<?php
class ModelCatalogProduction extends Model {
    public function getProduction($production_id) {
        $sql = "SELECT pd.*, pdesc.name AS product_name, p.code AS product_code FROM " . DB_PREFIX . "production pd LEFT JOIN " . DB_PREFIX . "product p ON pd.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_description pdesc ON pdesc.product_id = p.product_id AND pdesc.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE pd.production_id = '" . (int)$production_id . "'";
        
        $query = $this->db->query($sql);

        $production_row = $query->row;

        $production_stocks = $this->getProductionStocks($production_id);

        if (!empty($production_stocks)) {
            $production_row['production_stock'] = $production_stocks;

            foreach ($production_row['production_stock'] as $index => $stock) {
                $production_row['production_stock'][$index]['expected_quantity'] = $production_row['quantity'];
            }
        }

        return $production_row;
    }

    public function getProductionBySerialNum($serial_num, $production_id = false) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production WHERE serial_num = '" . $this->db->escape($serial_num) . "'";
        
        if ($production_id) {
            $sql .= " AND production_id != '" . (int)$production_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getProductionQc($production_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_qc WHERE production_id = '" . (int)$production_id . "' ORDER BY date_added DESC";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalRejectQty($production_id) {
        $sql = "SELECT SUM(reject_quantity) AS total_reject_quantity FROM " . DB_PREFIX . "production_qc WHERE production_id = '" . (int)$production_id . "'";
        
        $query = $this->db->query($sql);

        return $query->row['total_reject_quantity'];
    }

    public function getProductionStocks($production_id) {
        $sql = "SELECT ps.used_quantity, ps.quantity, ps.product_id, p.code AS product_code, pd.name AS product_name FROM " . DB_PREFIX . "production_stock ps LEFT JOIN " . DB_PREFIX . "product p ON p.product_id = ps.product_id LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = ps.product_id AND pd.language_id = '" . $this->config->get('config_language_id') . "' WHERE ps.production_id = '" . (int)$production_id . "' ORDER BY ps.production_stock_id DESC";
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductMaterials($product_id) {
        $sql = "SELECT pm.metarial_id, pd.name AS material_name, p.code AS product_code, pm.used_quantity FROM " . DB_PREFIX . "product_material pm LEFT JOIN " . DB_PREFIX . "product p ON p.product_id = pm.metarial_id LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = pm.metarial_id AND pd.language_id = '" . $this->config->get('config_language_id') . "' WHERE pm.product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductStock($product_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "' AND store_id = '" . $this->session->data['store_id'] . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getProductions($data) {
        $sql = "SELECT pd.*, pdesc.name AS product_name FROM " . DB_PREFIX . "production pd LEFT JOIN " . DB_PREFIX . "product p ON pd.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_description pdesc ON pdesc.product_id = p.product_id AND pdesc.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1";

        if (!empty($data['filter_production_date_from'])) {
            $sql .= " AND DATE(pd.production_date) >= DATE('" . $this->db->escape($data['filter_production_date_from']) . "')";
        }
        
        if (!empty($data['filter_production_date_to'])) {
            $sql .= " AND DATE(pd.production_date) <= DATE('" . $this->db->escape($data['filter_production_date_to']) . "')";
        }

        if (!empty($data['filter_expiry_date_from'])) {
            $sql .= " AND DATE(pd.expiry_date) >= DATE('" . $this->db->escape($data['filter_expiry_date_from']) ."')";
        }

        if (!empty($data['filter_expiry_date_to'])) {
            $sql .= " AND DATE(pd.expiry_date) <= DATE('" . $this->db->escape($data['filter_expiry_date_to']) . "')";
        }

        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND pd.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'";
        }

        if (!empty($data['filter_serial_num'])) {
            $sql .= " AND pd.serial_num LIKE '%" . $this->db->escape($data['filter_serial_num']) . "%'";
        }

        if (!empty($data['filter_product_name'])) {
            $sql .= " AND pdesc.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
        }

        if (!empty($data['filter_status'])) {
            $sql .= " AND pd.status = '" . (int)$data['filter_status'] . "'";
        }

        $sort_data = array(
            'pd.invoice_prefix',
            'pd.serial_num',
            'product_name',
			'pd.expiry_date',
			'pd.production_date',
			'pd.quantity',
			'pd.date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY pd.production_date";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
        }
        
        if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProductions($data) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "production pd LEFT JOIN " . DB_PREFIX . "product p ON pd.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_description pdesc ON pdesc.product_id = p.product_id AND pdesc.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE 1";

        if (!empty($data['filter_production_date_from'])) {
            $sql .= " AND DATE(production_date) >= DATE('" . $this->db->escape($data['filter_production_date_from']) . "')";
        }
        
        if (!empty($data['filter_production_date_to'])) {
            $sql .= " AND DATE(production_date) <= DATE('" . $this->db->escape($data['filter_production_date_to']) . "')";
        }

        if (!empty($data['filter_expiry_date_from'])) {
            $sql .= " AND DATE(expiry_date) >= DATE('" . $this->db->escape($data['filter_expiry_date_from']) ."')";
        }

        if (!empty($data['filter_expiry_date_to'])) {
            $sql .= " AND DATE(expiry_date) <= DATE('" . $this->db->escape($data['filter_expiry_date_to']) . "')";
        }

        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND pd.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'";
        }

        if (!empty($data['filter_serial_num'])) {
            $sql .= " AND serial_num LIKE '%" . $this->db->escape($data['filter_serial_num']) . "%'";
        }

        if (!empty($data['filter_product_name'])) {
            $sql .= " AND pdesc.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
        }
        
        if (!empty($data['filter_status'])) {
            $sql .= " AND pd.status = '" . (int)$data['filter_status'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function addProduction($data) {
        $production_id = 0;

        $sql = "INSERT INTO " . DB_PREFIX . "production SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', serial_num = '" . $this->db->escape($data['serial_num']) . "', production_date = '" . $this->db->escape($data['production_date']) . "', expiry_date = '" . $this->db->escape($data['expiry_date']) . "', serial_num_prefix = '" . $this->db->escape($data['serial_num_prefix']) . "', quantity = '" . (int)$data['quantity'] . "', actual_quantity = '" . (int)$data['actual_quantity'] . "', machine_num = '" . (int)$data['machine_num'] . "', round_num = '" . (int)$data['round_num'] . "', product_id = '" . (int)$data['product_id'] . "', remark = '" . $this->db->escape($data['remark']) . "', status = '" . (int)$data['status'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $production_id = $this->db->getLastId();

        if ($production_id > 0) {
            if (isset($this->request->post['production_stock'])) {
                foreach ($this->request->post['production_stock'] as $stock) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "production_stock SET production_id = '" . (int)$production_id . "', product_id = '" . (int)$stock['product_id'] . "', used_quantity = '" . $stock['used_quantity'] . "', quantity = '" . $stock['quantity'] . "'");
                }
            }

            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/production', 'store' => $this->session->data['store_id']));
        }

        return $production_id;
    }

    public function editProduction($data, $production_id) {
        $sql = "UPDATE " . DB_PREFIX . "production SET invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', serial_num = '" . $this->db->escape($data['serial_num']) . "', production_date = '" . $this->db->escape($data['production_date']) . "', expiry_date = '" . $this->db->escape($data['expiry_date']) . "', serial_num_prefix = '" . $this->db->escape($data['serial_num_prefix']) . "', quantity = '" . (int)$data['quantity'] . "', actual_quantity = '" . (int)$data['actual_quantity'] . "', machine_num = '" . (int)$data['machine_num'] . "', round_num = '" . (int)$data['round_num'] . "', product_id = '" . (int)$data['product_id'] . "', remark = '" . $this->db->escape($data['remark']) . "', status = '" . (int)$data['status'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE production_id = '" . (int)$production_id . "'";

        $query = $this->db->query($sql);

        $this->db->query("DELETE FROM " . DB_PREFIX . "production_stock WHERE production_id = '" . (int)$production_id . "'");

        if (isset($this->request->post['production_stock'])) {
            foreach ($this->request->post['production_stock'] as $stock) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "production_stock SET production_id = '" . (int)$production_id . "', product_id = '" . (int)$stock['product_id'] . "', used_quantity = '" . $stock['used_quantity'] . "', quantity = '" . $stock['quantity'] . "'");
            }
        }
    }

    public function deductProductionStock($production_id, $production_stock) {
        if (!empty($production_stock)) {
            foreach ($production_stock as $stock) {
                $quantity = $stock['quantity'];

                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity - $quantity WHERE store_id = '" . $this->session->data['store_id'] . "' AND product_id = '" . (int)$stock['product_id'] . "'");
            }
        }
    }

    public function addProductionStock($production_id, $data) {
        $total_reject_quantity = $this->getTotalRejectQty($production_id);

        $total_quantity_left = $data['actual_quantity'] - $total_reject_quantity;

        $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity + $total_quantity_left WHERE store_id = '" . $this->session->data['store_id'] . "' AND product_id = '" . (int)$data['product_id'] . "'");
    }

    public function addQualityControl($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "production_qc SET production_id = '" . (int)$data['production_id'] . "', reason_reject = '" . $this->db->escape($data['reason_reject']) . "', reject_quantity = '" . (int)$data['reject_quantity'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function getProductionMachines() {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_machine WHERE status = '1' ORDER BY date_added ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductionMachine($production_machine_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_machine WHERE production_machine_id = '" . (int)$production_machine_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
}
?>