<?php
class ModelCatalogProductSellEtcm extends Model{
    public function getProducts($data){
        $sql = "SELECT p.product_id, pd.name, p.code, p.price, pse.status, pse.publish_status, pwe.status AS wholesale_status, pwe.publish_status AS wholesale_publish_status, pwe.price AS wholesale_price, pwe.quantity AS onhand_quantity, pwe.special_price_switch, pwe.special_price
                FROM " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON pd.product_id = p.product_id
                AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'
                LEFT JOIN " . DB_PREFIX . "product_sell_etcm pse
                ON pse.product_id = p.product_id
                LEFT JOIN " . DB_PREFIX . "product_wholesale_etcm pwe
                ON pwe.product_id = p.product_id
                WHERE 1";

        if (!empty($data['filter_product_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
		}

        if (!empty($data['filter_product_code'])) {
			$sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
		}

        if (isset($data['filter_product_price']) && !is_null($data['filter_product_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_product_price']) . "%'";
		}

        if (isset($data['filter_product_wholesale_price']) && !is_null($data['filter_product_wholesale_price'])) {
			$sql .= " AND pwe.price LIKE '" . $this->db->escape($data['filter_product_wholesale_price']) . "%'";
		}

        if (isset($data['filter_product_quantity']) && !is_null($data['filter_product_quantity'])) {
            $sql .= " AND pwe.quantity = '" . (int)$data['filter_product_quantity'] . "'";
        }

        if(isset($data['filter_product_status'])){
            if($data['filter_product_status'] == '3'){
                $sql .= " AND pse.status IS NULL";
            } else{
                $sql .= " AND pse.status = '" . (int)$data['filter_product_status'] . "'";
            }
        }

        if(isset($data['filter_product_wholesale_status'])){
            if($data['filter_product_wholesale_status'] == '3'){
                $sql .= " AND pwe.status IS NULL";
            } else{
                $sql .= " AND pwe.status = '" . (int)$data['filter_product_wholesale_status'] . "'";
            }
        }

        if(isset($data['filter_publish_status'])){
            if($data['filter_publish_status'] == '-'){
                $sql .= " AND pse.publish_status IS NULL";
            } else{
                $sql .= " AND pse.publish_status = '" . (int)$data['filter_publish_status'] . "'";
            }
        }

        if(isset($data['filter_publish_wholesale_status'])){
            if($data['filter_publish_wholesale_status'] == '-'){
                $sql .= " AND pwe.publish_status IS NULL";
            } else{
                $sql .= " AND pwe.publish_status = '" . (int)$data['filter_publish_wholesale_status'] . "'";
            }
        }

        $sort_data = array(
			'pd.name',
			'p.price',
			'pwe.quantity',
            'pwe.price'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY p.product_id";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

        if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProducts($data){
        $sql = "SELECT COUNT(*) AS total
                FROM " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON pd.product_id = p.product_id
                AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' 
                LEFT JOIN " . DB_PREFIX . "product_sell_etcm pse
                ON pse.product_id = p.product_id
                LEFT JOIN " . DB_PREFIX . "product_wholesale_etcm pwe
                ON pwe.product_id = p.product_id
                WHERE 1";

        if (!empty($data['filter_product_name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'";
		}

        if (!empty($data['filter_product_code'])) {
			$sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'";
		}

        if (isset($data['filter_product_price']) && !is_null($data['filter_product_price'])) {
			$sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_product_price']) . "%'";
		}

        if (isset($data['filter_product_wholesale_price']) && !is_null($data['filter_product_wholesale_price'])) {
			$sql .= " AND pwe.price LIKE '" . $this->db->escape($data['filter_product_wholesale_price']) . "%'";
		}

        if (isset($data['filter_product_quantity']) && !is_null($data['filter_product_quantity'])) {
            $sql .= " AND pwe.quantity = '" . (int)$data['filter_product_quantity'] . "'";
        }

        if(isset($data['filter_product_status'])){
            if($data['filter_product_status'] == '3'){
                $sql .= " AND pse.status IS NULL";
            } else{
                $sql .= " AND pse.status = '" . (int)$data['filter_product_status'] . "'";
            }
        }

        if(isset($data['filter_product_wholesale_status'])){
            if($data['filter_product_wholesale_status'] == '3'){
                $sql .= " AND pwe.status IS NULL";
            } else{
                $sql .= " AND pwe.status = '" . (int)$data['filter_product_wholesale_status'] . "'";
            }
        }

        if(isset($data['filter_publish_status'])){
            if($data['filter_publish_status'] == '-'){
                $sql .= " AND pse.publish_status IS NULL";
            } else{
                $sql .= " AND pse.publish_status = '" . (int)$data['filter_publish_status'] . "'";
            }
        }

        if(isset($data['filter_publish_wholesale_status'])){
            if($data['filter_publish_wholesale_status'] == '-'){
                $sql .= " AND pwe.publish_status IS NULL";
            } else{
                $sql .= " AND pwe.publish_status = '" . (int)$data['filter_publish_wholesale_status'] . "'";
            }
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getSellEtcmProduct($product_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "product_sell_etcm WHERE product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getWholesaleEtcmProduct($product_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "product_wholesale_etcm WHERE product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getProductByProductId($product_id){
        $sql = "SELECT p.product_id,
                       pd.name,
                       pd.description,
                       p.code,
                       p.price,
                       pts.onhand_quantity AS onhand_quantity,
                       pwe.quantity AS onhand_quantity_wholesale,
                       pse.date_added,
                       pse.status,
                       pwe.status AS wholesale_status,
                       pse.etcm_category_id,
                       pwe.etcm_category_id AS wholesale_etcm_category_id,
                       pwe.weight_class_id AS wholesale_weight_class_id,
                       pwe.date_added AS wholesale_date_added,
                       pwe.price AS wholesale_price,
                       pwe.special_price_switch,
                       pwe.special_price,
                       pwe.special_date_end,
                       pwe.special_date_start
                FROM " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON pd.product_id = p.product_id
                AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'
                LEFT JOIN " . DB_PREFIX . "product_to_store pts
                ON pts.product_id = p.product_id
                AND pts.store_id = '" . (int)$this->config->get('config_store_id') . "'
                LEFT JOIN " . DB_PREFIX . "product_sell_etcm pse
                ON pse.product_id = p.product_id
                LEFT JOIN " . DB_PREFIX . "product_wholesale_etcm pwe
                ON pwe.product_id = p.product_id
                WHERE p.product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function addProductSellEtcm($data, $product_id){
        $sql = "INSERT INTO " . DB_PREFIX . "product_sell_etcm
                SET product_id = '" . (int)$product_id . "',
                    etcm_category_id = '" . (int)$data['etcm_category_id'] . "',
                    status = '0',
                    publish_status = '1',
                    date_added = NOW(),
                    add_by = '" . $this->session->data['user_id'] . "',
                    date_modified = NOW(),
                    modify_by = '" . $this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);
    }

    public function addProductWholesaleEtcm($data, $product_id){
        if($data['enable_special_price'] == '1'){
            $sql = "INSERT INTO " . DB_PREFIX . "product_wholesale_etcm
                    SET product_id = '" . (int)$product_id . "',
                        etcm_category_id = '" . (int)$data['etcm_category_id'] . "',
                        weight_class_id = '" . (int)$data['weight_class_id'] . "',
                        quantity = '" . $data['wholesale_quantity'] . "',
                        price = '" . $data['wholesale_price'] . "',
                        special_price_switch = '" . (int)$data['enable_special_price'] . "',
                        special_price = '" . $data['special_wholesale_price'] . "',
                        special_date_start = '" . $this->db->escape($data['date_start']) . "',
                        special_date_end = '" . $this->db->escape($data['date_end']) . "',
                        status = '0',
                        publish_status = '1',
                        date_added = NOW(),
                        add_by = '" . (int)$this->session->data['user_id'] . "',
                        date_modified = NOW(),
                        modify_by = '" . (int)$this->session->data['user_id'] . "'";
        } else{
            $sql = "INSERT INTO " . DB_PREFIX . "product_wholesale_etcm
                    SET product_id = '" . (int)$product_id . "',
                        etcm_category_id = '" . (int)$data['etcm_category_id'] . "',
                        weight_class_id = '" . (int)$data['weight_class_id'] . "',
                        quantity = '" . $data['wholesale_quantity'] . "',
                        price = '" . $data['wholesale_price'] . "',
                        special_price_switch = '" . (int)$data['enable_special_price'] . "',
                        status = '0',
                        publish_status = '1',
                        date_added = NOW(),
                        add_by = '" . (int)$this->session->data['user_id'] . "',
                        date_modified = NOW(),
                        modify_by = '" . (int)$this->session->data['user_id'] . "'";
        }

        $query = $this->db->query($sql);

        $product_wholesale_etcm_id = $this->db->getLastId();

		foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("UPDATE " . DB_PREFIX . "product_description SET description = '" . $this->db->escape($value['description']) . "' WHERE product_id = '" . (int)$product_id . "' AND language_id = '" . (int)$language_id . "'");
		}

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");

        if (isset($data['product_image'])) {
            foreach ($data['product_image'] as $product_image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
            }
        }

        return $product_wholesale_etcm_id;
    }

    // add the wholesale quantity and date available from product form
    public function addWholesaleInfo($data, $product_id){
        $sql = "INSERT INTO " . DB_PREFIX . "product_wholesale_etcm
                SET product_id = '" . (int)$product_id . "',
                    quantity = '" . (int)$data['wholesale_quantity'] . "',
                    date_available = '" . $this->db->escape($data['wholesale_date_available']) . "',
                    date_added = NOW(),
                    add_by = '" . (int)$this->session->data['user_id'] . "',
                    date_modified = NOW(),
                    modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function addPriceLog($data, $product_wholesale_etcm_id){
        if($data['enable_special_price'] == '1'){
            $sql = "INSERT INTO " . DB_PREFIX . "product_wholesale_etcm_price_log
                    SET product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "',
                        weight_class_id = '" . (int)$data['weight_class_id'] . "',
                        quantity = '" . $data['wholesale_quantity'] . "',
                        price = '" . $data['wholesale_price'] . "',
                        special_price_switch = '" . (int)$data['enable_special_price'] . "',
                        special_price = '" . $data['special_wholesale_price'] . "',
                        special_date_start = '" . $this->db->escape($data['date_start']) . "',
                        special_date_end = '" . $this->db->escape($data['date_end']) . "',
                        add_by = '" . (int)$this->session->data['user_id'] . "',
                        date_added = NOW()";
        } else{
            $sql = "INSERT INTO " . DB_PREFIX . "product_wholesale_etcm_price_log
                    SET product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "',
                        weight_class_id = '" . (int)$data['weight_class_id'] . "',
                        quantity = '" . $data['wholesale_quantity'] . "',
                        price = '" . $data['wholesale_price'] . "',
                        special_price_switch = '" . (int)$data['enable_special_price'] . "',
                        add_by = '" . (int)$this->session->data['user_id'] . "',
                        date_added = NOW()";
        }

        $query = $this->db->query($sql);
    }

    public function getAutoCompleteProducts($data){
        $sql = "SELECT p.product_id, pd.name, p.code
                FROM " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON pd.product_id = p.product_id
                AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'
                WHERE 1";

        if(!empty($data['filter_name'])){
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if(!empty($data['filter_code'])){
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateEtcmCategory($etcm_category_id, $product_sell_etcm_id){
        $sql = "UPDATE " . DB_PREFIX . "product_sell_etcm
                SET etcm_category_id = '" . (int)$etcm_category_id . "',
                    date_modified = NOW(),
                    modify_by = '" . $this->session->data['user_id'] . "'
                WHERE product_sell_etcm_id = '" . (int)$product_sell_etcm_id . "'";

        $query = $this->db->query($sql);
    }

    public function updateWholesaleProduct($data, $product_wholesale_etcm_id, $product_id){
        if($data['enable_special_price'] == '1'){
            $this->db->query("UPDATE " . DB_PREFIX . "product_wholesale_etcm
                              SET etcm_category_id = '" . (int)$data['etcm_category_id'] . "',
                                  weight_class_id = '" . (int)$data['weight_class_id'] . "',
                                  quantity = '" . $data['wholesale_quantity'] . "',
                                  price = '" . $data['wholesale_price'] . "',
                                  special_price_switch = '" . (int)$data['enable_special_price'] . "',
                                  special_price = '" . $data['special_wholesale_price'] . "',
                                  special_date_start = '" . $this->db->escape($data['date_start']) . "',
                                  special_date_end = '" . $this->db->escape($data['date_end']) . "',
                                  date_modified = NOW(),
                                  modify_by = '" . (int)$this->session->data['user_id'] . "'
                              WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "'");
        } else{
            $this->db->query("UPDATE " . DB_PREFIX . "product_wholesale_etcm
                              SET etcm_category_id = '" . (int)$data['etcm_category_id'] . "',
                                  weight_class_id = '" . (int)$data['weight_class_id'] . "',
                                  quantity = '" . $data['wholesale_quantity'] . "',
                                  price = '" . $data['wholesale_price'] . "',
                                  special_price_switch = '" . (int)$data['enable_special_price'] . "',
                                  date_modified = NOW(),
                                  modify_by = '" . (int)$this->session->data['user_id'] . "'
                              WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "'");
        }

        foreach ($data['product_description'] as $language_id => $value) {
			$this->db->query("UPDATE " . DB_PREFIX . "product_description SET description = '" . $this->db->escape($value['description']) . "' WHERE product_id = '" . (int)$product_id . "' AND language_id = '" . (int)$language_id . "'");
		}

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "'");

        if (isset($data['product_image'])) {
            foreach ($data['product_image'] as $product_image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int)$product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int)$product_image['sort_order'] . "'");
            }
        }
    }

    // change the wholesale product status to pending and publish status to enabled
    public function updateWholesaleProductStatus($product_wholesale_etcm_id){
        $this->db->query("UPDATE " . DB_PREFIX . "product_wholesale_etcm SET status = '0', publish_status = '1', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "'");
    }

    // Update the wholesale quantity and date available from product form
    public function updateWholesaleInfo($data, $product_wholesale_etcm_id){
        $this->db->query("UPDATE " . DB_PREFIX . "product_wholesale_etcm SET quantity = '" . (int)$data['wholesale_quantity'] . "', date_available = '" . $this->db->escape($data['wholesale_date_available']) . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "'");
    }

    public function getStatusHistory($product_sell_etcm_id){
        $sql = "SELECT *
                FROM " . DB_PREFIX . "product_sell_etcm_status_history
                WHERE product_sell_etcm_id = '" . (int)$product_sell_etcm_id . "'
                ORDER BY etcm_status_history_id ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getWholesaleStatusHistory($product_wholesale_etcm_id){
        $sql = "SELECT *
                FROM " . DB_PREFIX . "product_wholesale_etcm_status_history
                WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "'
                ORDER BY wholesale_status_history_id ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updatePublishStatus($publish_status_id, $product_id){
        $sql = "UPDATE " . DB_PREFIX . "product_sell_etcm
                SET publish_status = '" . (int)$publish_status_id . "',
                    status = '0',
                    date_modified = NOW(),
                    modify_by = '" . $this->session->data['user_id'] . "'
                WHERE product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);
    }

    public function updatePublishWholesaleStatus($publish_status_id, $product_id){
        $sql = "UPDATE " . DB_PREFIX . "product_wholesale_etcm
                SET publish_status = '" . (int)$publish_status_id . "',
                    status = '0',
                    date_modified = NOW(),
                    modify_by = '" . $this->session->data['user_id'] . "'
                WHERE product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);
    }

    public function getPriceLog($product_wholesale_etcm_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "product_wholesale_etcm_price_log WHERE product_wholesale_etcm_id = '" . (int)$product_wholesale_etcm_id . "' ORDER BY date_added DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductDescriptions($product_id){
        $product_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$product_id . "'");

		foreach ($query->rows as $result) {
			$product_description_data[$result['language_id']] = array(
				'description'      => $result['description']
			);
		}

		return $product_description_data;
    }

    public function getProductImages($product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int)$product_id . "' ORDER BY sort_order ASC");

		return $query->rows;
	}
}
?>