<?php

class ModelCatalogProduct extends Model
{
      public function get_product_by_product_id($product_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "product WHERE product_id = '" . $this->db->escape($product_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    
     public function getWeightClassByUnit($unit) {
        $sql = "SELECT *, wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id WHERE wcd.unit = '" . $this->db->escape($unit) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

   public function getCategory($name) {
        $sql = "SELECT * FROM " . DB_PREFIX . "category_description WHERE name = '" . $this->db->escape($name) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    
      public function addProductbyImport($data) {

        $this->db->query("INSERT INTO " . DB_PREFIX . "product SET model = '" . $this->db->escape($data['model']) . "',
                            code = '" . $this->db->escape($data['code']) . "', subtract = '1',
                            date_available = NOW(), price = '" . (float) $data['sellingprice'] . "',
                            costprice = '" . (float) $data['costprice'] . "',
                            product_type = '1', weight = '" . (float) $data['weight'] . "',
                            weight_class_id = '" . $this->db->escape($data['weight_class_id']) . "',
                            status = '1', 
                            internal_status = '1', 
                            tax_class_id = '11', 
                            add_by = '" . (int) $this->session->data['user_id'] . "',
                            date_added = NOW()");

        $product_id = $this->db->getLastId();

        $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '1', name = '" . $this->db->escape($data['en_product_name']) . "', description = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword = '" . $this->db->escape($data['model']) . "'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '2', name = '" . $this->db->escape($data['cn_product_name']) . "', description = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword = '" . $this->db->escape($data['model']) . "'");

        $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $this->session->data['store_id'] . "', onhand_quantity = '" . $this->db->escape($data['onhand_quantity']) . "', product_lastmodifiedby = '" . (int) $this->session->data['user_id'] . "', product_lastmodifieddate = NOW()");

        $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int) $product_id . "', category_id =  '" . (int) $data['category_id'] . "'");
        return $product_id;
    }
    
    
    public function addProductbyImporttoAdjustment($data) {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];

        $user_id = $this->session->data['user_id'];

        $this->db->query("
                INSERT INTO " . DB_PREFIX . "stock_adjustment SET
                invoice_prefix = '" . $invoice_prefix . "',
                store_id = '" . $store_id . "',
                description = 'Import By Excel', 
                status = 5, 
                add_by = '" . $user_id . "',
                date_added = NOW()");

        $stock_adjustment_id = $this->db->getLastId();

        if ($stock_adjustment_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));

            if (!empty($data)) {
                foreach ($data as $item) {
                    $this->db->query("
                        INSERT INTO " . DB_PREFIX . "stock_adjustment_item SET
                        stock_adjustment_id = " . (int) $stock_adjustment_id . ",
                        product_id = '" . $this->db->escape($item['product_id']) . "',
                        action = '1', 
                        qty = '" . $this->db->escape($item['stock']) . "',
                        add_by = '" . $user_id . "',
                        date_added = NOW()");
                }
            }
        }
        return $stock_adjustment_id;
    }
    
    public function updateImportedProduct($data, $product_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "product SET 
        
			model = '" . $this->db->escape($data['model']) . "', 
			code = '" . $this->db->escape($data['code']) . "', 
            quantity = quantity +'" . (float) $this->db->escape($data['onhand_quantity']) . "',    
			price = '" . (float) $data['sellingprice'] . "',
            costprice = '" . (float) $data['costprice'] . "',  
			weight = '" . (float) $data['weight'] . "', 
			weight_class_id = '" . (int) $data['weight_class_id'] . "', 
			modify_by = '" . (int) $this->session->data['user_id'] . "', 
			date_modified = NOW() 
                        WHERE product_id = '" . (int) $product_id . "'");

    if ($this->config->get('config_language_id') == 1) {
        $this->db->query("UPDATE " . DB_PREFIX . "product_description SET name = '" . $this->db->escape($data['en_product_name']) . "' WHERE product_id = '" . (int) $product_id . "' AND language_id = '1'");
    } else {
        // otherwise, update the cn_product_name field
        $this->db->query("UPDATE " . DB_PREFIX . "product_description SET name = '" . $this->db->escape($data['cn_product_name']) . "' WHERE product_id = '" . (int) $product_id . "' AND language_id = '2'");
    }
    
        $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity +'" . (float) $this->db->escape($data['onhand_quantity']) . "' WHERE 1 AND product_id = '" . (int) $product_id . "'");
    }
    
    
    public function getImportProduct()
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` WHERE 1 ");
        return $query->rows;
    }

    public function updateProductStock($product_id, $qty)
    {
        $query = $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = onhand_quantity +'" . (float) $qty . "' WHERE 1 AND product_id = '" . (int) $product_id . "'");
    }

    public function getStockAdjustment()
    {
        $query = $this->db->query("SELECT sa.stock_adjustment_id, sa.invoice_prefix, sai.product_id, sai.qty, sai.action FROM `" . DB_PREFIX . "stock_adjustment` sa LEFT JOIN `" . DB_PREFIX . "stock_adjustment_item` sai ON sa.stock_adjustment_id = sai.stock_adjustment_id WHERE 1 AND sa.stock_adjustment_id = '5'");
        return $query->rows;
    }

    public function updateProductAdjustment($stock_adjustment_id, $product_id, $qty)
    {
        $query = $this->db->query("UPDATE `" . DB_PREFIX . "stock_adjustment_item` SET qty = '" . (float) $qty . "' WHERE 1 AND product_id = '" . (int) $product_id . "' AND stock_adjustment_id = '" . (int) $stock_adjustment_id . "'");
    }

    /*
      public function getImportUpdateProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` ip WHERE 1");
      return $query->rows;
      }

      public function updateImportUpdateProductStock($product) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` pts SET pts.onhand_quantity = '" . (float)$product['stock'] . "' WHERE pts.product_id = '" . (int)$product['product_id'] . "' AND pts.store_id = '0'");
      }

      public function updateImportUpdateProductStatus($product) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.status = '" . (int)$product['new_status'] . "' WHERE p.product_id = '" . (int)$product['product_id'] . "'");
      }


      public function getAllProducts() {
      $query = $this->db->query("SELECT p.product_id, p.code, p.model, p.price, p.internal_status FROM `" . DB_PREFIX . "product` p WHERE 1");
      return $query->rows;
      }

      public function disableProduct($data) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.internal_status = '0' WHERE p.product_id = '" . (int)$data['product_id'] . "' AND p.code = '" . $this->db->escape($data['code']) . "'");
      }


      public function getImportProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` WHERE 1 ");
      return $query->rows;
      }

      public function checkProductExist($data){
      $query = $this->db->query("SELECT p.product_id, p.code, p.model, p.price FROM`" . DB_PREFIX . "product` p WHERE 1 AND p.code = '" . $this->db->escape($data['code']) . "'");
      return $query->row;
      }

      public function updateProductPrice($data) {
      $query = $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.price = '" . $data['price'] . "' WHERE 1 AND p.code = '" . $this->db->escape($data['code']) . "'");
      }

      public function insertImportProduct($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product` SET model = '" . $this->db->escape($data['model']) . "', code = '" . $this->db->escape($data['code']) . "', weight = '1', weight_class_id = '1', price = '" . (float)$data['price'] . "', tax_class_id = '13', internal_status  = '1', product_type = '2', add_by = '139', date_added = NOW()") ;
      $product_id = $this->db->getLastId();
      return $product_id ;
      }

      public function AddNewProductChineseDescription($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$data['new_product_id'] . "' , name = '" . $this->db->escape($data['model']) . "', language_id = '2', description = '" . $this->db->escape($data['model']). "', tag = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword='" . $this->db->escape($data['model']) . "'");
      }

      public function AddNewProductEnglishDescription($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$data['new_product_id'] . "' , name = '" . $this->db->escape($data['model']) . "', language_id = '1', description = '" . $this->db->escape($data['model']). "', tag = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword='" . $this->db->escape($data['model']) . "'");
      } */


    /*

      public function getImportProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` WHERE 1 ");
      return $query->rows;
      }

      public function checkProductExist($data){
      $query = $this->db->query("SELECT p.product_id FROM`" . DB_PREFIX . "product` p WHERE 1 AND p.product_id = '" . (int)$data['product_id'] . "' AND p.code = '" . $this->db->escape($data['code']) . "'");
      return $query->rows;
      }

      public function DisableProduct($data) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` SET internal_status = '0' WHERE 1 AND product_id = '" . (int)$data['product_id'] . "'");
      }


      public function getImportProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` WHERE 1 ");
      return $query->rows;
      }

      public function AddWholeSaleDiscountPrice($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_discount` SET product_id = '" . (int)$data['new_product_id'] . "', customer_group_id = '4', quantity = '1000', priority = '1', price = '" . (float)$data['wholesale'] . "',  date_start = NOW(), date_end = '2018-12-31'");
      }

      public function AddBrewingDiscountPrice($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_discount` SET product_id = '" . (int)$data['new_product_id'] . "', customer_group_id = '3', quantity = '1', priority = '1', price = '" . (float)$data['brewing'] . "',  date_start = NOW(), date_end = '2018-12-31'");
      }

      public function EnableProduct($data) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` SET internal_status = '1' WHERE 1 AND product_id = '" . (int)$data['product_id'] . "'");
      }

      public function AddNewProduct($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product` SET code = '" . $this->db->escape($data['code']) . "', model = '" . $this->db->escape($data['model']) . "', internal_status = '1'");
      $product_id = $this->db->getLastId();
      return $product_id;
      }

      public function getNewProductID($code){
      $query = $this->db->query("SELECT p.product_id AS product_id FROM `" . DB_PREFIX . "product` p WHERE p.code = '" . $this->db->escape($code) . "'");
      return $query->row['product_id'];
      }

      public function AddNewProductChineseDescription($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$data['new_product_id'] . "' , name = '" . $this->db->escape($data['model']) . "', language_id = '2', description = '" . $this->db->escape($data['model']). "', tag = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword='" . $this->db->escape($data['model']) . "'");
      }

      public function AddNewProductEnglishDescription($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$data['new_product_id'] . "' , name = '" . $this->db->escape($data['model']) . "', language_id = '1', description = '" . $this->db->escape($data['model']). "', tag = '" . $this->db->escape($data['model']) . "', meta_title = '" . $this->db->escape($data['model']) . "', meta_description = '" . $this->db->escape($data['model']) . "', meta_keyword='" . $this->db->escape($data['model']) . "'");
      } */

    /* public function getImportProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` WHERE 1 AND product_id <>''");
      return $query->rows;
      }

      public function AddWholeSaleDiscountPrice($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_discount` SET product_id = '" . (int)$data['product_id'] . "', customer_group_id = '4', quantity = '1000', priority = '1', price = '" . (float)$data['wholesale'] . "',  date_start = NOW(), date_end = '2018-12-31'");
      }

      public function AddBrewingDiscountPrice($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_discount` SET product_id = '" . (int)$data['product_id'] . "', customer_group_id = '3', quantity = '1', priority = '1', price = '" . (float)$data['brewing'] . "',  date_start = NOW(), date_end = '2018-12-31'");
      }

      public function DisableProduct($data) {
      //$this->db->query("UPDATE `" . DB_PREFIX . "product` SET internal_status = '0' WHERE 1 AND product_id = '" . (int)$data['product_id'] . "'");

      $this->db->query("DELETE FROM`" . DB_PREFIX . "product_discount` WHERE 1 AND product_id = '" . (int)$data['product_id'] . "' AND date_start = '2018-01-30' AND date_end = '2018-12-31'");
      } */


    /*
      public function getImportUpdateProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` ip WHERE 1");
      return $query->rows;
      }

      public function updateImportUpdateProductCode($product_id, $code) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.code = '" . $this->db->escape($code) . "' WHERE p.product_id = '" . (int)$product_id . "'");
      }

      public function updateImportUpdateProductDelete($product_id) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.status = '0' WHERE p.product_id = '" . (int)$product_id . "'");
      }

      public function updateImportUpdateProductStock($product_id, $stock) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` pts SET pts.onhand_quantity = '" . (float)$stock . "' WHERE pts.product_id = '" . (int)$product_id . "' AND pts.store_id = '0'");
      }

      public function updateImportUpdateProductUOM($product_id, $uom) {
      $this->db->query("UPDATE `" . DB_PREFIX . "product` p SET p.weight_class_id = '" . (int)$uom . "' WHERE p.product_id = '" . (int)$product_id . "'");
      }

      public function getImportDistinctPrescription() {
      $query = $this->db->query("SELECT DISTINCT ip.code, ip.name FROM `" . DB_PREFIX . "import_prescription` ip WHERE 1");
      return $query->rows;
      }

      public function getImportPrescriptionByCode($code) {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_prescription` ip WHERE 1 AND ip.code = '" . $this->db->escape($code) . "'");
      return $query->rows;
      }

      public function getImportPrescriptionItemByCode($code) {
      $query = $this->db->query("SELECT p.product_id AS product_id FROM `" . DB_PREFIX . "product` p WHERE 1 AND p.code = '" . $this->db->escape($code) . "' AND p.internal_status = '1'");
      return $query->row['product_id'];
      }

      public function insertImportPrescription($code) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "prescription` SET code = '" . $this->db->escape($code) . "', status = '1', sort_order = '1', add_by = '139', date_added = NOW()");
      $prescription_id = $this->db->getLastId();
      return $prescription_id;
      }

      public function insertImportPrescriptionNameLang1($prescription_id,$prescription_name) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "prescription_name` SET prescription_id = '" . (int)$prescription_id . "', name = '" . $this->db->escape($prescription_name) . "', language_id = '1'");
      $prescription_name_lang1 = $this->db->getLastId();
      return $prescription_name_lang1;
      }

      public function insertImportPrescriptionNameLang2($prescription_id,$prescription_name) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "prescription_name` SET prescription_id = '" . (int)$prescription_id . "', name = '" . $this->db->escape($prescription_name) . "', language_id = '2'");
      $prescription_name_lang2 = $this->db->getLastId();
      return $prescription_name_lang2;
      }

      public function insertImportPrescriptionItem($prescription_id,$product_id,$quantity) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "prescription_item` SET prescription_id = '" . (int)$prescription_id . "', product_id = '" . (int)$product_id. "', used_qty = '" . (int)$quantity . "', display_order = '1', add_by = '139', date_added = NOW()");
      }

      public function getImportMaterial() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_material` im WHERE 1");
      return $query->rows;
      }

      public function insertImportMaterial($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product` SET model = '" . $this->db->escape($data['product_name']) . "', code = '" . $this->db->escape($data['code']) . "', weight = '1', weight_class_id = '" . (int)$data['weight_class_id'] . "', tax_class_id = '13', internal_status  = '1', product_type = '2', add_by = '139', date_added() = NOW()") ;
      $product_id = $this->db->getLastId();
      return $product_id ;
      }

      public function insertImportMaterialDescription($product_id, $product_name) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$product_id . "' , name = '" . $this->db->escape($product_name) . "', language_id = '2', description = '" . $this->db->escape($product_name). "', tag = '" . $this->db->escape($product_name) . "', meta_title = '" . $this->db->escape($product_name) . "', meta_description = '" . $this->db->escape($product_name) . "', meta_keyword='" . $this->db->escape($product_name) . "'");
      }

      public function getImportProduct() {
      $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "import_product` im WHERE 1");
      return $query->rows;
      }

      public function insertImportProduct($data) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product` SET model = '" . $this->db->escape($data['product_name']) . "', code = '" . $this->db->escape($data['code']) . "', weight = '1', weight_class_id = '" . (int)$data['weight_class_id'] . "', price = '" . (float)$data['price'] . "', tax_class_id = '13', internal_status  = '1', product_type = '1', add_by = '139', date_added = NOW()") ;
      $product_id = $this->db->getLastId();
      return $product_id ;
      }

      public function insertImportProductDescription($product_id, $product_name) {
      $this->db->query("INSERT INTO `" . DB_PREFIX . "product_description` SET product_id = '" . (int)$product_id . "' , name = '" . $this->db->escape($product_name) . "', language_id = '2', description = '" . $this->db->escape($product_name). "', tag = '" . $this->db->escape($product_name) . "', meta_title = '" . $this->db->escape($product_name) . "', meta_description = '" . $this->db->escape($product_name) . "', meta_keyword='" . $this->db->escape($product_name) . "'");
      } */

    public function addProduct($data)
    {

        $this->db->query("INSERT INTO " . DB_PREFIX . "product SET model = '" . $this->db->escape($data['model']) . "', code = '" . $this->db->escape($data['code']) . "', pinyin = '" . $this->db->escape($data['pinyin']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '" . (int) $data['quantity'] . "', minimum = '" . (int) $data['minimum'] . "', subtract = '" . (int) $data['subtract'] . "', stock_status_id = '" . (int) $data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', manufacturer_id = '" . (int) $data['manufacturer_id'] . "', shipping = '" . (int) $data['shipping'] . "', price = '" . (float) $data['sellingprice'] . "', costprice = '" . (float) $data['costprice'] . "', selling_product = '" . (int) $data['selling_product'] . "', product_type = '" . (int) $data['product_type'] . "', points = '" . (int) $data['points'] . "', weight = '" . (float) $data['weight'] . "', weight_class_id = '" . (int) $data['weight_class_id'] . "', length = '" . (float) $data['length'] . "', width = '" . (float) $data['width'] . "', height = '" . (float) $data['height'] . "', length_class_id = '" . (int) $data['length_class_id'] . "', status = '" . (int) $data['status'] . "', internal_status = '" . (int) $data['internal_status'] . "', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int) $data['sort_order'] . "', english_name = '" . $this->db->escape($data['herbs_name']) . "', product_category = '" . $this->db->escape($data['category']) . "', other_name = '" . $this->db->escape($data['other_name']) . "', taste = '" . $this->db->escape($data['taste']) . "', meridian = '" . $this->db->escape($data['meridian']) . "', effect = '" . $this->db->escape($data['effect']) . "', indications = '" . $this->db->escape($data['indications']) . "', product_usage = '" . $this->db->escape($data['usage']) . "', precautions = '" . $this->db->escape($data['precautions']) . "', processing = '" . $this->db->escape($data['processing']) . "', add_by = '" . (int) $this->session->data['user_id'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW()");

        $product_id = $this->db->getLastId();


        //default location
        if (isset($data['default_location'])) {
            foreach ($data['default_location'] as $store_id => $location_id) {
                if ($location_id != '0') {
                    $location_text = $this->getLocationText($location_id);
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_location SET 
                    product_id = '" . (int)$product_id . "',
                    store_id = '" . (int)$store_id . "',
                    location_id = '" . (int) $location_id . "',
                    location = '" . $this->db->escape($location_text) . "'");
                }
            }
        }

        if (isset($data['image'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape($data['image']) . "' WHERE product_id = '" . (int) $product_id . "'");
        }

        foreach ($data['product_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");
        }

        if (isset($data['product_store'])) {
            foreach ($data['product_store'] as $store_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "'");
            }
        }

        if (isset($data['product_attribute'])) {
            foreach ($data['product_attribute'] as $product_attribute) {
                if ($product_attribute['attribute_id']) {
                    $this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "' AND attribute_id = '" . (int) $product_attribute['attribute_id'] . "'");

                    foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int) $product_id . "', attribute_id = '" . (int) $product_attribute['attribute_id'] . "', language_id = '" . (int) $language_id . "', text = '" . $this->db->escape($product_attribute_description['text']) . "'");
                    }
                }
            }
        }

        if (isset($data['product_option'])) {
            foreach ($data['product_option'] as $product_option) {
                if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
                    if (isset($product_option['product_option_value'])) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', required = '" . (int) $product_option['required'] . "'");

                        $product_option_id = $this->db->getLastId();

                        foreach ($product_option['product_option_value'] as $product_option_value) {
                            $this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_id = '" . (int) $product_option_id . "', product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', option_value_id = '" . (int) $product_option_value['option_value_id'] . "', quantity = '" . (int) $product_option_value['quantity'] . "', subtract = '" . (int) $product_option_value['subtract'] . "', price = '" . (float) $product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int) $product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "', weight = '" . (float) $product_option_value['weight'] . "', weight_prefix = '" . $this->db->escape($product_option_value['weight_prefix']) . "'");
                        }
                    }
                } else {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', value = '" . $this->db->escape($product_option['value']) . "', required = '" . (int) $product_option['required'] . "'");
                }
            }
        }

        if (isset($data['product_discount'])) {
            foreach ($data['product_discount'] as $product_discount) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_discount['customer_group_id'] . "', quantity = '" . (int) $product_discount['quantity'] . "', priority = '" . (int) $product_discount['priority'] . "', price = '" . (float) $product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
            }
        }

        if (isset($data['product_exemption'])) {
            foreach ($data['product_exemption'] as $product_exemption) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_exemption SET product_id = '" . (int) $product_id . "', exemption_product_id = '" . (int) $product_exemption['exemption_product_id'] . "', status = '" . (int) $product_exemption['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");
            }
        }

        if (isset($data['product_material'])) {
            foreach ($data['product_material'] as $product_material) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_material SET product_id = '" . (int) $product_id . "', metarial_id = '" . (int) $product_material['metarial_id'] . "', used_quantity = '" . (float) $product_material['used_quantity'] . "', status = '" . (int) $product_material['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modify = NOW()");
            }
        }

        if (isset($data['product_special'])) {
            foreach ($data['product_special'] as $product_special) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_special['customer_group_id'] . "', priority = '" . (int) $product_special['priority'] . "', price = '" . (float) $product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
            }
        }

        if (isset($data['product_image'])) {
            foreach ($data['product_image'] as $product_image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int) $product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int) $product_image['sort_order'] . "' , is_rotator = '" . (int)$product_image['is_rotator'] . "'");
            }
        }

        // SEO URL
        if (isset($data['product_seo_url'])) {
            foreach ($data['product_seo_url'] as $store_id => $language) {
                foreach ($language as $language_id => $keyword) {
                    if (!empty($keyword)) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET store_id = '" . (int) $store_id . "', language_id = '" . (int) $language_id . "', query = 'product_id=" . (int) $product_id . "', keyword = '" . $this->db->escape($keyword) . "'");
                    }
                }
            }
        }

        if (isset($data['product_download'])) {
            foreach ($data['product_download'] as $download_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int) $product_id . "', download_id = '" . (int) $download_id . "'");
            }
        }

        if (isset($data['product_category'])) {
            foreach ($data['product_category'] as $category_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int) $product_id . "', category_id = '" . (int) $category_id . "'");
            }
        }

        if (isset($data['product_filter'])) {
            foreach ($data['product_filter'] as $filter_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int) $product_id . "', filter_id = '" . (int) $filter_id . "'");
            }
        }

        if (isset($data['product_related'])) {
            foreach ($data['product_related'] as $related_id) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "' AND related_id = '" . (int) $related_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $product_id . "', related_id = '" . (int) $related_id . "'");
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $related_id . "' AND related_id = '" . (int) $product_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $related_id . "', related_id = '" . (int) $product_id . "'");
            }
        }

        if (isset($data['product_reward'])) {
            foreach ($data['product_reward'] as $customer_group_id => $product_reward) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $customer_group_id . "', points = '" . (int) $product_reward['points'] . "'");
            }
        }

        if (isset($data['low_stock'])) {
            foreach ($data['low_stock'] as $store_id => $quantity) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_low_stock SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "', quantity = '" . (float) $quantity . "'");
            }
        }

        if (isset($data['product_layout'])) {
            foreach ($data['product_layout'] as $store_id => $layout_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "', layout_id = '" . (int) $layout_id . "'");
            }
        }

        if (isset($data['keyword'])) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int) $product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
        }

        if (isset($data['product_recurrings'])) {
            foreach ($data['product_recurrings'] as $recurring) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "product_recurring` SET `product_id` = " . (int) $product_id . ", customer_group_id = " . (int) $recurring['customer_group_id'] . ", `recurring_id` = " . (int) $recurring['recurring_id']);
            }
        }

        $this->cache->delete('product');

        return $product_id;
    }

    public function addCopyProduct($data)
    {

        $this->db->query("INSERT INTO " . DB_PREFIX . "product SET model = '" . $this->db->escape($data['model']) . "', code = '" . $this->db->escape($data['code']) . "', sku = '" . $this->db->escape($data['sku']) . "', upc = '" . $this->db->escape($data['upc']) . "', ean = '" . $this->db->escape($data['ean']) . "', jan = '" . $this->db->escape($data['jan']) . "', isbn = '" . $this->db->escape($data['isbn']) . "', mpn = '" . $this->db->escape($data['mpn']) . "', location = '" . $this->db->escape($data['location']) . "', quantity = '" . (int) $data['quantity'] . "', minimum = '" . (int) $data['minimum'] . "', subtract = '" . (int) $data['subtract'] . "', stock_status_id = '" . (int) $data['stock_status_id'] . "', date_available = '" . $this->db->escape($data['date_available']) . "', manufacturer_id = '" . (int) $data['manufacturer_id'] . "', shipping = '" . (int) $data['shipping'] . "', price = '" . (float) $data['price'] . "', costprice = '" . (float) $data['costprice'] . "', selling_product = '" . (int) $data['selling_product'] . "', product_type = '" . (int) $data['product_type'] . "', points = '" . (int) $data['points'] . "', weight = '" . (float) $data['weight'] . "', weight_class_id = '" . (int) $data['weight_class_id'] . "', length = '" . (float) $data['length'] . "', width = '" . (float) $data['width'] . "', height = '" . (float) $data['height'] . "', length_class_id = '" . (int) $data['length_class_id'] . "', status = '" . (int) $data['status'] . "', internal_status = '0', tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', sort_order = '" . (int) $data['sort_order'] . "', english_name = '" . $this->db->escape($data['english_name']) . "', product_category = '" . $this->db->escape($data['product_category']) . "', other_name = '" . $this->db->escape($data['other_name']) . "', taste = '" . $this->db->escape($data['taste']) . "', meridian = '" . $this->db->escape($data['meridian']) . "', effect = '" . $this->db->escape($data['effect']) . "', indications = '" . $this->db->escape($data['indications']) . "', product_usage = '" . $this->db->escape($data['product_usage']) . "', precautions = '" . $this->db->escape($data['precautions']) . "', processing = '" . $this->db->escape($data['processing']) . "', add_by = '" . (int) $this->session->data['user_id'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW()");

        $product_id = $this->db->getLastId();

        if (isset($data['image'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape($data['image']) . "' WHERE product_id = '" . (int) $product_id . "'");
        }

        foreach ($data['product_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");
        }

        if (isset($data['product_store'])) {
            foreach ($data['product_store'] as $product_all_data) {
                $batch_date = '0000-00-00';
                $location_id = '0';

                $product_data = $this->db->query("SELECT product_id , store_id FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $product_all_data['store_id'] . "' AND location_id = '" . (int) $location_id . "' AND batch_date = '" . $this->db->escape($batch_date) . "'")->num_rows;

                if(empty($product_data)) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $product_all_data['store_id'] . "'");
                }

            }
        }

        if (isset($data['product_attribute'])) {
            foreach ($data['product_attribute'] as $product_attribute) {
                if ($product_attribute['attribute_id']) {
                    $this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "' AND attribute_id = '" . (int) $product_attribute['attribute_id'] . "'");

                    foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int) $product_id . "', attribute_id = '" . (int) $product_attribute['attribute_id'] . "', language_id = '" . (int) $language_id . "', text = '" . $this->db->escape($product_attribute_description['text']) . "'");
                    }
                }
            }
        }

        if (isset($data['product_option'])) {
            foreach ($data['product_option'] as $product_option) {
                if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
                    if (isset($product_option['product_option_value'])) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', required = '" . (int) $product_option['required'] . "'");

                        $product_option_id = $this->db->getLastId();

                        foreach ($product_option['product_option_value'] as $product_option_value) {
                            $this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_id = '" . (int) $product_option_id . "', product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', option_value_id = '" . (int) $product_option_value['option_value_id'] . "', quantity = '" . (int) $product_option_value['quantity'] . "', subtract = '" . (int) $product_option_value['subtract'] . "', price = '" . (float) $product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int) $product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "', weight = '" . (float) $product_option_value['weight'] . "', weight_prefix = '" . $this->db->escape($product_option_value['weight_prefix']) . "'");
                        }
                    }
                } else {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', value = '" . $this->db->escape($product_option['value']) . "', required = '" . (int) $product_option['required'] . "'");
                }
            }
        }

        if (isset($data['product_discount'])) {
            foreach ($data['product_discount'] as $product_discount) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_discount['customer_group_id'] . "', quantity = '" . (int) $product_discount['quantity'] . "', priority = '" . (int) $product_discount['priority'] . "', price = '" . (float) $product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
            }
        }

        if (isset($data['product_exemption'])) {
            foreach ($data['product_exemption'] as $product_exemption) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_exemption SET product_id = '" . (int) $product_id . "', exemption_product_id = '" . (int) $product_exemption['exemption_product_id'] . "', status = '" . (int) $product_exemption['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");
            }
        }

        if (isset($data['product_material'])) {
            foreach ($data['product_material'] as $product_material) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_material SET product_id = '" . (int) $product_id . "', metarial_id = '" . (int) $product_material['metarial_id'] . "', used_quantity = '" . (float) $product_material['used_quantity'] . "', status = '" . (int) $product_material['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modify = NOW()");
            }
        }

        if (isset($data['product_special'])) {
            foreach ($data['product_special'] as $product_special) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_special['customer_group_id'] . "', priority = '" . (int) $product_special['priority'] . "', price = '" . (float) $product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
            }
        }

        if (isset($data['product_image'])) {
            foreach ($data['product_image'] as $product_image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int) $product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int) $product_image['sort_order'] . "', is_rotator = '" . (int) $product_image['is_rotator'] . "'");
            }
        }

        if (isset($data['product_download'])) {
            foreach ($data['product_download'] as $download_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int) $product_id . "', download_id = '" . (int) $download_id . "'");
            }
        }

        if (isset($data['product_categories'])) {
            foreach ($data['product_categories'] as $category_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int) $product_id . "', category_id = '" . (int) $category_id . "'");
            }
        }

        if (isset($data['product_filter'])) {
            foreach ($data['product_filter'] as $filter_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int) $product_id . "', filter_id = '" . (int) $filter_id . "'");
            }
        }

        if (isset($data['product_related'])) {
            foreach ($data['product_related'] as $related_id) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "' AND related_id = '" . (int) $related_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $product_id . "', related_id = '" . (int) $related_id . "'");
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $related_id . "' AND related_id = '" . (int) $product_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $related_id . "', related_id = '" . (int) $product_id . "'");
            }
        }

        if (isset($data['product_reward'])) {
            foreach ($data['product_reward'] as $customer_group_id => $product_reward) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $customer_group_id . "', points = '" . (int) $product_reward['points'] . "'");
            }
        }

        if (isset($data['product_layout'])) {
            foreach ($data['product_layout'] as $store_id => $layout_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "', layout_id = '" . (int) $layout_id . "'");
            }
        }

        if (isset($data['keyword'])) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int) $product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
        }

        if (isset($data['product_recurrings'])) {
            foreach ($data['product_recurrings'] as $recurring) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "product_recurring` SET `product_id` = " . (int) $product_id . ", customer_group_id = " . (int) $recurring['customer_group_id'] . ", `recurring_id` = " . (int) $recurring['recurring_id']);
            }
        }

        $this->cache->delete('product');

        return $product_id;
    }

    public function editProduct($product_id, $data)
    {

        $this->db->query("
		UPDATE " . DB_PREFIX . "product SET 
			model = '" . $this->db->escape($data['model']) . "', 
			code = '" . $this->db->escape($data['code']) . "', 
			pinyin = '" . $this->db->escape($data['pinyin']) . "', 
			sku = '" . $this->db->escape($data['sku']) . "', 
			upc = '" . $this->db->escape($data['upc']) . "', 
			ean = '" . $this->db->escape($data['ean']) . "', 
			jan = '" . $this->db->escape($data['jan']) . "', 
			isbn = '" . $this->db->escape($data['isbn']) . "', 
			mpn = '" . $this->db->escape($data['mpn']) . "', 
			location = '" . $this->db->escape($data['location']) . "', 
			quantity = '" . (int) $data['quantity'] . "', 
			minimum = '" . (int) $data['minimum'] . "', 
			subtract = '" . (int) $data['subtract'] . "', 
			stock_status_id = '" . (int) $data['stock_status_id'] . "', 
			date_available = '" . $this->db->escape($data['date_available']) . "', 
			manufacturer_id = '" . (int) $data['manufacturer_id'] . "', 
			shipping = '" . (int) $data['shipping'] . "', 
			price = '" . (float) $data['sellingprice'] . "', 
			costprice = '" . (float) $data['costprice'] . "', 
			selling_product = '" . (int) $data['selling_product'] . "', 
			product_type = '" . (int) $data['product_type'] . "', 
			points = '" . (int) $data['points'] . "',
			weight = '" . (float) $data['weight'] . "', 
			weight_class_id = '" . (int) $data['weight_class_id'] . "', 
			length = '" . (float) $data['length'] . "', 
			width = '" . (float) $data['width'] . "', 
			height = '" . (float) $data['height'] . "', 
			length_class_id = '" . (int) $data['length_class_id'] . "', 
			status = '" . (int) $data['status'] . "', 
			internal_status = '" . (int) $data['internal_status'] . "', 
			tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', 
			sort_order = '" . (int) $data['sort_order'] . "', 
			english_name = '" . $this->db->escape($data['herbs_name']) . "',
			product_category = '" . $this->db->escape($data['category']) . "',
			other_name = '" . $this->db->escape($data['other_name']) . "', 
			taste = '" . $this->db->escape($data['taste']) . "', 
			meridian = '" . $this->db->escape($data['meridian']) . "', 
			effect = '" . $this->db->escape($data['effect']) . "', 
			indications = '" . $this->db->escape($data['indications']) . "', 
			product_usage = '" . $this->db->escape($data['usage']) . "', 
			precautions = '" . $this->db->escape($data['precautions']) . "', 
			processing = '" . $this->db->escape($data['processing']) . "', 
			promotion ='" . (int) $data['promotion'] . "', 
			modify_by = '" . (int) $this->session->data['user_id'] . "', 
			date_modified = NOW() 
		WHERE product_id = '" . (int) $product_id . "'");


        //default location
        if (isset($data['default_location'])) {
            $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_location 
                WHERE product_id = '" . (int)$product_id . "'");
            foreach ($data['default_location'] as $store_id => $location_id) {
                if ($location_id != '0') {
                    $location_text = $this->getLocationText($location_id);
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_location SET 
                    product_id = '" . (int)$product_id . "',
                    store_id = '" . (int)$store_id . "',
                    location_id = '" . (int) $location_id . "',
                    location = '" . $this->db->escape($location_text) . "'");
                }
            }
        }

        if (isset($data['image'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape($data['image']) . "' WHERE product_id = '" . (int) $product_id . "'");
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int) $product_id . "'");

        foreach ($data['product_description'] as $language_id => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['tag']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");
        }

        $checking_store_id_arr = [];
        $checking_store_id_arr[] = '0';

        $stores_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store");
        $all_stores = $stores_query->rows;

        if (!empty($all_stores)) {
            foreach ($all_stores as $store) {
                $checking_store_id_arr[] = $store['store_id'];
            }
        }

        if (isset($data['product_store'])) {
            $no_check_stores = array_diff($checking_store_id_arr, $data['product_store']);

            if (!empty($no_check_stores)) {
                foreach ($no_check_stores as $store_id) {
                    $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $store_id . "'");
                }
            }

            foreach ($data['product_store'] as $store_id) {

                $query = $this->db->query("SELECT COUNT(*) AS num_row FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $store_id . "'");

                $product_to_store_exist = ($query->row['num_row'] > 0) ? true : false;

                if (!$product_to_store_exist) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "'");
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "'");

        if (!empty($data['product_attribute'])) {
            foreach ($data['product_attribute'] as $product_attribute) {
                if ($product_attribute['attribute_id']) {
                    $this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "' AND attribute_id = '" . (int) $product_attribute['attribute_id'] . "'");

                    foreach ($product_attribute['product_attribute_description'] as $language_id => $product_attribute_description) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_attribute SET product_id = '" . (int) $product_id . "', attribute_id = '" . (int) $product_attribute['attribute_id'] . "', language_id = '" . (int) $language_id . "', text = '" . $this->db->escape($product_attribute_description['text']) . "'");
                    }
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_option'])) {
            foreach ($data['product_option'] as $product_option) {
                if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
                    if (isset($product_option['product_option_value'])) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int) $product_option['product_option_id'] . "', product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', required = '" . (int) $product_option['required'] . "'");

                        $product_option_id = $this->db->getLastId();

                        foreach ($product_option['product_option_value'] as $product_option_value) {
                            $this->db->query("INSERT INTO " . DB_PREFIX . "product_option_value SET product_option_value_id = '" . (int) $product_option_value['product_option_value_id'] . "', product_option_id = '" . (int) $product_option_id . "', product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', option_value_id = '" . (int) $product_option_value['option_value_id'] . "', quantity = '" . (int) $product_option_value['quantity'] . "', subtract = '" . (int) $product_option_value['subtract'] . "', price = '" . (float) $product_option_value['price'] . "', price_prefix = '" . $this->db->escape($product_option_value['price_prefix']) . "', points = '" . (int) $product_option_value['points'] . "', points_prefix = '" . $this->db->escape($product_option_value['points_prefix']) . "', weight = '" . (float) $product_option_value['weight'] . "', weight_prefix = '" . $this->db->escape($product_option_value['weight_prefix']) . "'");
                        }
                    }
                } else {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_option SET product_option_id = '" . (int) $product_option['product_option_id'] . "', product_id = '" . (int) $product_id . "', option_id = '" . (int) $product_option['option_id'] . "', value = '" . $this->db->escape($product_option['value']) . "', required = '" . (int) $product_option['required'] . "'");
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_discount'])) {
            foreach ($data['product_discount'] as $product_discount) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_discount SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_discount['customer_group_id'] . "', quantity = '" . (int) $product_discount['quantity'] . "', priority = '" . (int) $product_discount['priority'] . "', price = '" . (float) $product_discount['price'] . "', date_start = '" . $this->db->escape($product_discount['date_start']) . "', date_end = '" . $this->db->escape($product_discount['date_end']) . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_material WHERE product_id = '" . (int) $product_id . "'");


        if (isset($data['product_material'])) {
            foreach ($data['product_material'] as $product_material) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_material SET product_id = '" . (int) $product_id . "', metarial_id = '" . (int) $product_material['metarial_id'] . "', used_quantity = '" . (float) $product_material['used_quantity'] . "', weight_class_id = '" . (int) $product_material['weight_class_id'] . "', weight_title = '" . $this->db->escape($product_material['weight_title']) . "', status = '" . (int) $product_material['status'] . "', add_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW()");
            }
        }


        $this->db->query("DELETE FROM " . DB_PREFIX . "product_promotion WHERE product_id = '" . (int) $product_id . "'");


        if (isset($data['product_promotion'])) {
            foreach ($data['product_promotion'] as $product_promotion) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_promotion SET product_id = '" . (int) $product_id . "', promotion_product_id = '" . (int) $product_promotion['promotion_product_id'] . "', quantity = '" . (int) $product_promotion['quantity'] . "', weight = '" . (float) $product_promotion['weight'] . "', weight_class_id = '" . (int) $product_promotion['weight_class_id'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");
            }
        }

        // SEO URL
        $this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'product_id=" . (int) $product_id . "'");

        if (isset($data['product_seo_url'])) {
            foreach ($data['product_seo_url'] as $store_id => $language) {
                foreach ($language as $language_id => $keyword) {
                    if (!empty($keyword)) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET store_id = '" . (int) $store_id . "', language_id = '" . (int) $language_id . "', query = 'product_id=" . (int) $product_id . "', keyword = '" . $this->db->escape($keyword) . "'");
                    }
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_exemption WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_exemption'])) {
            foreach ($data['product_exemption'] as $product_exemption) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_exemption SET product_id = '" . (int) $product_id . "', exemption_product_id = '" . (int) $product_exemption['exemption_product_id'] . "', status = '" . (int) $product_exemption['status'] . "', modify_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");
            }
        }


        $this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_special'])) {
            foreach ($data['product_special'] as $product_special) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_special SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $product_special['customer_group_id'] . "', priority = '" . (int) $product_special['priority'] . "', price = '" . (float) $product_special['price'] . "', date_start = '" . $this->db->escape($product_special['date_start']) . "', date_end = '" . $this->db->escape($product_special['date_end']) . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_image'])) {
            foreach ($data['product_image'] as $product_image) {
                //$this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int) $product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int) $product_image['sort_order'] . "', is_rotator = '" . (int)$product_image['is_rotator'] . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_image SET product_id = '" . (int) $product_id . "', image = '" . $this->db->escape($product_image['image']) . "', sort_order = '" . (int) $product_image['sort_order'] . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_download'])) {
            foreach ($data['product_download'] as $download_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_download SET product_id = '" . (int) $product_id . "', download_id = '" . (int) $download_id . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_category'])) {
            foreach ($data['product_category'] as $category_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_category SET product_id = '" . (int) $product_id . "', category_id = '" . (int) $category_id . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_filter'])) {
            foreach ($data['product_filter'] as $filter_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_filter SET product_id = '" . (int) $product_id . "', filter_id = '" . (int) $filter_id . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int) $product_id . "'");

        if (isset($data['product_related'])) {
            foreach ($data['product_related'] as $related_id) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "' AND related_id = '" . (int) $related_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $product_id . "', related_id = '" . (int) $related_id . "'");
                $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $related_id . "' AND related_id = '" . (int) $product_id . "'");
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_related SET product_id = '" . (int) $related_id . "', related_id = '" . (int) $product_id . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_reward'])) {
            foreach ($data['product_reward'] as $customer_group_id => $value) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_reward SET product_id = '" . (int) $product_id . "', customer_group_id = '" . (int) $customer_group_id . "', points = '" . (int) $value['points'] . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_low_stock WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['low_stock'])) {
            foreach ($data['low_stock'] as $store_id => $value) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_low_stock SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "', quantity = '" . (float) $value . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int) $product_id . "'");

        if (isset($data['product_layout'])) {
            foreach ($data['product_layout'] as $store_id => $layout_id) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "product_to_layout SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "', layout_id = '" . (int) $layout_id . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int) $product_id . "'");

        if ($data['keyword']) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'product_id=" . (int) $product_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
        }

        $this->db->query("DELETE FROM `" . DB_PREFIX . "product_recurring` WHERE product_id = " . (int) $product_id);

        if (isset($data['product_recurrings'])) {
            foreach ($data['product_recurrings'] as $recurring) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "product_recurring` SET `product_id` = " . (int) $product_id . ", customer_group_id = " . (int) $recurring['customer_group_id'] . ", `recurring_id` = " . (int) $recurring['recurring_id']);
            }
        }

        $this->cache->delete('product');
    }

    public function copyProduct($product_id)
    {
        $query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int) $product_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        if ($query->num_rows) {
            $data = array();

            $data = $query->row;

            $data['sku'] = '';
            $data['upc'] = '';
            $data['viewed'] = '0';
            $data['keyword'] = '';
            $data['status'] = '0';

            $data = array_merge($data, array('product_attribute' => $this->getProductAttributes($product_id)));
            $data = array_merge($data, array('product_description' => $this->getProductDescriptions($product_id)));
            $data = array_merge($data, array('product_discount' => $this->getProductDiscounts($product_id)));
            $data = array_merge($data, array('product_filter' => $this->getProductFilters($product_id)));
            $data = array_merge($data, array('product_image' => $this->getProductImages($product_id)));
            $data = array_merge($data, array('product_option' => $this->getProductOptions($product_id)));
            $data = array_merge($data, array('product_related' => $this->getProductRelated($product_id)));
            $data = array_merge($data, array('product_reward' => $this->getProductRewards($product_id)));
            $data = array_merge($data, array('product_special' => $this->getProductSpecials($product_id)));
            $data = array_merge($data, array('product_categories' => $this->getProductCategories($product_id)));
            $data = array_merge($data, array('product_download' => $this->getProductDownloads($product_id)));
            $data = array_merge($data, array('product_layout' => $this->getProductLayouts($product_id)));
            $data = array_merge($data, array('product_store' => $this->getProductStores($product_id)));
            $data = array_merge($data, array('product_recurrings' => $this->getRecurrings($product_id)));

            $this->addCopyProduct($data);
        }
    }

    public function deleteProduct($product_id)
    {

        $this->db->query("DELETE FROM " . DB_PREFIX . "product WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_material WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_option WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_option_value WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_related WHERE related_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "review WHERE product_id = '" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "product_recurring WHERE product_id = " . (int) $product_id);
        $this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int) $product_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'product_id=" . (int) $product_id . "'");

        $this->cache->delete('product');
    }

    public function getProduct($product_id)
    {
        $query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'product_id=" . (int) $product_id . "') AS keyword FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int) $product_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->row;
    }

    //Start Modified By Chew Yi Xuan 2018-01-16
    public function getAutocompleteProducts($data)
    {
        $return = false;
        // $sql = "";
        $sql = "
            SELECT p.code, p.price, p.costprice, p.model, p.product_id, pts.onhand_quantity, CONCAT(cn_pd.name,'',en_pd.name) AS name, cn_pd.name AS chinese_name, en_pd.name AS english_name, p.weight_class_id FROM `" . DB_PREFIX . "product` p LEFT JOIN `" . DB_PREFIX . "product_description` en_pd ON p.product_id = en_pd.product_id AND en_pd.language_id = '1' LEFT JOIN `" . DB_PREFIX . "product_description` cn_pd ON p.product_id = cn_pd.product_id AND cn_pd.language_id = '2' LEFT JOIN `" . DB_PREFIX . "product_to_store` pts ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
            
            WHERE 1 ";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(cn_pd.name,'',en_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_model'])) {
            $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_price'])) {
            $sql .= " AND p.price LIKE '%" . (float) $data['filter_price'] . "%'";
            $return = true;
        }
        if (!empty($data['filter_stock'])) {
            $sql .= " AND pts.onhand_quantity LIKE '%" . $this->db->escape($data['filter_stock']) . "%'";
            $return = true;
        }
        if (!empty($data['filter_search']) && !is_null($data['filter_search'])) {
            $sql .= " AND ( 
                CONCAT(cn_pd.name,'',en_pd.name) LIKE '%" . $this->db->escape($data['filter_search']) . "%' 
                OR p.code LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                OR p.model LIKE '%" . $this->db->escape($data['filter_search']) . "%'
            )";
            $return = true;
        }
        $sql .= " GROUP BY p.product_id ORDER BY p.product_id ASC";
        if (!$return) {
            $sql .= " LIMIT 10";
        }

        $query = $this->db->query($sql);
        // echo '<pre>';
        // print_r($sql);
        // echo '</pre>';
        return $query->rows;
    }

    //End Modified By Chew Yi Xuan 2018-01-16

//     public function getProducts($data = array())
//     {
//         $sql = "
// 		SELECT 
// 			p.*,
// 			GROUP_CONCAT(DISTINCT(cd.name)) AS category_name,
// 			SUM(pts.onhand_quantity) AS onhand_quantity,
// 			wcd.unit,
// 			pd.name,
// 			CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat
// 		FROM " . DB_PREFIX . "product p 
// 		LEFT JOIN " . DB_PREFIX . "product_description pd 
// 		ON (p.product_id = pd.product_id) 
// 		LEFT JOIN " . DB_PREFIX . "product_description cn_pd
// 		ON (p.product_id = cn_pd.product_id) 
// 		AND cn_pd.language_id = 2
// 		LEFT JOIN " . DB_PREFIX . "product_description en_pd
// 		ON (p.product_id = en_pd.product_id) 
// 		AND en_pd.language_id = 1
// 		LEFT JOIN " . DB_PREFIX . "product_to_category ptc
// 		ON p.product_id = ptc.product_id
// 		LEFT JOIN " . DB_PREFIX . "category_description cd
// 		ON ptc.category_id = cd.category_id
// 		AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
// 		LEFT JOIN " . DB_PREFIX . "product_to_store pts
// 		ON p.product_id = pts.product_id 
// 		AND pts.store_id = '" . (int) $this->session->data['store_id'] . "'
// 		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
// 		ON p.weight_class_id = wcd.weight_class_id
// 		AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 
// 		WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

//         if (!empty($data['filter_name'])) {
//             $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
//         }

//         if (!empty($data['filter_model'])) {
//             $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
//         }

//         if (!empty($data['filter_code'])) {
//             $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
//         }

//         if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
//             $sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
//         }

//         if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
//             $sql .= " AND p.quantity = '" . (int) $data['filter_quantity'] . "'";
//         }

//         if (isset($data['filter_costprice']) && !is_null($data['filter_costprice'])) {
//             $sql .= " AND p.costprice LIKE '%" . $this->db->escape($data['filter_costprice']) . "%'";
//         }

//         if (isset($data['filter_stock']) && !is_null($data['filter_stock'])) {
//             $sql .= " AND pts.onhand_quantity LIKE '%" . $this->db->escape($data['filter_stock']) . "%'";
//         }

//         if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
//             $sql .= " AND p.internal_status = '" . (int) $data['filter_status'] . "'";
//         }

//         if (isset($data['filter_online_status']) && !is_null($data['filter_online_status'])) {
//             $sql .= " AND p.status = '" . (int) $data['filter_online_status'] . "'";
//         }

//         if (isset($data['filter_selling_product']) && !is_null($data['filter_selling_product'])) {
//             $sql .= " AND p.selling_product = '" . (int) $data['filter_selling_product'] . "'";
//         }

//         if (isset($data['filter_product_type']) && !is_null($data['filter_product_type'])) {
//             $sql .= " AND p.product_type = '" . (int) $data['filter_product_type'] . "'";
//         }

//         if (isset($data['filter_category']) && !is_null($data['filter_category'])) {
//             $sql .= " AND cd.category_id = '" . (int) $data['filter_category'] . "'";
//         }

//         /*if (!empty($data['filter_uom'])) {
//           $sql .= " AND wd.weight_class_id IN(" . $data['uom'] . ")";
//           } */

//         $sql .= " GROUP BY p.product_id";

//         $sort_data = array(
//             'pd.name',
//             'category_name',
//             'p.costprice',
//             'p.product_type',
//             'pts.onhand_quantity',
//             'p.weight_class_id',
//             'model_concat',
//             'p.price',
//             'p.quantity',
//             'p.status',
//             'p.sort_order'
//         );

//         if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
//             $sql .= " ORDER BY " . $data['sort'];
//         } else {
//             $sql .= " ORDER BY p.product_id";
//         }

//         if (isset($data['order']) && ($data['order'] == 'DESC')) {
//             $sql .= " DESC";
//         } else {
//             $sql .= " ASC";
//         }

//         if (isset($data['start']) || isset($data['limit'])) {
//             if ($data['start'] < 0) {
//                 $data['start'] = 0;
//             }

//             if ($data['limit'] < 1) {
//                 $data['limit'] = 20;
//             }

//             $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
//         }

//         $query = $this->db->query($sql);

//         return $query->rows;
//     }
// public function getProducts($data = array()) {
//         $sql = " SELECT p.*,pts.onhand_quantity,wcd.unit,pd.name,CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat,cn_pd.name AS cn_product_name,en_pd.name AS en_product_name,GROUP_CONCAT(DISTINCT(cd.name)) AS category_name FROM `" . DB_PREFIX . "product` p 
//         LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)
//         LEFT JOIN `" . DB_PREFIX . "product_description` en_pd ON p.product_id = en_pd.product_id AND en_pd.language_id = '1' 
//         LEFT JOIN `" . DB_PREFIX . "product_description` cn_pd ON p.product_id = cn_pd.product_id AND cn_pd.language_id = '2' 
//         LEFT JOIN`" . DB_PREFIX . "product_to_category`ptc ON p.product_id=ptc.product_id
//         LEFT JOIN`" . DB_PREFIX . "category_description` cd ON ptc.category_id=cd.category_id
//         LEFT JOIN `" . DB_PREFIX . "product_to_store` pts ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
//         LEFT JOIN  `" . DB_PREFIX . "weight_class_description` wcd on p.weight_class_id=wcd.weight_class_id
//         AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 
            
//         WHERE 1 ";


//         // $sql = "
//         // SELECT 
//         // 	p.*,
//         // 	GROUP_CONCAT(DISTINCT(cd.name)) AS category_name,
//         // 	pts.onhand_quantity,
//         // 	wcd.unit,
//         // 	pd.name,
//         // 	CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat
//         // FROM " . DB_PREFIX . "product p 
//         // LEFT JOIN " . DB_PREFIX . "product_description pd 
//         // ON (p.product_id = pd.product_id) 
//         // LEFT JOIN " . DB_PREFIX . "product_description cn_pd
//         // ON (p.product_id = cn_pd.product_id) 
//         // AND cn_pd.language_id = 2
//         // LEFT JOIN " . DB_PREFIX . "product_description en_pd
//         // ON (p.product_id = en_pd.product_id) 
//         // AND en_pd.language_id = 1
//         // LEFT JOIN " . DB_PREFIX . "product_to_category ptc
//         // ON p.product_id = ptc.product_id
//         // LEFT JOIN " . DB_PREFIX . "category_description cd
//         // ON ptc.category_id = cd.category_id
//         // AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
//         // LEFT JOIN " . DB_PREFIX . "product_to_store pts
//         // ON p.product_id = pts.product_id 
//         // AND pts.store_id = '" . (int) $this->session->data['store_id'] . "'
//         // LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
//         // ON p.weight_class_id = wcd.weight_class_id
//         // AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 
//         // WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

//         if (!empty($data['filter_name'])) {
//             $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
//         }

//         if (!empty($data['filter_model'])) {
//             $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
//         }

//         if (!empty($data['filter_code'])) {
//             $sql .= " AND p.code = '" . $this->db->escape($data['filter_code']) . "'";
//         }


//         if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
//             $sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
//         }

//         if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
//             $sql .= " AND p.quantity = '" . (int) $data['filter_quantity'] . "'";
//         }

//         if (isset($data['filter_costprice']) && !is_null($data['filter_costprice'])) {
//             $sql .= " AND p.costprice LIKE '%" . $this->db->escape($data['filter_costprice']) . "%'";
//         }

//         if (isset($data['filter_stock']) && !is_null($data['filter_stock'])) {
//             $sql .= " AND pts.onhand_quantity LIKE '%" . $this->db->escape($data['filter_stock']) . "%'";
//         }

//         if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
//             $sql .= " AND p.internal_status = '" . (int) $data['filter_status'] . "'";
//         }

//         if (isset($data['filter_product_type']) && !is_null($data['filter_product_type'])) {
//             $sql .= " AND p.product_type = '" . (int) $data['filter_product_type'] . "'";
//         }

//         // if (isset($data['filter_category']) && !is_null($data['filter_category'])) {
//         //     $sql .= " AND cd.category_id = '" . (int) $data['filter_category'] . "'";
//         // }


//         /* if (!empty($data['filter_category'])) {
//           $sql .= " AND cd.category_id IN(" . $data['category'] . ")";
//           }

//           if (!empty($data['filter_uom'])) {
//           $sql .= " AND wd.weight_class_id IN(" . $data['uom'] . ")";
//           } */

//         $sql .= " GROUP BY p.product_id";

//         $sort_data = array(
//             'pd.name',
//             'category_name',
//             'p.costprice',
//             'p.product_type',
//             'pts.onhand_quantity',
//             'p.weight_class_id',
//             'model_concat',
//             'p.price',
//             'p.quantity',
//             'p.status',
//             'p.sort_order'
//         );

//         if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
//             $sql .= " ORDER BY " . $data['sort'];
//         } else {
//             $sql .= " ORDER BY p.product_id";
//         }

//         if (isset($data['order']) && ($data['order'] == 'DESC')) {
//             $sql .= " DESC";
//         } else {
//             $sql .= " ASC";
//         }

//         if (isset($data['start']) || isset($data['limit'])) {
//             if ($data['start'] < 0) {
//                 $data['start'] = 0;
//             }

//             if ($data['limit'] < 1) {
//                 $data['limit'] = 20;
//             }

//             $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
//         }

//         $query = $this->db->query($sql);

//         // var_dump($sql);
//         // die();
//         return $query->rows;
//     }

       public function getProducts($data = array())
    {
        $sql = "
		SELECT 
			p.*,
			GROUP_CONCAT(DISTINCT(cd.name)) AS category_name,
			(SELECT SUM(pts.onhand_quantity) FROM " . DB_PREFIX . "product_to_store pts WHERE 1 AND pts.product_id = p.product_id AND pts.store_id = '" . (int) $this->session->data['store_id'] . "') AS onhand_quantity,
			/* SUM(pts.onhand_quantity) AS onhand_quantity, */
			wcd.unit,
			pd.name,
			CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat
		FROM " . DB_PREFIX . "product p 
		LEFT JOIN " . DB_PREFIX . "product_description pd 
		ON (p.product_id = pd.product_id) 
		LEFT JOIN " . DB_PREFIX . "product_description cn_pd
		ON (p.product_id = cn_pd.product_id) 
		AND cn_pd.language_id = 2
		LEFT JOIN " . DB_PREFIX . "product_description en_pd
		ON (p.product_id = en_pd.product_id) 
		AND en_pd.language_id = 1
		LEFT JOIN " . DB_PREFIX . "product_to_category ptc
		ON p.product_id = ptc.product_id
		LEFT JOIN " . DB_PREFIX . "category_description cd
		ON ptc.category_id = cd.category_id
		AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
		LEFT JOIN " . DB_PREFIX . "product_to_store pts
		ON p.product_id = pts.product_id 
		AND pts.store_id = '" . (int) $this->session->data['store_id'] . "'
		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON p.weight_class_id = wcd.weight_class_id
		AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 
		WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_model'])) {
            $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
        }

        if (!empty($data['filter_code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        }

        if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
            $sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
        }

        if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
            $sql .= " AND p.quantity = '" . (int) $data['filter_quantity'] . "'";
        }

        if (isset($data['filter_costprice']) && !is_null($data['filter_costprice'])) {
            $sql .= " AND p.costprice LIKE '%" . $this->db->escape($data['filter_costprice']) . "%'";
        }

        if (isset($data['filter_stock']) && !is_null($data['filter_stock'])) {
            $sql .= " AND pts.onhand_quantity LIKE '%" . $this->db->escape($data['filter_stock']) . "%'";
        }

        // if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
        //     $sql .= " AND p.internal_status = '" . (int) $data['filter_status'] . "'";
        // }

        // if (isset($data['filter_online_status']) && !is_null($data['filter_online_status'])) {
        //     $sql .= " AND p.status = '" . (int) $data['filter_online_status'] . "'";
        // }

        if (isset($data['filter_online_status'])) {
            if ($data['filter_online_status'] !='') {
                $sql .= " AND p.status in (" . $data['filter_online_status'] . ")";
            } else {
                $sql.= '';
            }
        }

        if (isset($data['filter_status'])) {
            if ($data['filter_status'] !='') {
                $sql .= " AND p.internal_status in (" . $data['filter_status'] . ")";
            } else {
                $sql.= '';
            }
        }


        if (isset($data['filter_selling_product'])) {
            if ($data['filter_selling_product'] !='') {
                $sql .= " AND p.selling_product in (" . $data['filter_selling_product'] . ")";
            } else {
                $sql.= '';
            }
        }

        // if (isset($data['filter_selling_product']) && !is_null($data['filter_selling_product'])) {
        //     $sql .= " AND p.selling_product = '" . (int) $data['filter_selling_product'] . "'";
        // }

        if (isset($data['filter_product_type']) && !is_null($data['filter_product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['filter_product_type'] . "'";
        }

        if (isset($data['filter_category']) && !is_null($data['filter_category'])) {
            $sql .= " AND cd.category_id IN (" . $data['filter_category'] . ")";
        }

      
        
      
        /*if (!empty($data['filter_uom'])) {
          $sql .= " AND wd.weight_class_id IN(" . $data['uom'] . ")";
          } */

        $sql .= " GROUP BY p.product_id";

        $sort_data = array(
            'pd.name',
            'category_name',
            'p.costprice',
            'p.product_type',
            'pts.onhand_quantity',
            'p.weight_class_id',
            'model_concat',
            'p.price',
            'p.quantity',
            'p.status',
            'p.sort_order'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY p.product_id";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductsByCategoryId($category_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_category p2c ON (p.product_id = p2c.product_id) WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p2c.category_id = '" . (int) $category_id . "' ORDER BY pd.name ASC");

        return $query->rows;
    }

    public function getProductDescriptions($product_id)
    {
        $product_description_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_description_data[$result['language_id']] = array(
                'name' => $result['name'],
                'description' => $result['description'],
                'meta_title' => $result['meta_title'],
                'meta_description' => $result['meta_description'],
                'meta_keyword' => $result['meta_keyword'],
                'tag' => $result['tag']
            );
        }

        return $product_description_data;
    }

    public function getProductCategories($product_id)
    {
        $product_category_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_category_data[] = $result['category_id'];
        }

        return $product_category_data;
    }

    public function getProductFilters($product_id)
    {
        $product_filter_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_filter WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_filter_data[] = $result['filter_id'];
        }

        return $product_filter_data;
    }

    public function getProductAttributes($product_id)
    {
        $product_attribute_data = array();

        $product_attribute_query = $this->db->query("SELECT attribute_id FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "' GROUP BY attribute_id");

        foreach ($product_attribute_query->rows as $product_attribute) {
            $product_attribute_description_data = array();

            $product_attribute_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_attribute WHERE product_id = '" . (int) $product_id . "' AND attribute_id = '" . (int) $product_attribute['attribute_id'] . "'");

            foreach ($product_attribute_description_query->rows as $product_attribute_description) {
                $product_attribute_description_data[$product_attribute_description['language_id']] = array('text' => $product_attribute_description['text']);
            }

            $product_attribute_data[] = array(
                'attribute_id' => $product_attribute['attribute_id'],
                'product_attribute_description' => $product_attribute_description_data
            );
        }

        return $product_attribute_data;
    }

    public function getProductOptions($product_id)
    {
        $product_option_data = array();

        $product_option_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_option` po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN `" . DB_PREFIX . "option_description` od ON (o.option_id = od.option_id) WHERE po.product_id = '" . (int) $product_id . "' AND od.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        foreach ($product_option_query->rows as $product_option) {
            $product_option_value_data = array();

            $product_option_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_option_value WHERE product_option_id = '" . (int) $product_option['product_option_id'] . "'");

            foreach ($product_option_value_query->rows as $product_option_value) {
                $product_option_value_data[] = array(
                    'product_option_value_id' => $product_option_value['product_option_value_id'],
                    'option_value_id' => $product_option_value['option_value_id'],
                    'quantity' => $product_option_value['quantity'],
                    'subtract' => $product_option_value['subtract'],
                    'price' => $product_option_value['price'],
                    'price_prefix' => $product_option_value['price_prefix'],
                    'points' => $product_option_value['points'],
                    'points_prefix' => $product_option_value['points_prefix'],
                    'weight' => $product_option_value['weight'],
                    'weight_prefix' => $product_option_value['weight_prefix']
                );
            }

            $product_option_data[] = array(
                'product_option_id' => $product_option['product_option_id'],
                'product_option_value' => $product_option_value_data,
                'option_id' => $product_option['option_id'],
                'name' => $product_option['name'],
                'type' => $product_option['type'],
                'value' => $product_option['value'],
                'required' => $product_option['required']
            );
        }

        return $product_option_data;
    }

    public function getProductImages($product_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_image WHERE product_id = '" . (int) $product_id . "' ORDER BY sort_order ASC");

        return $query->rows;
    }

    public function getProductDiscounts($product_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int) $product_id . "' ORDER BY quantity, priority, price");

        return $query->rows;
    }

    public function getProductMaterial($product_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_material pm LEFT JOIN " . DB_PREFIX . "product p ON (pm.metarial_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (pm.metarial_id = pd.product_id) WHERE pd.language_id ='" . (int) $this->config->get('config_language_id') . "' AND pm.product_id = '" . (int) $product_id . "' ORDER BY used_quantity");

        return $query->rows;
    }

    public function getProductPromotion($product_id)
    {

        $query = $this->db->query("SELECT p.code,pd.name,p.price,pm.quantity AS quantity,pm.weight AS weight,pm.weight_class_id,pm.promotion_product_id  FROM " . DB_PREFIX . "product_promotion pm LEFT JOIN " . DB_PREFIX . "product p ON (pm.promotion_product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (pm.promotion_product_id = pd.product_id) WHERE pd.language_id ='" . (int) $this->config->get('config_language_id') . "' AND pm.product_id = '" . (int) $product_id . "'");

        return $query->rows;
    }

    public function getProductExemption($product_id)
    {


        $query = $this->db->query("SELECT *,pm.status AS status FROM " . DB_PREFIX . "product_exemption pm LEFT JOIN " . DB_PREFIX . "product p ON (pm.exemption_product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (pm.exemption_product_id = pd.product_id) WHERE pd.language_id ='" . (int) $this->config->get('config_language_id') . "' AND pm.product_id = '" . (int) $product_id . "'");

        return $query->rows;
    }

    public function getProductSpecials($product_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int) $product_id . "' ORDER BY priority, price");

        return $query->rows;
    }

    public function getProductSeoUrls($product_id)
    {
        $product_seo_url_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE query = 'product_id=" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_seo_url_data[$result['store_id']][$result['language_id']] = $result['keyword'];
        }

        return $product_seo_url_data;
    }

    public function getProductRewards($product_id)
    {
        $product_reward_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_reward_data[$result['customer_group_id']] = array('points' => $result['points']);
        }

        return $product_reward_data;
    }

    public function getProductLowStocks($product_id)
    {
        $low_stock = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_low_stock WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $low_stock[$result['store_id']] = $result['quantity'];
        }

        return $low_stock;
    }

    public function getProductDownloads($product_id)
    {
        $product_download_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_download_data[] = $result['download_id'];
        }

        return $product_download_data;
    }

    public function getProductStores($product_id)
    {
        $product_store_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_store_data[] = array('store_id' => $result['store_id']);


        }

        return $product_store_data;
    }

    public function getProductLayouts($product_id)
    {
        $product_layout_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_layout WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_layout_data[$result['store_id']] = $result['layout_id'];
        }

        return $product_layout_data;
    }

    public function getProductRelated($product_id)
    {
        $product_related_data = array();

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_related WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $result) {
            $product_related_data[] = $result['related_id'];
        }

        return $product_related_data;
    }

    public function getRecurrings($product_id)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product_recurring` WHERE product_id = '" . (int) $product_id . "'");

        return $query->rows;
    }

    // public function getTotalProducts($data = array())
    // {
    //     $sql = "SELECT COUNT(DISTINCT p.product_id) AS total 
				// FROM " . DB_PREFIX . "product p 
				// LEFT JOIN " . DB_PREFIX . "product_description pd 
				//     ON (p.product_id = pd.product_id)
				// LEFT JOIN " . DB_PREFIX . "product_description cn_pd
				//     ON (p.product_id = cn_pd.product_id) 
				//     AND cn_pd.language_id = 2
				// LEFT JOIN " . DB_PREFIX . "product_description en_pd
				//     ON (p.product_id = en_pd.product_id) 
				//     AND en_pd.language_id = 1
    //             LEFT JOIN " . DB_PREFIX . "product_to_category ptc
    //                 ON p.product_id = ptc.product_id
    //             LEFT JOIN " . DB_PREFIX . "category_description cd
    //                 ON ptc.category_id = cd.category_id
    //         ";

    //     $sql .= " WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

    //     if (!empty($data['filter_name'])) {
    //         $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
    //     }

    //     if (!empty($data['filter_model'])) {
    //         $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
    //     }

    //     if (!empty($data['filter_code'])) {
    //         $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
    //     }

    //     if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
    //         $sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
    //     }

    //     if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
    //         $sql .= " AND p.quantity = '" . (int) $data['filter_quantity'] . "'";
    //     }


    //     if (isset($data['filter_selling_product']) && !is_null($data['filter_selling_product'])) {
    //         $sql .= " AND p.selling_product = '" . (int) $data['filter_selling_product'] . "'";
    //     }

    //     if (isset($data['filter_online_status']) && !is_null($data['filter_online_status'])) {
    //         $sql .= " AND p.status = '" . (int) $data['filter_online_status'] . "'";
    //     }

    //     if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
    //         $sql .= " AND p.internal_status = '" . (int) $data['filter_status'] . "'";
    //     }
    //     if (isset($data['filter_category']) && !is_null($data['filter_category'])) {
    //         $sql .= " AND cd.category_id = '" . (int) $data['filter_category'] . "'";
    //     }

    //     $query = $this->db->query($sql);

    //     return $query->row['total'];
    // }
    
      public function getTotalProducts($data = array())
    {
        $sql = "SELECT COUNT(DISTINCT p.product_id) AS total 
				FROM " . DB_PREFIX . "product p 
				LEFT JOIN " . DB_PREFIX . "product_description pd 
				    ON (p.product_id = pd.product_id)
				LEFT JOIN " . DB_PREFIX . "product_description cn_pd
				    ON (p.product_id = cn_pd.product_id) 
				    AND cn_pd.language_id = 2
				LEFT JOIN " . DB_PREFIX . "product_description en_pd
				    ON (p.product_id = en_pd.product_id) 
				    AND en_pd.language_id = 1
                LEFT JOIN " . DB_PREFIX . "product_to_category ptc
                    ON p.product_id = ptc.product_id
                LEFT JOIN " . DB_PREFIX . "category_description cd
                    ON ptc.category_id = cd.category_id
            ";

        $sql .= " WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_model'])) {
            $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
        }

        if (!empty($data['filter_code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        }

        if (isset($data['filter_price']) && !is_null($data['filter_price'])) {
            $sql .= " AND p.price LIKE '" . $this->db->escape($data['filter_price']) . "%'";
        }

        if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
            $sql .= " AND p.quantity = '" . (int) $data['filter_quantity'] . "'";
        }


        // if (isset($data['filter_selling_product']) && !is_null($data['filter_selling_product'])) {
        //     $sql .= " AND p.selling_product = '" . (int) $data['filter_selling_product'] . "'";
        // }

        // if (isset($data['filter_online_status']) && !is_null($data['filter_online_status'])) {
        //     $sql .= " AND p.status = '" . (int) $data['filter_online_status'] . "'";
        // }

        // if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
        //     $sql .= " AND p.internal_status = '" . (int) $data['filter_status'] . "'";
        // }

        if (isset($data['filter_selling_product'])) {
            if ($data['filter_selling_product'] !='') {
                $sql .= " AND p.selling_product in (" . $data['filter_selling_product'] . ")";
            } else {
                $sql.= '';
            }
        }

        if (isset($data['filter_status'])) {
            if ($data['filter_status'] !='') {
                $sql .= " AND p.internal_status in (" . $data['filter_status'] . ")";
            } else {
                $sql.= '';
            }
        }

        if (isset($data['filter_online_status'])) {
            if ($data['filter_online_status'] !='') {
                $sql .= " AND p.status in (" . $data['filter_online_status'] . ")";
            } else {
                $sql.= '';
            }
        }

        // if (!empty($data['filter_category'])) {
        //     $implode[] = "cd.category_id = '" . (int) $data['filter_category'] . "'";
        // }
       if (isset($data['filter_category']) && !is_null($data['filter_category'])) {
            $sql .= " AND cd.category_id IN (" . $data['filter_category'] . ")";
        }
       


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function materials($data = array())
    {

        $sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)  LEFT JOIN " . DB_PREFIX . "weight_class_description w ON (p.weight_class_id = w.weight_class_id) ";

        $sql .= " WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND w.language_id = " . (int) $this->config->get('config_language_id');

        if (!empty($data['type'])) {
            $sql . " AND p.product_type =" . (int) $data['type'];
        }

        if (!empty($data['name'])) {
            $sql .= " AND pd.name = '" . $this->db->escape($data['name']) . "'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code = '" . $this->db->escape($data['code']) . "'";
        }

        $query = $this->db->query($sql);

        return $query;
    }

    public function getopenperoducts($data = array())
    {

        $sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "weight_class_description w ON (p.weight_class_id = w.weight_class_id) WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.internal_status = 1 AND w.language_id = " . (int) $this->config->get('config_language_id');

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $sql .= " GROUP BY p.product_id";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    //added by mlawong
    public function getopenperoducts_with_stock($data = array())
    {

        $sql = "
		SELECT p.*,
        pd.*,
        w.*,
        pts.*,
        pd1.name AS en_name,
        pd2.name AS cn_name
		FROM 
			" . DB_PREFIX . "product p 
			LEFT JOIN " . DB_PREFIX . "product_description pd 
			ON (p.product_id = pd.product_id) 
			LEFT JOIN " . DB_PREFIX . "weight_class_description w 
			ON (p.weight_class_id = w.weight_class_id)
			LEFT JOIN " . DB_PREFIX . "product_to_store pts
			ON (p.product_id = pts.product_id)
            LEFT JOIN " . DB_PREFIX . "product_description pd1
            ON (p.product_id = pd1.product_id and pd1.language_id = '1')
            LEFT JOIN " . DB_PREFIX . "product_description pd2
            ON (p.product_id = pd2.product_id and pd2.language_id = '2')
		WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' 
		AND p.internal_status = 1 AND w.language_id = " . (int) $this->config->get('config_language_id');
        // AND pts.store_id = " . (int) $this->session->data['store_id'];

        if (!empty($data['name'])) {
            $sql .= " AND CONCAT(pd1.name,' ',pd2.name) LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $sql .= " GROUP BY p.product_id";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }


        //   echo "<pre>";
        //   print_r($sql);
        //   echo "</pre>";


        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function Totalopenperoducts($data = array())
    {


        $sql = "SELECT COUNT(DISTINCT p.product_id) AS total FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.internal_status =1";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTotalProductsByTaxClassId($tax_class_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE tax_class_id = '" . (int) $tax_class_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByStockStatusId($stock_status_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE stock_status_id = '" . (int) $stock_status_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByWeightClassId($weight_class_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE weight_class_id = '" . (int) $weight_class_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByLengthClassId($length_class_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE length_class_id = '" . (int) $length_class_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByDownloadId($download_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_download WHERE download_id = '" . (int) $download_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByManufacturerId($manufacturer_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE manufacturer_id = '" . (int) $manufacturer_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByAttributeId($attribute_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_attribute WHERE attribute_id = '" . (int) $attribute_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByOptionId($option_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_option WHERE option_id = '" . (int) $option_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByProfileId($recurring_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_recurring WHERE recurring_id = '" . (int) $recurring_id . "'");

        return $query->row['total'];
    }

    public function getTotalProductsByLayoutId($layout_id)
    {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_layout WHERE layout_id = '" . (int) $layout_id . "'");

        return $query->row['total'];
    }

    public function getProductByCode($code)
    {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE code = '" . $this->db->escape($code) . "' AND code != ''");

        return $query->row;
    }

    public function getProductByProductID($product_id)
    {
        $query = $this->db->query("SELECT p.product_id, p.model, p.code, pd_en.name AS english_name, pd_cn.name AS chinese_name, p.date_stock_in, p.product_weight_sticker, p.date_expired FROM `" . DB_PREFIX . "product` p LEFT JOIN `" . DB_PREFIX . "product_description` pd_en ON p.product_id = pd_en.product_id AND pd_en.language_id = 1 LEFT JOIN `" . DB_PREFIX . "product_description` pd_cn ON p.product_id = pd_cn.product_id AND pd_cn.language_id = 2 WHERE p.product_id = '" . (int)$product_id . "' AND p.code != ''");

        return $query->row;
    }

    /** Added by Chew Yi Xuan 2018-01-18 */
    /* public function getProductOnhandQuantity($product_id) {
      $query = $this->db->query("SELECT pts.onhand_quantity AS onhand_quantity FROM `" . DB_PREFIX . "product_to_store` ptc WHERE 1 AND ptc.product_id = '" . (int)$product_id . "' AND ptc.store_id = '" . (int)$this->session->data['store_id'] . "'");
      return $query->row['onhand_quantity'];
      } */
    /** End Added by Chew Yi Xuan 2018-01-18 */

    //default location for stock date module
    public function getDefaultLocation($product_id)
    {
        $locations = array();
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_location WHERE product_id = '" . (int) $product_id . "'");

        foreach ($query->rows as $loc) {
            $locations[$loc['store_id']] = $loc['location_id'];
        }
        return $locations;
    }
    public function getDefaultLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

        return $query->rows;
    }
    public function getLocationText($location_id)
    {
        $query = $this->db->query("SELECT concat(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int) $location_id . "'");

        return $query->row['loc_text'];
    }

    /** Added by Chew Yi Xuan 2021-08-12 */
    public function getProductForStockReceived($data = array())
    {

        $sql = "
            SELECT 
                    p.product_id,
                    p.code,
                    p.model,
                    p.price,
                    p.costprice,
                    pd.name AS name,
                    CONCAT(pd_cn.name, ' ', pd_en.name) AS product_name,
                    w.weight_class_id,
                    w.title,
                    w.unit,
                    ptl.location_id,
                    ptl.location AS location_text,
                    pts.onhand_quantity
                FROM " . DB_PREFIX . "product p 
                    LEFT JOIN " . DB_PREFIX . "product_description pd 
                        ON p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_en 
                        ON p.product_id = pd_en.product_id AND pd_en.language_id = '1'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
                        ON p.product_id = pd_cn.product_id AND pd_cn.language_id = '2'
                    LEFT JOIN " . DB_PREFIX . "weight_class_description w 
                        ON p.weight_class_id = w.weight_class_id AND w.language_id = " . (int) $this->config->get('config_language_id') . "
                    LEFT JOIN " . DB_PREFIX . "product_to_location ptl
                        ON p.product_id = ptl.product_id AND ptl.store_id = " . (int) $this->session->data['store_id'] . "
                    LEFT JOIN " . DB_PREFIX . "product_to_store pts
                        ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
                WHERE 1 
                    AND p.internal_status = 1 ";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $sql .= " GROUP BY p.product_id";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        /*
           echo "<pre>";
           print_r($sql);
           echo "</pre>";
          */

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProductForStockReceived($data = array())
    {
        $sql = "
            SELECT 
                    COUNT(DISTINCT p.product_id) AS total
                FROM " . DB_PREFIX . "product p 
                    LEFT JOIN " . DB_PREFIX . "product_description pd 
                        ON p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_en 
                        ON p.product_id = pd_en.product_id AND pd_en.language_id = '1'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
                        ON p.product_id = pd_cn.product_id AND pd_cn.language_id = '2'
                    LEFT JOIN " . DB_PREFIX . "weight_class_description w 
                        ON p.weight_class_id = w.weight_class_id AND w.language_id = " . (int) $this->config->get('config_language_id') . "
                    LEFT JOIN " . DB_PREFIX . "product_to_location ptl
                        ON p.product_id = ptl.product_id AND ptl.store_id = " . (int) $this->session->data['store_id'] . "
                    LEFT JOIN " . DB_PREFIX . "product_to_store pts
                        ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
                WHERE 1 
                    AND p.internal_status = 1 ";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }
}
