<?php

class ModelCatalogLotTransfer extends Model
{

	public function getLotTransferList($data)
	{

		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_doc_no = isset($data['filter_doc_no']) ? $data['filter_doc_no'] : false;
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;



		$filter_doc_no_statement = $filter_doc_no ? "AND a.doc_no LIKE '%" . $filter_doc_no . "%'" : "";

		$filter_add_by_statement = $filter_add_by ? "AND a.add_by LIKE '%" . $filter_add_by . "%'" : "";

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_code_statement = $filter_product_code ? "AND a.product_code LIKE '%" . $filter_product_code . "%'" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";


		$filter_store_id_statement = $data['filter_store_id'] != '' ?

			"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :

			"";

		$filter_source_locations_id_statement = !empty($data['filter_source_locations']) ?
			"AND a.source_location_id in (" . implode(',', $data['filter_source_locations']) . ")" :
			"";

		$filter_target_locations_id_statement = !empty($data['filter_target_locations']) ?
			"AND a.target_location_id in (" . implode(',', $data['filter_target_locations']) . ")" :
			"";





		$sql = "

		SELECT *

		FROM(

			SELECT

				" . DB_PREFIX . "lot_transfer.lot_transfer_id,
				" . DB_PREFIX . "lot_transfer.doc_date,
				" . DB_PREFIX . "lot_transfer.doc_no,
				" . DB_PREFIX . "product_description.name AS product_name,
				" . DB_PREFIX . "product.code AS product_code,
				" . DB_PREFIX . "lot_transfer_product.source_location,
				" . DB_PREFIX . "lot_transfer_product.target_location,
				" . DB_PREFIX . "lot_transfer_product.batch_date,
				" . DB_PREFIX . "lot_transfer_product.qty,
				" . DB_PREFIX . "weight_class_description.unit AS uom,
				CONCAT(
					" . DB_PREFIX . "lot_transfer_product.source_stock_onhand,
					'=>',
					" . DB_PREFIX . "lot_transfer_product.source_stock_balance
					) AS source_mvmt,
				CONCAT(
					" . DB_PREFIX . "lot_transfer_product.target_stock_onhand,
					'=>',
					" . DB_PREFIX . "lot_transfer_product.target_stock_balance
				) AS target_mvmt,
				" . DB_PREFIX . "lot_transfer.description,
				" . DB_PREFIX . "lot_transfer.status,
				
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',


				" . DB_PREFIX . "lot_transfer_product.product_id,
				" . DB_PREFIX . "lot_transfer.store_id,
				" . DB_PREFIX . "lot_transfer_product.source_location_id,
				" . DB_PREFIX . "lot_transfer_product.target_location_id


			FROM

				" . DB_PREFIX . "lot_transfer_product 

				LEFT JOIN " . DB_PREFIX . "lot_transfer 
				ON (" . DB_PREFIX . "lot_transfer.lot_transfer_id=" . DB_PREFIX . "lot_transfer_product.lot_transfer_id)

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "lot_transfer_product.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "lot_transfer_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "weight_class_description
				ON(" . DB_PREFIX . "lot_transfer_product.weight_class_id = " . DB_PREFIX . "weight_class_description.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')


				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "lot_transfer_product.added_by = " . DB_PREFIX . "user.user_id)


			UNION

			SELECT

				" . DB_PREFIX . "lot_transfer.lot_transfer_id,
				" . DB_PREFIX . "lot_transfer.doc_date,
				" . DB_PREFIX . "lot_transfer.doc_no,
				'None' as product_name,
				'None' as product_code, 
				'None' as source_location,
				'None' as target_location,
				'None' as batch_date,
				'' as qty,
				'' as uom,
				'' AS source_mvmt,
				'' AS target_mvmt,
				" . DB_PREFIX . "lot_transfer.description,
				" . DB_PREFIX . "lot_transfer.status,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',

				'0' AS product_id,
				" . DB_PREFIX . "lot_transfer.store_id,
				'None' as source_location_id,
				'None' as target_location_id


			FROM

				" . DB_PREFIX . "lot_transfer

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "lot_transfer.added_by = " . DB_PREFIX . "user.user_id)

			WHERE 

			" . DB_PREFIX . "lot_transfer.lot_transfer_id NOT IN (SELECT DISTINCT(lot_transfer_id) FROM " . DB_PREFIX . "lot_transfer_product)

		)a

		WHERE 1

		$filter_doc_no_statement

		$filter_add_by_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_store_id_statement

		$filter_source_locations_id_statement

		$filter_target_locations_id_statement

		$filter_batch_date_from_statement

		$filter_batch_date_to_statement

		$filter_product_code_statement

		$filter_product_id_statement

		ORDER BY a.$sort $order

		LIMIT $start, $limit";



		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function totalLotTransfer($data)
	{
		$filter_doc_no = isset($data['filter_doc_no']) ? $data['filter_doc_no'] : false;
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$filter_doc_no_statement = $filter_doc_no ? "AND a.doc_no LIKE '%" . $filter_doc_no . "%'" : "";

		$filter_add_by_statement = $filter_add_by ? "AND a.add_by LIKE '%" . $filter_add_by . "%'" : "";

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_code_statement = $filter_product_code ? "AND a.product_code LIKE '%" . $filter_product_code . "%'" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";



		$filter_store_id_statement = $data['filter_store_id'] != '' ?

			"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :

			"";

		$filter_source_locations_id_statement = !empty($data['filter_source_locations']) ?
			"AND a.source_location_id in (" . implode(',', $data['filter_source_locations']) . ")" :
			"";

		$filter_target_locations_id_statement = !empty($data['filter_target_locations']) ?
			"AND a.target_location_id in (" . implode(',', $data['filter_target_locations']) . ")" :
			"";




		$sql = "

		SELECT COUNT(*) AS total

		FROM(

			SELECT

				" . DB_PREFIX . "lot_transfer.lot_transfer_id,
				" . DB_PREFIX . "lot_transfer.doc_date,
				" . DB_PREFIX . "lot_transfer.doc_no,
				" . DB_PREFIX . "product_description.name AS product_name,
				" . DB_PREFIX . "product.code AS product_code,
				" . DB_PREFIX . "lot_transfer_product.source_location,
				" . DB_PREFIX . "lot_transfer_product.target_location,
				" . DB_PREFIX . "lot_transfer_product.batch_date,
				" . DB_PREFIX . "lot_transfer_product.qty,
				" . DB_PREFIX . "weight_class_description.unit AS uom,
				CONCAT(
					" . DB_PREFIX . "lot_transfer_product.source_stock_onhand,
					'=>',
					" . DB_PREFIX . "lot_transfer_product.source_stock_balance
					) AS source_mvmt,
				CONCAT(
					" . DB_PREFIX . "lot_transfer_product.target_stock_onhand,
					'=>',
					" . DB_PREFIX . "lot_transfer_product.target_stock_balance
				) AS target_mvmt,
				" . DB_PREFIX . "lot_transfer.description,
				" . DB_PREFIX . "lot_transfer.status,
				
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',


				" . DB_PREFIX . "lot_transfer_product.product_id,
				" . DB_PREFIX . "lot_transfer.store_id,
				" . DB_PREFIX . "lot_transfer_product.source_location_id,
				" . DB_PREFIX . "lot_transfer_product.target_location_id


			FROM

				" . DB_PREFIX . "lot_transfer_product 

				LEFT JOIN " . DB_PREFIX . "lot_transfer 
				ON (" . DB_PREFIX . "lot_transfer.lot_transfer_id=" . DB_PREFIX . "lot_transfer_product.lot_transfer_id)

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "lot_transfer_product.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "lot_transfer_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "weight_class_description
				ON(" . DB_PREFIX . "lot_transfer_product.weight_class_id = " . DB_PREFIX . "weight_class_description.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')


				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "lot_transfer_product.added_by = " . DB_PREFIX . "user.user_id)


			UNION

			SELECT

				" . DB_PREFIX . "lot_transfer.lot_transfer_id,
				" . DB_PREFIX . "lot_transfer.doc_date,
				" . DB_PREFIX . "lot_transfer.doc_no,
				'None' as product_name,
				'None' as product_code, 
				'None' as source_location,
				'None' as target_location,
				'None' as batch_date,
				'' as qty,
				'' as uom,
				'' AS source_mvmt,
				'' AS target_mvmt,
				" . DB_PREFIX . "lot_transfer.description,
				" . DB_PREFIX . "lot_transfer.status,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',

				'0' AS product_id,
				" . DB_PREFIX . "lot_transfer.store_id,
				'None' as source_location_id,
				'None' as target_location_id


			FROM

				" . DB_PREFIX . "lot_transfer

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "lot_transfer.added_by = " . DB_PREFIX . "user.user_id)

			WHERE 

			" . DB_PREFIX . "lot_transfer.lot_transfer_id NOT IN (SELECT DISTINCT(lot_transfer_id) FROM " . DB_PREFIX . "lot_transfer_product)

		)a

		WHERE 1

		$filter_doc_no_statement

		$filter_add_by_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_store_id_statement

		$filter_source_locations_id_statement

		$filter_target_locations_id_statement

		$filter_batch_date_from_statement

		$filter_batch_date_to_statement

		$filter_product_code_statement

		$filter_product_id_statement

		";

		$query = $this->db->query($sql);



		return $query->row['total'];
	}

	public function getLotTransfer($lot_transfer_id)
	{

		$lot_transfer_info = array();



		$store_id = $this->session->data['store_id'];

		$language_id = $this->config->get('config_language_id');



		$sql = "

		SELECT

				" . DB_PREFIX . "lot_transfer.*,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'staff',

				" . DB_PREFIX . "lot_transfer.store_id

			FROM

				" . DB_PREFIX . "lot_transfer,

				" . DB_PREFIX . "user

			WHERE " . DB_PREFIX . "lot_transfer.added_by = " . DB_PREFIX . "user.user_id

			AND " . DB_PREFIX . "lot_transfer.lot_transfer_id = $lot_transfer_id

		";



		$query = $this->db->query($sql);



		$lot_transfer_info = $query->row;

		if (!empty($lot_transfer_info['store_id'])) {
			$store_id = $lot_transfer_info['store_id'];
		}

		$sql = "

		SELECT

			" . DB_PREFIX . "product.product_id,

			" . DB_PREFIX . "product_description.name,

			" . DB_PREFIX . "product.code,

			" . DB_PREFIX . "lot_transfer_product.*

		FROM

			" . DB_PREFIX . "lot_transfer_product,

			" . DB_PREFIX . "product,

			" . DB_PREFIX . "product_description

		WHERE " . DB_PREFIX . "lot_transfer_product.product_id = " . DB_PREFIX . "product.product_id

		AND " . DB_PREFIX . "product.product_id = " . DB_PREFIX . "product_description.product_id

		AND " . DB_PREFIX . "product_description.language_id = $language_id

		AND " . DB_PREFIX . "lot_transfer_product.lot_transfer_id = $lot_transfer_id

		";



		$query = $this->db->query($sql);



		$lot_transfer_items = $query->rows;



		foreach ($lot_transfer_items as $product) {

			$batch_date = $product['batch_date'];
			if (!empty($batch_date)) {
				$batch_date = "'" . $batch_date . "'";
			} else {
				$batch_date = 'NULL';
			}

			$source_onhand_quantity = $this->getProductStock($store_id, $product['product_id'], $product['source_location_id'], $batch_date);
			$target_onhand_quantity = $this->getProductStock($store_id, $product['product_id'], $product['target_location_id'], $batch_date);

			$lot_transfer_info['lot_transfer_item'][$product['lot_transfer_product_id']] = array(
				'name' => $product['name'],
				'product_id' => $product['product_id'],
				'lot_transfer_product_id' => $product['lot_transfer_product_id'],
				'code' => $product['code'],
				'source_onhand_quantity' => $source_onhand_quantity,
				'source_location' => $product['source_location_id'],
				'source_location_text' => $product['source_location'],
				'target_onhand_quantity' => $target_onhand_quantity,
				'target_location' => $product['target_location_id'],
				'target_location_text' => $product['target_location'],
				'qty' => (float)$product['qty'],
				'weight_class_id' => $product['weight_class_id'],
				'batch_date' => $product['batch_date'],
				'remark' => $product['remark'],
				'ref_lot_transfer_id' => $product['ref_lot_transfer_id']
			);
		}



		return $lot_transfer_info;
	}

	public function getLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	//get all location if user can view other store data
	public function getAllLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getDefaultLocation($product_id)
	{
		$query = $this->db->query("SELECT location_id FROM " . DB_PREFIX . "product_to_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' AND product_id='" . (int)$product_id . "'");

		$location_id = isset($query->row['location_id']) ? $query->row['location_id'] : 0;
		return $location_id;
	}


	public function getLocationText($location_id)
	{
		$query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
		$loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
		return $loc_text;
	}

	public function getWeightClasses()
	{
		$sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getweightClassProduct($product_id)
	{
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
		$query = $this->db->query($sql);

		$weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
		return $weight_class_id;
	}

	public function addLotTransfer($data)
	{

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;
		$save_header = isset($this->request->post['add_product']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft || $save_header) {
			$status = '1';
		}

		$store_id = $this->session->data['store_id'];
		$doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/lot_transfer', 'store' => $store_id));
		$user_id = $this->session->data['user_id'];

		$lot_transfer_item = isset($data['lot_transfer_item']) ? $data['lot_transfer_item'] : array();

		$sql = "
		INSERT INTO " . DB_PREFIX . "lot_transfer SET
		store_id = " . $store_id . ",
		description = '" . $this->db->escape($data['description'])  . "',
		doc_no = '" . $doc_no . "',
		status = '$status',
		doc_date = '" . $data['doc_date'] . "',
		added_by = " . $user_id . ",
		date_added = NOW(),
		modified_by = " . $user_id . ",
		date_modified = NOW()
		";

		$query = $this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);

			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/lot_transfer', 'store' => $store_id));

			if (!empty($lot_transfer_item)) {
				foreach ($lot_transfer_item as $row_id => $item) {
					$product_id = $item['product_id'];
					$qty = $item['qty'];
					$source_location = $this->getLocationText($item['source_location']);
					$source_location_id = $item['source_location'];
					$target_location = $this->getLocationText($item['target_location']);
					$target_location_id = $item['target_location'];

					$remark = $item['remark'];
					$wcid = $item['weight_class_id'];
					$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;

					$product_info = $this->model_catalog_product->getProduct($product_id);

					$product_wcid = $this->getweightClassProduct($product_id);

					$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


					$total_product_weight = $qty * $product_weight;
					$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

					if (!empty($batch_date)) {
						$batch_date = "'" . $batch_date . "'";
						$batch = $batch_date;
					} else {
						$batch_date = 'NULL';
						$batch = "'0000-00-00'";
					}
					$source_stock_onhand = $this->getProductStock($store_id, $product_id, $source_location_id, $batch_date);
					$target_stock_onhand = $this->getProductStock($store_id, $product_id, $target_location_id, $batch_date);
					$item_sql = "
					INSERT INTO " . DB_PREFIX . "lot_transfer_product SET
					lot_transfer_id = " . $lastid . ",
					product_id = " . $product_id . ",
					qty = " . $qty . ",
					weight_class_id = " . $wcid . ",
					weight_quantity = '" . (float)$weight_quantity . "',
					source_stock_onhand = '" . (float)$source_stock_onhand . "',
					source_location_id = '" . (int)$source_location_id . "',
					source_location = '" . $this->db->escape($source_location) . "',
					target_stock_onhand = '" . (float)$target_stock_onhand . "',
					target_location_id = '" . (int)$target_location_id . "',
					target_location = '" . $this->db->escape($target_location) . "',
					batch_date = " . $batch_date . ",
					remark = '" . $this->db->escape($remark) . "',
					date_added = NOW(),
					added_by = " . $user_id . ",
					modified_by = " . $user_id . ",
					date_modified = NOW()
					";

					$item_query = $this->db->query($item_sql);
					if ($submit) {
						$lot_transfer_product_id =  $this->db->getLastId();

						//conversion function here if needed.
						$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));


						//minus from source_location
						$calculation_sql = "
						UPDATE " . DB_PREFIX . "product_to_store SET
						onhand_quantity = onhand_quantity - $converted_qty
						WHERE product_id = $product_id
						AND store_id = $store_id
						AND location_id = $source_location_id
						AND batch_date = $batch
						";
						$calculate_query = $this->db->query($calculation_sql);

						//add to target_location
						$calculation_sql = "
						UPDATE " . DB_PREFIX . "product_to_store SET
						onhand_quantity = onhand_quantity + $converted_qty
						WHERE product_id = $product_id
						AND store_id = $store_id
						AND location_id = $target_location_id
						AND batch_date = $batch
						";
						$calculate_query = $this->db->query($calculation_sql);



						//update stock_balance in lot_transfer_product table
						$update_sql = "UPDATE " . DB_PREFIX . "lot_transfer_product SET
						source_stock_balance = source_stock_onhand - $converted_qty ,
						target_stock_balance = target_stock_onhand + $converted_qty 
						WHERE lot_transfer_product_id = $lot_transfer_product_id";
						$update_query = $this->db->query($update_sql);
					}
				}
			}
		}
		return $lastid;
	}


	public function editLotTransfer($lot_transfer_id, $data)
	{

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft) {
			$status = '1';
		}

		$user_id = $this->session->data['user_id'];
		$store_id = $this->session->data['store_id'];

		$lot_transfer_item = $data['lot_transfer_item'];

		$sql = "
		UPDATE " . DB_PREFIX . "lot_transfer SET
		description = '" . $this->db->escape($data['description'])  . "',
		status = '$status',
		doc_date = '" . $data['doc_date'] . "',
		modified_by = " . $user_id . ",
		date_modified = NOW()
		WHERE lot_transfer_id = '" . (int)$lot_transfer_id . "'
		";

		$query = $this->db->query($sql);

		$sql_delete = "DELETE FROM " . DB_PREFIX . "lot_transfer_product WHERE lot_transfer_id='" . (int)$lot_transfer_id . "'";
		$this->db->query($sql_delete);
		$this->load->model('catalog/product');

		$this->load->library('weight');

		$this->weight = new Weight($this->registry);

		foreach ($lot_transfer_item as $row_id => $item) {
			$product_id = $item['product_id'];
			$qty = $item['qty'];
			$source_location = $this->getLocationText($item['source_location']);
			$source_location_id = $item['source_location'];
			$target_location = $this->getLocationText($item['target_location']);
			$target_location_id = $item['target_location'];

			$remark = $item['remark'];
			$wcid = $item['weight_class_id'];
			$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;

			$product_info = $this->model_catalog_product->getProduct($product_id);

			$product_wcid = $this->getweightClassProduct($product_id);

			$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


			$total_product_weight = $qty * $product_weight;
			$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

			if (!empty($batch_date)) {
				$batch_date = "'" . $batch_date . "'";
				$batch = $batch_date;
			} else {
				$batch_date = 'NULL';
				$batch = "'0000-00-00'";
			}
			$source_stock_onhand = $this->getProductStock($store_id, $product_id, $source_location_id, $batch_date);
			$target_stock_onhand = $this->getProductStock($store_id, $product_id, $target_location_id, $batch_date);
			$item_sql = "
			INSERT INTO " . DB_PREFIX . "lot_transfer_product SET
			lot_transfer_id = " . $lot_transfer_id . ",
			product_id = " . $product_id . ",
			qty = " . $qty . ",
			weight_class_id = " . $wcid . ",
			weight_quantity = '" . (float)$weight_quantity . "',
			source_stock_onhand = '" . (float)$source_stock_onhand . "',
			source_location_id = '" . (int)$source_location_id . "',
			source_location = '" . $this->db->escape($source_location) . "',
			target_stock_onhand = '" . (float)$target_stock_onhand . "',
			target_location_id = '" . (int)$target_location_id . "',
			target_location = '" . $this->db->escape($target_location) . "',
			batch_date = " . $batch_date . ",
			remark = '" . $this->db->escape($remark) . "',
			date_added = NOW(),
			added_by = " . $user_id . ",
			modified_by = " . $user_id . ",
			date_modified = NOW()
			";

			$item_query = $this->db->query($item_sql);
			if ($submit) {
				$lot_transfer_product_id =  $this->db->getLastId();

				//conversion function here if needed.
				$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));


				//minus from source_location
				$calculation_sql = "
				UPDATE " . DB_PREFIX . "product_to_store SET
				onhand_quantity = onhand_quantity - $converted_qty
				WHERE product_id = $product_id
				AND store_id = $store_id
				AND location_id = $source_location_id
				AND batch_date = $batch
				";
				$calculate_query = $this->db->query($calculation_sql);

				//add to target_location
				$calculation_sql = "
				UPDATE " . DB_PREFIX . "product_to_store SET
				onhand_quantity = onhand_quantity + $converted_qty
				WHERE product_id = $product_id
				AND store_id = $store_id
				AND location_id = $target_location_id
				AND batch_date = $batch
				";
				$calculate_query = $this->db->query($calculation_sql);



				//update stock_balance in lot_transfer_product table
				$update_sql = "UPDATE " . DB_PREFIX . "lot_transfer_product SET
				source_stock_balance = source_stock_onhand - $converted_qty ,
				target_stock_balance = target_stock_onhand + $converted_qty 
				WHERE lot_transfer_product_id = $lot_transfer_product_id";
				$update_query = $this->db->query($update_sql);
			}
		}
	}

	public function addLotTransferProduct($data)
	{

		$lot_transfer_id = !empty($data['lot_transfer_id']) ? $data['lot_transfer_id'] : 0;

		$lot_transfer_product_id = 0;

		if (!empty($lot_transfer_id)) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);



			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;

			$store_id = (int)$this->session->data['store_id'];

			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$source_location = $this->getLocationText($data['source_location']);
				$source_location_id = $data['source_location'];
				$target_location = $this->getLocationText($data['target_location']);
				$target_location_id = $data['target_location'];


				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = "'" . $batch_date . "'";
				} else {
					$batch_date = 'NULL';
				}
				$source_stock_onhand = $this->getProductStock($store_id, $product_id, $source_location_id, $batch_date);
				$target_stock_onhand = $this->getProductStock($store_id, $product_id, $target_location_id, $batch_date);

				$item_sql = "
				INSERT INTO " . DB_PREFIX . "lot_transfer_product SET
				lot_transfer_id = " . $lot_transfer_id . ",
				product_id = " . $product_id . ",
				qty = " . $qty . ",
				weight_class_id = " . $wcid . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				source_stock_onhand = '" . (float)$source_stock_onhand . "',
				source_location_id = '" . (int)$source_location_id . "',
				source_location = '" . $this->db->escape($source_location) . "',
				target_stock_onhand = '" . (float)$target_stock_onhand . "',
				target_location_id = '" . (int)$target_location_id . "',
				target_location = '" . $this->db->escape($target_location) . "',
				batch_date = " . $batch_date . ",
				remark = '" . $this->db->escape($remark) . "',
				date_added = NOW(),
				added_by = " . $user_id . ",
				modified_by = " . $user_id . ",
				date_modified = NOW()
				";

				$this->db->query($item_sql);

				$lot_transfer_product_id =  $this->db->getLastId();
			}
		}



		return array(
			'id' => $lot_transfer_product_id,
			'source_stock_onhand' => $source_stock_onhand,
			'target_stock_onhand' => $target_stock_onhand
		);
	}

	public function editLotTransferProduct($data)
	{

		$lot_transfer_product_id = !empty($data['lot_transfer_product_id']) ? $data['lot_transfer_product_id'] : 0;

		if (!empty($lot_transfer_product_id)) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);



			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;

			$store_id = (int)$this->session->data['store_id'];

			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$source_location = $this->getLocationText($data['source_location']);
				$source_location_id = $data['source_location'];
				$target_location = $this->getLocationText($data['target_location']);
				$target_location_id = $data['target_location'];


				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = "'" . $batch_date . "'";
				} else {
					$batch_date = 'NULL';
				}
				$source_stock_onhand = $this->getProductStock($store_id, $product_id, $source_location_id, $batch_date);
				$target_stock_onhand = $this->getProductStock($store_id, $product_id, $target_location_id, $batch_date);

				$item_sql = "
				UPDATE " . DB_PREFIX . "lot_transfer_product SET
				product_id = " . $product_id . ",
				qty = " . $qty . ",
				weight_class_id = " . $wcid . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				source_stock_onhand = '" . (float)$source_stock_onhand . "',
				source_location_id = '" . (int)$source_location_id . "',
				source_location = '" . $this->db->escape($source_location) . "',
				target_stock_onhand = '" . (float)$target_stock_onhand . "',
				target_location_id = '" . (int)$target_location_id . "',
				target_location = '" . $this->db->escape($target_location) . "',
				batch_date = " . $batch_date . ",
				remark = '" . $this->db->escape($remark) . "',
				modified_by = " . $user_id . ",
				date_modified = NOW()
				WHERE
				lot_transfer_product_id = '" . (int)$lot_transfer_product_id . "'
				";

				$this->db->query($item_sql);

				$lot_transfer_product_id =  $this->db->getLastId();
			}
		}
		return array(
			'id' => $lot_transfer_product_id,
			'source_stock_onhand' => $source_stock_onhand,
			'target_stock_onhand' => $target_stock_onhand
		);
	}

	public function deleteLotTransferProduct($lot_transfer_product_id)
	{
		$sql_delete = "DELETE FROM " . DB_PREFIX . "lot_transfer_product WHERE lot_transfer_product_id='" . (int)$lot_transfer_product_id . "'";
		$this->db->query($sql_delete);
	}

	public function reverseTransfer($lot_transfer_product_id, $remark)
	{
		$sql = "SELECT * FROM " . DB_PREFIX . "lot_transfer_product WHERE lot_transfer_product_id ='$lot_transfer_product_id'";
		$query = $this->db->query($sql);
		$item = $query->row;

		$data = array();
		$data['description'] = $remark;
		$data['doc_date'] = date('Y-m-d');
		//action=1 (plus) 0 (minus)
		$product_id = $item['product_id'];
		$wcid = $item['weight_class_id'];
		$source_location = $item['source_location_id'];
		$target_location = $item['target_location_id'];
		$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

		//adjust quantity
		$qty = $item['qty'];

		$data['lot_transfer_item'][] = array(
			'product_id'=> $product_id,
			'qty'=> $qty,
			'source_location'=> $target_location,
			'target_location'=> $source_location,
			'remark'=> 'reversed transfer',
			'weight_class_id'=> $wcid,
			'batch_date'=> $batch_date
		);


		$ref_lot_transfer_id = $this->addLotTransfer($data);
		$this->db->query("UPDATE " . DB_PREFIX . "lot_transfer_product SET
						remark = '" . $this->db->escape($remark) . "',
						ref_lot_transfer_id = '" . (int)$ref_lot_transfer_id . "'
						WHERE lot_transfer_product_id = '" . (int)$lot_transfer_product_id . "'");
	}

	public function getProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		//$batch_date='NULL';
		if ($batch_date == 'NULL') {
			$batch_condition = " AND batch_date ='0000-00-00'";
		} else {
			$batch_condition = " AND batch_date=$batch_date";
		}

		$sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
		WHERE store_id='" . (int)$store_id . "' 
		AND product_id='" . (int)$product_id . "' 
		AND location_id='" . (int)$location_id . "'
		$batch_condition";
		$query = $this->db->query($sql);

		if (!empty($query->row['onhand_quantity'])) {
			return $query->row['onhand_quantity'];
		} else {
			//$this->addProductStock($store_id, $product_id, $location_id, $batch_date);
			return 0;
		}
	}

	public function addProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_update = "batch_date='0000-00-00',";
		} else {
			$batch_update = "batch_date=$batch_date,";
		}
		$user_id = (int)$this->session->data['user_id'];
		$sql = "INSERT INTO " . DB_PREFIX . "product_to_store SET
		store_id = " . (int)$store_id . ",
		product_id = " . (int)$product_id . ",
		location_id = " . (int)$location_id . ",
		$batch_update
		product_lastmodifiedby = " . (int)$user_id . ",
		product_lastmodifieddate = NOW()
		";
		$this->db->query($sql);
	}

	public function getLocationList($product_id)
	{
		$def_location = array();
		$sql = "SELECT DISTINCT(pts.location_id), CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) AS location_text FROM " . DB_PREFIX . "product_to_store pts
		LEFT JOIN " . DB_PREFIX . "wms_location wms on (pts.location_id = wms.location_id)
		 WHERE pts.store_id = '" . (int)$this->session->data['store_id'] . "' 
		 AND pts.product_id='" . (int)$product_id . "'
		 ORDER BY location_text asc";

		$query = $this->db->query($sql);
		$location = $query->rows;
		if (!empty($location)) {
			foreach ($location as $loc) {
				if ($loc['location_id'] == 0) {
					$def_location[$loc['location_id']] = 'Default Location';
				} else {
					$def_location[$loc['location_id']] = $loc['location_text'];
				}
			}
		}
		return $def_location;
	}

	public function getBatchDateList($product_id, $location_id)
	{
		$batchDateList = array();
		$sql = "SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'
		ORDER BY FIELD('0000-00-00', batch_date) DESC, batch_date DESC";
		$query = $this->db->query($sql);
		$list = $query->rows;
		if (!empty($list)) {
			foreach ($list as $date) {
				$batchDateList[] = $date['batch_date'];
			}
		}
		return $batchDateList;
	}

	public function editLotTransferInfo($lot_transfer_id, $data)
	{
		$user_id = (int)$this->session->data['user_id'];


		if (!empty($lot_transfer_id)) {
			$sql = "
                UPDATE " . DB_PREFIX . "lot_transfer
                    SET
                        description = '" . $this->db->escape($data['description'])  . "',
                        modified_by = " . $user_id . ",
                        date_modified = NOW()
                        WHERE lot_transfer_id = '" . (int)$lot_transfer_id . "'
                
            ";
			$this->db->query($sql);
		}
	}
}
