<?php

class ModelCatalogBarcode extends Model
{
    public function getProducts($data)
    {
        $sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

        $filter_product_name = isset($data['filter_name']) ? explode(',', $data['filter_name']) : array();
		$filter_product_code = isset($data['filter_code']) ? explode(',', $data['filter_code']) : array();
        $filter_model = isset($data['filter_model']) ? $data['filter_model'] : false;

        $start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;

		$filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $product_name . "%'":" OR CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

		$filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)?"p.code LIKE '%" . $product_code . "%'":" OR a.code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement)?" AND ($filter_product_code_statement)":"";

        $filter_model_statement = $filter_model ? "AND a.model LIKE '%" . $filter_model . "%'" : "";

        $sql = "SELECT *

		FROM(


		SELECT 
			p.product_id,
            p.code,
            p.image,
            p.model,
			wcd.unit,
			pd.name,
			CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat
		FROM " . DB_PREFIX . "product p 
		LEFT JOIN " . DB_PREFIX . "product_description pd 
		ON (p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "') 

		LEFT JOIN " . DB_PREFIX . "product_description cn_pd
		ON (p.product_id = cn_pd.product_id
		AND cn_pd.language_id = 2)

		LEFT JOIN " . DB_PREFIX . "product_description en_pd
		ON (p.product_id = en_pd.product_id
		AND en_pd.language_id = 1)

		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON p.weight_class_id = wcd.weight_class_id
		AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 

		WHERE 1 GROUP BY p.product_id
        
        )a

		WHERE 1
        
        $filter_product_name_statement

		$filter_product_code_statement

        $filter_model_statement


		ORDER BY a.$sort $order

		LIMIT $start, $limit";

        // if (!empty($data['filter_name'])) {
        //     $sql .= " AND CONCAT(en_pd.name, ' ', cn_pd.name) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        // }

        // if (!empty($data['filter_model'])) {
        //     $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
        // }

        // if (!empty($data['filter_code'])) {
        //     $sql .= " AND p.code LIKE '%" . $this->db->escape($data['filter_code']) . "%'";
        // }

        // $sort_data = array(
        //     'pd.name',
        //     'model_concat',
        //     'p.code',
        // );

        // if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
        //     $sql .= " ORDER BY " . $data['sort'];
        // } else {
        //     $sql .= " ORDER BY p.product_id";
        // }

        // if (isset($data['order']) && ($data['order'] == 'DESC')) {
        //     $sql .= " DESC";
        // } else {
        //     $sql .= " ASC";
        // }

        // if (isset($data['start']) || isset($data['limit'])) {
        //     if ($data['start'] < 0) {
        //         $data['start'] = 0;
        //     }

        //     if ($data['limit'] < 1) {
        //         $data['limit'] = 20;
        //     }

        //     $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        // }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProducts($data)
    {

        $filter_product_name = isset($data['filter_name']) ? explode(',', $data['filter_name']) : array();
		$filter_product_code = isset($data['filter_code']) ? explode(',', $data['filter_code']) : array();
        $filter_model = isset($data['filter_model']) ? $data['filter_model'] : false;


		$filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" a.name LIKE '%" . $product_name . "%'":" OR a.name LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

		$filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)?"a.code LIKE '%" . $product_code . "%'":" OR a.code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement)?" AND ($filter_product_code_statement)":"";

        $filter_model_statement = $filter_model ? "AND a.model LIKE '%" . $filter_model . "%'" : "";

        $sql = "SELECT COUNT(*) AS total

		FROM(


		SELECT 
			p.product_id,
            p.code,
            p.image,
			wcd.unit,
			pd.name,
			CONCAT(en_pd.name, ' ', cn_pd.name) AS model_concat
		FROM " . DB_PREFIX . "product p 
		LEFT JOIN " . DB_PREFIX . "product_description pd 
		ON (p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "') 

		LEFT JOIN " . DB_PREFIX . "product_description cn_pd
		ON (p.product_id = cn_pd.product_id
		AND cn_pd.language_id = 2)

		LEFT JOIN " . DB_PREFIX . "product_description en_pd
		ON (p.product_id = en_pd.product_id
		AND en_pd.language_id = 1)

		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON p.weight_class_id = wcd.weight_class_id
		AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 

		WHERE 1 GROUP BY p.product_id
        
        )a

		WHERE 1
        
        $filter_product_name_statement

		$filter_product_code_statement

        $filter_model_statement
";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    // public function getWeightClasses()
    // {
    //     $result = array();
    //     $sql = "SELECT *  FROM oc_weight_class_description WHERE language_id = " . (int) $this->config->get('config_language_id') . "";
    //     $query = $this->db->query($sql);
    //     if ($query->num_rows) {
    //         foreach ($query->rows as $row) {
    //             $result[$row['weight_class_id']] = $row['unit'];
    //         }
    //     }
    //     return $result;
    // }

    public function getProduct($product_id)
    {
        $sql = "SELECT 
                p.*,
                wcd.weight_class_id,
                wcd.unit,
                en_pd.name AS english_name,
                cn_pd.name AS chinese_name
                FROM " . DB_PREFIX . "product p 

                LEFT JOIN " . DB_PREFIX . "product_description cn_pd
                ON (p.product_id = cn_pd.product_id
                AND cn_pd.language_id = 2)

                LEFT JOIN " . DB_PREFIX . "product_description en_pd
                ON (p.product_id = en_pd.product_id
                AND en_pd.language_id = 1)

                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON p.weight_class_id = wcd.weight_class_id
                AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' 

                WHERE p.product_id = '" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }
}
