<?php
class ModelAppointmentAppointmentEtcm extends Model {
    public function getAppointments($data){
        $sort 	= isset($data['sort']) ? $data['sort'] : "appointment_date";
	$order 	= isset($data['order']) ? $data['order'] : "DESC";
        
        $filter_name_statement = !empty($data['filter_name']) ? 
                                 "AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" : '';
        
        $filter_no_statement = !empty($data['filter_no']) ? 
                                 "AND c.customer_card LIKE '%" . $this->db->escape($data['filter_no']) . "%'" : '';
        
        $filter_ic_statement = !empty($data['filter_ic']) ? 
                                 "AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_ic']) . "%'" : '';
        
        $filter_date_statement = !empty($data['filter_date']) ? 
                                 "AND DATE(a.appointment_date) = DATE('" . $this->db->escape($data['filter_date']) . "')" : '';
        
        $filter_status_statement = isset($data['filter_status']) ? "AND a.status = " . (int)$data['filter_status'] . "" : '';
		
		$filter_doctor_statement = !empty($data['filter_doctor']) ? "AND a.doctor_id = " . (int)$data['filter_doctor'] . "" : '';
		
		$filter_remark_statement = !empty($data['filter_remark']) ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : '';
        
        $limit_statement = "";
	if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
		$data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
	}
                
        $sql = "SELECT a.appointment_date, 
                       a.appointment_time, 
                       a.appointment_id, 
                       a.status, 
                       s.name AS store_name,
                       a.store_id, 
                       a.customer_id
                FROM " . DB_PREFIX . "appointment a 
                LEFT JOIN " . DB_PREFIX . "store s
                ON s.store_id = a.store_id 
                LEFT JOIN " . DB_PREFIX . "customer c 
                ON c.customer_id = a.customer_id 
                WHERE a.from_etcm != 0 
                $filter_name_statement 
                $filter_no_statement 
                $filter_ic_statement 
                $filter_date_statement 
                $filter_status_statement
				$filter_doctor_statement
				$filter_remark_statement 
                ORDER BY $sort $order 
                $limit_statement";
        
        $query = $this->db->query($sql);
        
        return $query->rows;
    }
    
    public function getTotalAppointments($data){
        $filter_name_statement = !empty($data['filter_name']) ? 
                                 "AND CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'" : '';
        
        $filter_no_statement = !empty($data['filter_no']) ? 
                                 "AND c.customer_card LIKE '%" . $this->db->escape($data['filter_no']) . "%'" : '';
        
        $filter_ic_statement = !empty($data['filter_ic']) ? 
                                 "AND c.customer_ic LIKE '%" . $this->db->escape($data['filter_ic']) . "%'" : '';
         
        $filter_date_statement = !empty($data['filter_date']) ? 
                                 "AND DATE(a.appointment_date) = DATE('" . $this->db->escape($data['filter_date']) . "')" : '';
        
        $filter_status_statement = isset($data['filter_status']) ? "AND a.status = " . (int)$data['filter_status'] . "" : '';
		
		$filter_doctor_statement = !empty($data['filter_doctor']) ? "AND a.doctor_id = " . (int)$data['filter_doctor'] . "" : '';
		
		$filter_remark_statement = !empty($data['filter_remark']) ? "AND a.remark LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : '';
                
        $sql = "SELECT COUNT(*) AS total 
                FROM " . DB_PREFIX . "appointment a 
                LEFT JOIN " . DB_PREFIX . "store s
                ON s.store_id = a.store_id 
                LEFT JOIN " . DB_PREFIX . "customer c 
                ON c.customer_id = a.customer_id 
                WHERE a.from_etcm != 0 
                $filter_name_statement 
                $filter_no_statement 
                $filter_ic_statement 
                $filter_date_statement 
                $filter_status_statement
				$filter_doctor_statement
				$filter_remark_statement";
        
        $query = $this->db->query($sql);
        
        return $query->row['total'];
    }
    
    public function deleteAppointment($appointment_id) {
	$this->db->query("UPDATE " . DB_PREFIX . "appointment SET status = 2 WHERE appointment_id = '" . (int)$appointment_id . "'");
    }

    public function getCustomer($customer_id){
        $sql = "SELECT CONCAT(c.firstname, ' ', c.lastname) AS customer_name, 
                c.customer_ic, 
                c.gender, 
                c.email, 
                c.telephone, 
                c.fax,
                a.country_id, 
                c.firstname, 
                c.lastname, 
                c.customer_card, 
                c.telephone2,
                c.home 
                FROM " . DB_PREFIX . "customer c 
                LEFT JOIN " . DB_PREFIX . "address a 
                ON a.customer_id = c.customer_id 
                WHERE c.customer_id = '" . (int)$customer_id . "'"; 
    
        $query = $this->db->query($sql);
        
        return $query->row;
    }
    
    public function getAppointment($appointment_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . (int)$appointment_id . "'"; 
    
        $query = $this->db->query($sql);
        
        return $query->row; 
    }
    
	public function getDoctors() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE position = 2");

		return $query->rows;		
	}
	
    public function getDoctor($doctor_id){
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE position = '" . (int) 2 . "' AND user_id = '" . (int)$doctor_id . "'");
        
        return $query->row;
    }
    
    public function getService($service_id) {
	$query = $this->db->query("SELECT *
                                   FROM " . DB_PREFIX . "clinical_service a
                                   LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
                                   WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' AND a.clinicalservice_id = '" . (int)$service_id . "'");

	return $query->row;
    }
    
    public function getServices() {
	$query = $this->db->query("SELECT *
                		   FROM " . DB_PREFIX . "clinical_service a
                                   LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
                                   WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY b.name ASC");

	return $query->rows;
    }
    
    public function checkUserHoliday($doctor_id) {
	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE store_id = '" . $this->session->data['store_id'] . "' AND user_id = '" . (int)$doctor_id . "'");

	return $query->rows;		
    }

    public function checkStoreHoliday($store_id) {
	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'");

	return $query->rows;		
    }
    
    public function getStore($appointment_id) {
	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment a
                                   INNER JOIN " . DB_PREFIX . "store b ON a.store_id = b.store_id
                                   WHERE a.appointment_id = '" . $appointment_id . "'");

	return $query->row;		
    }
    
    public function editAppointment($appointment_id, $data) {
	$doctor = ($data['doctor'] ? (int)$data['doctor'] : 'NULL');
	$service = ($data['service'] ? (int)$data['service'] : 'NULL');

	if($data['status']==5) {
            $data['status'] = 0;
	}

	$this->db->query("UPDATE " . DB_PREFIX . "appointment SET appointment_date = '" . $this->db->escape($data['date']) . "', appointment_time = '" . $this->db->escape($data['time']) . "', store_id = '" . (int)$this->session->data['store_id'] . "', doctor_id = " . $doctor . ", clinicalservice_id = " . $service . ", start_time = '" . $this->db->escape($data['start']) . "', end_time = '" . $this->db->escape($data['end']) . "', price = '" . (float)$data['price'] . "', remark = '" . $this->db->escape($data['remark']) . "', status = '" . (int)$data['status'] . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW() WHERE appointment_id = '" . $appointment_id . "'");

	$this->db->query("UPDATE " . DB_PREFIX . "appointment_emergency SET appointment_newdate = '" . $this->db->escape($data['date']) . "', appointment_newtime = '" . $this->db->escape($data['time']) . "', doctor_id = " . $doctor . ", emergency_status = 1 WHERE appointment_id = '" . $appointment_id . "' AND emergency_status != 1");

	return $this->db->countAffected();
    }
    
    public function addHerbal($data, $transaction_no) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale SET customer_id = '" . (int)$data['customer_id'] . "', doctor_id = '" . (int)$data['doctor'] . "', invoice_prefix = '" . $this->db->escape($transaction_no) . "', sales_date = NOW(), store_id = '" . (int)$this->session->data['store_id'] . "', clinicalsale_action = '" . (int) 1 . "', order_action = '" . (int)17 . "', add_by = '" . (int)$this->session->data['user_id'] . "', date_added = NOW(), modifi_by = '" . $this->session->data['user_id'] . "', date_modified = NOW()");
	
		$herbal_id = $this->db->getLastId();
	
		$this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = (lastrunningno + 1) WHERE module = 'herbal/herbal' AND store_id = '" . $this->session->data['store_id'] . "'");		
    	
		return $herbal_id;
	}

    public function addService($data, $transaction_no) {		
	$this->db->query("INSERT INTO " . DB_PREFIX . "service_form SET invoice_prefix = '" . $this->db->escape($transaction_no) . "', customer_id = '" . (int)$data['customer_id'] . "', store_id = '" . (int)$this->session->data['store_id'] . "', serviceform_action = 1, order_action = 17, add_by = '" . $this->user->getId() . "', date_added = NOW(), modifi_by = '" . $this->user->getId() . "', date_modified = NOW()");

	$service_id = $this->db->getLastId();

	$start_time = date('Y-m-d') . ' ' . $data['start'];
	$end_time = date('Y-m-d') . ' ' . $data['end'];

	$this->db->query("INSERT INTO " . DB_PREFIX . "service_item SET service_form_id = '" . $service_id . "', clinicalservice_id = '" . (int)$data['service'] . "', user_id = '" . (int)$data['doctor'] . "', start_time = '" . $start_time . "', end_time = '" . $end_time . "', price = '" . $data['price'] . "', modifi_by = '" . $this->session->data['user_id'] . "', date_modified = NOW()");

	$this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = (lastrunningno + 1) WHERE module = 'service/service_form' AND store_id = '" . $this->session->data['store_id'] . "'");		
    }
}
?>