<?php

class ModelAppointmentAppointmentEmergency extends Model {

    public function getTotalEmergencys($data) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "appointment_emergency a";

        $sql .= " INNER JOIN " . DB_PREFIX . "appointment b ON a.appointment_id = b.appointment_id";

        $sql .= " INNER JOIN " . DB_PREFIX . "user c ON b.doctor_id = c.user_id";

        $sql .= " INNER JOIN " . DB_PREFIX . "customer d ON b.customer_id = d.customer_id";

        $sql .= ' WHERE a.store_id = ' . $store_id;

        if (isset($data['filter_status'])) {
            $sql .= " AND a.emergency_status = " . (int) $data['filter_status'] . "";
        }

        if (!empty($data['filter_date'])) {
            $sql .= " AND DATE(a.appointment_olddate) = DATE('" . $this->db->escape($data['filter_date']) . "')";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND d.firstname LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
            $sql .= " OR d.lastname LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_ic'])) {
            $sql .= " AND d.customer_ic = '" . $this->db->escape($data['filter_ic']) . "'";
        }

        if (!empty($data['filter_no'])) {
            $sql .= " AND d.customer_card = '" . $this->db->escape($data['filter_no']) . "'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND c.firstname LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
            $sql .= " OR c.lastname LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getEmergencys($data = array()) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT a.*, c.firstname d_firstname, c.lastname d_lastname, d.firstname c_firstname, d.lastname c_lastname, d.customer_ic FROM " . DB_PREFIX . "appointment_emergency a ";

        $sql .= " INNER JOIN " . DB_PREFIX . "appointment b ON a.appointment_id = b.appointment_id";

        $sql .= " INNER JOIN " . DB_PREFIX . "user c ON b.doctor_id = c.user_id";

        $sql .= " INNER JOIN " . DB_PREFIX . "customer d ON b.customer_id = d.customer_id";

        $sql .= ' WHERE a.store_id = ' . $store_id;

        if (isset($data['filter_status'])) {
            $sql .= " AND a.emergency_status = " . (int) $data['filter_status'] . "";
        }

        if (!empty($data['filter_date'])) {
            $sql .= " AND DATE(a.appointment_olddate) = DATE('" . $this->db->escape($data['filter_date']) . "')";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND d.firstname LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
            $sql .= " OR d.lastname LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_ic'])) {
            $sql .= " AND d.customer_ic = '" . $this->db->escape($data['filter_ic']) . "'";
        }

        if (!empty($data['filter_no'])) {
            $sql .= " AND d.customer_card = '" . $this->db->escape($data['filter_no']) . "'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND c.firstname LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
            $sql .= " OR c.lastname LIKE '%" . $this->db->escape($data['filter_doctor']) . "%'";
        }

        $sort_data = array(
            'date',
            'doctor',
            'name',
            'ic',
            'sms',
            'email',
            'status'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            if ($data['sort'] == 'date') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'doctor') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'name') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'ic') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'sms') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'email') {
                $sql .= " ORDER BY a.appointment_olddate";
            } else if ($data['sort'] == 'status') {
                $sql .= " ORDER BY a.appointment_olddate";
            }
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateEmergency($emergency_id, $notification) {
        $sql = "UPDATE " . DB_PREFIX . "appointment_emergency SET";

        if ($notification == 'sms') {
            $sql .= " sms_notification = 1";
        } else if ($notification == 'email') {
            $sql .= " email_notification = 1";
        }

        $sql .= " WHERE emergency_id = '" . $emergency_id . "'";

        $this->db->query($sql);
    }

    public function getCustomer($emergency_id) {
        $query = $this->db->query("SELECT c.*, a.appointment_olddate, a.appointment_oldtime FROM " . DB_PREFIX . "appointment_emergency a
						INNER JOIN " . DB_PREFIX . "appointment b ON a.appointment_id = b.appointment_id
						INNER JOIN " . DB_PREFIX . "customer c ON b.customer_id = c.customer_id
						WHERE a.emergency_id = '" . (int) $emergency_id . "'");

        return $query->row;
    }

    public function getStore($emergency_id) {
        $query = $this->db->query("SELECT b.name FROM " . DB_PREFIX . "appointment_emergency a
						INNER JOIN " . DB_PREFIX . "store b ON a.store_id = b.store_id
						WHERE a.emergency_id = '" . (int) $emergency_id . "'");

        return $query->row;
    }

    //dashbord
    public function getDashboardAppointments($data = array()) {

        $sql = "SELECT a.*, c.firstname d_firstname, c.lastname d_lastname, d.firstname c_firstname, d.lastname c_lastname, d.customer_ic FROM " . DB_PREFIX . "appointment_emergency a ";

        $sql .= " LEFT JOIN " . DB_PREFIX . "appointment b ON a.appointment_id = b.appointment_id";

        $sql .= " LEFT JOIN " . DB_PREFIX . "user c ON b.doctor_id = c.user_id";

        $sql .= " LEFT JOIN " . DB_PREFIX . "customer d ON b.customer_id = d.customer_id";

        $sql .= ' WHERE a.emergency_status !=3 AND a.store_id = ' . $this->session->data['store_id'];


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_olddate) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_olddate) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }

        if (isset($data['sort']) && $data['sort']) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalDashboardAppointments($data) {

        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "appointment_emergency a ";

        $sql .= " LEFT JOIN " . DB_PREFIX . "appointment b ON a.appointment_id = b.appointment_id";

        $sql .= " LEFT JOIN " . DB_PREFIX . "user c ON b.doctor_id = c.user_id";

        $sql .= " LEFT JOIN " . DB_PREFIX . "customer d ON b.customer_id = d.customer_id";

        $sql .= ' WHERE a.emergency_status !=3 AND a.store_id = ' . $this->session->data['store_id'];


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_olddate) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_olddate) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

}
