<?php

class ModelAppointmentAppointmentAvailability extends Model {

    public function addAvailability($data) {

        foreach($data['availability_times'] as $type){
            if(!empty($type['check_day'])){

            $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability
					      SET store_id = '" . (int) $data['store_id'] . "',
						  	  doctor_id = '" . (int) $data['doctor_id'] . "',
						  	  minutes = '30',
							  day = '" . $this->db->escape($type['clinical_day']) . "',
							  created_by = '" . $this->user->getId() . "',
							  created_date = NOW(),
							  lastmodified_by = '" . $this->user->getId() . "',
							  lastmodified_date = NOW()"
        );

        $availability_id = $this->db->getLastId();
        if ($availability_id > 0) {
                foreach ($type['times'] as  $time) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time
									  SET availability_id = '" . (int) $availability_id . "',
										  start_time = '" . $this->db->escape($time['start_time']) . "',
										  end_time = '" . $this->db->escape($time['end_time']) . "',
										  num_app = '" . (int) $time['num_app'] . "',
										  enable_num_app = '" . (int) $time['enable_num_app'] . "',
										  added_by = '" . $this->user->getId() . "',
										  date_added = NOW()"
                    );
                }

                foreach($type['service'] as  $service){
                    $this->db->query("INSERT INTO oc_availability_to_service
									  SET availability_id = '" . (int) $availability_id . "',
										  service_id = '" . $this->db->escape($service) . "'"
                    );
                }
        }

        }
    }
        return $availability_id;
    }

    public function getAvailabilitys($data = array()) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT DISTINCT doctor_id FROM " . DB_PREFIX . "appointment_availability WHERE store_id = '" . (int) $store_id . "'";

        if (!empty($data['filter_day'])) {
            $sql .= " AND day = '" . $this->db->escape($data['filter_day']) . "'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND doctor_id = '" . (int) $data['filter_doctor'] . "'";
        }

        if (isset($data['sort'])) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAvailabilityWorkingHour($doctor_id) {
        $sql = "SELECT aa.day as service_day , aat.start_time as start_time,aat.end_time as end_time FROM oc_appointment_availability_time aat
        LEFT JOIN oc_appointment_availability aa
        ON aat.availability_id = aa.availability_id
        
        WHERE aa.doctor_id = '".(int)$doctor_id."' ORDER BY availability_time_id ASC";
        

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAvailability($doctor_id,$day) {
        $query = $this->db->query("SELECT availability_id FROM " . DB_PREFIX . "appointment_availability   WHERE doctor_id = '" . (int) $doctor_id . "' AND day = '" . $this->db->escape($day) . "'");

        return $query->row;
    }

    public function getAvailabilityTimes($availability_id) {
        $sql = "SELECT aa.day as service_day , aat.start_time as start_time,aat.end_time as end_time,aat.num_app , aat.enable_num_app FROM oc_appointment_availability_time aat
        LEFT JOIN oc_appointment_availability aa
        ON aat.availability_id = aa.availability_id
        
        WHERE aa.availability_id = '".(int)$availability_id."' ORDER BY availability_time_id ASC";
        // echo"<pre>";
        // print_r($sql);
        // echo"</pre>";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAvailabilityService($availability_id){
        $query = $this->db->query("SELECT service_id FROM oc_availability_to_service WHERE availability_id = '" . $availability_id . "'");

        return $query->rows;
    }

    public function getTotalAvailabilitys($data = array()) {
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        $sql = "SELECT COUNT(DISTINCT(doctor_id)) AS total FROM " . DB_PREFIX . "appointment_availability WHERE store_id = '" . (int) $store_id . "'";

        if (!empty($data['filter_day'])) {
            $sql .= " AND day = '" . $this->db->escape($data['filter_day']) . "'";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND doctor_id = '" . (int) $data['filter_doctor'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function editAvailability($doctor_id, $data) {

        // appointment_availability  ,  appointment_availability_time   ,   oc_availability_to_service
      $availability_ids =  $this->db->query("SELECT availability_id FROM oc_appointment_availability WHERE doctor_id = '".$doctor_id."'")->rows;
     
      foreach($availability_ids as $availability_id){

        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");

    //     echo"<pre>";
    //   print_r($availability_id['availability_id']);
    //     echo"</pre>";
      }


      foreach($data['availability_times'] as $type){
        if(!empty($type['check_day'])){

        $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability
                      SET store_id = '" . (int) $data['store_id'] . "',
                            doctor_id = '" . (int) $data['doctor_id'] . "',
                            minutes = '30',
                          day = '" . $this->db->escape($type['clinical_day']) . "',
                          created_by = '" . $this->user->getId() . "',
                          created_date = NOW(),
                          lastmodified_by = '" . $this->user->getId() . "',
                          lastmodified_date = NOW()"
    );

    $availability_id = $this->db->getLastId();
    if ($availability_id > 0) {
            foreach ($type['times'] as  $time) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time
                                  SET availability_id = '" . (int) $availability_id . "',
                                      start_time = '" . $this->db->escape($time['start_time']) . "',
                                      end_time = '" . $this->db->escape($time['end_time']) . "',
                                      num_app = '" . (int) $time['num_app'] . "',
                                      enable_num_app = '" . (int) $time['enable_num_app'] . "',
                                      added_by = '" . $this->user->getId() . "',
                                      date_added = NOW()"
                );
            }

            foreach($type['service'] as  $service){
                $this->db->query("INSERT INTO oc_availability_to_service
                                  SET availability_id = '" . (int) $availability_id . "',
                                      service_id = '" . $this->db->escape($service) . "'"
                );
            }
    }

    }
}
     

        // $this->db->query("UPDATE " . DB_PREFIX . "appointment_availability
		// 				  SET store_id = '" . (int) $data['store_id'] . "',
		// 				  	  doctor_id = '" . (int) $data['doctor_id'] . "',
		// 				      minutes = '" . (int) $data['minutes'] . "',
		// 					  day = '" . $this->db->escape($data['day']) . "',
		// 					  lastmodified_by = '" . $this->user->getId() . "',
		// 					  lastmodified_date = NOW()
		// 				   WHERE availability_id = '" . (int) $availability_id . "'"
        // );

        // $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int) $availability_id . "'");

        // if (isset($data['availability_times'])) {
        //     foreach ($data['availability_times'] as $time) {
        //         $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time
		// 						  SET availability_id = '" . (int) $availability_id . "',
		// 							  start_time = '" . $this->db->escape($time['start_time']) . "',
		// 							  end_time = '" . $this->db->escape($time['end_time']) . "',
		// 							  num_app = '" . (int) $time['num_app'] . "',
		// 							  enable_num_app = '" . (int) $time['enable_num_app'] . "', 
		// 							  added_by = '" . $this->user->getId() . "',
		// 							  date_added = NOW()"
        //         );
        //     }
        // }
    }

    public function deleteAvailability($doctor_id) {

        $availability_ids =  $this->db->query("SELECT availability_id FROM oc_appointment_availability WHERE doctor_id = '".$doctor_id."'")->rows;
     
      foreach($availability_ids as $availability_id){

        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int) $availability_id['availability_id'] . "'");

    //     echo"<pre>";
    //   print_r($availability_id['availability_id']);
    //     echo"</pre>";
      }
        
    }

    public function checkDuplicate($doctor_id, $store_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment_availability
				WHERE doctor_id = '" . (int) $doctor_id . "'
				AND store_id = '" . (int) $store_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function get_clinical_service($doctor_id) {
        $sql = "SELECT csd.clinicalservice_id as cs_id ,
        csd.name as cs_name 
        
        
        FROM oc_clinical_service cs
        LEFT JOIN oc_clinical_service_description csd
        ON cs.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "'
        LEFT JOIN oc_service_to_doctor sd
        ON cs.clinicalservice_id = sd.service_id
        WHERE sd.doctor_id = '".(int)$doctor_id."'
        ";

        // print_r($sql);
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getservicebydoctor($doctor_id){

        $sql="SELECT 
        csd.clinicalservice_id as service_id,
        csd.name as csservice_name

        FROM
        oc_clinical_service cs
        LEFT JOIN oc_clinical_service_description csd
        ON cs.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "'
        LEFT JOIN oc_service_to_doctor sd
        ON cs.clinicalservice_id = sd.service_id
        WHERE sd.doctor_id = '".(int)$doctor_id."'
        ";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDoctors(){
        $doctor = '';
        $doctor_id_used = $this->db->query("SELECT DISTINCT doctor_id FROM oc_appointment_availability WHERE 1")->rows;

        foreach($doctor_id_used as $doctor_id_useds){
            $doctor .= ','.$doctor_id_useds['doctor_id'] ;
        }
        
        $filter_doctor = !empty(!empty($doctor)) ? " AND user_id not in (". substr($doctor,1).") " : "";

        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE position = 2 AND status = 1 $filter_doctor ORDER BY doctor_sort_order" ;
        
        $query = $this->db->query($sql);
        return $query->rows;

    }

    public function getDoctorsselected($doctor_id){

        $sql="SELECT CONCAT(firstname,' ',lastname) as doctor_name, user_id as doctor_id FROM " . DB_PREFIX . "user WHERE `position` = 2 AND `status` = 1 AND user_id = '".(int)$doctor_id."'";


        // $doctor = '';
        // $doctor_id_used = $this->db->query("SELECT DISTINCT doctor_id FROM oc_appointment_availability WHERE 1")->rows;

        // foreach($doctor_id_used as $doctor_id_useds){
        //     $doctor .= ','.$doctor_id_useds['doctor_id'] ;
        // }

    
        // $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE `position` = 2 AND `status` = 1 AND user_id not in (". substr($doctor,1).") ORDER BY `doctor_sort_order`" ;


        $query = $this->db->query($sql);
        return $query->row;

    }

}
