<?php
class ControllerWholesaleWholesaleOrder extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('wholesale/wholesale_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('wholesale/wholesale_order');
        $this->load->model('localisation/order_status');

        $this->getList();
    }

    protected function getList(){
        if (isset($this->request->get['filter_wholesale_order_id'])) {
            $filter_wholesale_order_id = $this->request->get['filter_wholesale_order_id'];
        } else {
            $filter_wholesale_order_id = null;
        }

        if (isset($this->request->get['filter_wholesale_customer_name'])) {
            $filter_wholesale_customer_name = $this->request->get['filter_wholesale_customer_name'];
        } else {
            $filter_wholesale_customer_name = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_total'])) {
            $filter_order_total = $this->request->get['filter_order_total'];
        } else {
            $filter_order_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'wo.date_added';
		}

        if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

        $url = '';

        if (isset($this->request->get['filter_wholesale_order_id'])) {
            $url .= '&filter_wholesale_order_id=' . $this->request->get['filter_wholesale_order_id'];
        }

        if (isset($this->request->get['filter_wholesale_customer_name'])) {
            $url .= '&filter_wholesale_customer_name=' . $this->request->get['filter_wholesale_customer_name'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_total'])) {
            $url .= '&filter_order_total=' . $this->request->get['filter_order_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $language_arr = ['heading_title', 'text_list', 'column_wholesale_order_id', 'column_action', 'column_date_added', 'column_date_modified', 'column_order_total', 'column_order_status', 'column_wholesale_customer_name', 'button_filter', 'entry_wholesale_order_id', 'entry_order_status', 'entry_wholesale_customer_name', 'entry_date_added', 'entry_date_modified', 'entry_order_total', 'text_no_results', 'button_view', 'button_upload_slip'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

        $data['wholesale_orders'] = [];

        $filter_data = array(
           'filter_wholesale_order_id'         => $filter_wholesale_order_id,
           'filter_wholesale_customer_name'    => $filter_wholesale_customer_name,
           'filter_order_status'               => $filter_order_status,
           'filter_order_total'                => $filter_order_total,
           'filter_date_added'                 => $filter_date_added,
           'filter_date_modified'              => $filter_date_modified,
           'sort'                              => $sort,
           'order'                             => $order,
           'start'                             => ($page - 1) * $this->config->get('config_limit_admin'),
           'limit'                             => $this->config->get('config_limit_admin')
       );

       $results = $this->model_wholesale_wholesale_order->getWholesaleOrders($filter_data);
       $total_wholesale_orders = $this->model_wholesale_wholesale_order->getTotalWholesaleOrders($filter_data);

        if(!empty($results)){
            foreach($results as $result){
                $order_status_row = $this->model_localisation_order_status->getOrderStatus($result['order_status_id']);
                $order_status = !empty($order_status_row) ? $order_status_row['name'] : '';

                $data['wholesale_orders'][] = [
                    'wholesale_order_id'        => $result['wholesale_order_id'],
                    'customer_name'             => $result['customer_name'],
                    'order_status_id'           => $result['order_status_id'],
                    'order_status'              => $order_status,
                    'total'                     => $this->currency->format($result['total'], $this->config->get('config_currency')),
                    'date_added'                => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'date_modified'             => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                    'view'                      => $this->url->link('wholesale/wholesale_order/info', 'user_token=' . $this->session->data['user_token'] . '&wholesale_order_id=' . $result['wholesale_order_id'], true),
                    'upload_slip'               => $this->url->link('wholesale/wholesale_order/upload_slip', 'user_token=' . $this->session->data['user_token'] . '&wholesale_order_id=' . $result['wholesale_order_id'], true)
                ];
            }
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $url = '';

        if(isset($this->request->get['filter_wholesale_order_id'])){
            $url .= '&filter_wholesale_order_id=' . $this->request->get['filter_wholesale_order_id'];
        }

        if(isset($this->request->get['filter_wholesale_customer_name'])){
            $url .= '&filter_wholesale_customer_name=' . $this->request->get['filter_wholesale_customer_name'];
        }

        if(isset($this->request->get['filter_order_status'])){
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if(isset($this->request->get['filter_order_total'])){
            $url .= '&filter_order_total=' . $this->request->get['filter_order_total'];
        }

        if(isset($this->request->get['filter_date_added'])){
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if(isset($this->request->get['filter_date_modified'])){
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_wholesale_order_id'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.wholesale_order_id', true);
        $data['sort_wholesale_customer_name'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.customer_name', true);
        $data['sort_order_status'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.order_status_id', true);
        $data['sort_order_total'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.total', true);
        $data['sort_date_added'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.date_added', true);
        $data['sort_date_modified'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=wo.date_modified', true);

        $url = '';

        if(isset($this->request->get['filter_wholesale_order_id'])){
            $url .= '&filter_wholesale_order_id=' . urlencode(html_entity_decode($this->request->get['filter_wholesale_order_id'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_wholesale_customer_name'])){
            $url .= '&filter_wholesale_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_wholesale_customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_order_status'])){
            $url .= '&filter_order_status=' . urlencode(html_entity_decode($this->request->get['filter_order_status'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_order_total'])){
            $url .= '&filter_order_total=' . urlencode(html_entity_decode($this->request->get['filter_order_total'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_date_added'])){
            $url .= '&filter_date_added=' . urlencode(html_entity_decode($this->request->get['filter_date_added'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_date_modified'])){
            $url .= '&filter_date_modified=' . urlencode(html_entity_decode($this->request->get['filter_date_modified'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_wholesale_orders;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_wholesale_orders) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_wholesale_orders - $this->config->get('config_limit_admin'))) ? $total_wholesale_orders : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_wholesale_orders, ceil($total_wholesale_orders / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_wholesale_order_id'] = $filter_wholesale_order_id;
        $data['filter_wholesale_customer_name'] = $filter_wholesale_customer_name;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_order_total'] = $filter_order_total;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_order_list', $data));
    }

    public function info(){
        $this->load->language('wholesale/wholesale_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('wholesale/wholesale_order');
        $this->load->model('localisation/order_status');

        if(isset($this->request->get['wholesale_order_id'])){
            $wholesale_order_id = $this->request->get['wholesale_order_id'];
            $wholesale_order_info = $this->model_wholesale_wholesale_order->getWholesaleOrder($wholesale_order_id);

            if(!empty($wholesale_order_info)){
                $order_status_row = $this->model_localisation_order_status->getOrderStatus($wholesale_order_info['order_status_id']);
                $order_status = !empty($order_status_row) ? $order_status_row['name'] : '';

                $shipping_method = unserialize($wholesale_order_info['shipping_method']);

                $shipping_remark_arr = [];

                $order_histories = [];
                $payment_slips = [];

                $order_history_results = $this->model_wholesale_wholesale_order->getWholesaleOrderHistory($wholesale_order_id);
                $order_payment_slips = $this->model_wholesale_wholesale_order->getWholesaleOrderPaymentSlips($wholesale_order_id);

                $show_merchant_order_history = !empty($wholesale_order_info['merchant_order_id']) ? true : false;

                if(!empty($order_history_results)){
                    foreach($order_history_results as $history){
                        $history_order_status_row = $this->model_localisation_order_status->getOrderStatus($history['order_status_id']);

                        $history_order_status = !empty($history_order_status_row) ? $history_order_status_row['name'] : '';
                        $notify = ($history['notify'] == '1') ? $this->language->get('text_yes') : $this->language->get('text_no');


                        $order_histories[] = [
                            'date_added'        => date($this->language->get('date_format_short'), strtotime($history['date_added'])),
                            'comment'           => nl2br($history['comment']),
                            'order_status_id'   => $history['order_status_id'],
                            'order_status'      => $history_order_status,
                            'notify'            => $notify
                        ];
                    }
                }

                $total_order_histories = count($order_histories);

                if(!empty($order_payment_slips)){
                    foreach($order_payment_slips as $slip){
                        $payment_slips[] = [
                            'wholesale_order_payment_slip_id'   => $slip['wholesale_order_payment_slip_id'],
                            'image'                             => HTTPS_IMAGE . $slip['image'],
                            'remark'                            => nl2br($slip['remark']),
                            'date_added'                        => date($this->language->get('date_format_short'), strtotime($slip['date_added']))
                        ];
                    }
                }

                $merchant_order_arr = !empty($wholesale_order_info['merchant_order_id']) ? unserialize($wholesale_order_info['merchant_order_id']) : [];

                $merchant_order_histories = [];

                if(!empty($merchant_order_arr)){
                    $merchant_num = 1;

                    foreach($merchant_order_arr as $merchant_id => $order_info){
                        $merchant_order_id = $order_info['order_id'];

                        $order_history_url = HTTP_API . 'index.php?route=etcm/wholesale/get_merchant_order_histories&order_id=' . $merchant_order_id . '&store_id=' . $merchant_id;

                        $order_history_json = file_get_contents($order_history_url);
                        $order_history_arr = json_decode($order_history_json, true);

                        if($order_history_arr['error'] == '0'){
                            $histories = $order_history_arr['data'];

                            $merchant_order_histories[$merchant_id]['merchant_name'] = $this->language->get('text_merchant_title') . ' ' . $merchant_num;

                            if(!empty($histories)){
                                foreach($histories as $history){
                                    $notify_merchant_order_history = ($history['notify'] == '1') ? $this->language->get('text_yes') : $this->language->get('text_no');

                                    $merchant_order_histories[$merchant_id]['order_histories'][] = [
                                        'order_status_id'	=> $history['order_status_id'],
						                'order_status'		=> $history['order_status'],
                                        'comment'           => $history['comment'],
                                        'notify'            => $history['notify'],
                                        'notify_text'       => $notify_merchant_order_history,
						                'date_added'	    => $history['date_added']
                                    ];
                                }

                                $merchant_order_histories[$merchant_id]['num_of_history'] = count($merchant_order_histories[$merchant_id]['order_histories']);
                            } else{
                                $merchant_order_histories[$merchant_id]['order_histories'] = [];
                                $merchant_order_histories[$merchant_id]['num_of_history'] = 0;
                            }

                            $total_merchant_order_histories = $merchant_order_histories[$merchant_id]['num_of_history'];

                            if($total_merchant_order_histories > 0){
                                $merchant_order_histories[$merchant_id]['order_history_results'] = sprintf($this->language->get('text_pagination'), ($total_merchant_order_histories) ? ((1 - 1) * $total_merchant_order_histories) + 1 : 0, (((1 - 1) * $total_merchant_order_histories) > ($total_merchant_order_histories - $total_merchant_order_histories)) ? $total_merchant_order_histories : (((1 - 1) * $total_merchant_order_histories) + $total_merchant_order_histories), $total_merchant_order_histories, 1);
                            } else{
                                $merchant_order_histories[$merchant_id]['order_history_results'] = sprintf($this->language->get('text_pagination'), ($total_merchant_order_histories) ? ((1 - 1) * $total_merchant_order_histories) + 1 : 0, (((1 - 1) * $total_merchant_order_histories) > ($total_merchant_order_histories - $total_merchant_order_histories)) ? $total_merchant_order_histories : (((1 - 1) * $total_merchant_order_histories) + $total_merchant_order_histories), $total_merchant_order_histories, 0);
                            }
                        }

                        $merchant_num++;
                    }
                }

                // echo '<pre>';
                // print_r($merchant_order_histories);
                // echo '</pre>';

                $data['order'] = [
                    'wholesale_order_id'            => '#' . $wholesale_order_info['wholesale_order_id'],
                    'merchant_id'                   => unserialize($wholesale_order_info['merchant_id']),
                    'customer_name'                 => $wholesale_order_info['customer_name'],
                    'customer_telephone'            => $wholesale_order_info['customer_telephone'],
                    'customer_email'                => $wholesale_order_info['customer_email'],
                    'order_total'                   => $this->currency->format($wholesale_order_info['total'], $this->config->get('config_currency')),
                    'order_status_id'               => $wholesale_order_info['order_status_id'],
                    'order_status'                  => $order_status,
                    'date_added'                    => date($this->language->get('date_format_short'), strtotime($wholesale_order_info['date_added'])),
                    'date_modified'                 => date($this->language->get('date_format_short'), strtotime($wholesale_order_info['date_modified'])),
                    'payment_name'                  => $wholesale_order_info['payment_name'],
                    'payment_company'               => $wholesale_order_info['payment_company'],
                    'payment_address_1'             => $wholesale_order_info['payment_address_1'],
                    'payment_address_2'             => $wholesale_order_info['payment_address_2'],
                    'payment_city'                  => $wholesale_order_info['payment_city'],
                    'payment_postcode'              => $wholesale_order_info['payment_postcode'],
                    'payment_country'               => $wholesale_order_info['payment_country'],
                    'payment_zone'                  => $wholesale_order_info['payment_zone'],
                    'payment_method'                => $wholesale_order_info['payment_method'],
                    'shipping_name'                 => $wholesale_order_info['shipping_name'],
                    'shipping_company'              => $wholesale_order_info['shipping_company'],
                    'shipping_address_1'            => $wholesale_order_info['shipping_address_1'],
                    'shipping_address_2'            => $wholesale_order_info['shipping_address_2'],
                    'shipping_city'                 => $wholesale_order_info['shipping_city'],
                    'shipping_postcode'             => $wholesale_order_info['shipping_postcode'],
                    'shipping_zone'                 => $wholesale_order_info['shipping_zone'],
                    'shipping_country'              => $wholesale_order_info['shipping_country'],
                    'order_histories'               => $order_histories,
                    'payment_slips'                 => $payment_slips,
                    'show_merchant_order_history'   => $show_merchant_order_history,
                    'merchant_order_histories'      => $merchant_order_histories
                ];
            }
        } else{
            $this->response->redirect($this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'], true));
        }

        $language_arr = ['button_cancel', 'heading_title', 'text_info', 'tab_order_info', 'tab_payment_address', 'tab_shipping_address', 'tab_products', 'tab_order_history', 'text_no_results', 'column_date_added', 'column_comment', 'column_product_name', 'column_product_code', 'column_order_status', 'column_customer_notified', 'column_weight_quantity', 'column_unit_price', 'column_total_price', 'column_wholesale_customer_name', 'column_wholesale_company_name', 'column_address_1', 'column_address_2', 'column_city', 'column_postcode', 'column_zone', 'column_country', 'column_shipping_remark', 'column_payment_method', 'column_order_total', 'column_wholesale_order_id', 'column_wholesale_customer_telephone', 'column_wholesale_customer_email', 'column_date_modified', 'tab_payment_slip', 'column_image', 'column_remark', 'column_action', 'button_view_payment_slip', 'text_merchant_title', 'tab_merchant_order_history'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['user_token'] = $this->session->data['user_token'];
        $data['wholesale_order_id'] = $this->request->get['wholesale_order_id'];

        $data['cancel'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'], true);

        $data['order_history_results'] = sprintf($this->language->get('text_pagination'), ($total_order_histories) ? ((1 - 1) * $total_order_histories) + 1 : 0, (((1 - 1) * $total_order_histories) > ($total_order_histories - $total_order_histories)) ? $total_order_histories : (((1 - 1) * $total_order_histories) + $total_order_histories), $total_order_histories, ceil($total_order_histories / $total_order_histories));

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_order_info', $data));
    }

    public function get_order_by_store(){
        $json = [];
        $return_data = [];

        $this->load->model('wholesale/wholesale_order');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->cart->clear();

        if(isset($this->request->post)){
            $merchant_id = $this->request->post['merchant_id'];
            $wholesale_order_id = $this->request->get['wholesale_order_id'];

            $wholesale_order_info = $this->model_wholesale_wholesale_order->getWholesaleOrder($wholesale_order_id);
            $products = $this->model_wholesale_wholesale_order->getWholesaleOrderProducts($wholesale_order_id);

            if(!empty($products) && !empty($wholesale_order_info)){
                $shipping_method = unserialize($wholesale_order_info['shipping_method']);

                $all_products = [];
                $product_data = [];

                foreach($products as $product){
                    if($product['merchant_id'] == $merchant_id){
                        $wholesale_product_id = $product['wholesale_product_id'];

                        $product_data = [
                            'etcm_product_id'           => $product['etcm_product_id'],
                            'store_id'                  => $product['merchant_id'],
                            'product_id'                => $product['merchant_product_id'],
                            'product_name'              => $product['product_name'],
                            'product_code'              => $product['product_code'],
                            'tax_class_id'              => $product['tax_class_id'],
                            'weight_quantity'           => $product['weight_quantity'],
                            'weight_class_unit'         => $product['weight_class_unit'],
                            'unit_price'                => $product['unit_price'],
                            'unit_price_unit'           => $this->currency->format($product['unit_price'], $this->config->get('config_currency')),
                            'unit_price_without_tax'    => $product['unit_price_without_tax'],
                            'calculated_price'          => $product['total'],
                            'calculated_price_unit'     => $this->currency->format($product['total'], $this->config->get('config_currency'))
                        ];

                        $this->cart->set_domain(HTTPS_CATALOG);

                        $this->cart->add_to_cart($wholesale_product_id, $product_data);

                        $all_products[] = $product_data;
                    }
                }

                $this->cart->set_shipping_method_single($shipping_method[$merchant_id]);

                $api_url = HTTP_API . 'index.php?route=etcm/wholesale/set_single_shipping_method';

                $post_data = [
                    'shipping_method'       => base64_encode(json_encode($shipping_method[$merchant_id]))
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $api_url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $result = curl_exec($ch);

                curl_close($ch);

                $total_data = $this->totalData($wholesale_order_info['etcm_wholesale_order_id']);

                $this->cart->clear();

                $return_data = [
                    'products'      => $all_products,
                    'total'         => $total_data
                ];

                $json = [
                    'error'     => 0,
                    'data'      => $return_data,
                    'message'   => 'get order success'
                ];
            }
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function upload_slip(){
        $this->load->language('wholesale/wholesale_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('wholesale/wholesale_order');

        if($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()){
            $wholesale_order_payment_slip_id = $this->model_wholesale_wholesale_order->add_payment_slip($this->request->post, $this->request->get['wholesale_order_id']);

            // send to etcm database
            $order_info = $this->model_wholesale_wholesale_order->getWholesaleOrder($this->request->get['wholesale_order_id']);
            $payment_slip_info = $this->model_wholesale_wholesale_order->getWholesaleOrderPaymentSlip($wholesale_order_payment_slip_id);

            if(!empty($order_info) && !empty($payment_slip_info)){
                $etcm_wholesale_order_id = $order_info['etcm_wholesale_order_id'];
                $remark = $payment_slip_info['remark'];
                $image = HTTPS_IMAGE . $payment_slip_info['image'];

                $api_url = HTTP_API . 'index.php?route=etcm/wholesale/submit_payment_slip';

                $post_data = [
                    'wholesale_order_id'        => $etcm_wholesale_order_id,
                    'remark'                    => $remark,
                    'image'                     => $image
                ];

                $ch = curl_init();
        		curl_setopt($ch, CURLOPT_URL, $api_url);
        		curl_setopt($ch, CURLOPT_POST, true);
        		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        		$result = curl_exec($ch);

        		curl_close($ch);

                $json = json_decode($result, true);

                if($json['error'] == '0'){
                    $this->session->data['success'] = $this->language->get('text_success_upload');

                    $this->response->redirect($this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'], true));
                }
            }
        }

        if(isset($this->request->get['wholesale_order_id'])){
            $wholesale_order_id = $this->request->get['wholesale_order_id'];
            $wholesale_order_info = $this->model_wholesale_wholesale_order->getWholesaleOrder($wholesale_order_id);

            if(!empty($wholesale_order_info)){
                $data['order'] = [
                    'wholesale_order_id'        => '#' . $wholesale_order_info['wholesale_order_id'],
                    'order_total'               => $this->currency->format($wholesale_order_info['total'], $this->config->get('config_currency')),
                    'date_added'                => date($this->language->get('date_format_short'), strtotime($wholesale_order_info['date_added']))
                ];
            }
        } else{
            $this->response->redirect($this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'], true));
        }

        $language_arr = ['heading_title', 'button_cancel', 'text_upload_slip', 'column_wholesale_order_id', 'column_date_added', 'column_order_total', 'button_save', 'entry_payment_slip', 'entry_remark'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_upload_slip'),
            'href' => $this->url->link('wholesale/wholesale_order/upload_slip', 'user_token=' . $this->session->data['user_token'] . '&wholesale_order_id=' . $this->request->get['wholesale_order_id'] . $url, true)
        );

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if(isset($this->error['payment_slip'])){
            $data['error_payment_slip'] = $this->error['payment_slip'];
        } else{
            $data['error_payment_slip'] = NULL;
        }

        $data['action'] = $this->url->link('wholesale/wholesale_order/upload_slip', 'user_token=' . $this->session->data['user_token'] . '&wholesale_order_id=' . $this->request->get['wholesale_order_id'], true);
        $data['cancel'] = $this->url->link('wholesale/wholesale_order', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_upload_slip', $data));
    }

    protected function validateForm(){
        if (!$this->user->hasPermission('modify', 'wholesale/wholesale_order')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

        $img_allowed = array('gif','jpeg','png','jpg');

        if($this->request->files['payment_slip']['error'] == 0) {
			$img_filename = $this->request->files['payment_slip']['name'];
			$ext = pathinfo($img_filename,PATHINFO_EXTENSION);

			if(!in_array(strtolower($ext), $img_allowed)){
				$this->error['payment_slip'] = $this->language->get('error_imgformat');
			}
		} else{
            $this->error['payment_slip'] = $this->language->get('error_img');
        }

        //error
		if($this->error && !isset($this->error['warning'])){
			$this->error['warning'] = $this->language->get('error_warning');
        }

		return !$this->error;
    }

    private function totalData($etcm_wholesale_order_id){
        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $customer_data = $this->cart->get_customer_info();
        $cart_data = $this->cart->get_cart();
        $shipping_data = $this->cart->get_single_shipping_method();

        $customer_info = !empty($customer_data) ? $customer_data : [];
        $cart_products = !empty($cart_data['product']) ? $cart_data['product'] : [];
        $shipping_method = !empty($shipping_data) ? $shipping_data : [];

        $post_data['customer_info'] = base64_encode(json_encode($customer_info));
        $post_data['products'] = base64_encode(json_encode($cart_products));

        if(!empty($shipping_method)){
            $post_data['shipping_method'] = base64_encode(json_encode($shipping_method));
        }

        // echo '<pre>';
        // print_r($post_data);
        // echo '</pre>';

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/calculate_total_data&wholesale_order_id=' . $etcm_wholesale_order_id;

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);

        return $json;
    }
}
?>