<?php
class ControllerWholesaleWholesaleCatalog extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('wholesale/wholesale_catalog');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addStyle('view/stylesheet/modalbox.css');
        $this->document->addStyle('view/stylesheet/jquery.countdown.css');
        $this->document->addScript('view/javascript/jquery.plugin.js');
        $this->document->addScript('view/javascript/jquery.countdown.js');

        $this->load->model('wholesale/wholesale_catalog');

        // echo '<pre>';
        // print_r($this->session->data);
        // echo '</pre>';
        //
        // $this->load->library('wholesale_cart');
        // $this->cart = new Wholesale_cart($this->registry);
        //
        // $this->cart->clear();

        $this->getList();
    }

    protected function getList(){
        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = '';
        }

        if (isset($this->request->get['filter_product'])) {
			$filter_product = $this->request->get['filter_product'];
		} else {
			$filter_product = '';
		}

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

        $url = '';

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_product'])) {
            $url .= '&filter_product=' . str_replace(' ', '%20', $this->request->get['filter_product']);
        }

        $language_arr = ['heading_title', 'text_list', 'entry_filter_product', 'button_search_products', 'text_kg', 'button_add_to_cart', 'button_view_product', 'text_every', 'text_is_selling', 'text_product_code', 'text_close', 'entry_weight_quantity', 'text_promotion', 'button_quotation_price', 'text_selling_price', 'error_weight_quantity', 'button_view_shopping_cart', 'error_exceed_quantity', 'text_discount_off', 'text_comment_wholesale_products', 'button_comment_wholesale_products', 'text_success_add_wholesale_product_comment', 'text_failed_add_wholesale_product_comment', 'button_remove_search', 'text_not_found_products', 'text_search_suggestion', 'text_search_suggestion_1', 'text_search_suggestion_2', 'entry_filter_category', 'text_select'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

        $wholesale_catalog_url = HTTP_API . 'index.php?route=etcm/wholesale/get_products' . $url . '&language=' . $this->session->data['language'];

        $wholesale_catalog_json = file_get_contents($wholesale_catalog_url);

        $wholesale_catalog_arr = json_decode($wholesale_catalog_json, true);

        $today_date = date('Y-m-d');

        $product_catalog = [];

        if(!empty($wholesale_catalog_arr)){
            foreach($wholesale_catalog_arr as $index => $catalog){
                $special_price_switch = $catalog['special_price_switch'];
                $show_timer = 0;

                if($special_price_switch == '1'){
                    if(($catalog['special_date_start'] != '0000-00-00') && ($catalog['special_date_end'] != '0000-00-00')){
                        if(($today_date >= $catalog['special_date_start']) && ($today_date <= $catalog['special_date_end'])){
                            $show_timer = 1;
                        } else{
                            $special_price_switch = 0;
                        }
                    } else{
                        $special_price_switch = 1;
                    }
                }

                $product_catalog[$index] = [
                    'product_id'                => $catalog['product_id'],
                    'product_name'              => $catalog['product_name'],
                    'product_code'              => $catalog['product_code'],
                    'wholesale_product_id'      => $catalog['wholesale_product_id'],
                    'wholesale_price'           => $catalog['wholesale_price'],
                    'wholesale_price_unit'      => $catalog['wholesale_price_unit'],
                    'show_discount'             => (int)$special_price_switch,
                    'store_id'                  => $catalog['store_id'],
                    'tax_class_id'              => $catalog['tax_class_id'],
                    'weight_class_id'           => $catalog['weight_class_id'],
                    'weight_class_title'        => $catalog['weight_class_title'],
                    'weight_class_unit'         => $catalog['weight_class_unit'],
                    'image'                     => $catalog['image'],
                    'show_timer'                => $show_timer
                ];

                if($special_price_switch == 1){
                    $product_catalog[$index]['special_price'] = $catalog['special_price'];
                    $product_catalog[$index]['special_price_unit'] = $catalog['special_price_unit'];
                    $product_catalog[$index]['discount'] = $catalog['discount'];
                }

                if($show_timer == 1){
                    $deals_end_on_date = date('Y-m-d', strtotime($catalog['special_date_end'] . ' +1 day'));

                    $product_catalog[$index]['deals_end_on'] = $catalog['special_date_end'];
                    $product_catalog[$index]['deals_end_on_date'] = $deals_end_on_date;
                    $product_catalog[$index]['deals_end_on_year'] = date('Y', strtotime($deals_end_on_date));
                    $product_catalog[$index]['deals_end_on_month'] = date('m', strtotime($deals_end_on_date));
                    $product_catalog[$index]['deals_end_on_day'] = date('d', strtotime($deals_end_on_date));
                }
            }
        }

        $wholesale_price_column = array_column($product_catalog, 'wholesale_price');
        $show_discount_column = array_column($product_catalog, 'show_discount');
        $show_timer_column = array_column($product_catalog, 'show_timer');

        array_multisort($product_catalog, SORT_NUMERIC, $show_discount_column, SORT_DESC, $show_timer_column, SORT_DESC, $wholesale_price_column, SORT_ASC);

        $total_wholesale_catalog = count($product_catalog);

        $page = isset($this->request->get['page']) ? $this->request->get['page'] : '1';

        $catalog_products_settings = $this->get_wholesale_product_catalog_settings();
        $limit = $catalog_products_settings['products_per_page'];

        $offset = ($page - 1) * $limit;
        $data['wholesale_catalog'] = array_slice($product_catalog, $offset, $limit);

        $url = '';

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_product'])) {
            $url .= '&filter_product=' . $this->request->get['filter_product'];
        }

        $url = '';

        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_product'])) {
            $url .= '&filter_product=' . urlencode(html_entity_decode($this->request->get['filter_product'], ENT_QUOTES, 'UTF-8'));
        }

        $data['shopping_cart'] = $this->url->link('wholesale/wholesale_catalog/shopping_cart', 'user_token=' . $this->session->data['user_token'], true);
        $data['remove_search'] = $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['categories'] = [];

        $product_categories_url = HTTP_API . 'index.php?route=etcm/wholesale/get_product_categories';

        $product_categories_json = file_get_contents($product_categories_url);
        $product_categories_arr = json_decode($product_categories_json, true);

        if($product_categories_arr['error'] == 0){
            foreach($product_categories_arr['data'] as $category){
                $data['categories'][] = [
                    'category_id'       => $category['category_id'],
                    'category_name'     => $category['category_name']
                ];
            }
        }

        $data['countdown'] = rand(0, 5000) * rand(0, 5000);

        $pagination = new Pagination();
        $pagination->total = $total_wholesale_catalog;
        $pagination->page = $page;
        $pagination->limit = $limit;
        $pagination->url = $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['filter_category'] = $filter_category;
        $data['filter_product'] = $filter_product;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_catalog_list', $data));
    }

    private function get_wholesale_product_catalog_settings(){
		$setting_arr = [];

		$language = $this->session->data['language'];

		$settings_url = HTTP_API . 'index.php?route=etcm/wholesale/get_wholesale_product_catalog_settings';
		$setting_json = file_get_contents($settings_url);
		$setting_response_arr = json_decode($setting_json, true);

		if($setting_response_arr['error'] == '0'){
			$setting_arr = $setting_response_arr['data'];
		}

		return $setting_arr;
	}

    public function shopping_cart(){
        $this->load->language('wholesale/wholesale_catalog');
        $this->load->model('wholesale/wholesale_catalog');

        $this->document->setTitle($this->language->get('text_shopping_cart'));

        $this->document->addStyle('view/stylesheet/modalbox.css');

        $language_arr = ['heading_title', 'button_continue_shopping', 'text_shopping_cart', 'column_image', 'column_unit_price', 'column_total_price', 'column_product_name', 'column_product_code', 'column_weight_quantity', 'text_no_results', 'text_close', 'text_promotion', 'text_every', 'text_kg', 'text_product_code', 'text_is_selling', 'column_action', 'button_remove_from_cart', 'button_change_weight_quantity', 'entry_weight_quantity', 'error_weight_quantity', 'button_checkout', 'error_exceed_quantity', 'text_discount_off', 'text_comment_wholesale_products', 'button_comment_wholesale_products', 'text_failed_add_wholesale_product_comment', 'text_success_add_wholesale_product_comment'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_shopping_cart'),
            'href' => $this->url->link('wholesale/wholesale_catalog/shopping_cart', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->cart->reset_method();

        $cart_data = $this->cart->get_cart();

        $data['shopping_cart_list'] = !empty($cart_data['product']) ? $cart_data['product'] : [];

        $data['cart_total'] = $this->totalData();

        $data['user_token'] = $this->session->data['user_token'];

        $data['continue_shopping'] = $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_shopping_cart', $data));
    }

    public function checkout(){
        $this->load->language('wholesale/wholesale_catalog');
        $this->load->model('wholesale/wholesale_catalog');
        $this->load->model('localisation/country');

        $this->document->setTitle($this->language->get('text_checkout'));

        $language_arr = ['heading_title', 'button_cancel', 'text_checkout', 'tab_payment_address', 'tab_shipping_address', 'tab_shipping_method', 'tab_confirm_order', 'entry_payment_address', 'text_new_address', 'text_add_payment_address', 'entry_address_1', 'entry_address_2', 'entry_city', 'entry_postcode', 'entry_country', 'text_select', 'entry_zone', 'entry_name', 'entry_company', 'text_none', 'text_loading', 'button_continue', 'entry_same_with_shipping_address', 'text_yes', 'text_no', 'error_name', 'error_address_1', 'error_city', 'error_country', 'error_zone', 'error_same_with_shipping_address', 'entry_shipping_address', 'text_add_shipping_address', 'button_back', 'entry_shipping_method', 'text_select_shipping_method', 'error_shipping_method', 'error_payment_method', 'entry_shipping_remark', 'text_select_payment_method', 'error_shipping_address_form', 'error_payment_address_form', 'column_product_name', 'column_product_code', 'column_unit_price', 'column_total_price', 'column_weight_quantity', 'button_save', 'text_bank_transfer_instruction', 'text_bank_transfer_instruction_desc', 'tab_customer_information', 'entry_telephone', 'entry_email', 'error_telephone', 'error_customer_info_form', 'error_email', 'column_image', 'text_seller', 'column_seller', 'error_checkout_failed'];

        foreach ($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_shopping_cart'),
            'href' => $this->url->link('wholesale/wholesale_catalog/shopping_cart', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_checkout'),
            'href' => $this->url->link('wholesale/wholesale_catalog/checkout', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $cart_data = $this->cart->get_cart();

        $shopping_cart_list = !empty($cart_data['product']) ? $cart_data['product'] : [];

        if(empty($shopping_cart_list)){
            $this->response->redirect($this->url->link('wholesale/wholesale_catalog', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['buyer_address_list'] = $this->get_buyer_address();

        $buyer_information = $this->get_buyer_information();

        if(!empty($buyer_information)){
            $data['customer_name'] = !empty($buyer_information['customer_name']) ? $buyer_information['customer_name'] : '';
            $data['customer_telephone'] = !empty($buyer_information['customer_telephone']) ? $buyer_information['customer_telephone'] : '';
            $data['customer_email'] = !empty($buyer_information['customer_email']) ? $buyer_information['customer_email'] : '';
        } else{
            $data['customer_name'] = '';
            $data['customer_telephone'] = '';
            $data['customer_email'] = '';
        }

        $entry_arr = ['payment_address_1', 'payment_address_2', 'payment_city', 'payment_postcode', 'payment_company', 'payment_name', 'shipping_name', 'shipping_company', 'shipping_postcode', 'shipping_address_1', 'shipping_city', 'shipping_address_2'];

        foreach($entry_arr as $entry){
            if(isset($this->request->post[$entry])){
                $data[$entry] = $this->request->post[$entry];
            } else{
                $data[$entry] = '';
            }
        }

        $data['countries'] = $this->model_localisation_country->getCountries();

        $data['action'] = $this->url->link('wholesale/wholesale_catalog/checkout', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('wholesale/wholesale_catalog/shopping_cart', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('wholesale/wholesale_checkout', $data));
    }

    public function view_product_details(){
        $json = [];
        $product_results = [];

        if(isset($this->request->post['wholesale_product_id'])){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];

            $product_info = $this->get_product_details($wholesale_product_id);

            $today_date = date('Y-m-d');

            $special_price_switch = $product_info['special_price_switch'];
            $show_timer = 0;

            if($special_price_switch == '1'){
                if(($product_info['special_date_start'] != '0000-00-00') && ($product_info['special_date_end'] != '0000-00-00')){
                    if(($today_date >= $product_info['special_date_start']) && ($today_date <= $product_info['special_date_end'])){
                        $show_timer = 1;
                    } else{
                        $special_price_switch = 0;
                    }
                } else{
                    $special_price_switch = 1;
                }
            }

            $product_results = [
                'product_id'                => $product_info['product_id'],
                'product_name'              => $product_info['product_name'],
                'product_code'              => $product_info['product_code'],
                'product_description'       => $product_info['product_description'],
                'wholesale_product_id'      => $product_info['wholesale_product_id'],
                'wholesale_price'           => $product_info['wholesale_price'],
                'wholesale_price_unit'      => $product_info['wholesale_price_unit'],
                'show_discount'             => (int)$special_price_switch,
                'store_id'                  => $product_info['store_id'],
                'tax_class_id'              => $product_info['tax_class_id'],
                'weight_class_id'           => $product_info['weight_class_id'],
                'weight_class_title'        => $product_info['weight_class_title'],
                'weight_class_unit'         => $product_info['weight_class_unit'],
                'image'                     => $product_info['image'],
                'show_timer'                => $show_timer
            ];

            if($special_price_switch == 1){
                $product_results['special_price'] = $product_info['special_price'];
                $product_results['special_price_unit'] = $product_info['special_price_unit'];
                $product_results['discount'] = $product_info['discount'];
            }

            if($show_timer == 1){
                $product_results['deals_end_on'] = $product_info['special_date_end'];
            }

            $json = [
                'error'     => 0,
                'data'      => $product_results,
                'message'   => 'get product details success'
            ];
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function calculate_price(){
        $json = [];
        $product_price_arr = [];

        if(isset($this->request->post)){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];
            $weight_quantity = $this->request->post['weight_to_buy'];

            $return_data = $this->cart_calculate_price($wholesale_product_id, $weight_quantity);

            if($return_data['error'] == '0'){
                $data_results = $return_data['data'];

                $product_price_arr = [
                    'calculated_price_unit'     => $data_results['calculated_price_unit']
                ];

                $json = [
                    'error'     => 0,
                    'data'      => $product_price_arr,
                    'message'   => 'get product price success'
                ];
            } else{
                if($return_data['code'] == 'quantity'){
                    $json = [
                        'error'     => 1,
                        'code'      => 'quantity',
                        'message'   => 'exceed quantity available'
                    ];
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function add_wholesale_product_comment(){
        $json = [];

        $this->load->model('user/user');

        $user_id = $this->session->data['user_id'];
        $user_info = $this->model_user_user->getUser($user_id);

        if(isset($this->request->post) && !empty($user_info)){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];
            $comment = $this->request->post['comment'];

            $api_url = HTTP_API . 'index.php?route=etcm/wholesale/add_wholesale_product_comment';

            $post_data = [
                'wholesale_product_id'  => $wholesale_product_id,
                'comment'               => $comment,
                'hosting'               => HTTP_CATALOG,
                'user_id'               => $user_id,
                'firstname'             => $user_info['firstname'],
                'lastname'              => $user_info['lastname'],
                'chinesename'           => $user_info['chinesename']
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $json = json_decode($result, true);

            if($json['error'] == '0'){
                $json = [
                    'error'     => 0,
                    'message'   => 'add wholesale product comment success'
                ];
            } else{
                $json = [
                    'error'     => 1,
                    'message'   => 'failed to add wholesale product comment'
                ];
            }
        } else{
            $json = [
                'error'     => 1,
                'code'      => 'post',
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function add_to_cart(){
        $json = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];
            $weight_quantity = $this->request->post['weight_quantity'];

            // get all the products from the shopping cart
            $products_cart = $this->cart->get_cart();

            if(isset($products_cart['product'][$wholesale_product_id])){
                $weight_quantity_cart = $products_cart['product'][$wholesale_product_id]['weight_quantity'];

                $weight_quantity += $weight_quantity_cart;
            }

            $this->cart->set_domain(HTTPS_CATALOG);

            $json_calculated_price = $this->cart_calculate_price($wholesale_product_id, $weight_quantity);

            if($json_calculated_price['error'] == '0'){
                $calculated_data = $json_calculated_price['data'];

                $added_product = $this->cart->add_to_cart($wholesale_product_id, $calculated_data);

                $json = [
                    'error'     => 0,
                    'data'      => $added_product,
                    'message'   => 'add to cart success'
                ];
            } else{
                $json = $json_calculated_price;
            }
        } else{
            $json = [
                'error'     => 1,
                'code'      => 'post',
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function remove_from_cart(){
        $json = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];

            $this->cart->remove_from_cart($wholesale_product_id);

            $products = $this->cart->get_cart();

            $json = [
                'error'     => 0,
                'message'   => 'remove from cart success'
            ];
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function edit_quantity(){
        $json = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $wholesale_product_id = $this->request->post['wholesale_product_id'];
            $weight_quantity = $this->request->post['weight_quantity'];

            $json_calculated_price = $this->cart_calculate_price($wholesale_product_id, $weight_quantity);

            if($json_calculated_price['error'] == '0'){
                $calculated_data = $json_calculated_price['data'];

                $edited_product = $this->cart->add_to_cart($wholesale_product_id, $calculated_data);

                $json = [
                    'error'     => 0,
                    'data'      => $edited_product,
                    'message'   => 'edit product quantity success'
                ];
            } else{
                $json = $json_calculated_price;
            }
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function load_shopping_cart(){
        $json = [];
        $results = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $cart_data = $this->cart->get_cart();

        if(!empty($cart_data['product'])){
            foreach($cart_data['product'] as $index => $cart){
                $results['product'][] = $cart;
            }
        } else{
            $results['product'] = [];
        }

        $results['total'] = $this->totalData();

        $json = [
            'error'     => 0,
            'data'      => $results,
            'message'   => 'get cart success'
        ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function customer_info_submit(){
        $json = [];

        $this->load->language('wholesale/wholesale_catalog');

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            if(empty($this->validateCustomerInfoForm($this->request->post))){
                $customer_info = $this->cart->add_customer_info($this->request->post);

                $json = [
                    'error'     => 0,
                    'data'      => $customer_info,
                    'message'   => 'add customer info success'
                ];
            } else{
                $error_message = $this->validateCustomerInfoForm($this->request->post);

                $json = [
                    'error'         => 1,
                    'error_data'    => $error_message,
                    'message'       => 'cannot get post data'
                ];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function payment_address_submit(){
        $json = [];

        $this->load->language('wholesale/wholesale_catalog');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $same_with_shipping_address = $this->request->post['same_with_shipping_address'];

            $this->cart->set_address_type($same_with_shipping_address);

            if(isset($this->request->post['payment_address_id'])){
                // if can select the address
                $payment_address_id = $this->request->post['payment_address_id'];

                if($payment_address_id == 'new'){
                    // if the buyer select to create new address, check the form validation
                    if(empty($this->validatePaymentAddressForm($this->request->post))){
                        $payment_country_id = $this->request->post['payment_country'];
                        $payment_zone_id = $this->request->post['payment_zone'];

                        $payment_country_info = $this->model_localisation_country->getCountry($payment_country_id);
                        $payment_zone_info = $this->model_localisation_zone->getZone($payment_zone_id);

                        $payment_country_name = !empty($payment_country_info) ? $payment_country_info['name'] : '';
                        $payment_zone_name = !empty($payment_zone_info) ? $payment_zone_info['name'] : '';

                        // form validation done and no error message found
                        $address_to_insert = [
                            'company'       => $this->request->post['payment_company'],
                            'name'          => $this->request->post['payment_name'],
                            'address_1'     => $this->request->post['payment_address_1'],
                            'address_2'     => $this->request->post['payment_address_2'],
                            'city'          => $this->request->post['payment_city'],
                            'postcode'      => $this->request->post['payment_postcode'],
                            'country_id'    => $payment_country_id,
                            'country_name'  => $payment_country_name,
                            'zone_id'       => $payment_zone_id,
                            'zone_name'     => $payment_zone_name,
                        ];

                        $payment_address = $this->cart->set_payment_address($address_to_insert);

                        if($same_with_shipping_address == '1'){
                            // shipping address same with payment address
                            // set the shipping address directly
                            $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                            $json = [
                                'error'                 => 0,
                                'go_shipping_method'    => 1,
                                'payment_address'       => $payment_address,
                                'shipping_address'      => $shipping_address,
                                'message'               => 'add the payment address and shipping address success'
                            ];
                        } else{
                            $json = [
                                'error'                 => 0,
                                'go_shipping_method'    => 0,
                                'payment_address'       => $payment_address,
                                'message'               => 'add the payment address success'
                            ];
                        }
                    } else{
                        // got error
                        $error_message = $this->validatePaymentAddressForm($this->request->post);

                        $json = [
                            'error'         => 1,
                            'error_data'    => $error_message,
                            'message'       => 'cannot get post data'
                        ];
                    }
                } else{
                    // if the buyer select one of the addresses listed
                    $address_result = $this->get_address($payment_address_id);

                    if($address_result['error'] == '0'){
                        $address_data = $address_result['data'];

                        $address_to_insert = [
                            'company'       => $address_data['company'] . ' ' . $address_data['company_en'],
                            'name'          => $address_data['name'],
                            'address_1'     => $address_data['address_1'],
                            'address_2'     => $address_data['address_2'],
                            'city'          => $address_data['city'],
                            'postcode'      => $address_data['postcode'],
                            'country_id'    => $address_data['country_id'],
                            'country_name'  => $address_data['country_name'],
                            'zone_id'       => $address_data['zone_id'],
                            'zone_name'     => $address_data['zone_name'],
                        ];

                        $payment_address = $this->cart->set_payment_address($address_to_insert);

                        if($same_with_shipping_address == '1'){
                            // shipping address same with payment address
                            // set the shipping address directly
                            $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                            $json = [
                                'error'                 => 0,
                                'go_shipping_method'    => 1,
                                'payment_address'       => $payment_address,
                                'shipping_address'      => $shipping_address,
                                'message'               => 'add the payment address and shipping address success'
                            ];
                        } else{
                            $json = [
                                'error'                 => 0,
                                'go_shipping_method'    => 0,
                                'payment_address'       => $payment_address,
                                'message'               => 'add the payment address success'
                            ];
                        }
                    }
                }
            } else{
                // the form didn't provide the input of select address, then validate the form
                if(empty($this->validatePaymentAddressForm($this->request->post))){
                    $payment_country_id = $this->request->post['payment_country'];
                    $payment_zone_id = $this->request->post['payment_zone'];

                    $payment_country_info = $this->model_localisation_country->getCountry($payment_country_id);
                    $payment_zone_info = $this->model_localisation_zone->getZone($payment_zone_id);

                    $payment_country_name = !empty($payment_country_info) ? $payment_country_info['name'] : '';
                    $payment_zone_name = !empty($payment_zone_info) ? $payment_zone_info['name'] : '';

                    // form validation done and no error message found
                    $address_to_insert = [
                        'company'       => $this->request->post['payment_company'],
                        'name'          => $this->request->post['payment_name'],
                        'address_1'     => $this->request->post['payment_address_1'],
                        'address_2'     => $this->request->post['payment_address_2'],
                        'city'          => $this->request->post['payment_city'],
                        'postcode'      => $this->request->post['payment_postcode'],
                        'country_id'    => $payment_country_id,
                        'country_name'  => $payment_country_name,
                        'zone_id'       => $payment_zone_id,
                        'zone_name'     => $payment_zone_name,
                    ];

                    $payment_address = $this->cart->set_payment_address($address_to_insert);

                    if($same_with_shipping_address == '1'){
                        // shipping address same with payment address
                        // set the shipping address directly
                        $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                        $json = [
                            'error'                 => 0,
                            'go_shipping_method'    => 1,
                            'payment_address'       => $payment_address,
                            'shipping_address'      => $shipping_address,
                            'message'               => 'add the payment address and shipping address success'
                        ];
                    } else{
                        $json = [
                            'error'                 => 0,
                            'go_shipping_method'    => 0,
                            'payment_address'       => $payment_address,
                            'message'               => 'add the payment address success'
                        ];
                    }
                } else{
                    // got error
                    $error_message = $this->validatePaymentAddressForm($this->request->post);

                    $json = [
                        'error'         => 1,
                        'error_data'    => $error_message,
                        'message'       => 'cannot get post data'
                    ];
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function shipping_address_submit(){
        $json = [];

        $this->load->language('wholesale/wholesale_catalog');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            if(isset($this->request->post['shipping_address_id'])){
                // if can select the address
                $shipping_address_id = $this->request->post['shipping_address_id'];

                if($shipping_address_id == 'new'){
                    // if the buyer select to create new address, check the form validation
                    if(empty($this->validateShippingAddressForm($this->request->post))){
                        $shipping_country_id = $this->request->post['shipping_country'];
                        $shipping_zone_id = $this->request->post['shipping_zone'];

                        $shipping_country_info = $this->model_localisation_country->getCountry($shipping_country_id);
                        $shipping_zone_info = $this->model_localisation_zone->getZone($shipping_zone_id);

                        $shipping_country_name = !empty($shipping_country_info) ? $shipping_country_info['name'] : '';
                        $shipping_zone_name = !empty($shipping_zone_info) ? $shipping_zone_info['name'] : '';

                        // form validation done and no error message found
                        $address_to_insert = [
                            'company'       => $this->request->post['shipping_company'],
                            'name'          => $this->request->post['shipping_name'],
                            'address_1'     => $this->request->post['shipping_address_1'],
                            'address_2'     => $this->request->post['shipping_address_2'],
                            'city'          => $this->request->post['shipping_city'],
                            'postcode'      => $this->request->post['shipping_postcode'],
                            'country_id'    => $shipping_country_id,
                            'country_name'  => $shipping_country_name,
                            'zone_id'       => $shipping_zone_id,
                            'zone_name'     => $shipping_zone_name,
                        ];

                        $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                        $json = [
                            'error'                 => 0,
                            'shipping_address'      => $shipping_address,
                            'message'               => 'add the shipping address success'
                        ];
                    } else{
                        // got error
                        $error_message = $this->validateShippingAddressForm($this->request->post);

                        $json = [
                            'error'         => 1,
                            'error_data'    => $error_message,
                            'message'       => 'cannot get post data'
                        ];
                    }
                } else{
                    // if the buyer select one of the addresses listed
                    $address_result = $this->get_address($shipping_address_id);

                    if($address_result['error'] == '0'){
                        $address_data = $address_result['data'];

                        $address_to_insert = [
                            'company'       => $address_data['company'] . ' ' . $address_data['company_en'],
                            'name'          => $address_data['name'],
                            'address_1'     => $address_data['address_1'],
                            'address_2'     => $address_data['address_2'],
                            'city'          => $address_data['city'],
                            'postcode'      => $address_data['postcode'],
                            'country_id'    => $address_data['country_id'],
                            'country_name'  => $address_data['country_name'],
                            'zone_id'       => $address_data['zone_id'],
                            'zone_name'     => $address_data['zone_name'],
                        ];

                        $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                        $json = [
                            'error'                 => 0,
                            'shipping_address'      => $shipping_address,
                            'message'               => 'add the shipping address success'
                        ];
                    }
                }
            } else{
                // the form didn't provide the input of select address, then validate the form
                if(empty($this->validateShippingAddressForm($this->request->post))){
                    $shipping_country_id = $this->request->post['shipping_country'];
                    $shipping_zone_id = $this->request->post['shipping_zone'];

                    $shipping_country_info = $this->model_localisation_country->getCountry($shipping_country_id);
                    $shipping_zone_info = $this->model_localisation_zone->getZone($shipping_zone_id);

                    $shipping_country_name = !empty($shipping_country_info) ? $shipping_country_info['name'] : '';
                    $shipping_zone_name = !empty($shipping_zone_info) ? $shipping_zone_info['name'] : '';

                    // form validation done and no error message found
                    $address_to_insert = [
                        'company'       => $this->request->post['shipping_company'],
                        'name'          => $this->request->post['shipping_name'],
                        'address_1'     => $this->request->post['shipping_address_1'],
                        'address_2'     => $this->request->post['shipping_address_2'],
                        'city'          => $this->request->post['shipping_city'],
                        'postcode'      => $this->request->post['shipping_postcode'],
                        'country_id'    => $shipping_country_id,
                        'country_name'  => $shipping_country_name,
                        'zone_id'       => $shipping_zone_id,
                        'zone_name'     => $shipping_zone_name,
                    ];

                    $shipping_address = $this->cart->set_shipping_address($address_to_insert);

                    $json = [
                        'error'                 => 0,
                        'shipping_address'      => $shipping_address,
                        'message'               => 'add the shipping address success'
                    ];
                } else{
                    // got error
                    $error_message = $this->validateShippingAddressForm($this->request->post);

                    $json = [
                        'error'         => 1,
                        'error_data'    => $error_message,
                        'message'       => 'cannot get post data'
                    ];
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function select_shipping_method(){
        $json = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $shipping_method = $this->request->post['shipping_method'];
            $shipping_remark = $this->request->post['shipping_remark'];

            $shipping_methods = $this->get_shipping_method_internal();

            if(!empty($shipping_methods)){
                foreach($shipping_methods as $store_id => $methods){
                    foreach($methods['shipping_methods'] as $method){
                        $quote = $method['quote'];

                        foreach($quote as $code => $quote_row){
                            if($quote_row['code'] == $shipping_method[$store_id]){
                                $this->cart->set_shipping_method($quote_row, $shipping_remark[$store_id], $store_id);

                                $api_url = HTTP_API . 'index.php?route=etcm/wholesale/set_shipping_method';

                                $post_data = [
                                    'shipping_method'       => base64_encode(json_encode($quote_row)),
                                    'shipping_remark'       => $shipping_remark[$store_id],
                                    'store_id'              => $store_id
                                ];

                                $ch = curl_init();
                                curl_setopt($ch, CURLOPT_URL, $api_url);
                                curl_setopt($ch, CURLOPT_POST, true);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                                $result = curl_exec($ch);

                                curl_close($ch);

                                $result_arr = json_decode($result, true);

                                if($result_arr['error'] == 0){
                                    $shipping_method_result = $result_arr['data'];

                                    $json = [
                                        'error'     => 0,
                                        'data'      => $shipping_method_result,
                                        'message'   => 'select shipping method success'
                                    ];
                                }
                            }
                        }
                    }
                }
            }
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function select_payment_method(){
        $this->load->language('wholesale/wholesale_catalog');

        $json = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        if(isset($this->request->post)){
            $payment_method = $this->request->post['payment_method'];

            if($payment_method == 'bank_transfer'){
                $instruction = $this->get_bank_transfer_instruction() . '<br /><br />' . $this->language->get('text_bank_transfer_shipment');
                $instruction2 = $this->language->get('text_bank_transfer_instruction') . ':<br /><br />' . $this->get_bank_transfer_instruction() . '<br /><br />' . $this->language->get('text_bank_transfer_shipment');
            }

            $payment_arr = [
                'payment_name'      => $this->language->get('text_' . $payment_method),
                'payment_code'      => $payment_method,
                'comment'           => $instruction2,
                'instruction'       => $instruction
            ];

            $payment_method_result = $this->cart->set_payment_method($payment_arr);

            $json = [
                'error'     => 0,
                'data'      => $payment_method_result,
                'message'   => 'select payment method success'
            ];
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function order_confirm(){
        $json = [];
        $order_arr = [];
        $product_results = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $products = $this->cart->get_cart();
        $payment_method_arr = $this->cart->get_payment_method();

        if(!empty($products['product'])){
            foreach($products['product'] as $wholesale_product_id => $product){
                $product_results[] = $product;
            }

            $total_results = $this->totalData();

            $order_arr = [
                'products'                  => $product_results,
                'total'                     => $total_results,
                'bank_transfer_instruction' => nl2br($payment_method_arr['instruction'])
            ];

            $json = [
                'error'     => 0,
                'data'      => $order_arr,
                'message'   => 'get checkout product success'
            ];
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'no product found'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function checkout_order(){
        $this->load->language('wholesale/wholesale_catalog');

        $this->load->model('wholesale/wholesale_catalog');
    
		$final_response = [];        
        $json = [];
        $post_data = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $customer_info = $this->cart->get_customer_info();

        $products_in_cart = $this->cart->get_cart();
        $products = !empty($products_in_cart['product']) ? $products_in_cart['product'] : [];

        $products_by_store = [];

        foreach($products as $product){
            $products_by_store[$product['store_id']][] = $product;
        }

        foreach($products_by_store as $store_id => $products){
            $subtotal[$store_id] = 0;
            $tax[$store_id] = 0;
            $total[$store_id] = 0;

            foreach($products as $product){
                $tax_code = $this->tax->getClassCode($product['tax_class_id']);

                $tax_format_row = $this->model_wholesale_wholesale_catalog->get_tax_format($product['tax_class_id'], $tax_code);
                $tax_format = !empty($tax_format_row) ? $tax_format_row['format'] : '';

                $product_to_post[$store_id][] = [
                    'etcm_product_id'           => $product['etcm_product_id'],
                    'product_id'                => $product['product_id'],
                    'image'                     => $product['image'],
                    'product_name'              => $product['product_name'],
                    'product_code'              => $product['product_code'],
                    'tax_class_id'              => $product['tax_class_id'],
                    'tax_code'                  => $tax_code,
                    'tax_format'                => $tax_format,
                    'unit_price'                => $product['unit_price'],
                    'unit_price_unit'           => $product['unit_price_unit'],
                    'unit_price_without_tax'    => $product['unit_price_without_tax'],
                    'weight_quantity'           => $product['weight_quantity'],
                    'weight_class_unit'         => $product['weight_class_unit'],
                    'calculated_price'          => $product['calculated_price'],
                    'calculated_price_unit'     => $product['calculated_price_unit'],
                    'total_price_without_tax'   => $product['calculated_price_without_tax'],
                    'wholesale_product_id'      => $product['wholesale_product_id'],
                    'etcm_product_id'           => $product['etcm_product_id'],
                    'store_id'                  => $product['store_id']
                ];

                $tax_value = $product['calculated_price'] - $product['calculated_price_without_tax'];

                $subtotal[$store_id] += $product['calculated_price_without_tax'];
                $tax[$store_id] += $tax_value;
                $total[$store_id] += $product['calculated_price'];
            }
        }

        $payment_address = $this->cart->get_payment_address();
        $shipping_address = $this->cart->get_shipping_address();

        $payment_method = $this->cart->get_payment_method();
        $shipping_method = $this->cart->get_shipping_method();

        foreach($shipping_method as $store_id => $method){
            if($method['cost'] > 0){
                $shipping_tax_value = $this->tax->getTax($method['cost'], $method['tax_class_id']);
                $shipping_total_value = $method['cost'] + $shipping_tax_value;

                $subtotal[$store_id] += $method['cost'];
                $tax[$store_id] += $shipping_tax_value;
                $total[$store_id] += $shipping_total_value;
            }
        }

        $total_data = $this->totalData();

        $currency_data = [
            'language_id'       => $this->config->get('config_language_id'),
            'currency_id'       => $this->config->get('config_currency_id'),
            'currency_code'     => $this->config->get('config_currency_code'),
            'currency_value'    => $this->config->get('config_currency_value'),
            'subtotal'          => $subtotal,
            'tax'               => $tax,
            'total'             => $total
        ];

        $customer_info['hosting'] = HTTP_CATALOG;

		$api_url = HTTP_API . 'index.php?route=etcm/wholesale/checkout_order';

        $post_data = [
            'customer_info'             => $customer_info,
            'products'                  => $product_to_post,
            'payment_address'           => $payment_address,
            'shipping_address'          => $shipping_address,
            'payment_method'            => $payment_method,
            'shipping_method'           => $shipping_method,
            'total'                     => $total_data,
            'currency_data'             => $currency_data
        ];

        $post_data_encoded = [];

        foreach($post_data as $code => $data){
            $post_data_encoded[$code] = base64_encode(json_encode($data));
        }

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data_encoded);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);
		
        if($json['error'] == 0){
            $etcm_wholesale_order_id = $json['data']['etcm_wholesale_order_id'];

            $wholesale_order_id = $this->model_wholesale_wholesale_catalog->add_wholesale_order($post_data, $etcm_wholesale_order_id);

            if($wholesale_order_id > 0){
                $update_wholesale_order_id_api_url = HTTP_API . 'index.php?route=etcm/wholesale/update_wholesale_order_id';

                $wholesale_order_id_post_data = [
                    'etcm_wholesale_order_id'   => $etcm_wholesale_order_id,
                    'wholesale_order_id'        => $wholesale_order_id
                ];

                $ch = curl_init();
        		curl_setopt($ch, CURLOPT_URL, $update_wholesale_order_id_api_url);
        		curl_setopt($ch, CURLOPT_POST, true);
        		curl_setopt($ch, CURLOPT_POSTFIELDS, $wholesale_order_id_post_data);
        		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        		$result = curl_exec($ch);

        		curl_close($ch);

                $json = json_decode($result, true);

                if($json['error'] == '0'){
                    $this->cart->clear();
                }
            }
			
			$this->session->data['success'] = $this->language->get('text_checkout_success');
			
			$final_response = [
				'error'		=> 0,
				'message'	=> 'add wholesale order success'
			];
        } else {
			$final_response = [
				'error'		=> 1,
				'message'	=> 'failed to add wholesale order'
			];
		}
    
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($final_response));
    }

    public function back_to_address_tab(){
        $json = [];

        if(isset($this->session->data['wholesale']['address_type'])){
            $address_type = $this->session->data['wholesale']['address_type'];

            if($address_type == '1'){
                $json = [
                    'error'     => 0,
                    'tab'       => 'tab-payment-address',
                    'message'   => 'back to address tab success'
                ];
            } else{
                $json = [
                    'error'     => 0,
                    'tab'       => 'tab-shipping-address',
                    'message'   => 'back to address tab success'
                ];
            }
        } else{
            $json = [
                'error'         => 1,
                'message'       => 'cannot back to address tab'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function get_shipping_method(){
        $json = [];
        $shipping_method_returns = [];
        $post_data = [];

        $this->load->model('wholesale/wholesale_catalog');

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $products_in_cart = $this->cart->get_cart();

        // declaration
        $products = !empty($products_in_cart['product']) ? $products_in_cart['product'] : [];
        $shipping_address = base64_encode(json_encode($this->cart->get_shipping_address()));

        $products_encoded = !empty($products) ? base64_encode(json_encode($products)) : '';

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_wholesaler_shipping_method';

        $post_data = [
            'products'                  => $products_encoded,
            'shipping_address'          => $shipping_address
        ];

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

        curl_close($ch);

        $result_arr = json_decode($result, true);

        if($result_arr['error'] == '0'){
            $shipping_method_results = $result_arr['data'];

            foreach($products_in_cart['product'] as $product){
                $shipping_method_returns[$product['store_id']]['products'][] = $product;
            }

            foreach($shipping_method_results as $store_id => $method){
                $shipping_method_returns[$store_id]['shipping_methods'] = $method;
                $shipping_method_returns[$store_id]['store_name'] = $method['store_name'];
            }

            $json = [
                'error'     => 0,
                'data'      => $shipping_method_returns,
                'message'   => 'get shipping method success'
            ];
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'api not respond'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function get_shipping_method_internal(){
        $shipping_methods = [];
        $post_data = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $products_in_cart = $this->cart->get_cart();

        // declaration
        $products = !empty($products_in_cart['product']) ? $products_in_cart['product'] : [];

        $shipping_address = base64_encode(json_encode($this->cart->get_shipping_address()));

        $products_encoded = !empty($products) ? base64_encode(json_encode($products)) : '';

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_wholesaler_shipping_method';

        $post_data = [
            'products'                  => $products_encoded,
            'shipping_address'          => $shipping_address
        ];

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

        curl_close($ch);

        $result_arr = json_decode($result, true);

        if($result_arr['error'] == '0'){
            $shipping_methods = $result_arr['data'];
        }

        return $shipping_methods;
    }

    private function get_bank_transfer_instruction(){
        $post_data = [];
        $instructions = [];

        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $products = $this->cart->get_cart();
        $cart_products = $products['product'];

        if(!empty($cart_products)){
            $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_wholesaler_bank_transfer_instruction';

            $post_data = [
                'language'                  => $this->session->data['language']
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            curl_close($ch);

            $result_arr = json_decode($result, true);

            if($result_arr['error'] == '0'){
                $instructions = $result_arr['data'];
            }
        }

        return $instructions;
    }

    protected function validateCustomerInfoForm($data){
        $error_arr = [];

        if(empty($data['customer_name'])){
            $error_arr['customer_name'] = $this->language->get('error_name');
        }

        if(empty($data['customer_telephone'])){
            $error_arr['customer_telephone'] = $this->language->get('error_telephone');
        }

        if(!empty($data['customer_email'])){
            if (!preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $data['customer_email'])) {
    			$error_arr['customer_email'] = $this->language->get('error_email');
    		}
        }

        return $error_arr;
    }

    protected function validatePaymentAddressForm($data){
        $error_arr = [];

        if(empty($data['payment_name'])){
			$error_arr['payment_name'] = $this->language->get('error_name');
		}

        if(empty($data['payment_address_1'])){
            $error_arr['payment_address_1'] = $this->language->get('error_address_1');
        }

        if(empty($data['payment_city'])){
            $error_arr['payment_city'] = $this->language->get('error_city');
        }

        if(empty($data['payment_country'])){
            $error_arr['payment_country'] = $this->language->get('error_country');
        }

        if(empty($data['payment_zone'])){
            $error_arr['payment_zone'] = $this->language->get('error_zone');
        }

		return $error_arr;
    }

    protected function validateShippingAddressForm($data){
        $error_arr = [];

        if(empty($data['shipping_name'])){
			$error_arr['shipping_name'] = $this->language->get('error_name');
		}

        if(empty($data['shipping_address_1'])){
            $error_arr['shipping_address_1'] = $this->language->get('error_address_1');
        }

        if(empty($data['shipping_city'])){
            $error_arr['shipping_city'] = $this->language->get('error_city');
        }

        if(empty($data['shipping_country'])){
            $error_arr['shipping_country'] = $this->language->get('error_country');
        }

        if(empty($data['shipping_zone'])){
            $error_arr['shipping_zone'] = $this->language->get('error_zone');
        }

		return $error_arr;
    }

    private function get_product_details($wholesale_product_id){
        $result = [];

        $url = HTTP_API . 'index.php?route=etcm/wholesale/get_product_details&wholesale_product_id=' . (int)$wholesale_product_id . '&language=' . $this->session->data['language'];

        $json_product_info = file_get_contents($url);
        $arr_product_info = json_decode($json_product_info, true);

        if($arr_product_info['error'] == '0'){
            $result = $arr_product_info['data'];
        }

        return $result;
    }

    private function cart_calculate_price($wholesale_product_id, $weight_quantity){
        $json = [];

        $post_data = [];

		$api_url = HTTP_API . 'index.php?route=etcm/wholesale/calculate_price';

        $post_data = [
            'language'                  => $this->session->data['language'],
            'wholesale_product_id'      => $wholesale_product_id,
            'weight_to_buy'             => $weight_quantity
        ];

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);

        return $json;
    }

    private function get_buyer_information(){
        $json = [];
        $buyer_information = [];
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_buyer_information';

        $post_data = [
            'hosting'           => HTTP_CATALOG
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        $json = json_decode($result, true);

        if($json['error'] == '0'){
            $buyer_information = $json['data'];
        }

        return $buyer_information;
    }

    private function get_buyer_address(){
        $json = [];
        $addresses = [];
        $post_data = [];

		$api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_buyer_addresses';

        $post_data = [
            'hosting'           => HTTP_CATALOG
        ];

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);

        if($json['error'] == '0'){
            if(!empty($json['data'])){
                foreach($json['data'] as $address){
                    $address_1 = !empty($address['address_1']) ? $address['address_1'] . ', ' : '';
                    $address_2 = !empty($address['address_2']) ? $address['address_2'] . ', ' : '';
                    $postcode = !empty($address['postcode']) ? $address['postcode'] . ' ' : '';
                    $city = !empty($address['city']) ? $address['city'] . ', ' : '';
                    $zone_name = !empty($address['zone_name']) ? $address['zone_name'] . ', ' : '';
                    $country_name = !empty($address['country_name']) ? $address['country_name'] . '.' : '';

                    $full_address = $address_1 . $address_2 . $postcode . $city . $zone_name . $country_name;

                    $addresses[] = [
                        'address_id'        => $address['address_id'],
                        'name'              => $address['name'],
                        'company'           => $address['company'],
                        'address_1'         => $address['address_1'],
                        'address_2'         => $address['address_2'],
                        'postcode'          => $address['postcode'],
                        'city'              => $address['city'],
                        'country_id'        => $address['country_id'],
                        'country_name'      => $address['country_name'],
                        'zone_id'           => $address['zone_id'],
                        'zone_name'         => $address['zone_name'],
                        'full_address'      => $full_address
                    ];
                }
            }
        }

        return $addresses;
    }

    private function get_address($address_id){
        $json = [];

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/get_address';

        $post_data = [
            'address_id'        => $address_id
        ];

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);

        return $json;
    }

    private function totalData(){
        $this->load->library('wholesale_cart');
        $this->cart = new Wholesale_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $customer_data = $this->cart->get_customer_info();
        $cart_data = $this->cart->get_cart();
        $shipping_data = $this->cart->get_shipping_method();

        $customer_info = !empty($customer_data) ? $customer_data : [];
        $cart_products = !empty($cart_data['product']) ? $cart_data['product'] : [];
        $shipping_methods = !empty($shipping_data) ? $shipping_data : [];

        $post_data['customer_info'] = base64_encode(json_encode($customer_info));
        $post_data['products'] = base64_encode(json_encode($cart_products));

        if(!empty($shipping_methods)){
            $post_data['shipping_methods'] = base64_encode(json_encode($shipping_methods));
        }

        // echo '<pre>';
        // print_r($post_data);
        // echo '</pre>';

        $api_url = HTTP_API . 'index.php?route=etcm/wholesale/calculate_total_data';

        $ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$result = curl_exec($ch);

		curl_close($ch);

        $json = json_decode($result, true);

        return $json;
    }
}
?>