<?php

class ControllerSettingStoreOpening extends Controller
{

    private $error = [];

    public function index()
    {
        $this->load->language('setting/store_opening');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_opening');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('setting/store_opening');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_opening');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $store_opening_time = $this->model_setting_store_opening->addStoreOpening($this->request->post);

            $api_data = [
                'store_url' => HTTP_CATALOG,
                'store_opening_time' => $store_opening_time,
                'day' => $this->request->post['day']
            ];

            // $api_response = json_decode($this->etcm_save_opening($api_data), true);
            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            // if ($api_response['error'] == 0) {
            //     $this->session->data['success'] = $this->language->get('text_success');
            // } else {
            //     $this->session->data['fail_save'] = $this->language->get('text_fail_save');
            // }

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('setting/store_opening');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_opening');

        $api_data = [];

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $store_opening_time = $this->model_setting_store_opening->editStoreOpening($this->request->post, $this->request->get['store_opening_id']);

            $api_data = [
                'store_url' => HTTP_CATALOG,
                'store_opening_time' => $store_opening_time,
                'day' => $this->request->post['day']
            ];

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            // $api_response = json_decode($this->etcm_save_opening($api_data), true);

            // if ($api_response['error'] == 0) {
            //     $this->session->data['success'] = $this->language->get('text_success');
            // } else {
            //     $this->session->data['fail_save'] = $this->language->get('text_fail_save');
            // }

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        if (!isset($this->request->get['store_opening_id'])) {
            $this->response->redirect($this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('setting/store_opening');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_opening');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $store_opening_id) {
                $this->model_setting_store_opening->deleteStoreOpening($store_opening_id);

                // $store_opening_info = $this->model_setting_store_opening->getStoreOpening($store_opening_id);

                // if (!empty($store_opening_info)) {
                //     $api_data = [
                //         'store_url' => HTTP_CATALOG,
                //         'day' => $store_opening_info['day']
                //     ];

                //     $api_response = json_decode($this->etcm_delete_opening($api_data), true);

                //     if ($api_response['error'] == 0) {
                //         $this->model_setting_store_opening->deleteStoreOpening($store_opening_id);

                //         $this->session->data['success'] = $this->language->get('text_success');
                //     } else {
                //         $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                //     }
                // }
            }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');


            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_day'])) {
            $filter_day = $this->request->get['filter_day'];
        } else {
            $filter_day = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'doctor_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_day'])) {
            $url .= '&filter_day=' . $this->request->get['filter_day'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        $data['add'] = $this->url->link('setting/store_opening/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['copy'] = $this->url->link('setting/store_opening/copy', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete'] = $this->url->link('setting/store_opening/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['store_openings'] = [];

        $filter_data = [
            'filter_day' => $filter_day,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        $results = $this->model_setting_store_opening->getStoreOpenings($filter_data);
        $total_store_opening = $this->model_setting_store_opening->getTotalStoreOpenings($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $store_opening_times = $this->model_setting_store_opening->getStoreOpeningTimes($result['store_opening_id']);

                if (!empty($store_opening_times)) {
                    $working_hours = '';
                    $working_hour_arr = array();

                    foreach ($store_opening_times as $time) {
                        $working_hour_arr[] = $time['start_time'] . ' - ' . $time['end_time'];
                    }

                    if (!empty($working_hour_arr)) {
                        $working_hours = implode('<br />', $working_hour_arr);
                    }
                } else {
                    $working_hours = '-';
                }

                $data['store_openings'][] = [
                    'store_opening_id' => $result['store_opening_id'],
                    'day' => $result['day'],
                    'working_hours' => $working_hours,
                    'edit' => $this->url->link('setting/store_opening/edit', 'user_token=' . $this->session->data['user_token'] . '&store_opening_id=' . $result['store_opening_id'], true)
                ];
            }
        }

        $language_arr = ['heading_title', 'button_add', 'button_delete', 'text_confirm', 'text_list', 'button_filter', 'entry_day', 'text_no_results', 'column_day', 'column_action', 'column_working', 'button_edit', 'button_copy'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->session->data['fail_save'])) {
            $data['fail_save'] = $this->session->data['fail_save'];

            unset($this->session->data['fail_save']);
        } else {
            $data['fail_save'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }

        $url = '';

        if (isset($this->request->get['filter_day'])) {
            $url .= '&filter_day=' . $this->request->get['filter_day'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_day'] = $filter_day;

        $full_days = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];

        foreach ($full_days as $day) {
            $data['days'][] = [
                'full_day' => ucfirst($day),
                'text_day' => $this->language->get('text_' . $day)
            ];
        }

        $pagination = new Pagination();
        $pagination->total = $total_store_opening;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_store_opening) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_store_opening - $this->config->get('config_limit_admin'))) ? $total_store_opening : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_store_opening, ceil($total_store_opening / $this->config->get('config_limit_admin')));

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/store_opening_list', $data));
    }

    protected function getForm()
    {
        $url = '';

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        if (isset($this->request->get['store_opening_id'])) {
            $data['action'] = $this->url->link('setting/store_opening/edit', 'user_token=' . $this->session->data['user_token'] . '&store_opening_id=' . $this->request->get['store_opening_id'], true);
        } else {
            $data['action'] = $this->url->link('setting/store_opening/add', 'user_token=' . $this->session->data['user_token'], true);
        }

        $data['cancel'] = $this->url->link('setting/store_opening', 'user_token=' . $this->session->data['user_token'], true);

        $data['text_form'] = isset($this->request->get['store_opening_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['day'])) {
            $data['error_day'] = $this->error['day'];
        } else {
            $data['error_day'] = '';
        }

        if (isset($this->error['service_session'])) {
            $data['error_service_session'] = $this->error['service_session'];
        } else {
            $data['error_service_session'] = '';
        }

        if (isset($this->error['enable_service_session'])) {
            $data['error_enable_service_session'] = $this->error['enable_service_session'];
        } else {
            $data['error_enable_service_session'] = '';
        }

        $data['error_start_time'] = isset($this->error['start_time']) ? $this->error['start_time'] : NULL;
        $data['error_end_time'] = isset($this->error['end_time']) ? $this->error['end_time'] : NULL;

        if (isset($this->request->get['store_opening_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $store_opening_info = $this->model_setting_store_opening->getStoreOpening($this->request->get['store_opening_id']);

            $store_opening_times = $this->model_setting_store_opening->getStoreOpeningTimes($this->request->get['store_opening_id']);
        }

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        if (isset($this->request->post['store_id'])) {
            $data['store_id'] = $this->request->post['store_id'];
        } elseif (!empty($store_opening_info)) {
            $data['store_id'] = $store_opening_info['store_id'];
        } else {
            $data['store_id'] = $store_id;
        }

        if (isset($this->request->post['day'])) {
            $data['day'] = $this->request->post['day'];
        } elseif (!empty($store_opening_info)) {
            $data['day'] = $store_opening_info['day'];
        } else {
            $data['day'] = '';
        }

        if (isset($this->request->post['service_session'])) {
            $data['service_session'] = $this->request->post['service_session'];
        } elseif (!empty($store_opening_info)) {
            $data['service_session'] = $store_opening_info['session'];
        } else {
            $data['service_session'] = NULL;
        }

        if (isset($this->request->post['enable_service_session'])) {
            $data['enable_service_session'] = $this->request->post['enable_service_session'];
        } elseif (!empty($store_opening_info)) {
            $data['enable_service_session'] = $store_opening_info['enable_session'];
        } else {
            $data['enable_service_session'] = NULL;
        }

        $full_days = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];

        foreach ($full_days as $day) {
            $data['days'][] = [
                'full_day' => ucfirst($day),
                'text_day' => $this->language->get('text_' . $day)
            ];
        }

        if (isset($this->request->get['store_opening_id'])) {
            $data['disabled'] = 1;
        } else {
            $data['disabled'] = 0;
        }

        if (isset($this->request->post['store_opening_times'])) {
            $data['store_opening_times'] = $this->request->post['store_opening_times'];
        } else if (!empty($store_opening_times)) {
            $data['store_opening_times'] = $store_opening_times;
        } else {
            $data['store_opening_times'] = array();
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/store_opening_form', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'setting/store_opening')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $check_available = $this->model_setting_store_opening->checkDuplicate($this->request->post['day'], $this->request->post['store_id']);

        if (!empty($check_available)) {
            if (!isset($this->request->get['store_opening_id'])) {
                $this->error['warning'] = $this->language->get('error_duplicate');
            }
        }

        if ((utf8_strlen($this->request->post['day']) < 1)) {
            $this->error['day'] = $this->language->get('error_day');
        }

        if (isset($this->request->post['store_opening_times'])) {
            foreach ($this->request->post['store_opening_times'] as $counter => $time) {
                if (empty($time['start_time'])) {
                    $this->error['start_time']['store_opening_times'][$counter] = $this->language->get('error_start_time');
                }

                if (empty($time['end_time'])) {
                    $this->error['end_time']['store_opening_times'][$counter] = $this->language->get('error_end_time');
                }

                if (strtotime($time['start_time']) > strtotime($time['end_time'])) {
                    $this->error['start_time']['store_opening_times'][$counter] = $this->language->get('error_invalid_time');
                    $this->error['end_time']['store_opening_times'][$counter] = $this->language->get('error_invalid_time');
                }

                if ($counter > 0) {
                    $previous_counter = $counter - 1;

                    $previous_arr = $this->request->post['store_opening_times'][$previous_counter];

                    if (strtotime($time['start_time']) < strtotime($previous_arr['end_time'])) {
                        $this->error['start_time']['store_opening_times'][$counter] = $this->language->get('error_invalid_time');
                    }
                }
            }
        }


        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'setting/store_opening')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    private function etcm_save_opening($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_opening/save_opening';

        $post_data['push_data'] = [
            'store_url' => $data['store_url'],
            'day' => $data['day'],
            'store_opening_time' => urldecode(http_build_query($data['store_opening_time']))
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_delete_opening($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_opening/delete_opening';

        $post_data['push_data'] = [
            'store_url' => $data['store_url'],
            'day' => $data['day']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function syncToEtcm()
    {
        $db_openings = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening")->rows;

        $openings = [];
        foreach ($db_openings as $opening) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$opening['store_opening_id'] . "'")->rows;
            $openings[] = [
                "store_id"  => $opening['store_id'],
                'day'       => $opening['day'],
                'times'     => $db_times
            ];
        }

        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'openings' => $openings
        ];

        $path = 'etcm/syncing/syncing/update_store_opening';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
