<?php

class ControllerSettingStoreHoliday extends Controller
{

    private $error = [];

    public function index()
    {
        $this->load->language('setting/store_holiday');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_holiday');

        $this->getList();
    }

    public function add()
    {
        $this->load->language('setting/store_holiday');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_holiday');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $holiday_id = $this->model_setting_store_holiday->addHoliday($this->request->post);

            if ($holiday_id > 0) {
                // $etcm_insert_data = [
                //     'holiday_id' => $holiday_id,
                //     'store_url' => HTTP_CATALOG,
                //     'title' => $this->request->post['store_holiday_title'],
                //     'start' => $this->request->post['start_date'],
                //     'end' => $this->request->post['end_date']
                // ];

                // $api_response = json_decode($this->etcm_add_holiday($etcm_insert_data), true);

                // if ($api_response['error'] == 0) {
                //     $this->session->data['success'] = $this->language->get('text_success');
                // } else {
                //     $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                // }

                $this->syncToEtcm();
                $this->session->data['success'] = $this->language->get('text_success');

                $url = '';

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['page'])) {
                    $url .= '&page=' . $this->request->get['page'];
                }

                $this->response->redirect($this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('setting/store_holiday');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_holiday');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $row_affected = $this->model_setting_store_holiday->editHoliday($this->request->post, $this->request->get['store_holiday_id']);

            if ($row_affected == 1) {
                // $etcm_edit_data = [
                //     'holiday_id' => $this->request->get['store_holiday_id'],
                //     'store_url' => HTTP_CATALOG,
                //     'title' => $this->request->post['store_holiday_title'],
                //     'start' => $this->request->post['start_date'],
                //     'end' => $this->request->post['end_date']
                // ];

                // $api_response = json_decode($this->etcm_edit_holiday($etcm_edit_data), true);

                // if ($api_response['error'] == 0) {
                //     $this->session->data['success'] = $this->language->get('text_success');
                // } else {
                //     $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                // }

                
                $this->syncToEtcm();
                $this->session->data['success'] = $this->language->get('text_success');

                $url = '';

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['page'])) {
                    $url .= '&page=' . $this->request->get['page'];
                }

                $this->response->redirect($this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        if (!isset($this->request->get['store_holiday_id'])) {
            $this->response->redirect($this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('setting/store_holiday');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_holiday');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $store_holiday_id) {
                $store_holiday_info = $this->model_setting_store_holiday->getStoreHoliday($store_holiday_id);

                if (!empty($store_holiday_info)) {
                    // $api_data = [
                    //     'store_url' => HTTP_CATALOG,
                    //     'holiday_id' => $store_holiday_info['id']
                    // ];

                    // $api_response = json_decode($this->etcm_delete_holiday($api_data), true);

                    // if ($api_response['error'] == 0) {
                    //     $this->model_setting_store_holiday->deleteHoliday($store_holiday_id);

                    //     $this->session->data['success'] = $this->language->get('text_success');
                    // } else {
                    //     $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                    // }
                }
            }

            
            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList()
    {
        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        $data['add'] = $this->url->link('setting/store_holiday/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete'] = $this->url->link('setting/store_holiday/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['store_holidays'] = [];

        $filter_data = [
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        $results = $this->model_setting_store_holiday->getHolidays($filter_data);
        $total_holidays = $this->model_setting_store_holiday->getTotalHolidays($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['store_holidays'][] = [
                    'store_holiday_id' => $result['id'],
                    'title' => $result['title'],
                    'start' => date($this->language->get('date_format_short'), strtotime($result['start'])),
                    'end' => date($this->language->get('date_format_short'), strtotime($result['end'])),
                    'edit' => $this->url->link('setting/store_holiday/edit', 'user_token=' . $this->session->data['user_token'] . '&store_holiday_id=' . $result['id'], true)
                ];
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->session->data['fail_save'])) {
            $data['fail_save'] = $this->session->data['fail_save'];

            unset($this->session->data['fail_save']);
        } else {
            $data['fail_save'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = [];
        }

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_title'] = $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . '&sort=title' . $url, true);
        $data['sort_from_date'] = $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . '&sort=start' . $url, true);
        $data['sort_to_date'] = $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . '&sort=end' . $url, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_holidays;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_holidays) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_holidays - $this->config->get('config_limit_admin'))) ? $total_holidays : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_holidays, ceil($total_holidays / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/store_holiday_list', $data));
    }

    protected function getForm()
    {
        $url = '';

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ];

        if (isset($this->request->get['store_holiday_id'])) {
            $data['action'] = $this->url->link('setting/store_holiday/edit', 'user_token=' . $this->session->data['user_token'] . '&store_holiday_id=' . $this->request->get['store_holiday_id'], true);
        } else {
            $data['action'] = $this->url->link('setting/store_holiday/add', 'user_token=' . $this->session->data['user_token'], true);
        }

        $data['cancel'] = $this->url->link('setting/store_holiday', 'user_token=' . $this->session->data['user_token'], true);

        $data['text_form'] = isset($this->request->get['store_holiday_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['store_holiday_title'])) {
            $data['error_store_holiday_title'] = $this->error['store_holiday_title'];
        } else {
            $data['error_store_holiday_title'] = '';
        }

        if (isset($this->error['start_date'])) {
            $data['error_start_date'] = $this->error['start_date'];
        } else {
            $data['error_start_date'] = '';
        }

        if (isset($this->error['end_date'])) {
            $data['error_end_date'] = $this->error['end_date'];
        } else {
            $data['error_end_date'] = '';
        }

        if (isset($this->request->get['store_holiday_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $store_holiday_info = $this->model_setting_store_holiday->getStoreHoliday($this->request->get['store_holiday_id']);
        }

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        if (isset($this->request->post['store_id'])) {
            $data['store_id'] = $this->request->post['store_id'];
        } elseif (!empty($store_holiday_info)) {
            $data['store_id'] = $store_holiday_info['store_id'];
        } else {
            $data['store_id'] = $store_id;
        }

        if (isset($this->request->post['store_holiday_title'])) {
            $data['store_holiday_title'] = $this->request->post['store_holiday_title'];
        } elseif (!empty($store_holiday_info)) {
            $data['store_holiday_title'] = $store_holiday_info['title'];
        } else {
            $data['store_holiday_title'] = '';
        }

        if (isset($this->request->post['start_date'])) {
            $data['start_date'] = $this->request->post['start_date'];
        } elseif (!empty($store_holiday_info)) {
            $data['start_date'] = $store_holiday_info['start'];
        } else {
            $data['start_date'] = '';
        }

        if (isset($this->request->post['end_date'])) {
            $data['end_date'] = $this->request->post['end_date'];
        } elseif (!empty($store_holiday_info)) {
            $data['end_date'] = $store_holiday_info['end'];
        } else {
            $data['end_date'] = '';
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/store_holiday_form', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'setting/store_holiday')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['store_holiday_title'])) {
            $this->error['store_holiday_title'] = $this->language->get('error_store_holiday_title');
        }

        if (empty($this->request->post['start_date'])) {
            $this->error['start_date'] = $this->language->get('error_start_date');
        }

        if (empty($this->request->post['end_date'])) {
            $this->error['end_date'] = $this->language->get('error_end_date');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('modify', 'setting/store_holiday')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function etcm_add_holiday($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_holiday/add_holiday';

        $post_data['push_data'] = [
            'holiday_id' => $data['holiday_id'],
            'store_url' => $data['store_url'],
            'title' => $data['title'],
            'start' => $data['start'],
            'end' => $data['end']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function etcm_edit_holiday($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_holiday/edit_holiday';

        $post_data['push_data'] = [
            'holiday_id' => $data['holiday_id'],
            'store_url' => $data['store_url'],
            'title' => $data['title'],
            'start' => $data['start'],
            'end' => $data['end']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function etcm_delete_holiday($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_holiday/delete_holiday';

        $post_data['push_data'] = [
            'store_url' => $data['store_url'],
            'holiday_id' => $data['holiday_id']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function syncToEtcm()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE end >= '".$this->db->escape(date('Y-m-d'))."'")->rows;

        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'holidays' => $db_holidays
        ];

        $path = 'etcm/syncing/syncing/update_store_holiday';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
