<?php

class ControllerSettingStoreGallery extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('setting/store_gallery');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_gallery');

        $this->getList();
    }

    public function delete(){
        $this->load->language('setting/store_gallery');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/store_gallery');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach($this->request->post['selected'] as $store_gallery_id){
                $api_data = [
                    'hosting'		    => HTTP_CATALOG,
                    'merchant_gallery_id'   => $store_gallery_id
                ];

                $api_response = json_decode($this->etcm_delete_image($api_data), true);

                if($api_response['error'] == 0){
                    $this->model_setting_store_gallery->deleteStoreImage($store_gallery_id);

                    $this->session->data['success'] = $this->language->get('text_success_delete');
                } else{
                    $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                }
            }

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getList();
    }

    public function change_sort_order(){
        $this->load->language('setting/store_gallery');
        $this->load->model('setting/store_gallery');

        $json = [];

        if(isset($this->request->post)){
            $sort_order = $this->request->post['sort_order'];
            $store_gallery_id = $this->request->post['store_gallery_id'];

            $changed_row = $this->model_setting_store_gallery->updateSortOrder($store_gallery_id, $sort_order);

            if($changed_row == 1){
                $api_data = [
                    'hosting'		         => HTTP_CATALOG,
                    'merchant_gallery_id'    => $store_gallery_id,
                    'sort_order'             => $sort_order
                ];

                $api_response = json_decode($this->etcm_change_sort_order($api_data), true);

                if($api_response['error'] == 0){
                    $json = [
                        'error'         => 0,
                        'message'       => $this->language->get('text_success_modify'),
                        'sort_order'    => $sort_order
                    ];
                } else{
                    $json = [
                        'error'     => 1,
                        'message'   => 'fail to post to etcm'
                    ];
                }
            }
        } else{
            $json = [
                'error'     => 1,
                'message'   => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function change_status(){
        $this->load->language('setting/store_gallery');
        $this->load->model('setting/store_gallery');

        if(isset($this->request->get['store_gallery_id'])){
            $store_gallery_id = $this->request->get['store_gallery_id'];

            $store_gallery_info = $this->model_setting_store_gallery->getStoreGallery($store_gallery_id);

            if(!empty($store_gallery_info)){
                $status = $store_gallery_info['status'];

                if($status == '1'){
                    $change_status = '0';
                } else{
                    $change_status = '1';
                }

                $changed_row = $this->model_setting_store_gallery->updateStoreGalleryStatus($store_gallery_id, $change_status);

                if($changed_row == 1){
                    $api_data = [
                        'hosting'		         => HTTP_CATALOG,
                        'merchant_gallery_id'    => $store_gallery_id,
                        'status'                 => $change_status
                    ];

                    $api_response = json_decode($this->etcm_change_status($api_data), true);

                    if($api_response['error'] == 0){
                        $this->session->data['success'] = $this->language->get('text_success_modify');
                    } else{
                        $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                    }

                    $this->response->redirect($this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'], true));
                }
            }
        } else{
            $this->response->redirect($this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'], true));
        }
    }

    protected function getList(){
        if($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateUploadForm()){
            $store_gallery_id = $this->model_setting_store_gallery->uploadStoreImage($this->request->post);

            if($store_gallery_id > 0){
                $store_gallery_info = $this->model_setting_store_gallery->getStoreGallery($store_gallery_id);

                if(!empty($store_gallery_info)){
                    $api_data = [
                        'hosting'		         => HTTP_CATALOG,
                        'merchant_gallery_id'    => $store_gallery_id,
                        'image'                  => HTTP_CATALOG . 'image/' . $store_gallery_info['image'],
                        'sort_order'             => $store_gallery_info['sort_order'],
                        'status'                 => $store_gallery_info['status']
                    ];

                    $api_response = json_decode($this->etcm_save_store_image($api_data), true);

                    if($api_response['error'] == 0){
                        $this->session->data['success'] = $this->language->get('text_success');
                    } else{
                        $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                    }
                }
            }

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getListView();
    }

    protected function getListView(){
        if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'sort_order';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

        $url = '';

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $data['error_sort_order_edit'] = $this->language->get('error_sort_order');
        $data['text_success_modify'] = $this->language->get('text_success_modify');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['image'])) {
            $data['error_image'] = $this->error['image'];
        } else {
            $data['error_image'] = '';
        }

        if (isset($this->error['sort_order'])) {
            $data['error_sort_order'] = $this->error['sort_order'];
        } else {
            $data['error_sort_order'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->session->data['fail_save'])) {
            $data['fail_save'] = $this->session->data['fail_save'];
            unset($this->session->data['fail_save']);
        } else {
            $data['fail_save'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['upload_action'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete_action'] = $this->url->link('setting/store_gallery/delete', 'user_token=' . $this->session->data['user_token'], true);

        $data['store_images'] = [];

        $filter_data = array(
			'sort'             	        => $sort,
			'order'                     => $order,
			'start'                     => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                     => $this->config->get('config_limit_admin')
		);

        $store_image_total = $this->model_setting_store_gallery->getTotalStoreImages($filter_data);

		$results = $this->model_setting_store_gallery->getStoreImages($filter_data);

        $this->load->model('tool/image');

        if(!empty($results)){
            foreach($results as $result){
                if($result['add_by'] > 0){
                    if (is_file(DIR_IMAGE . $result['image'])) {
                        $image = $this->model_tool_image->resize($result['image'], 40, 40);
                    } else {
                        $image = $this->model_tool_image->resize('no_image.png', 40, 40);
                    }

                    $view_image = HTTPS_IMAGE . $result['image'];
                } else{
                    $api_data = [
                        'hosting'				=> HTTP_CATALOG,
                        'merchant_gallery_id'   => $result['store_gallery_id'],
                        'width'                 => 40,
                        'height'                => 40
                    ];

                    $api_response = json_decode($this->etcm_get_resize_image($api_data), true);

                    if($api_response['error'] == 0){
                        $image = $api_response['image_url'];
                    } else{
                        $image = $this->model_tool_image->resize('no_image.png', 40, 40);
                    }

                    $view_image = HTTP_API . 'image/' . $result['image'];
                }

                $status = ($result['status'] == '1') ? $this->language->get('text_enabled') : $this->language->get('text_disabled');

                if($result['approval_status'] == '0'){
                    $approval_status = $this->language->get('text_pending');
                    $label_color = 'label-warning';
                } elseif($result['approval_status'] == '1'){
                    $approval_status = $this->language->get('text_approved');
                    $label_color =  'label-success';
                } elseif($result['approval_status'] == '2'){
                    $approval_status = $this->language->get('text_rejected');
                    $label_color =  'label-danger';
                }

                if($result['date_approval'] == '0000-00-00 00:00:00'){
                    $date_approval = '-';
                } else{
                    $date_approval = date($this->language->get('date_format_short'), strtotime($result['date_approval']));
                }

                $data['store_images'][] = [
                    'store_gallery_id'          => $result['store_gallery_id'],
                    'image'                     => $image,
                    'status'                    => $result['status'],
                    'status_text'               => $status,
                    'sort_order'                => $result['sort_order'],
                    'approval_status_text'      => $approval_status,
                    'label_color'               => $label_color,
                    'date_added'                => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'date_approval'             => $date_approval,
                    'view'                      => $view_image,
                    'change_status'             => $this->url->link('setting/store_gallery/change_status', 'user_token=' . $this->session->data['user_token'] . '&store_gallery_id=' . $result['store_gallery_id'], true)
                ];
            }
        }

        if (isset($this->request->post['sort_order'])) {
			$data['sort_order'] = $this->request->post['sort_order'];
		} else {
			$data['sort_order'] = '';
		}

        if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} else {
			$data['status'] = '';
		}

        $url = '';

        if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

        $data['sort_status'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_sort_order'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);
        $data['sort_approval_status'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . '&sort=approval_status' . $url, true);
        $data['sort_date_approval'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . '&sort=date_approval' . $url, true);
        $data['sort_date_added'] = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $url = '';

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        $pagination = new Pagination();
        $pagination->total = $store_image_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('setting/store_gallery', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($store_image_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($store_image_total - $this->config->get('config_limit_admin'))) ? $store_image_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $store_image_total, ceil($store_image_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
		$data['order'] = $order;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('setting/store_gallery', $data));
    }

    protected function validateUploadForm(){
        if (!$this->user->hasPermission('modify', 'setting/store_gallery')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if(empty($this->request->post['sort_order'])){
            $this->error['sort_order'] = $this->language->get('error_sort_order');
        }

        $img_allowed = array('gif','jpeg','png','jpg');

        if($this->request->files["image"]["error"] != 0) {
            $this->error['image'] = $this->language->get('error_image');
        } elseif($this->request->files['image']['size'] > 1000000){
            $this->error['image'] = $this->language->get('error_image_size');
        } else {
            $img_filename = $this->request->files["image"]["name"];
            $ext = pathinfo($img_filename,PATHINFO_EXTENSION);
            if(!in_array(strtolower($ext), $img_allowed)){
                $this->error['image'] = $this->language->get('error_image_format');
            }
        }

        //error
        if($this->error && !isset($this->error['warning'])){
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete(){
        if (!$this->user->hasPermission('modify', 'setting/store_gallery')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
    }

    private function etcm_save_store_image($data){
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_gallery/save_image';

        $post_data['push_data'] = [
            'hosting'		         => $data['hosting'],
            'merchant_gallery_id'    => $data['merchant_gallery_id'],
            'image'			         => $data['image'],
            'sort_order'		     => $data['sort_order'],
            'status'		         => $data['status']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_change_sort_order($data){
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_gallery/change_sort_order';

        $post_data['push_data'] = [
            'hosting'		         => $data['hosting'],
            'merchant_gallery_id'    => $data['merchant_gallery_id'],
            'sort_order'		     => $data['sort_order']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_change_status($data){
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_gallery/change_status';

        $post_data['push_data'] = [
            'hosting'		         => $data['hosting'],
            'merchant_gallery_id'    => $data['merchant_gallery_id'],
            'status'		         => $data['status']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_delete_image($data){
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_gallery/delete_image';

        $post_data['push_data'] = [
            'hosting'		         => $data['hosting'],
            'merchant_gallery_id'    => $data['merchant_gallery_id']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_get_resize_image($data){
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_gallery/resize_image';

        $post_data['push_data'] = [
            'hosting'		         => $data['hosting'],
            'merchant_gallery_id'    => $data['merchant_gallery_id'],
            'width'                  => $data['width'],
            'height'                 => $data['height']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }
}
?>