<?php

class ControllerServiceClinicalService extends Controller
{

    private $error = [];

    public function index()
    {
        $this->load->language('service/clinical_service');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/clinical_service');
        $this->createIfNotExist();
        $this->getList();
    }

    public function add()
    {
        $this->load->language('service/clinical_service');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/clinical_service');
        $this->load->model('localisation/language');
        $this->load->model('localisation/tax_class');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_service_clinical_service->addClinicalService($this->request->post);

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('service/clinical_service');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/clinical_service');
        $this->load->model('localisation/language');
        $this->load->model('localisation/tax_class');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_service_clinical_service->editClinicalService($this->request->get['clinicalservice_id'], $this->request->post);

            $this->syncToEtcm();

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('service/clinical_service');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/clinical_service');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $clinicalservice_id) {
                $this->model_service_clinical_service->delete_clinical_service($clinicalservice_id);
            }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getList();
    }

    public function serviceList()
    {
        $this->load->language('openwindow/clinical_service');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/clinical_service');

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $filter_data = array(
            'filter_name' => $filter_name,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $clinicalServiceList = $this->model_service_clinical_service->get_clinical_services($filter_data);
        $clinical_service_total = $this->model_service_clinical_service->total_clinical_services($filter_data);

        foreach ($clinicalServiceList as $clinicalService) {
            $data['clinicalServices'][] = array(
                'clinicalservice_id' => $clinicalService['clinicalservice_id'],
                'name' => $clinicalService['name'],
                'cs_minute' => $clinicalService['cs_minute'],
                'price' => $clinicalService['price'],
                'formated_price' => $this->currency->format($clinicalService['price'], $this->config->get('config_currency')),
                'type' => $clinicalService['type']
            );
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('service/clinical_service/serviceList', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        $data['sort_cs_minute'] = $this->url->link('service/clinical_service/serviceList', 'user_token=' . $this->session->data['user_token'] . '&sort=cs_minute' . $url, true);
        $data['sort_price'] = $this->url->link('service/clinical_service/serviceList', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $url, true);
        $data['sort_type'] = $this->url->link('service/clinical_service/serviceList', 'user_token=' . $this->session->data['user_token'] . '&sort=type' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $clinical_service_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/clinical_service/serviceList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($clinical_service_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($clinical_service_total - $this->config->get('config_limit_admin'))) ? $clinical_service_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $clinical_service_total, ceil($clinical_service_total / $this->config->get('config_limit_admin')));

        $data['user_token'] = $this->session->data['user_token'];

        $data['filter_name'] = $filter_name;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/clinical_service_list', $data));
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['add'] = $this->url->link('service/clinical_service/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link("service/clinical_service/delete", 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['clinicalServices'] = [];

        $filter_data = [
            'filter_name' => $filter_name,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        $results = $this->model_service_clinical_service->get_clinical_services($filter_data);
        $clinical_service_total = $this->model_service_clinical_service->total_clinical_services($filter_data);

        foreach ($results as $result) {
            $data['clinicalServices'][] = [
                'clinicalservice_id' => $result['clinicalservice_id'],
                'name' => $result['name'],
                'cs_minute' => $result['cs_minute'],
                'price' => $this->currency->format($result['price'], $this->config->get('config_currency')),
                'type' => $result['type'],
                'edit' => $this->url->link('service/clinical_service/edit', 'user_token=' . $this->session->data['user_token'] . '&clinicalservice_id=' . $result['clinicalservice_id'] . $url, true)
            ];
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        $data['sort_cs_minute'] = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . '&sort=cs_minute' . $url, true);
        $data['sort_price'] = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $url, true);
        $data['sort_type'] = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . '&sort=type' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $clinical_service_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($clinical_service_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($clinical_service_total - $this->config->get('config_limit_admin'))) ? $clinical_service_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $clinical_service_total, ceil($clinical_service_total / $this->config->get('config_limit_admin')));

        $data['user_token'] = $this->request->get['user_token'];

        $data['filter_name'] = $filter_name;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/clinical_service_list', $data));
    }

    protected function getForm()
    {
        $data['text_form'] = !isset($this->request->get['clinicalservice_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = [];
        }

        if (isset($this->error['cs_minute'])) {
            $data['error_cs_minute'] = $this->error['cs_minute'];
        } else {
            $data['error_cs_minute'] = '';
        }

        if (isset($this->error['cs_session'])) {
            $data['error_cs_session'] = $this->error['cs_session'];
        } else {
            $data['error_cs_session'] = '';
        }

        if (isset($this->error['price'])) {
            $data['error_price'] = $this->error['price'];
        } else {
            $data['error_price'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'], true)
        ];

        if (!isset($this->request->get['clinicalservice_id'])) {
            $data['action'] = $this->url->link('service/clinical_service/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('service/clinical_service/edit', 'user_token=' . $this->session->data['user_token'] . '&clinicalservice_id=' . $this->request->get['clinicalservice_id'] . $url, true);
        }

        if (isset($this->request->get['clinicalservice_id'])) {
            $clinical_service_info = $this->model_service_clinical_service->get_clinical_service($this->request->get['clinicalservice_id']);
        }

        if (isset($this->request->post['clinical_service_description'])) {
            $data['clinical_service_description'] = $this->request->post['clinical_service_description'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['clinical_service_description'] = $this->model_service_clinical_service->get_clinical_service_descriptions($this->request->get['clinicalservice_id']);
        } else {
            $data['clinical_service_description'] = [];
        }

        if (isset($this->request->post['store_id'])) {
            $data['store_ids'] = $this->request->post['store_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['store_ids'] = unserialize($clinical_service_info['store_id']);
        } else {
            $data['store_ids'] = [];
        }

        if (isset($this->request->post['doctor_id'])) {
            $data['service_doctor_list'] = $this->request->post['doctor_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['service_doctor_list'] = unserialize($clinical_service_info['doctor_id']);
        } else {
            $data['service_doctor_list'] = [];
        }

        if (isset($this->request->post['acupuncture_part_id'])) {
            $data['acupuncture_part_list'] = $this->request->post['acupuncture_part_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['acupuncture_part_list'] = unserialize($clinical_service_info['acupuncture_parts']);
        } else {
            $data['acupuncture_part_list'] = [];
        }

        if (isset($this->request->post['facility_id'])) {
            $data['facility_list'] = $this->request->post['facility_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['facility_list'] = array_column($this->model_service_clinical_service->get_clinical_service_facilities($this->request->get['clinicalservice_id']), 'facility_id');
        } else {
            $data['facility_list'] = [];
        }

        if (isset($this->request->post['type'])) {
            $data['type'] = $this->request->post['type'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['type'] = $clinical_service_info['type'];
        } else {
            $data['type'] = '';
        }

        if (isset($this->request->post['staff_id'])) {
            $data['staff_id'] = $this->request->post['staff_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['staff_id'] = $clinical_service_info['staff_id'];
        } else {
            $data['staff_id'] = '';
        }

        if (isset($this->request->post['doctor'])) {
            $data['doctor'] = $this->request->post['doctor'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['doctor'] = $clinical_service_info['doctor'];
        } else {
            $data['doctor'] = '';
        }

        if (isset($this->request->post['cs_minute'])) {
            $data['cs_minute'] = $this->request->post['cs_minute'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['cs_minute'] = $clinical_service_info['cs_minute'];
        } else {
            $data['cs_minute'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['status'] = $clinical_service_info['status'];
        } else {
            $data['status'] = '';
        }

        if (isset($this->request->post['enable_appointment'])) {
            $data['enable_appointment'] = $this->request->post['enable_appointment'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['enable_appointment'] = $clinical_service_info['enable_appointment'];
        } else {
            $data['enable_appointment'] = '';
        }

        if (isset($this->request->post['enable_etcm'])) {
            $data['enable_etcm'] = $this->request->post['enable_etcm'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['enable_etcm'] = $clinical_service_info['enable_etcm'];
        } else {
            $data['enable_etcm'] = '';
        }

        if (isset($this->request->post['cs_session'])) {
            $data['cs_session'] = $this->request->post['cs_session'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['cs_session'] = $clinical_service_info['cs_session'];
        } else {
            $data['cs_session'] = '';
        }

        if (isset($this->request->post['price'])) {
            $data['price'] = $this->request->post['price'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['price'] = $clinical_service_info['price'];
        } else {
            $data['price'] = '';
        }

        if (isset($this->request->post['tax_class_id'])) {
            $data['tax_class_id'] = $this->request->post['tax_class_id'];
        } elseif (isset($this->request->get['clinicalservice_id'])) {
            $data['tax_class_id'] = $clinical_service_info['tax_class_id'];
        } else {
            $data['tax_class_id'] = '';
        }

        $data['cancel'] = $this->url->link('service/clinical_service', 'user_token=' . $this->session->data['user_token'], true);

        $data['languages'] = $this->model_localisation_language->getLanguages();
        $data['stores'] = $this->model_service_clinical_service->get_available_stores();

        $this->load->model('appointment/appointment');
        $doctors = $this->model_appointment_appointment->getDoctors();

        foreach ($doctors as $doctor) {
            $data['doctors'][] = array(
                'doctor_id' => $doctor['user_id'],
                'doctor_name' => $doctor['firstname'] . ' ' . $doctor['lastname']
            );
        }

        $acupuncture_parts = $this->model_service_clinical_service->get_acupuncture_parts();

        foreach ($acupuncture_parts as $part) {
            $data['acupuncture_parts'][] = array(
                'acupuncture_part_id' => $part['acupuncture_part_id'],
                'name' => $part['name']
            );
        }

        $facilitys = $this->model_service_clinical_service->get_facility();

        foreach ($facilitys as $facility) {
            $data['facilitys'][] = array(
                'facility_id' => $facility['facility_id'],
                'facility_name' => $facility['facility_name']
            );
        }

        $data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
        $data['adminStaffs'] = $this->model_service_clinical_service->get_administrator_staff();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/clinical_service_form', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'service/clinical_service') && !$this->user->userpermission('modify', 'service/clinical_service')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['clinical_service_description'] as $language_id => $value) {
            if ((utf8_strlen($value['name']) < 2) || (utf8_strlen($value['name']) > 255)) {
                $this->error['name'][$language_id] = $this->language->get('error_clinical_service_name');
            }
        }

        if (empty($this->request->post['cs_minute'])) {
            $this->error['cs_minute'] = $this->language->get('error_clinical_service_cs_minute');
        }

        if (empty($this->request->post['cs_session'])) {
            $this->error['cs_session'] = $this->language->get('error_clinical_service_cs_session');
        }

        if (!is_numeric($this->request->post['cs_session'])) {
            $this->error['cs_session'] = $this->language->get('error_clinical_service_cs_session_format');
        }

        if (empty($this->request->post['price'])) {
            $this->error['price'] = $this->language->get('error_clinical_service_price');
        }

        if (!is_numeric($this->request->post['price'])) {
            $this->error['price'] = $this->language->get('error_clinical_service_price_format');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('delete', 'service/clinical_service') && !$this->user->userpermission('delete', 'service/clinical_service')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function syncToEtcm()
    {

        $db_services = $this->db->query("SELECT cs.*, en.name AS en_name, cn.name AS cn_name FROM " . DB_PREFIX . "clinical_service cs 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description en ON(en.clinicalservice_id = cs.clinicalservice_id AND en.language_id = '1') 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cn ON(cn.clinicalservice_id = cs.clinicalservice_id AND cn.language_id = '2')
        WHERE cs.enable_etcm = '1'")->rows;
        $services = [];
        foreach ($db_services as $service) {

            $service_id = $service['clinicalservice_id'];

            $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$service_id . "'")->rows;
            $stores = [];
            if (!empty($db_stores)) {
                foreach ($db_stores as $store) {
                    $stores[] = [
                        'service_id'    => $service_id,
                        'store_id'   => $store['store_id']
                    ];
                }
            } else {
                foreach (unserialize($service['store_id']) as $id) {
                    $stores[] = [
                        'service_id'   => $service_id,
                        'store_id'     => $id
                    ];
                }
            }

            $db_doctors = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$service_id . "'")->rows;
            $doctors = [];
            if (!empty($db_doctors)) {
                foreach ($db_doctors as $doctor) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'   => $doctor['doctor_id']
                    ];
                }
            } else {
                foreach (unserialize($service['doctor_id']) as $id) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'     => $id
                    ];
                }
            }

            $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'")->rows;
            $facilities = [];
            foreach ($db_facilities as $facility) {
                $facilities[] = [
                    'service_id'    => $service_id,
                    'facility_id'   => $facility['facility_id']
                ];
            }

            $services[] = [
                'service_id'    => $service_id,
                'en_name'       => $service['en_name'],
                'cn_name'       => $service['cn_name'],
                'minute'        => $service['cs_minute'],
                'type'          => $service['type'],
                'stores'        => $stores,
                'doctors'       => $doctors,
                'facilities'    => $facilities,
            ];
        }
        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'services' => $services
        ];

        $path = 'etcm/syncing/syncing/update_services';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    private function createIfNotExist()
    {
        $service_facility_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_facility'")->num_rows;
        if (!$service_facility_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_facility` (
                `service_id` int(11) NOT NULL,
                `facility_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, facility_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $service_doctor_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_doctor'")->num_rows;
        if (!$service_doctor_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_doctor` (
                `service_id` int(11) NOT NULL,
                `doctor_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, doctor_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $service_store_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_store'")->num_rows;
        if (!$service_store_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_store` (
                `service_id` int(11) NOT NULL,
                `store_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, store_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $column_exist = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service status")->num_rows;

        if (!$column_exist) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `status` INT(1) NOT NULL AFTER `cs_minute`");
        }

        $column_exist2 = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service enable_appointment")->num_rows;

        if (!$column_exist2) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `enable_appointment` INT(1) NOT NULL AFTER `status`");
        }

        $column_exist3 = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service enable_etcm")->num_rows;

        if (!$column_exist3) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `enable_etcm` INT(1) NOT NULL AFTER `enable_appointment`");
        }
    }
}
