<?php
class ControllerSaleSupplierPaymentMethod extends Controller{
    private $error = [];

    public function index() {
        $this->load->language('sale/supplier_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/supplier_payment_method');
        
        $this->getList();
    }

    public function add() {
        $this->load->language('sale/supplier_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/supplier_payment_method');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_supplier_payment_method->addSupplierPaymentMethod($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('sale/supplier_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/supplier_payment_method');

        if (!isset($this->request->get['supplier_payment_method_id'])) {
            $this->response->redirect($this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'], true));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_supplier_payment_method->editSupplierPaymentMethod($this->request->post, $this->request->get['supplier_payment_method_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('sale/supplier_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/supplier_payment_method');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $supplier_payment_method_id) {
                $this->model_sale_supplier_payment_method->deleteSupplierPaymentMethod($supplier_payment_method_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }
    
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList() {
        if (isset($this->request->get['filter_payment_method_name'])) {
            $filter_payment_method_name = $this->request->get['filter_payment_method_name'];
        } else {
            $filter_payment_method_name = '';
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $filter_sql_accounting_code = $this->request->get['filter_sql_accounting_code'];
        } else {
            $filter_sql_accounting_code = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sort_order';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('sale/supplier_payment_method/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('sale/supplier_payment_method/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['payment_methods'] = array();

        $filter_data = array(
            'filter_payment_method_name'    => $filter_payment_method_name,
            'filter_sql_accounting_code'    => $filter_sql_accounting_code,
            'filter_status'                 => $filter_status,
            'sort'                          => $sort,
            'order'                         => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $results = $this->model_sale_supplier_payment_method->getSupplierPaymentMethods($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $payment_method_name_arr = json_decode($result['payment_method_name'], true);
                $payment_method_name = $payment_method_name_arr[$this->config->get('config_language_id')];

                if (!empty($filter_payment_method_name)) {
                    if (stripos($payment_method_name, $filter_payment_method_name) !== false) {
                        $data['payment_methods'][] = [
                            'supplier_payment_method_id'        => $result['supplier_payment_method_id'],
                            'payment_method_name'               => $payment_method_name,
                            'sql_accounting_code'               => $result['sql_accounting_code'],
                            'sort_order'                        => $result['sort_order'],
                            'status'                            => ($result['status'] == '1') ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                            'date_added'                        => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                            'edit'                              => $this->url->link('sale/supplier_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&supplier_payment_method_id=' . $result['supplier_payment_method_id'], true)
                        ];
                    }
                } else {
                    $data['payment_methods'][] = [
                        'supplier_payment_method_id'        => $result['supplier_payment_method_id'],
                        'payment_method_name'               => $payment_method_name,
                        'sql_accounting_code'               => $result['sql_accounting_code'],
                        'sort_order'                        => $result['sort_order'],
                        'status'                            => ($result['status'] == '1') ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                        'date_added'                        => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                        'edit'                              => $this->url->link('sale/supplier_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&supplier_payment_method_id=' . $result['supplier_payment_method_id'], true)
                    ];
                }
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'payment_method_name') {
                $payment_method_name_column = array_column($data['payment_methods'], 'payment_method_name');

                if ($order == 'ASC') {
                    array_multisort($data['payment_methods'], SORT_NUMERIC, $payment_method_name_column, SORT_ASC);
                } else {
                    array_multisort($data['payment_methods'], SORT_NUMERIC, $payment_method_name_column, SORT_DESC);
                }
            }
        }

        $total_payment_methods = count($data['payment_methods']);

        $data['payment_methods'] = array_slice($data['payment_methods'], $start, $limit);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_payment_method_name'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_method_name' . $url, true);
        $data['sort_sql_accounting_code'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=sql_accounting_code' . $url, true);
        $data['sort_status'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_sort_order'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_payment_methods;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_payment_methods) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_payment_methods - $this->config->get('config_limit_admin'))) ? $total_payment_methods : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_payment_methods, ceil($total_payment_methods / $this->config->get('config_limit_admin')));

        $data['filter_payment_method_name'] = $filter_payment_method_name;
        $data['filter_sql_accounting_code'] = $filter_sql_accounting_code;
        $data['filter_status'] = $filter_status;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/supplier_payment_method_list', $data));
    }

    protected function getForm() {
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['payment_method_name'])) {
            $data['error_payment_method_name'] = $this->error['payment_method_name'];
        } else {
            $data['error_payment_method_name'] = [];
        }

        if (isset($this->error['sql_accounting_code'])) {
            $data['error_sql_accounting_code'] = $this->error['sql_accounting_code'];
        } else {
            $data['error_sql_accounting_code'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['supplier_payment_method_id'])) {
            $data['action'] = $this->url->link('sale/supplier_payment_method/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/supplier_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&supplier_payment_method_id=' . $this->request->get['supplier_payment_method_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('sale/supplier_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['supplier_payment_method_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $payment_method_info = $this->model_sale_supplier_payment_method->getSupplierPaymentMethod($this->request->get['supplier_payment_method_id']);
        }

        $data['text_form'] = isset($this->request->get['supplier_payment_method_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');
        
        if (isset($this->request->post['payment_method_name'])) {
            $data['payment_method_name'] = $this->request->post['payment_method_name'];
        } elseif (!empty($payment_method_info)) {
            $data['payment_method_name'] = json_decode($payment_method_info['payment_method_name'], true);
        } else {
            $data['payment_method_name'] = [];
        }

        if (isset($this->request->post['sql_accounting_code'])) {
            $data['sql_accounting_code'] = $this->request->post['sql_accounting_code'];
        } elseif (!empty($payment_method_info)) {
            $data['sql_accounting_code'] = $payment_method_info['sql_accounting_code'];
        } else {
            $data['sql_accounting_code'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($payment_method_info)) {
            $data['status'] = $payment_method_info['status'];
        } else {
            $data['status'] = '0';
        }

        if (isset($this->request->post['sort_order'])) {
            $data['sort_order'] = $this->request->post['sort_order'];
        } elseif (!empty($payment_method_info)) {
            $data['sort_order'] = $payment_method_info['sort_order'];
        } else {
            $data['sort_order'] = '';
        }

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/supplier_payment_method_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/supplier_payment_method')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['payment_method_name'] as $language_id => $name) {
            if (empty($name)) {
                $this->error['payment_method_name']{$language_id} = $this->language->get('error_payment_method_name');
            }
        }

        if (empty($this->request->post['sql_accounting_code'])) {
            $this->error['sql_accounting_code'] = $this->language->get('error_sql_accounting_code');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'sale/supplier_payment_method')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
}
?>