<?php

class ControllerSalePurchaseInvoice extends Controller {

    private $error = array();
    private $order_status_arr = [1, 5];

    public function index() {
        $this->load->language('sale/purchase_invoice');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_invoice');

        $this->getList();
    }

    public function get_import_product() {
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('purchase_invoice');
        $this->cart = new Purchase_invoice($this->registry);
        $this->cart->clear();
        $this->cart->importType(3);

        $this->load->model('sale/purchase_invoice');
        $products = $this->model_sale_purchase_invoice->get_all_import_product();
        $data = [];
        $formatted_products = [];
        if (!empty($products)) {
            foreach ($products as $product) {
                $check = $this->model_sale_purchase_invoice->check_product_exists($product);
                if (!empty($check)) {
                    if (!empty($product['product_id'])) {
                        $type = $this->model_sale_purchase_invoice->getProductType($product['product_id']);
                    } else {
                        $type = '';
                    }

                    $formatted_products[] = [
                        'product_id' => $product['product_id'],
                        'name' => $product['name'],
                        'code' => $product['code'],
                        'quantity' => $product['stock'],
                        'price' => (float) $product['price'],
                        'type' => $type,
                        'check' => !empty($check) ? 1 : 0,
                    ];
                }
            }

            $exists = array_column($formatted_products, 'check');
            array_multisort($exists, SORT_DESC, $formatted_products);
        }

        if (!empty($formatted_products)) {
            foreach ($formatted_products as $ftp) {
                $this->cart->add($ftp['product_id'], $ftp['quantity'], number_format(round($ftp['price'], 4), 4), '');
            }
        }

        $cart_products = $this->cart->getProducts();

        $data['supplier_invoice'] = 'Zheng Qiang Supplier Invoice';
        $data['invoice_remark'] = 'Purcahse Invoice for Zheng Qiang Supplier';
        $data['comment'] = '';
        $data['payment_method'] = '';
        $data['payment_code'] = '';
        $data['type'] = 3;
        $data['order_status_id'] = 1;
        $data['stock_affect'] = 1;
        $data['date_added'] = '2018-09-01';
        $data['purchase_order_id'] = 0;

        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();

        $this->model_sale_purchase_invoice->add_purchase_invoice($data, $this->cart, $total_data);
    }

    public function productOrderCart() {
        $this->load->language('sale/purchase_invoice');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_invoice($this->registry);
        $data['products'] = $this->cart->getProducts();

        $this->response->setOutput($this->load->view('sale/purchase_invoice_cart', $data));
    }

    public function editProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_invoice($this->registry);


            $json = array(
                'success' => true,
                'respond' => $this->cart->edit($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function deleteProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_invoice($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->remove($product_id)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function productOrderTotal() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_invoice');
        $this->cart = new Purchase_invoice($this->registry);

        //total
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();

        $data['total_data'] = $total_data;

        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $getProduct = $this->cart->getProducts();
        $data['products'] = $getProduct;

        $this->response->setOutput($this->load->view('sale/purchase_invoice_cart', $data));
    }

    public function add() {
        $this->load->language('sale/purchase_invoice');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_invoice');
        $this->load->model('localisation/order_status');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_invoice');
        $this->cart = new Purchase_invoice($this->registry);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            //total
            $total_data = array();
            $total = 0;

            $total_data = $this->totalData();

            $this->load->language('sale/purchase_invoice');

            $this->model_sale_purchase_invoice->addPurchaseInvoice($this->request->post, $this->cart, $total_data);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->cart->clear();

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('sale/purchase_invoice');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_invoice');
        $this->load->model('localisation/order_status');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_invoice');
        $this->cart = new Purchase_invoice($this->registry);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {

            //total
            $total_data = array();
            $total = 0;

            $total_data = $this->totalData();

            $this->load->language('sale/purchase_invoice');

            $this->model_sale_purchase_invoice->editPurchaseInvoice($this->request->get['purchase_invoice_id'], $this->request->post, $this->cart, $total_data);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->cart->clear();

            $this->response->redirect($this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function info() {
        $this->load->language('sale/purchase_invoice');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_invoice');

        $purchase_invoice_id = isset($this->request->get['purchase_invoice_id']) ? $this->request->get['purchase_invoice_id'] : 0;
        if ($this->model_sale_purchase_invoice->purchaseInvoiceExistsById($purchase_invoice_id)) {
            $data['heading_title'] = $this->language->get('heading_title');

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $data['cancel'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true);
            $data['excel'] = $this->url->link('sale/purchase_invoice/exportExcel', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $purchase_invoice_id . $url, true);
            $data['edit'] = $this->url->link('sale/purchase_invoice/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $purchase_invoice_id . $url, true);

            if (isset($this->request->get['purchase_invoice_id'])) {
                $purchase_invoice_info = $this->model_sale_purchase_invoice->getPurchaseInvoice($purchase_invoice_id);
            } else {
                $purchase_invoice_info = array();
            }

            $product_invoice_products = $this->model_sale_purchase_invoice->getPurchaseInvoiceProducts($purchase_invoice_id);

            foreach ($product_invoice_products as $index => $product) {
                $product_invoice_products[$index]['net_amount'] = $this->currency->format($product['net_amount'], $this->config->get('config_currency'));
                $product_invoice_products[$index]['total_net_amount'] = $this->currency->format($product['total_net_amount'], $this->config->get('config_currency'));
                $product_invoice_products[$index]['total'] = $this->currency->format($product['total'], $this->config->get('config_currency'));
                $product_invoice_products[$index]['tax'] = $this->currency->format($product['tax'], $this->config->get('config_currency'));
                $product_invoice_products[$index]['total_tax'] = $this->currency->format($product['total_tax'], $this->config->get('config_currency'));
            }

            $label = '';
            switch ($purchase_invoice_info['order_status_id']) {
                case 1:
                    $label = 'warning';
                    break;
                case 5:
                    $label = 'success';
                    break;
            }

            $data['purchase_invoice_info'] = array(
                'invoice_prefix' => $purchase_invoice_info['invoice_prefix'],
                'supplier_invoice' => $purchase_invoice_info['supplier_invoice'],
                'order_status_id' => $purchase_invoice_info['order_status_id'],
                'order_status' => $purchase_invoice_info['order_status'],
                'invoice_remark' => nl2br($purchase_invoice_info['invoice_remark']),
                'manufacturer_name' => $purchase_invoice_info['manufacturer_name'],
                'manufacturer_code' => $purchase_invoice_info['manufacturer_code'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($purchase_invoice_info['date_added'])),
                'product_invoice_products' => $product_invoice_products,
                'label' => $label
            );

            $purchase_invoice_total = $this->model_sale_purchase_invoice->getPurchaseInvoiceTotals($purchase_invoice_id);
            foreach ($purchase_invoice_total as $total_data) {
                $data['purchase_invoice_total'][] = array(
                    'title' => $total_data['title'],
                    'text' => $this->currency->format($total_data['value'], $this->config->get('config_currency'))
                );
            }

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('sale/purchase_invoice_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    protected function getList() {
        if ((isset($this->request->get['filter_transaction_start']))) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = NULL;
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = NULL;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = NULL;
        }

        if (!empty($this->request->get['filter_search'])) {
            $filter_search = $this->request->get['filter_search'];
        } else {
            $filter_search = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_search'])) {
            $url .= '&filter_search=' . $this->request->get['filter_search'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['invoice'] = $this->url->link('sale/purchase_invoice/invoiceA5', 'user_token=' . $this->session->data['user_token'], true);
        $data['invoice_pdf'] = $this->url->link('sale/purchase_invoice/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['shipping'] = $this->url->link('sale/purchase_invoice/shipping', 'user_token=' . $this->session->data['user_token'], true);
        $data['receipt'] = $this->url->link('sale/purchase_invoice/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['insert'] = $this->url->link('sale/purchase_invoice/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['add'] = $this->url->link('sale/purchase_invoice/add', 'user_token=' . $this->session->data['user_token'], true);

        $data['orders'] = array();

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_order_status' => $filter_order_status,
            'search' => $filter_search,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_purchase_invoice->getTotalPurchaseInvoice($filter_data);

        $results = $this->model_sale_purchase_invoice->getPurchaseInvoices($filter_data);

        foreach ($results as $result) {

            $label = '';

            switch ($result['order_status_id']) {
                case 1:
                    $label = 'warning';
                    break;
                case 5:
                    $label = 'success';
                    break;
            }

            $data['orders'][] = array(
                'purchase_invoice_id' => $result['purchase_invoice_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'supplier_name' => $result['supplier_name'],
                'supplier_invoice' => $result['supplier_invoice'],
                'invoice_remark' => $result['invoice_remark'],
                'order_status_id' => $result['order_status_id'],
                'order_status' => $result['order_status'],
                'total' => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'invoiceA5' => $this->url->link('sale/purchase_invoice/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $result['purchase_invoice_id'] . '&pdf=1' . $url, true),
                'excel' => $this->url->link('sale/purchase_invoice/exportExcel', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $result['purchase_invoice_id'] . $url, true),
                'view' => $this->url->link('sale/purchase_invoice/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $result['purchase_invoice_id'] . $url, true),
                'edit' => $this->url->link('sale/purchase_invoice/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $result['purchase_invoice_id'] . $url, true),
                'label' => $label
            );
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_search'])) {
            $url .= '&filter_search=' . $this->request->get['filter_search'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_purchase_invoice_id'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=purchase_invoice_id' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=po.invoice_prefix' . $url, true);
        $data['sort_supplier_name'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=m.name' . $url, true);
        $data['sort_supplier_invoice'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=po.supplier_invoice' . $url, true);
        $data['sort_invoice_remark'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=po.invoice_remark' . $url, true);
        $data['sort_order_status'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=po.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . '&sort=po.date_modified' . $url, true);

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['filter_search'])) {
            $url .= '&filter_search=' . $this->request->get['filter_search'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_search'] = $filter_search;

        $this->load->model('localisation/order_status');

        foreach ($this->order_status_arr as $order_status_id) {
            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_status_id);

            if (!empty($order_status_info)) {
                $data['order_statuses'][] = $order_status_info;
            }
        }

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_invoice_list', $data));
    }

    public function getForm() {
        $this->load->model('sale/customer');

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['purchase_invoice_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];
        $data['store_id'] = $this->session->data['store_id'];

        $purchase_invoice_id = isset($this->request->get['purchase_invoice_id']) ? $this->request->get['purchase_invoice_id'] : 0;

        $data['purchase_invoice_id'] = !empty($purchase_invoice_id) ? $this->request->get['purchase_invoice_id'] : 0;

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        //Get Invoice From Purchase Receive
        $purchase_receive_id = isset($this->request->get['purchase_receive_id']) ? $this->request->get['purchase_receive_id'] : false;

        $data['purchase_receive_id2'] = $purchase_receive_id ? $this->request->get['purchase_receive_id'] : 0;

        if (isset($this->request->get['purchase_receive_id'])) {
            $purchase_receive_info = $this->model_sale_purchase_invoice->getPurchaseInvoiceByGoodReceive($purchase_receive_id);
        } else {
            $purchase_receive_info = array();
        }

        $data['purchase_receive_info'] = [];

        if (!empty($purchase_receive_info)) {
            $data['purchase_receive_info'] = [
                'purchase_receive_id' => $purchase_receive_info['purchase_receive_id'],
                'purchase_receive_invoice' => $purchase_receive_info['purchase_receive_prefix'],
                'supplier_id' => $purchase_receive_info['manufacturer_id'],
                'supplier_name' => $purchase_receive_info['manufacturer_name'],
                'supplier_code' => $purchase_receive_info['manufacturer_code']
            ];
        }
        //Get Invoice From Purchase Receive
        
        // echo '<pre>';
        // print_r($purchase_receive_info);
        // echo '</pre>';
        
        //Get Invoice From Purchase Order
        $purchase_order_id = isset($this->request->get['purchase_order_id']) ? $this->request->get['purchase_order_id'] : false;

        $data['purchase_order_id2'] = $purchase_order_id ? $this->request->get['purchase_order_id'] : 0;

        if (isset($this->request->get['purchase_order_id'])) {
            $purchase_order_info = $this->model_sale_purchase_invoice->getPurchaseInvoiceByPurchaseOrder($purchase_order_id);
        } else {
            $purchase_order_info = array();
        }

        $data['purchase_order_info'] = [];

        if (!empty($purchase_order_info)) {
            $data['purchase_order_info'] = [
                'purchase_order_id' => $purchase_order_info['purchase_order_id'],
                'purchase_order_invoice' => $purchase_order_info['purchase_order_prefix'],
                'order_supplier_id' => $purchase_order_info['manufacturer_id'],
                'order_supplier_name' => $purchase_order_info['manufacturer_name'],
                'order_supplier_code' => $purchase_order_info['manufacturer_code']
            ];
        }
        //Get Invoice From Purchase Order

        $data['cancel'] = $this->url->link('sale/purchase_invoice', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['sample_excel'] = HTTPS_SERVER . 'sample/purchase_invoice_sample.xlsx';

        if (isset($this->request->get['purchase_invoice_id'])) {
            $data['editmode'] = 1;
            $data['action'] = $this->url->link('sale/purchase_invoice/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $this->request->get['purchase_invoice_id'] . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/purchase_invoice/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        }

        if (isset($this->request->get['purchase_invoice_id'])) {
            $order_info = $this->model_sale_purchase_invoice->getPurchaseInvoice($this->request->get['purchase_invoice_id']);
        } else {
            $order_info = array();
        }

        if (isset($this->request->get['purchase_invoice_id'])) {
            $data['invoice_prefix'] = $order_info['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_invoice', 'store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['stock_affect'])) {
            $data['stock_affect'] = $this->request->post['stock_affect'];
        } elseif (isset($this->request->get['purchase_invoice_id'])) {
            $data['stock_affect'] = $order_info['stock_affect'];
        } else {
            $data['stock_affect'] = true;
        }

        if (isset($this->request->post['order_status_id'])) {
            $data['order_status_id'] = $this->request->post['order_status_id'];
        } elseif (isset($this->request->get['purchase_invoice_id'])) {
            $data['order_status_id'] = $order_info['order_status_id'];
        } else {
            $data['order_status_id'] = 1;
        }

        if (isset($this->request->post['supplier_invoice'])) {
            $data['supplier_invoice'] = $this->request->post['supplier_invoice'];
        } elseif (isset($this->request->get['purchase_invoice_id'])) {
            $data['supplier_invoice'] = $order_info['supplier_invoice'];
        } else {
            $data['supplier_invoice'] = "";
        }


        if (isset($this->request->post['invoice_remark'])) {
            $data['invoice_remark'] = $this->request->post['invoice_remark'];
        } elseif (isset($this->request->get['purchase_invoice_id'])) {
            $data['invoice_remark'] = $order_info['invoice_remark'];
        } else {
            $data['invoice_remark'] = '';
        }

        if (isset($this->request->post['manufacturer_id'])) {
            $data['supplier_id'] = $this->request->post['manufacturer_id'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['supplier_id'] = $order_info['manufacturer_id'];
        } else {
            $data['supplier_id'] = 0;
        }

        if (isset($this->request->post['supplier_name'])) {
            $data['supplier_name'] = $this->request->post['supplier_name'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['supplier_name'] = $order_info['manufacturer_name'];
        } else {
            $data['supplier_name'] = '';
        }

        if (isset($this->request->post['supplier_code'])) {
            $data['supplier_code'] = $this->request->post['supplier_code'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['supplier_code'] = $order_info['manufacturer_code'];
        } else {
            $data['supplier_code'] = '';
        }

        if (isset($this->request->post['purchase_order_invoice'])) {
            $data['purchase_order_invoice'] = $this->request->post['purchase_order_invoice'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['purchase_order_invoice'] = $order_info['purchase_order_invoice'];
        } else {
            $data['purchase_order_invoice'] = '';
        }

        if (isset($this->request->post['purchase_order_id'])) {
            $data['purchase_order_id'] = $this->request->post['purchase_order_id'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['purchase_order_id'] = $order_info['purchase_order_id'];
        } else {
            $data['purchase_order_id'] = 0;
        }

        if (isset($this->request->post['type'])) {
            $data['type'] = $this->request->post['type'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['type'] = $order_info['type'];
        } else {
            $data['type'] = 1;
        }

        if (isset($this->request->post['purchase_receive_invoice'])) {
            $data['purchase_receive_invoice'] = $this->request->post['purchase_receive_invoice'];
        } else {
            $data['purchase_receive_invoice'] = '';
        }

        if (isset($this->request->post['purchase_receive_id'])) {
            $data['purchase_receive_id'] = $this->request->post['purchase_receive_id'];
        } else {
            $data['purchase_receive_id'] = 0;
        }

        if ($this->request->server['REQUEST_METHOD'] != 'POST') {

            $this->cart->clear();

            if (isset($this->request->get['purchase_invoice_id'])) {

                $this->cart->importType($order_info['type'], $order_info['purchase_order_id']);

                $purchase_invoice_item = $this->model_sale_purchase_invoice->getPurchaseInvoiceItemsArray($this->request->get['purchase_invoice_id']);

                foreach ($purchase_invoice_item['product'] as $product_id => $product)
                    $this->cart->add($product_id, $product['quantity'], number_format(round($product['price'], 4), 4), $product['transaction_no']);

                //$name, $price, $quantity, $subtotal, $tax_class_id, $tax, $total

                foreach ($purchase_invoice_item['custom_product'] as $index => $product)
                    $this->cart->addCustomProduct($product['name'], number_format(round($product['price'], 4), 4), $product['quantity'], $product['total_net_amount'], $product['tax_class_id'], $product['total_tax'], $product['total']);
            }
        }

        $data['purchase_invoice_item'] = $this->cart->getProducts();
        $data['json_purchase_invoice_item'] = json_encode($this->cart->getProducts());

        $data['manufacturer_id'] = isset($this->request->post['manufacturer_id']) ? $this->request->post['manufacturer_id'] : false;
        $data['purchase_invoice_id'] = isset($this->request->get['purchase_invoice_id']) ? $this->request->get['purchase_invoice_id'] : 0;

        if (isset($this->request->post['payment_method'])) {
            $data['payment_method'] = $this->request->post['payment_method'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['payment_method'] = $order_info['payment_code'];
        } else {
            $data['payment_method'] = '';
        }

        if (isset($this->request->post['date_added'])) {
            $data['date_added'] = $this->request->post['date_added'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['date_added'] = date('Y-m-d', strtotime($order_info['date_added']));
        } else {
            $data['date_added'] = date('Y-m-d');
        }

        if (isset($this->request->post['comment'])) {
            $data['comment'] = $this->request->post['comment'];
        } else if (isset($this->request->get['purchase_invoice_id'])) {
            $data['comment'] = $order_info['comment'];
        } else {
            $data['comment'] = '';
        }

        $available_order_status = array();
        if (isset($this->request->get['purchase_request_id'])) {
            if ($order_info['order_status_id'] == 1) {//is pendding
                $available_order_status = array(1, 5, 7);
            } else {
                $available_order_status = array($order_info['order_status_id']);
            }
        } else {
            $available_order_status = array(1, 5);
        }

        $data['import_excel_action'] = $this->url->link('sale/purchase_invoice/import_excel', 'user_token=' . $this->session->data['user_token'], true);

        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $data['order_statuses'] = array();
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $available_order_status))
                $data['order_statuses'][] = $order_status;
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_invoice_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_invoice')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!($this->cart->totalProduct() > 0)) {

            $this->error['name']['empty_cart'] = $this->language->get('error_empty_cart');
            $this->error['warning'] = $this->language->get('error_empty_cart');
        }

        if (!$this->request->post['manufacturer_id']) {
            $this->error['name']['manufacturer_id'] = $this->language->get('error_manufacturer');
            $this->error['warning'] = $this->language->get('error_manufacturer');
        }


        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {            
            $code = isset($result['code']) ? $result['code'] : $result['key'];

            if ($this->config->get('total_' . $code . '_status')) {
                $this->load->model('pos/' . $code);
                $this->{'model_pos_' . $code}->getTotal($total_data);
            }
            
            $sort_order = array();
            
            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }
            
            array_multisort($sort_order, SORT_ASC, $totals);
        }

        return $totals;
    }

    //reporting output
    public function invoiceA5() {
        $this->load->language('sale/purchase_invoice_invoiceA5');

        $this->load->model('sale/purchase_invoice');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $data = array();

        $purchase_invoices = array();

        if (isset($this->request->post['selected'])) {
            $purchase_invoices = $this->request->post['selected'];
        } elseif (isset($this->request->get['purchase_invoice_id'])) {
            $purchase_invoices[] = $this->request->get['purchase_invoice_id'];
        }

        foreach ($purchase_invoices as $purchase_invoice_id) {
            $purchase_invoice_info = $this->model_sale_purchase_invoice->getPurchaseInvoice($purchase_invoice_id);
            $data['purchase_invoices'][$purchase_invoice_id] = $purchase_invoice_info;
            $purchase_invoice_products = $this->model_sale_purchase_invoice->getPurchaseInvoiceItems($purchase_invoice_id);

            $data['tax'] = array();

            foreach ($purchase_invoice_products as $index => $product) {
                $purchase_invoice_products[$index]['formatted_net_amount'] = $this->currency->format($product['net_amount'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);
                $purchase_invoice_products[$index]['formatted_total_net_amount'] = $this->currency->format($product['total_net_amount'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);
                $purchase_invoice_products[$index]['formatted_total_tax'] = $this->currency->format($product['total_tax'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);
                $purchase_invoice_products[$index]['formatted_total'] = $this->currency->format($product['total'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);

                if (!array_key_exists($product['tax_code'], $data['tax'])) {
                    $data['tax'][$product['tax_code']] = array(
                        'net_amount' => $product['total_net_amount'],
                        'tax' => $product['total_tax']
                    );
                } else {
                    $data['tax'][$product['tax_code']] = array(
                        'net_amount' => $data['tax'][$product['tax_code']]['net_amount'] + $product['total_net_amount'],
                        'tax' => $data['tax'][$product['tax_code']]['tax'] + $product['total_tax']
                    );
                }
            }

            foreach ($data['tax'] as $tax_code => $tax) {
                $data['purchase_invoices'][$purchase_invoice_id]['tax'][$tax_code]['net_amount'] = $this->currency->format($tax['net_amount'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);
                $data['purchase_invoices'][$purchase_invoice_id]['tax'][$tax_code]['tax'] = $this->currency->format($tax['tax'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value']);
            }

            $data['purchase_invoices'][$purchase_invoice_id]['products'] = $purchase_invoice_products;

            $data['purchase_invoices'][$purchase_invoice_id]['date_added'] = date($this->language->get('date_format_short'), strtotime($purchase_invoice_info['date_added']));

            $data['total_data'] = array();
            $totals = $this->model_sale_purchase_invoice->getPurchaseInvoiceTotals($purchase_invoice_id);

            foreach ($totals as $total) {
                $data['purchase_invoices'][$purchase_invoice_id]['total_data'][] = array(
                    'title' => $total['title'],
                    'text' => $this->currency->format($total['value'], $purchase_invoice_info['currency_code'], $purchase_invoice_info['currency_value'])
                );
            }
        }

        $store_info = $this->model_setting_setting->getSetting('config', $this->session->data['store_id']);
        if ($store_info) {
            $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
            $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

            $store_name = $store_info['config_name'];
            $store_address = $store_info['config_address'];
            $store_email = $store_info['config_email'];
            $store_telephone = $store_info['config_telephone'];
            $store_fax = $store_info['config_fax'];
            //$store_number = $store_info['config_number'];
            //$store_gstno = $store_info['config_gstno'];
            $store_country = $country['name'];
            $store_zone = $zone['name'];
        } else {
            $country = $this->model_localisation_country->getCountry($this->config->get('config_country_id'));
            $zone = $this->model_localisation_zone->getZone($this->config->get('config_zone_id'));

            $store_name = $this->config->get('config_name');
            $store_address = $this->config->get('config_address');
            $store_email = $this->config->get('config_email');
            $store_telephone = $this->config->get('config_telephone');
            $store_fax = $this->config->get('config_fax');
            $store_number = $this->config->get('config_code');
            $store_gstno = $this->config->get('config_gstno');
            $store_country = $country['name'];
            $zone = $zone['name'];
        }

        $data['store_name'] = $store_name;
        $data['store_address'] = nl2br($store_address);
        $data['store_country'] = $store_country;
        $data['store_zone'] = $store_zone;
        $data['store_telephone'] = $store_telephone;

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';


        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();

            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/purchase_invoice_invoiceA5', $data), $pdf_file_name, $page_size, $show));
        } else {
            $this->response->setOutput($this->load->view('sale/purchase_invoice_invoiceA5', $data));
        }
    }

    public function import_excel() {
        $json = [];
        $return_products = [];

        $this->load->model('sale/purchase_invoice');

        $excel_filename = $this->request->files['excel_file']['name'];

        $ext = pathinfo($excel_filename, PATHINFO_EXTENSION);

        if (strtolower($ext) != 'xlsx') {
            $json = [
                'success' => false
            ];
        } else {
            $this->load->library('PHPExcel');
            $this->excel = new PHPExcel();

            $obj_reader = PHPExcel_IOFactory::createReader('Excel2007');
            $obj_php_excel = $obj_reader->load($this->request->files['excel_file']['tmp_name']);

            $sheet = $obj_php_excel->getActiveSheet();
            $highest_row = $sheet->getHighestRow();
            $highest_column = $sheet->getHighestColumn();

            $sheets = [];

            for ($row = 1; $row <= $highest_row; $row++) {
                $sheets[$row] = $sheet->rangeToArray('A' . $row . ':' . $highest_column . $highest_row, null, true, false)[0];
            }

            $products_imported = [];
            $headers = array_shift($sheets);
            $header = array_filter($headers);

            foreach ($sheets as $d => $dt) {
                if (is_array($dt)) {
                    $products_imported[$d] = [];
                    foreach ($dt as $rd => $row) {
                        if (in_array($rd, array_keys($header))) {
                            $products_imported[$d][$header[$rd]] = $row;
                        }
                    }
                }
            }

            if (!empty($products_imported)) {
                $this->load->library('customer');
                $this->customer = new Customer($this->registry);

                $this->load->library('tax');
                $this->tax = new Tax($this->registry);

                $this->load->library('purchase_invoice');
                $this->cart = new Purchase_invoice($this->registry);
                $this->cart->clear();

                $this->cart->importType(5);

                foreach ($products_imported as $product) {
                    $product_code = $product['code'];

                    $product_info = $this->model_sale_purchase_invoice->getProductByCode($product_code);

                    if (!empty($product_info)) {
                        if ($product['quantity'] > 0) {
                            $this->cart->add($product_info['product_id'], $product['quantity'], $product['price']);
                        }
                    }
                }
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function exportExcel() {
        $this->load->model('sale/purchase_invoice');
        $this->load->language('sale/purchase_invoice_invoiceA5');

        $purchase_invoice_id = isset($this->request->get['purchase_invoice_id']) ? $this->request->get['purchase_invoice_id'] : 0;

        $pi_info = $this->model_sale_purchase_invoice->getPurchaseInvoice($purchase_invoice_id);

        if (!empty($pi_info)) {
            //get user detail
            $this->load->model('user/user');
            $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

            $this->load->library('PHPExcel');
            $objPHPExcel = new PHPExcel();

            // Set document properties
            $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                    ->setTitle("Title")
                    ->setSubject("Subject")
                    ->setDescription("Description")
                    ->setKeywords("report ptcm.etcm.me webceo")
                    ->setCategory("report excel");
            // Set default font
            $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                    ->setSize(10);
            // Table Data
            //get data collection from database
            $table_collection = array();

            $purchases = $this->model_sale_purchase_invoice->getPurchaseInvoiceItems($purchase_invoice_id);

            foreach ($purchases as $purchase) {
                $table_collection[] = array(
                    'code' => $purchase['code'],
                    'name' => $purchase['name'],
                    'quantity' => $purchase['quantity'],
                    'price' => $purchase['price'],
                    'total_net_amount' => $purchase['total_net_amount'],
                    'total_tax' => $purchase['total_tax'],
                    'total' => $purchase['total']
                );
            }

            $table = array();

            $table[] = array('Report Name : ', $this->language->get('heading_title'));
            $table[] = array('Invoice Prefix : ', $pi_info['invoice_prefix']);
            $table[] = array('Supplier Name : ', $pi_info['manufacturer_name']);
            $table[] = array('Supplier Invoice : ', $pi_info['supplier_invoice']);
            $table[] = array('Description : ', $pi_info['invoice_remark']);
            $table[] = array('Store Name : ', $this->config->get('config_name'));

            $table[] = array();

            $table_header = array(//table headers
                $this->language->get('column_product_code'),
                $this->language->get('column_product'),
                $this->language->get('column_quantity'),
                $this->language->get('column_amount'),
                $this->language->get('column_total_amount'),
                $this->language->get('column_tax'),
                $this->language->get('column_total')
            );

            $table[] = $table_header; //add header to table

            $table_data = $table_collection;
            $row;

            $total_row = 0;
            foreach ($table_data as $key => $data) {
                $row = array();
                foreach ($data as $key => $value) {
                    $row[] = $value;
                }
                $table[] = $row; //add data row to table
                $total_row++;
            }

            //  Styling
            $autosize_column_index = 'A';
            foreach ($table_header as $header) {//loop each header
                $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                $autosize_column_index++;
            }

            $header_index_s_column = 'A';
            $header_index_e_column = $header_index_s_column;
            foreach ($table_header as $col)
                $header_index_e_column++;
            $header_index_row = 8;
            $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

            $header_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                ),
                'font' => array(
                    'bold' => true
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

            $text_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
                ),
                'numberformat' => array(
                    'code' => "0"
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($text_style);

            $currency_style = array(
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                ),
                'numberformat' => array(
                    'code' => "0.00"
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
            $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
            $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
            $objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
            $objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

            // Add Array To Excel
            $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


            // Rename worksheet
            $sheettitle = $this->language->get('heading_title');
            $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
            $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);

            $filename = $this->language->get('heading_title') . '_' . $pi_info['invoice_prefix'];

            // Save Excel 2007 file
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            //ob_end_clean();
            // We'll be outputting an excel file
            header('Content-type: application/vnd.ms-excel');

            // It will be called file.xls
            header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
            $objWriter->save('php://output');
        }
    }

    //ajax
    public function changeImport() {
        $json = array('success' => false);
        $type = (isset($this->request->post['type'])) ? $this->request->post['type'] : false;

        if ($type) {
            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);
            $this->cart->clear();

            $this->cart->importType($type);

            $json = array(
                'success' => true
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addItemByPurchaseOrder() {
        $json = array('success' => false);

        $purchase_order_id = (isset($this->request->post['purchase_order_id'])) ? $this->request->post['purchase_order_id'] : false;

        if ($purchase_order_id) {
            $this->load->model('sale/purchase_invoice');

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);
            $this->cart->clear();

            $this->cart->importType(1, $purchase_order_id);

            $products = $this->model_sale_purchase_invoice->getPurchaseOrderItem($purchase_order_id);

            foreach ($products as $product) {
                if ($product['quantity'] > 0) {
                    $this->cart->add($product['product_id'], $product['quantity'], number_format(round($product['price'], 4), 4), $product['invoice_prefix']);
                }
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts(),
                'subtotal' => $this->cart->getSubtotal(),
                'tax' => $this->cart->getTaxes(),
                'total' => $this->cart->getTotal()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addItemByPurchaseReceive() {
        $json = array('success' => false);

        $purchase_receive_id = (isset($this->request->post['purchase_receive_id'])) ? $this->request->post['purchase_receive_id'] : false;

        if ($purchase_receive_id) {
            $this->load->model('sale/purchase_invoice');

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);
            $this->cart->clear();

            $this->cart->importType(4, $purchase_receive_id);

            $products = $this->model_sale_purchase_invoice->getPurchaseReceiveItem($purchase_receive_id);

            foreach ($products as $product) {
                if ($product['quantity'] > 0) {
                    $this->cart->add($product['product_id'], $product['quantity'], number_format(round(0, 4), 4), $product['invoice_prefix']);
                }
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts(),
                'subtotal' => $this->cart->getSubtotal(),
                'tax' => $this->cart->getTaxes(),
                'total' => $this->cart->getTotal()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addItemByHerbalRemedies() {
        $json = array('success' => false);

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($ranges) {
            $this->load->model('sale/purchase_invoice');

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);
            //$this->cart->clear();
            $this->cart->importType(2);

            $products = $this->model_sale_purchase_invoice->getHerbalRemediesItem($ranges);
            foreach ($products as $product) {
                $this->cart->add($product['product_id'], $product['quantity'], number_format(round($product['costprice'], 4), 4), '');
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addItemByPos() {
        $json = array('success' => false);

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($ranges) {
            $this->load->model('sale/purchase_invoice');

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);
            $this->cart->clear();

            $this->cart->importType(3);

            $products = $this->model_sale_purchase_invoice->getPosItem($ranges);
            foreach ($products as $product) {
                $this->cart->add($product['product_id'], $product['quantity'], number_format(round($product['costprice'], 4), 4), '');
            }

            $shippings = $this->model_sale_purchase_invoice->getPosShipping($ranges);

            foreach ($shippings as $shipping) {
                $this->cart->addCustomProduct($shipping['title'], $shipping['unit_price'], $shipping['quantity'], $shipping['subtotal'], $shipping['tax_class_id'], $shipping['tax'], $shipping['total']);
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addItem() {
        $this->load->model('sale/purchase_invoice');
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id) {
            $type = $this->model_sale_purchase_invoice->getProductType($product_id);
        } else {
            $type = '';
        }

        if ($product_id && $quantity) {
            $this->load->model('sale/purchase_invoice');

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);

            $this->cart->importType(6);

            $json = array(
                'success' => true,
                'respond' => $this->cart->add($product_id, $quantity, number_format(round($this->model_sale_purchase_invoice->getProductCost($product_id), 4), 4)),
                'subtotal' => $this->cart->getSubtotal(),
                'tax' => $this->cart->getTaxes(),
                'total' => $this->cart->getTotal()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function editItemQuantity() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->editQuantity($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function editItemPrice() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $custom_price = (isset($this->request->post['custom_price'])) ? $this->request->post['custom_price'] : NULL;

        if ($product_id && $custom_price != NULL) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);


            $json = array(
                'success' => true,
                'respond' => $this->cart->editPrice($product_id, number_format(round($custom_price, 4), 4))
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function deleteItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->remove($product_id)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function deleteCustomItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : NULL;

        if ($product_id != NULL) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_invoice');
            $this->cart = new Purchase_invoice($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->removeCustomProduct($product_id)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function clearItem() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_invoice');
        $this->cart = new Purchase_invoice($this->registry);
        $this->cart->clear();

        $json = array(
            'success' => true
        );

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

}

?>