<?php

class ControllerSaleOrderPrint extends Controller {
    public function printReceiptA5() {
        $this->load->model('sale/order');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $this->load->model('catalog/product');

        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_print_receipt_a5');
        } else {
            $this->load->language('sale/order_print_receipt_a5');
        }

        $data['title'] = $this->language->get('text_receipt');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        $data['print_time'] = date("Y-m-d H:i:s");


        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $order_info = [];
        $order_details = $this->getOrderPrint($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'order_info') {
                $order_info = $value;
                continue;
            }
            $data[$key] = $value;
        }

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }


        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_info['order_id'],
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            $data['pdf'] = true;

            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';
            $mpdf = new mPDF('utf-8', 'A5-L');
            $mpdf->writeHTML($this->load->view('sale/order_print_receipt_a5', $data));
            $mpdf->Output($pdf_file_name, 'I');
        }


        $this->response->setOutput($this->load->view('sale/order_print_receipt_a5', $data));
    }

    public function printReceiptRollPaper() {
        $this->load->model('sale/order');
        $this->load->model('setting/setting');
        $this->load->model('catalog/product');
        $this->load->model('localisation/zone');
        $this->load->model('localisation/country');

        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_receipt_roll_paper');
        } else {
            $this->load->language('sale/order_receipt_roll_paper');
        }

        $data['pdf'] = false;
        $data['title'] = $this->language->get('text_receipt');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['catalog']    = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;
        $data['print_time'] = date("Y-m-d H : i: s");

        $orders = [];
        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        $order_info = [];
        $order_details = $this->getOrderPrint($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'order_info') {
                $order_info = $value;
                continue;
            }
            $data[$key] = $value;
        }

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_info['order_id'],
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            $data['pdf'] = true;
            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';
            $mpdf = new mPDF('utf-8', 'A5-L');
            $mpdf->writeHTML($this->load->view('sale/order_receipt_roll_paper', $data));
            $mpdf->Output($pdf_file_name, 'I');
        }
        $this->response->setOutput($this->load->view('sale/order_receipt_roll_paper', $data));
    }

    public function printReceiptRollPaper2() {
        $this->load->model('sale/order');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_receipt_roll_paper2');
        } else {
            $this->load->language('sale/order_receipt_roll_paper2');
        }

        $data['title'] = $this->language->get('text_receipt');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        $data['orders'] = array();

        $data['print_time'] = date("Y-m-d H:i:s");

        $orders = array();
        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $order_info = [];
        $order_details = $this->getOrderPrint($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'order_info') {
                $order_info = $value;
                continue;
            }
            $data[$key] = $value;
        }

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_info['order_id'],
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            $data['pdf'] = true;
            include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';
            $mpdf = new mPDF('utf-8', 'A5-L');
            $mpdf->writeHTML($this->load->view('sale/order_receipt_roll_paper2', $data));
            $mpdf->Output($pdf_file_name, 'I');

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
        }

        $this->response->setOutput($this->load->view('sale/order_receipt_roll_paper2', $data));
    }

    protected function getOrderPrint($orders) {
        $data = array();
        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);
            $data['order_info'] = $order_info;

            $data['staff_firstname'] = $order_info['firstname'];
            $data['staff_lastname'] = $order_info['lastname'];


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}',
                    '{payment_method}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country'],
                    'payment_method' => $order_info['payment_method']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
                $data['fullname'] = $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}',
                    '{payment_method}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country'],
                    'payment_method' => $order_info['payment_method']

                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $data['whit_tax'] = 0;
                $data['product_tax'] = 0;
                $data['non_tax'] = 0;
                $data['product_non'] = 0;
                $total_quantity = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getPaidHerbals($order_id);
                $services = $this->model_sale_order->getPaidServies($order_id);


                $option_data = array();

                foreach ($herbales as $herbale) {


                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $total_quantity = $total_quantity + 1;

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'code'  =>  $herbale['invoice_prefix'],
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;//
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $total_quantity = $total_quantity + 1;

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'code'  =>  $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['total_d_gst'], $this->config->get('config_currency'))
                        );
                    } else {

                        $total_quantity = $total_quantity + 1;

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'code'  =>  $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['subtotal'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['subtotal'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['tax'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['total'], $this->config->get('config_currency'))
                        );

                        $total_quantity = $total_quantity + 1;


                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'code'  =>  $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0, $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                            'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                            'total' => $this->currency->format(0, $this->config->get('config_currency'))
                        );
                    }
                }

                foreach ($services as $service) {

                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $total_quantity = $total_quantity + 1;


                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'code'  =>  $service['invoice_prefix'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {

                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);


                    $total_quantity = $total_quantity + $product['quantity'];


                    $product_data[] = array(
                        'name' => $product['model'],
                        'code' => $product_info['code'],
                        'model' => $product['model'],
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $total,

                    );
                }

                $total_item = count($product_data);

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;



                foreach ($totals as $total) {
                    $total_data[] = array(
                        'title' => str_replace("_", " ", $total['code']),
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];

                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['currency'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));



                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'time_added' => date("H:i:s", strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'telephone' => $order_info['telephone'],
                    'payment_address' => $payment_address,
                    'product' => $product_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'tax' => $data['tax'],
                    'total_tax' => $data['total_tax'],
                    'sub_total' => $data['sub_total'],
                    'rounding' => $data['rounding'],
                    'shipping' => $data['shipping'],
                    'alltotal' => $data['alltotal'],
                    'staff_firstname' => $order_info['staff_firstname'],
                    'staff_lastname' => $order_info['staff_lastname'],
                    'payment_method' => $order_info['payment_method'],
                    'total_quantity' => $total_quantity,
                    'total_item' => $total_item,
                    'total_data' => $total_data,

                );
            }
        }

        return $data;
    }
}
