<?php

class ControllerSaleCustomerPayment extends Controller {

    private $error = [];

    public function index() {
        $this->load->language('sale/customer_payment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment');

        $this->getList();
    }

    public function add() {
        $this->load->language('sale/customer_payment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_customer_payment->addCustomerPayment($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_date_from'])) {
                $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_payment_date_to'])) {
                $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_name'])) {
                $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_payment_method'])) {
                $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('sale/customer_payment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment');

        if (!isset($this->request->get['customer_payment_id'])) {
            $this->response->redirect($this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'], true));
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_customer_payment->editCustomerPayment($this->request->post, $this->request->get['customer_payment_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_date_from'])) {
                $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_payment_date_to'])) {
                $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_name'])) {
                $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_payment_method'])) {
                $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function info() {
        $this->load->language('sale/customer_payment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment');

        if (!isset($this->request->get['customer_payment_id'])) {
            $this->response->redirect($this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'], true));
        } else {
            $url = '';

            if (isset($this->request->get['filter_payment_date_from'])) {
                $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_payment_date_to'])) {
                $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_name'])) {
                $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_payment_method'])) {
                $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $customer_payment_info = $this->model_sale_customer_payment->getCustomerPayment($this->request->get['customer_payment_id']);

            $data['customer_payment_info'] = [];

            if (!empty($customer_payment_info)) {
                $payment_method_name_arr = json_decode($customer_payment_info['payment_method_name'], true);
                $payment_method_name = $payment_method_name_arr[$this->config->get('config_language_id')];

                $transactions = $customer_payment_info['transactions'];

                foreach ($transactions as $index => $transaction) {
                    $transactions[$index]['amount'] = $this->currency->format($transaction['amount'], $this->config->get('config_currency'));
                    $transactions[$index]['outstanding_amount'] = $this->currency->format($transaction['outstanding_amount'], $this->config->get('config_currency'));
                    $transactions[$index]['pay_amount'] = $this->currency->format($transaction['pay_amount'], $this->config->get('config_currency'));
                }

                $data['customer_payment_info'] = [
                    'invoice_prefix' => $customer_payment_info['invoice_prefix'],
                    'payment_date' => date($this->language->get('date_format_short'), strtotime($customer_payment_info['payment_date'])),
                    'customer_name' => $customer_payment_info['customer_name'],
                    'customer_ic' => $customer_payment_info['customer_ic'],
                    'description' => nl2br($customer_payment_info['description']),
                    'customer_payment_method' => $payment_method_name,
                    'cheque_num' => $customer_payment_info['cheque_num'],
                    'bank_charge' => $this->currency->format($customer_payment_info['bank_charge'], $this->config->get('config_currency')),
                    'paid_amount' => $this->currency->format($customer_payment_info['paid_amount'], $this->config->get('config_currency')),
                    'unapplied_amount' => $this->currency->format($customer_payment_info['unapplied_amount'], $this->config->get('config_currency')),
                    'transactions' => $transactions,
                    'total_amount' => $this->currency->format($customer_payment_info['total_amount'], $this->config->get('config_currency')),
                    'total_outstanding_amount' => $this->currency->format($customer_payment_info['total_outstanding_amount'], $this->config->get('config_currency')),
                    'total_pay_amount' => $this->currency->format($customer_payment_info['total_pay_amount'], $this->config->get('config_currency'))
                ];
            }
        }

        $data['edit'] = $this->url->link('sale/customer_payment/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_id=' . $this->request->get['customer_payment_id'], true);
        $data['cancel'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/customer_payment_info', $data));
    }

    public function get_customer_transaction() {
        $json = [];
        $return_transactions = [];

        $this->load->model('sale/customer_payment');

        $customer_id = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;
        $customer_payment_id = isset($this->request->post['customer_payment_id']) ? $this->request->post['customer_payment_id'] : false;
        $grandtotal_paid_amount = isset($this->request->post['total_paid_amount']) ? (float) $this->request->post['total_paid_amount'] : 0;
        $total_unapplied_amount = isset($this->request->post['total_unapplied_amount']) ? $this->request->post['total_unapplied_amount'] : 0;
        $paid_arr = isset($this->request->post['paid']) ? $this->request->post['paid'] : [];

        $total_amount = 0;
        $total_outstanding_amount = 0;
        $total_pay_amount = 0;
        $loop_transactions = [];

        if ($customer_id) {
            $transactions = $this->model_sale_customer_payment->getCustomerTransactions($customer_id);

            if (!empty($transactions)) {
                if (!empty($paid_arr)) {
                    foreach ($transactions as $transaction) {
                        $transaction_order_id = (int) $transaction['order_id'];

                        if (in_array($transaction_order_id, $paid_arr)) {
                            $paid_arr_index = array_search($transaction_order_id, $paid_arr);

                            $loop_transactions[$paid_arr_index] = $transaction;
                        }
                    }
                }

                foreach ($transactions as $transaction) {
                    if (!in_array($transaction['order_id'], $paid_arr)) {
                        $loop_transactions[] = $transaction;
                    }
                }

                // sort the array by index
                ksort($loop_transactions);

                foreach ($loop_transactions as $transaction) {
                    $amount = round($transaction['total'], 2);

                    $db_total_amount_row = $this->model_sale_customer_payment->getTotalCustomerPaymentTransactionHistory($transaction['order_id'], $customer_payment_id);
                    $customer_payment_transactions = $this->model_sale_customer_payment->getCustomerPaymentTransactions($transaction['order_id'], $customer_payment_id);
                    $customer_payment_transaction_info = $this->model_sale_customer_payment->getCustomerPaymentTransaction($transaction['order_id'], $customer_payment_id);

                    $db_total_amount = isset($db_total_amount_row['total_amount']) ? $db_total_amount_row['total_amount'] : 0;
                    $db_total_outstanding_amount = isset($db_total_amount_row['total_outstanding_amount']) ? $db_total_amount_row['total_outstanding_amount'] : 0;
                    $db_total_paid_amount = isset($db_total_amount_row['total_pay_amount']) ? $db_total_amount_row['total_pay_amount'] : 0;

                    $outstanding_amount = $amount - $db_total_amount;

                    $pay_amount = 0;

                    if (in_array($transaction['order_id'], $paid_arr)) {
                        if ($db_total_outstanding_amount > 0) {
                            if (!empty($customer_payment_transactions)) {
                                if (count($customer_payment_transactions) == 1) {
                                    $pay_amount = (end($paid_arr) == $transaction['order_id']) ? $customer_payment_transaction_info['pay_amount'] : $db_total_amount - $db_total_paid_amount;
                                } else {
                                    $pay_amount = $db_total_amount - $db_total_paid_amount;
                                }
                            } else {
                                $pay_amount = (end($paid_arr) == $transaction['order_id']) ? $db_total_outstanding_amount : $db_total_amount - $db_total_paid_amount;
                            }
                        } else {
                            if (!empty($customer_payment_transactions)) {
                                $pay_amount = $customer_payment_transaction_info['pay_amount'];
                            } else {
                                $pay_amount = $amount;
                            }
                        }
                    } else {
                        $pay_amount = $pay_amount;
                    }

                    $outstanding_amount = ($db_total_paid_amount < $amount) ? $amount - $db_total_paid_amount : ($amount - $db_total_amount);

                    if (in_array($transaction['order_id'], $paid_arr)) {
                        if ($db_total_outstanding_amount > 0) {
                            if (!empty($customer_payment_transactions)) {
                                if (count($customer_payment_transactions) == 1) {
                                    $outstanding_amount = (end($paid_arr) == $transaction['order_id']) ? $customer_payment_transaction_info['outstanding_amount'] : 0;
                                } else {
                                    $outstanding_amount = 0;
                                }
                            } else {
                                $outstanding_amount = (end($paid_arr) == $transaction['order_id']) ? $db_total_outstanding_amount - $pay_amount : 0;
                            }
                        } else {
                            if (!empty($customer_payment_transactions)) {
                                $outstanding_amount = $customer_payment_transaction_info['outstanding_amount'];
                            } else {
                                $outstanding_amount = $amount - $pay_amount;
                            }
                        }
                    }

                    if ($db_total_paid_amount < $amount) {
                        $return_transactions[$transaction['order_id']] = [
                            'order_id' => $transaction['order_id'],
                            'date' => date($this->language->get('date_format_short'), strtotime($transaction['date_added'])),
                            'invoice_prefix' => $transaction['invoice_prefix'],
                            'amount' => sprintf('%0.2f', $amount),
                            'outstanding_amount' => sprintf('%0.2f', $outstanding_amount),
                            'pay_amount' => sprintf('%0.2f', $pay_amount)
                        ];

                        $total_amount += $amount;
                        $total_outstanding_amount += $outstanding_amount;
                        $total_pay_amount += $pay_amount;
                    }

                    if ($grandtotal_paid_amount < $total_pay_amount) {
                        if (end($paid_arr) == $transaction['order_id']) {
                            // remove current loop's pay amount first, because need use all unapplied amount and calculate the pay amount for last transaction                              
                            $total_pay_amount -= $pay_amount;
                            $total_outstanding_amount -= $outstanding_amount;

                            if ($db_total_outstanding_amount > 0) {
                                if (!empty($customer_payment_transactions)) {
                                    if ($total_unapplied_amount == 0) {
                                        $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                        if (count($paid_arr) == 1) {
                                            if ($grandtotal_paid_amount > $current_outstanding_amount) {
                                                $last_outstanding_amount = $grandtotal_paid_amount - $current_outstanding_amount;
                                            } else {
                                                $last_outstanding_amount = $current_outstanding_amount - $grandtotal_paid_amount;
                                            }
                                        } else {
                                            if (count($customer_payment_transactions) == 1) {
                                                $last_outstanding_amount = $customer_payment_transaction_info['outstanding_amount'] - ($grandtotal_paid_amount - $total_pay_amount);
                                            } else {
                                                $last_outstanding_amount = $grandtotal_paid_amount - $total_pay_amount;
                                            }
                                        }
                                    } else {
                                        $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                        if ($current_outstanding_amount > $total_unapplied_amount) {
                                            $last_outstanding_amount = $current_outstanding_amount - $total_unapplied_amount;
                                        } else {
                                            $last_outstanding_amount = 0;
                                        }
                                    }
                                } else {
                                    $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                    if ($current_outstanding_amount > $total_unapplied_amount) {
                                        $last_outstanding_amount = $current_outstanding_amount - $total_unapplied_amount;
                                    } else {
                                        $last_outstanding_amount = 0;
                                    }
                                }
                            } else {
                                if (!empty($customer_payment_transactions)) {
                                    if ($total_unapplied_amount == 0) {
                                        $last_outstanding_amount = $customer_payment_transaction_info['outstanding_amount'];
                                    } else {
                                        $last_outstanding_amount = $amount - $total_unapplied_amount;
                                    }
                                } else {
                                    if (end($paid_arr) == $transaction['order_id']) {
                                        if (count($paid_arr) == 1) {
                                            $last_outstanding_amount = $amount - $grandtotal_paid_amount;
                                        } else {
                                            // enter this
                                            $last_outstanding_amount = $amount - ($grandtotal_paid_amount - $total_pay_amount);
                                        }
                                    } else {
                                        $last_outstanding_amount = ($amount > $total_unapplied_amount) ? $amount - $total_unapplied_amount : 0;
                                    }
                                }
                            }

                            if ($db_total_outstanding_amount > 0) {
                                if (!empty($customer_payment_transactions)) {
                                    if ($total_unapplied_amount == 0) {
                                        $last_pay_amount = $db_total_outstanding_amount - $last_outstanding_amount;
                                    } else {
                                        $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                        if ($current_outstanding_amount > $total_unapplied_amount) {
                                            $last_pay_amount = $total_unapplied_amount;
                                        } else {
                                            $last_pay_amount = $amount - $db_total_paid_amount;
                                        }
                                    }
                                } else {
                                    $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                    $last_pay_amount = ($current_outstanding_amount > $total_unapplied_amount) ? $total_unapplied_amount : $current_outstanding_amount;
                                }
                            } else {
                                $last_pay_amount = $amount - $last_outstanding_amount;
                            }

                            $return_transactions[$transaction['order_id']]['outstanding_amount'] = sprintf('%0.2f', $last_outstanding_amount);
                            $return_transactions[$transaction['order_id']]['pay_amount'] = sprintf('%0.2f', $last_pay_amount);

                            $total_outstanding_amount += $last_outstanding_amount;
                            $total_pay_amount += $last_pay_amount;
                        }
                    } else {
                        if (end($paid_arr) == $transaction['order_id']) {
                            // remove current loop's pay amount first, because need use all unapplied amount and calculate the pay amount for last transaction             
                            $total_pay_amount -= $pay_amount;
                            $total_outstanding_amount -= $outstanding_amount;

                            if ($db_total_outstanding_amount > 0) {
                                if (!empty($customer_payment_transactions)) {
                                    if ($total_unapplied_amount == 0) {
                                        if (count($customer_payment_transactions) == 1) {
                                            $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                            if ($grandtotal_paid_amount > $current_outstanding_amount) {
                                                $last_outstanding_amount = 0;
                                            } else {
                                                $last_outstanding_amount = $customer_payment_transaction_info['outstanding_amount'];
                                            }
                                        } else {
                                            $last_outstanding_amount = 0;
                                        }
                                    } else {
                                        if (count($customer_payment_transactions) == 1) {
                                            $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                            if ($grandtotal_paid_amount > $current_outstanding_amount) {
                                                $last_outstanding_amount = 0;
                                            } else {
                                                $last_outstanding_amount = $customer_payment_transaction_info['outstanding_amount'];
                                            }
                                        } else {
                                            $last_outstanding_amount = 0;
                                        }
                                    }
                                } else {
                                    $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                    if ($current_outstanding_amount > $total_unapplied_amount) {
                                        $last_outstanding_amount = $current_outstanding_amount - $total_unapplied_amount;
                                    } else {
                                        $last_outstanding_amount = 0;
                                    }
                                }
                            } else {
                                if (!empty($customer_payment_transactions)) {
                                    $last_outstanding_amount = $customer_payment_transaction_info['outstanding_amount'];
                                } else {
                                    $last_outstanding_amount = 0;
                                }
                            }

                            if ($db_total_outstanding_amount > 0) {
                                if (!empty($customer_payment_transactions)) {
                                    if ($total_unapplied_amount == 0) {
                                        if (count($customer_payment_transactions) == 1) {
                                            $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                            if ($grandtotal_paid_amount > $current_outstanding_amount) {
                                                $last_pay_amount = $current_outstanding_amount;
                                            } else {
                                                $last_pay_amount = $customer_payment_transaction_info['pay_amount'];
                                            }
                                        } else {
                                            $last_pay_amount = $db_total_amount - $db_total_paid_amount;
                                        }
                                    } else {
                                        if (count($customer_payment_transactions) == 1) {
                                            $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                            if ($grandtotal_paid_amount > $current_outstanding_amount) {
                                                $last_pay_amount = $current_outstanding_amount;
                                            } else {
                                                $last_pay_amount = $customer_payment_transaction_info['pay_amount'];
                                            }
                                        } else {
                                            $last_pay_amount = $db_total_amount - $db_total_paid_amount;
                                        }
                                    }
                                } else {
                                    $current_outstanding_amount = $db_total_amount - $db_total_paid_amount;

                                    $last_pay_amount = ($current_outstanding_amount > $total_unapplied_amount) ? $total_unapplied_amount : $current_outstanding_amount;
                                }
                            } else {
                                if (!empty($customer_payment_transactions)) {
                                    $last_pay_amount = $customer_payment_transaction_info['pay_amount'];
                                } else {
                                    $last_pay_amount = $amount;
                                }
                            }

                            $return_transactions[$transaction['order_id']]['outstanding_amount'] = sprintf('%0.2f', $last_outstanding_amount);
                            $return_transactions[$transaction['order_id']]['pay_amount'] = sprintf('%0.2f', $last_pay_amount);

                            $total_outstanding_amount += $last_outstanding_amount;
                            $total_pay_amount += $last_pay_amount;
                        }
                    }
                }
            }

            // top input paid amount - tfoot pay total amount
            $total_unapplied_amount = $grandtotal_paid_amount - $total_pay_amount;

            $return_data = [
                'total_paid_amount' => sprintf('%0.2f', $grandtotal_paid_amount),
                'total_unapplied_amount' => sprintf('%0.2f', $total_unapplied_amount),
                'total_amount' => sprintf('%0.2f', $total_amount),
                'total_outstanding_amount' => sprintf('%0.2f', $total_outstanding_amount),
                'total_pay_amount' => sprintf('%0.2f', $total_pay_amount),
                'transactions' => array_values($return_transactions)
            ];

            $json = [
                'error' => false,
                'data' => $return_data,
                'message' => 'get the customer transactions success'
            ];
        } else {
            $json = [
                'error' => true,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function getList() {
        if (isset($this->request->get['filter_payment_date_from'])) {
            $filter_payment_date_from = $this->request->get['filter_payment_date_from'];
        } else {
            $filter_payment_date_from = '';
        }

        if (isset($this->request->get['filter_payment_date_to'])) {
            $filter_payment_date_to = $this->request->get['filter_payment_date_to'];
        } else {
            $filter_payment_date_to = '';
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
        } else {
            $filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_customer_name'])) {
            $filter_customer_name = $this->request->get['filter_customer_name'];
        } else {
            $filter_customer_name = '';
        }

        if (isset($this->request->get['filter_customer_payment_method'])) {
            $filter_customer_payment_method = $this->request->get['filter_customer_payment_method'];
        } else {
            $filter_customer_payment_method = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'cp.invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_payment_date_from'])) {
            $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_date_to'])) {
            $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_payment_method'])) {
            $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('sale/customer_payment/add', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['customer_payments'] = array();

        $filter_data = array(
            'filter_payment_date_from' => $filter_payment_date_from,
            'filter_payment_date_to' => $filter_payment_date_to,
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_customer_name' => $filter_customer_name,
            'filter_customer_payment_method' => $filter_customer_payment_method,
            'sort' => $sort,
            'order' => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $results = $this->model_sale_customer_payment->getCustomerPayments($filter_data);

        $total_payments = count($results);

        if (!empty($results)) {
            foreach ($results as $result) {
                $customer_payment_method_arr = json_decode($result['payment_method_name'], true);
                $customer_payment_method = $customer_payment_method_arr[$this->config->get('config_language_id')];

                $data['customer_payments'][] = [
                    'customer_payment_id' => $result['customer_payment_id'],
                    'invoice_prefix' => $result['invoice_prefix'],
                    'payment_date' => date($this->language->get('date_format_short'), strtotime($result['payment_date'])),
                    'customer_name' => $result['customer_name'],
                    'customer_payment_method' => $customer_payment_method,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'paid_amount' => $this->currency->format($result['paid_amount'], $this->config->get('config_currency')),
                    'unapplied_amount' => $this->currency->format($result['unapplied_amount'], $this->config->get('config_currency')),
                    'view' => $this->url->link('sale/customer_payment/info', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_id=' . $result['customer_payment_id'], true),
                    'edit' => $this->url->link('sale/customer_payment/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_id=' . $result['customer_payment_id'], true)
                ];
            }
        }

        $data['customer_payments'] = array_slice($data['customer_payments'], $start, $limit);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_payment_date_from'])) {
            $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_date_to'])) {
            $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_payment_method'])) {
            $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_invoice_prefix'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.invoice_prefix' . $url, true);
        $data['sort_payment_date'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.payment_date' . $url, true);
        $data['sort_customer_name'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, true);
        $data['sort_customer_payment_method'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.customer_payment_method_id' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.date_added' . $url, true);
        $data['sort_paid_amount'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.paid_amount' . $url, true);
        $data['sort_unapplied_amount'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . '&sort=cp.unapplied_amount' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_payment_date_from'])) {
            $url .= '&filter_payment_date_from=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_from'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_date_to'])) {
            $url .= '&filter_payment_date_to=' . urlencode(html_entity_decode($this->request->get['filter_payment_date_to'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_payment_method'])) {
            $url .= '&filter_customer_payment_method=' . $this->request->get['filter_customer_payment_method'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['payment_methods'] = [];

        $payment_methods = $this->model_sale_customer_payment->getPaymentMethods();

        if (!empty($payment_methods)) {
            foreach ($payment_methods as $payment_method) {
                $payment_method_name_arr = json_decode($payment_method['payment_method_name'], true);
                $payment_method_name = $payment_method_name_arr[$this->config->get('config_language_id')];

                $data['payment_methods'][] = [
                    'customer_payment_method_id' => $payment_method['customer_payment_method_id'],
                    'name' => $payment_method_name
                ];
            }
        }

        $pagination = new Pagination();
        $pagination->total = $total_payments;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_payments) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_payments - $this->config->get('config_limit_admin'))) ? $total_payments : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_payments, ceil($total_payments / $this->config->get('config_limit_admin')));

        $data['filter_payment_date_from'] = $filter_payment_date_from;
        $data['filter_payment_date_to'] = $filter_payment_date_to;
        $data['filter_invoice_prefix'] = $filter_invoice_prefix;
        $data['filter_customer_name'] = $filter_customer_name;
        $data['filter_customer_payment_method'] = $filter_customer_payment_method;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/customer_payment_list', $data));
    }

    protected function getForm() {
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['payment_date'])) {
            $data['error_payment_date'] = $this->error['payment_date'];
        } else {
            $data['error_payment_date'] = '';
        }

        if (isset($this->error['customer_name'])) {
            $data['error_customer_name'] = $this->error['customer_name'];
        } else {
            $data['error_customer_name'] = '';
        }

        if (isset($this->error['payment_method'])) {
            $data['error_payment_method'] = $this->error['payment_method'];
        } else {
            $data['error_payment_method'] = '';
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['customer_payment_id'])) {
            $data['action'] = $this->url->link('sale/customer_payment/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/customer_payment/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_id=' . $this->request->get['customer_payment_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('sale/customer_payment', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['customer_payment_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $payment_info = $this->model_sale_customer_payment->getCustomerPayment($this->request->get['customer_payment_id']);
        }

        $data['text_form'] = isset($this->request->get['customer_payment_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($payment_info)) {
            $data['invoice_prefix'] = $payment_info['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer_payment', 'store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['payment_date'])) {
            $data['payment_date'] = $this->request->post['payment_date'];
        } elseif (!empty($payment_info)) {
            $data['payment_date'] = $payment_info['payment_date'];
        } else {
            $data['payment_date'] = '';
        }

        if (isset($this->request->post['customer_name'])) {
            $data['customer_name'] = $this->request->post['customer_name'];
        } elseif (!empty($payment_info)) {
            $data['customer_name'] = $payment_info['customer_name'];
        } else {
            $data['customer_name'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } elseif (!empty($payment_info)) {
            $data['customer_ic'] = $payment_info['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } elseif (!empty($payment_info)) {
            $data['customer_id'] = $payment_info['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->post['description'])) {
            $data['description'] = $this->request->post['description'];
        } elseif (!empty($payment_info)) {
            $data['description'] = $payment_info['description'];
        } else {
            $data['description'] = '';
        }

        if (isset($this->request->post['customer_payment_method_id'])) {
            $data['customer_payment_method_id'] = $this->request->post['customer_payment_method_id'];
        } elseif (!empty($payment_info)) {
            $data['customer_payment_method_id'] = $payment_info['customer_payment_method_id'];
        } else {
            $data['customer_payment_method_id'] = '';
        }

        if (isset($this->request->post['cheque_num'])) {
            $data['cheque_num'] = $this->request->post['cheque_num'];
        } elseif (!empty($payment_info)) {
            $data['cheque_num'] = $payment_info['cheque_num'];
        } else {
            $data['cheque_num'] = '';
        }

        if (isset($this->request->post['bank_charge'])) {
            $data['bank_charge'] = $this->request->post['bank_charge'];
        } elseif (!empty($payment_info)) {
            $data['bank_charge'] = $payment_info['bank_charge'];
        } else {
            $data['bank_charge'] = '';
        }

        if (isset($this->request->post['paid_amount'])) {
            $data['paid_amount'] = $this->request->post['paid_amount'];
        } elseif (!empty($payment_info)) {
            $data['paid_amount'] = $payment_info['paid_amount'];
        } else {
            $data['paid_amount'] = '0.00';
        }

        if (isset($this->request->post['unapplied_amount'])) {
            $data['unapplied_amount'] = $this->request->post['unapplied_amount'];
        } elseif (!empty($payment_info)) {
            $data['unapplied_amount'] = $payment_info['unapplied_amount'];
        } else {
            $data['unapplied_amount'] = '0.00';
        }

        if (isset($this->request->post['transactions'])) {
            $data['transactions'] = $this->request->post['transactions'];
        } elseif (!empty($payment_info)) {
            $data['transactions'] = $payment_info['transactions'];
        } else {
            $data['transactions'] = [];
        }

        $paid_order_id_arr = array_column($data['transactions'], 'paid');
        $data['paid'] = '[' . implode(', ', $paid_order_id_arr) . ']';

        if (isset($this->request->post['total_amount'])) {
            $data['total_amount'] = $this->request->post['total_amount'];
        } elseif (!empty($payment_info)) {
            $data['total_amount'] = $payment_info['total_amount'];
        } else {
            $data['total_amount'] = '0.00';
        }

        if (isset($this->request->post['total_outstanding_amount'])) {
            $data['total_outstanding_amount'] = $this->request->post['total_outstanding_amount'];
        } elseif (!empty($payment_info)) {
            $data['total_outstanding_amount'] = $payment_info['total_outstanding_amount'];
        } else {
            $data['total_outstanding_amount'] = '0.00';
        }

        if (isset($this->request->post['total_pay_amount'])) {
            $data['total_pay_amount'] = $this->request->post['total_pay_amount'];
        } elseif (!empty($payment_info)) {
            $data['total_pay_amount'] = $payment_info['total_pay_amount'];
        } else {
            $data['total_pay_amount'] = '0.00';
        }

        $data['user_token'] = $this->session->data['user_token'];
        $data['store_id'] = $this->session->data['store_id'];
        $data['customer_payment_id'] = isset($this->request->get['customer_payment_id']) ? $this->request->get['customer_payment_id'] : 0;

        $data['payment_methods'] = [];

        $payment_methods = $this->model_sale_customer_payment->getPaymentMethods();

        if (!empty($payment_methods)) {
            foreach ($payment_methods as $method) {
                $payment_method_name_arr = json_decode($method['payment_method_name'], true);
                $payment_method_name = $payment_method_name_arr[$this->config->get('config_language_id')];

                $data['payment_methods'][] = [
                    'customer_payment_method_id' => $method['customer_payment_method_id'],
                    'name' => $payment_method_name
                ];
            }
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/customer_payment_form', $data));
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_ic'])) {
            if (isset($this->request->get['filter_name'])) {
                $filter_name = $this->request->get['filter_name'];
            } else {
                $filter_name = '';
            }

            if (isset($this->request->get['filter_ic'])) {
                $filter_ic = $this->request->get['filter_ic'];
            } else {
                $filter_ic = '';
            }

            $this->load->model('sale/customer_payment');

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_ic' => $filter_ic,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_sale_customer_payment->getCustomers($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'customer_id' => $result['customer_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'customer_ic' => $result['customer_ic']
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/customer_payment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['payment_date'])) {
            $this->error['payment_date'] = $this->language->get('error_payment_date');
        }

        if (empty($this->request->post['customer_id'])) {
            $this->error['customer_name'] = $this->language->get('error_customer');
        }

        if (empty($this->request->post['customer_payment_method_id'])) {
            $this->error['payment_method'] = $this->language->get('error_payment_method');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function customerList() {
        $this->load->language('sale/customer_payment');

        $this->document->setTitle($this->language->get('text_customer_list'));

        $this->load->model('sale/customer_payment');

        if (isset($this->request->get['customer_name'])) {
            $customer_name = $this->request->get['customer_name'];
        } else {
            $customer_name = NULL;
        }

        if (isset($this->request->get['customer_ic'])) {
            $customer_ic = $this->request->get['customer_ic'];
        } else {
            $customer_ic = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['customer_name'])) {
            $url .= '&customer_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_ic'])) {
            $url .= '&customer_ic=' . urlencode(html_entity_decode($this->request->get['customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['customers'] = array();

        $filter_data = array(
            'customer_name' => $customer_name,
            'customer_ic' => $customer_ic,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_sale_customer_payment->getTotalCustomers($filter_data);
        $results = $this->model_sale_customer_payment->getCustomersforopenwindow($filter_data);

        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'data_encoded' => htmlspecialchars(json_encode($result))
            );
        }

        $data['text_list'] = $this->language->get('text_customer_list');

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        ;
        $pagination->url = $this->url->link('sale/customer_payment/customerList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['customer_name'] = $customer_name;
        $data['customer_ic'] = $customer_ic;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/customer_list', $data));
    }

}

?>