<?php

class ControllerSaleCarrier extends Controller {

    public function index() {
        $this->load->language('sale/carrier');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/carrier');
        $this->getList();
    }

    public function add() {
        $this->load->language('sale/carrier');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/carrier');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_sale_carrier->addCarrier($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/carrier', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function update() {
        $this->load->language('sale/carrier');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/carrier');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_sale_carrier->editCarrier($this->request->get['carrier_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/carrier', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('sale/carrier');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/carrier');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {

            foreach ($this->request->post['selected'] as $carrier_id) {
                $this->model_sale_carrier->deleteCarrier($carrier_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/carrier', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function getList() {

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['add'] = $this->url->link('sale/carrier/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('sale/carrier/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['carriers'] = array();

        $pagelimit = 15;

        $filter_data = array(
            'start' => ($page - 1) * $pagelimit,
            'limit' => $pagelimit
        );

        $carrier_total = $this->model_sale_carrier->getTotalCarriers();
        $results = $this->model_sale_carrier->getCarriers($filter_data);
        $this->load->model('tool/image');
        
//        echo"<pre>";
//        print_r($results);
//        echo"</pre>";

        foreach ($results as $result) {
            if ($result['image'] && file_exists(DIR_IMAGE . $result['image'])) {
                $image = $this->model_tool_image->resize($result['image'], 110, 30);
            } else {
                $image = $this->model_tool_image->resize('no_image.jpg', 110, 30);
            }

            $data['carriers'][] = array(
                'carrier_id' => $result['carrier_id'],
                'name' => $result['name'],
                'image' => $image,
                'url' => $result['tracking_url'],
                'edit' => $this->url->link('sale/carrier/update', 'user_token=' . $this->session->data['user_token'] . '&carrier_id=' . $result['carrier_id'] . $url, true)
            );
        }

        $data['ext_name'] = $this->_ext_name;
        $data['ext_title'] = $this->_ext_title;
        $data['dev_name'] = $this->_dev_name;
        $data['dev_email'] = $this->_dev_email;
        $data['ext_version'] = $this->_ext_version;

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';
        $pagelimit = 15;

        $pagination = new Pagination();
        $pagination->total = $carrier_total;
        $pagination->page = $page;
        $pagination->limit = $pagelimit;
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('sale/carrier', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($carrier_total) ? (($page - 1) * $pagelimit) + 1 : 0, ((($page - 1) * $pagelimit) > ($carrier_total - $pagelimit)) ? $carrier_total : ((($page - 1) * $pagelimit) + $pagelimit), $carrier_total, ceil($carrier_total / $pagelimit));

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/carrier_list', $data));
    }

    public function getForm() {

        $this->load->language('sale/carrier');

        $data['text_form'] = !isset($this->request->get['carrier_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = '';
        }

        if (isset($this->error['url'])) {
            $data['error_url'] = $this->error['url'];
        } else {
            $data['error_url'] = '';
        }

        $url = '';

        if (!isset($this->request->get['carrier_id'])) {
            $data['action'] = $this->url->link('sale/carrier/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/carrier/update', 'user_token=' . $this->session->data['user_token'] . '&carrier_id=' . $this->request->get['carrier_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('sale/carrier', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['carrier_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $carrier_info = $this->model_sale_carrier->getCarrier($this->request->get['carrier_id']);
        }

        if (isset($this->request->post['image'])) {
            $data['image'] = $this->request->post['image'];
        } elseif (!empty($carrier_info)) {
            $data['image'] = $carrier_info['image'];
        } else {
            $data['image'] = '';
        }

        $this->load->model('tool/image');

        if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 110, 30);
        } elseif (!empty($carrier_info) && is_file(DIR_IMAGE . $carrier_info['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($carrier_info['image'], 110, 30);
        } else {
            $data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        $data['user_token'] = $this->session->data['user_token'];
        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($carrier_info)) {
            $data['name'] = $carrier_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['url'])) {
            $data['url'] = $this->request->post['url'];
        } elseif (!empty($carrier_info)) {
            $data['url'] = $carrier_info['tracking_url'];
        } else {
            $data['url'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/carrier_form', $data));
    }

    protected function validateForm() {

        if (!$this->user->hasPermission('modify', 'sale/carrier')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 100)) {
            $this->error['name'] = $this->language->get('error_name');
        }

        if ((utf8_strlen($this->request->post['url']) < 3) || (utf8_strlen($this->request->post['url']) > 1000)) {
            $this->error['url'] = $this->language->get('error_url');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'sale/carrier')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

}
