<?php
class ControllerReportTopCustomerReport extends Controller {
	protected function c_format($data) {
		return $this->currency->format($data,$this->config->get('config_currency'));
	}
	public function index() {
		$msc = microtime(true);
		$this->load->model('report/top_customer_report');
		$this->load->language('report/top_customer_report');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		

		$this->document->setTitle($this->language->get('heading_title'));
		
		//**filter

        $data['date_types'][] = [
            'text' => 'Custom',
            'value' => 'custom'
        ];
        $data['date_types'][] = [
            'text' => 'Today',
            'value' => 'today'
        ];
        $data['date_types'][] = [
            'text' => 'Yesterdays',
            'value' => 'Yesterday'
        ];
        $data['date_types'][] = [
            'text' => 'Last 7 days',
            'value' => 'Last_7_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 30 days',
            'value' => 'Last_30_days'
        ];

        $config_date_type = 'custom';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

        if($filter_date_type != 'custom' ){
            $date_now = date('Y-m-d');
            switch ($filter_date_type) {
                // case 'all':
                // 	$filter_date_start2 = '';
                // 	$filter_date_end2 = '';
                // 	break;
                case 'today':
                    $filter_date_start2 = date('Y-m-d');
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Yesterday':
                    $filter_date_start2 = date('Y-m-d',strtotime('-1 days'));
                    $filter_date_end2 = date('Y-m-d',strtotime('-1 days'));
                    break;
                case 'Last_7_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-7 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Last_30_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-30 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                default:
                    $filter_date_start2 =  '1999-01-01';
                    $filter_date_end2 = '2999-12-31';
                    break;
            }
            // $data['selected_date_type'] = $filter_date_type;
        } else{
            $filter_date_start2 = $filter_date_start;
            $filter_date_end2 = $filter_date_end;
        }


        $this->request->get['filter_date_start'] = $filter_date_start;
        $this->request->get['filter_date_end'] = $filter_date_end;

		
		if (isset($this->request->get['filter_store_id'])) {
			
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}
		
		if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}
		
		if (isset($this->request->get['filter_telephone'])) {
			$filter_telephone  = $this->request->get['filter_telephone'];
		} else {
			$filter_telephone  = '';
		}

        if (isset($this->request->get['filter_gender'])) {
			$filter_gender  = $this->request->get['filter_gender'];
		} else {
			$filter_gender  = '';
		}

        if (isset($this->request->get['filter_age_start'])) {
			$filter_age_start  = $this->request->get['filter_age_start'];
		} else {
			$filter_age_start  = '';
		}

        if (isset($this->request->get['filter_age_end'])) {
			$filter_age_end  = $this->request->get['filter_age_end'];
		} else {
			$filter_age_end  = '';
		}

        if (isset($this->request->get['filter_last_visit_start'])) {
			$filter_last_visit_start  = $this->request->get['filter_last_visit_start'];
		} else {
			$filter_last_visit_start  = '';
		}

        if (isset($this->request->get['filter_last_visit_end'])) {
			$filter_last_visit_end  = $this->request->get['filter_last_visit_end'];
		} else {
			$filter_last_visit_end  = '';
		}

		if (isset($this->request->get['filter_new_return_start'])) {
			$filter_new_return_start  = $this->request->get['filter_new_return_start'];
		} else {
			$filter_new_return_start  = '';
		}

		if (isset($this->request->get['filter_new_return_end'])) {
			$filter_new_return_end  = $this->request->get['filter_new_return_end'];
		} else {
			$filter_new_return_end  = '';
		}

        if (isset($this->request->get['filter_customer_group'])) {
			$filter_customer_group  = $this->request->get['filter_customer_group'];
		} else {
			$filter_customer_group  = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}
		
		if (isset($this->request->get['filter_telephone'])) {
			$url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}

        if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

        if (isset($this->request->get['filter_age_start'])) {
			$url .= '&filter_age_start=' . $this->request->get['filter_age_start'];
		}

        if (isset($this->request->get['filter_age_end'])) {
			$url .= '&filter_age_end=' . $this->request->get['filter_age_end'];
		}

        if (isset($this->request->get['filter_date_type'])) {
			$url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
		}

        if (isset($this->request->get['filter_last_visit_start'])) {
			$url .= '&filter_last_visit_start=' . $this->request->get['filter_last_visit_start'];
		}

        if (isset($this->request->get['filter_last_visit_end'])) {
			$url .= '&filter_last_visit_end=' . $this->request->get['filter_last_visit_end'];
		}

		if (isset($this->request->get['filter_new_return_start'])) {
			$url .= '&filter_new_return_start=' . $this->request->get['filter_new_return_starts'];
		}

		if (isset($this->request->get['filter_new_return_end'])) {
			$url .= '&filter_new_return_end=' . $this->request->get['filter_new_return_end'];
		}

        if (isset($this->request->get['filter_customer_group'])) {
			$url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/top_customer_report', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/top_customer_report/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start2,
			'filter_date_end' 		=> $filter_date_end2,
			'filter_store_id' 		=> $filter_store_id,
			'filter_name'	=> $filter_name,
			'filter_telephone' => $filter_telephone,
            'filter_gender'         => $filter_gender,
            'filter_age_start'      => $filter_age_start,
            'filter_age_end'        => $filter_age_end,
            'filter_last_visit_start'=> $filter_last_visit_start,
            'filter_last_visit_end' => $filter_last_visit_end,
            'filter_new_return_start' => $filter_new_return_start,
            'filter_new_return_end' => $filter_new_return_end,
            'filter_customer_group' => $filter_customer_group,
            'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_name'] = $filter_name;
		$data['filter_telephone'] = $filter_telephone;
		$data['filter_gender'] = $filter_gender;
		$data['filter_age_start'] = $filter_age_start;
		$data['filter_age_end'] = $filter_age_end;
		$data['filter_last_visit_start'] = $filter_last_visit_start;
		$data['filter_last_visit_end'] = $filter_last_visit_end;
		$data['filter_new_return_start'] = $filter_new_return_start;
		$data['filter_new_return_end'] = $filter_new_return_end;

		$data['filter_customer_group'] = $filter_customer_group;

		
		//**data
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$data['user_view'] = $this->user->user_view;
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['payment_methods'] = $this->model_report_top_customer_report->getPaymentMethod();
        		
        $data['customer_groups'] = $this->model_report_top_customer_report->getCustomerGroup();

		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$data['sales'] = array();
		$customerlists = $this->model_report_top_customer_report->getTopcustomerlist($filter_data);
		$total_num = 0; 
		foreach($customerlists as $customerlist){
			if(($customerlist['date_added'] >= $filter_new_return_start) && $customerlist['date_added'] <= $filter_new_return_end){
				$new_return = 'NEW';

			}elseif($customerlist['date_added'] == date('Y-m-d') ){
				$new_return = 'NEW';
			}else{
				$new_return = 'RETURN';

			}
            $num =1;
			$data['customer_list'][] = array(
				'name' => $customerlist['name'],
				'telephone' => $customerlist['telephone'],
				'age' => $customerlist['age'],
				'gender' => $customerlist['gender'],
				'customer_group' => $customerlist['customer_group'],
				'date_added' => DATE('Y-m-d',strtotime($customerlist['date_added'])),
                'new_return' => $new_return,
                'first_visit' => DATE('Y-m-d',strtotime($customerlist['first_visit'])),
                'last_visit' => $customerlist['last_visit'],
                'medical_record' => $customerlist['medical_record'],
                'service_record' => $customerlist['service_record'],
                'total' => $customerlist['medical_record'] +  $customerlist['service_record'],
                'store_id' => $this->model_report_top_customer_report->getstore($customerlist['store_id']),
				'view' => $this->url->link('customer/customer/edit','user_token=' . $this->session->data['user_token'].'&customer_id='.$customerlist['customer_id'] , true),

			);
			$total_num += $num; 
		}

        $data['total_amount'] = $this->model_report_top_customer_report->getalltotal($filter_data);
        
      
		$data['total_num'] = $total_num;

        $data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/top_customer_report')){
			$data['user_modify'] = true;
		}

		$data['customer_modify'] = false;
		if($this->user->hasPermission('modify', 'customer/customer')){
			$data['customer_modify'] = true;
		}

		//** soting url
		//rebuild querystring for sorting
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}
		
		if (isset($this->request->get['filter_telephone'])) {
			$url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}

        if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

        if (isset($this->request->get['filter_age_start'])) {
			$url .= '&filter_age_start=' . $this->request->get['filter_age_start'];
		}

        if (isset($this->request->get['filter_age_end'])) {
			$url .= '&filter_age_end=' . $this->request->get['filter_age_end'];
		}

        if (isset($this->request->get['filter_date_type'])) {
			$url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
		}

        if (isset($this->request->get['filter_last_visit_start'])) {
			$url .= '&filter_last_visit_start=' . $this->request->get['filter_last_visit_start'];
		}

        if (isset($this->request->get['filter_last_visit_end'])) {
			$url .= '&filter_last_visit_end=' . $this->request->get['filter_last_visit_end'];
		}

		if (isset($this->request->get['filter_new_return_start'])) {
			$url .= '&filter_new_return_start=' . $this->request->get['filter_new_return_start'];
		}

		if (isset($this->request->get['filter_new_return_end'])) {
			$url .= '&filter_new_return_end=' . $this->request->get['filter_new_return_end'];
		}

        if (isset($this->request->get['filter_customer_group'])) {
			$url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_top_customer_report->getTopcustomerlistnumber($filter_data);
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/top_customer_report', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

		$msc = microtime(true)-$msc;
		/*echo '<pre>';
		print_r($msc);
		echo '</pre>';*/
		
		//**layout
		$this->response->setOutput($this->load->view('report/top_customer_report_list', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/top_customer_report');
		$this->load->language('report/top_customer_report');
		
		//**filter
        
        $config_date_type = 'custom';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

        if($filter_date_type != 'custom' ){
            $date_now = date('Y-m-d');
            switch ($filter_date_type) {
                // case 'all':
                // 	$filter_date_start2 = '';
                // 	$filter_date_end2 = '';
                // 	break;
                case 'today':
                    $filter_date_start2 = date('Y-m-d');
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Yesterday':
                    $filter_date_start2 = date('Y-m-d',strtotime('-1 days'));
                    $filter_date_end2 = date('Y-m-d',strtotime('-1 days'));
                    break;
                case 'Last_7_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-7 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Last_30_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-30 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                default:
                    $filter_date_start2 =  '1999-01-01';
                    $filter_date_end2 = '2999-12-31';
                    break;
            }
            // $data['selected_date_type'] = $filter_date_type;
        } else{
            $filter_date_start2 = $filter_date_start;
            $filter_date_end2 = $filter_date_end;
        }


        $this->request->get['filter_date_start'] = $filter_date_start;
        $this->request->get['filter_date_end'] = $filter_date_end;

		
		if (isset($this->request->get['filter_store_id'])) {
			
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
	
	if (isset($this->request->get['filter_name'])) {
			$filter_name = $this->request->get['filter_name'];
		} else {
			$filter_name = '';
		}
	
	if (isset($this->request->get['filter_telephone'])) {
		$filter_telephone  = $this->request->get['filter_telephone'];
	} else {
		$filter_telephone  = '';
	}

	if (isset($this->request->get['filter_gender'])) {
		$filter_gender  = $this->request->get['filter_gender'];
	} else {
		$filter_gender  = '';
	}

	if (isset($this->request->get['filter_new_return'])) {
		$filter_new_return  = $this->request->get['filter_new_return'];
	} else {
		$filter_new_return  = '';
	}

	if (isset($this->request->get['filter_age_start'])) {
		$filter_age_start  = $this->request->get['filter_age_start'];
	} else {
		$filter_age_start  = '';
	}

	if (isset($this->request->get['filter_age_end'])) {
		$filter_age_end  = $this->request->get['filter_age_end'];
	} else {
		$filter_age_end  = '';
	}

	if (isset($this->request->get['filter_last_visit_start'])) {
		$filter_last_visit_start  = $this->request->get['filter_last_visit_start'];
	} else {
		$filter_last_visit_start  = '';
	}

	if (isset($this->request->get['filter_last_visit_end'])) {
		$filter_last_visit_end  = $this->request->get['filter_last_visit_end'];
	} else {
		$filter_last_visit_end  = '';
	}

	if (isset($this->request->get['filter_new_return_start'])) {
		$filter_new_return_start  = $this->request->get['filter_new_return_start'];
	} else {
		$filter_new_return_start  = '';
	}

	if (isset($this->request->get['filter_new_return_end'])) {
		$filter_new_return_end  = $this->request->get['filter_new_return_end'];
	} else {
		$filter_new_return_end  = '';
	}

	if (isset($this->request->get['filter_customer_group'])) {
		$filter_customer_group  = $this->request->get['filter_customer_group'];
	} else {
		$filter_customer_group  = '';
	}
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start2,
			'filter_date_end' 		=> $filter_date_end2,
			'filter_store_id' 		=> $filter_store_id,
			'filter_name'	=> $filter_name,
			'filter_telephone' => $filter_telephone,
            'filter_gender'         => $filter_gender,
            'filter_new_return'     => $filter_new_return,
            'filter_age_start'      => $filter_age_start,
            'filter_age_end'        => $filter_age_end,
            'filter_last_visit_start'=> $filter_last_visit_start,
            'filter_last_visit_end' => $filter_last_visit_end,
            'filter_new_return_start' => $filter_new_return_start,
            'filter_new_return_end'   => $filter_new_return_end,
            'filter_customer_group' => $filter_customer_group,
			
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		// $sales = $this->model_report_top_customer_report->getSalesSummary($filter_data);
		
			
		
		$table_collection = array();

		$customerlists = $this->model_report_top_customer_report->getTopcustomerlist($filter_data);
		foreach($customerlists as $customerlist){
			if(($customerlist['date_added'] >= $filter_new_return_start) && $customerlist['date_added'] <= $filter_new_return_end){
				$new_return = 'NEW';

			}elseif($customerlist['date_added'] == date('Y-m-d') ){
				$new_return = 'NEW';
			}else{
				$new_return = 'RETURN';

			}
			$table_collection[] = array(
			
				'name' => $customerlist['name'] . '[' . $new_return . ']',
				'age' => $customerlist['age'],
				'gender' => $customerlist['gender'],
				'telephone' => $customerlist['telephone'],
				'customer_group' => $customerlist['customer_group'],
                'first_visit' => DATE('Y-m-d',strtotime($customerlist['first_visit'])),
                'last_visit' => $customerlist['last_visit'],
                'medical_record' => $customerlist['medical_record'],
                'service_record' => $customerlist['service_record'],
                'total' => $customerlist['medical_record'] +  $customerlist['service_record'],
                'store_id' => $this->model_report_top_customer_report->getstore($customerlist['store_id']),

			);
		}
        $data['total_amount'] = $this->model_report_top_customer_report->getalltotal($filter_data);

		$table_collection[] = array(
			'TOTAL NEW :',
			$data['total_amount']['new_customer'],
			'TOTAL RETURNING :',
			$data['total_amount']['return_customer'],
			'TOTAL MEDICAL RECORD :',
			$data['total_amount']['medical_record'],
			'TOTAL SERVICES :',
			$data['total_amount']['service_record'],
			'',
			'',
			'',
		);
		
		
		$table = array();
		
		
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		$table_header = array(//table headers
			$this->language->get('column_name'),
			$this->language->get('column_age'),
			$this->language->get('column_gender'),
			$this->language->get('column_telephone'),
			$this->language->get('column_customer_group'),
			$this->language->get('column_first_visit'),
			$this->language->get('column_last_visit'),
			$this->language->get('column_medical_record'),
			$this->language->get('column_service_record'),
			$this->language->get('column_total'),
			$this->language->get('column_store')

		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row));
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))	;
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row));
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>