<?php
class ControllerReportServiceformSummaryByTransaction extends Controller {
	public function index() {
		$this->load->language('report/serviceform_summary_by_transaction');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $url = $this->getFilterUrl();
		

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/serviceform_summary_by_transaction', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/serviceform_summary_by_transaction/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/serviceform_summary_by_transaction');

		$data['orders'] = array();

		$filter_data = $this->getFiltersData();
		$filter_data_with_pagination = $this->getFiltersData(true);

		$total_transaction = $this->model_report_serviceform_summary_by_transaction->getServiceformSummaryByTransactionTotal($filter_data);

		$results = $this->model_report_serviceform_summary_by_transaction->getServiceformSummaryByTransaction($filter_data_with_pagination);

		$total_amounts = $this->model_report_serviceform_summary_by_transaction->getServiceformSummaryByTransactionTotalAmount($filter_data);

		$order_statuses = $this->model_report_serviceform_summary_by_transaction->orderstatus($filter_data['filter_payment_status']);
		
		foreach ($results as $result) {			
			$data['orders'][] = array(
				'service_date' => $result['service_date'],
				'invoice_prefix' 	=>  $result['invoice_prefix'],
				'card'				=> $result['card'],
				'payment_status'	=> $result['payment_status'],
				'service_status'	=> $result['service_status'],
				'customer_ic' 		=> $result['customer_ic'],
				'name'   			=> $result['name'],
				'invoice'				=> $result['invoice'],
				'invoice_date'			=> $result['invoice_date'],
				'total_price'=> $this->currency->format($result['total_price'], $this->config->get('config_currency')),
				'subtotal' 			=>  $this->currency->format($result['subtotal'], $this->config->get('config_currency')),
				'tax' 				=> $this->currency->format($result['tax'], $this->config->get('config_currency')),
				'total'				=> $this->currency->format($result['total'], $this->config->get('config_currency'))
			);
		}		
		
		$total_price = 0;
		$total_subtotal = 0;
		$total_tax = 0;
		$total_total = 0;
		

		foreach($total_amounts as $total_amount){
			$total_price += $total_amount['total_price'];
			$total_subtotal += $total_amount['subtotal'];
			$total_tax += $total_amount['tax'];
			$total_total += $total_amount['total'];
		}

		$data['totals'] = array(
			'total_price'		=> $this->currency->format($total_price, $this->config->get('config_currency')),
			'total_subtotal'	=> $this->currency->format($total_subtotal, $this->config->get('config_currency')),
			'total_tax'			=> $this->currency->format($total_tax, $this->config->get('config_currency')),
			'total_total'		=> $this->currency->format($total_total, $this->config->get('config_currency')),			
		);
		$data['user_token'] = $this->session->data['user_token'];
		$data['doctors'] = $this->model_report_serviceform_summary_by_transaction->getdoctorlist();
		$data['itemlist'] = $this->model_report_serviceform_summary_by_transaction->getservicename();

		
		
		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		// $this->load->model('service/clinical_service');
		// $data['services'] = array();
		
		// $services = $this->model_service_clinical_service->get_clinical_services_report();

		// foreach($services as $service){
		// 	$data['services'][] = array(
		// 		'id' => $service['clinicalservice_id'],
		// 		'name' => $service['name']
		// 	);
		// }
		
		// $this->load->model('localisation/order_status');

		// $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		// $data['service_statuses'] = $this->model_localisation_order_status->getServiceStatus();

		$data['filter_date_type'] = $filter_data['filter_date_type'];
		$data['filter_date_start'] = $filter_data['filter_date_start'];
		$data['filter_date_end'] = $filter_data['filter_date_end'];
		$data['filter_invoice_date_type'] = $filter_data['filter_invoice_date_type'];
		$data['filter_invoice_date_start'] = $filter_data['filter_invoice_date_start'];
		$data['filter_invoice_date_end'] = $filter_data['filter_invoice_date_end'];
		$data['filter_transaction_start'] = $filter_data['filter_transaction_start'];
		$data['filter_transaction_end'] = $filter_data['filter_transaction_end'];
		$data['filter_customer_card'] = $filter_data['filter_customer_card'];
		$data['filter_customer_name'] = $filter_data['filter_customer_name'];
		$data['filter_store_id'] = $filter_data['filter_store_id'];
		$data['filter_status_id'] = explode(',',$filter_data['filter_status_id']);
		$data['filter_payment_status'] = explode(',',$filter_data['filter_payment_status']);
		$data['filter_doctor_name'] = explode(',',$filter_data['filter_doctor_name']);
		$data['filter_service_name'] = explode(',',$filter_data['filter_service_name']);
		$page = $filter_data['page'];
		$data['sort'] = $filter_data['sort'];
		$data['order'] = $filter_data['order'];
        $pagination_url = $this->getFilterUrl(true);
		

		$pagination = new Pagination();
		$pagination->total = $total_transaction;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/serviceform_summary_by_transaction', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/serviceform_summary_by_transaction')){
			$data['user_modify'] = true;
		}

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$data['service_statuses'] = $this->model_report_serviceform_summary_by_transaction->getServiceStatuses();
		$data['payment_statuses'] = $this->model_report_serviceform_summary_by_transaction->getPaymentStatuses();
        $data['date_types'] = $this->getDateTypes();

		

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/serviceform_summary_by_transaction', $data));
	}
	
	public function exportExcel(){		
		$this->load->model('report/serviceform_summary_by_transaction');
		$this->load->language('report/serviceform_summary_by_transaction');
		
		$filter_data = $this->getFiltersData();
		
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");

		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		
		$results = $this->model_report_serviceform_summary_by_transaction->getServiceformSummaryByTransaction($filter_data);

		$total_amounts = $this->model_report_serviceform_summary_by_transaction->getServiceformSummaryByTransactionTotalAmount($filter_data);

		$order_statuses = $this->model_report_serviceform_summary_by_transaction->orderstatus($filter_data['filter_payment_status']);

		$service_statuses = $this->model_report_serviceform_summary_by_transaction->orderstatus($filter_data['filter_status_id']);

		$filter_status = '';
		// if($filter_data['filter_status_id'] == '1'){
		// 	$filter_status = 'PENDING';
		// }elseif($filter_data['filter_status_id'] == '5'){
		// 	$filter_status = 'COMPLETE';
		// }elseif($filter_data['filter_status_id'] == '7'){
		// 	$filter_status = 'CANCELED';

		// }
		$filter_payment_status = '';
		// if($filter_data['filter_payment_status'] == '1'){
		// 	$filter_payment_status = 'PENDING';
		// }elseif($filter_data['filter_payment_status'] == '5'){
		// 	$filter_payment_status = 'COMPLETE';
		// }elseif($filter_data['filter_payment_status'] == '7'){
		// 	$filter_payment_status = 'CANCELED';

		// }
		if(!empty($filter_data['filter_payment_status'])){
			$filter_payment_status = $this->model_report_serviceform_summary_by_transaction->status($filter_data['filter_payment_status']);

		}
		if(!empty($filter_data['filter_status_id'])){
			$filter_status = $this->model_report_serviceform_summary_by_transaction->status($filter_data['filter_status_id']);

		}
		
		$table_collection = array();
		
		foreach ($results as $result) {	
			if($result['payment_status'] == 5 ){
				$text_payment_status=$this->language->get('text_complete');
			}else if($result['payment_status'] == 17){
				$text_payment_status=$this->language->get('text_not_paid');
			}else if($result['payment_status'] == 1){
				$text_payment_status=$this->language->get('text_pending');
			}else if($result['payment_status'] == 7){
				$text_payment_status=$this->language->get('text_canceled');

			}	

			if($result['service_status'] == 5){
				$text_status_id=$this->language->get('text_complete');
			}else if($result['service_status'] == 1){
				$text_status_id=$this->language->get('text_pending');
			}else if($result['service_status'] == 7){
				$text_status_id=$this->language->get('text_canceled');
			}
			$table_collection[] = array(
				'invoice_date'			=> $result['invoice_date'],
				'invoice'				=> $result['invoice'],
				'payment_status'		=> $text_payment_status,
				'service_date' 		=> $result['service_date'],
				'invoice_prefix' 	=>  $result['invoice_prefix'],
				'service_status' 	=>  $text_status_id,
				'name'   			=> $result['name'],
				'customer_ic' 		=> $result['customer_ic'],
				'card'				=> $result['card'],
				'total_price'=> $this->currency->format($result['total_price'], $this->config->get('config_currency')),
				'subtotal' 			=>  $this->currency->format($result['subtotal'], $this->config->get('config_currency'), '', false),
				'tax' 				=> $this->currency->format($result['tax'], $this->config->get('config_currency'), '', false),
				'total'				=> $this->currency->format($result['total'], $this->config->get('config_currency'), '', false)
			);
		}

		
		$total_price = 0;
		$total_subtotal = 0;
		$total_tax = 0;
		$total_total = 0;
		

		foreach($total_amounts as $total_amount){
			$total_price += $total_amount['total_price'];
			$total_subtotal += $total_amount['subtotal'];
			$total_tax += $total_amount['tax'];
			$total_total += $total_amount['total'];
		}

			$total_price	= $this->currency->format($total_price, $this->config->get('config_currency'),'',false);
			$total_subtotal	= $this->currency->format($total_subtotal, $this->config->get('config_currency'),'',false);
			$total_tax			= $this->currency->format($total_tax, $this->config->get('config_currency'),'',false);
			$total_total		= $this->currency->format($total_total, $this->config->get('config_currency'),'',false)	;	
		
		
		$table_collection[] = array(
			'', '', '', '', '','','','','',
			$total_price,
			$total_subtotal,
			$total_tax,
			$total_total
		);
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Doc Date : ', $filter_data['filter_date_start'], $filter_data['filter_date_end']);
		$table[] = array('Filter Service Status : ', $filter_status);
        $table[] = array('Filter Payment Status : ', $filter_payment_status);		
	
		$table[] = array();
		
		$table[] = array();
		
		$table_header = array(
			$this->language->get('column_invoice_date'),
			$this->language->get('column_invoice'),
			$this->language->get('column_payment_status'),
			$this->language->get('column_date'),
			$this->language->get('column_transaction_no'),
			$this->language->get('column_service_status'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_customer_ic'),
			$this->language->get('column_customer_card'),
			$this->language->get('column_total_price'),
			$this->language->get('column_subtotal'),
			$this->language->get('column_tax'),
			$this->language->get('column_total')
		);

		$table[] = $table_header;
		
		$total_row = 0;
		
		$table_data = $table_collection;
		$row;
		
		foreach($table_data as $key => $data){
			$row = array();
			
			foreach($data as $key => $value){
				$row[] = $value;
			}

			$table[] = $row;
			
			$total_row ++;
		}
		
		$autosize_column_index = 'A';

		foreach($table_header as $header){
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 7;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$textformat_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row));
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_data['filter_date_start'] . '_' . $filter_data['filter_date_end'] ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	protected function getFiltersData($pagination = false) {
        /** Filters */
        $config_appointment_date_type = !empty($this->config->get('config_order_transaction_list_date_type')) ? $this->config->get('config_order_transaction_list_date_type') : 'all';
        $config_appointment_invoice_date_type = !empty($this->config->get('config_order_transaction_list_date_type')) ? $this->config->get('config_order_transaction_list_date_type') : 'today';


		if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = $config_appointment_date_type;
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_date_start = $filter_date_start2;
        } else if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = null;
        }

        if ($filter_date_type != 'custom') {
            $filter_date_end = $filter_date_end2;
        } else if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = null;
        }



		if (isset($this->request->get['filter_invoice_date_type'])) {
            $filter_invoice_date_type = $this->request->get['filter_invoice_date_type'];
        } else {
            $filter_invoice_date_type = $config_appointment_invoice_date_type;
        }

        $invoice_date_from_datetypes = $this->getDateByDateType($filter_invoice_date_type);
        $filter_invoice_date_start2 = $invoice_date_from_datetypes['date_start'];
        $filter_invoice_date_end2 = $invoice_date_from_datetypes['date_end'];

        if ($filter_invoice_date_type != 'custom') {
            $filter_invoice_date_start = $filter_invoice_date_start2;
        } else if (isset($this->request->get['filter_invoice_date_start'])) {
            $filter_invoice_date_start = $this->request->get['filter_invoice_date_start'];
        } else {
            $filter_invoice_date_start = null;
        }

        if ($filter_invoice_date_type != 'custom') {
            $filter_invoice_date_end = $filter_invoice_date_end2;
        } else if (isset($this->request->get['filter_invoice_date_end'])) {
            $filter_invoice_date_end = $this->request->get['filter_invoice_date_end'];
        } else {
            $filter_invoice_date_end = null;
        }


		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_status_id'])) {
			$filter_status_id = $this->request->get['filter_status_id'];
		} else {
			$filter_status_id = '5';
		}	
		
		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '5,1';
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}
		
		if (isset($this->request->get['filter_service_name'])) {
			$filter_service_name = $this->request->get['filter_service_name'];
		} else {
			$filter_service_name = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$start = null;
		$limit = null;
		if (!empty($pagination)) {
			$start = ($page - 1) * $this->config->get('config_limit_admin');
			$limit =  $this->config->get('config_limit_admin');
		}

        return [
            'filter_date_type'         => $filter_date_type,
            'filter_date_start'        => $filter_date_start,
            'filter_date_end'          => $filter_date_end,
			'filter_invoice_date_type' => $filter_invoice_date_type,
			'filter_invoice_date_start'=> $filter_invoice_date_start,
			'filter_invoice_date_end'  => $filter_invoice_date_end,
			'filter_customer_name'	   => $filter_customer_name,
			'filter_service_name'	   => $filter_service_name,
			'filter_customer_card'	   => $filter_customer_card,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end'   => $filter_transaction_end,
            'filter_status_id'         => $filter_status_id,
            'filter_payment_status'    => $filter_payment_status,
			'filter_doctor_name'	   => $filter_doctor_name,
            'filter_store_id'          => $filter_store_id,
            'sort'                     => $sort,
            'order'                    => $order,
            'page'                     => $page,
            'start'                    => $start,
            'limit'                    => $limit,
        ];
    }

	protected function getFilterUrl($all = false) {
        $url = '';

		if (isset($this->request->get['filter_date_type'])) {
			$url .= '&filter_date_type=' . urlencode(html_entity_decode($this->request->get['filter_date_type'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_invoice_date_type'])) {
			$url .= '&filter_invoice_date_type=' . urlencode(html_entity_decode($this->request->get['filter_invoice_date_type'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$url .= '&filter_invoice_date_start=' . $this->request->get['filter_invoice_date_start'];
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$url .= '&filter_invoice_date_end=' . $this->request->get['filter_invoice_date_end'];
		}

		if (isset($this->request->get['filter_status_id'])) {
			$url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}
		
		if (isset($this->request->get['filter_service_name'])) {
			$url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
        return $url;
    }

	protected function getDateByDateType($type) {
		$timezone = new DateTimeZone('Asia/Kuala_Lumpur');
        $today = new DateTime('now', $timezone);

        $yesterday = clone $today;
        $yesterday->modify('-1 day');
        $start_of_week = clone $today;
        $start_of_week->modify('monday this week');
        $start_of_month = clone $today;
        $start_of_month->modify('first day of this month');
        $start_of_year = clone $today;
        $start_of_year->modify('first day of January this year');

        $last_week = clone $today;
        $last_week->modify('monday last week');
        $last_month = clone $today;
        $last_month->modify('first day of last month');
        $last_year = clone $today;
        $last_year->modify('first day of January last year');

		$date = [];
		switch ($type) {
			case 'today':
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'yesterday':
				$start_date = $yesterday->format('Y-m-d');
				$end_date   = $yesterday->format('Y-m-d');
				break;
            case 'last_week':
                $start_date = $last_week->format('Y-m-d');
				$end_date   = $last_week->modify('+6 days')->format('Y-m-d');
				break;
            case 'last_month':
                $start_date = $last_month->format('Y-m-d');
                $end_date   = $last_month->modify('last day of')->format('Y-m-d');
                break;
            case 'last_year':
                $start_date = $last_year->format('Y-m-d');
                $end_date   = $last_year->modify('last day of December')->format('Y-m-d');
                break;
			case 'past':
				$start_date = null;
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_week':
				$start_date = $start_of_week->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_month':
				$start_date = $start_of_month->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_year':
				$start_date = $start_of_year->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'last7days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-6 days')->format('Y-m-d');
				break;
            case 'last14days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-13 days')->format('Y-m-d');    
                break;
            case 'last21days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-20 days')->format('Y-m-d');
                break;
			case 'last30days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-29 days')->format('Y-m-d');
				break;
            case 'last60days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-59 days')->format('Y-m-d');
                break;
			case 'last90days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-89 days')->format('Y-m-d');
				break;
			case 'last1year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
            case 'last3year':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-3 year')->format('Y-m-d');
                break;
			case 'last5year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-5 year')->format('Y-m-d');
				break;
			case 'last_year_this_year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
			case 'all':
				$start_date = null;
				$end_date   = null;
				break;
			default:
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
		}

		$date = [
			'date_start' => $start_date,
			'date_end'   => $end_date,
		];
		return $date;
	}

	protected function getDateTypes() {
		$result = [
			array(
				'name' => 'Today',
				'code' => 'today'
			),
			array(
				'name' => 'Yesterday',
				'code' => 'yesterday'
			),
            array(
                'name' => 'Last Week',
                'code' => 'last_week'
            ),
            array(
                'name' => 'Last Month',
                'code' => 'last_month'
            ),
            array(
                'name' => 'Last Year',
                'code' => 'last_year'
            ),
			array(
				'name' => 'This Week',
				'code' => 'this_week'
			),
			array(
				'name' => 'This Month',
				'code' => 'this_month'
			),
			array(
				'name' => 'This Year',
				'code' => 'this_year'
			),
			array(
				'name' => 'Year to date (YTD)',
				'code' => 'last_year_this_year'
			),
			array(
				'name' => 'Last 7 days',
				'code' => 'last7days'
			),
            array(
				'name' => 'Last 14 days',
				'code' => 'last14days'
			),
            array(
				'name' => 'Last 21 days',
				'code' => 'last21days'
			),
			array(
				'name' => 'Last 30 days',
				'code' => 'last30days'
			),
            array(
				'name' => 'Last 60 days',
				'code' => 'last60days'
			),
			array(
				'name' => 'Last 90 days',
				'code' => 'last90days'
			),
			array(
                'name' => 'Last 1 years',
                'code' => 'last1year'
            ),
            array(
                'name' => 'Last 3 years',
                'code' => 'last3year'
            ),
            array(
                'name' => 'Last 5 years',
                'code' => 'last5year'
            ),
            array(
				'name' => 'Past',
				'code' => 'past'
			),
			array(
				'name' => 'All Time',
				'code' => 'all'
			),
			array(
				'name' => 'Custom Range',
				'code' => 'custom'
			)
		];
		return $result;
	} 
}