<?php
class ControllerReportServiceSummaryByCustomer extends Controller {
	protected function c_format($data) {
		return $this->currency->format($data,$this->config->get('config_currency'));
	}

	protected function print_data($data) {
		echo '<pre>';
		print_r($data);
		echo '</pre>';
	}

	public function index() {
		$msc = microtime(true);
		$this->load->model('report/service_summary_by_customer');
		$this->load->language('report/service_summary_by_customer');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		// $languages = $this->load->language('report/service_summary_by_customer');
		// foreach ($languages as $l => $lang) {
		// 	$data[$l] = $lang;
		// }

		$this->document->setTitle($this->language->get('heading_title'));
		
		//**filter

		$url = $this->getFilterUrl();
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/service_summary_by_customer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/service_summary_by_customer/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		
		//** filter data
		$filter_data = $this->getFiltersData();
		$filter_data_with_pagination = $this->getFiltersData(true);
		
		
		

		
		//**data
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$data['user_view'] = $this->user->user_view;
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['payment_methods'] = $this->model_report_service_summary_by_customer->getPaymentMethod();
        		
        $data['customer_groups'] = $this->model_report_service_summary_by_customer->getCustomerGroup();

		$data['user_token'] = $this->session->data['user_token'];
		
		$data['itemlist'] = $this->model_report_service_summary_by_customer->getservicename();
		
		//listing data
		$data['sales'] = array();
		$customerlists = $this->model_report_service_summary_by_customer->getcustomerservicelist($filter_data_with_pagination);
		foreach($customerlists as $customerlist){
			if(($customerlist['date_added'] >= $filter_data['filter_new_return_start']) && $customerlist['date_added'] <= $filter_data['filter_new_return_end']){
				$new_return = 'NEW';

			}elseif($customerlist['date_added'] == date('Y-m-d') ){
				$new_return = 'NEW';
			}else{
				$new_return = 'RETURN';

			}
			$data['customer_list'][] = array(
				'name' => $customerlist['name'],
				'telephone' => $customerlist['telephone'],
				'age' => $customerlist['age'],
				'gender' => $customerlist['gender'],
				'customer_group' => $customerlist['customer_group'],
				'date_added' => DATE('Y-m-d',strtotime($customerlist['date_added'])),
				'new_return' => $new_return,
				'service_form'	=> $customerlist['service_form'],
				'service_item'	=> $customerlist['service_item'],
				'view_service'	=> $this->url->link('report/serviceform_summary_by_transaction','user_token=' . $this->session->data['user_token'].'&filter_customer_name='.$customerlist['name'].'&filter_invoice_date_type=all'. $url , true),
				'view_service_item' => $this->url->link('report/serviceform_by_service_item_detail','user_token=' . $this->session->data['user_token'].'&filter_customer_name='.$customerlist['name'].'&filter_status_id=5&filter_payment_status=5'.'&filter_invoice_date_type=all'.$url , true),

			);
		}


        $data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/service_summary_by_customer')){
			$data['user_modify'] = true;
		}

		$data['customer_modify'] = false;
		if($this->user->hasPermission('modify', 'customer/customer')){
			$data['customer_modify'] = true;
		}

		//** soting url
		//rebuild querystring for sorting
		
		//**querysting for pagination
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$data['filter_date_type'] = $filter_data['filter_date_type'];
		$data['filter_date_start'] = $filter_data['filter_date_start'];
		$data['filter_date_end'] = $filter_data['filter_date_end'];
		$data['filter_invoice_date_type'] = $filter_data['filter_invoice_date_type'];
		$data['filter_invoice_date_start'] = $filter_data['filter_invoice_date_start'];
		$data['filter_invoice_date_end'] = $filter_data['filter_invoice_date_end'];
		$data['filter_status_id'] = explode(',',$filter_data['filter_status_id']);
		$data['filter_new_return_start'] = $filter_data['filter_new_return_start'];
		$data['filter_new_return_end'] = $filter_data['filter_new_return_end'];
		$data['filter_store_id'] = explode(',',$filter_data['filter_store_id']);
		$data['filter_doctor_name'] = explode(',',$filter_data['filter_doctor_name']);
		$data['filter_gender'] = $filter_data['filter_gender'];
		$data['filter_customer_card'] = $filter_data['filter_customer_card'];
		$data['filter_customer_name'] = $filter_data['filter_customer_name'];
		$data['filter_payment_status'] = explode(',',$filter_data['filter_payment_status']);
		$data['filter_service_name'] = explode(',',$filter_data['filter_service_name']);
        $page = $filter_data['page'];
		$data['sort'] = $filter_data['sort'];
		$data['order'] = $filter_data['order'];
        $pagination_url = $this->getFilterUrl(true);
		$total_sales_result = $this->model_report_service_summary_by_customer->getcustomerservicelistnumber($filter_data);
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/service_summary_by_customer', 'user_token=' . $this->session->data['user_token'] . $pagination_url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
        $data['date_types'] = $this->getDateTypes();
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

		$msc = microtime(true)-$msc;
		/*echo '<pre>';
		print_r($msc);
		echo '</pre>';*/
		
		//**layout
		$this->response->setOutput($this->load->view('report/service_summary_by_customer_list', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/service_summary_by_customer');
		$this->load->language('report/service_summary_by_customer');
		
		//**filter
        
        $filter_data = $this->getFiltersData();

		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		// $sales = $this->model_report_service_summary_by_customer->getSalesSummary($filter_data);
		
		$filter_status = '';
		// if($filter_data['filter_status_id'] == '1'){
		// 	$filter_status = 'PENDING';
		// }elseif($filter_data['filter_status_id'] == '5'){
		// 	$filter_status = 'COMPLETE';
		// }elseif($filter_data['filter_status_id'] == '7'){
		// 	$filter_status = 'CANCELED';

		// }
		$filter_payment_status = '';
		// if($filter_data['filter_payment_status'] == '1'){
		// 	$filter_payment_status = 'PENDING';
		// }elseif($filter_data['filter_payment_status'] == '5'){
		// 	$filter_payment_status = 'COMPLETE';
		// }elseif($filter_data['filter_payment_status'] == '7'){
		// 	$filter_payment_status = 'CANCELED';

		// }
		if(!empty($filter_data['filter_payment_status'])){
			$filter_payment_status = $this->model_report_service_summary_by_customer->status($filter_data['filter_payment_status']);

		}
		if(!empty($filter_data['filter_status_id'])){
			$filter_status = $this->model_report_service_summary_by_customer->status($filter_data['filter_status_id']);

		}
		
		$table_collection = array();

		$customerlists = $this->model_report_service_summary_by_customer->getcustomerservicelist($filter_data);
		foreach($customerlists as $customerlist){
			if(($customerlist['date_added'] >= $filter_data['filter_new_return_start']) && $customerlist['date_added'] <= $filter_data['filter_new_return_end']){
				$new_return = 'NEW';

			}elseif($customerlist['date_added'] == date('Y-m-d') ){
				$new_return = 'NEW';
			}else{
				$new_return = 'RETURN';

			}

			if($customerlist['gender']==1){
				$gender = 'Mae';
			}else{
				$gender = "Female";
			}


			$table_collection[] = array(


				'name' => $customerlist['name'].'['.$new_return.']',
				'age' => $customerlist['age'],
				'gender' => $gender,
				'telephone' => $customerlist['telephone'],
				'customer_group' => $customerlist['customer_group'],
				'service_form'	=> $customerlist['service_form'],
				'service_item'	=> $customerlist['service_item'],

			);
		}

		// $table_collection[] = array(
		// 	'',
		// 	'',
		// 	'',
		// 	'',
		// );
		
		
		$table = array();
		
		
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_data['filter_date_start'], $filter_data['filter_date_end']);
		$table[] = array('Filter Service Status : ', $filter_status);
        $table[] = array('Filter Payment Status : ', $filter_payment_status);	
		$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		$table_header = array(//table headers
			$this->language->get('column_name'),
			$this->language->get('column_age'),
			$this->language->get('column_gender'),
			$this->language->get('column_telephone'),
			$this->language->get('column_customer_group'),
			$this->language->get('column_visit'),
			$this->language->get('column_total_services')

		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 6;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_data['filter_date_start'] . '_' . $filter_data['filter_date_end'] ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}


	protected function getFiltersData($pagination = false) {
        /** Filters */
        $config_appointment_date_type = !empty($this->config->get('config_order_transaction_list_date_type')) ? $this->config->get('config_order_transaction_list_date_type') : 'today';


		if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = $config_appointment_date_type;
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_date_start = $filter_date_start2;
        } else if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = null;
        }

        if ($filter_date_type != 'custom') {
            $filter_date_end = $filter_date_end2;
        } else if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = null;
        }



		if (isset($this->request->get['filter_invoice_date_type'])) {
            $filter_invoice_date_type = $this->request->get['filter_invoice_date_type'];
        } else {
            $filter_invoice_date_type = $config_appointment_date_type;
        }

        $invoice_date_from_datetypes = $this->getDateByDateType($filter_invoice_date_type);
        $filter_invoice_date_start2 = $invoice_date_from_datetypes['date_start'];
        $filter_invoice_date_end2 = $invoice_date_from_datetypes['date_end'];

        if ($filter_invoice_date_type != 'custom') {
            $filter_invoice_date_start = $filter_invoice_date_start2;
        } else if (isset($this->request->get['filter_invoice_date_start'])) {
            $filter_invoice_date_start = $this->request->get['filter_invoice_date_start'];
        } else {
            $filter_invoice_date_start = null;
        }

        if ($filter_invoice_date_type != 'custom') {
            $filter_invoice_date_end = $filter_invoice_date_end2;
        } else if (isset($this->request->get['filter_invoice_date_end'])) {
            $filter_invoice_date_end = $this->request->get['filter_invoice_date_end'];
        } else {
            $filter_invoice_date_end = null;
        }


		if (isset($this->request->get['filter_new_return_start'])) {
			$filter_new_return_start  = $this->request->get['filter_new_return_start'];
		} else {
			$filter_new_return_start  = '';
		}

		if (isset($this->request->get['filter_new_return_end'])) {
			$filter_new_return_end  = $this->request->get['filter_new_return_end'];
		} else {
			$filter_new_return_end  = '';
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_status_id'])) {
			$filter_status_id = $this->request->get['filter_status_id'];
		} else {
			$filter_status_id = '';
		}	
		
		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '';
		}
		
		if (isset($this->request->get['filter_service_name'])) {
			$filter_service_name = $this->request->get['filter_service_name'];
		} else {
			$filter_service_name = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = '';
		}


		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$start = null;
		$limit = null;
		if (!empty($pagination)) {
			$start = ($page - 1) * $this->config->get('config_limit_admin');
			$limit =  $this->config->get('config_limit_admin');
		}

        return [
            'filter_date_type'         => $filter_date_type,
            'filter_date_start'        => $filter_date_start,
            'filter_date_end'          => $filter_date_end,
			'filter_invoice_date_type' => $filter_invoice_date_type,
			'filter_invoice_date_start'=> $filter_invoice_date_start,
			'filter_invoice_date_end'  => $filter_invoice_date_end,
			'filter_customer_name'	   => $filter_customer_name,
			'filter_gender'			   => $filter_gender,
			'filter_service_name'	   => $filter_service_name,
			'filter_customer_card'	   => $filter_customer_card,
			'filter_new_return_start' => $filter_new_return_start,
			'filter_new_return_end'   => $filter_new_return_end,
			'filter_doctor_name'	   => $filter_doctor_name,
            'filter_status_id'         => $filter_status_id,
            'filter_payment_status'    => $filter_payment_status,
            'filter_store_id'          => $filter_store_id,
            'sort'                     => $sort,
            'order'                    => $order,
            'page'                     => $page,
            'start'                    => $start,
            'limit'                    => $limit,
        ];
    }

	protected function getFilterUrl($all = false) {
        $url = '';

		if (isset($this->request->get['filter_date_type'])) {
			$url .= '&filter_date_type=' . urlencode(html_entity_decode($this->request->get['filter_date_type'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_invoice_date_type'])) {
			$url .= '&filter_invoice_date_type=' . urlencode(html_entity_decode($this->request->get['filter_invoice_date_type'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$url .= '&filter_invoice_date_start=' . $this->request->get['filter_invoice_date_start'];
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$url .= '&filter_invoice_date_end=' . $this->request->get['filter_invoice_date_end'];
		}

		if (isset($this->request->get['filter_status_id'])) {
			$url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}
		
		if (isset($this->request->get['filter_new_return_start'])) {
			$url .= '&filter_new_return_start=' . $this->request->get['filter_new_return_start'];
		}
		
		if (isset($this->request->get['filter_new_return_end'])) {
			$url .= '&filter_new_return_end=' . $this->request->get['filter_new_return_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_service_name'])) {
			$url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
        return $url;
    }

	protected function getDateByDateType($type) {
		$timezone = new DateTimeZone('Asia/Kuala_Lumpur');
        $today = new DateTime('now', $timezone);

        $yesterday = clone $today;
        $yesterday->modify('-1 day');
        $start_of_week = clone $today;
        $start_of_week->modify('monday this week');
        $start_of_month = clone $today;
        $start_of_month->modify('first day of this month');
        $start_of_year = clone $today;
        $start_of_year->modify('first day of January this year');

        $last_week = clone $today;
        $last_week->modify('monday last week');
        $last_month = clone $today;
        $last_month->modify('first day of last month');
        $last_year = clone $today;
        $last_year->modify('first day of January last year');

		$date = [];
		switch ($type) {
			case 'today':
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'yesterday':
				$start_date = $yesterday->format('Y-m-d');
				$end_date   = $yesterday->format('Y-m-d');
				break;
            case 'last_week':
                $start_date = $last_week->format('Y-m-d');
				$end_date   = $last_week->modify('+6 days')->format('Y-m-d');
				break;
            case 'last_month':
                $start_date = $last_month->format('Y-m-d');
                $end_date   = $last_month->modify('last day of')->format('Y-m-d');
                break;
            case 'last_year':
                $start_date = $last_year->format('Y-m-d');
                $end_date   = $last_year->modify('last day of December')->format('Y-m-d');
                break;
			case 'past':
				$start_date = null;
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_week':
				$start_date = $start_of_week->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_month':
				$start_date = $start_of_month->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_year':
				$start_date = $start_of_year->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'last7days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-6 days')->format('Y-m-d');
				break;
            case 'last14days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-13 days')->format('Y-m-d');    
                break;
            case 'last21days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-20 days')->format('Y-m-d');
                break;
			case 'last30days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-29 days')->format('Y-m-d');
				break;
            case 'last60days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-59 days')->format('Y-m-d');
                break;
			case 'last90days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-89 days')->format('Y-m-d');
				break;
			case 'last1year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
            case 'last3year':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-3 year')->format('Y-m-d');
                break;
			case 'last5year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-5 year')->format('Y-m-d');
				break;
			case 'last_year_this_year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
			case 'all':
				$start_date = null;
				$end_date   = null;
				break;
			default:
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
		}

		$date = [
			'date_start' => $start_date,
			'date_end'   => $end_date,
		];
		return $date;
	}

	protected function getDateTypes() {
		$result = [
			array(
				'name' => 'Today',
				'code' => 'today'
			),
			array(
				'name' => 'Yesterday',
				'code' => 'yesterday'
			),
            array(
                'name' => 'Last Week',
                'code' => 'last_week'
            ),
            array(
                'name' => 'Last Month',
                'code' => 'last_month'
            ),
            array(
                'name' => 'Last Year',
                'code' => 'last_year'
            ),
			array(
				'name' => 'This Week',
				'code' => 'this_week'
			),
			array(
				'name' => 'This Month',
				'code' => 'this_month'
			),
			array(
				'name' => 'This Year',
				'code' => 'this_year'
			),
			array(
				'name' => 'Year to date (YTD)',
				'code' => 'last_year_this_year'
			),
			array(
				'name' => 'Last 7 days',
				'code' => 'last7days'
			),
            array(
				'name' => 'Last 14 days',
				'code' => 'last14days'
			),
            array(
				'name' => 'Last 21 days',
				'code' => 'last21days'
			),
			array(
				'name' => 'Last 30 days',
				'code' => 'last30days'
			),
            array(
				'name' => 'Last 60 days',
				'code' => 'last60days'
			),
			array(
				'name' => 'Last 90 days',
				'code' => 'last90days'
			),
			array(
                'name' => 'Last 1 years',
                'code' => 'last1year'
            ),
            array(
                'name' => 'Last 3 years',
                'code' => 'last3year'
            ),
            array(
                'name' => 'Last 5 years',
                'code' => 'last5year'
            ),
            array(
				'name' => 'Past',
				'code' => 'past'
			),
			array(
				'name' => 'All Time',
				'code' => 'all'
			),
			array(
				'name' => 'Custom Range',
				'code' => 'custom'
			)
		];
		return $result;
	} 
}
?>