<?php
class ControllerReportPromoteEtcmapp extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('report/promote_etcmapp');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('report/promote_etcmapp');

        $this->getList();
    }

    protected function getList(){
        if (isset($this->request->get['filter_customer_name'])) {
            $filter_customer_name = $this->request->get['filter_customer_name'];
        } else {
            $filter_customer_name = '';
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = '';
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = NULL;
        }

        if (isset($this->request->get['filter_favourite'])) {
            $filter_favourite = $this->request->get['filter_favourite'];
        } else {
            $filter_favourite = NULL;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = '';
        }

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'etcm_favourite_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

        $url = '';

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_favourite'])) {
            $url .= '&filter_favourite=' . $this->request->get['filter_favourite'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . $url, true)
		];

        $data['customers'] = [];

        $filter_data = [
            'filter_customer_name'      => $filter_customer_name,
            'filter_email'              => $filter_email,
            'filter_telephone'          => $filter_telephone,
            'filter_gender'             => $filter_gender,
            'filter_favourite'          => $filter_favourite,
            'filter_date_added'         => $filter_date_added,
            'sort'					    => $sort,
            'order'					    => $order,
            'start'                     => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                     => $this->config->get('config_limit_admin')
        ];

        $results = $this->model_report_promote_etcmapp->getPromoteCustomers($filter_data);
        $total_customers = $this->model_report_promote_etcmapp->getTotalPromoteCustomers($filter_data);

        if(!empty($results)){
            foreach($results as $result){
                $gender = ($result['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');
                $favourite_status = ($result['favourite_status'] == '1') ? $this->language->get('text_favourite') : $this->language->get('text_unfavourite');

                $data['customers'][] = [
                    'customer_name'         => $result['customer_name'],
                    'telephone'             => $result['telephone'],
                    'email'                 => $result['email'],
                    'gender'                => $gender,
                    'favourite_status'      => $favourite_status,
                    'date_added'            => date($this->language->get('date_format_short'), strtotime($result['date_added']))
                ];
            }
        }
        // echo '<pre>';
        // print_r($total_customers);
        // echo '</pre>';

        $language_arr = ['heading_title', 'button_export_excel', 'text_list', 'text_no_results', 'column_customer_name', 'column_telephone', 'column_email', 'column_gender', 'entry_customer_name', 'entry_email', 'entry_telephone', 'button_filter', 'entry_gender', 'text_male', 'text_female', 'text_favourite', 'text_unfavourite', 'entry_favourite', 'column_favourite', 'entry_date_added', 'column_date_added'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $querystringforsort = '';

        if (isset($this->request->get['filter_customer_name'])) {
            $querystringforsort .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_email'])) {
            $querystringforsort .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $querystringforsort .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $querystringforsort .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_favourite'])) {
            $querystringforsort .= '&filter_favourite=' . $this->request->get['filter_favourite'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $querystringforsort .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_customer_name'] = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $querystringforsort, true);
        $data['sort_email'] = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . '&sort=email' . $querystringforsort, true);
        $data['sort_gender'] = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . '&sort=gender' . $querystringforsort, true);
        $data['sort_favourite'] = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . '&sort=favourite_status' . $querystringforsort, true);
        $data['sort_date_added'] = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystringforsort, true);

        $url = '';

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_favourite'])) {
            $url .= '&filter_favourite=' . $this->request->get['filter_favourite'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['export_excel'] = $this->url->link('report/promote_etcmapp/exportExcel','user_token=' . $this->session->data['user_token'] . $url, true);

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/promote_etcmapp', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['filter_customer_name'] = $filter_customer_name;
        $data['filter_email'] = $filter_email;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_gender'] = $filter_gender;
        $data['filter_favourite'] = $filter_favourite;
        $data['filter_date_added'] = $filter_date_added;

        $data['user_token'] = $this->session->data['user_token'];
        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('report/promote_etcmapp_list', $data));
    }

    public function exportExcel(){
        $this->load->language('report/promote_etcmapp');
        $this->load->model('report/promote_etcmapp');

        if (isset($this->request->get['filter_customer_name'])) {
            $filter_customer_name = $this->request->get['filter_customer_name'];
        } else {
            $filter_customer_name = '';
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = '';
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = NULL;
        }

        if (isset($this->request->get['filter_favourite'])) {
            $filter_favourite = $this->request->get['filter_favourite'];
        } else {
            $filter_favourite = NULL;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'etcm_favourite_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        $filter_data = [
            'filter_customer_name'      => $filter_customer_name,
            'filter_email'              => $filter_email,
            'filter_telephone'          => $filter_telephone,
            'filter_gender'             => $filter_gender,
            'filter_favourite'          => $filter_favourite,
            'filter_date_added'         => $filter_date_added,
            'sort'					    => $sort,
            'order'					    => $order
        ];

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel =  new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()   ->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                                        ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                                        ->setTitle('Title')
                                        ->setSubject('Subject')
                                        ->setDescription('Description')
                                        ->setKeywords('report etcm.me')
                                        ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()  ->setName('Arial')
                                                    ->setSize(10);

        // Table Data

        // get data collection from database
        $results = $this->model_report_promote_etcmapp->getAllPromoteCustomers($filter_data);

        $table_collection = [];

        foreach($results as $result){
            $gender_name = ($result['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');
            $favourite_status = ($result['favourite_status'] == '1') ? $this->language->get('text_favourite') : $this->language->get('text_unfavourite');

            $table_collection[] = [
                'customer_name'     => $result['customer_name'],
                'email'             => $result['email'],
                'telephone'         => $result['telephone'],
                'gender'            => $gender_name,
                'favourite_status'  => $favourite_status,
                'date_added'        => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            ];
        }

        $table = [];

        $table[] = ['Report Name : ', $this->language->get('heading_title')];

        $table[] = [];

        $table_header = array(
            $this->language->get('column_customer_name'),
            $this->language->get('column_email'),
            $this->language->get('column_telephone'),
            $this->language->get('column_gender'),
            $this->language->get('column_favourite'),
            $this->language->get('column_date_added')
        );

        $table[] = $table_header;

        $total_row = 0;

        $table_data = $table_collection;
        $row;

        foreach($table_data as $key => $data){
            $row = array();

            foreach($data as $key => $value){
                $row[] = $value;
            }
            $table[] = $row;

            $total_row++;
        }

        // Styling
        $autosize_column_index = 'A';
        foreach($table_header as $header){
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach($table_header as $col) $header_index_e_column++;
        $header_index_row = 3;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font'  => array(
                'bold'  => true
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $general_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat'  => array(
                'code'  => '0000000000'
            )
        );

        $general_style2 = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat'  => array(
                'code'  => '000000000000'
            )
        );

         $objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);

        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


        // Rename worksheet
        $sheettitle = $this->language->get('heading_title2');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = $this->language->get('heading_title');

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }
}
?>
