<?php
class ControllerReportProductStockIssue extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('report/product_stock_issue');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('report/product_stock_issue');

        if (isset($this->request->get['filter_transaction_num_start'])) {
            $filter_transaction_num_start = $this->request->get['filter_transaction_num_start'];
        } else {
            $filter_transaction_num_start = '';
        }

        if (isset($this->request->get['filter_transaction_num_end'])) {
            $filter_transaction_num_end = $this->request->get['filter_transaction_num_end'];
        } else {
            $filter_transaction_num_end = '';
        }

        if (isset($this->request->get['filter_staff_name'])) {
            $filter_staff_name = $this->request->get['filter_staff_name'];
        } else {
            $filter_staff_name = '';
        }

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = date('Y-m-d');
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = date('Y-m-d');
        }

        if (isset($this->request->get['filter_description'])) {
            $filter_description = $this->request->get['filter_description'];
        } else {
            $filter_description = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'si.invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_transaction_num_start'])) {
            $url .= '&filter_transaction_num_start=' . $this->request->get['filter_transaction_num_start'];
        }

        if (isset($this->request->get['filter_transaction_num_end'])) {
            $url .= '&filter_transaction_num_end=' . $this->request->get['filter_transaction_num_end'];
        }

        if (isset($this->request->get['filter_staff_name'])) {
            $url .= '&filter_staff_name=' . $this->request->get['filter_staff_name'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . $this->request->get['filter_description'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_product_code'])) {
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $language_arr = ['heading_title', 'button_export_excel', 'text_list', 'entry_transaction_num_start', 'entry_transaction_num_end', 'entry_date_from', 'entry_date_to', 'entry_staff_name', 'entry_description', 'entry_product_code', 'entry_product_name', 'entry_store', 'text_all_store', 'button_filter', 'column_product_code', 'column_product_chinese_name', 'column_product_english_name', 'column_description', 'column_transaction_num', 'column_staff_name', 'column_product_quantity', 'column_date_added', 'text_no_results'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $data['stock_issue_products'] = [];

        $filter_data = array(
            'filter_transaction_num_start'      => $filter_transaction_num_start,
            'filter_transaction_num_end'        => $filter_transaction_num_end,
            'filter_staff_name'                 => $filter_staff_name,
            'filter_date_from'                  => $filter_date_from,
            'filter_date_to'                    => $filter_date_to,
            'filter_description'                => $filter_description,
            'filter_product_code'               => $filter_product_code,
            'filter_product_name'               => $filter_product_name,
            'filter_store_id'                   => $filter_store_id,
            'sort'                              => $sort,
            'order'                             => $order,
            'start'                             => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                             => $this->config->get('config_limit_admin')
        );

        $total_products = $this->model_report_product_stock_issue->getTotalStockIssueProducts($filter_data);
        $results = $this->model_report_product_stock_issue->getStockIssueProducts($filter_data);

        if(!empty($results)){
            foreach($results as $result){
                $data['stock_issue_products'][] = [
                    'invoice_prefix'        => $result['invoice_prefix'],
                    'staff_name'            => $result['staff_name'],
                    'date_added'            => date('Y-m-d', strtotime($result['date_added'])),
                    'product_code'          => $result['code'],
                    'product_english_name'  => $result['english_name'],
                    'product_chinese_name'  => $result['chinese_name'],
                    'description'           => $result['description'],
                    'quantity'              => '- ' . $result['quantity']
                ];
            }
        }

        $data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

        $url = '';

        if(isset($this->request->get['filter_transaction_num_start'])){
            $url .= '&filter_transaction_num_start=' . $this->request->get['filter_transaction_num_start'];
        }

        if(isset($this->request->get['filter_transaction_num_end'])){
            $url .= '&filter_transaction_num_end=' . $this->request->get['filter_transaction_num_end'];
        }

        if(isset($this->request->get['filter_staff_name'])){
            $url .= '&filter_staff_name=' . $this->request->get['filter_staff_name'];
        }

        if(isset($this->request->get['filter_date_from'])){
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if(isset($this->request->get['filter_date_to'])){
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if(isset($this->request->get['filter_description'])){
            $url .= '&filter_description=' . $this->request->get['filter_description'];
        }

        if(isset($this->request->get['filter_product_name'])){
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if(isset($this->request->get['filter_product_code'])){
            $url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
        }

        if(isset($this->request->get['filter_store_id'])){
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_invoice_prefix'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=si.invoice_prefix', true);
        $data['sort_date_added'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=si.date_added', true);
        $data['sort_staff_name'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=staff_name', true);
        $data['sort_product_code'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=p.code', true);
        $data['sort_product_english_name'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=english_name', true);
        $data['sort_product_chinese_name'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=chinese_name', true);
        $data['sort_product_quantity'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=sii.quantity', true);
        $data['sort_description'] = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=si.description', true);

        $url = '';

        if(isset($this->request->get['filter_transaction_num_start'])){
            $url .= '&filter_transaction_num_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_num_start'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_transaction_num_end'])){
            $url .= '&filter_transaction_num_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_num_end'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_staff_name'])){
            $url .= '&filter_staff_name=' . urlencode(html_entity_decode($this->request->get['filter_staff_name'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_date_from'])){
            $url .= '&filter_date_from=' . urlencode(html_entity_decode($this->request->get['filter_date_from'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_date_to'])){
            $url .= '&filter_date_to=' . urlencode(html_entity_decode($this->request->get['filter_date_to'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_description'])){
            $url .= '&filter_description=' . urlencode(html_entity_decode($this->request->get['filter_description'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_product_name'])){
            $url .= '&filter_product_name=' . urlencode(html_entity_decode($this->request->get['filter_product_name'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_product_code'])){
            $url .= '&filter_product_code=' . urlencode(html_entity_decode($this->request->get['filter_product_code'], ENT_QUOTES, 'UTF-8'));
        }

        if(isset($this->request->get['filter_store_id'])){
            $url .= '&filter_store_id=' . urlencode(html_entity_decode($this->request->get['filter_store_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['user_token'] = $this->session->data['user_token'];
        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name'     => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name'     => $store['name']
            );
        }

        $data['export_excel'] = $this->url->link('report/product_stock_issue/export_excel', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $pagination = new Pagination();
        $pagination->total = $total_products;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/product_stock_issue', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_products) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_products - $this->config->get('config_limit_admin'))) ? $total_products : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_products, ceil($total_products / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_transaction_num_start'] = $filter_transaction_num_start;
        $data['filter_transaction_num_end'] = $filter_transaction_num_end;
        $data['filter_staff_name'] = $filter_staff_name;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_description'] = $filter_description;
        $data['filter_product_name'] = $filter_product_name;
        $data['filter_product_code'] = $filter_product_code;
        $data['filter_store_id'] = $filter_store_id;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('report/product_stock_issue', $data));
    }

    public function export_excel(){
        $this->load->language('report/product_stock_issue');
        $this->load->model('report/product_stock_issue');

        if (isset($this->request->get['filter_transaction_num_start'])) {
            $filter_transaction_num_start = $this->request->get['filter_transaction_num_start'];
        } else {
            $filter_transaction_num_start = '';
        }

        if (isset($this->request->get['filter_transaction_num_end'])) {
            $filter_transaction_num_end = $this->request->get['filter_transaction_num_end'];
        } else {
            $filter_transaction_num_end = '';
        }

        if (isset($this->request->get['filter_staff_name'])) {
            $filter_staff_name = $this->request->get['filter_staff_name'];
        } else {
            $filter_staff_name = '';
        }

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = date('Y-m-d');
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = date('Y-m-d');
        }

        if (isset($this->request->get['filter_description'])) {
            $filter_description = $this->request->get['filter_description'];
        } else {
            $filter_description = '';
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = '';
        }

        if (isset($this->request->get['filter_product_code'])) {
            $filter_product_code = $this->request->get['filter_product_code'];
        } else {
            $filter_product_code = '';
        }

        if (isset($this->request->get['filter_store_id'])) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'si.invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        $filter_data = array(
            'filter_transaction_num_start'      => $filter_transaction_num_start,
            'filter_transaction_num_end'        => $filter_transaction_num_end,
            'filter_staff_name'                 => $filter_staff_name,
            'filter_date_from'                  => $filter_date_from,
            'filter_date_to'                    => $filter_date_to,
            'filter_description'                => $filter_description,
            'filter_product_code'               => $filter_product_code,
            'filter_product_name'               => $filter_product_name,
            'filter_store_id'                   => $filter_store_id,
            'sort'                              => $sort,
            'order'                             => $order
        );

        //get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report qiangyitang webceo")
										->setCategory("report excel");

		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$products = $this->model_report_product_stock_issue->getStockIssueProducts($filter_data);

		$table_collection = array();
		$action = '';

		foreach($products as $product){
			$table_collection[] = array(
				'document_no'		=> $product['invoice_prefix'],
				'date'				=> date('Y-m-d', strtotime($product['date_added'])),
				'staff_name'		=> $product['staff_name'],
				'product_code'		=> $product['code'],
				'english_name'		=> $product['english_name'],
				'chinese_name'		=> $product['chinese_name'],
				'quantity'          => '- ' . $product['quantity'],
				'description' 		=> $product['description']
			);
		}

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_from, $filter_date_to);
		$table[] = array('Store Name : ', $this->config->get('config_name'));

		$table[] = array();

		$table_header = array(//table headers
			$this->language->get('column_transaction_num'),
			$this->language->get('column_date_added'),
			$this->language->get('column_staff_name'),
			$this->language->get('column_product_code'),
			$this->language->get('column_product_english_name'),
			$this->language->get('column_product_chinese_name'),
			$this->language->get('column_product_quantity'),
			$this->language->get('column_description')
		);
		$table[] = $table_header;//add header to table

		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 5;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);


		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_from . '_' . $filter_date_to;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
    }
}
?>
