<?php
class ControllerReportProductStockAdjustment extends Controller {
	public function index(){
		$this->load->language('report/product_stock_adjustment');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('report/product_stock_adjustment');

		//**filter
		if (isset($this->request->get['filter_document_no_start'])) {
			$filter_document_no_start = $this->request->get['filter_document_no_start'];
		} else {
			$filter_document_no_start = NULL;
		}

		if (isset($this->request->get['filter_document_no_end'])) {
			$filter_document_no_end = $this->request->get['filter_document_no_end'];
		} else {
			$filter_document_no_end = NULL;
		}

		if (isset($this->request->get['filter_date_from'])) {
			$filter_date_from = $this->request->get['filter_date_from'];
		} else {
			$filter_date_from = date('Y-m-d');
		}

		if (isset($this->request->get['filter_date_to'])) {
			$filter_date_to = $this->request->get['filter_date_to'];
		} else {
			$filter_date_to = date('Y-m-d');
		}

		if (isset($this->request->get['filter_description'])) {
			$filter_description = $this->request->get['filter_description'];
		} else {
			$filter_description = NULL;
		}

		if (isset($this->request->get['filter_staff_name'])) {
			$filter_staff_name = $this->request->get['filter_staff_name'];
		} else {
			$filter_staff_name = NULL;
		}

		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = NULL;
		}

		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = NULL;
		}

		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = NULL;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'document_no';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		//**querystring
		$url = '';
		if (isset($this->request->get['filter_document_no_start'])) {
			$url .= '&filter_document_no_start=' . $this->request->get['filter_document_no_start'];
		}

		if (isset($this->request->get['filter_document_no_end'])) {
			$url .= '&filter_document_no_end=' . $this->request->get['filter_document_no_end'];
		}

		if (isset($this->request->get['filter_date_from'])) {
			$url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
		}

		if (isset($this->request->get['filter_date_to'])) {
			$url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
		}

		if (isset($this->request->get['filter_description'])) {
			$url .= '&filter_description=' . $this->request->get['filter_description'];
		}

		if (isset($this->request->get['filter_staff_name'])) {
			$url .= '&filter_staff_name=' . $this->request->get['filter_staff_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/product_stock_adjustment/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		//** filter data
		$filter_data = array(
			'filter_document_no_start' 		=> $filter_document_no_start,
			'filter_document_no_end' 		=> $filter_document_no_end,
			'filter_date_from' 				=> $filter_date_from,
			'filter_date_to'				=> $filter_date_to,
			'filter_description'			=> $filter_description,
			'filter_staff_name'				=> $filter_staff_name,
			'filter_product_code'			=> $filter_product_code,
			'filter_product_name'			=> $filter_product_name,
			'filter_store_id'				=> $filter_store_id,
			'sort'							=> $sort,
			'order'							=> $order,
			'start' 						=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 						=> $this->config->get('config_limit_admin')
		);

		$data['filter_document_no_start'] = $filter_document_no_start;
		$data['filter_document_no_end'] = $filter_document_no_end;
		$data['filter_date_from'] = $filter_date_from;
		$data['filter_date_to'] = $filter_date_to;
		$data['filter_description'] = $filter_description;
		$data['filter_staff_name'] = $filter_staff_name;
		$data['filter_product_code'] = $filter_product_code;
		$data['filter_product_name'] = $filter_product_name;
		$data['filter_store_id'] = $filter_store_id;

		//**data
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		//listing data
		$data['stock_adjustments'] = array();
		$stock_adjustments = $this->model_report_product_stock_adjustment->getStockAdjustment($filter_data);

		foreach($stock_adjustments as $stock_adjustment){
			$data['stock_adjustments'][] = array(
				'document_no'		=> $stock_adjustment['document_no'],
				'date'				=> date('Y-m-d', strtotime($stock_adjustment['date'])),
				'product_code'		=> $stock_adjustment['product_code'],
				'english_name'		=> $stock_adjustment['english_name'],
				'chinese_name'		=> $stock_adjustment['chinese_name'],
				'action'			=> $stock_adjustment['action'],
				'adjusted_quantity' => $stock_adjustment['adjusted_quantity'],
				'description' 		=> $stock_adjustment['description'],
				'staff_name'		=> $stock_adjustment['staff_name']
			);
		}

		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';

		if (isset($this->request->get['filter_document_no_start'])) {
			$querystringforsort .= '&filter_document_no_start=' . $this->request->get['filter_document_no_start'];
		}

		if (isset($this->request->get['filter_document_no_end'])) {
			$querystringforsort .= '&filter_document_no_end=' . $this->request->get['filter_document_no_end'];
		}

		if (isset($this->request->get['filter_date_from'])) {
			$querystringforsort .= '&filter_date_from=' . $this->request->get['filter_date_from'];
		}

		if (isset($this->request->get['filter_date_to'])) {
			$querystringforsort .= '&filter_date_to=' . $this->request->get['filter_date_to'];
		}

		if (isset($this->request->get['filter_description'])) {
			$querystringforsort .= '&filter_description=' . $this->request->get['filter_description'];
		}

		if (isset($this->request->get['filter_staff_name'])) {
			$querystringforsort .= '&filter_staff_name=' . $this->request->get['filter_staff_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

		$data['sort_document_no'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=document_no' . $querystringforsort, true);
		$data['sort_date_added'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, true);
		$data['sort_staff_name'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=staff_name' . $querystringforsort, true);
		$data['sort_product_code'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $querystringforsort, true);
		$data['sort_english_name'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=english_name' . $querystringforsort, true);
		$data['sort_chinese_name'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=chinese_name' . $querystringforsort, true);
		$data['sort_adjusted_quantity'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=adjusted_quantity' . $querystringforsort, true);
		$data['sort_description'] = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $querystringforsort, true);

		//**language
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_add'] = $this->language->get('text_add');
		$data['text_deduct'] = $this->language->get('text_deduct');
		$data['text_all_store'] = $this->language->get('text_all_store');

		$data['column_document_no'] = $this->language->get('column_document_no');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_product_code'] = $this->language->get('column_product_code');
		$data['column_english_name'] = $this->language->get('column_english_name');
		$data['column_chinese_name'] = $this->language->get('column_chinese_name');
		$data['column_action'] = $this->language->get('column_action');
		$data['column_adjusted_quantity'] = $this->language->get('column_adjusted_quantity');
		$data['column_description'] = $this->language->get('column_description');
		$data['column_staff_name'] = $this->language->get('column_staff_name');

		$data['entry_document_no_start'] = $this->language->get('entry_document_no_start');
		$data['entry_document_no_end'] = $this->language->get('entry_document_no_end');
		$data['entry_date_from'] = $this->language->get('entry_date_from');
		$data['entry_date_to'] = $this->language->get('entry_date_to');
		$data['entry_staff_name'] = $this->language->get('entry_staff_name');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_product_code'] = $this->language->get('entry_product_code');
		$data['entry_product_name'] = $this->language->get('entry_product_name');
		$data['entry_store'] = $this->language->get('entry_store');

		$data['button_filter'] = $this->language->get('button_filter');
		$data['button_export_excel'] = $this->language->get('button_export_excel');

		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_document_no_start'])) {
			$url .= '&filter_document_no_start=' . $this->request->get['filter_document_no_start'];
		}

		if (isset($this->request->get['filter_document_no_end'])) {
			$url .= '&filter_document_no_end=' . $this->request->get['filter_document_no_end'];
		}

		if (isset($this->request->get['filter_date_from'])) {
			$url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
		}

		if (isset($this->request->get['filter_date_to'])) {
			$url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
		}

		if (isset($this->request->get['filter_description'])) {
			$url .= '&filter_description=' . $this->request->get['filter_description'];
		}

		if (isset($this->request->get['filter_staff_name'])) {
			$url .= '&filter_staff_name=' . $this->request->get['filter_staff_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$total_stock_adjustment = $this->model_report_product_stock_adjustment->getStockAdjustmentTotal($filter_data);

		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_stock_adjustment;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/product_stock_adjustment', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_stock_adjustment) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_stock_adjustment - $this->config->get('config_limit_admin'))) ? $total_stock_adjustment : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_stock_adjustment, ceil($total_stock_adjustment / $this->config->get('config_limit_admin')));

		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		//**layout
		$this->response->setOutput($this->load->view('report/product_stock_adjustment', $data));
	}

	public function exportExcel() {
		$this->load->model('report/product_stock_adjustment');
		$this->load->language('report/product_stock_adjustment');

		//**filter

		if (isset($this->request->get['filter_document_no_start'])) {
			$filter_document_no_start = $this->request->get['filter_document_no_start'];
		} else {
			$filter_document_no_start = NULL;
		}

		if (isset($this->request->get['filter_document_no_end'])) {
			$filter_document_no_end = $this->request->get['filter_document_no_end'];
		} else {
			$filter_document_no_end = NULL;
		}

		if (isset($this->request->get['filter_date_from'])) {
			$filter_date_from = $this->request->get['filter_date_from'];
		} else {
			$filter_date_from = date('Y-m-d');
		}

		if (isset($this->request->get['filter_date_to'])) {
			$filter_date_to = $this->request->get['filter_date_to'];
		} else {
			$filter_date_to = date('Y-m-d');
		}

		if (isset($this->request->get['filter_description'])) {
			$filter_description = $this->request->get['filter_description'];
		} else {
			$filter_description = NULL;
		}

		if (isset($this->request->get['filter_staff_name'])) {
			$filter_staff_name = $this->request->get['filter_staff_name'];
		} else {
			$filter_staff_name = NULL;
		}

		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = NULL;
		}

		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = NULL;
		}

		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = NULL;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'document_no';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}


		//** filter data
		$filter_data = array(
			'filter_document_no_start' 		=> $filter_document_no_start,
			'filter_document_no_end' 		=> $filter_document_no_end,
			'filter_date_from' 				=> $filter_date_from,
			'filter_date_to'				=> $filter_date_to,
			'filter_description'			=> $filter_description,
			'filter_staff_name'				=> $filter_staff_name,
			'filter_product_code'			=> $filter_product_code,
			'filter_product_name'			=> $filter_product_name,
			'filter_store_id'				=> $filter_store_id,
			'sort'							=> $sort,
			'order'							=> $order
		);


		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//get gst code
		$this->load->model('setting/store');
		$gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));


		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");

		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$stock_adjustments = $this->model_report_product_stock_adjustment->getStockAdjustment($filter_data);

		$table_collection = array();
		$action = '';

		foreach($stock_adjustments as $stock_adjustment){
			if($stock_adjustment['action'] == 1){
				$action = $this->language->get('text_add');
			}
			else{
				$action = $this->language->get('text_deduct');
			}

			$table_collection[] = array(
				'document_no'		=> $stock_adjustment['document_no'],
				'date'				=> date('Y-m-d', strtotime($stock_adjustment['date'])),
				'staff_name'		=> $stock_adjustment['staff_name'],
				'product_code'		=> $stock_adjustment['product_code'],
				'english_name'		=> $stock_adjustment['english_name'],
				'chinese_name'		=> $stock_adjustment['chinese_name'],
				'action'			=> $action,
				'adjusted_quantity' => $stock_adjustment['adjusted_quantity'],
				'description' 		=> $stock_adjustment['description']
			);
		}

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_from, $filter_date_to);
		$table[] = array('Store Name : ', $this->config->get('config_name'));

		$table[] = array();

		$table_header = array(//table headers
			$this->language->get('column_document_no'),
			$this->language->get('column_date_added'),
			$this->language->get('column_staff_name'),
			$this->language->get('column_product_code'),
			$this->language->get('column_english_name'),
			$this->language->get('column_chinese_name'),
			$this->language->get('column_action'),
			$this->language->get('column_adjusted_quantity'),
			$this->language->get('column_description')
		);
		$table[] = $table_header;//add header to table

		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 5;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);


		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_from . '_' . $filter_date_to;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>
