<?php
class ControllerReportProductPurchased extends Controller {
	public function index() {
		
		$this->load->language('report/product_purchased');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$today = date('Y-m-d');
		
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = $today;
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = $today;
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'total';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/product_purchased/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/product');

		$data['products'] = array();

		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category,
			'filter_store_id'			=> $filter_store_id,
			'filter_order_status_id' 	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start'                  	=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  	=> $this->config->get('config_limit_admin')
		);

		$product_total = $this->model_report_product->getTotalPurchased($filter_data);

		$results = $this->model_report_product->getPurchased($filter_data);
		foreach ($results as $result) {
			$data['products'][] = array(
				'code'		=> $result['code'],
				'name'     	=> $result['name'],
				'category'	=> $result['category'],
				'model'     => $result['model'],
				'type' 		=> $this->productTypeText($result['type']),
				'quantity'  => $result['quantity'],
				'tax' 		=> $this->currency->format($result['tax'], $this->config->get('config_currency')),
				'total'     => $this->currency->format($result['total'], $this->config->get('config_currency')),
				'view'		=> $this->url->link('report/product_purchased/info', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'] . $url, true)
			);
		}
		
		$data['total_tax'] = $this->currency->format($this->model_report_product->getPurchasedTotalTax($filter_data), $this->config->get('config_currency'));
		$data['total_sales'] =  $this->currency->format($this->model_report_product->getPurchasedTotalSales($filter_data), $this->config->get('config_currency'));


		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;


		$data['user_view'] = $this->user->user_view;
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$querystringforsort .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$querystringforsort .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_name'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
		$data['sort_code'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
		$data['sort_category'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystringforsort, true);
		$data['sort_model'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=model' . $querystringforsort, true);
		$data['sort_type'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=type' . $querystringforsort, true);
		$data['sort_quantity'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		
		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_product_name'] = $filter_product_name;
		$data['filter_product_code'] = $filter_product_code;
		$data['filter_category'] = $filter_category;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_order_status_id'] = $filter_order_status_id;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/product_purchased', $data));
	}

	public function info() {
		$this->load->language('report/product_purchased');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('report/product');
		$this->load->model('customer/customer');

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['transaction_page'])) {
			$transaction_page = $this->request->get['transaction_page'];
		} else {
			$transaction_page = 1;
		}

		if (isset($this->request->get['customer_page'])) {
			$customer_page = $this->request->get['customer_page'];
		} else {
			$customer_page = 1;
		}

		$limit = $this->config->get('config_limit_admin');
		$transaction_start = ($transaction_page - 1) * $this->config->get('config_limit_admin');
		$customer_start = ($customer_page - 1) * $this->config->get('config_limit_admin');

		$data['product_info'] = [];
		$data['transactions'] = [];
		$data['customer_transactions'] = [];
		$data['total_quantity_transaction'] = 0;
		$data['total_customer_transactions'] = 0;
		$data['total_customer_purchase_quantity'] = 0;

		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_store_id'			=> $filter_store_id,
			'filter_order_status_id' 	=> $filter_order_status_id
		);

		$product_info = $this->model_report_product->getProduct($this->request->get['product_id']);
		$product_purchased = $this->model_report_product->getPurchasedProduct($filter_data, $this->request->get['product_id']);

		if (!empty($product_info)) {
			$data['product_info'] = [
				'product_code'			=> $product_info['code'],
				'product_name'			=> $product_info['name'],
				'model'					=> $product_info['model'],
				'category_name'			=> $product_info['category_name'],
				'product_type'			=> ($product_info['product_type'] == '1') ? $this->language->get('text_product') : $this->language->get('text_material'),
				'product_url'			=> $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product_info['product_id'], true)
			];
		}

		if (!empty($product_purchased)) {
			foreach ($product_purchased as $product) {
				$customer_info = ($product['customer_id'] > 0) ? $this->model_customer_customer->getCustomer($product['customer_id']) : [];

				$customer_name = !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '-';

				$data['transactions'][] = [
					'order_id'				=> $product['order_id'],
					'invoice_prefix'		=> $product['invoice_prefix'],
					'date_added'			=> date($this->language->get('date_format_short'), strtotime($product['date_added'])),
					'customer_type'			=> ($product['customer_id'] == 0) ? $this->language->get('text_walk_in_customer') : $this->language->get('text_member'),
					'customer_id'			=> $product['customer_id'],
					'customer_name'			=> $customer_name,
					'quantity'				=> $product['quantity'],
					'customer_url'			=> !empty($customer_info) ? $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $product['customer_id'], true) : '',
					'order_url'				=> $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $product['order_id'], true)
				];

				$data['total_quantity_transaction'] += $product['quantity'];
			}
		}

		if (!empty($product_purchased)) {
			foreach ($product_purchased as $product) {
				if ($product['customer_id'] > 0) {					
					$data['customer_transactions'][$product['customer_id']]['transactions'][] = [
						'order_id'			=> $product['order_id'],
						'invoice_prefix'	=> $product['invoice_prefix'],
						'customer_id'		=> $product['customer_id'],
						'quantity'			=> $product['quantity'],
						'date_added'		=> date($this->language->get('date_format_short'), strtotime($product['date_added'])),
						'order_url'			=> $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $product['order_id'], true)
					];
				}
			}
		}

		if (!empty($data['customer_transactions'])) {
			foreach ($data['customer_transactions'] as $customer_id => $transaction) {
				$customer_info = $this->model_customer_customer->getCustomer($customer_id);

				$data['customer_transactions'][$customer_id] = [
					'customer_id'			=> $customer_id,
					'customer_name'			=> !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '',
					'telephone'				=> !empty($customer_info) ? $customer_info['telephone'] : '',
					'email'					=> !empty($customer_info) ? $customer_info['email'] : '',
					'customer_url'			=> !empty($customer_info) ? $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $customer_id, true) : '',
					'total_transactions'	=> count($transaction['transactions']),
					'transactions'			=> $transaction['transactions']
				];

				$data['total_customer_transactions'] += count($transaction['transactions']);
			}
		}

		$data['customer_transactions'] = array_values($data['customer_transactions']);

		if (!empty($data['customer_transactions'])) {
			foreach ($data['customer_transactions'] as $index => $transaction) {
				$quantity_purchased = 0;

				if (!empty($transaction['transactions'])) {
					foreach ($transaction['transactions'] as $transaction) {
						$quantity_purchased += $transaction['quantity'];
					}
				}
				
				$data['customer_transactions'][$index]['total_quantity_purchased'] = $quantity_purchased;
				$data['total_customer_purchase_quantity'] += $quantity_purchased;
			}
		}

		$data['total_quantity_transaction'] = number_format((float)$data['total_quantity_transaction'], 4, '.', '');

		$total_transaction = count($data['transactions']);
		$data['transactions'] = array_slice($data['transactions'], $transaction_start, $limit);

		$total_customer_transactions = count($data['customer_transactions']);
		$data['customer_transactions'] = array_slice($data['customer_transactions'], $customer_start, $limit);

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
		}
		
		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$language_arr = ['heading_title', 'text_info', 'button_cancel', 'tab_general', 'tab_transaction', 'tab_customer', 'text_no_results', 'column_order_id', 'column_invoice_prefix', 'column_quantity', 'column_date_added', 'column_customer_type', 'column_total_quantity', 'column_customer_name', 'column_name', 'column_code', 'column_model', 'column_type', 'column_category', 'column_total_transactions', 'column_email', 'column_telephone', 'column_total_quantity_purchased', 'column_action', 'button_view', 'button_hide', 'button_send_sms', 'text_send_sms', 'button_close', 'button_send', 'entry_message', 'entry_customer_number', 'entry_minimum_sms_credit', 'entry_current_sms_credit', 'text_character_count', 'text_character', 'error_max_char_count', 'text_loading', 'text_success_send_sms', 'button_send_selected_customers', 'button_send_all_customers', 'button_export_excel', 'button_export_excel_by_customer', 'button_export_excel_by_transaction'];

		foreach ($language_arr as $language) {
			$data[$language] = $this->language->get($language);
		}
		
		$data['english_max_count'] = 165;
		$data['chinese_max_count'] = 65;
		
		$data['show_transaction_tab'] = isset($this->request->get['transaction_page']) ? true : false;
		$data['show_customer_tab'] = isset($this->request->get['customer_page']) ? true : false;

		$data['user_token'] = $this->session->data['user_token'];

		$transaction_pagination = new Pagination();
		$transaction_pagination->total = $total_transaction;
		$transaction_pagination->page = $transaction_page;
		$transaction_pagination->limit = $this->config->get('config_limit_admin');
		$transaction_pagination->url = $this->url->link('report/product_purchased/info', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url . '&transaction_page={page}', true);

		$data['transaction_pagination'] = $transaction_pagination->render();

		$data['transaction_results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($transaction_page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($transaction_page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($transaction_page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$customer_pagination = new Pagination();
		$customer_pagination->total = $total_customer_transactions;
		$customer_pagination->page = $customer_page;
		$customer_pagination->limit = $this->config->get('config_limit_admin');
		$customer_pagination->url = $this->url->link('report/product_purchased/info', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url . '&customer_page={page}', true);

		$data['customer_pagination'] = $customer_pagination->render();

		$data['customer_results'] = sprintf($this->language->get('text_pagination'), ($total_customer_transactions) ? (($customer_page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($customer_page - 1) * $this->config->get('config_limit_admin')) > ($total_customer_transactions - $this->config->get('config_limit_admin'))) ? $total_customer_transactions : ((($customer_page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customer_transactions, ceil($total_customer_transactions / $this->config->get('config_limit_admin')));

		$data['cancel'] = $this->url->link('report/product_purchased', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['export_excel_by_transaction'] = $this->url->link('report/product_purchased/export_excel_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url, true);
		$data['export_excel_by_customer'] = $this->url->link('report/product_purchased/export_excel_by_customer', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url, true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/product_purchased_info', $data));
	}
	
	public function get_sms_credit() {
		$json = [
			'error'		=> true
		];

		$config_check_credit = $this->config->get('config_sms_credit');
		$sms_check_credit = new SMS($config_check_credit);
		
		if(!empty($config_check_credit['host'])){
			$minimum_sms_credit = $config_check_credit['alert'];
		
			$credit_string = $sms_check_credit->checkCredit();
			$credit = explode(':', $credit_string);
		
			if(!empty($credit)){
				if($credit[0] == '1'){
					$current_sms_credit = $credit[1];
				} else{
					$current_sms_credit = 0;
				}
			}
		} else{
			$current_sms_credit = 0;
			$minimum_sms_credit = 0;
		}

		$json = [
			'error'					=> false,
			'current_sms_credit'	=> $current_sms_credit,
			'minimum_sms_credit'	=> $minimum_sms_credit
		];

		$this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
	}

	public function validate_sms_form() {
		$json = [];

		$json['code'] = false;

		$this->load->language('report/product_purchased');

		$customer_ids = isset($this->request->post['customer_ids']) ? $this->request->post['customer_ids'] : false;
		$message = isset($this->request->post['message']) ? $this->request->post['message'] : false;

		$config_check_credit = $this->config->get('config_sms_credit');
		$sms_check_credit = new SMS($config_check_credit);
		
		if ($customer_ids && $message) {
			$customer_id_arr = explode(',', $customer_ids);
			$total_customers = count($customer_id_arr);

			if (empty($customer_id_arr)) {
				$json['errors']['error_customers'] = $this->language->get('error_customers');
			}

			if(!empty($config_check_credit['host'])){
				$credit_string = $sms_check_credit->checkCredit();
				$credit = explode(':', $credit_string);
	
				if(!empty($credit)){
					if($credit[0] == '1'){
						$current_sms_credit = $credit[1];
					} else{
						$current_sms_credit = 0;
					}
				}
			} else{
				$current_sms_credit = 0;
			}

			if($total_customers >= $current_sms_credit){
				$json['errors']['error_credit_limit'] = $this->language->get('error_credit_limit');
			}
		} else {
			if (!$customer_ids) {
				$json['errors']['error_customers'] = $this->language->get('error_customers');
			}

			if (!$message) {
				$json['errors']['error_message'] = $this->language->get('error_empty_message');
			}
		}

		if (!empty($json['errors'])) {
			$json['code'] = true;
			$json['errors']['error_warning'] = $this->language->get('error_warning');
		}

		$this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
	}

	public function send_sms() {
		$json = [];

		$this->load->model('customer/customer');
		$this->load->model('localisation/country');

		$send_sms = new SMS($this->config->get('config_sms'));

		$customer_ids = isset($this->request->post['customer_ids']) ? $this->request->post['customer_ids'] : false;
		$message = isset($this->request->post['message']) ? $this->request->post['message'] : false;

		if ($customer_ids && $message) {
			$customer_id_arr = explode(',', $customer_ids);

			if (!empty($customer_id_arr)) {
				foreach ($customer_id_arr as $customer_id) {
					$customer_info = $this->model_customer_customer->getCustomer($customer_id);

					$find_telephone = ['-', ' '];
					$replace_telephone = ['dash' => '', 'space' => ''];

					$customer_telephone = !empty($customer_info) ? str_replace($find_telephone, $replace_telephone, $customer_info['telephone']) : '';

					if (!empty($customer_telephone)) {
						$country_id = $this->config->get('config_country_id');
						$country_info = $this->model_localisation_country->getCountry($country_id);
						$mobile_code = $country_info['mobile_code'];

						if(substr($customer_telephone, 0, 2) == '+6'){
							$customer_telephone = ltrim($customer_telephone, '+6');
						}

						$send_sms->sendTo($mobile_code, $customer_telephone);

						if(preg_match('/[^A-Za-z0-9\s\.\,]/', $message)){
							$send_sms->changeContentType();
							$send_sms->convertUnicode($message);
						} else{
							$send_sms->setMessage($message);
						}

						$send_sms->send();
					}
				}
			}

			$json = [
				'error'		=> false,
				'message'	=> 'send sms success'
			];
		} else {
			$json = [
				'error'		=> true,
				'message'	=> 'cannot get post data'
			];
		}

		$this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
	}

	private function productTypeText($id){
		$text = '';
		switch($id){
			case 1:
				$text = $this->language->get('text_product');
				break;
			case 2:
				$text = $this->language->get('text_material');
				break;
		}
		
		return $text;
	}
	
	public function exportExcel(){
		
		$this->load->model('report/product');
		$this->load->language('report/product_purchased');
		
		//**filter
		
		$today = date('Y-m-d');
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = $today;
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = $today;
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'total';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category,
			'filter_store_id'			=> $filter_store_id,
			'filter_order_status_id' 	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$results = $this->model_report_product->getPurchased($filter_data);
		
		$table_collection = array();
		
		foreach ($results as $result) {
			$table_collection[] = array(
				'code'		=> $result['code'],
				'name'     	=> $result['name'],
				'category'	=> $result['category'],
				'model'     => $result['model'],
				'type' 		=> $this->productTypeText($result['type']),
				'quantity'  => $result['quantity']
			);
		}
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		$table_header = array(//table headers
			$this->language->get('column_code'),
			$this->language->get('column_name'),
			$this->language->get('column_category'),
			$this->language->get('column_model'),
			$this->language->get('column_type'),
			$this->language->get('column_quantity')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$product_code_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($product_code_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function export_excel_by_transaction() {		
		$this->load->model('report/product');
		$this->load->model('customer/customer');

		$this->load->language('report/product_purchased');
		
		//**filter
		$today = date('Y-m-d');

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = $today;
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = $today;
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'total';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_store_id'			=> $filter_store_id,
			'filter_order_status_id' 	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database		
		$product_info = $this->model_report_product->getProduct($this->request->get['product_id']);
		$results = $this->model_report_product->getPurchasedProduct($filter_data, $this->request->get['product_id']);

		$table_collection = array();
		$total_quantity_transaction = 0;

		if (!empty($results)) {
			foreach ($results as $result) {
				$customer_info = ($result['customer_id'] > 0) ? $this->model_customer_customer->getCustomer($result['customer_id']) : [];

				$customer_name = !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '-';

				$table_collection[] = [
					'order_id'				=> $result['order_id'],
					'invoice_prefix'		=> $result['invoice_prefix'],
					'date_added'			=> date($this->language->get('date_format_short'), strtotime($result['date_added'])),
					'customer_type'			=> ($result['customer_id'] == 0) ? $this->language->get('text_walk_in_customer') : $this->language->get('text_member'),
					'customer_name'			=> $customer_name,
					'quantity'				=> $result['quantity'],
				];

				$total_quantity_transaction += $result['quantity'];
			}
		}

		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		$table[] = array($this->language->get('entry_product_name'), $product_info['name']);
		$table[] = array($this->language->get('entry_product_code'), $product_info['code']);
		$table[] = array($this->language->get('column_model'), $product_info['model']);
		$table[] = array($this->language->get('column_category'), $product_info['category_name']);
		$table[] = array($this->language->get('column_type'), ($product_info['product_type'] == '1') ? $this->language->get('text_product') : $this->language->get('text_material'));

		$table[] = array(); // add a space
		
		$table_header = array(//table headers
			$this->language->get('column_order_id'),
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_date_added'),
			$this->language->get('column_customer_type'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_quantity')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		$table[] = array('', '', '', '', '', $total_quantity_transaction);
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 9;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
			
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function export_excel_by_customer() {		
		$this->load->model('report/product');
		$this->load->model('customer/customer');

		$this->load->language('report/product_purchased');
		
		//**filter
		$today = date('Y-m-d');

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = $today;
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = $today;
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'total';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_store_id'			=> $filter_store_id,
			'filter_order_status_id' 	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database		
		$product_info = $this->model_report_product->getProduct($this->request->get['product_id']);
		$results = $this->model_report_product->getPurchasedProduct($filter_data, $this->request->get['product_id']);

		$customer_transactions = array();
		$table_collection = array();
		$total_customer_transactions = 0;
		$total_customer_purchase_quantity = 0;

		if (!empty($results)) {
			foreach ($results as $result) {
				if ($result['customer_id'] > 0) {					
					$customer_transactions[$result['customer_id']]['transactions'][] = [
						'order_id'			=> $result['order_id'],
						'invoice_prefix'	=> $result['invoice_prefix'],
						'customer_id'		=> $result['customer_id'],
						'quantity'			=> $result['quantity'],
						'date_added'		=> date($this->language->get('date_format_short'), strtotime($result['date_added'])),
					];
				}
			}
		}

		if (!empty($customer_transactions)) {
			foreach ($customer_transactions as $customer_id => $transaction) {
				$customer_info = $this->model_customer_customer->getCustomer($customer_id);

				$customer_transactions[$customer_id] = [
					'customer_name'			=> !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '',
					'telephone'				=> !empty($customer_info) ? $customer_info['telephone'] : '',
					'email'					=> !empty($customer_info) ? $customer_info['email'] : '',
					'total_transactions'	=> count($transaction['transactions']),
					'transactions'			=> $transaction['transactions']
				];

				$total_customer_transactions += count($transaction['transactions']);
			}
		}

		$customer_transactions = array_values($customer_transactions);

		if (!empty($customer_transactions)) {
			foreach ($customer_transactions as $index => $transaction) {
				$quantity_purchased = 0;

				if (!empty($transaction['transactions'])) {
					foreach ($transaction['transactions'] as $transaction) {
						$quantity_purchased += $transaction['quantity'];
					}
				}
				
				$customer_transactions[$index]['total_quantity_purchased'] = $quantity_purchased;
				$total_customer_purchase_quantity += $quantity_purchased;
			}
		}

		if (!empty($customer_transactions)) {
			foreach ($customer_transactions as $transaction) {
				$order_id_column = array_column($transaction['transactions'], 'order_id');

				$table_collection[] = [
					'customer_name'				=> $transaction['customer_name'],
					'telephone'					=> $transaction['telephone'],
					'email'						=> $transaction['email'],
					'total_transactions'		=> $transaction['total_transactions'],
					'total_quantity_purchased'	=> $transaction['total_quantity_purchased'],
					'order_ids'					=> implode(', ', $order_id_column)
				];
			}
		}

		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		$table[] = array($this->language->get('entry_product_name'), $product_info['name']);
		$table[] = array($this->language->get('entry_product_code'), $product_info['code']);
		$table[] = array($this->language->get('column_model'), $product_info['model']);
		$table[] = array($this->language->get('column_category'), $product_info['category_name']);
		$table[] = array($this->language->get('column_type'), ($product_info['product_type'] == '1') ? $this->language->get('text_product') : $this->language->get('text_material'));

		$table[] = array(); // add a space
		
		$table_header = array(//table headers
			$this->language->get('column_customer_name'),
			$this->language->get('column_telephone'),
			$this->language->get('column_email'),
			$this->language->get('column_total_transactions'),
			$this->language->get('column_total_quantity_purchased'),
			$this->language->get('column_order_id')
		);

		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		$table[] = array('', '', '', $total_customer_transactions, $total_customer_purchase_quantity);
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 9;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$textformat_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "000000000000"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style);// top

		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
			
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}