<?php
class ControllerReportProductMovement extends Controller
{

	public function index()
	{
		//load default model
		$this->load->model('report/product_movement');

		$product_id = isset($this->request->get['product_id']) ? $this->request->get['product_id'] : 0;

		if ($this->model_report_product_movement->productStockExists($product_id)) {

			//load default language
			$this->load->language('report/product_movement');

			//add css and js for multiselection
			$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
			$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
			$this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
			$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

			//set document title
			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			date_default_timezone_set("Asia/Kuala_Lumpur");

			$data['date_types'][] = [
				'text' => 'All',
				'value' => 'all'
			];
			$data['date_types'][] = [
				'text' => 'Today',
				'value' => 'today'
			];
			$data['date_types'][] = [
				'text' => 'Yesterdays',
				'value' => 'Yesterday'
			];
			$data['date_types'][] = [
				'text' => 'This Month',
				'value' => 'month'
			];
			$data['date_types'][] = [
				'text' => 'Last 7 days',
				'value' => 'Last_7_days'
			];
			$data['date_types'][] = [
				'text' => 'Last 30 days',
				'value' => 'Last_30_days'
			];
			$data['date_types'][] = [
				'text' => 'Last 3 Months',
				'value' => 'Last_3_months'
			];
			$data['date_types'][] = [
				'text' => 'Last 6 Months',
				'value' => 'Last_6_months'
			];
			$data['date_types'][] = [
				'text' => 'Years To Date(YTD)',
				'value' => 'Years_To_Date(YTD)'
			];
			$data['date_types'][] = [
				'text' => 'Last 1 Years',
				'value' => 'Last_1_Years'
			];
			$data['date_types'][] = [
				'text' => 'Last 3 Years',
				'value' => 'Last_3_Years'
			];
			$data['date_types'][] = [
				'text' => 'Last 5 Years',
				'value' => 'Last_5_Years'
			];

			//$date_now = date('Y-m-d');
			$config_date_type = 'month';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

			///print_r($filter_date_type);

			if (isset($this->request->get['filter_open_date'])) {
				$filter_open_date = $this->request->get['filter_open_date'];
			} else {
				$filter_open_date = NULL;
			}

			if (isset($this->request->get['filter_close_date'])) {
				$filter_close_date = $this->request->get['filter_close_date'];
			} else {
				$filter_close_date = NULL;
			}

			if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}

			if (isset($this->request->get['filter_location'])) {
				$filter_location = $this->request->get['filter_location'];
			} else {
				$filter_location = '';
			}

			if (isset($this->request->get['filter_batch_date_start'])) {
				$filter_batch_date_start = $this->request->get['filter_batch_date_start'];
			} else {
				$filter_batch_date_start = '';
			}

			if (isset($this->request->get['filter_batch_date_end'])) {
				$filter_batch_date_end = $this->request->get['filter_batch_date_end'];
			} else {
				$filter_batch_date_end = '';
			}

			if (isset($this->request->get['filter_product_name'])) {
				$filter_product_name = $this->request->get['filter_product_name'];
			} else {
				$filter_product_name = '';
			}

			if (isset($this->request->get['filter_product_code'])) {
				$filter_product_code = $this->request->get['filter_product_code'];
			} else {
				$filter_product_code = '';
			}

			if (isset($this->request->get['filter_doc_type'])) {
				$filter_doc_type = $this->request->get['filter_doc_type'];
			} else {
				$filter_doc_type = '';
			}

			if (isset($this->request->get['filter_category'])) {
				$filter_category = $this->request->get['filter_category'];
			} else {
				$filter_category = '';
			}


			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}

			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
			} else {
				$sort = 'date_added';
			}

			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
			} else {
				$order = 'DESC';
			}

			if (isset($this->request->get['filter_description'])) {
				$filter_description = $this->request->get['filter_description'];
			} else {
				$filter_description = '';
			}

			// $data['selected_date_type'] = null;
			if(empty($filter_open_date) && empty($filter_close_date) ){
				$date_now = date('Y-m-d');
				switch ($filter_date_type) {
					// case 'all':
					// 	$filter_open_date2 = '';
					// 	$filter_close_date2 = '';
					// 	break;
					case 'today':
						$filter_open_date2 = date('Y-m-d');
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Yesterday':
						$filter_open_date2 = date('Y-m-d',strtotime('-1 days'));
						$filter_close_date2 = date('Y-m-d',strtotime('-1 days'));
						break;
					case 'month':
						$filter_open_date2 = date('Y-m-01');
						$filter_close_date2 = date('Y-m-t');
						break;
					case 'Last_7_days':
						$filter_open_date2 = date('Y-m-d',strtotime('-7 days'));
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Last_30_days':
						$filter_open_date2 = date('Y-m-d',strtotime('-30 days'));
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Last_3_months':
						$filter_open_date2 = date('Y-m-d',strtotime('-3 months'));
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Last_6_months':
						$filter_open_date2 = date('Y-m-d',strtotime('-6 months'));
						$filter_close_date2 = date('Y-m-d');
						break;	
					case 'Years_To_Date(YTD)':
						$filter_open_date2 = date('Y-m-d',strtotime('first day of january this year'));
						$filter_close_date2 = date('Y-m-d',strtotime('last day of december this year'));
						break;
					case 'Last_1_Years':
						$filter_open_date2 = date('Y-m-d',strtotime('-1 years'));
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Last_3_Years':
						$filter_open_date2 = date('Y-m-d',strtotime('-3 years'));
						$filter_close_date2 = date('Y-m-d');
						break;
					case 'Last_5_Years':
						$filter_open_date2 = date('Y-m-d',strtotime('-5 years'));
						$filter_close_date2 = date('Y-m-d');
						break;
					default:
						$filter_open_date2 =  '1999-01-01';
						$filter_close_date2 = '2999-12-31';
						break;
				}
				$data['selected_date_type'] = $filter_date_type;
			} else{
				$filter_open_date2 = $filter_open_date;
				$filter_close_date2 = $filter_close_date;
			}


			$this->request->get['filter_open_date'] = $filter_open_date;
			$this->request->get['filter_close_date'] = $filter_close_date;

			$url = '';

			if (isset($filter_date_type)) {
				$url .= '&filter_date_type=' . $filter_date_type;
			}


			if (isset($this->request->get['filter_open_date'])) {
				$url .= '&filter_open_date=' . $this->request->get['filter_open_date'];
			}

			if (isset($this->request->get['filter_close_date'])) {
				$url .= '&filter_close_date=' . $this->request->get['filter_close_date'];
			}

			if (isset($this->request->get['filter_store_id'])) {
				$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}

			if (isset($this->request->get['filter_location'])) {
				$url .= '&filter_location=' . $this->request->get['filter_location'];
			}

			if (isset($this->request->get['filter_batch_date_start'])) {
				$url .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
			}

			if (isset($this->request->get['filter_batch_date_end'])) {
				$url .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
			}

			if (isset($this->request->get['filter_product_name'])) {
				$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
			}

			if (isset($this->request->get['filter_product_code'])) {
				$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
			}

			if (isset($this->request->get['filter_doc_type'])) {
				$url .= '&filter_doc_type=' . $this->request->get['filter_doc_type'];
			}

			if (isset($this->request->get['filter_category'])) {
				$url .= '&filter_category=' . $this->request->get['filter_category'];
			}
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			if (isset($this->request->get['filter_description'])) {
				$url .= '&filter_description=' . $this->request->get['filter_description'];
			}
			//**sitemap
			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('report/product_movement', 'user_token=' . $this->session->data['user_token'] . $url, true)
			);

			//urls

			// $page_limit = $this->config->get('config_limit_admin'); 
			$page_limit = 100; //temporary hardcode

			$filter_data = array(
				'filter_open_date' 			=> $filter_open_date2,
				'filter_close_date' 		=> $filter_close_date2,
				'filter_store_id'			=> $filter_store_id,
				'filter_location'			=> $filter_location,
				'filter_batch_date_start'	=> $filter_batch_date_start,
				'filter_batch_date_end'		=> $filter_batch_date_end,
				'filter_product_name'		=> $filter_product_name,
				'filter_product_code'		=> $filter_product_code,
				'filter_doc_type'			=> $filter_doc_type,
				'filter_category'			=> $filter_category,
				'start'             		=> ($page - 1) * $page_limit,
				'limit'             		=> $page_limit,
				'filter_description'		=> $filter_description
			);

			$transaction_item = $this->model_report_product_movement->getProductStockInfo($product_id, $filter_data);

			$data['product_id'] = $product_id;
			$data['user_token'] = $this->session->data['user_token'];
			$data['user_view'] = $this->user->user_view;
			$data['sort'] = $sort;
			$data['order'] = $order;

			$querystring = '';

			if (isset($this->request->get['sort'])) {
				$querystring .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$querystring .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$querystring .= '&page=' . $this->request->get['page'];
			}

			$data['master_querystring'] = $querystring;

			//**data
			$this->load->model('setting/store');
			$this->load->model('report/product_stock');

			$arr_stores = array();
			$data['stores'] = array();

			$sname = $this->config->get('config_name');

			$arr_stores[0] = $sname . $this->language->get('text_default');
			$data['stores'][] = array(
				'store_id' => 0,
				'name' => $sname . $this->language->get('text_default')
			);
			$stores = $this->model_setting_store->getStores();

			foreach ($stores as $store) {
				$arr_stores[$store['store_id']] = $store['name'];
				$data['stores'][] = array(
					'store_id' => $store['store_id'],
					'name' => $store['name']
				);
			}

			if ($this->user->user_view == 1) {
				$data['locations'] = $this->model_report_product_stock->getAllLocations();
			} else {
				$data['locations'] = $this->model_report_product_stock->getLocations();
			}

			$arr_location = array();
			$arr_location[0] = 'Default Location';
			$locations = $this->model_report_product_movement->getLocations();
			foreach ($locations as $location) {
				$arr_location[$location['location_id']] = $location['name'];
			}
	
			// $transaction_itemss = array_column($transaction_item,'type');
			// $type = array_unique($transaction_itemss);
			
			$transaction_itemss = ["Stock Take","Stock Return","Lot Transfer","Stock Received","Stock Adjustment","Stock Issue","Order","Wholesale Order","Herbal Remedies","Purchase Received","Purchase Invoice","Production" ];
			$data['transaction_items'] = $transaction_itemss;
			$this->load->model('catalog/product');
			
			foreach (array_reverse($transaction_item,true) as $product) {
				$person_type = '';
				switch ($product['person_type']) {
					case 1:
						$person_type = $this->language->get('text_staff');
						break;
					case 2:
						$person_type = $this->language->get('text_customer');
						break;
				}
				

				$data['transaction_item'][] = array(
					'date_added' 	=> date('Y-m-d', strtotime($product['date_added'])),
					'type' 			=> $product['type'],
					'id' 			=> $product['id'],
					'name' 			=> $product['name'],
					'store' 		=> $arr_stores[$product['store_id']],
					'location' 		=> $arr_location[$product['location_id']],
					'batch' 		=> $product['batch_date'],
					'remark' 		=> $product['remark'],
					'person_type' 	=> $person_type,
					'product_name' 	=> $product['product_name'],
					'product_code' 	=> $product['product_code'],
					'description'	=> $product['product_description'],
					'action' 		=> $product['action'],
					'quantity' 		=> $product['quantity'],
					'add' 			=> '+' . $this->weight->format((float)$product['add'], $this->config->get('config_weight')),
					'deduct' 		=> '-' . $this->weight->format((float)($product['deduct'] ? $product['deduct'] : 0), $this->config->get('config_weight')),
					'balance' 		=> $this->weight->format((float)$product['balance'], $this->config->get('config_weight'))
				);
			}

			$stock_calculation = $this->model_report_product_movement->getStockCalculation($product_id, $filter_data);

			$data['total_add'] = '+' . $this->weight->format((float)$stock_calculation['total_add'] ? $stock_calculation['total_add'] : 0, $this->config->get('config_weight'));
			$data['total_deduct'] = '-' . $this->weight->format((float)($stock_calculation['total_deduct'] ? $stock_calculation['total_deduct'] : 0), $this->config->get('config_weight'));

			$data['openStock'] = $this->weight->format((float)$this->model_report_product_movement->getOpenStock($filter_open_date2 . ' 00:00:00', $product_id, $filter_data), $this->config->get('config_weight'));
			$data['closeStock'] = $this->weight->format((float)$this->model_report_product_movement->getCloseStock($filter_close_date2 . ' 23:59:59', $product_id, $filter_data), $this->config->get('config_weight'));

			// print_r($data['closeStock']);
			//**query string
			$querystring = '';
			if (isset($this->request->get['filter_store_id'])) {
				$querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}

			if (isset($this->request->get['filter_location'])) {
				$querystring .= '&filter_location=' . $this->request->get['filter_location'];
			}

			if (isset($this->request->get['filter_batch_date_start'])) {
				$querystring .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
			}

			if (isset($this->request->get['filter_batch_date_end'])) {
				$querystring .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
			}

			if (isset($this->request->get['filter_product_name'])) {
				$querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];
			}

			if (isset($this->request->get['filter_product_code'])) {
				$querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
			}

			if (isset($this->request->get['filter_doc_type'])) {
				$querystring .= '&filter_doc_type=' . $this->request->get['filter_doc_type'];
			}

			if (isset($this->request->get['filter_category'])) {
				$url .= '&filter_category=' . $this->request->get['filter_category'];
			}
			if (isset($this->request->get['filter_description'])) {
				$querystring .= '&filter_description=' . $this->request->get['filter_description'];
			}

			//**url
			$data['filter_date_type'] = $filter_date_type;
			$data['cancel'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

			$product_total = $this->model_report_product_movement->getProductStockInfoTotal($product_id, $filter_data);

			$querystring = '';

			if (isset($this->request->get['product_id'])) {
				$querystring .= '&product_id=' . $this->request->get['product_id'];
			}

			if (isset($this->request->get['filter_date_type'])) {
				$querystring .= '&filter_date_type=' . $this->request->get['filter_date_type'];
			}

			if (isset($this->request->get['filter_open_date'])) {
				$querystring .= '&filter_open_date=' . $this->request->get['filter_open_date'];
			}

			if (isset($this->request->get['filter_close_date'])) {
				$querystring .= '&filter_close_date=' . $this->request->get['filter_close_date'];
			}

			if (isset($this->request->get['filter_store_id'])) {
				$querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}

			if (isset($this->request->get['filter_location'])) {
				$querystring .= '&filter_location=' . $this->request->get['filter_location'];
			}

			if (isset($this->request->get['filter_batch_date_start'])) {
				$querystring .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
			}

			if (isset($this->request->get['filter_batch_date_end'])) {
				$querystring .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
			}

			if (isset($this->request->get['filter_product_name'])) {
				$querystring .= '&filter_product_name=' . $this->request->get['filter_product_name'];
			}

			if (isset($this->request->get['filter_product_code'])) {
				$querystring .= '&filter_product_code=' . $this->request->get['filter_product_code'];
			}
			if (isset($this->request->get['filter_category'])) {
				$querystring .= '&filter_category=' . $this->request->get['filter_category'];
			}

			if (isset($this->request->get['filter_doc_type'])) {
				$querystring .= '&filter_doc_type=' . $this->request->get['filter_doc_type'];
			}

			if (isset($this->request->get['sort'])) {
				$querystring .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$querystring .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['filter_description'])) {
				$querystring .= '&filter_description=' . $this->request->get['filter_description'];
			}

			

			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $page_limit;
			$pagination->url = $this->url->link('report/product_movement', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $page_limit) + 1 : 0, ((($page - 1) * $page_limit) > ($product_total - $page_limit)) ? $product_total : ((($page - 1) * $page_limit) + $page_limit), $product_total, ceil($product_total / $page_limit));

			$data['filter_open_date'] = $filter_open_date;
			$data['filter_close_date'] = $filter_close_date;
			$data['filter_category'] = explode(',', $filter_category);
			$data['filter_doc_type'] = explode(',',$filter_doc_type);


			$data['filter_store_id'] = explode(',', $filter_store_id);
			$data['filter_location'] = explode(',', $filter_location);
			$data['filter_batch_date_start'] = explode(',',$filter_batch_date_start);
			$data['filter_batch_date_end'] = $filter_batch_date_end;
			$data['filter_product_name'] = $filter_product_name;
			$data['filter_product_code'] = $filter_product_code;
			$data['filter_description'] = $filter_description;
			$data['product_locations'] = $this->model_report_product_movement->getlocation($product_id);
			$data['product_batch_date'] = $this->model_report_product_movement->getbatchdate($product_id);


			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');

			$this->response->setOutput($this->load->view('report/product_movement', $data));
		} else {
			$this->load->language('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_not_found'] = $this->language->get('text_not_found');

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}
}
