<?php
class ControllerReportPosSummaryByStock extends Controller {
	public function index() {
		$this->load->language('report/pos_summary_by_stock');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/sale');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			if($this->request->get['filter_payment_status']){
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
		} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'op.product_id';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		//urls
		$data['export_excel'] = $this->url->link('report/pos_summary_by_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_payment_status'] = $filter_payment_status;
		$data['filter_code'] = $filter_code;
		$data['filter_name_cn'] = $filter_name_cn;
		$data['filter_name_en'] = $filter_name_en;
		
		//**data
		
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$this->load->library('weight');
		$this->weight = new Weight($this->registry);
		
		$data['sales'] = array();
		$sales = $this->model_report_sale->getPosSummaryByStock($filter_data);
		
		foreach($sales as $sale){
			$label = ''; 
			switch($sale['order_status_id']){
				case 1:
					$label = 'warning';
					break;
				case 5:
					$label = 'success';
					break;
				case 7:
				case 17:
					$label = 'danger';
					break;
			}
					
			$data['sales'][] = array(
				'product_id' 		=> $sale['product_id'],
				'code' 				=> $sale['code'],
				'en_name' 			=> $sale['en_name'],
				'cn_name' 			=> $sale['cn_name'],
				'order_status'		=> $sale['order_status'],
				'order_status_id'	=> $sale['order_status_id'],
				'label'				=> $label,
				'quantity'			=> $sale['quantity'],
				'price' 			=> $this->currency->format($sale['price'],$this->config->get('config_currency')),
				'discount' 			=> $this->currency->format($sale['discount'],$this->config->get('config_currency')),
				'net_amount' 		=> $this->currency->format($sale['net_amount'],$this->config->get('config_currency')),
				'total_net_amount' 	=> $this->currency->format($sale['total_net_amount'],$this->config->get('config_currency')),
				'total_tax' 		=> $this->currency->format($sale['total_tax'],$this->config->get('config_currency')),
				'total' 			=> $this->currency->format($sale['total'],$this->config->get('config_currency'))
			);
		}
		
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if(isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if(isset($this->request->get['filter_code'])) {
			$querystringforsort .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if(isset($this->request->get['filter_name_cn'])) {
			$querystringforsort .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if(isset($this->request->get['filter_name_en'])) {
			$querystringforsort .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_product_id'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=op.product_id' . $querystringforsort, true);
		$data['sort_product_code'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=p.code' . $querystringforsort, true);
		$data['sort_name_en'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=en_name' . $querystringforsort, true);
		$data['sort_name_cn'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=cn_name' . $querystringforsort, true);
		$data['sort_status'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $querystringforsort, true);
		$data['sort_quantity'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
		$data['sort_price'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $querystringforsort, true);
		$data['sort_discount'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=discount' . $querystringforsort, true);
		$data['sort_net_amount'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=net_amount' . $querystringforsort, true);
		$data['sort_total_net_amount'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_net_amount' . $querystringforsort, true);
		$data['sort_total_tax'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		
		//**language
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_sale->getPosSummaryByStockTotal($filter_data);

		
		
		$data['total_quantity'] = $this->model_report_sale->getPosSummaryByStockTotalQuantity($filter_data);
		$data['total_unit_price'] = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalUnitPrice($filter_data),$this->config->get('config_currency'));
		$data['total_discount'] = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalDiscount($filter_data),$this->config->get('config_currency'));
		$data['total_net_price'] = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetPrice($filter_data),$this->config->get('config_currency'));
		$data['total_net_amount'] = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetAmount($filter_data),$this->config->get('config_currency'));
		$data['total_tax'] = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalTax($filter_data),$this->config->get('config_currency'));
		$data['total_sales'] =  $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalSales($filter_data),$this->config->get('config_currency'));
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/pos_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/pos_summary_by_stock')){
			$data['user_modify'] = true;
		}
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/pos_summary_by_stock', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/sale');
		$this->load->language('report/pos_summary_by_stock');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			if($this->request->get['filter_payment_status']){
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
		} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'op.product_id';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//get gst code
		$this->load->model('setting/store');
		$gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$sales = $this->model_report_sale->getPosSummaryByStock($filter_data);
		
		$table_collection = array();
		
		foreach($sales as $sale){
			$table_collection[] = array(
				'product_id' 		=> $sale['product_id'],
				'code' 				=> $sale['code'],
				'en_name' 			=> $sale['en_name'],
				'cn_name' 			=> $sale['cn_name'],
				'order_status'		=> $sale['order_status'],
				'quantity'			=> $sale['quantity'],
				'price' 			=> $this->currency->format($sale['price'],$this->config->get('config_currency'), '', false),
				'discount' 			=> $this->currency->format($sale['discount'],$this->config->get('config_currency'), '', false),
				'net_amount' 		=> $this->currency->format($sale['net_amount'],$this->config->get('config_currency'), '', false),
				'total_net_amount' 	=> $this->currency->format($sale['total_net_amount'],$this->config->get('config_currency'), '', false),
				'total_tax' 		=> $this->currency->format($sale['total_tax'],$this->config->get('config_currency'), '', false),
				'total' 			=> $this->currency->format($sale['total'],$this->config->get('config_currency'), '', false),
				'tax_code' => $sale['tax_code']
			);
		}
		
		$total_quantity = $this->model_report_sale->getPosSummaryByStockTotalQuantity($filter_data);
		$total_unit_price = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalUnitPrice($filter_data),$this->config->get('config_currency'), '', false);
		$total_discount = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalDiscount($filter_data),$this->config->get('config_currency'), '', false);
		$total_net_price = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetPrice($filter_data),$this->config->get('config_currency'), '', false);
		$total_net_amount = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetAmount($filter_data),$this->config->get('config_currency'), '', false);
		$total_tax = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalTax($filter_data),$this->config->get('config_currency'), '', false);
		$total_sales =  $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalSales($filter_data),$this->config->get('config_currency'), '', false);
		
		$table_collection[] = array('', '', '', '', '', '', '', '', $total_net_price, $total_net_amount, $total_tax, $total_sales);
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array();
		
		/*
		$table[] = array('Report Summary : ');
		
		$total_quantity = $this->model_report_sale->getPosSummaryByStockTotalQuantity($filter_data);
		$total_unit_price = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalUnitPrice($filter_data),$this->config->get('config_currency'));
		$total_discount = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalDiscount($filter_data),$this->config->get('config_currency'));
		$total_net_price = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetPrice($filter_data),$this->config->get('config_currency'));
		$total_net_amount = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalNetAmount($filter_data),$this->config->get('config_currency'));
		$total_tax = $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalTax($filter_data),$this->config->get('config_currency'));
		$total_sales =  $this->currency->format($this->model_report_sale->getPosSummaryByStockTotalSales($filter_data),$this->config->get('config_currency'));
		
		$table[] = array($this->language->get('text_total_quantity'), 	$total_quantity);
		$table[] = array($this->language->get('text_total_unit_price'), $total_unit_price);
		$table[] = array($this->language->get('text_total_discount'), 	$total_discount);
		$table[] = array($this->language->get('text_total_net_price'), 	$total_net_price);
		$table[] = array($this->language->get('text_total_net_amount'), $total_net_amount);
		$table[] = array($this->language->get('text_total_tax'), 		$total_tax);
		$table[] = array($this->language->get('text_total_sales'), 		$total_sales);
		*/
		
		//$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		
		$table_header = array(//table headers
			$this->language->get('column_product_id'),
			$this->language->get('column_product_code'),
			$this->language->get('column_en_name'),
			$this->language->get('column_cn_name'),
			$this->language->get('column_status'),
			$this->language->get('column_quantity'),
			$this->language->get('column_price'),
			$this->language->get('column_discount'),
			$this->language->get('column_net_amount'),
			$this->language->get('column_net_amount_total'),
			$this->language->get('column_tax'),
			$this->language->get('column_total'),
			$this->language->get('column_tax_code')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$text_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($text_style);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($text_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>