<?php
class ControllerReportPosHoldList extends Controller {
	public function index() {
		$this->load->language('report/pos_hold_list');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}
		
		if (isset($this->request->get['filter_customer_type'])) {
			$filter_customer_type = $this->request->get['filter_customer_type'];
		} else {
			$filter_customer_type = '';
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_customer_type'])) {
			$url .= '&filter_customer_type=' . $this->request->get['filter_customer_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/pos_hold_list/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/pos');

		$data['orders'] = array();

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end' => $filter_transaction_end,
			'filter_customer_type' => $filter_customer_type,
			'filter_customer_card' => $filter_customer_card,
			'filter_customer_name' => $filter_customer_name,
			'filter_payment_method' => $filter_payment_method,
			'filter_store_id' => $filter_store_id,
			'sort'					=> $sort,
			'order'					=> $order,
			'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  => $this->config->get('config_limit_admin')
		);

		
		$total_transaction = $this->model_report_pos->getHoldListTotal($filter_data);

		$results = $this->model_report_pos->getHoldList($filter_data);

		foreach ($results as $result) {
			
			$customer_type = "";
			
			if($result['customer_type'] == 2){
				$customer_type = $this->language->get('text_customer');
			} else if($result['customer_type'] == 1){
				$customer_type = $this->language->get('text_walk_in_customer');
			}
			
			$label = ''; 

			switch($result['order_status_id']){
				case 1:
					$label = 'warning';
					break;
				case 5:
					$label = 'success';
					break;
				case 7:
				case 17:
					$label = 'danger';
					break;
			}
				
			$data['orders'][] = array(
				'invoice_prefix' => $result['invoice_prefix'],
				'date_added'   => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'customer_type' 	=> $customer_type,
				'customer_name'   	=> $result['customer_name'],
				'customer_card' 	=> $result['customer_card'],
				'payment_method' 	=> $result['payment_method'],
				'status'			=> $result['status'],
				'order_status_id'	=> $result['order_status_id'],
				'label'				=> $label,
				'points'			=> $result['points'],
				'subtotal'			=> $this->currency->format($result['subtotal'], $this->config->get('config_currency')),
				'tax'        		=> $this->currency->format($result['tax'], $this->config->get('config_currency')),
				'total'      		=> $this->currency->format($result['total'], $this->config->get('config_currency')),
				'info' 				=> $this->url->link('report/pos_hold_list/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true)
			);
		}
		
		
		$data['total_subtotal'] = $this->currency->format($this->model_report_pos->getHoldListTotalSubtotal($filter_data), $this->config->get('config_currency'));
		$data['total_tax'] = $this->currency->format($this->model_report_pos->getHoldListTotalTax($filter_data), $this->config->get('config_currency'));
		$data['total_sales'] = $this->currency->format($this->model_report_pos->getHoldListTotalSales($filter_data), $this->config->get('config_currency'));
		
		

		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
	    $data['payment_methods'] = array(
			'Cash' => 'Cash',
			'Boost App' => 'Boost App',
			'Touch n Go eWallet' => 'Touch n Go eWallet',
			'Points' => 'Points',
			'Bank Transfer' => 'Bank Transfer'
		);
		
		//rebuild querystring for sorting
		$querystringforsort = '';
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$querystringforsort .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$querystringforsort .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_customer_type'])) {
			$querystringforsort .= '&filter_customer_type=' . $this->request->get['filter_customer_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$querystringforsort .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$querystringforsort .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$querystringforsort .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_invoice_prefix'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
		$data['sort_date_added'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystringforsort, true);
		$data['sort_customer_type'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_type' . $querystringforsort, true);
		$data['sort_customer_name'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $querystringforsort, true);
		$data['sort_customer_card'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_card' . $querystringforsort, true);
		$data['sort_payment_method'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_method' . $querystringforsort, true);
		$data['sort_status'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystringforsort, true);
		$data['sort_points'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=points' . $querystringforsort, true);
		$data['sort_subtotal'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		
		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_customer_type'])) {
			$url .= '&filter_customer_type=' . $this->request->get['filter_customer_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $total_transaction;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_transaction_start'] = $filter_transaction_start;
		$data['filter_transaction_end'] = $filter_transaction_end;
		$data['filter_customer_type'] = $filter_customer_type;
		$data['filter_customer_card'] = $filter_customer_card;
		$data['filter_customer_name'] = $filter_customer_name;
		$data['filter_payment_method'] = $filter_payment_method;
		$data['filter_store_id'] = $filter_store_id;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/pos_hold_list', $data));
	}
	
	public function info(){	
		$order_id = isset($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;
		$this->load->model('sale/order');
		
		$order = $this->model_sale_order->getOrder($order_id);
		
		if(!empty($order)){
			//load default language
			$this->load->language('report/pos_hold_list');
		
			//set document title
			$this->document->setTitle($this->language->get('heading_title'));
			
			$data['heading_title'] = $this->language->get('heading_title');
			
			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}
			
			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
			} else {
				$sort = 'date_added';
			}
			
			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
			} else {
				$order = 'DESC';
			}
			
			//**sitemap
			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'], true)
			);
			
			//**text
			$data['text_total_tax'] = $this->language->get('text_total_tax');
			$data['text_subtotal'] = $this->language->get('text_subtotal');
			$data['text_total'] = $this->language->get('text_total');
			
			//**column
			$data['column_name'] = $this->language->get('column_name');
			$data['column_code'] = $this->language->get('column_code');
			$data['column_model'] = $this->language->get('column_model');
			$data['column_quantity'] = $this->language->get('column_quantity');
			$data['column_price'] = $this->language->get('column_price');
			$data['column_subtotal'] = $this->language->get('column_subtotal');
			$data['column_tax'] = $this->language->get('column_tax');
			$data['column_total'] = $this->language->get('column_total');
			
			//**button text
			$data['button_cancel']	= $this->language->get('button_cancel');
			
			//**entry
			
			
			$data['user_token'] = $this->session->data['user_token'];
			$data['sort'] = $sort;
			$data['order'] = $order;
			
			$this->load->model('report/pos');
			$transaction_item = $this->model_report_pos->getHoldListInfo($order_id);
			
			$data['transaction_item'] = array();
			//**data
			foreach($transaction_item as $product){
				$data['transaction_item'][] = array(
					'code' => $product['code'],
					'name' => $product['name'],
					'quantity' => $product['quantity'],
					'price' => $this->currency->format($product['price'], $this->config->get('config_currency')),
					'subtotal' => $this->currency->format($product['subtotal'], $this->config->get('config_currency')),
					'tax' => $this->currency->format($product['tax'], $this->config->get('config_currency')),
					'total' => $this->currency->format($product['total'], $this->config->get('config_currency'))
					
					
				);
			}
			
			$data['total_tax'] = $this->currency->format($this->model_report_pos->getHoldListInfoTotalTax($order_id), $this->config->get('config_currency'));
			$data['total_subtotal'] = $this->currency->format($this->model_report_pos->getHoldListInfoTotalSubtotal($order_id), $this->config->get('config_currency'));
			$data['total_sales'] = $this->currency->format($this->model_report_pos->getHoldListInfoTotalSales($order_id), $this->config->get('config_currency'));
			
			$this->load->model('sale/order');
			
			$order_info = $this->model_sale_order->getOrder($order_id);
			
			$totals = $this->model_sale_order->getOrderTotals($order_id);
			//tracing sql
			/*
			echo "<pre>";
			print_r($totals);
			echo "</pre>";
			*/
			foreach ($totals as $total) {
				$data['totals'][] = array(
					'title' => $total['title'],
					'text'  => $this->currency->format($total['value'], $this->config->get('config_currency')),
				);
			}
			
			//**query string
			$querystring = '';

			if (isset($this->request->get['filter_date_start'])) {
				$querystring .= '&filter_date_start=' . $this->request->get['filter_date_start'];
			}
	
			if (isset($this->request->get['filter_date_end'])) {
				$querystring .= '&filter_date_end=' . $this->request->get['filter_date_end'];
			}
	
			if (isset($this->request->get['filter_order_status_id'])) {
				$querystring .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}
			
			if (isset($this->request->get['filter_transaction_start'])) {
				$querystring .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
			}
			
			if (isset($this->request->get['filter_transaction_end'])) {
				$querystring .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
			}
			
			if (isset($this->request->get['filter_customer_type'])) {
				$querystring .= '&filter_customer_type=' . $this->request->get['filter_customer_type'];
			}
			
			if (isset($this->request->get['filter_store_id'])) {
				$querystring .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}
			
			if (isset($this->request->get['filter_customer_card'])) {
				$querystring .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
			}
			
			if (isset($this->request->get['filter_customer_name'])) {
				$querystring .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
			}
			
			if (isset($this->request->get['filter_payment_method'])) {
				$querystring .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
			}
			
			if (isset($this->request->get['sort'])) {
				$querystring .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$querystring .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$querystring .= '&page=' . $this->request->get['page'];
			}

			//**url
			$data['cancel'] = $this->url->link('report/pos_hold_list', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
			$data['edit'] = $this->url->link('report/pos_hold_list/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order_id . $querystring, true);
			
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');

			$this->response->setOutput($this->load->view('report/pos_hold_list_info', $data));
		} else{
			$this->load->language('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_not_found'] = $this->language->get('text_not_found');

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
		
	}
	
	public function exportExcel(){
		
		$this->load->model('report/pos');
		$this->load->language('report/pos_hold_list');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}
		
		if (isset($this->request->get['filter_customer_type'])) {
			$filter_customer_type = $this->request->get['filter_customer_type'];
		} else {
			$filter_customer_type = '';
		}
		
		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}	

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//** filter data
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_transaction_start' 	=> $filter_transaction_start,
			'filter_transaction_end' 	=> $filter_transaction_end,
			'filter_customer_type' 		=> $filter_customer_type,
			'filter_customer_card' 		=> $filter_customer_card,
			'filter_customer_name' 		=> $filter_customer_name,
			'filter_payment_method' 	=> $filter_payment_method,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$results = $this->model_report_pos->getHoldList($filter_data);
		
		$table_collection = array();
		
		foreach ($results as $result) {
			
			$customer_type = "";
			
			if($result['customer_type'] == 2){
				$customer_type = $this->language->get('text_customer');
			} else if($result['customer_type'] == 1){
				$customer_type = $this->language->get('text_walk_in_customer');
			}
			
			$table_collection[] = array(
				'invoice_prefix' 	=> $result['invoice_prefix'],
				'date_added'   		=> date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'customer_type' 	=> $customer_type,
				'customer_name'   	=> $result['customer_name'],
				'customer_card' 	=> $result['customer_card'],
				'payment_method' 	=> $result['payment_method'],
				'status'			=> $result['status'],
				'points'			=> $result['points'],
				'subtotal'        		=> $this->currency->format($result['subtotal'], $this->config->get('config_currency'), '', false),
				'tax'        		=> $this->currency->format($result['tax'], $this->config->get('config_currency'), '', false),
				'total'      		=> $this->currency->format($result['total'], $this->config->get('config_currency'), '', false)
			);
		}
		
		$total_tax = $this->currency->format($this->model_report_pos->getHoldListTotalTax($filter_data), $this->config->get('config_currency'), '', false);
		$total_subtotal = $this->currency->format($this->model_report_pos->getHoldListTotalSubtotal($filter_data), $this->config->get('config_currency'), '', false);
		$total_sales = $this->currency->format($this->model_report_pos->getHoldListTotalSales($filter_data), $this->config->get('config_currency'), '', false);
		
		$table_collection[] = array(
			'', '', '', '', '', '', '', '',
			$total_subtotal,
			$total_tax,
			$total_sales
		);
		
		$table = array();
		
		/*
		$table[] = array('Report Summary : ');
		$total_tax = $this->currency->format($this->model_report_pos->getHoldListTotalTax($filter_data), $this->config->get('config_currency'));
		$total_subtotal = $this->currency->format($this->model_report_pos->getHoldListTotalSubtotal($filter_data), $this->config->get('config_currency'));
		$total_sales = $this->currency->format($this->model_report_pos->getHoldListTotalSales($filter_data), $this->config->get('config_currency'));
		
		$table[] = array($this->language->get('text_total_tax') , $total_tax);
		$table[] =  array($this->language->get('text_subtotal') , $total_subtotal);
		$table[] = array($this->language->get('text_total') 	, $total_sales);
		*/
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		$table_header = array(//table headers
			$this->language->get('column_transaction_no'),
			$this->language->get('column_date'),
			$this->language->get('column_customer_type'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_customer_card'),
			$this->language->get('column_payment_method'),
			$this->language->get('column_status'),
			$this->language->get('column_reward_point'),
			$this->language->get('column_subtotal'),
			$this->language->get('column_tax'),
			$this->language->get('column_total')
		);
		$table[] = $table_header;//add header to table
		
		$total_row = 0;
		
		$table_data = $table_collection;
		$row;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			
			$total_row ++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$textformat_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style);// top
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}