<?php
class ControllerReportNewReturningCustomer extends Controller {
	protected function c_format($data) {
		return $this->currency->format($data,$this->config->get('config_currency'));
	}

	protected function print_data($data) {
		echo '<pre>';
		print_r($data);
		echo '</pre>';
	}

	public function index() {
		$msc = microtime(true);
		$this->load->model('report/new_returning_customer');
		$this->load->language('report/new_returning_customer');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		// $languages = $this->load->language('report/new_returning_customer');
		// foreach ($languages as $l => $lang) {
		// 	$data[$l] = $lang;
		// }

		$this->document->setTitle($this->language->get('heading_title'));
		
		//**filter

        $data['date_types'][] = [
            'text' => 'Custom',
            'value' => 'custom'
        ];
        $data['date_types'][] = [
            'text' => 'Today',
            'value' => 'today'
        ];
        $data['date_types'][] = [
            'text' => 'Yesterdays',
            'value' => 'Yesterday'
        ];
        $data['date_types'][] = [
            'text' => 'Last 7 days',
            'value' => 'Last_7_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 30 days',
            'value' => 'Last_30_days'
        ];

        $config_date_type = 'today';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

        if($filter_date_type != 'custom' ){
            $date_now = date('Y-m-d');
            switch ($filter_date_type) {
                // case 'all':
                // 	$filter_date_start2 = '';
                // 	$filter_date_end2 = '';
                // 	break;
                case 'today':
                    $filter_date_start2 = date('Y-m-d');
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Yesterday':
                    $filter_date_start2 = date('Y-m-d',strtotime('-1 days'));
                    $filter_date_end2 = date('Y-m-d',strtotime('-1 days'));
                    break;
                case 'Last_7_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-7 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Last_30_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-30 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                default:
                    $filter_date_start2 =  '1999-01-01';
                    $filter_date_end2 = '2999-12-31';
                    break;
            }
            // $data['selected_date_type'] = $filter_date_type;
        } else{
            $filter_date_start2 = $filter_date_start;
            $filter_date_end2 = $filter_date_end;
        }


        $this->request->get['filter_date_start'] = $filter_date_start;
        $this->request->get['filter_date_end'] = $filter_date_end;

		
		if (isset($this->request->get['filter_store_id'])) {
			
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}

			if (isset($this->request->get['filter_doctor'])) {
			
				$filter_doctor = $this->request->get['filter_doctor'];
			} else {
				$filter_doctor = '';
			}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_doctor'])) {
			$url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
		}
		
		if (isset($this->request->get['filter_name'])) {
			$url .= '&filter_name=' . $this->request->get['filter_name'];
		}
		
		
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/new_returning_customer/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start2,
			'filter_date_end' 		=> $filter_date_end2,
			'filter_store_id' 		=> $filter_store_id,
			'filter_doctor'			=> $filter_doctor,
			
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = explode(',',$filter_store_id);
		$data['filter_doctor'] = explode(',',$filter_doctor);
		
		
		//**data
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$data['user_view'] = $this->user->user_view;
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		$data['doctorlist'] = $this->model_report_new_returning_customer->getuserlist();

		
		$this->load->model('localisation/order_status');

		$data['user_token'] = $this->session->data['user_token'];

		$data['medical_record_new_total'] = 0;
		$data['medical_record_return_total'] = 0;
		$data['medical_record_total_total'] = 0;
		$data['service_form_new_total'] = 0;
		$data['service_form_return_total'] = 0;
		$data['service_form_total_total'] = 0;
		$data['final_total_total'] = 0;
		
        for ( $i = strtotime($filter_date_start2); $i <= strtotime($filter_date_end2); $i = $i + 86400 ) {
            $thisDate = date( 'Y-m-d', $i ); // 2010-05-01, 2010-05-02, etc
            // echo"<pre>";
            // print_r($thisDate);
            // echo"</pre>";
		$newreturnlists = $this->model_report_new_returning_customer->getnewreturninglist($filter_data,$thisDate);
        foreach($newreturnlists as $newreturnlist){
            $data['new_return_lists'][] = array(
				'date' => $thisDate,
				'medical_record_new' => $newreturnlist['clinical_sale_new'],
				'medical_record_return' => $newreturnlist['clinical_sale_returning'],
				'medical_record_total' => $newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'],
				'service_form_new' => $newreturnlist['service_new'],
				'service_form_return' => $newreturnlist['service_return'],
				'service_form_total' => $newreturnlist['service_new'] + $newreturnlist['service_return'],
                'final_total' => $newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'] +$newreturnlist['service_new'] + $newreturnlist['service_return'],
				
			);
		$data['medical_record_new_total'] += $newreturnlist['clinical_sale_new'];
		$data['medical_record_return_total'] += $newreturnlist['clinical_sale_returning'];
		$data['medical_record_total_total'] +=  ($newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning']);
		$data['service_form_new_total'] += $newreturnlist['service_new'];
		$data['service_form_return_total'] += $newreturnlist['service_return'];
		$data['service_form_total_total'] += ($newreturnlist['service_new'] + $newreturnlist['service_return']);
		$data['final_total_total'] += ($newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'] +$newreturnlist['service_new'] + $newreturnlist['service_return']);


        }

          }

        $data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/new_returning_customer')){
			$data['user_modify'] = true;
		}

		$data['customer_modify'] = false;
		if($this->user->hasPermission('modify', 'customer/customer')){
			$data['customer_modify'] = true;
		}

		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_telephone'])) {
			$querystringforsort .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}
		
		
		$data['sort_date'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, 'SSL');
		$data['sort_herbal_remedies'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=herbal_remedies' . $querystringforsort, 'SSL');
		$data['sort_service_form'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=service_form' . $querystringforsort, 'SSL');
		$data['sort_pos'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=pos' . $querystringforsort, 'SSL');
		$data['sort_tax'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, 'SSL');$data['sort_date'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, 'SSL');
		$data['sort_subtotal'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, 'SSL');
		$data['sort_total'] = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, 'SSL');
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_doctor'])) {
			$url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		// $total_sales_result = $this->model_report_new_returning_customer->getcustomerlistnumber($filter_data);
		
		//**pagination
		// $pagination = new Pagination();
		// $pagination->total = $total_sales_result;
		// $pagination->page = $page;
		// $pagination->limit = $this->config->get('config_limit_admin');
		// $pagination->url = $this->url->link('report/new_returning_customer', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

		// $data['pagination'] = $pagination->render();
		
		// $data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		// $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

		// //**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$msc = microtime(true)-$msc;
		/*echo '<pre>';
		print_r($msc);
		echo '</pre>';*/
		
		//**layout
		$this->response->setOutput($this->load->view('report/new_returning_customer_list', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/new_returning_customer');
		$this->load->language('report/new_returning_customer');
		
		//**filter
        
        $config_date_type = 'today';
			$filter_date_type = isset($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : $config_date_type;
			$data['selected_date_type'] = $filter_date_type;

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

        if($filter_date_type != 'custom' ){
            $date_now = date('Y-m-d');
            switch ($filter_date_type) {
                // case 'all':
                // 	$filter_date_start2 = '';
                // 	$filter_date_end2 = '';
                // 	break;
                case 'today':
                    $filter_date_start2 = date('Y-m-d');
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Yesterday':
                    $filter_date_start2 = date('Y-m-d',strtotime('-1 days'));
                    $filter_date_end2 = date('Y-m-d',strtotime('-1 days'));
                    break;
                case 'Last_7_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-7 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                case 'Last_30_days':
                    $filter_date_start2 = date('Y-m-d',strtotime('-30 days'));
                    $filter_date_end2 = date('Y-m-d');
                    break;
                default:
                    $filter_date_start2 =  '1999-01-01';
                    $filter_date_end2 = '2999-12-31';
                    break;
            }
            // $data['selected_date_type'] = $filter_date_type;
        } else{
            $filter_date_start2 = $filter_date_start;
            $filter_date_end2 = $filter_date_end;
        }


        $this->request->get['filter_date_start'] = $filter_date_start;
        $this->request->get['filter_date_end'] = $filter_date_end;

		
		if (isset($this->request->get['filter_store_id'])) {
			
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}

			if (isset($this->request->get['filter_doctor'])) {
			
				$filter_doctor = $this->request->get['filter_doctor'];
			} else {
				$filter_doctor = '';
			}
		
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start2,
			'filter_date_end' 		=> $filter_date_end2,
			'filter_store_id' 		=> $filter_store_id,
			'filter_doctor' 		=> $filter_doctor,

			
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		// $sales = $this->model_report_new_returning_customer->getSalesSummary($filter_data);
		
		$data['medical_record_new_total'] = 0;
		$data['medical_record_return_total'] = 0;
		$data['medical_record_total_total'] = 0;
		$data['service_form_new_total'] = 0;
		$data['service_form_return_total'] = 0;
		$data['service_form_total_total'] = 0;
		$data['final_total_total'] = 0;
		
        for ( $i = strtotime($filter_date_start); $i <= strtotime($filter_date_end); $i = $i + 86400 ) {
            $thisDate = date( 'Y-m-d', $i ); // 2010-05-01, 2010-05-02, etc
            // echo"<pre>";
            // print_r($thisDate);
            // echo"</pre>";
		$newreturnlists = $this->model_report_new_returning_customer->getnewreturninglist($filter_data,$thisDate);
        foreach($newreturnlists as $newreturnlist){
			$table_collection[] = array(
				'date' => $thisDate,
				'medical_record_new' => $newreturnlist['clinical_sale_new'],
				'medical_record_return' => $newreturnlist['clinical_sale_returning'],
				'medical_record_total' => $newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'],
				'service_form_new' => $newreturnlist['service_new'],
				'service_form_return' => $newreturnlist['service_return'],
				'service_form_total' => $newreturnlist['service_new'] + $newreturnlist['service_return'],
                'final_total' => $newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'] +$newreturnlist['service_new'] + $newreturnlist['service_return'],
				
			);
		$data['medical_record_new_total'] += $newreturnlist['clinical_sale_new'];
		$data['medical_record_return_total'] += $newreturnlist['clinical_sale_returning'];
		$data['medical_record_total_total'] +=  ($newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning']);
		$data['service_form_new_total'] += $newreturnlist['service_new'];
		$data['service_form_return_total'] += $newreturnlist['service_return'];
		$data['service_form_total_total'] += ($newreturnlist['service_new'] + $newreturnlist['service_return']);
		$data['final_total_total'] += ($newreturnlist['clinical_sale_new'] + $newreturnlist['clinical_sale_returning'] +$newreturnlist['service_new'] + $newreturnlist['service_return']);


        }

          }
		  $table_collection[] = array(
				'',
				$data['medical_record_new_total'],
				$data['medical_record_return_total'],
				$data['medical_record_total_total'],
				$data['service_form_new_total'],
				$data['service_form_return_total'],
				$data['service_form_total_total'],
				$data['final_total_total']
			);
		
		// $table_collection = array();

		// $customerlists = $this->model_report_new_returning_customer->getcustomerlist($filter_data);
		// $total_num = 0; 
		// foreach($customerlists as $customerlist){
        //     $num =1;
		// 	$table_collection[] = array(
		// 		'name' => $customerlist['name'],
		// 		'telephone' => $customerlist['telephone'],
		// 		'age' => $customerlist['age'],
		// 		'gender' => $customerlist['gender'],
		// 		'customer_group' => $customerlist['customer_group'],
		// 		'date_added' => DATE('Y-m-d',strtotime($customerlist['date_added'])),

		// 	);
		// 	$total_num += $num; 
		// }

		// $data['total_num'] = $total_num;
		// $table_collection[] = array(
		// 	'','','','','Total',$data['total_num']
		// );
		
		
		$table = array();
		
		
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		$table_header = array(//table headers
			$this->language->get('column_date'),
			$this->language->get('column_medical_record'),
			'',
			'',
			$this->language->get('column_service_record'),
			'',
			'',
			$this->language->get('column_totals'),

		);
		$table_header2 = array(//table headers
			'',
			$this->language->get('column_New'),
			$this->language->get('column_return'),
			$this->language->get('column_total'),
			$this->language->get('column_New'),
			$this->language->get('column_return'),
			$this->language->get('column_total'),
			'',

		);
		$table[] = $table_header;//add header to table
		$table[] = $table_header2;
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->mergeCells('A4:A5');
		$objPHPExcel->getActiveSheet()->mergeCells('B4:D4');
		$objPHPExcel->getActiveSheet()->mergeCells('E4:G4');
		$objPHPExcel->getActiveSheet()->mergeCells('H4:H5');
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>