<?php
class ControllerReportHerbalremediesSummaryByStock extends Controller {
	public function index() {
		$this->load->language('report/herbalremedies_summary_by_stock');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/herbalremedies_summary_by_stock');

		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
	

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = 5;
			}
		
		
		if (isset($this->request->get['filter_order_status'])) {
				$filter_order_status = $this->request->get['filter_order_status'];
			} else {
				$filter_order_status = 5;
			}
		
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = '';
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = '';
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = '';
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'model';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_order_status'])) {
			$url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/herbalremedies_summary_by_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		$start = ($page - 1) * $this->config->get('config_limit_admin');
		$limit = $this->config->get('config_limit_admin');

		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_category'		=> $filter_category,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_order_status' 	=> $filter_order_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'filter_product_name'	=> $filter_product_name,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_category'] = $filter_category;
		$data['filter_payment_status'] = !empty($filter_payment_status) ? explode(',',$filter_payment_status) : [];
		$data['filter_order_status'] = !empty($filter_order_status) ? explode(',',$filter_order_status):[];
		$data['filter_payment_method'] = $filter_payment_method;
		$data['filter_code'] = $filter_code;
		$data['filter_product_name'] = $filter_product_name;
		
		//**data
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['payment_methods'] = $this->model_report_herbalremedies_summary_by_stock->getPaymentMethod();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$data['sales'] = array();
		$sales = $this->model_report_herbalremedies_summary_by_stock->getHerbalremediesSummaryByStock($filter_data);
		
		$grandtotal_cost = 0;
		$grandtotal_price = 0;
		$grandtotal_profits = 0;

		foreach($sales as $sale){
			
			$total_cost = $sale['costprice'] * $sale['weight'];
			$total_price = $sale['price'] * $sale['weight'];
			if($total_price != 0){
				$total_profits = ($total_price - $total_cost) / $total_price * 100;
			}else{
				$total_profits = 0;
			}
			

			$data['sales'][] = array(
				'product_id' 	=> $sale['product_id'],
				'code' 			=> $sale['code'],
				'product_name' 		=> $sale['product_name'],
				'category'		=> $sale['category'],
				'costprice' 	=> $this->currency->format($sale['costprice'],$this->config->get('config_currency')),
				'price' 		=> $this->currency->format($sale['price'],$this->config->get('config_currency')),
				'quantity' 		=> $this->weight->format($sale['weight'], $sale['weight_class_id']),
				'total_cost'	=> $this->currency->format($total_cost, $this->config->get('config_currency')),
				'total_price'	=> $this->currency->format($total_price, $this->config->get('config_currency')),
				'total_profits'	=> ROUND($total_profits,0) ."%",
				'info' 			=> $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&filter_code='. $sale['code'] , true)

			);

			$grandtotal_cost += $total_cost;
			$grandtotal_price += $total_price;
			$grandtotal_profits += $total_profits;
		}
		
		$data['total_cost'] = $this->currency->format($grandtotal_cost, $this->config->get('config_currency'));
		$data['total_price'] = $this->currency->format($grandtotal_price, $this->config->get('config_currency'));
		$data['total_profits'] = $grandtotal_profits .'%' ;

		$data['sales'] = array_slice($data['sales'], $start, $limit);
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_category'])) {
			$querystringforsort .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if(isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if(isset($this->request->get['filter_order_status'])) {
			$querystringforsort .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}
		
		if(isset($this->request->get['filter_code'])) {
			$querystringforsort .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if(isset($this->request->get['filter_name_cn'])) {
			$querystringforsort .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if(isset($this->request->get['filter_name_en'])) {
			$querystringforsort .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_product_id'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=product_id' . $querystringforsort, true);
		$data['sort_code'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
		$data['sort_en_name'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=en_name' . $querystringforsort, true);
		$data['sort_cn_name'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=cn_name' . $querystringforsort, true);
		$data['sort_category'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystringforsort, true);
		$data['sort_model'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=model' . $querystringforsort, true);
		$data['sort_costprice'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=costprice' . $querystringforsort, true);
		$data['sort_price'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $querystringforsort, true);
		$data['sort_total_weight'] = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_weight' . $querystringforsort, true);
		
		//**language
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_order_status'])) {
			$url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_herbalremedies_summary_by_stock->getHerbalremediesSummaryByStockTotal($filter_data);
		$data['total_quantity'] = $this->weight->format($this->model_report_herbalremedies_summary_by_stock->getHerbalremediesSummaryByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/herbalremedies_summary_by_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		$data['categorys'] = $this->model_report_herbalremedies_summary_by_stock->getcategory();

		$data['button_validate'] = false;
        if ($this->user->hasPermission('modify', 'report/herbalremedies_summary_by_stock')) {
            $data['button_validate'] = true;
        }

		$data['check_detail'] = false;
        if ($this->user->hasPermission('modify', 'report/herbalremedies_detail_by_stock')) {
            $data['check_detail'] = true;
        }

		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/herbalremedies_summary_by_stock', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/herbalremedies_summary_by_stock');
		$this->load->language('report/herbalremedies_summary_by_stock');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
	

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = 5;
			}
		
		
		if (isset($this->request->get['filter_order_status'])) {
				$filter_order_status = $this->request->get['filter_order_status'];
			} else {
				$filter_order_status = 5;
			}
		
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = '';
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = '';
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = '';
		}
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'model';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_category'		=> $filter_category,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_order_status'	=> $filter_order_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'filter_product_name'			=> $filter_product_name,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//get gst code
		$this->load->model('setting/store');
		// $gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));
		//$gstno = 0;
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$sales = $this->model_report_herbalremedies_summary_by_stock->getHerbalremediesSummaryByStock($filter_data);

		
		$table_collection = array();
		
		$grandtotal_cost = 0;
		$grandtotal_price = 0;
		$grandtotal_profits = 0;

		foreach($sales as $sale){
			$total_cost = $sale['costprice'] * $sale['weight'];
			$total_price = $sale['price'] * $sale['weight'];
			if($total_price != 0){
				$total_profits = ($total_price - $total_cost) / $total_price * 100;
			}else{
				$total_profits = 0;
			}

			$table_collection[] = array(
				'product_name' 		=> $sale['product_name'],
				'code' 				=> $sale['code'],
				'category'			=> $sale['category'],
				'costprice' 		=> $this->currency->format($sale['costprice'],$this->config->get('config_currency'), '', false),
				'quantity' 			=> $this->weight->format($sale['weight'], $sale['weight_class_id']),
				'total_cost'		=> $this->currency->format($total_cost, $this->config->get('config_currency'), '', false),
				'total_price'		=> $this->currency->format($total_price, $this->config->get('config_currency'), '', false),
				'total_profits'		=> ROUND($total_profits,2) ."%"
			);

			$grandtotal_cost += $total_cost;
			$grandtotal_price += $total_price;
			$grandtotal_profits += $total_profits;
		}
		
		$total_quantity = $this->weight->format($this->model_report_herbalremedies_summary_by_stock->getHerbalremediesSummaryByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		
		$table_collection[] = array('','','','', $total_quantity, $grandtotal_cost, $grandtotal_price,'');
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
			
		//$table[] = array('Report Detail : '); // label
		
		$table_header = array(//table headers
			$this->language->get('column_model'),
			$this->language->get('column_product_code'),
			$this->language->get('column_category'),
			$this->language->get('column_cost'),
			$this->language->get('column_quantity'),
			$this->language->get('column_total_cost'),
			$this->language->get('column_total_price'),
			$this->language->get('column_total_profits')
		);
		
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row ++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$product_id_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		//$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function autocomplete()
	{
		$json = [];
		if (!empty($this->request->get)) {
			//Load the model files
			$this->load->model('report/herbalremedies_summary_by_stock');
			//Get the variables
			$code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : '';
			$name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : '';
			$model = isset($this->request->get['filter_model']) ? $this->request->get['filter_model'] : '';
			$price = isset($this->request->get['filter_price']) ? $this->request->get['filter_price'] : 0;
			$search = isset($this->request->get['filter_search']) ? $this->request->get['filter_search'] : '';
			$stock = isset($this->request->get['filter_stock']) ? $this->request->get['filter_stock'] : '';
			//Set all the variables and put inside and array
			$filter = ['filter_code' => $code, 'filter_product_name' => $name, 'filter_model' => $model, 'filter_price' => $price, 'filter_search' => $search, 'filter_stock' => $stock];
			$results = $this->model_report_herbalremedies_summary_by_stock->getAutocompleteProducts($filter);
			if (!empty($results)) {
				foreach ($results as $result) {
					if ($this->config->get('language_id') == 1) {
						$name = $result['english_name'];
					} else {
						$name = $result['chinese_name'];
					}
					$json[] = [
						'name' => strip_tags(html_entity_decode($name, ENT_QUOTES, 'UTF-8')),
						'code' => $result['code'],
						'model' => $result['model'],
						'price' => $result['price'],
						'costprice' => $result['costprice'],
						'product_id' => $result['product_id'],
						'onhand_quantity' => $result['onhand_quantity'],
						'weight_class_id' => $result['weight_class_id']
					];
				}
			} else {
				$json = [];
			}
		} else {
			$json = [];
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
?>