<?php
class ControllerReportHerbalremediesByTransaction extends Controller {
	public function index() {
		$this->load->language('report/herbalremedies_by_transaction');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$filter_invoice_date_start = $this->request->get['filter_invoice_date_start'];
		} else {
			$filter_invoice_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$filter_invoice_date_end = $this->request->get['filter_invoice_date_end'];
		} else {
			$filter_invoice_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = 5;
		}

		if (isset($this->request->get['filter_hide'])) {
			$filter_hide = $this->request->get['filter_hide'];
		} else {
			$filter_hide = '';
		}

		if (isset($this->request->get['filter_collect_consultation'])) {
			$filter_collect_consultation = $this->request->get['filter_collect_consultation'];
		} else {
			$filter_collect_consultation = '';
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}
		if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 5;
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_date';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$url .= '&filter_invoice_date_start=' . $this->request->get['filter_invoice_date_start'];
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$url .= '&filter_invoice_date_end=' . $this->request->get['filter_invoice_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['filter_collect_consultation'])) {
			$url .= '&filter_collect_consultation=' . $this->request->get['filter_collect_consultation'];
		}

		if (isset($this->request->get['filter_hide'])) {
			$url .= '&filter_hide=' . $this->request->get['filter_hide'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/herbalremedies_by_transaction/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/herbalremedies');

		$data['orders'] = array();

		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_invoice_date_start'	=> $filter_invoice_date_start,
			'filter_invoice_date_end'	=> $filter_invoice_date_end,
			'filter_transaction_start' 	=> $filter_transaction_start,
			'filter_transaction_end' 	=> $filter_transaction_end,
			'filter_customer_card' 		=> $filter_customer_card,
			'filter_customer_name' 		=> $filter_customer_name,
			'filter_payment_status' 	=> $filter_payment_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_collect_consultation'=>$filter_collect_consultation,
			'filter_hide'				=> $filter_hide,
			'filter_doctor_name' 		=> $filter_doctor_name,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start'                  	=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  	=> $this->config->get('config_limit_admin')
		);

		$results = $this->model_report_herbalremedies->getHerbalremediesByTransaction($filter_data);
		$total = $this->model_report_herbalremedies->getTotalHerbalremediesByTransaction($filter_data);
		$data['payment_methods'] = $this->model_report_herbalremedies->getPaymentMethod();

		$total_transaction = count($total);

		foreach ($results as $result) {
			$data['orders'][] = array(
				'sales_date'   			=> date($this->language->get('date_format_short'), strtotime($result['sales_date'])),
				'invoice_prefix' 		=> $result['invoice_prefix'],
				'order_invoice_prefix'	=> $result['order_invoice_prefix'],
				'collect_price'			=> $result['collect_price'],
				'hide'					=> $result['hide'],
				'status_id'				=> $result['status_id'],
				'payment_status'		=> $result['payment_status'],
				'customer_ic' 			=> $result['customer_ic'],
				'customer_name'   		=> $result['customer_name'],
				'doctor_name'			=> $result['doctor_name'],
				'invoice'				=> $result['invoice'],
				'invoice_date'			=> $result['invoice_date'],
				'medicine_total' 		=> $this->currency->format($result['medical_total'], $this->config->get('config_currency')),
				'medical_total'  		=> $this->currency->format($result['medicine_total1'] + $result['medicine_total2'], $this->config->get('config_currency')),
				'pos_total' 			=> $this->currency->format($result['pos_total'], $this->config->get('config_currency')),
				'clinicalsale_consultation' => $this->currency->format($result['clinicalsale_consultation'], $this->config->get('config_currency')),
				'payment_total'			=> $this->currency->format($result['payment_total'], $this->config->get('config_currency')),
				'info'					=> $this->url->link('herbal/new_herbal/getInfo', 'user_token=' . $this->session->data['user_token'].'&herbal_id='. $result['clinical_sale_id'] , true),
				'view' 					=> $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'].'&filter_transaction_start='. $result['invoice_prefix'] .'&filter_transaction_end='. $result['invoice_prefix'] .'&form_transaction=1' , true),
				

			);
		}
		$pos_total = 0;
		$total_medical_total = 0;
		$total_medicine_total = 0;
		
		$payment_total = 0;
		$clinicalsale_consultation = 0;

		foreach($total as $result){
			$pos_total += $result['pos_total'];
			$total_medicine_total += $result['medical_total'];
			$total_medical_total += $result['medicine_total1'] + $result['medicine_total2'];
			$clinicalsale_consultation += $result['clinicalsale_consultation'];
			$payment_total += $result['payment_total'];

		}

		$data['totals'] = array(
			'pos_total'			=> $this->currency->format($pos_total, $this->config->get('config_currency')),
			'total_medicine_total'	=> $this->currency->format($total_medicine_total, $this->config->get('config_currency')),
			'total_medical_total'	=> $this->currency->format($total_medical_total, $this->config->get('config_currency')),
			'clinicalsale_consultation'		=> $this->currency->format($clinicalsale_consultation, $this->config->get('config_currency')),
			'payment_total'		=> $this->currency->format($payment_total, $this->config->get('config_currency')),

		);

		

		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		//rebuild querystring for sorting
		$querystringforsort = '';
		

		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$querystringforsort .= '&filter_invoice_date_start=' . $this->request->get['filter_invoice_date_start'];
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$querystringforsort .= '&filter_invoice_date_end=' . $this->request->get['filter_invoice_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$querystringforsort .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$querystringforsort .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$querystringforsort .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_collect_consultation'])) {
			$querystringforsort .= '&filter_collect_consultation=' . $this->request->get['filter_collect_consultation'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$querystringforsort .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['filter_hide'])) {
			$querystringforsort .= '&filter_hide=' . $this->request->get['filter_hide'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$querystringforsort .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$querystringforsort .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$querystringforsort .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}



		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");


		$data['sort_pos_total'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=pos_total' . $querystringforsort, true);
		$data['sort_med_consultation'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=med_consultation' . $querystringforsort, true);
		$data['sort_collect_price'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=collect_price' . $querystringforsort, true);
		$data['sort_hide'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=hide' . $querystringforsort, true);
		$data['sort_payment_status'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_status' . $querystringforsort, true);
		$data['sort_status_id'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=status_id' . $querystringforsort, true);
		$data['sort_invoice'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice' . $querystringforsort, true);
		$data['sort_invoice_date'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_date' . $querystringforsort, true);
		$data['sort_date_added'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=sales_date' . $querystringforsort, true);
		$data['sort_invoice_prefix'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
		$data['sort_order_invoice_prefix'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=order_invoice_prefix' . $querystringforsort, true);
		$data['sort_customer_ic'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_ic' . $querystringforsort, true);
		$data['sort_customer_name'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $querystringforsort, true);
		$data['sort_doctor_name'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=doctor_name' . $querystringforsort, true);
		$data['sort_subtotal'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		$data['sort_d_subtotal'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=d_subtotal' . $querystringforsort, true);
		$data['sort_d_tax'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=d_tax' . $querystringforsort, true);
		$data['sort_d_total'] = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&sort=d_total' . $querystringforsort, true);

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$url .= '&filter_invoice_date_start=' . $this->request->get['filter_invoice_date_start'];
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$url .= '&filter_invoice_date_end=' . $this->request->get['filter_invoice_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}

		if (isset($this->request->get['filter_collect_consultation'])) {
			$url .= '&filter_collect_consultation=' . $this->request->get['filter_collect_consultation'];
		}

		if (isset($this->request->get['filter_hide'])) {
			$url .= '&filter_hide=' . $this->request->get['filter_hide'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $total_transaction;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/herbalremedies_by_transaction')){
			$data['user_modify'] = true;
		}


		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_invoice_date_start'] = $filter_invoice_date_start;
		$data['filter_invoice_date_end'] = $filter_invoice_date_end;
		$data['filter_transaction_start'] = $filter_transaction_start;
		$data['filter_transaction_end'] = $filter_transaction_end;
		$data['filter_collect_consultation'] = $filter_collect_consultation;
		$data['filter_hide'] = $filter_hide;
		$data['filter_doctor_name'] = explode(',',$filter_doctor_name);
		$data['filter_customer_card'] = $filter_customer_card;
		$data['filter_customer_name'] = $filter_customer_name;
		$data['filter_payment_status'] = explode(',',$filter_payment_status);
		$data['filter_payment_method'] = explode(',',$filter_payment_method);
		$data['filter_store_id'] = explode(',',$filter_store_id);
		$data['filter_order_status_id'] = explode(',',$filter_order_status_id);
		$data['doctors'] = $this->model_report_herbalremedies->getdoctorlist();
		$data['collectconsultations'] = $this->model_report_herbalremedies->getcollectconsultation();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


		$this->response->setOutput($this->load->view('report/herbalremedies_by_transaction', $data));
	}

	public function exportExcel(){

		$this->load->model('report/herbalremedies');
		$this->load->language('report/herbalremedies_by_transaction');

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		if (isset($this->request->get['filter_invoice_date_start'])) {
			$filter_invoice_date_start = $this->request->get['filter_invoice_date_start'];
		} else {
			$filter_invoice_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_invoice_date_end'])) {
			$filter_invoice_date_end = $this->request->get['filter_invoice_date_end'];
		} else {
			$filter_invoice_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = 5;
		}

		if (isset($this->request->get['filter_hide'])) {
			$filter_hide = $this->request->get['filter_hide'];
		} else {
			$filter_hide = '';
		}

		if (isset($this->request->get['filter_collect_consultation'])) {
			$filter_collect_consultation = $this->request->get['filter_collect_consultation'];
		} else {
			$filter_collect_consultation = '';
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}
		if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 5;
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_date';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		//** filter data
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_invoice_date_start'	=> $filter_invoice_date_start,
			'filter_invoice_date_end'	=> $filter_invoice_date_end,
			'filter_transaction_start' 	=> $filter_transaction_start,
			'filter_transaction_end' 	=> $filter_transaction_end,
			'filter_customer_card' 		=> $filter_customer_card,
			'filter_customer_name' 		=> $filter_customer_name,
			'filter_payment_status' 	=> $filter_payment_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_collect_consultation'=>$filter_collect_consultation,
			'filter_hide'				=> $filter_hide,
			'filter_doctor_name' 		=> $filter_doctor_name,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$results = $this->model_report_herbalremedies->getTotalHerbalremediesByTransaction($filter_data);
		$total = $this->model_report_herbalremedies->getTotalHerbalremediesByTransaction($filter_data);

		$table_collection = array();

	

		foreach ($results as $result) {
			
		if($result['collect_price'] == 0){
			$text=$this->language->get('text_no');
		}else{
			$text=$this->language->get('text_yes');
		}
		if($result['payment_status'] == 5 ){
			$text_payment_status=$this->language->get('text_complete');
		}else{
			$text_payment_status=$this->language->get('text_not_paid');
		}
		if($result['status_id'] == 5){
			$text_status_id=$this->language->get('text_complete');
		}else if($result['status_id'] == 1){
			$text_status_id=$this->language->get('text_pending');
		}else if($result['status_id'] == 7){
			$text_status_id=$this->language->get('text_canceled');
		}
		if($result['hide'] == 0){
			$hide=$this->language->get('text_no');
		}else{
			$hide=$this->language->get('text_yes');
		}
			$table_collection[] = array(
				'invoice_date'			=> $result['invoice_date'],
				'invoice'				=> $result['invoice'],
				'payment_status'		=> $text_payment_status,
				'sales_date'   			=> date($this->language->get('date_format_short'), strtotime($result['sales_date'])),
				'invoice_prefix' 		=> $result['invoice_prefix'],
				'status_id'				=> $text_status_id,
				'doctor_name'			=> $result['doctor_name'],
				'customer_name'   		=> $result['customer_name'],
				'customer_ic' 			=> $result['customer_ic'],
				'medicine_total' 		=> $this->currency->format($result['medical_total'], $this->config->get('config_currency')),
				'medical_total'  		=> $this->currency->format($result['medicine_total1'] + $result['medicine_total2'], $this->config->get('config_currency')),
				'collect_price'			=> $text,
				'clinicalsale_consultation' => $this->currency->format($result['clinicalsale_consultation'], $this->config->get('config_currency')),
				'payment_total'				=> $this->currency->format($result['payment_total'], $this->config->get('config_currency')),
				
				'hide'					=> $hide,

			);
		}
		

		$pos_total = 0;
		$total_subtotal = 0;
		
		$total_medical_total = 0;
		$total_medicine_total = 0;
		$payment_total = 0;
		$clinicalsale_consultation = 0;

		foreach($total as $result){
			$pos_total += $result['pos_total'];
			$total_subtotal += $result['subtotal'];
			$total_medicine_total += $result['medical_total'];
			$total_medical_total += $result['medicine_total1'] + $result['medicine_total2'];
			$clinicalsale_consultation += $result['clinicalsale_consultation'];
			$payment_total += $result['payment_total'];

		}

		$table_collection[] = array(
			'', '', '', '', '','','','','',
			
			$total_medicine_total,
			$total_medical_total, 
			'',
			$clinicalsale_consultation,
			$payment_total, 
			''
		);

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		

		$table[] = array(); // add a space

		$table_header = array(//table headers
			$this->language->get('column_invoice_date'),
			$this->language->get('column_invoice'),
			$this->language->get('column_payment_status'),
			$this->language->get('column_date'),
			$this->language->get('column_transaction_no'),
			$this->language->get('column_status'),
			$this->language->get('column_doctor_name'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_customer_ic'),
			$this->language->get('column_medicine_total'),
			$this->language->get('column_total'),
			$this->language->get('column_collect_consultation'),
			$this->language->get('column_consultation_subtotal'),
			$this->language->get('column_payment_total'),
			$this->language->get('column_hide')


		);
		$table[] = $table_header;//add header to table

		$total_row = 0;

		$table_data = $table_collection;
		$row;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table

			$total_row ++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("M" . ($header_index_row + 1) . ":M" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("N" . ($header_index_row + 1) . ":N" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("O" . ($header_index_row + 1) . ":O" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("P" . ($header_index_row + 1) . ":P" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("Q" . ($header_index_row + 1) . ":Q" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("R" . ($header_index_row + 1) . ":R" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);





		$textformat_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style);// top

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
