<?php
class ControllerReportCustomerOrder extends Controller {
	public function index() {
		$this->load->language('report/customer_order');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = [];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$filter_customer_ic = $this->request->get['filter_customer_ic'];
		} else {
			$filter_customer_ic = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = NULL;
		}

		if (!empty($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] == '*'){
				$filter_store_id = '';
			} else {
				$filter_store_id = $this->request->get['filter_store_id'];
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/customer_order/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['export_excel_details'] = $this->url->link('report/customer_order/exportExcelDetails', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/customer');

		$data['customers'] = array();

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_order_status_id' => $filter_order_status_id,
			'filter_customer_card'	 => $filter_customer_card,
			'filter_customer_name'	 => $filter_customer_name,
			'filter_customer_ic'	 => $filter_customer_ic,
			'filter_gender'			 => $filter_gender,
			'filter_store_id'		 => $filter_store_id,
			'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  => $this->config->get('config_limit_admin')
		);

		$customer_total = $this->model_report_customer->getTotalOrders($filter_data);

		$results = $this->model_report_customer->getOrders($filter_data);

		foreach ($results as $result) {

			$gender = '';

			switch($result['gender']){
				case 1:
					$gender = $this->language->get('text_male');
					break;
				case 2:
					$gender = $this->language->get('text_female');
					break;
			}

			$data['customers'][] = array(
				'customer_ic'		=> $result['customer_ic'],
				'customer_card'     => $result['customer_card'],
				'customer_name'     => $result['customer_name'],
				'gender'			=> $gender,
				'total_order' 		=> $result['total_order'],
				'subtotal'         	=> $this->currency->format($result['subtotal'], $this->config->get('config_currency')),
				'tax'         		=> $this->currency->format($result['tax'], $this->config->get('config_currency')),
				'rounding'         	=> $this->currency->format($result['rounding'], $this->config->get('config_currency')),
				'shipping'         	=> $this->currency->format($result['shipping'], $this->config->get('config_currency')),
				'total'         	=> $this->currency->format($result['total'], $this->config->get('config_currency')),
				'view'           	=> $this->url->link('report/customer_order/info', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true)
			);
		}

		$data['user_token'] = $this->session->data['user_token'];

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		$pagination = new Pagination();
		$pagination->total = $customer_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($customer_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($customer_total - $this->config->get('config_limit_admin'))) ? $customer_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $customer_total, ceil($customer_total / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		
		if (!empty($filter_order_status_id)) {
			$data['filter_order_status_id'] = explode(',',$filter_order_status_id);
		} else {
			$data['filter_order_status_id'] = [];
		}

		$data['filter_customer_name'] = $filter_customer_name;
		$data['filter_customer_card'] = $filter_customer_card;
		$data['filter_customer_ic'] = $filter_customer_ic;
		$data['filter_gender'] = $filter_gender;
		$data['filter_store_id'] = $filter_store_id;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/customer_order', $data));
	}

	public function exportExcel(){

		$this->load->model('report/customer');
		$this->load->language('report/customer_order');

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = [];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$filter_customer_ic = $this->request->get['filter_customer_ic'];
		} else {
			$filter_customer_ic = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = NULL;
		}

		if (!empty($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] == '*'){
				$filter_store_id = '';
			} else {
				$filter_store_id = $this->request->get['filter_store_id'];
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_order_status_id' => $filter_order_status_id,
			'filter_customer_card'	 => $filter_customer_card,
			'filter_customer_name'	 => $filter_customer_name,
			'filter_customer_ic'	 => $filter_customer_ic,
			'filter_gender'			 => $filter_gender,
			'filter_store_id'		 => $filter_store_id
		);

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$results = $this->model_report_customer->getOrders($filter_data);

		$table_collection = array();




		foreach ($results as $result) {

			$gender = '';

			switch($result['gender']){
				case 1:
					$gender = $this->language->get('text_male');
					break;
				case 2:
					$gender = $this->language->get('text_female');
					break;
			}

			$table_collection[] = array(
				'customer_card'       => $result['customer_card'],
				'customer_ic'	=> $result['customer_ic'],
				'customer_name'          => $result['customer_name'],
				'gender'		=> $gender,
				'total_order' => $result['total_order'],
				'tax'         => $this->currency->format($result['tax'], $this->config->get('config_currency'), '', false),
				'total'         => $this->currency->format($result['total'], $this->config->get('config_currency'), '', false)
			);
		}

		$table = array();
		/*
		$table[] = array("Total Herbal Remedies" 	, '');
		$table[] = array("Total Service Form" 		, '');
		$table[] = array("Total Product Form POS" 	, '');
		$table[] = array("Total Subtotal" 			,'');
		$table[] = array("Total GST" 				, '');
		$table[] = array("Total" 					, '');

		$table[] = array(); // add a space
		*/

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

		$table[] = array(); // add a space

		$table_header = array(//table headers
			$this->language->get('column_customer_ic'),
			$this->language->get('column_customer_card'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_gender'),
			$this->language->get('column_orders'),
			$this->language->get('column_tax'),
			$this->language->get('column_total')
		);
		$table[] = $table_header;//add header to table

		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$product_id_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

		//debug test
		//$table = array("one", "two", "three");

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function exportExcelDetails() {
		$this->load->model('report/customer');
		$this->load->language('report/customer_order');

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = [];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$filter_customer_ic = $this->request->get['filter_customer_ic'];
		} else {
			$filter_customer_ic = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = NULL;
		}

		if (!empty($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] == '*'){
				$filter_store_id = '';
			} else {
				$filter_store_id = $this->request->get['filter_store_id'];
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_order_status_id' => $filter_order_status_id,
			'filter_customer_card'	 => $filter_customer_card,
			'filter_customer_name'	 => $filter_customer_name,
			'filter_customer_ic'	 => $filter_customer_ic,
			'filter_gender'			 => $filter_gender,
			'filter_store_id'		 => $filter_store_id
		);

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$results = $this->model_report_customer->getOrderDetails($filter_data);

		$table_collection = array();

		foreach ($results as $result) {
			$table_collection[] = array(
				'order_id'       		=> $result['order_id'],
				'invoice_prefix'       	=> $result['invoice_prefix'],
				'date_added'			=> date('Y-m-d', strtotime($result['date_added'])),
				'month_added'			=> date('F Y', strtotime($result['date_added'])),
				'customer_ic'			=> $result['customer_ic'],
				'customer_card'			=> $result['customer_card'],
				'customer_name'         => $result['customer_name'],
				'payment_zone' 			=> $result['payment_zone'],
				'product_name' 			=> $result['product_name'],
				'purchased_quantity'	=> $result['purchased_quantity'],
				'amount'      			=> $this->currency->format($result['product_total_amount'], $this->config->get('config_currency'), '', false),
				'order_status'			=> $result['order_status']
			);
		}

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

		$table[] = array(); // add a space

		$table_header = array(//table headers
			$this->language->get('column_order_id'),
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_date_added'),
			$this->language->get('column_month_added'),
			$this->language->get('column_customer_ic'),
			$this->language->get('column_customer_card'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_payment_zone'),
			$this->language->get('column_product_name'),
			$this->language->get('column_purchased_quantity'),
			$this->language->get('column_total'),
			$this->language->get('column_order_status')
		);
		$table[] = $table_header;//add header to table

		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$product_id_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

		//debug test
		//$table = array("one", "two", "three");

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function info(){
		$this->load->language('report/customer_order');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('report/customer');

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = [];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$filter_customer_card = $this->request->get['filter_customer_card'];
		} else {
			$filter_customer_card = '';
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$filter_customer_ic = $this->request->get['filter_customer_ic'];
		} else {
			$filter_customer_ic = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = NULL;
		}

		if (!empty($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] == '*'){
				$filter_store_id = '';
			} else {
				$filter_store_id = $this->request->get['filter_store_id'];
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$orders = [];
		$data['orders'] = [];
		$total_orders = 0;
		$total_subtotal = 0;
		$total_tax = 0;
		$total_rounding = 0;
		$total_shipping = 0;
		$grand_total = 0;

		if(isset($this->request->get['customer_id'])){
			$customer_id = $this->request->get['customer_id'];

			$filter_data = [
				'filter_date_start'			=> $filter_date_start,
				'filter_date_end'			=> $filter_date_end,
				'filter_store_id'			=> $filter_store_id,
				'filter_order_status_id'	=> $filter_order_status_id
			];

			$customer_info = $this->model_report_customer->get_customer($customer_id);
			$customer_orders = $this->model_report_customer->getCustomerOrders($customer_id, $filter_data);

			if(!empty($customer_info)){
				$data['gender'] = ($customer_info['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');
				$data['customer_name'] = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
				$data['customer_ic'] = $customer_info['customer_ic'];
				$data['customer_card'] = $customer_info['customer_card'];

				if(!empty($customer_orders)){
					foreach($customer_orders as $order){
						$subtotal = $this->model_report_customer->get_order_total('sub_total', $order['order_id']);
						$subtotal_value = !empty($subtotal) ? $subtotal['value'] : 0;

						$shipping = $this->model_report_customer->get_order_total('shipping', $order['order_id']);
						$shipping_value = !empty($shipping) ? $shipping['value'] : 0;

						$tax = $this->model_report_customer->get_order_total('tax', $order['order_id']);
						$tax_value = !empty($tax) ? $tax['value'] : 0;

						$rounding = $this->model_report_customer->get_order_total('rounding', $order['order_id']);
						$rounding_value = !empty($rounding) ? $rounding['value'] : 0;

						$total = $this->model_report_customer->get_order_total('total', $order['order_id']);
						$total_value = !empty($total) ? $total['value'] : 0;

						$orders[] = [
							'order_id'			=> $order['order_id'],
							'invoice_prefix'	=> $order['invoice_prefix'],
							'date_added'		=> date($this->language->get('date_format_short'), strtotime($order['date_added'])),
							'order_status'		=> $order['order_status'],
							'subtotal'			=> $subtotal_value,
							'tax'				=> $tax_value,
							'shipping'			=> $shipping_value,
							'rounding'			=> $rounding_value,
							'total'				=> $total_value,
							'order_link'		=> $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'], true)
						];

						$total_subtotal += $subtotal_value;
						$total_tax += $tax_value;
						$total_rounding += $rounding_value;
						$total_shipping += $shipping_value;
						$grand_total += $total_value;
					}

					$data['orders'] = $orders;

					foreach($data['orders'] as $index => $order){
						$data['orders'][$index]['subtotal'] = $this->currency->format($order['subtotal'], $this->config->get('config_currency'));
						$data['orders'][$index]['tax'] = $this->currency->format($order['tax'], $this->config->get('config_currency'));
						$data['orders'][$index]['shipping'] = $this->currency->format($order['shipping'], $this->config->get('config_currency'));
						$data['orders'][$index]['rounding'] = $this->currency->format($order['rounding'], $this->config->get('config_currency'));
						$data['orders'][$index]['total'] = $this->currency->format($order['total'], $this->config->get('config_currency'));
					}
				}

				$data['total_subtotal'] = $this->currency->format($total_subtotal, $this->config->get('config_currency'));
				$data['total_tax'] = $this->currency->format($total_tax, $this->config->get('config_currency'));
				$data['total_shipping'] = $this->currency->format($total_shipping, $this->config->get('config_currency'));
				$data['total_rounding'] = $this->currency->format($total_rounding, $this->config->get('config_currency'));
				$data['total_grandtotal'] = $this->currency->format($grand_total, $this->config->get('config_currency'));
			} else{
				$this->response->redirect($this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url, true));
			}
		} else{
			$this->response->redirect($this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$total_orders = count($data['orders']);

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_customer_card'])) {
			$url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		$data['cancel'] = $this->url->link('report/customer_order', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$num_of_result_pages = ($total_orders > 0) ? 1 : 0;
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_orders) ? (($page - 1) * $total_orders) + 1 : 0, ((($page - 1) * $total_orders) > ($total_orders - $total_orders)) ? $total_orders : ((($page - 1) * $total_orders) + $total_orders), $total_orders, $num_of_result_pages);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/customer_order_info', $data));
	}
}
?>