<?php
class ControllerReportCouponRedemptionByStock extends Controller {
	public function index() {
		$this->load->language('report/coupon');
		$this->load->language('report/coupon');

		$this->document->setTitle($this->language->get('heading_title'));

		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('report/coupon_redemption');		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}


		if (isset($this->request->get['filter_customer_ic'])) {
			$filter_customer_ic = $this->request->get['filter_customer_ic'];
		} else {
			$filter_customer_ic = '';
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_telephone'])) {
			$filter_telephone = $this->request->get['filter_telephone'];
		} else {
			$filter_telephone = '';
		}

		if (isset($this->request->get['filter_gender'])) {
			$filter_gender = $this->request->get['filter_gender'];
		} else {
			$filter_gender = null;
		}

		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}

		if (isset($this->request->get['filter_product_id'])) {
			$filter_product_id = $this->request->get['filter_product_id'];
		} else {
			$filter_product_id = '';
		}

		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}

		if (isset($this->request->get['filter_product_model'])) {
			$filter_product_model = $this->request->get['filter_product_model'];
		} else {
			$filter_product_model = '';
		}

		if (isset($this->request->get['filter_coupon_id'])) {
			$filter_coupon_id = $this->request->get['filter_coupon_id'];
		} else {
			$filter_coupon_id = '';
		}

		if (isset($this->request->get['filter_coupon_redemption_history_id'])) {
			$filter_coupon_redemption_history_id = $this->request->get['filter_coupon_redemption_history_id'];
		} else {
			$filter_coupon_redemption_history_id = '';
		}

		if (isset($this->request->get['filter_customer_id'])) {

		}

		if (isset($this->request->get['filter_coupon_name'])) {
			$filter_coupon_name = $this->request->get['filter_coupon_name'];
		} else {
			$filter_coupon_name = '';
		}

		if (isset($this->request->get['filter_coupon_code'])) {
			$filter_coupon_code = $this->request->get['filter_coupon_code'];
		} else {
			$filter_coupon_code = '';
		}

		if (isset($this->request->get['filter_coupon_status'])) {
			$filter_coupon_status = $this->request->get['filter_coupon_status'];
		} else {
			$filter_coupon_status = null;
		}

		if (isset($this->request->get['filter_coupon_redemption_status'])) {
			$filter_coupon_redemption_status = $this->request->get['filter_coupon_redemption_status'];
		} else {
			$filter_coupon_redemption_status = null;
		}
		
		if ($data['user_view'] == 1) {
			if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = null;
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_telephone'])) {
			$url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_model'])) {
			$url .= '&filter_product_model=' . $this->request->get['filter_product_model'];
		}

		if (isset($this->request->get['filter_coupon_name'])) {
			$url .= '&filter_coupon_name=' . $this->request->get['filter_coupon_name'];
		} 

		if (isset($this->request->get['filter_coupon_redemption_history_id'])) {
			$url .= '&filter_coupon_redemption_history_id=' . $this->request->get['filter_coupon_redemption_history_id'];
		} 

		if (isset($this->request->get['filter_coupon_id'])) {
			$url .= '&filter_coupon_id=' . $this->request->get['filter_coupon_id'];
		} 

		if (isset($this->request->get['filter_coupon_code'])) {
			$url .= '&filter_coupon_code=' . $this->request->get['filter_coupon_code'];
		}

		if (isset($this->request->get['filter_coupon_status'])) {
			$url .= '&filter_coupon_status=' . $this->request->get['filter_coupon_status'];
		}

		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . $this->request->get['filter_product_id'];
		}

		if (isset($this->request->get['filter_coupon_redemption_status'])) {
			$url .= '&filter_coupon_redemption_status=' .  $this->request->get['filter_coupon_redemption_status'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('redemption_title'),
			'href' => $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		//urls
		$data['export_excel'] = $this->url->link('module/coupon_redemption_by_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 		=> $filter_date_start,
			'filter_date_end' 			=> $filter_date_end,
			'filter_customer_ic'		=> $filter_customer_ic,
			'filter_telephone'			=> $filter_telephone,
			'filter_gender'				=> $filter_gender,
			'filter_customer_name'		=> $filter_customer_name,
			'filter_coupon_id'			=> $filter_coupon_id,
			'filter_coupon_name'		=> $filter_coupon_name,
			'filter_coupon_code'		=> $filter_coupon_code,
			'filter_coupon_status'		=> $filter_coupon_status,
			'filter_coupon_redemption_status' => $filter_coupon_redemption_status,
			'filter_product_id'			=> $filter_product_id,
			'filter_product_code'		=> $filter_product_code,
			'filter_product_name'		=> $filter_product_name,
			'filter_product_model'		=> $filter_product_model,
			'filter_store_id'			=> $filter_store_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start' 					=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 					=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_product_id']		= $filter_product_id;
		$data['filter_date_start'] 		= $filter_date_start;
		$data['filter_date_end'] 		= $filter_date_end;
		$data['filter_customer_ic']		= $filter_customer_ic;
		$data['filter_telephone']		= $filter_telephone;
		$data['filter_customer_name']	= $filter_customer_name;
		$data['filter_gender']			= $filter_gender;
		$data['filter_coupon_name']		= $filter_coupon_name;
		$data['filter_coupon_id']		= $filter_coupon_id;
		$data['filter_coupon_code']		= $filter_coupon_code;
		$data['filter_coupon_status']	= $filter_coupon_status;
		$data['filter_coupon_redemption_status'] = $filter_coupon_redemption_status;
		$data['filter_product_code']	= $filter_product_code;
		$data['filter_product_name']	= $filter_product_name;
		$data['filter_product_model']	= $filter_product_model;
		$data['filter_store_id']		= $filter_store_id;

		//**data
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$data['user_token'] = $this->session->data['user_token'];
		
		//listing data
		$this->load->library('weight');
		$this->weight = new Weight($this->registry);
		
		$data['sales'] = array();
		$sales = $this->model_report_coupon_redemption->getCouponRedemptionByStock($filter_data);

		$final_quantity = 0;
		$customer_count = 0;
		$male_count 	= 0;
		$female_count	= 0;
		$gender_empty	= 0;
		$redemption_success_count = 0;
		$redemption_cancel_count  = 0;
		$redemption_empty_count   = 0;
		
		foreach($sales as $sale) {
			if (!empty($sale['status'])) {
				if ($sale['status'] == 1) {
					$redemption_status_id = $sale['status'];
					$redemption_status = '<label class="label label-success">' . $this->language->get('text_redeem_success') . '</label>';
					$redemption_success_count++;
				} else if ($sale['status'] == 7) {
					$redemption_status_id = $sale['status'];
					$redemption_status = '<label class="label label-danger">' . $this->language->get('text_cancel') . '</label>';
					$redemption_cancel_count++;
				} else {
					$redemption_status_id = 0;
					$redemption_status = '-';
					$redemption_empty_count++;
				}
			} else {
				$status = '-' ;
				$redemption_empty_count++;
			}

			if (!empty($sale['coupon_id'])) {
				$coupon_info = $this->model_report_coupon_redemption->getCouponInfo($sale['coupon_id']);
				if (!empty($coupon_info)) {
					if (!empty($coupon_info['name'])) {
						$coupon_name = $coupon_info['name'];
					} else {
						$coupon_name = '';
					}

					if (!empty($coupon_info['code'])) {
						$coupon_code = $coupon_info['code'];
					} else {
						$coupon_code = '';
					}

					if (!empty($coupon_info['coupon_id'])) {
						$coupon_id = $coupon_info['coupon_id'];
					} else {
						$coupon_id = '';
					}
				} else {
					$coupon_name = '';
					$coupon_code = '';
					$coupon_id 	 = '';
				}
			} else {
				$coupon_id 	 = '';
				$coupon_name = '';
				$coupon_code = '';
			}

			if (!empty($sale['quantity'])) {
				if ($sale['status'])
				$quantity = $sale['quantity'] ;
			} else {
				$quantity = 0 ;
			}

			$this->load->library('weight');
			$this->weight = new Weight($this->registry);

			if (!empty($sale['products'])) {
				$products = unserialize($sale['products']);

				if (!empty($products['weight'])) {
					$data['weight'][] = $products['weight'];
					$weight = $products['weight'];
				} else {
					$weight = 0.00 ;
				}

				if (!empty($products['weight_class_id'])) {
					$weight_class_id = $products['weight_class_id'];
				} else {
					$weight_class_id = '';
				}

				$total_quantity = $quantity * $weight ;
				$data['total_quantitys'][] = $total_quantity;
				$total_quantity = number_format($this->weight->convert($total_quantity, $weight_class_id, $this->config->get('config_weight_class_id')),2);

			} else {
				$total_quantity = 0 ;
			}

			$final_quantity += $total_quantity;

			if (!empty($sale['product_id'])) {
				$product_info = $this->model_report_coupon_redemption->getProductInfo($sale['product_id']);
				if (!empty($product_info)) {
					if (!empty($product_info['name'])) {
						$product_name = $product_info['name'];
					} else {
						$product_name = '';
					}

					if (!empty($product_info['code'])) {
						$product_code = $product_info['code'];
					} else {
						$product_code = '';
					}

					if (!empty($product_info['model'])) {
						$product_model = $product_info['model'];
					} else {
						$product_model = '';
					}

					if (!empty($product_info['product_id'])) {
						$product_id = $product_info['product_id'];
					} else {
						$product_id = '';
					}
				} else {
					$product_name 	= '';
					$product_model 	= '';
					$product_code 	= '';
					$product_id   	= '';
				}
			} else {
				$product_name 	= '';
					$product_model 	= '';
					$product_code 	= '';
					$product_id   	= '';
			}


			if (!empty($sale['customer_id'])) {
				$customer_info = $this->model_report_coupon_redemption->getCustomerInfo($sale['customer_id']);
				if (!empty($customer_info['customer_id'])) {
					if (!empty($customer_info['customer_id'])) {
						$customer_id = $customer_info['customer_id'];
					} else {
						$customer_id = '';
					}

					if (!empty($customer_info['telephone'])) {
						$telephone = $customer_info['telephone'];
					} else {
						$telephone = '';
					}

					if (!empty($customer_info['customer_ic'])) {
						$customer_ic = $customer_info['customer_ic'];
					} else {
						$customer_ic = '';
					}

					if (!empty($customer_info['name'])) {
						$customer_name = $customer_info['name'];
					} else {
						$customer_name = '-' ;
					}

					if (!empty($customer_info['gender'])) {
						if ($customer_info['gender'] == 1) {
							$gender = $this->language->get('text_male');
							$male_count++;
						} else if ($customer_info['gender'] == 2) {
							$gender = $this->language->get('text_female');
							$female_count++;
						} else {
							$gender = '-';
							$gender_empty++;
						}
					} else {
						$gender = '-';
						$gender_empty++;
					}

					if (!empty($customer_info['customer_card'])) {
						$customer_card = $customer_info['customer_card'];
					} else {
						$customer_card = '';
					}
				} else {
					$customer_name = '';
					$telephone 	   = '';
					$customer_ic   = '';
					$gender 	   = '';
					$customer_card = '';
					$customer_id   = '';
				}
			} else {
				$customer_name = '';
				$telephone 	   = '';
				$customer_ic   = '';
				$gender 	   = '';
				$customer_card = '';
				$customer_id   = '';
			}

			if (!empty($sale['store_id'])) {
				$store_id 	= $sale['store_id'];
				$store_info = $this->model_report_coupon_redemption->getStoreInfo($sale['store_id']);
				if (!empty($store_info['name'])) {
					$store_name = $store_info['name'];
				} else {
					$store_name = '-' ;
				}
			} else {
				$store_id   = 0; 
				$store_name = $this->config->get('config_name') . $this->language->get('text_default') ;
			}

			if (!empty($sale['date_added'])) {
				$date_added = $sale['date_added'];
			} else {
				$date_added = '0000-00000';
			}


			if (!empty($sale['coupon_redemption_history_id'])) {
				$coupon_redemption_history_id = $sale['coupon_redemption_history_id'];
			} else {
				$coupon_redemption_history_id = '';
			}

			$customer_count++ ;

			$data['sales'][] = array(
				'coupon_redemption_history_id' => $coupon_redemption_history_id,
				'coupon_id'					=> $coupon_id,
				'coupon_name' 				=> $coupon_name,
				'coupon_code' 				=> $coupon_code,
				'coupon_redemption_status' 	=> $redemption_status,
				'customer_name'				=> $customer_name,
				'gender'					=> $gender,
				'telephone'					=> $telephone,
				'customer_id'				=> $customer_id,
				'customer_ic'				=> $customer_ic,
				'customer_card'				=> $customer_card,
				'product_id' 				=> $product_id,
				'product_code'				=> $product_code,
				'store_id'					=> $store_id,
				'store_name'				=> $store_name,
				'product_model'				=> $product_model,
				'product_name'				=> $product_name,
				'date_added'				=> $date_added,
				'quantity'					=> $total_quantity
			);
		}

		$data['total_quantity'] = number_format($final_quantity,2);

		$querystringforsort = '';
		if (isset($this->request->get['filter_customer_ic'])) {
			$querystringforsort .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_product_id'])) {
			$querystringforsort .= '&filter_product_id=' . $this->request->get['filter_product_id'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$querystringforsort .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_telephone'])) {
			$querystringforsort .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$querystringforsort .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_model'])) {
			$querystringforsort .= '&filter_product_model=' . $this->request->get['filter_product_model'];
		}

		if (isset($this->request->get['filter_coupon_id'])) {
			$url .= '&filter_coupon_id=' . $this->request->get['filter_coupon_id'];
		} 

		if (isset($this->request->get['filter_coupon_name'])) {
			$querystringforsort .= '&filter_coupon_name=' . $this->request->get['filter_coupon_name'];
		} 

		if (isset($this->request->get['filter_coupon_code'])) {
			$querystringforsort .= '&filter_coupon_code=' . $this->request->get['filter_coupon_code'];
		}

		if (isset($this->request->get['filter_coupon_status'])) {
			$querystringforsort .= '&filter_coupon_status=' . $this->request->get['filter_coupon_status'];
		}

		if (isset($this->request->get['filter_coupon_redemption_status'])) {
			$querystringforsort .= '&filter_coupon_redemption_status=' .  $this->request->get['filter_coupon_redemption_status'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_coupon_redemption_history_id'])) {
			$querystringforsort .= '&filter_coupon_redemption_history_id=' . $this->request->get['filter_coupon_redemption_history_id'];
		} 
	
		if (isset($this->request->get['page'])) {
			$querystringforsort .= '&page=' . $this->request->get['page'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		$data['sort_coupon_id'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=co.coupon_id' . $querystringforsort, true);
		$data['sort_coupon_code'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=co.code' . $querystringforsort, true);
		$data['sort_coupon_name'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=co.name' . $querystringforsort, true);
		$data['sort_customer_name'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $querystringforsort, true);
		$data['sort_gender'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=c.gender' . $querystringforsort, true);
		$data['sort_telephone'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=c.telephone' . $querystringforsort, true);
		$data['sort_customer_ic'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $querystringforsort, true);
		$data['sort_store_id'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.store_id' . $querystringforsort, true);
		$data['sort_product_id'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.product_id' . $querystringforsort, true);
		$data['sort_product_name'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $querystringforsort, true);
		$data['sort_product_code'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=p.code' . $querystringforsort, true);
		$data['sort_product_model'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=p.model' . $querystringforsort, true);
		$data['sort_quantity'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.quantity' . $querystringforsort, true);
		$data['sort_weight'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.weight' . $querystringforsort, true);
		$data['sort_date_added'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.date_added' . $querystringforsort, true);
		$data['sort_redemption_status'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.status' . $querystringforsort, true);
		$data['sort_coupon_redemption_history_id'] = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=crh.coupon_redemption_history_id' . $querystringforsort, true);
		
		$data['text_success'] 	= $this->language->get('text_redeem_success'); 
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_customer_ic'])) {
			$url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
		}

		if (isset($this->request->get['filter_telephone'])) {
			$url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
		}

		if (isset($this->request->get['filter_gender'])) {
			$url .= '&filter_gender=' . $this->request->get['filter_gender'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_product_model'])) {
			$url .= '&filter_product_model=' . $this->request->get['filter_product_model'];
		}

		if (isset($this->request->get['filter_coupon_name'])) {
			$url .= '&filter_coupon_name=' . $this->request->get['filter_coupon_name'];
		} 

		if (isset($this->request->get['filter_coupon_code'])) {
			$url .= '&filter_coupon_code=' . $this->request->get['filter_coupon_code'];
		}

		if (isset($this->request->get['filter_coupon_status'])) {
			$url .= '&filter_coupon_status=' . $this->request->get['filter_coupon_status'];
		}

		if (isset($this->request->get['filter_coupon_redemption_status'])) {
			$url .= '&filter_coupon_redemption_status=' .  $this->request->get['filter_coupon_redemption_status'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_product_id'])) {
			$url .= '&filter_product_id=' . $this->request->get['filter_product_id'];
		}

		if (isset($this->request->get['filter_coupon_redemption_history_id'])) {
			$$url .= '&filter_coupon_redemption_history_id=' . $this->request->get['filter_coupon_redemption_history_id'];
		} 
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_coupon_redemption->getCouponRedemptionByStockTotal($filter_data);
		//$data['total_quantity'] = $this->weight->format($this->model_report_coupon_redemption->getCouponRedemptionByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		//
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/coupon_redemption_by_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] 		= $this->load->controller('common/header');
		$data['column_left'] 	= $this->load->controller('common/column_left');
		$data['footer'] 		= $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/coupon_redemption_by_stock', $data));
	}
}