<?php

class ControllerPrescriptionTreatment extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/treatment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/treatment');

        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/treatment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/treatment');


        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_treatment->addTreatment($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_description']))
                $querystring .= '&filter_description=' . $this->request->get['filter_description'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        //tracing error list
        /*
          echo "<pre>";
          print_r($this->error);
          echo "</pre>";
         */

        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/treatment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/treatment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_prescription_treatment->editTreatment($this->request->get['treatment_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_description']))
                $querystring .= '&filter_description=' . $this->request->get['filter_description'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/treatment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/treatment');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $treatment_id)
                $this->model_prescription_treatment->deleteTreatment($treatment_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/treatment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/treatment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            if (isset($this->request->post['filter_description']))
                $querystring .= '&filter_description=' . $this->request->post['filter_description'];

            $this->response->redirect($this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        $data["filter_description"] = isset($this->request->get['filter_description']) ? $this->request->get['filter_description'] : "";

        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;
        $filter_description = isset($this->request->get['filter_description']) ? $this->request->get['filter_description'] : NULL;


        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/treatment/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('prescription/treatment/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/treatment/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['treatments'] = array();

        $treatmentList = $this->model_prescription_treatment->getTreatmentList($filter_data);

        foreach ($treatmentList as $treatment) {
            $data['treatments'][] = array(
                'treatment_id' => $treatment['treatment_id'],
                'name' => $treatment['name'],
                'code' => $treatment['code'],
                'pinyin' => $treatment['pinyin'],
                'sort_order' => $treatment['sort_order'],
                'edit' => $this->url->link('prescription/treatment/edit', 'user_token=' . $this->session->data['user_token'] . '&treatment_id=' . $treatment['treatment_id'] . $querystring, true)
            );
        }

        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : NULL;
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_name'] = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);

        //rebuild querystring for pagination
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        if (isset($this->request->get['filter_description']))
            $querystring .= '&filter_description=' . $this->request->get['filter_description'];

        //pagination
        $treatment_total = $this->model_prescription_treatment->totalTreatment($filter_data);

        $pagination = new Pagination();
        $pagination->total = $treatment_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($treatment_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($treatment_total - $this->config->get('config_limit_admin'))) ? $treatment_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $treatment_total, ceil($treatment_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/treatment_list', $data));
    }

    public function openwindow() {

        $this->load->language('prescription/treatment');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/treatment');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;
        //module view data


        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;

        $data['treatments'] = array();

        $treatmentList = $this->model_prescription_treatment->getTreatmentList($filter_data);
        foreach ($treatmentList as $treatment) {
            $data['treatments'][] = array(
                'treatment_id' => $treatment['treatment_id'],
                'name' => $treatment['name'],
                'code' => $treatment['code'],
                'description' => $treatment['description'],
                'sort_order' => $treatment['sort_order'],
                'select' => $treatment['name'],
            );
        }

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/treatment_list', $data));
    }

    public function treatmentItem() {
        $json = array();

        $this->load->language('prescription/treatment');
        $this->load->model('prescription/treatment');

        $treatment_items = $this->model_prescription_treatment->getTreatmentItem($this->request->get['treatment_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');
        $json['treatment'] = array();
        if (!empty($treatment_items)) {
            foreach ($treatment_items as $item) {
                $json['treatment'][] = array(
                    'name' => $item['name'],
                    'description' => $item['description'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {

        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $descriptionMemory = array();
        if (isset($this->request->get['treatment_id'])) {
            foreach ($data['languages'] as $language) {
                $descriptionMemory[$language['language_id']] = array(
                    'name' => $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'name', false, $language['language_id']),
                    'description' => $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'description', false, $language['language_id'])
                );
            }
        }

        $data["form_memory_treatment_description"] = isset($this->request->post['treatment_description']) ? // if request post from form
                $this->request->post['treatment_description'] :
                (isset($this->request->get['treatment_id']) ? $descriptionMemory : array());

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['treatment_id']) ?
                $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'code') :
                NULL
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['treatment_id']) ?
                $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['treatment_id']) ?
                $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['treatment_id']) ?
                $this->model_prescription_treatment->getTreatmentColumn($this->request->get['treatment_id'], 'status') :
                1
                );

        $data["form_memory_treatment_items"] = isset($this->request->post['treatmentitem']) ? // if request post from form
                $this->request->post['treatmentitem'] :
                (
                isset($this->request->get['treatment_id']) ?
                $this->model_prescription_treatment->getTreatmentItemList($this->request->get['treatment_id']) :
                false
                );

        /*
          echo "<pre>";
          print_r($data["form_memory_treatment_items"]);
          echo "</pre>";
         */

        //tracing database treatment item memory
        /*
          echo "<pre>";
          print_r($this->model_prescription_treatment->getTreatmentItemList($this->request->get['treatment_id']));
          echo "</pre>";
         */

        //module data
      

        $data['text_form'] = !(isset($this->request->get['treatment_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //entry data
       

        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/treatment', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['treatment_id']))
            $querystring .= '&treatment_id=' . $this->request->get['treatment_id'];
        $action_mode = !(isset($this->request->get['treatment_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("prescription/treatment/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;
        $data['error_description'] = isset($this->error['description']) ? $this->error['description'] : NULL;
        $data['error_treatment_name'] = isset($this->error['treatment_name']) ? $this->error['treatment_name'] : NULL;
        $data['error_treatment_item_code'] = isset($this->error['diagnostic_item_code']) ? $this->error['diagnostic_item_code'] : NULL;
        $data['error_treatment_item_pinyin'] = isset($this->error['diagnostic_item_pinyin']) ? $this->error['diagnostic_item_pinyin'] : NULL;
        $data['error_treatment_item_treatment_name'] = isset($this->error['treatment_item_treatment_name']) ? $this->error['treatment_item_treatment_name'] : NULL;


        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/treatment_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }
        function validStrLen($str, $min, $max) {
            return (utf8_strlen($str) > $min && utf8_strlen($str) < $max);
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/treatment') && !$this->user->userpermission('modify', 'prescription/treatment'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general treatment description
    
        foreach ($this->request->post['treatment_description'] as $language_id => $value) {
             if (validIsNullOrEmpty($value['name']))
                $this->error['treatment_name'][$language_id] = $this->language->get('error_treatment_name');
        }

        //validate general treatment code
        $treatmentcode = $this->request->post['code'];
        if (validIsNullOrEmpty($treatmentcode))
            $this->error['name']['code'] = $this->language->get('error_treatment_code');

        $treatmentpinyin = $this->request->post['pinyin'];
        if (validIsNullOrEmpty($treatmentpinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_treatment_pinyin');

        //validate general treatment sort order
        //if(!validIsNumeric($this->request->post['sort_order']))
        //validate general treatment status
        // --- no validation
        //validate treatment item

        $treatmentitems = isset($this->request->post['treatmentitem']) ? $this->request->post['treatmentitem'] : false;
        if ($treatmentitems) {
            foreach ($treatmentitems as $diseasitempos => $treatmentitem) {
                //validate treatment item code
                $treatmentitemcode = $treatmentitem['code'];
                if (validIsNullOrEmpty($treatmentitemcode))
                    $this->error['treatment_item_code'][$diseasitempos] = $this->language->get('error_treatment_code');

                $treatmentitempinyin = $treatmentitem['pinyin'];
                if (validIsNullOrEmpty($treatmentitempinyin))
                    $this->error['treatment_item_pinyin'][$diseasitempos] = $this->language->get('error_treatment_pinyin');

                //validate general treatment name
                $treatmentitemnames = $treatmentitem['treatment_description'];
                foreach ($treatmentitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['treatment_item_description'][$language_id] = $this->language->get('error_treatment_description');
                }

                //validate general treatment description
                /*
                  $treatmentitemdescriptions = $treatmentitem['treatment_description'];
                  foreach($treatmentitemdescriptions as $language_id => $value){
                  if(!validStrLen($value['description'], 2, 255))
                  $this->error['description']['treatmentitem_' . $diseasitempos . '_description' . $language_id] = $this->language->get('error_treatment_description');
                  }
                 */
            }
        }


        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/treatment') && !$this->user->userpermission('delete', 'prescription/treatment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/treatment');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $treatmentList = $this->model_prescription_treatment->getTreatmentList($filter_data);

            foreach ($treatmentList as $row => $treatment) {
                $json[] = array(
                    'treatment_id' => $treatment['treatment_id'],
                    'name' => $treatment['name'],
                    'description' => $treatment['description'],
                    'code' => $treatment['code'],
                    'pinyin' => $treatment['pinyin']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>