<?php

class ControllerPrescriptionSymptom extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/symptom');

        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/symptom');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_symptom->addSymptom($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit() {

        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/symptom');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_prescription_symptom->editSymptom($this->request->get['symptom_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {

        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/symptom');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {

            $selected = $this->request->post['selected'];

            foreach ($selected as $symptom_id)
                $this->model_prescription_symptom->deleteSymptom($symptom_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }
        $this->getList();
    }

    public function filter() {

        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/symptom');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form

            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    protected function getList() {

        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap data

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls

        $data['filter'] = $this->url->link('prescription/symptom/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['add'] = $this->url->link('prescription/symptom/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/symptom/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;
        $data['symptoms'] = array();
        $symptomList = $this->model_prescription_symptom->getSymptomList($filter_data);

        foreach ($symptomList as $symptom) {

            $data['symptoms'][] = array(
                'symptom_id' => $symptom['symptom_id'],
                'name' => $symptom['name'],
                'code' => $symptom['code'],
                'pinyin' => $symptom['pinyin'],
                'sort_order' => $symptom['sort_order'],
                'edit' => $this->url->link('prescription/symptom/edit', 'user_token=' . $this->session->data['user_token'] . '&symptom_id=' . $symptom['symptom_id'] . $querystring, true)
            );
        }
        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : '';
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
        $data['sort_name'] = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);

        //rebuild querystring for pagination

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination

        $symptom_total = $this->model_prescription_symptom->totalSymptom($filter_data);

        $pagination = new Pagination();
        $pagination->total = $symptom_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($symptom_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($symptom_total - $this->config->get('config_limit_admin'))) ? $symptom_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $symptom_total, ceil($symptom_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/symptom_list', $data));
    }

    public function openwindow() {

        $this->load->language('prescription/symptom');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/symptom');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $data['user_token'] = $user_token;
        //module view data

        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;
        $data['symptoms'] = array();

        $symptomList = $this->model_prescription_symptom->getSymptomList($filter_data);

        foreach ($symptomList as $symptom) {

            $data['symptoms'][] = array(
                'symptom_id' => $symptom['symptom_id'],
                'name' => $symptom['name'],
                'code' => $symptom['code'],
                'sort_order' => $symptom['sort_order'],
                'select' => $symptom['name'],
            );
        }
        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/symptom_list', $data));
    }

    public function symptomItem() {

        $json = array();

        $this->load->language('prescription/symptom');
        $this->load->model('prescription/symptom');

        $symptom_items = $this->model_prescription_symptom->getSymptomItem($this->request->get['symptom_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');
        $json['symptom'] = array();

        if (!empty($symptom_items)) {

            foreach ($symptom_items as $item) {
                $json['symptom'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {

            $json['error'] = $this->language->get('error_empty');
        }
        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {

        $this->load->model('localisation/language'); //load other module model

        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();

        if (isset($this->request->get['symptom_id'])) {

            foreach ($data['languages'] as $language) {

                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_symptom->getSymptomColumn($this->request->get['symptom_id'], 'name', false, $language['language_id']));
            }
        }

        $data["form_memory_symptom_name"] = isset($this->request->post['symptom_name']) ? // if request post from form

                $this->request->post['symptom_name'] :
                (isset($this->request->get['symptom_id']) ? $nameMemory : array());

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form

                $this->request->post['code'] :
                (
                isset($this->request->get['symptom_id']) ?
                $this->model_prescription_symptom->getSymptomColumn($this->request->get['symptom_id'], 'code') :
                NULL
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form

                $this->request->post['pinyin'] :
                (
                isset($this->request->get['symptom_id']) ?
                $this->model_prescription_symptom->getSymptomColumn($this->request->get['symptom_id'], 'pinyin') :
                NULL
                );
        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['symptom_id']) ?
                $this->model_prescription_symptom->getSymptomColumn($this->request->get['symptom_id'], 'sort_order') :
                0
                );
        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['symptom_id']) ?
                $this->model_prescription_symptom->getSymptomColumn($this->request->get['symptom_id'], 'status') :
                1
                );

        $data["form_memory_symptom_items"] = isset($this->request->post['symptomitem']) ? // if request post from form

                $this->request->post['symptomitem'] :
                (
                isset($this->request->get['symptom_id']) ?
                $this->model_prescription_symptom->getSymptomItemList($this->request->get['symptom_id']) :
                false
                );

        $data['text_form'] = !(isset($this->request->get['symptom_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'], true)
        );
        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls

        $data['cancel'] = $this->url->link('prescription/symptom', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['symptom_id']))
            $querystring .= '&symptom_id=' . $this->request->get['symptom_id'];

        $action_mode = !(isset($this->request->get['symptom_id'])) ? 'add' : 'edit';

        $data['action'] = $this->url->link("prescription/symptom/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_symptom_name'] = isset($this->error['symptom_name']) ? $this->error['symptom_name'] : NULL;
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;
        $data['error_symptom_item_code'] = isset($this->error['symptom_item_code']) ? $this->error['symptom_item_code'] : NULL;
        $data['error_symptom_item_pinyin'] = isset($this->error['symptom_item_pinyin']) ? $this->error['symptom_item_pinyin'] : NULL;
        $data['error_symptom_item_symptom_name'] = isset($this->error['symptom_item_symptom_name']) ? $this->error['symptom_item_symptom_name'] : NULL;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/symptom_form', $data));
    }

    protected function validateForm() {

        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);

            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        if (!$this->user->hasPermission('modify', 'prescription/symptom') && !$this->user->userpermission('modify', 'prescription/symptom'))
            $this->error['warning'] = $this->language->get('error_permission');

        foreach ($this->request->post['symptom_name'] as $language_id => $value) {

            if (validIsNullOrEmpty($value['name']))
                $this->error['name']['name' . $language_id] = $this->language->get('error_symptom_name');
        }
        $symptomcode = $this->request->post['code'];
        if (validIsNullOrEmpty($symptomcode))
            $this->error['name']['code'] = $this->language->get('error_symptom_code');

        $symptompinyin = $this->request->post['pinyin'];

        if (validIsNullOrEmpty($symptompinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_symptom_pinyin');

        $symptomitems = isset($this->request->post['symptomitem']) ? $this->request->post['symptomitem'] : false;

        if ($symptomitems) {

            foreach ($symptomitems as $diseasitempos => $symptomitem) {

                $symptomitemcode = $symptomitem['code'];

                if (validIsNullOrEmpty($symptomitemcode))
                    $this->error['name']['symptomitem_' . $diseasitempos . '_code'] = $this->language->get('error_symptom_code');

                $symptomitempinyin = $symptomitem['pinyin'];

                if (validIsNullOrEmpty($symptomitempinyin))
                    $this->error['name']['symptomitem_' . $diseasitempos . '_pinyin'] = $this->language->get('error_symptom_pinyin');

                $symptomitemnames = $symptomitem['symptom_name'];

                foreach ($symptomitemnames as $language_id => $value) {

                    if (validIsNullOrEmpty($value['name']))
                        $this->error['name']['symptomitem_' . $diseasitempos . '_name' . $language_id] = $this->language->get('error_symptom_name');
                }
            }
        }

        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {

        if (!$this->user->hasPermission('delete', 'prescription/symptom') && !$this->user->userpermission('delete', 'prescription/symptom')) {

            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {

        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {

            $this->load->model('prescription/symptom');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $symptomList = $this->model_prescription_symptom->getSymptomList($filter_data);

            foreach ($symptomList as $row => $symptom) {
                $json[] = array(
                    'symptom_id' => $symptom['symptom_id'],
                    'name' => $symptom['name'],
                    'code' => $symptom['code'],
                    'pinyin' => $symptom['pinyin']
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>