<?php

class ControllerPrescriptionDoctorAdvice extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/doctoradvice');
        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/doctoradvice');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_doctoradvice->addDoctorAdvice($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];



            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/doctoradvice');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_prescription_doctoradvice->editDoctorAdvice($this->request->get['doctoradvice_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/doctoradvice');
        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];

            foreach ($selected as $doctoradvice_id)
                $this->model_prescription_doctoradvice->deleteDoctorAdvice($doctoradvice_id);
            $this->session->data['success'] = $this->language->get('text_success');
        }
        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/doctoradvice');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

        //querystring to variable

        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //module view data

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'], true)
        );
        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/doctoradvice/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('prescription/doctoradvice/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['delete'] = $this->url->link('prescription/doctoradvice/delete', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );
        $data['filter_data'] = $filter_data;
        $data['doctoradvices'] = array();

        $doctoradviceList = $this->model_prescription_doctoradvice->getDoctorAdviceList($filter_data);

        foreach ($doctoradviceList as $doctoradvice) {
            $data['doctoradvices'][] = array(
                'doctoradvice_id' => $doctoradvice['doctoradvice_id'],
                'name' => $doctoradvice['name'],
                'code' => $doctoradvice['code'],
                'pinyin' => $doctoradvice['pinyin'],
                'sort_order' => $doctoradvice['sort_order'],
                'edit' => $this->url->link('prescription/doctoradvice/edit', 'user_token=' . $this->session->data['user_token'] . '&doctoradvice_id=' . $doctoradvice['doctoradvice_id'] . $querystring, true)
            );
        }

        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : NULL;
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_name'] = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);

        //rebuild querystring for pagination
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination
        $doctoradvice_total = $this->model_prescription_doctoradvice->totalDoctorAdvice($filter_data);
        $pagination = new Pagination();
        $pagination->total = $doctoradvice_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($doctoradvice_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($doctoradvice_total - $this->config->get('config_limit_admin'))) ? $doctoradvice_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $doctoradvice_total, ceil($doctoradvice_total / $this->config->get('config_limit_admin')));
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/doctoradvice_list', $data));
    }

    public function openwindow() {
        $this->load->language('prescription/doctoradvice');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/doctoradvice');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;
        //module view data

        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;

        $data['doctoradvices'] = array();

        $doctoradviceList = $this->model_prescription_doctoradvice->getDoctorAdviceList($filter_data);

        foreach ($doctoradviceList as $doctoradvice) {
            $data['doctoradvices'][] = array(
                'doctoradvice_id' => $doctoradvice['doctoradvice_id'],
                'name' => $doctoradvice['name'],
                'code' => $doctoradvice['code'],
                'sort_order' => $doctoradvice['sort_order'],
                'select' => $doctoradvice['name'],
            );
        }

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/doctoradvice_list', $data));
    }

    public function doctoradviceItem() {
        $json = array();
        $this->load->language('prescription/doctoradvice');
        $this->load->model('prescription/doctoradvice');
        $doctoradvice_items = $this->model_prescription_doctoradvice->getDoctorAdviceItem($this->request->get['doctoradvice_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');
        $json['doctoradvice'] = array();

        if (!empty($doctoradvice_items)) {

            foreach ($doctoradvice_items as $item) {
                $json['doctoradvice'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }
        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();
        if (isset($this->request->get['doctoradvice_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_doctoradvice->getDoctorAdviceColumn($this->request->get['doctoradvice_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_doctoradvice_name"] = isset($this->request->post['doctoradvice_name']) ? // if request post from form
                $this->request->post['doctoradvice_name'] :
                (isset($this->request->get['doctoradvice_id']) ? $nameMemory : array());

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['doctoradvice_id']) ?
                $this->model_prescription_doctoradvice->getDoctorAdviceColumn($this->request->get['doctoradvice_id'], 'code') :
                NULL
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['doctoradvice_id']) ?
                $this->model_prescription_doctoradvice->getDoctorAdviceColumn($this->request->get['doctoradvice_id'], 'pinyin') :
                NULL
                );
        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (

                isset($this->request->get['doctoradvice_id']) ?
                $this->model_prescription_doctoradvice->getDoctorAdviceColumn($this->request->get['doctoradvice_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['doctoradvice_id']) ?
                $this->model_prescription_doctoradvice->getDoctorAdviceColumn($this->request->get['doctoradvice_id'], 'status') :
                1
                );

        $data["form_memory_doctoradvice_items"] = isset($this->request->post['doctoradviceitem']) ? // if request post from form
                $this->request->post['doctoradviceitem'] :
                (
                isset($this->request->get['doctoradvice_id']) ?
                $this->model_prescription_doctoradvice->getDoctorAdviceItemList($this->request->get['doctoradvice_id']) :
                false

                );

        //tracing database doctoradvice item memory

        /*

          echo "<pre>";

          print_r($this->model_prescription_doctoradvice->getDoctorAdviceItemList($this->request->get['doctoradvice_id']));

          echo "</pre>";

         */

        //module data
        $data['text_form'] = !(isset($this->request->get['doctoradvice_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['button_doctoradvice_item_add'] = $this->language->get('button_doctoradvice_item_add');
        //sitemap data

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/doctoradvice', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['doctoradvice_id']))
            $querystring .= '&doctoradvice_id=' . $this->request->get['doctoradvice_id'];

        $action_mode = !(isset($this->request->get['doctoradvice_id'])) ? 'add' : 'edit';

        $data['action'] = $this->url->link("prescription/doctoradvice/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error

        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;
        $data['error_doctoradvice_name'] = isset($this->error['doctoradvice_name']) ? $this->error['doctoradvice_name'] : NULL;
        $data['error_doctoradvice_item_code'] = isset($this->error['diagnostic_item_code']) ? $this->error['diagnostic_item_code'] : NULL;
        $data['error_doctoradvice_item_pinyin'] = isset($this->error['diagnostic_item_pinyin']) ? $this->error['diagnostic_item_pinyin'] : NULL;
        $data['error_doctoradvice_item_doctoradvice_name'] = isset($this->error['doctoradvice_item_doctoradvice_name']) ? $this->error['doctoradvice_item_doctoradvice_name'] : NULL;

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/doctoradvice_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking

        if (!$this->user->hasPermission('modify', 'prescription/doctoradvice') && !$this->user->userpermission('modify', 'prescription/doctoradvice'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general doctoradvice name

        foreach ($this->request->post['doctoradvice_name'] as $language_id => $value) {

            if (validIsNullOrEmpty($value['name']))
                $this->error['name']['name' . $language_id] = $this->language->get('error_doctoradvice_name');
        }

        //validate general doctoradvice code
        $doctoradvicecode = $this->request->post['code'];

        if (validIsNullOrEmpty($doctoradvicecode))
            $this->error['name']['code'] = $this->language->get('error_doctoradvice_code');

        //validate general doctoradvice code

        $doctoradvicepinyin = $this->request->post['pinyin'];
        if (validIsNullOrEmpty($doctoradvicepinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_doctoradvice_pinyin');

        //validate general doctoradvice sort order
        //if(!validIsNumeric($this->request->post['sort_order']))
        //validate general doctoradvice status
        // --- no validation
        //validate doctoradvice item

        $doctoradviceitems = isset($this->request->post['doctoradviceitem']) ? $this->request->post['doctoradviceitem'] : false;

        if ($doctoradviceitems) {
            foreach ($doctoradviceitems as $diseasitempos => $doctoradviceitem) {

                //validate doctoradvice item code

                $doctoradviceitemcode = $doctoradviceitem['code'];
                if (validIsNullOrEmpty($doctoradviceitemcode))
                    $this->error['name']['doctoradviceitem_' . $diseasitempos . '_code'] = $this->language->get('error_doctoradvice_code');

                $doctoradviceitempinyin = $doctoradviceitem['pinyin'];
                if (validIsNullOrEmpty($doctoradviceitempinyin))
                    $this->error['name']['doctoradviceitem_' . $diseasitempos . '_pinyin'] = $this->language->get('error_doctoradvice_pinyin');

                //validate general doctoradvice name
                $doctoradviceitemnames = $doctoradviceitem['doctoradvice_name'];
                foreach ($doctoradviceitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['name']['doctoradviceitem_' . $diseasitempos . '_name' . $language_id] = $this->language->get('error_doctoradvice_name');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/doctoradvice') && !$this->user->userpermission('delete', 'prescription/doctoradvice')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

    public function autocomplete() {
        $json = array();
        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/doctoradvice');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $doctoradviceList = $this->model_prescription_doctoradvice->getDoctorAdviceList($filter_data);

            foreach ($doctoradviceList as $row => $doctoradvice) {
                $json[] = array(
                    'doctoradvice_id' => $doctoradvice['doctoradvice_id'],
                    'name' => $doctoradvice['name'],
                    'code' => $doctoradvice['code'],
                    'pinyin' => $doctoradvice['pinyin']
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>