<?php

class ControllerPrescriptionDisease extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/disease');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/disease');
        $this->getList();
    }

    public function add() {
        // tracing POST request
        $this->load->language('prescription/disease');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/disease');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_disease->addDisease($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];
            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];
            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/disease');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/disease');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_prescription_disease->editDisease($this->request->get['disease_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];
            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];
            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/disease');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/disease');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $disease_id)
                $this->model_prescription_disease->deleteDisease($disease_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/disease');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/disease');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];
            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];
            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap data
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/disease/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['add'] = $this->url->link('prescription/disease/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/disease/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['diseases'] = array();

        $diseaseList = $this->model_prescription_disease->getDiseaseList($filter_data);

        foreach ($diseaseList as $disease) {
            $data['diseases'][] = array(
                'disease_id' => $disease['disease_id'],
                'name' => $disease['name'],
                'code' => $disease['code'],
                'pinyin' => $disease['pinyin'],
                'sort_order' => $disease['sort_order'],
                'edit' => $this->url->link('prescription/disease/edit', 'user_token=' . $this->session->data['user_token'] . '&disease_id=' . $disease['disease_id'] . $querystring, true)
            );
        }

        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : NULL;
        unset($this->session->data['success']);
        //rebuild querystring for sorting

        $querystringforsort = '';

        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
        $data['sort_name'] = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);

        //rebuild querystring for pagination

        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination

        $disease_total = $this->model_prescription_disease->totalDisease($filter_data);
        $pagination = new Pagination();
        $pagination->total = $disease_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($disease_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($disease_total - $this->config->get('config_limit_admin'))) ? $disease_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $disease_total, ceil($disease_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['sort'] = $sort;
        $data['order'] = $order;
        $this->response->setOutput($this->load->view('prescription/disease_list', $data));
    }

    public function openwindow() {
        $this->load->language('prescription/disease');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addScript('view/javascript/herbal/load.js');

        $this->load->model('prescription/disease');

        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $data['user_token'] = $user_token;

        //module view data
        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;

        $data['diseases'] = array();

        $diseaseList = $this->model_prescription_disease->getDiseaseList($filter_data);

        foreach ($diseaseList as $disease) {
            $data['diseases'][] = array(
                'disease_id' => $disease['disease_id'],
                'name' => $disease['name'],
                'code' => $disease['code'],
                'sort_order' => $disease['sort_order'],
                'select' => $disease['name'],
            );
        }

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/disease_list', $data));
    }

    public function diseaseItem() {
        $json = array();

        $this->load->language('prescription/disease');
        $this->load->model('prescription/disease');

        $disease_items = $this->model_prescription_disease->getDiseaseItem($this->request->get['disease_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');

        $json['disease'] = array();

        if (!empty($disease_items)) {
            foreach ($disease_items as $item) {
                $json['disease'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $this->load->model('localisation/language'); //load other module model

        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();

        if (isset($this->request->get['disease_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array(
                    'name' => $this->model_prescription_disease->getDiseaseColumn(
                            $this->request->get['disease_id'], 'name', false, $language['language_id']),
                    'name_english' => $this->model_prescription_disease->getDiseaseColumn(
                            $this->request->get['disease_id'], 'name_english', false, $language['language_id'])
                );
            }
        }

        $data["form_memory_disease_name"] = isset($this->request->post['disease_name']) ? // if request post from form
                $this->request->post['disease_name'] :
                (isset($this->request->get['disease_id']) ? $nameMemory : array());
        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['disease_id']) ?
                $this->model_prescription_disease->getDiseaseColumn($this->request->get['disease_id'], 'code') :
                NULL

                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['disease_id']) ?
                $this->model_prescription_disease->getDiseaseColumn($this->request->get['disease_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['disease_id']) ?
                $this->model_prescription_disease->getDiseaseColumn($this->request->get['disease_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['disease_id']) ?
                $this->model_prescription_disease->getDiseaseColumn($this->request->get['disease_id'], 'status') :
                1
                );

        $data["form_memory_disease_items"] = isset($this->request->post['diseaseitem']) ? // if request post from form
                $this->request->post['diseaseitem'] :
                (
                isset($this->request->get['disease_id']) ?
                $this->model_prescription_disease->getDiseaseItemList($this->request->get['disease_id']) :
                false
                );

        $data['text_form'] = !(isset($this->request->get['disease_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //sitemap data
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/disease', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['disease_id']))
            $querystring .= '&disease_id=' . $this->request->get['disease_id'];

        $action_mode = !(isset($this->request->get['disease_id'])) ? 'add' : 'edit';

        $data['action'] = $this->url->link("prescription/disease/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error

        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_disease_name'] = isset($this->error['disease_name']) ? $this->error['disease_name'] : NULL;
        $data['error_name_english'] = isset($this->error['name_english']) ? $this->error['name_english'] : NULL;


        $data['error_disease_item_code'] = isset($this->error['disease_item_code']) ? $this->error['disease_item_code'] : NULL;
        $data['error_disease_item_pinyin'] = isset($this->error['disease_item_pinyin']) ? $this->error['disease_item_pinyin'] : NULL;
        $data['error_disease_item_disease_name'] = isset($this->error['disease_item_disease_name']) ? $this->error['disease_item_disease_name'] : NULL;
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/disease_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/disease') && !$this->user->userpermission('modify', 'prescription/disease'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general disease name
        /*  if (!empty($this->request->post['disease_name'])) {
          print_r($this->request->post); */
        foreach ($this->request->post['disease_name'] as $language_id => $value) {
            if (validIsNullOrEmpty($value['name']))
                $this->error['disease_name'][$language_id] = $this->language->get('error_disease_name');
        }

        //validate general disease code
        $diseasecode = $this->request->post['code'];

        if (validIsNullOrEmpty($diseasecode))
            $this->error['name']['code'] = $this->language->get('error_disease_code');

        $diseasepinyin = $this->request->post['pinyin'];

        if (validIsNullOrEmpty($diseasepinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_disease_pinyin');

        //validate disease item
        $diseaseitems = isset($this->request->post['diseaseitem']) ? $this->request->post['diseaseitem'] : false;

        if ($diseaseitems) {
            foreach ($diseaseitems as $diseasitempos => $diseaseitem) {
                //validate disease item code
                $diseaseitemcode = $diseaseitem['code'];

                if (validIsNullOrEmpty($diseaseitemcode))
                    $this->error['disease_item_code'][$diseasitempos] = $this->language->get('error_disease_code');

                $diseaseitempinyin = $diseaseitem['pinyin'];

                if (validIsNullOrEmpty($diseaseitempinyin))
                    $this->error['disease_item_pinyin'][$diseasitempos] = $this->language->get('error_disease_pinyin');

                //validate general disease name
                $diseaseitemnames = $diseaseitem['disease_name'];

                foreach ($diseaseitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['disease_name'][$language_id] = $this->language->get('error_disease_name');

                    if (validIsNullOrEmpty($value['name_english']))
                        $this->error['disease_name_english'][$language_id] = $this->language->get('error_disease_name_english');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/disease') && !$this->user->userpermission('delete', 'prescription/disease')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/disease');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $diseaseList = $this->model_prescription_disease->getDiseaseList($filter_data);

            foreach ($diseaseList as $row => $disease) {

                $json[] = array(
                    'disease_id' => $disease['disease_id'],
                    'name' => $disease['name'],
                    'code' => $disease['code'],
                    'pinyin' => $disease['pinyin']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>