<?php

class ControllerPrescriptionDiagnostic extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/diagnostic');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/diagnostic');

        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/diagnostic');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/diagnostic');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_diagnostic->addDiagnostic($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/diagnostic');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/diagnostic');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_prescription_diagnostic->editDiagnostic($this->request->get['diagnostic_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/diagnostic');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/diagnostic');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];

            foreach ($selected as $diagnostic_id)
                $this->model_prescription_diagnostic->deleteDiagnostic($diagnostic_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/diagnostic');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/diagnostic');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";

        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap data
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/diagnostic/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('prescription/diagnostic/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/diagnostic/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['diagnostics'] = array();

        $diagnosticList = $this->model_prescription_diagnostic->getDiagnosticList($filter_data);

        foreach ($diagnosticList as $diagnostic) {
            $data['diagnostics'][] = array(
                'diagnostic_id' => $diagnostic['diagnostic_id'],
                'name' => $diagnostic['name'],
                'code' => $diagnostic['code'],
                'pinyin' => $diagnostic['pinyin'],
                'sort_order' => $diagnostic['sort_order'],
                'edit' => $this->url->link('prescription/diagnostic/edit', 'user_token=' . $this->session->data['user_token'] . '&diagnostic_id=' . $diagnostic['diagnostic_id'] . $querystring, true)
            );
        }

        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : '';
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_name'] = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);

        //rebuild querystring for pagination
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination
        $diagnostic_total = $this->model_prescription_diagnostic->totalDiagnostic($filter_data);

        $pagination = new Pagination();
        $pagination->total = $diagnostic_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($diagnostic_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($diagnostic_total - $this->config->get('config_limit_admin'))) ? $diagnostic_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $diagnostic_total, ceil($diagnostic_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/diagnostic_list', $data));
    }

    public function openwindow() {

        $this->load->language('prescription/diagnostic');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/diagnostic');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;
        //module view data

        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;

        $data['diagnostics'] = array();

        $diagnosticList = $this->model_prescription_diagnostic->getDiagnosticList($filter_data);
        foreach ($diagnosticList as $diagnostic) {
            $data['diagnostics'][] = array(
                'diagnostic_id' => $diagnostic['diagnostic_id'],
                'name' => $diagnostic['name'],
                'code' => $diagnostic['code'],
                'sort_order' => $diagnostic['sort_order'],
                'select' => $diagnostic['name'],
            );
        }

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/diagnostic_list', $data));
    }

    public function diagnosticItem() {
        $json = array();

        $this->load->language('prescription/diagnostic');
        $this->load->model('prescription/diagnostic');

        $diagnostic_items = $this->model_prescription_diagnostic->getDiagnosticItem($this->request->get['diagnostic_id']);

        $json['diagnostic'] = array();
        if (!empty($diagnostic_items)) {
            foreach ($diagnostic_items as $item) {
                $json['diagnostic'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $this->load->model('localisation/language'); //load other module model

        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();
        if (isset($this->request->get['diagnostic_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_diagnostic->getDiagnosticColumn($this->request->get['diagnostic_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_diagnostic_name"] = isset($this->request->post['diagnostic_name']) ? // if request post from form
                $this->request->post['diagnostic_name'] :
                (isset($this->request->get['diagnostic_id']) ? $nameMemory : array());

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['diagnostic_id']) ?
                $this->model_prescription_diagnostic->getDiagnosticColumn($this->request->get['diagnostic_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['diagnostic_id']) ?
                $this->model_prescription_diagnostic->getDiagnosticColumn($this->request->get['diagnostic_id'], 'code') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['diagnostic_id']) ?
                $this->model_prescription_diagnostic->getDiagnosticColumn($this->request->get['diagnostic_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['diagnostic_id']) ?
                $this->model_prescription_diagnostic->getDiagnosticColumn($this->request->get['diagnostic_id'], 'status') :
                1
                );

        $data["form_memory_diagnostic_items"] = isset($this->request->post['diagnosticitem']) ? // if request post from form
                $this->request->post['diagnosticitem'] :
                (
                isset($this->request->get['diagnostic_id']) ?
                $this->model_prescription_diagnostic->getDiagnosticItemList($this->request->get['diagnostic_id']) :
                false
                );

        $data['text_form'] = !(isset($this->request->get['diagnostic_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/diagnostic', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['diagnostic_id']))
            $querystring .= '&diagnostic_id=' . $this->request->get['diagnostic_id'];
        $action_mode = !(isset($this->request->get['diagnostic_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("prescription/diagnostic/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_diagnostic_name'] = isset($this->error['diagnostic_name']) ? $this->error['diagnostic_name'] : NULL;
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        $data['error_diagnostic_item_code'] = isset($this->error['diagnostic_item_code']) ? $this->error['diagnostic_item_code'] : NULL;
        $data['error_diagnostic_item_pinyin'] = isset($this->error['diagnostic_item_pinyin']) ? $this->error['diagnostic_item_pinyin'] : NULL;
        $data['error_diagnostic_item_diagnostic_name'] = isset($this->error['diagnostic_item_diagnostic_name']) ? $this->error['diagnostic_item_diagnostic_name'] : NULL;


        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/diagnostic_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/diagnostic') && !$this->user->userpermission('modify', 'prescription/diagnostic'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general diagnostic name
        foreach ($this->request->post['diagnostic_name'] as $language_id => $value) {
            if (validIsNullOrEmpty($value['name']))
                $this->error['diagnostic_name'][$language_id] = $this->language->get('error_diagnostic_name');
        }

        //validate general diagnostic code
        $diagnosticcode = $this->request->post['code'];
        if (validIsNullOrEmpty($diagnosticcode)) {
            $this->error['name']['code'] = $this->language->get('error_diagnostic_code');
        }

        $diagnosticpinyin = $this->request->post['pinyin'];
        if (validIsNullOrEmpty($diagnosticpinyin)) {
            $this->error['name']['pinyin'] = $this->language->get('error_diagnostic_pinyin');
        }

        //validate diagnostic item
        $diagnosticitems = isset($this->request->post['diagnosticitem']) ? $this->request->post['diagnosticitem'] : false;
        if ($diagnosticitems) {
            foreach ($diagnosticitems as $diseasitempos => $diagnosticitem) {

                //validate diagnostic item code
                $diagnosticitemcode = $diagnosticitem['code'];
                if (validIsNullOrEmpty($diagnosticitemcode))
                    $this->error['diagnostic_item_code'][$diseasitempos] = $this->language->get('error_diagnostic_code');

                $diagnosticitempinyin = $diagnosticitem['pinyin'];
                if (validIsNullOrEmpty($diagnosticitempinyin))
                    $this->error['diagnostic_item_pinyin'][$diseasitempos] = $this->language->get('error_diagnostic_pinyin');

                //validate general diagnostic name
                $diagnosticitemnames = $diagnosticitem['diagnostic_name'];
                foreach ($diagnosticitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['diagnostic_item_diagnostic_name'][$diseasitempos][$language_id] = $this->language->get('error_diagnostic_name');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/diagnostic') && !$this->user->userpermission('delete', 'prescription/diagnostic')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/diagnostic');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $diagnosticList = $this->model_prescription_diagnostic->getDiagnosticList($filter_data);

            foreach ($diagnosticList as $row => $diagnostic) {
                $json[] = array(
                    'diagnostic_id' => $diagnostic['diagnostic_id'],
                    'name' => $diagnostic['name'],
                    'code' => $diagnostic['code'],
                    'pinyin' => $diagnostic['pinyin']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>
