<?php

class ControllerPrescriptionAcupuncturePart extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/acupuncture_part');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture_part');
        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/acupuncture_part');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture_part');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $acupuncture_part_id = $this->model_prescription_acupuncture_part->addAcupuncturePart($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $url = '';

            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $url .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $url .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $url .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/acupuncture_part');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture_part');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_acupuncture_part->editAcupuncturePart($this->request->get['acupuncture_part_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $url .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $url .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $url .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/acupuncture_part');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture_part');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];

            foreach ($selected as $acupuncture_part_id)
                $this->model_prescription_acupuncture_part->deleteAcupuncturePart($acupuncture_part_id);
            $this->session->data['success'] = $this->language->get('text_success');
        }
        $this->getList();
    }

    protected function getForm() {
        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();
        $language_arr = array('heading_title', 'button_save', 'button_cancel', 'tab_info', 'entry_name', 'entry_code', 'entry_sort_order', 'entry_status', 'text_enabled', 'text_disabled', 'entry_pinyin');

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['text_form'] = isset($this->request->get['acupuncture_part_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = "";
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = NULL;
        }

        if (isset($this->error['code'])) {
            $data['error_code'] = $this->error['code'];
        } else {
            $data['error_code'] = "";
        }

        if (isset($this->error['pinyin'])) {
            $data['error_pinyin'] = $this->error['pinyin'];
        } else {
            $data['error_pinyin'] = "";
        }
        $url = '';

        if (isset($this->request->get['acupuncture_part_id'])) {
            $acupuncture_part_info = $this->model_prescription_acupuncture_part->getAcupuncturePart($this->request->get['acupuncture_part_id']);

            if (empty($acupuncture_part_info)) {
                $this->response->redirect($this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }
        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'], true)
        );
        $url = '';

        $data['cancel'] = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (!isset($this->request->get['acupuncture_part_id'])) {
            $data['action'] = $this->url->link('prescription/acupuncture_part/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('prescription/acupuncture_part/edit', 'user_token=' . $this->session->data['user_token'] . '&acupuncture_part_id=' . $this->request->get['acupuncture_part_id'] . $url, true);
        }

        foreach ($data['languages'] as $language) {
            if (isset($this->request->post['acupuncture_part_name'][$language['language_id']])) {
                $data['acupuncture_part_name'][$language['language_id']] = $this->request->post['acupuncture_part_name'][$language['language_id']];
            } elseif (!empty($acupuncture_part_info)) {
                $data['acupuncture_part_name'][$language['language_id']] = $acupuncture_part_info['name'][$language['language_id']];
            } else {
                $data['acupuncture_part_name'][$language['language_id']] = '';
            }
        }

        if (isset($this->request->post['acupuncture_part_code'])) {
            $data['acupuncture_part_code'] = $this->request->post['acupuncture_part_code'];
        } elseif (!empty($acupuncture_part_info)) {
            $data['acupuncture_part_code'] = $acupuncture_part_info['code'];
        } else {
            $data['acupuncture_part_code'] = '';
        }

        if (isset($this->request->post['pinyin'])) {
            $data['pinyin'] = $this->request->post['pinyin'];
        } elseif (!empty($acupuncture_part_info)) {
            $data['pinyin'] = $acupuncture_part_info['pinyin'];
        } else {
            $data['pinyin'] = '';
        }

        if (isset($this->request->post['acupuncture_part_sort_order'])) {
            $data['acupuncture_part_sort_order'] = $this->request->post['acupuncture_part_sort_order'];
        } elseif (!empty($acupuncture_part_info)) {
            $data['acupuncture_part_sort_order'] = $acupuncture_part_info['sort_order'];
        } else {
            $data['acupuncture_part_sort_order'] = '';
        }

        if (isset($this->request->post['acupuncture_part_status'])) {
            $data['acupuncture_part_status'] = $this->request->post['acupuncture_part_status'];
        } elseif (!empty($acupuncture_part_info)) {
            $data['acupuncture_part_status'] = $acupuncture_part_info['status'];
        } else {
            $data['acupuncture_part_status'] = '';
        }

        $data['user_token'] = $this->session->data['user_token'];
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/acupuncture_part_form', $data));
    }

    protected function getList() {
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = null;
        }
        if (isset($this->request->get['filter_code'])) {
            $filter_code = $this->request->get['filter_code'];
        } else {
            $filter_code = null;
        }

        if (isset($this->request->get['filter_pinyin'])) {
            $filter_pinyin = $this->request->get['filter_pinyin'];
        } else {
            $filter_pinyin = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sort_order';
        }
        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }
        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }
        $url = '';
        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }
        if (isset($this->request->get['filter_pinyin'])) {
            $url .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        }
        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . $this->request->get['filter_code'];
        }
        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }
        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );


        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('prescription/acupuncture_part/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('prescription/acupuncture_part/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['acupuncture_parts'] = array();

        $filter_data = array(
            'filter_name' => $filter_name,
            'filter_pinyin' => $filter_pinyin,
            'filter_code' => $filter_code,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $acupuncture_part_total = $this->model_prescription_acupuncture_part->getTotalAcupunctureParts($filter_data);
        $results = $this->model_prescription_acupuncture_part->getAcupunctureParts($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['acupuncture_parts'][] = array(
                    'acupuncture_part_id' => $result['acupuncture_part_id'],
                    'name' => $result['name'],
                    'code' => $result['code'],
                    'pinyin' => $result['pinyin'],
                    'sort_order' => $result['sort_order'],
                    'edit' => $this->url->link('prescription/acupuncture_part/edit', 'user_token=' . $this->session->data['user_token'] . '&acupuncture_part_id=' . $result['acupuncture_part_id'], true)
                );
            }
        }
        $language_arr = array('heading_title', 'button_add', 'button_delete', 'text_list', 'button_filter', 'entry_name', 'entry_code', 'column_sort_order', 'column_name', 'column_code', 'column_action', 'text_no_results', 'text_confirm', 'button_edit', 'entry_pinyin', 'column_pinyin');
        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }
        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
        $url = '';
        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }
        if (isset($this->request->get['filter_pinyin'])) {
            $url .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        }
        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . $this->request->get['filter_code'];
        }
        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
        // sort column
        $data['sort_name'] = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        $data['sort_pinyin'] = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $url, true);
        $data['sort_code'] = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $url, true);
        $data['sort_sort_order'] = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);

        $url = '';
        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_pinyin'])) {
            $url .= '&filter_pinyin=' . urlencode(html_entity_decode($this->request->get['filter_pinyin'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_code'])) {
            $url .= '&filter_code=' . urlencode(html_entity_decode($this->request->get['filter_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $acupuncture_part_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/acupuncture_part', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($acupuncture_part_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($acupuncture_part_total - $this->config->get('config_limit_admin'))) ? $acupuncture_part_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $acupuncture_part_total, ceil($acupuncture_part_total / $this->config->get('config_limit_admin')));
        $data['sort'] = $sort;
        $data['order'] = $order;
        $data['filter_name'] = $filter_name;
        $data['filter_pinyin'] = $filter_pinyin;
        $data['filter_code'] = $filter_code;
        $data['user_token'] = $this->session->data['user_token'];
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->load->view('prescription/acupuncture_part_list', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'prescription/acupuncture_part')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        foreach ($this->request->post['acupuncture_part_name'] as $language_id => $value) {
            if (empty($value)) {
                $this->error['name'][$language_id] = $this->language->get('error_name');
            }
        }

        if (empty($this->request->post['acupuncture_part_code'])) {
            $this->error['code'] = $this->language->get('error_code');
        }

        if (empty($this->request->post['pinyin'])) {
            $this->error['pinyin'] = $this->language->get('error_pinyin');
        }
        //error
        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }
        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/acupuncture_part') && !$this->user->userpermission('delete', 'prescription/acupuncture_part')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        foreach ($this->request->post['selected'] as $acupuncture_part_id) {
            $num = 0;
            $acupuncture_items = $this->model_prescription_acupuncture_part->getAllAcupunctureItems();

            if (!empty($acupuncture_items)) {
                foreach ($acupuncture_items as $item) {
                    $acupuncture_parts = unserialize($item['acupuncture_parts']);

                    if (!empty($acupuncture_parts)) {
                        if (in_array($acupuncture_part_id, $acupuncture_parts)) {
                            $num++;
                        }
                    }
                }
            }

            if ($num > 0) {
                $this->error['warning'] = sprintf($this->language->get('error_acupuncture_part'), $num);
            }
        }
        return !$this->error;
    }

    public function autocomplete() {
        $json = array();
        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code'])) {
            $this->load->model('prescription/acupuncture_part');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;
            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'start' => 0,
                'limit' => $limit
            );

            $acupuncturePartList = $this->model_prescription_acupuncture_part->getAcupuncturePartList($filter_data);
            foreach ($acupuncturePartList as $acupuncturePart) {
                $json[] = array(
                    'acupuncture_part_id' => $acupuncturePart['acupuncture_part_id'],
                    'name' => $acupuncturePart['name'],
                    'code' => $acupuncturePart['code']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>