<?php

class ControllerHerbalWaiting extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('herbal/waiting');
        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/waiting');
        $this->load->model('sale/order');

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->getList();
    }

    public function getList()
    {
        $this->load->language('herbal/waiting');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
        $this->document->addStyle('view/stylesheet/waiting.css?v=' . time());

        date_default_timezone_set("Asia/Kuala_Lumpur");
        

        // $language = $this->session->data['language'];

        // if ($language == 'en-gb') {
        //     $data['date_types'][] = [
        //         'text' => 'All',
        //         'value' => 'all'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Today',
        //         'value' => 'today'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Week',
        //         'value' => 'week'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Month',
        //         'value' => 'month'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Year',
        //         'value' => 'year'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => 'Set By Date',
        //         'value' => 'set_by_date'
        //     ];
        // } elseif ($language == 'cn') {
        //     $data['date_types'][] = [
        //         'text' => '所有',
        //         'value' => 'all'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '今天',
        //         'value' => 'today'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '星期',
        //         'value' => 'week'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '月',
        //         'value' => 'month'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '年',
        //         'value' => 'year'
        //     ];
        //     $data['date_types'][] = [
        //         'text' => '按日期设置',
        //         'value' => 'set_by_date'
        //     ];
        // }
        $data['date_types'][] = [
            'text' => 'All',
            'value' => 'all'
        ];
        $data['date_types'][] = [
            'text' => 'Today',
            'value' => 'today'
        ];
        $data['date_types'][] = [
            'text' => 'Yesterdays',
            'value' => 'Yesterday'
        ];
        $data['date_types'][] = [
            'text' => 'This Month',
            'value' => 'month'
        ];
        $data['date_types'][] = [
            'text' => 'Last 7 days',
            'value' => 'Last_7_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 30 days',
            'value' => 'Last_30_days'
        ];
        $data['date_types'][] = [
            'text' => 'Last 3 Months',
            'value' => 'Last_3_months'
        ];
        $data['date_types'][] = [
            'text' => 'Last 6 Months',
            'value' => 'Last_6_months'
        ];
        $data['date_types'][] = [
            'text' => 'Years To Date(YTD)',
            'value' => 'Years_To_Date(YTD)'
        ];
        $data['date_types'][] = [
            'text' => 'Last 1 Years',
            'value' => 'Last_1_Years'
        ];
        $data['date_types'][] = [
            'text' => 'Last 3 Years',
            'value' => 'Last_3_Years'
        ];
        $data['date_types'][] = [
            'text' => 'Last 5 Years',
            'value' => 'Last_5_Years'
        ];

        // if (!empty($this->request->get['filter_customer_search'])) {
        //     $filter_date_from = null;
        //     $filter_date_to = null;
        //     $filter_date_type = 'all';
        //     $this->request->get['filter_date_to'] = null;
        //     $this->request->get['filter_date_from'] = null;
        //     $this->request->get['filter_customer_search'] = null;
        // }

        

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = '';
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = '';
        }

        $config_date_type = 'today';
        $filter_date_type = isset($this->request->get['filter_date_type']) ? ($this->request->get['filter_date_type']) : $config_date_type;
        $data['selected_date_type'] = $filter_date_type;

        if(empty($filter_date_from) && empty($filter_date_to) ){
            $date_now = date('Y-m-d');
            switch ($filter_date_type) {
                case 'today':
                    $filter_date_from2 = date('Y-m-d');
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Yesterday':
                    $filter_date_from2 = date('Y-m-d',strtotime('-1 days'));
                    $filter_date_to2 = date('Y-m-d',strtotime('-1 days'));
                    break;
                case 'month':
                    $filter_date_from2 = date('Y-m-01');
                    $filter_date_to2 = date('Y-m-t');
                    break;
                case 'Last_7_days':
                    $filter_date_from2 = date('Y-m-d',strtotime('-7 days'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Last_30_days':
                    $filter_date_from2 = date('Y-m-d',strtotime('-30 days'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Last_3_months':
                    $filter_date_from2 = date('Y-m-d',strtotime('-3 months'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Last_6_months':
                    $filter_date_from2 = date('Y-m-d',strtotime('-6 months'));
                    $filter_date_to2 = date('Y-m-d');
                    break;	
                case 'Years_To_Date(YTD)':
                    $filter_date_from2 = date('Y-m-d',strtotime('first day of january this year'));
                    $filter_date_to2 = date('Y-m-d',strtotime('last day of december this year'));
                    break;
                case 'Last_1_Years':
                    $filter_date_from2 = date('Y-m-d',strtotime('-1 years'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Last_3_Years':
                    $filter_date_from2 = date('Y-m-d',strtotime('-3 years'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                case 'Last_5_Years':
                    $filter_date_from2 = date('Y-m-d',strtotime('-5 years'));
                    $filter_date_to2 = date('Y-m-d');
                    break;
                default:
                    $filter_date_from2 =  '1999-01-01';
                    $filter_date_to2 = '2999-12-31';
                    break;
            }
            $data['selected_date_type'] = $filter_date_type;
        } else{
            $filter_date_from2 = $filter_date_from;
            $filter_date_to2 = $filter_date_to;
        }


        $this->request->get['filter_date_from'] = $filter_date_from;
        $this->request->get['filter_date_to'] = $filter_date_to;

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = '';
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = '';
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $filter_customer_search = $this->request->get['filter_customer_search'];
        } else {
            $filter_customer_search = '';
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = '';
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $filter_customer_lastname = $this->request->get['filter_customer_lastname'];
        } else {
            $filter_customer_lastname = '';
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = 17;
        } else {
            $filter_payment_status = 17;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = 1;
        } else {
            $filter_status = 1;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor =' 0 ,' . $this->session->data['user_id'];
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = '';
        }

        if (isset($this->request->get['filter_prescription'])) {
            $filter_prescription = $this->request->get['filter_prescription'];
        } else {
            $filter_prescription = '';
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = '';
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }

        if (isset($this->request->get['filter_address'])) {
            $filter_address = $this->request->get['filter_address'];
        } else {
            $filter_address = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = '';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = '';
        }

        if (isset($this->request->get['filter_service_type'])) {
            $filter_service_type = $this->request->get['filter_service_type'];
        } else {
            $filter_service_type = '';
        }

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $data['add'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['delete'] = $this->url->link('herbal/new_herbal/delete', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_date_from2,
            'filter_date_to' => $filter_date_to2,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_occupation' => $filter_occupation,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_prescription' => $filter_prescription,
            'filter_telephone' => $filter_telephone,
            'filter_address' => $filter_address,
            'filter_customer_lastname' => $filter_customer_lastname,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_status' => $filter_status,
            'filter_customer_search' => $filter_customer_search,
            'filter_doctor' => $filter_doctor,
            'filter_gender' => $filter_gender,
            'filter_service_type' => $filter_service_type,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $data['user_view'] = $this->user->user_view;

        if ($this->user->user_position == 2 && $this->user->user_view == 0) {
            $data['user_view'] = 0;
        } else {
            $data['user_view'] = 1;
        }

        $data['user_position'] = $this->user->user_position;

        $herbal_total = $this->model_herbal_waiting->getTotalHerbal($filter_data);

        $results = $this->model_herbal_waiting->getHerbals($filter_data);

        foreach ($results as $result) {
            if ($result['collect_consultation_price'] > 0) {
                $consultation_price = $result['clinicalsale_concultation'] * 1; //$this->model_sale_order->getHerbalTotal($result['clinical_sale_id']);
            } else {
                $consultation_price = $result['clinicalsale_concultation'] + $result['d_gst'];
            }

            $herbal_service_total = $this->model_herbal_waiting->getHerbalServiceTotal($result['clinical_sale_id']);

            $date_of_birth = date('m/d/Y', strtotime($result['dob']));
            $birthDate = explode("/", $date_of_birth);
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

            switch ($result['herb_service_type']) {
                case 'herbs':
                    $result['herb_service_type'] = $this->language->get('text_herbs');
                    break;
                case 'brewing':
                    $result['herb_service_type'] = $this->language->get('text_brewing');
                    break;
                case 'granule':
                    $result['herb_service_type'] = $this->language->get('text_granule');
                    break;
                default:
            }

            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'sales_time' => date('h:i A', strtotime($result['date_added'])),
                'invoice_prefix' => $result['invoice_prefix'],
                'telephone' => $result['telephone'],
                'firstname' => $result['firstname'] . ' ' . $result['lastname'],
                'customer_id' => $result['customer_id'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'customer_group' => $result['customer_group'],
                'doctor_name' => $result['doctor_name'],
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'status' => $result['status'],
                'top' => $result['tick_top'],
                'occupation' => $result['occupation'],
                'telephone' => $result['telephone'],
                'diagnostic' => substr($result['diagnostic_text'], 0, -1),
                //'prescription_list' => $result['prescription_name'],
                //'prescription_product_list' => $result['prescription_product_name'],
                'herb_service_type' => $result['herb_service_type'],
                'order_status' => $result['order_status'],
                'order_action' => $result['order_action'],
                'order_id' => $result['order_id'],
                'add_by' => $result['add_by'],
                'modifi_by' => $result['modifi_by'],
                'clinicalsale_action' => $result['clinicalsale_action'],
                'clinicalsale_total' => $result['clinicalsale_total'],
                'consultation_price' => sprintf('%.2f', $consultation_price),
                'service_total' => number_format($herbal_service_total, 2),
                'total_d_gst' => sprintf('%.2f', $consultation_price + $herbal_service_total + $result['clinicalsale_total']),
                'cs_type' => $result['herb_service_type'],
                // 'service_total' => number_format($herbal_service_total, 2),
                // 'total_d_gst' => sprintf('%.2f', $result['total_d_gst'] + $herbal_service_total),
                'create_new' => $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL'),
                'edit' => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . '&condition=waiting' . $url, 'SSL'),
                'delete' => $this->url->link('herbal/waiting/delete', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, 'SSL'),
                'pos' => $this->url->link('pos/pos', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'], 'SSL'),
                'info' => $this->url->link('herbal/new_herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, 'SSL'),
                'print_prescription_sticker' => $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url . '&pdf=1', 'SSL'),
                'age' => $age,
                'gender' => $result['gender'],
                'date_modified' => date('Y-m-d h:i A', strtotime($result['date_modified'])),
                'date_added' => date('Y-m-d h:i A', strtotime($result['date_added']))
            );
        }

        $data['add_new'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['export_excel'] = $this->url->link('herbal/new_herbal/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['refresh_medical_record'] = 'index.php?route=herbal/new_herbal/getList2&user_token=' . $this->session->data['user_token'] . $url;


        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_address'])) {
            $url .= '&filter_address=' . urlencode(html_entity_decode($this->request->get['filter_address'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_occupation'])) {
            $url .= '&filter_occupation=' . urlencode(html_entity_decode($this->request->get['filter_occupation'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.sales_date' . $url, 'SSL');
        $data['sort_invoice_prefix'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.invoice_prefix' . $url, 'SSL');
        $data['sort_firstname'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.firstname' . $url, 'SSL');
        $data['sort_customer_ic'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $url, 'SSL');
        $data['sort_customer_card'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_card' . $url, 'SSL');
        $data['sort_telephone'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.telephone' . $url, 'SSL');

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/waiting', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        $data['filter_date_type'] = $filter_date_type;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_transaction_from'] = $filter_transaction_from;
        $data['filter_transaction_to'] = $filter_transaction_to;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_customer_firstname'] = $filter_customer_firstname;
        $data['filter_payment_status'] = $filter_payment_status;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;
        $data['filter_customer_lastname'] = $filter_customer_lastname;
        $data['filter_occupation'] = $filter_occupation;
        $data['filter_address'] = $filter_address;
        $data['filter_prescription'] = $filter_prescription;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer_search'] = $filter_customer_search;
        $data['filter_gender'] = $filter_gender;
        $data['filter_service_type'] = $filter_service_type;
        $data['count'] = (($page - 1) * $this->config->get('config_limit_admin'));
        $data['total_pay'] = $pagination->total;



        $data['print_prescription'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_dispensing_list'] = $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_medical_cert'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');

        $data['customer_id'] = null;
        $data['herbal_single'] = array();

        if (!empty($this->request->get['customer_id'])) {
            $data['customer_id'] = $this->request->get['customer_id'];
        }
        if ($data['customer_id'] != '') {
            $herbal_single_results = $this->model_herbal_waiting->getCustomerbyid($data['customer_id']);

            $data['herbal_single'] = $herbal_single_results;
        }

        $this->load->model('localisation/order_status');

        $order_status_list = array(7, 5, 1, 18);

        foreach ($order_status_list as $order_status) {
            $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

            $data['cs_order_statuses'][] = array(
                'order_status_id' => $order_status_data['order_status_id'],
                'name' => $order_status_data['name']
            );
        }

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['button_validate'] = false;
        if ($this->user->hasPermission('modify', 'herbal/new_herbal')) {
            $data['button_validate'] = true;
        }

        $data['search_types'] = $this->getSearchTypes();

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['doctors'] = $this->model_herbal_waiting->getDoctors();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/waiting_list', $data));
    }

    protected function printData($data)
    {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }

    public function getSearchTypes(){
        $searchtype = [];
        $searchtype[] = [
           'value' => 'customer_ic',
           'text' => 'IC/Passport'
        ];
        $searchtype[] = [
            'value' => 'contact_number',
            'text' => 'Contact Number'
        ];
        $searchtype[] = [
            'value' => 'member_number',
            'text' => 'Member number'
        ];
        $searchtype[] = [
            'value' => 'customer_name',
            'text' => 'Customer Name'
        ];

        return $searchtype;
    }

    public function delete(){
        $this->load->model('herbal/waiting'); 

        $this->model_herbal_waiting->delete($this->request->get['herbal_id']);

        $this->getList();
    }

    public function checkconsult(){

        $json = array('success' => false);
		
        $clinical_sale_id = (isset($this->request->post['clinical_sale_id'])) ? $this->request->post['clinical_sale_id'] : false;
		// if (isset($this->request->post['clinical_sale_id'])) {
		// 	$clinical_sale_id = $this->request->post['clinical_sale_id'];
		// }
		if($clinical_sale_id){
            $this->load->model('herbal/waiting');

            $allclinicaldata = $this->model_herbal_waiting->getallclinicaldata($clinical_sale_id);

            if (!empty($allclinicaldata)) {
                $json = array(
                    'success' => true,
                   
                );
            }
        }
    
      
           
        // echo"<pre>";
        // print_r($allclinicaldata);
        // echo"</pre>";

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }
}
