<?php

class ControllerHerbalPrint extends Controller {
    public function index() {
        $this->load->language('herbal/print');
        // $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/payment');
        $this->load->model('sale/order');
        $this->load->model('setting/setting');

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        //
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $this->document->addStyle('view/stylesheet/payment.css?v=' . time());

        $data['herbal'] = $this->config->get('config_herbal_print_setting');
        // echo"<pre>";
        // print_r($printsetting);
        // echo"</pre>";
        // foreach($printsetting as $key => $value) {
        //     $data['herbal'] = [$key . "=>" . $value];

        //   }
        //   echo"<pre>";
        // print_r($data['herbal']);
        // echo"</pre>";

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['select_templete'] = $this->url->link('herbal/print/selectprinttemplate', 'user_token=' . $this->session->data['user_token'], true);
        $data['action'] = $this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        $this->response->setOutput($this->load->view('herbal/print', $data));
        // $this->getList();
    }

    public function printMedicalCert() {
        $this->load->model('herbal/print');

        $this->load->language('herbal/print_prescription');

        $this->document->addStyle('view/stylesheet/invoicea5.css?v=' . time());

        $data = [];
        $data['logo_image'] = HTTPS_CATALOG . 'image/catalog/cop_image.png';
        $data['direction'] = $this->language->get('direction');
        $data['lang'] = $this->language->get('code');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        if (isset($this->request->post['selected'])) {
            $herbals = $this->request->post['selected'];
        } elseif (isset($this->request->get['herbal_id'])) {
            $herbals[] = $this->request->get['herbal_id'];
        }

        $data['herbals'] = [];
        if (!empty($herbals)) {
            foreach ($herbals as $herbal_id) {
                if (!empty($herbal_id)) {
                    $this->load->model('setting/setting');

                    $this->load->model('localisation/country');

                    $this->load->model('localisation/zone');


                    $data['pdf'] = false;
                }
            }
        }

        $data = $this->allPrintData();


        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['review']) && ($this->request->get['pdf'])) {
            $printherbal = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printherbal, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            if (empty($setting['new_medical_cert'])) {
                $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['new_medical_cert'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }



        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            $template = $setting['new_medical_cert'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printHerbalRemedies() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $herbal_id = $this->request->get['herbal_id'];

        $data = $this->allPrintData();
        // echo '<pre>';
        // print_r($data);
        // echo '</pre>';

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $herbal_remedies_image = $this->model_herbal_print->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printherbal = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printherbal, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            if (empty($setting['herbal_remedies'])) {
                $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['herbal_remedies'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }



        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            $template = $setting['herbal_remedies'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printMedicationStickers() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/print');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $herbal_id = $this->request->get['herbal_id'];

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data = $this->allPrintData();

        $data['current_language'] = $this->session->data['language'];

        $herbal_remedies = $this->model_herbal_print->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals']   = array();

        foreach ($herbal_remedies as $prescription_id => $prescription) {
            $data['remedies'][$prescription_id] = array(
                'key'      => $prescription_id,
                'name'     => $prescription['name'],
                'id'       => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_print->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $data['products'][$prescription_id][] = array(
                    'name'   => $products['name'],
                    'code'   => $products['code'],
                    'weight' => $this->weight->format($products['weight'], $products['weight_class_id']),
                );
            }
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        $herbal_remedies_image = $this->model_herbal_print->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['review']) && ($this->request->get['pdf'])) {
            $printherbal = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printherbal, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            if (empty($setting['herbal_remedies_sticker'])) {
                $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['herbal_remedies_sticker'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }



        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            $template = $setting['herbal_remedies_sticker'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printDispensingList() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $herbal_id = $this->request->get['herbal_id'];

        $data = $this->allPrintData();

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $herbal_remedies_image = $this->model_herbal_print->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['review']) && ($this->request->get['pdf'])) {
            $printherbal = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printherbal, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            if (empty($setting['herbal_dispensing'])) {
                $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['herbal_dispensing'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }



        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_herbal_print_setting');
            $template = '';
            $template = $setting['herbal_dispensing'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function selectPrintTemplate() {
        $this->load->model('setting/setting');
        $this->load->model('herbal/print');
        $this->load->language('herbal/print');

        $herbal_remedies = (isset($this->request->post['herbal_remedies'])) ? $this->request->post['herbal_remedies'] : '';
        $herbal_dispensing = (isset($this->request->post['herbal_dispensing'])) ? $this->request->post['herbal_dispensing'] : '';
        $herbal_remedies_sticker = (isset($this->request->post['herbal_remedies_sticker'])) ? $this->request->post['herbal_remedies_sticker'] : '';
        $new_medical_cert = (isset($this->request->post['new_medical_cert'])) ? $this->request->post['new_medical_cert'] : '';

        $selecttemplate = array(
            'herbal_remedies' => $herbal_remedies,
            'herbal_dispensing' => $herbal_dispensing,
            'herbal_remedies_sticker' => $herbal_remedies_sticker,
            'new_medical_cert' => $new_medical_cert
        );



        $jsontemplete = json_encode($selecttemplate);
        $print_value = $this->config->get('config_herbal_print_setting');
        if (empty($print_value)) {
            $this->model_herbal_print->addprintsetting($jsontemplete);
        } else {
            $this->model_herbal_print->insertprintsetting($jsontemplete);
        }



        $this->session->data['success'] = $this->language->get('text_success');



        $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
    }

    public function allPrintData() {
        $this->load->language('herbal/print');

        $this->load->model('herbal/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $herbal_id = $this->request->get['herbal_id'];


        $basic_data = $this->model_herbal_print->getHerbalRemediesBasicData($herbal_id);

        if (empty($basic_data['store_id'])) {
            $store_info = $this->model_setting_setting->getSetting('config', '0');
            $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
            $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);
        } else {
            $store_info = $this->model_setting_setting->getSetting('config', $basic_data['store_id']);
            $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
            $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);
        };

        $herbal_remedies = $this->model_herbal_print->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals'] = array();


        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }


        if ($store_info) {
            $store_name      = $store_info['config_name'];
            $store_address   = $store_info['config_address'];
            $store_telephone = $store_info['config_telephone'];
            $store_fax       = $store_info['config_fax'];
            $store_number    = $store_info['config_number'];
            $store_gstno     = $store_info['config_gstno'];
            $store_country   = $country['name'];
            $store_zone      = $zone['name'];
            $store_email     = $store_info['config_email'];
        } else {
            $store_name      = $this->config->get('config_name');
            $store_address   = $this->config->get('config_address');
            $store_telephone = $this->config->get('config_telephone');
            $store_fax       = $this->config->get('config_fax');
            $store_number    = '';
            $store_gstno     = $this->config->get('config_gstno');
            $store_country   = '';
            $store_zone            = '';
            $store_email     = $this->config->get('config_email');
        }
        if (!empty($herbal_id)) {
            $data['store_name']      = $store_name;
            $data['store_number']    = $store_number;
            $data['store_address']   = $store_address;
            $data['store_zone']      = $store_zone;
            $data['store_country']   = $store_country;
            $data['store_gstno']     = $store_gstno;
            $data['store_telephone'] = $store_telephone;
            $data['customer_name']   = $basic_data['customer_name'];
            $data['customer_ic']     = $basic_data['customer_ic'];
            $data['invoice_prefix']  = $basic_data['invoice_prefix'];
            $data['date_added']      = date($this->language->get('date_format_short'), strtotime($basic_data['date_added']));
            $data['doctor_name']     = $basic_data['doctor_name'];
            $data['telephone']       = $basic_data['telephone'];
            $data['store_email']     = $store_email;

            $data['age']             = $basic_data['age'];
            $data['diagnostic']      = $basic_data['diagnostic'];
            $data['doctoradvice']    = $basic_data['doctoradvice'];
            $data['pulse']           = $basic_data['pulse'];
            $data['disease']         = $basic_data['disease'];
            $data['treatment']       = $basic_data['treatment'];
            $data['acupuncture']     = $basic_data['acupuncture'];
            $data['symptom']         = $basic_data['symptom'];

            $data['times']           = $basic_data['times'];
            $data['day']             = $basic_data['day'];
            $data['cook']            = $basic_data['cook'];
            $data['taketype']        = $basic_data['taketype'];
            $data['weight']         = $this->weight->format($basic_data['weight'], $basic_data['weight_class_id']);


            if ($basic_data['gender'] == '1') {
                $data['gender'] = $this->language->get('text_male');
            } else {
                $data['gender'] = $this->language->get('text_female');
            }

            foreach ($herbal_remedies as $prescription_id => $prescription) {
                $data['remedies'][$prescription_id] = array(
                    'key' => $prescription_id,
                    'name' => $prescription['name'],
                    'id' => $prescription['prescription_id'],
                    'discount' => 0
                );

                $herbal_peroduct = $this->model_herbal_print->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

                foreach ($herbal_peroduct as $product_id => $products) {
                    $data['products'][$prescription_id][] = array(
                        'name' => $products['name'],
                        'code' => $products['code'],
                        'weight' => round($products['quantity'], 2) . 'g', //* $products['weight'])
                    );
                }
            }
        } else {
            $data['store_name']      = $store_name;
            $data['store_number']    = $store_number;
            $data['store_address']   = $store_address;
            $data['store_zone']      = $store_zone;
            $data['store_country']   = $store_country;
            $data['store_telephone'] = $store_telephone;
            $data['customer_name']   = 'Kelvin Tan';
            $data['customer_ic']     = '92031312451';
            $data['invoice_prefix']  = 'CS-000001';
            $data['date_added']      = '2022-02-04';
            $data['doctor_name']     = 'Justin';
            $data['telephone']       = '014-22356123';
            $data['store_email']     = 'kelvin@gmail.com';
            $data['age']             = '25';
            $data['diagnostic']      = '呕吐';
            $data['doctoradvice']    = 'drink water';
            $data['pulse']           = 'ok';
            $data['disease']         = '咳嗽，发烧';
            $data['treatment']       = '多休息';
            $data['acupuncture']     = '';
            $data['symptom']         = '呕吐';

            $data['times']           = '3';
            $data['day']             = '5';
            $data['cook']            = '5';
            $data['taketype']        = '5';
            $data['weight']         = $this->weight->format('20', '2');


            $data['gender'] = $this->language->get('text_male');
            $data['remedies'][0] = array(
                'key' => 0,
                'name' => '三黄石膏汤,乙字汤',
                'id' => 1,
                'discount' => 0
            );

            $data['products'][0][] = array(
                'name' => 'RHIZOMA COPTIDIS',
                'code' => 'HL01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'RADIX SCUTELLARIAE',
                'code' => 'HQ02',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'CORTEX PHELLODENDRI CHINENSIS',
                'code' => 'HB01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'GYPSUM FIBROSUM',
                'code' => 'SG01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'HERBA EPHEDRAE',
                'code' => 'MH01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'FERMENTED SOYBEAN',
                'code' => 'DDC01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'FRUCTUS GARDENIAE',
                'code' => 'ZZ01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'RADIX BUPLEURI (WILD)',
                'code' => 'CH01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'RHIZOMA CIMICIFUGAE',
                'code' => 'SM01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'RADIX ET RHIZOMA RHEI',
                'code' => 'DH01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'CHINESE ANGELICA ROOT',
                'code' => 'DG01',
                'weight' => '10g', //* $products['weight'])
            );
            $data['products'][0][] = array(
                'name' => 'LIQUORICE ROOT',
                'code' => 'GC01',
                'weight' => '10g', //* $products['weight'])
            );
        }


        return $data;
    }
}
