<?php

class ControllerHerbalNgpPrescription extends Controller {
    private $error;

    protected function setOrderStatus($array) {
        $allowed_order_status = ['1', '5', '15'];
        return in_array($array['order_status_id'], $allowed_order_status);
    }

    public function index() {
        $this->load->language('herbal/ngp_prescription');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/ngp_prescription');

        $this->getList();
    }

    public function getList() {

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = '';
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = '';
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = '';
        }

        if (isset($this->request->get['filter_service_type'])) {
            $filter_service_type = $this->request->get['filter_service_type'];
        } else {
            $filter_service_type = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '1,15';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'product_to_service_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . urlencode(html_entity_decode($this->request->get['filter_gender'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . urlencode(html_entity_decode($this->request->get['filter_doctor'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_all'] = $this->language->get('text_all');
        $data['text_age'] = $this->language->get('text_age');

        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_gender'] = $this->language->get('entry_gender');
        $data['entry_doctor'] = $this->language->get('entry_doctor');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_service_type'] = $this->language->get('entry_service_type');
        $data['entry_granule'] = $this->language->get('entry_granule');
        $data['entry_herbs'] = $this->language->get('entry_herbs');

        $data['button_complete'] = $this->language->get('button_complete');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_send_to_machine'] = $this->language->get('button_send_to_machine');
        $data['button_print_pdf'] = $this->language->get('button_print_pdf');

        $data['column_complete_status'] = $this->language->get('column_complete_status');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_detail'] = $this->language->get('column_detail');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_age'] = $this->language->get('column_age');
        $data['column_gender'] = $this->language->get('column_gender');
        $data['column_doctor'] = $this->language->get('column_doctor');
        $data['column_prescription_id'] = $this->language->get('column_prescription_id');
        $data['column_profession'] = $this->language->get('column_profession');
        $data['column_prescription_times'] = $this->language->get('column_prescription_times');
        $data['column_daily_take'] = $this->language->get('column_daily_take');
        $data['column_diagnostic'] = $this->language->get('column_diagnostic');
        $data['column_doctoradvice'] = $this->language->get('column_doctoradvice');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_product'] = $this->language->get('column_product');
        $data['column_prescription'] = $this->language->get('column_prescription');
        $data['column_pts_id']  = $this->language->get('column_pts_id');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = array_filter(
            $this->model_localisation_order_status->getOrderStatuses(),
            array($this, 'setOrderStatus'),
            ARRAY_FILTER_USE_BOTH
        );

        $data['prescriptions'] = [];

        $filter_data = [
            'filter_customer' => $filter_customer,
            'filter_gender' => $filter_gender,
            'filter_doctor' => $filter_doctor,
            'filter_status' => $filter_status,
            'filter_service_type' => $filter_service_type,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        if (!empty($filter_status)) {
            $data['filter_status'] = explode(',', $filter_status);
        } else {
            $data['filter_status'] = [];
        }

        $this->load->model('herbal/ngp_prescription');

        $prescription_total = $this->model_herbal_ngp_prescription->getTotalNGPPrescription($filter_data);

        $results = $this->model_herbal_ngp_prescription->getNGPPrescriptions($filter_data);

        foreach ($results as $result) {

            $order_status_label = '';
            switch ($result['status']) {
                case 1:
                    $order_status_label = 'warning';
                    break;
                case 5:
                    $order_status_label = 'success';
                    break;
                case 15:
                    $order_status_label = 'primary';
                    break;
            }

            $complete_status_name = $this->model_herbal_ngp_prescription->getCompleteStatusName($result['status']);

            $data['prescriptions'][] = [
                'product_to_service_id' => $result['product_to_service_id'],
                'prescription_id' => $result['prescription_id'],
                'prescription_times' => $result['prescription_times'],
                'daily_take' => $result['daily_take'],
                'diagnostic' => $result['diagnostic'],
                'doctoradvice' => $result['doctoradvice'],
                'customer' => $result['customer'],
                'gender' => $result['gender'],
                'age' => $result['age'],
                'total' => $this->currency->format($result['total'], $this->config->get('config_currency')),
                'doctor' => $result['doctor'],
                'profession' => $result['profession'],
                'products' => $result['products'],
                'order_status_label' => $order_status_label,
                'complete_status' => $result['status'],
                'complete_status_name' => $complete_status_name,
                'ngp_machine' => $result['ngp_machine'],
                'print_a5' => $this->url->link('herbal/herbal/printSticker', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['prescription_id'] . '&pdf=1', 'SSL'),
                'complete' => $this->url->link('herbal/ngp_prescription/setComplete', 'user_token=' . $this->session->data['user_token'] . '&product_to_service_id=' . $result['product_to_service_id'] . '&ngp_machine=' . $result['ngp_machine'] . $url, 'SSL'),
                'cancel' => $this->url->link('herbal/ngp_prescription/setCancel', 'user_token=' . $this->session->data['user_token'] . '&product_to_service_id=' . $result['product_to_service_id'] . $url, 'SSL'),
                'send_to_machine' => $this->url->link('herbal/ngp_prescription/sendToNGPMachine', 'user_token=' . $this->session->data['user_token'] . '&product_to_service_id=' . (int) $result['product_to_service_id'] . $url, 'SSL')
            ];
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'pts_id') {
                $product_to_service_id_column = array_column($data['prescriptions'], 'product_to_service_id');

                if ($order == 'ASC') {
                    array_multisort($data['prescriptions'], SORT_NUMERIC, $product_to_service_id_column, SORT_ASC);
                } else {
                    array_multisort($data['prescriptions'], SORT_NUMERIC, $product_to_service_id_column, SORT_DESC);
                }
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (!empty($this->session->data['warning'])) {
            $data['error_warning'] = $this->session->data['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . urlencode(html_entity_decode($this->request->get['filter_gender'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . urlencode(html_entity_decode($this->request->get['filter_doctor'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_customer'] = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, 'SSL');
        $data['sort_prescription_id'] = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=prescription_id' . $url, 'SSL');
        $data['sort_gender'] = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=gender' . $url, 'SSL');
        $data['sort_doctor'] = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=doctor' . $url, 'SSL');
        $data['sort_pts_id'] = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . '&sort=pts_id' . $url, 'SSL');

        $url = '';

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . urlencode(html_entity_decode($this->request->get['filter_gender'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . urlencode(html_entity_decode($this->request->get['filter_doctor'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $prescription_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($prescription_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($prescription_total - $this->config->get('config_limit_admin'))) ? $prescription_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $prescription_total, ceil($prescription_total / $this->config->get('config_limit_admin')));

        $data['filter_customer'] = $filter_customer;
        $data['filter_gender'] = $filter_gender;
        $data['filter_doctor'] = $filter_doctor;
        // $data['filter_status'] = $filter_status;

        $data['filter_service_type'] = $filter_service_type;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/ngp_prescription_list', $data));
    }

    public function getHerbsProductCodeMatch() {
        $query = $this->db->query("SELECT * FROM `oc_ngp_product_shelf_grid`");
        return $query->rows;
    }

    public function getNGPProduct($id) {
        $query = $this->db->query("SELECT code FROM `oc_ngp_product` WHERE 1 AND `product_id` = '" . (int)$id . "'");
        return !empty($query->row['code']) ? $query->row['code'] : '';
    }

    public function updateProductCodeMatch() {
        $products = $this->getHerbsProductCodeMatch();
        foreach ($products as $product) {
            $code = $this->getNGPProduct($product['drug_id']);
            if (!empty($code)) {
                $this->modelUpdateProductCodeMatch($code);
            }
        }
    }

    public function modelUpdateProductCodeMatch($code) {
        $this->db->query("UPDATE `oc_product_code_match` SET `shelf_grid` = '1' WHERE 1 AND `match_code` = '" . $this->db->escape($code) . "'");
    }

    public function DrugShelfGridGetList() {
        $url = "http://eciwo.dyndns.org:8089/Prescription.asmx?WSDL";

        $client = new SoapClient($url);

        $client->__setLocation('http://eciwo.dyndns.org:8089/Prescription.asmx');

        $response = $client->GetList();

        // $response->GetListResult->DrugShelfGrid;

        // $products = $response->GetListResult->DrugShelfGrid;
        // foreach ($products as $product) {
        //     $this->insertShelf((array)$product);
        // }

        echo '<pre>';
        print_r($response);
        echo '</pre>';
    }

    public function insertShelf($data) {
        $this->db->query("INSERT INTO `oc_ngp_product_shelf_grid` SET `pkid` = '" . (int)$data['PKId'] . "', `x` = '" . (int)$data['x'] . "', `y` = '" . (int)$data['y'] . "', `drug_id` = '" . (int)$data['DrugID'] . "', `drug_stock_quantity` = '" . (float)$data['DrugStockQuantity'] . "', `update_date` = '" . $this->db->escape($data['UpdateDate']) . "', `pihao` = '" . (int)$data['PiHao'] . "'");
    }

    public function getPaymentList() {
        $url = "http://eciwo.dyndns.org:8089/Payment.asmx?WSDL";

        $client = new SoapClient($url);

        //var_dump($client->__getFunctions());
        //var_dump($client->__getTypes());

        $client->__setLocation('http://eciwo.dyndns.org:8089/Payment.asmx');

        $response = $client->GetList();

        echo '<pre>';
        print_r($response);
        echo '</pre>';
    }

    public function getDrugList() {
        $url = "http://eciwo.dyndns.org:8089/Drug.asmx?WSDL";

        $client = new SoapClient($url);

        //var_dump($client->__getFunctions());
        //var_dump($client->__getTypes());

        $client->__setLocation('http://eciwo.dyndns.org:8089/Drug.asmx');

        $response = $client->GetDrugList1();

        echo '<pre>';
        print_r($response);
        echo '</pre>';
    }

    public function DrugClassGetList() {
        $url = "http://eciwo.dyndns.org:8089/DrugClass.asmx?WSDL";

        $client = new SoapClient($url);

        // var_dump($client);
        // var_dump($client->__getFunctions());
        // var_dump($client->__getTypes());

        $client->__setLocation('http://eciwo.dyndns.org:8089/DrugClass.asmx');

        $response = $client->GetList();

        echo '<pre>';
        print_r($response);
        echo '</pre>';
    }

    public function DrugClassAdd() {
        //连接
        $url = "http://eciwo.dyndns.org:8089/DrugClass.asmx?WSDL";

        //设置连接
        $client = new SoapClient($url);

        //var_dump($client->__getFunctions());
        //var_dump($client->__getTypes());

        $client->__setLocation('http://eciwo.dyndns.org:8089/DrugClass.asmx');

        //�?传�?的数�?�
        $data = [
            'model' => array(
                'PKId' => 7,
                'DrugClassName' => '补养�?�----壯阳�?�',
            )
        ];

        // Call 添加 WebService
        $response = $client->Add($data);

        // 打�?�回传的 Response
        echo '<pre>';
        print_r($response);
        echo '</pre>';
    }

    public function PrescriptioninterfaceFormat() {
    }

    public function interfaceFormat() {
        //header("Access-Control-Allow-Origin: http://myetcm.dyndns-server.com");
        //header("Access-Control-Request-Method: GET,POST");

        // try {
        $url = "http://eciwo.dyndns.org:8089/Prescription.asmx?WSDL";

        $client = new SoapClient($url);

        // var_dump($client);
        // var_dump($client->__getFunctions());
        // var_dump($client->__getTypes());

        $client->__setLocation('http://eciwo.dyndns.org:8089/Prescription.asmx?WSDL');

        $data = [
            //'InterfaceStr' => '', //'3, 7, 一日三次, 早�?�, 肾虚阳痿, 林凯文, 男, 24, 452.40, Mr.黄医师, 皮肤科; A001, 30/A002, 20'
            'InterfaceStr' => '20201029, 3, 一日2次,    ,    , CHEW YI XUAN-, 男, 0, 50.00, 2, 外�?�-, 外�?�;DG01, 10.00',
        ];

        $response = $client->InterfaceFormat($data);
        echo '<pre>';
        print_r($response);
        echo '</pre>';
        // } catch (SoapFault $e) {
        //     echo '<pre>';
        //     print_r($e);
        //     echo '</pre>';
        //     var_dump($client->__getLastResponse());
        // }
    }

    public function phpInfo() {
        phpinfo();
    }

    protected function printArray($data) {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }

    public function getWrongServicePartnerProducts() {
        $sql = "SELECT spsop.sale_order_id, spsop.sale_order_product_id, spsop.product_id AS etcm_product_id, sppm.etcm_product_id AS real_etcm_product_id, spsop.name, spsop.code, CONCAT(pcm.`code`, ', ', (spsop.`quantity` * ngp.`compressscale`)) AS product, pcm.name AS match_name, pcm.code AS match_code, ngp.drug_id, ngp.name AS ngp_product, ngp.code AS ngp_code FROM `" . DB_PREFIX .  "service_partner_sale_order_product` spsop LEFT JOIN `" . DB_PREFIX .  "etcm_service_partner_product_match` sppm ON (spsop.code = sppm.etcm_product_code) LEFT JOIN `" . DB_PREFIX .  "product_code_match` pcm ON (sppm.`product_id` = pcm.`product_id`) LEFT JOIN `" . DB_PREFIX .  "ngp_product` ngp ON (sppm.`product_id` = ngp.`product_id`) WHERE 1 AND spsop.`sale_order_id` IN (8,9,10)  ORDER BY spsop.`sale_order_product_id` ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function updateETCMProductId() {
        $data = [];
        $products = $this->getWrongServicePartnerProducts();
        $data['counts'] = count($products);
        foreach ($products as $product) {
            $data['products'][] = $product;

            //$this->db->query("UPDATE `" . DB_PREFIX . "service_partner_sale_order_product` SET product_id = '" . (int)$product['real_etcm_product_id'] . "' WHERE 1 AND sale_order_id = '" . (int)$product['sale_order_id'] . "' AND sale_order_product_id = '" . (int)$product['sale_order_product_id'] . "'");
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }


    public function getServicePartnerSaleOrderProducts($sale_order_id, $prescription_id) {
        $sql = "SELECT spsop.sale_order_product_id, spsop.product_id AS etcm_product_id, spsop.name, spsop.code, CONCAT(pcm.`code`, ', ', (spsop.`quantity` * ngp.`compressscale`)) AS product, pcm.name AS match_name, pcm.code AS match_code, ngp.drug_id, ngp.name AS ngp_product, ngp.code AS ngp_code FROM `" . DB_PREFIX .  "service_partner_sale_order_product` spsop LEFT JOIN `" . DB_PREFIX .  "etcm_service_partner_product_match` sppm ON (spsop.product_id = sppm.etcm_product_id) LEFT JOIN `" . DB_PREFIX .  "product_code_match` pcm ON (sppm.`product_id` = pcm.`product_id`) LEFT JOIN `" . DB_PREFIX .  "ngp_product` ngp ON (sppm.`product_id` = ngp.`product_id`) WHERE 1 AND pcm.`code` <> '' AND spsop.`sale_order_id` = '" . (int)$sale_order_id . "' AND pcm.`status` = 1 AND spsop.`prescription_id` = '" . (int)$prescription_id . "' ORDER BY spsop.`sale_order_product_id` ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getWrongServicePartnerSaleOrderProduct($sale_order_id, $prescription_id) {
        $sql = "SELECT GROUP_CONCAT(spsop.name,' (',spsop.code,')') AS name FROM `" . DB_PREFIX .  "service_partner_sale_order_product` spsop LEFT JOIN `" . DB_PREFIX .  "etcm_service_partner_product_match` sppm ON (spsop.product_id = sppm.etcm_product_id) LEFT JOIN `" . DB_PREFIX .  "product_code_match` pcm ON (sppm.`product_id` = pcm.`product_id`) LEFT JOIN `" . DB_PREFIX .  "ngp_product` ngp ON (sppm.`product_id` = ngp.`product_id`) WHERE 1 AND (pcm.`code` IS NULL OR pcm.`status` = 0) AND spsop.`sale_order_id` = '" . (int)$sale_order_id . "' AND spsop.`prescription_id` = '" . (int)$prescription_id . "' GROUP BY spsop.`prescription_id` ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getServicePartnerSaleOrder($sale_order_id) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "service_partner_sale_order` WHERE `sale_order_id` = '" . (int)$sale_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getServicePartnerSaleOrderPrescriptions($sale_order_id) {
        $sql = "SELECT MAX(spsop.times) AS times, MAX(spsop.day) AS day  FROM `" . DB_PREFIX .  "service_partner_sale_order_product` spsop  WHERE 1 AND spsop.`sale_order_id` = '" . (int)$sale_order_id . "' GROUP BY spsop.`sale_order_id` ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    protected function printJson($json) {
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function sendToNGPMachineByServicePartner() {
        $json = [];

        $json['success'] = '';
        $json['error'] = '';
        $json['prescriptions'] = [];
        $sale_order_id = !empty($this->request->get['sale_order_id']) ? $this->request->get['sale_order_id'] : 0;
        $send = true;

        // Setup Soap Client INI settings
        ini_set('soap.wsdl_cache_enabled', 0);
        ini_set('soap.wsdl_cache_ttl', 0);
        ini_set('default_socket_timeout', 15);

        //options for ssl in php 5.6.5
        $opts = array(
            'ssl' => array(
                'ciphers' => 'RC4-SHA',
                'verify_peer' => false,
                'verify_peer_name' => false
            )
        );

        // Setup Soap Client options
        $options = array(
            'cache_wsdl' => WSDL_CACHE_NONE,
            'connection_timeout' => 5,
            'trace' => false,
            'encoding' => 'UTF-8',
            'exceptions' => false,
            'verifypeer' => false,
            'verifyhost' => false,
            'soap_version' => SOAP_1_2,
            'exceptions' => true,
        );

        try {
            // Check sale order is empty or not
            if (empty($sale_order_id)) {
                $send = false;
                throw new Exception('Error! Sale order id parameter are empty ! Please resend again !');
            }

            // Check sale order is valid or invalid, throw error if invalid
            $service_partner_sale_order = $this->getServicePartnerSaleOrder($sale_order_id);
            if (empty($service_partner_sale_order)) {
                $send = false;
                throw new Exception('Error! Invalid sale order id parameter ! Please resend again !');
            }

            // Check prescription and throw error if empty
            $prescriptions_json = !empty($service_partner_sale_order['service_partner_prescription_json']) ? json_decode($service_partner_sale_order['service_partner_prescription_json'], true) : [];
            if (empty($prescriptions_json)) {
                $send = false;
                throw new Exception('Error! Empty prescriptions date for the sale order #' . $sale_order_id . ' ! Please resend again !');
            }

            // Check ngp webservices exists, if not exists throw an error
            if (empty($this->config->get('config_ngp_webservices_connection_url'))) {
                $send = false;
                $json['error'] = 'Error! The NGP machine connection havent setup ! Please conatact ETCM techinicain !';
            }

            // Check ngp webservices is enable, if disable throw an error
            if (empty($this->config->get('config_ngp_webservices_status'))) {
                $send = false;
                throw new Exception('Error! The NGP machine connection is disabled and you are not allowed to connect ! Please conatact ETCM techinicain !');
            }

            // Check ngp webservices send prescription connection setup, if havent throw an error
            if (empty($this->config->get('config_ngp_webservices_send_prescription_url')) || empty($this->config->get('config_ngp_webservices_send_prescription_location_url'))) {
                $send = false;
                throw new Exception('Error! The NGP machine send prescription connection havent setup ! Please conatact ETCM techinicain !');
            }

            $function_url = $this->config->get('config_ngp_webservices_send_prescription_url');
            //$function_location_url = $this->config->get('config_ngp_webservices_send_prescription_location_url');

            // Check ngp webservices connection is turn on, if turn off throw an error 
            $url = $this->config->get('config_ngp_webservices_connection_url');
            if (empty($this->checkConnection($url))) {
                $send = false;
                throw new Exception('Error! The NGP machine is not turn on ! Please turn on before send prescriptions to NGP machine !');
            }

            try {
                // Check ngp webservices validation, if invalid, throw and error.
                $client = new SoapClient($function_url, $options);
            } catch (SoapFault $client) {
                $send = false;
                $json['error'] = 'Error! Invalid NGP machine connection setup ! Please contact ETCM technician !';
                $this->printJson($json);
            }

            // If cannot send prescriptions to NGP machine, send an error.
            if (empty($send)) {
                $send = false;
                throw new Exception('Error! The system error ! Please contact ETCM technician !');
            }

            if (!empty($send)) {
                // Prescriptions format of NGP machine used
                $data['format'] = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';
                $search = [
                    '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
                    '{gender}', '{age}', '{total}', '{status}', '{doctor}', '{profession}', '{products}'
                ];

                // Data that needed for prescription format
                $data['date_added'] = (!empty($service_partner_sale_order['order_date'])) ? date('Ymd', strtotime($service_partner_sale_order['order_date'])) : date('Ymd');
                $data['prescription_times'] = (!empty($service_partner_sale_order_prescription['times'])) ?  $service_partner_sale_order_prescription['times'] : 3;
                $data['daily_take'] = (!empty($service_partner_sale_order_prescription['day'])) ? '一日' . $service_partner_sale_order_prescription['day'] . '次' : '一日1次';
                $data['diagnostic'] = '';
                $data['doctoradvice'] = '';
                $data['customer'] = (!empty($service_partner_sale_order['customer_name'])) ? substr($service_partner_sale_order['customer_name'], 0, 10) : '';
                $data['gender'] = '男';
                $data['age'] = '20';
                $data['status'] = 2;
                $data['total'] = (!empty($service_partner_sale_order['total'])) ? $service_partner_sale_order['total'] : 0;
                $data['doctor'] = 'eTCM药房联盟 外单';
                $data['profession'] = 'NGP智能药房';

                $prescriptions = $prescriptions_json;
                $count_success = 0;
                $count_granule = 0;
                $json['prescriptions'] = [];
                $product_errors = '';

                // Loop all prescriptions of sale order and send to machine
                foreach ($prescriptions as $pid => $prescription) {
                    $json['prescriptions'][$pid] = $prescription;
                    // Only granule prescriptions will send to NGP machine
                    if ($prescription['service_type'] == 'GRANULE') {
                        $count_granule++;

                        $check = true;
                        $data['prescription_times'] = (!empty($prescription['times'])) ?  $prescription['times'] : 3;
                        $data['daily_take'] = (!empty($prescription['day'])) ? '一日' . $prescription['day'] . '次' : '一日2次';

                        // Get all prescriptions products
                        $service_partner_sale_order_products = $this->getServicePartnerSaleOrderProducts($sale_order_id, $prescription['prescription_id']);
                        $products = array_column($service_partner_sale_order_products, 'product');
                        $product_count = !empty($products) ? count($products) : 0;

                        // Check if prescription products is empty, thrown an error.
                        if (!empty($products)) {
                            // Check if total products count of prescription is incorrect, thrown an error.
                            if ((int)$product_count != (int)$prescription['total_products']) {
                                $check = false;
                                $json['prescriptions'][$pid]['error'] = 'Some product are missing ! Please contact NGP technician !';

                                if (empty($check)) {
                                    // Check prescription products that not in NGP system, thrown an error
                                    $error_products = $this->getWrongServicePartnerSaleOrderProduct($sale_order_id, $prescription['prescription_id']);

                                    if (!empty($error_products['name'])) {
                                        $json['prescriptions'][$pid]['error'] = 'There are some products ' . $error_products['name'] . ' in the prescription #' . (int)$prescription['prescription_id'] . ' are not in NGP machine system ! Please contact NGP technician !';
                                    }
                                }
                            }

                            $json['prescriptions'][$pid]['products'] = implode('/', $products);
                        } else {
                            $check = false;
                            $json['prescriptions'][$pid]['products'] = [];
                            $json['prescriptions'][$pid]['error'] = 'The products data are empty! Please contact NGP technician!';
                        }

                        // Check prescription format no issue, sent to NGP machine
                        if ($check) {
                            $data['products'] = implode('/', $products);
                            $replace = [
                                $data['date_added'],
                                $data['prescription_times'],
                                $data['daily_take'],
                                $data['diagnostic'],
                                $data['doctoradvice'],
                                $data['customer'],
                                $data['gender'],
                                $data['age'],
                                $data['total'],
                                $data['status'],
                                $data['doctor'],
                                $data['profession'],
                                $data['products'],
                            ];

                            // Match Prescription Data
                            $result['InterfaceStr'] = str_ireplace($search, $replace, $data['format']);

                            $json['prescriptions'][$pid] = $prescription;
                            $json['prescriptions'][$pid]['products'] = $data['products'];
                            $json['prescriptions'][$pid]['InterfaceStr'] = $result['InterfaceStr'];

                            $count_success++;

                            // Check send prescriptions call is incorrect, thrown an error
                            try {
                                //$client = new SoapClient($function_url, $options);
                                $response = $client->InterfaceFormat($result);
                                if (!empty($response->InterfaceFormatResult)) {
                                    $format_result = explode(',', $response->InterfaceFormatResult);
                                    $result['response'] = (int)$format_result['2'];
                                    $msg = $format_result['1'];
                                    // Check if webservices response success, return success else thrown an error
                                    if (!empty($result['response'])) {
                                        $json['prescriptions'][$pid]['response'] = $result['response'];
                                        $json['prescriptions'][$pid]['send_to_ngp'] = 1;
                                        $json['success'] = 'Prescriptions successfully sent to NGP Machine ! #' . $result['response'] . ' ' . $msg;
                                    } else {
                                        $json['prescriptions'][$pid]['response'] = $result['response'];
                                        $json['prescriptions'][$pid]['send_to_ngp'] = 0;
                                        $json['success'] = 'There are some items of prescription #' .  $prescription['prescription_id'] . ' not exists in NGP machine ! ' . $msg;
                                    }
                                } else {
                                    $json['prescriptions'][$pid]['response'] = $response;
                                    $json['prescriptions'][$pid]['send_to_ngp'] = 0;
                                    $json['prescriptions'][$pid]['error'] = 'Failed! Your send prescriptionsc #' . $prescription['prescription_id'] . ' format is not correct. Please contact ETCM techinician!';
                                }
                            } catch (SoapFault $client) {
                                $json['error'] = 'Erorrs. Send Prescriptions webservices function name is incorrect ! Contact ETCM technician !';
                            }
                        }

                        $product_errors .= !empty($json['prescriptions'][$pid]['error']) ? $json['prescriptions'][$pid]['error'] : '';
                    }
                }

                // Check if no have any granule prescriptions, thrown an error
                if (empty($count_granule)) {
                    throw new Exception('Error! The prescriptions are not granule ! Cannot sent to NGP machine !');
                }

                // Check if no have any granule prescriptions successfully sent to NGP machine, thrown an error
                if (empty($count_success)) {
                    throw new Exception($product_errors);
                } else {
                    $this->printJson($json);
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
            $json['error'] = $message;
            $this->printJson($json);
        }
    }

    public function sendMedicalRecordToNGPMachine() {
        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/herbal');
        $this->load->model('herbal/new_herbal');

        $json = [];
        $json['error'] = '';
        $json['prescriptions'] = [];

        $send = true;
        if (!empty($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        } else if (!empty($this->request->post['herbal_id'])) {
            $herbal_id = $this->request->post['herbal_id'];
        } else {
            $herbal_id = 0;
        }

        $order_id  = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;

        // Setup Soap Client INI settings
        ini_set('soap.wsdl_cache_enabled', 0);
        ini_set('soap.wsdl_cache_ttl', 0);
        ini_set('default_socket_timeout', 15);

        //options for ssl in php 5.6.5
        $opts = array(
            'ssl' => array(
                'ciphers' => 'RC4-SHA',
                'verify_peer' => false,
                'verify_peer_name' => false
            )
        );

        // Setup Soap Client options
        $options = array(
            'cache_wsdl' => WSDL_CACHE_NONE,
            'connection_timeout' => 5,
            'trace' => false,
            'encoding' => 'UTF-8',
            'exceptions' => false,
            'verifypeer' => false,
            'verifyhost' => false,
            'soap_version' => SOAP_1_2,
            'exceptions' => true,
        );

        try {
            // Check herbal is empty or not
            if (empty($herbal_id)) {
                $send = false;
                throw new Exception('Error! herbal id parameter are empty ! Please resend again !');
            }

            // Check herbal info is valid or invalid, throw error if invalid
            $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
            if (empty($herbal_info)) {
                $send = false;
                throw new Exception('Error! Invalid herbal id parameter ! Please resend again !');
            }

            // Check service type is granule
            if ($herbal_info['herb_service_type'] != 'granule') {
                $send = false;
                throw new Exception('Error! The prescriptions is not granule ! Cannot send to NGP Machine !');
            }

            // Check ngp webservices exists, if not exists throw an error
            if (empty($this->config->get('config_ngp_webservices_connection_url'))) {
                $send = false;
                $json['error'] = 'Error! The NGP machine connection havent setup ! Please conatact ETCM techinicain !';
            }

            // Check ngp webservices is enable, if disable throw an error
            if (empty($this->config->get('config_ngp_webservices_status'))) {
                $send = false;
                throw new Exception('Error! The NGP machine connection is disabled and you are not allowed to connect ! Please conatact ETCM techinicain !');
            }

            // Check ngp webservices send prescription connection setup, if havent throw an error
            if (empty($this->config->get('config_ngp_webservices_send_prescription_url')) || empty($this->config->get('config_ngp_webservices_send_prescription_location_url'))) {
                $send = false;
                throw new Exception('Error! The NGP machine send prescription connection havent setup ! Please conatact ETCM techinicain !');
            }

            $function_url = $this->config->get('config_ngp_webservices_send_prescription_url');
            //$function_location_url = $this->config->get('config_ngp_webservices_send_prescription_location_url');

            // Check ngp webservices connection is turn on, if turn off throw an error 
            $url = $this->config->get('config_ngp_webservices_connection_url');
            if (empty($this->checkConnection($url))) {
                $send = false;
                throw new Exception('Error! The NGP machine is not turn on ! Please turn on before send prescriptions to NGP machine !');
            }

            try {
                // Check ngp webservices validation, if invalid, throw and error.
                $client = new SoapClient($function_url, $options);
            } catch (SoapFault $client) {
                $send = false;
                $json['error'] = 'Error! Invalid NGP machine connection setup ! Please contact ETCM technician !';
                $this->printJson($json);
            }

            $prescriptions = $this->model_herbal_new_herbal->getHerbalPrescription($herbal_id);
            $products  = $this->model_herbal_herbal->getHerbalProducts($herbal_id);
            $products2 = $this->model_herbal_herbal->getHerbalProducts2($herbal_id);
            $times     = $this->model_herbal_herbal->getHerbalDailyTimes($herbal_id);
            $take      = $this->model_herbal_herbal->getHerbalDailyTake($herbal_id);

            // Format Product List
            $formatted_products  = array_column($products, 'product');
            $formatted_products2 = array_column($products2, 'product');

            // Implode Products
            $implode_products  = implode('/', $formatted_products);
            $implode_products2 = implode('/', $formatted_products2);

            // Prescription Format
            $format = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';
            $format2 = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';

            $search = [
                '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
                '{gender}', '{age}', '{total}', '{status}', '{doctor}', '{profession}', '{products}'
            ];
            $search2 = [
                '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
                '{gender}', '{age}', '{total}',  '{status}', '{doctor}', '{profession}', '{products}'
            ];

            // Get All Data
            $data = [
                'order_id'           => $order_id,
                'date_added'         => (!empty($herbal_info['date_added'])) ? date('Ymd', strtotime($herbal_info['date_added'])) : date('Ymd'),
                'invoice_prefix'     => (!empty($herbal_info['invoice_prefix'])) ? $herbal_info['invoice_prefix'] : date('Ymd'),
                'prescription_id'    => ($herbal_info['clinical_sale_id']) ? $herbal_info['clinical_sale_id'] : 0,
                'currency_format'    => 'RM',
                'prescription_times' => !empty($times['times']) ? $times['times'] : 3,
                'daily_take'  => !empty($taken) ? '一日' . $taken . '次' : '一日1次',
                'diagnostic'         => str_replace(',', ' ', $herbal_info['diagnostic'] . ' ' . $herbal_info['pulse'] . ' ' . $herbal_info['disease'] . ' ' . $herbal_info['symptom']),
                'doctoradvice'       => str_replace(',', ' ', $herbal_info['doctoradvice'] . ' ' . $herbal_info['treatment'] . ' ' . $herbal_info['acupuncture'] . ' ' . $herbal_info['remark']),
                'service_type'       => empty($herbal_info['herb_service_type']) ? $herbal_info['herb_service_type'] : 'herbs',
                'status'             => 2,
                'customer'           => $herbal_info['firstname'] . $herbal_info['lastname'],
                'gender'             => ($herbal_info['gender'] == 1) ? '男' : '女',
                'age'                => ($herbal_info['age']) ? $herbal_info['age'] : 0,
                'total'              => ($herbal_info['total_d_gst']) ? $herbal_info['total_d_gst'] : 0,
                'doctor'             => $herbal_info['doctor_firstname'] . $herbal_info['doctor_lastname'],
                'profession'         => $herbal_info['doctor_firstname'],
                'products'           => $implode_products,
                'products2'          => $implode_products2,
            ];

            $replace = [
                $data['date_added'], $data['prescription_times'], $data['daily_take'], $data['diagnostic'], $data['doctoradvice'], $data['customer'], $data['gender'], $data['age'], $data['total'], $data['status'], $data['doctor'], $data['profession'], $data['products'],
            ];

            $replace2 = [
                $data['date_added'], $data['prescription_times'], $data['daily_take'], $data['diagnostic'], $data['doctoradvice'], $data['customer'], $data['gender'], $data['age'], $data['total'], $data['status'], $data['doctor'], $data['profession'], $data['products2'],
            ];

            $data['prescriptionFormat'] = str_ireplace($search2, $replace2, $format);
            $data['InterfaceStr']       = str_ireplace($search, $replace, $format);

            // Check prescriptions list, if empty, send an error
            if (empty($prescriptions)) {
                $send = false;
                throw new Exception('Error! The prescription is empty! Cannot send to NGP Machine ! ');
            }

            // Check products list, if empty, send an error
            if (empty($products)) {
                $send = false;
                throw new Exception('Error! The products list is empty! Cannot send to NGP Machine ! ');
            }

            // If cannot send prescriptions to NGP machine, send an error.
            if (empty($send)) {
                $send = false;
                throw new Exception('Error! The system error ! Please contact ETCM technician !');
            }

            if (!empty($send)) {
                try {
                    $InterfaceStr['InterfaceStr']  = $data['InterfaceStr'];
                    $response = $client->InterfaceFormat($InterfaceStr);
                    if (!empty($response->InterfaceFormatResult)) {
                        $format_result = explode(',', $response->InterfaceFormatResult);
                        $result['response'] = (int)$format_result['2'];
                        $msg = $format_result['1'];
                        // Check if webservices response success, return success else thrown an error
                        if (!empty($result['response'])) {
                            $json['response'] = $result['response'];
                            $json['send_to_ngp'] = 1;
                            $json['success'] = 'Prescriptions successfully sent to NGP Machine ! #' . $result['response'] . ' ' . $msg;
                        } else {
                            $json['response'] = $result['response'];
                            $json['send_to_ngp'] = 0;
                            $json['success'] = 'There are some items of prescription #' . (int)$herbal_id . ' not exists in NGP machine ! ' . $this->db->escape($msg);
                        }
                    } else {
                        $json['error'] = 'Failed! Your send medical record #' . (int)$herbal_id . ' format is not correct. Please contact ETCM techinician!';
                    }
                } catch (SoapFault $client) {
                    $json['error'] = 'Erorrs. Send Prescriptions webservices function name is incorrect ! Contact ETCM technician !';
                }
            }

            $this->printJson($json);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $json['error'] = $message;
            $this->printJson($json);
        }
    }

    public function sendToNGPMachine($data) {
        $this->load->language('herbal/herbal');
        $this->load->language('herbal/ngp_prescription');
        $this->load->model('herbal/ngp_prescription');
        $this->load->model('herbal/herbal');
        $result = [];
        $herbal_id = isset($this->request->get['product_to_service_id']) ? $this->request->get['product_to_service_id'] : 0;
        $details = $this->model_herbal_ngp_prescription->getProductToServiceDetails($herbal_id);

        if (!empty($details)) {
            ini_set('soap.wsdl_cache_enabled', 0);
            ini_set('soap.wsdl_cache_ttl', 0);
            ini_set('default_socket_timeout', 15);

            //options for ssl in php 5.6.5
            $opts = array(
                'ssl' => array(
                    'ciphers' => 'RC4-SHA',
                    'verify_peer' => false,
                    'verify_peer_name' => false
                )
            );

            $options = array(
                'cache_wsdl' => WSDL_CACHE_NONE,
                'connection_timeout' => 15,
                'trace' => false,
                'encoding' => 'UTF-8',
                'exceptions' => false,
                'verifypeer' => false,
                'verifyhost' => false,
                'soap_version' => SOAP_1_2,
            );

            $url = "http://eciwo.dyndns.org:8089";
            if (!empty($this->checkConnection($url))) {
                $url = "http://eciwo.dyndns.org:8089/Prescription.asmx?WSDL";
                $client = new SoapClient($url);

                $client->__setLocation('http://eciwo.dyndns.org:8089/Prescription.asmx');

                $interfaceStr = !empty($details['interfaceFormat']) ? $details['interfaceFormat'] : '';

                $data = [
                    'InterfaceStr' => $interfaceStr,
                    //'InterfaceStr' => '3, 7, 一日三次, 早�?�, 肾虚阳痿, 林凯文, 男, 24, 452.40, Mr.黄医师, 皮肤科; A001, 30/A002, 20',
                ];

                $response = $client->InterfaceFormat($data);

                $result['id'] = $herbal_id;
                if (!empty($response->InterfaceFormatResult)) {
                    $result['herbal_id'] = !empty($details['prescription_id']) ? $details['prescription_id'] : 0;
                    $format_result = explode(',', $response->InterfaceFormatResult);
                    $result['response'] = (int)$format_result['2'];
                    $msg = $format_result['1'];
                    if (!empty($result['response'])) {
                        $result['status'] = 15;
                        $result['msg'] = 'Success: prescription id #' . $msg . ' successfully send to machine';
                        $this->model_herbal_ngp_prescription->updateStatus($result);
                        $this->model_herbal_ngp_prescription->updateHerbalStatus($result);
                        $this->session->data['success'] = $this->language->get('text_success');
                        $this->session->data['warning'] = '';
                        $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                    } else {
                        $result['status'] = 1;
                        $result['msg'] = 'Failed: caused by - ' . $msg;
                        $this->model_herbal_ngp_prescription->updateStatus($result);
                        $this->session->data['warning'] = 'Warning: prescription #' . $result['id'] .  ' failed to send into machine! Please do checking';
                        $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                    }
                } else {
                    $this->session->data['warning'] = 'Warning: prescription #' . $result['id'] .  ' failed to send into machine! Please do checking';
                    $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
                }
            } else {
                $this->session->data['warning'] = 'Warning: The NGP Machine internet connection is not connected !';
                $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
            }
        } else {
            $this->session->data['warning'] = 'Warning: prescription #' . $result['id'] .  ' failed to send into machine! Please do checking !';
            $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
        }
    }

    public function checkConnection($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, true);    // we want headers
        curl_setopt($ch, CURLOPT_NOBODY, true);    // we don't need body
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        $output = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($httpcode == 200) {
            return true;
        } else {
            return false;
        }
    }

    public function setCancel() {
        $this->load->model('herbal/ngp_prescription');

        if (isset($this->request->get['product_to_service_id'])) {
            $data['id'] = $this->request->get['product_to_service_id'];
        } else {
            $data['id'] = 0;
        }

        $data['response'] = !empty($this->request->get['ngp_machine']) ? $this->request->get['ngp_machine'] : 0;

        $data['status'] = 7;
        $data['msg'] = 'Prescription #' . $data['id'] . ' have been cancelled!';

        $this->model_herbal_ngp_prescription->updateStatus($data);

        $this->session->data['success'] = $this->language->get('text_success');
        $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
    }

    public function setComplete() {
        $this->load->model('herbal/ngp_prescription');

        if (isset($this->request->get['product_to_service_id'])) {
            $data['id'] = $this->request->get['product_to_service_id'];
        } else {
            $data['id'] = 0;
        }

        $data['response'] = !empty($this->request->get['ngp_machine']) ? $this->request->get['ngp_machine'] : 0;

        $data['status'] = 5;
        $data['msg'] = 'Success: prescription #' . $data['id'] . ' have complete dispensing !';

        $this->model_herbal_ngp_prescription->updateStatus($data);

        $this->session->data['success'] = $this->language->get('text_success');
        $this->response->redirect($this->url->link('herbal/ngp_prescription', 'user_token=' . $this->session->data['user_token'], 'SSL'));
    }

    public function printA5() {
        $this->load->language('herbal/ngp_prescription');

        $this->load->model('herbal/ngp_prescription');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['direction'] = $this->language->get('direction');
        $data['lang'] = $this->language->get('code');

        $data['text_doctor_name'] = $this->language->get('text_doctor_name');
        $data['text_customer_name'] = $this->language->get('text_customer_name');
        $data['text_customer_gender'] = $this->language->get('text_customer_gender');
        $data['text_customer_age']  = $this->language->get('text_customer_age');
        $data['text_year']  = $this->language->get('text_year');

        $data['text_diagnostic'] = $this->language->get('text_diagnostic');
        $data['text_doctoradvice'] = $this->language->get('text_doctoradvice');
        $data['text_service_type'] = $this->language->get('text_service_type');

        $data['text_service_type']  = $this->language->get('text_service_type');
        $data['text_day'] = $this->language->get('text_day');
        $data['text_times_per_day'] = $this->language->get('text_times_per_day');
        $data['text_prescription'] = $this->language->get('text_prescription');

        $product_to_service_id = isset($this->request->get['product_to_service_id']) ? $this->request->get['product_to_service_id'] : 0;

        $service_data = $this->model_herbal_ngp_prescription->getNGPData($product_to_service_id);

        $data['customer_name'] = $service_data['customer'];
        $data['doctor_name'] = $service_data['doctor'];
        $data['gender'] = $service_data['gender'];
        $data['age'] = $service_data['age'];

        $data['diagnostic'] = $service_data['diagnostic'];
        $data['doctoradvice'] = $service_data['doctoradvice'];
        $data['service_type'] = $service_data['service_type'];

        $data['product']  = $service_data['products'];

        $data['times_per_day'] = $service_data['daily_take'];
        $data['day'] = $service_data['prescription_times'];

        $data['current_language'] = $this->session->data['language'];

        $data['products'] = [];
        $data['totals'] = [];

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';


            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;

            $this->response->setOutput($pdf->pdf($this->load->view('herbal/ngp_prescription_pdf.tpl', $data), $pdf_file_name, $page_size, $show));
        }


        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('herbal/ngp_prescription_pdf.tpl', $data));
        }
    }
}
