<?php

class ControllerHerbalNewHerbal extends Controller {

    private $error = array();

    public function index() {

        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');
        $this->load->model('sale/order');

        unset($this->session->data['clinical_sale_products']);
        unset($this->session->data['clinical_sale_prescription']);
        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->installUpdateNewRelease();

        $this->getList(TRUE);
    }

    public function addCustomer() {
        $this->document->addStyle('view/stylesheet/new_herbal_add.css?v=' . time());

        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('herbal/new_herbal');
        $this->load->model('user/user');
        $this->load->model('customer/customer');

        $user_id = $this->session->data['user_id'];
        $user_position = !empty($this->getUserPosition($user_id)) ? $this->getUserPosition($user_id) : 1;

        //Check if Get the customer_id from the GET request url 
        if (!empty($this->request->get['customer_id']) && !empty($this->request->get['doctor_id'])) {
            $customer_info = $this->model_herbal_new_herbal->getCustomerbyid($this->request->get['customer_id']);
            $data['customer_id'] = $customer_info['customer_id'];

            $data['doctor_id'] = $this->request->get['doctor_id'];
            $doctor_info = $this->model_user_user->getUser($data['doctor_id']);

            $data['enable_consultation_price'] = $doctor_info['enable_consultation_price'];
            $data['consultationprice'] = $doctor_info['consultationprice'];

            $checkLastestMedicalRecord = $this->getLatestHerbalByCustomerId($data['customer_id']);
            //This function to avoid duplication of same customer have create two medical record
            if (!empty($checkLastestMedicalRecord)) {
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $passed_time = $checkLastestMedicalRecord;
                $current_time = date('Y-m-d H:i:s');

                $date_added = strtotime($passed_time);
                $date_now = strtotime($current_time);
                $diff = $date_now - $date_added;

                //Check the latest add new medical record time not less than 10 seconds
                //If less then 10 seconds redirect medical record list page
                //Else then add new medical record
                //This checking is to avoid duplication of add new medical record 
                if ($diff < 10) {
                    $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
                } else {
                    //Add new medical record
                    $herbal_id = $this->model_herbal_new_herbal->addHerbal($data);
                }
            } else {
                // Add new medical record
                $herbal_id = $this->model_herbal_new_herbal->addHerbal($data);
            }

            $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
            $invoice_prefix = $herbal_info['invoice_prefix'];
            $customer_name = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
            $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

            //Check if not empty the doctor, will send notification to the doctor
            if ($data['doctor_id'] != 0  && $herbal_id > 0) {
                /** Removed/Archieve */
                /*$notification_template = $this->config->get('config_gcm_new_herbal');
                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $customer_name = $herbal_info['firstname'] . ' ' . $herbal_info['lastname'];

                    $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
                    $invoice_prefix = $herbal_info['invoice_prefix'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_name
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $data['doctor_id'],
                        'type' => 2      // New herbal remedies type
                    );

                    $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($data['doctor_id']))
                            ->setData($data_gcm)
                            ->send();
                    }
                }*/
                $notification_data = [
                    'customer_id' => $data['customer_id'],
                    'herbal_id' => $herbal_id,
                    'doctor_id' => $data['doctor_id'],
                    'invoice_prefix' => $invoice_prefix,
                    'customer_name' => $customer_name,
                    'doctor_device' => $doctor_device
                ];
                //Send app notification to doctor
                $this->sendDoctorNotification($notification_data);
                //Send PopUP notification
                $this->sendSystemPopupNotification($notification_data);
            }


            $url = '';
            if (isset($herbal_id) && $herbal_id != 0) {
                $this->session->data['success'] = $this->language->get('text_success');
                $url .= '&herbal_id=' . $herbal_id;
            }

            //Check if role as doctor will auto redirect to medical record edit page else then redirect back to medical record list page
            if ($user_position == 1) {
                $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true));
            } else {
                $this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }
        }

        //Form submit function
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $customer_ic = !empty($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : '';
            $telephone = !empty($this->request->post['telephone']) ? $this->request->post['telephone'] : '';

            if (!empty($customer_ic)) {
                $customer_info = $this->model_herbal_new_herbal->customerExistsByIc($this->request->post['customer_ic']);
            }

            if (!empty($telephone)) {
                if (empty($customer_info)) {
                    $customer_info = $this->model_herbal_new_herbal->customerExistsByTelephone($this->request->post['telephone']);
                }
            }

            // Check if is new customer then add customer to database
            // Else check the existing customer have duplication add medical record frequently
            if (empty($customer_info)) {
                $data['customer_id'] = $this->model_herbal_new_herbal->addCustomer($this->request->post);
            } else {
                $data['customer_id'] = $customer_info['customer_id'];
                $checkLastestMedicalRecord = $this->getLatestHerbalByCustomerId($data['customer_id']);
                if (!empty($this->$checkLastestMedicalRecord)) {
                    date_default_timezone_set("Asia/Kuala_Lumpur");
                    $passed_time = $this->$checkLastestMedicalRecord;
                    $current_time = date('Y-m-d H:i:s');
                    $date_added = strtotime($passed_time);
                    $date_now = strtotime($current_time);
                    $diff = $date_now - $date_added;

                    if ($diff < 10) {
                        $this->response->redirect($this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'], true));
                    }
                }
            }

            $data['doctor_id'] = $this->request->post['doctor_id'];
            $doctor_info = $this->model_user_user->getUser($data['doctor_id']);

            $data['enable_consultation_price'] = $doctor_info['enable_consultation_price'];
            $data['consultationprice'] = $doctor_info['consultationprice'];

            //Add new medical record
            $herbal_id = $this->model_herbal_new_herbal->addHerbal($data);
            $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
            $invoice_prefix = $herbal_info['invoice_prefix'];
            $customer_name = $herbal_info['customer_name'];
            $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

            if ($data['doctor_id'] != 0 && $herbal_id > 0) {
                $notification_template = $this->config->get('config_gcm_new_herbal');
                /** Removed/Archieve */
                //Check if not empty the doctor, will send notification to the doctor
                /*if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $customer_data = $this->model_customer_customer->getCustomer($data['customer_id']);
                    $customer_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

                    $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
                    $invoice_prefix = $herbal_info['invoice_prefix'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_name
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $data['doctor_id'],
                        'type' => 2      // New herbal remedies type
                    );

                    $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_token($data['doctor_id']))
                            ->setData($data_gcm)
                            ->send();
                    }
                }*/
                $notification_data = [
                    'customer_id' => $data['customer_id'],
                    'herbal_id' => $herbal_id,
                    'doctor_id' => $data['doctor_id'],
                    'invoice_prefix' => $invoice_prefix,
                    'customer_name' => $customer_name,
                    'doctor_device' => $doctor_device
                ];
                //Send app notification to doctor
                $this->sendDoctorNotification($notification_data);
                //Send PopUP notification
                $this->sendSystemPopupNotification($notification_data);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            /** Removed/Archieve */
            /*$notification = new Notification($this->registry);
            $notification_data = [
                'herbal_id' => $herbal_id,
                'invoice_prefix' => $invoice_prefix,
                'customer_name' => $customer_name
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('new_clinical_sale_notification', $notification_data);
            }*/

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_transaction_from'])) {
                $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
            }

            if (isset($this->request->get['filter_transaction_to'])) {
                $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_firstname'])) {
                $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
            }


            if (isset($this->request->get['filter_payment_status'])) {
                $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($herbal_id) && $herbal_id != 0) {
                $url .= '&herbal_id=' . $herbal_id;
            }

            if ($user_position == 1) {
                $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
            } else {
                $this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
            }
        }

        $this->customer();
    }

    public function customer() {
        //Get the lastest medical number from transaction number module
        //$text_invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        //Get latest customer card number from transaction number module
        //$placeholder_customer_card = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        //Get the latest invoice prefix number
        $data['new_customer_form_javascript_link'] = 'view/javascript/herbal/new_customer_form.js?v=' . time();

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }


        $data['placeholder_customer_card'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $store_id));
        $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/new_herbal', 'store' => $store_id));
        $data['doctors'] = $this->model_user_user->getUserByPostion(2);

        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['user_token'] = $this->session->data['user_token'];

        $this->load->model('localisation/country');
        $data['countries'] = $this->model_localisation_country->getCountries();

        $this->load->model('customer/customer_group');
        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        //Set default nationality, marital status, race, religion
        $data['nationality'] = 'MALAYSIANS';
        $data['marital_status'] = 1;
        $data['religion_id'] = 2;
        $data['race_id'] = 2;
        //Build Races Data 
        $data['races'][] = array(
            'race_id' => 1,
            'name' => $this->language->get('text_malay'),
        );
        $data['races'][] = array(
            'race_id' => 2,
            'name' => $this->language->get('text_chinese'),
        );
        $data['races'][] = array(
            'race_id' => 3,
            'name' => $this->language->get('text_indian'),
        );
        $data['races'][] = array(
            'race_id' => 4,
            'name' => $this->language->get('text_race_indigenous_ethic_group'),
        );
        $data['races'][] = array(
            'race_id' => 5,
            'name' => $this->language->get('text_race_foreigner'),
        );

        //Build Religion Data
        $data['religions'][] = array(
            'religion_id' => 1,
            'name' => $this->language->get('text_islam'),
        );
        $data['religions'][] = array(
            'religion_id' => 2,
            'name' => $this->language->get('text_buddhism'),
        );
        $data['religions'][] = array(
            'religion_id' => 3,
            'name' => $this->language->get('text_hinduism'),
        );
        $data['religions'][] = array(
            'religion_id' => 4,
            'name' => $this->language->get('text_christian'),
        );

        //Set the error message
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_customer_ic'] = isset($this->error['customer_ic']) ? $this->error['customer_ic'] : '';
        $data['error_firstname'] = isset($this->error['firstname']) ? $this->error['firstname'] : '';
        $data['error_lastname'] = isset($this->error['lastname']) ? $this->error['lastname'] : '';
        $data['error_dob'] = isset($this->error['dob']) ? $this->error['dob'] : '';
        $data['error_telephone'] = isset($this->error['telephone']) ? $this->error['telephone'] : '';
        $data['error_password'] = isset($this->error['password']) ? $this->error['password'] : '';
        $data['error_confirm'] = isset($this->error['confirm']) ? $this->error['confirm'] : '';
        $data['error_address'] = isset($this->error['address']) ? $this->error['address'] : '';
        $data['error_doctor'] = isset($this->error['doctor_id']) ? $this->error['doctor_id'] : '';

        //Build the query link
        $url = '';
        isset($this->request->get['filter_date_from']) ? $url .= '&filter_date_from=' . $this->request->get['filter_date_from'] : '';
        isset($this->request->get['filter_date_to']) ? $url .= '&filter_date_to=' . $this->request->get['filter_date_to'] : '';
        isset($this->request->get['filter_transaction_from']) ? $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'] : '';
        isset($this->request->get['filter_transaction_to']) ? $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'] : '';
        isset($this->request->get['filter_customer_ic']) ? $url .= '&filter_customer_ic=' . urlencode(html_entity_decode($this->request->get['filter_customer_ic'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_customer_card']) ? $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_customer_firstname']) ? $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8')) : '';
        isset($this->request->get['filter_payment_status']) ? $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'] : '';
        isset($this->request->get['filter_status']) ? $url .= '&filter_status=' . $this->request->get['filter_status'] : '';
        isset($this->request->get['sort']) ? $url .= '&sort=' . $this->request->get['sort'] : '';
        isset($this->request->get['order']) ? $url .= '&order=' . $this->request->get['order'] : '';
        isset($this->request->get['page']) ? $url .= '&page=' . $this->request->get['page'] : '';

        //Build breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        //Set the action link
        $data['action'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['cancel'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);

        //Build Custom Fields Data
        $this->load->model('customer/custom_field');
        $data['custom_fields'] = array();
        $custom_fields = $this->model_customer_custom_field->getCustomFields();
        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        //Set the POST request data
        $data['customer_group_id'] = isset($this->request->post['customer_group_id']) ? $this->request->post['customer_group_id'] : $this->config->get('config_customer_group_id');
        $data['firstname'] = isset($this->request->post['firstname']) ? $this->request->post['firstname'] : '';
        $data['lastname'] = isset($this->request->post['lastname']) ? $this->request->post['lastname'] : '';
        $data['home'] = isset($this->request->post['home']) ? $this->request->post['home'] : '';
        $data['gender'] = isset($this->request->post['gender']) ? $this->request->post['gender'] : 1;
        $data['customer_card'] = isset($this->request->post['customer_card']) ? $this->request->post['customer_card'] : '';
        $data['customer_ic'] = isset($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : '';
        $data['customer_id'] = isset($this->request->post['customer_id']) ? $this->request->post['customer_id'] : 0;
        $data['dob'] = isset($this->request->post['dob']) ? $this->request->post['dob'] : '';
        $data['email'] = isset($this->request->post['email']) ? $this->request->post['email'] : '';
        $data['telephone'] = isset($this->request->post['telephone']) ? $this->request->post['telephone'] : '';
        $data['telephone2'] = isset($this->request->post['telephone2']) ? $this->request->post['telephone2'] : '';
        $data['occupation'] = isset($this->request->post['occupation']) ? $this->request->post['occupation'] : '';
        $data['nationality'] = isset($this->request->post['nationality']) ? $this->request->post['nationality'] : 'MALAYSIANS';
        $data['allergic'] = isset($this->request->post['allergic']) ? $this->request->post['allergic'] : '';
        $data['diagnostic_history'] = isset($this->request->post['diagnostic_history']) ? $this->request->post['diagnostic_history'] : '';
        $data['fax'] = isset($this->request->post['fax']) ? $this->request->post['fax'] : '';
        $data['doctor_id'] = isset($this->request->post['doctor_id']) ? $this->request->post['doctor_id'] : '';

        // var_dump($this->request->post);
        // die();
        $data['account_custom_field'] = isset($this->request->post['custom_field']) ? $this->request->post['custom_field'] : [];
        $data['newsletter'] = isset($this->request->post['newsletter']) ? $this->request->post['newsletter'] : '';
        $data['status'] = isset($this->request->post['status']) ? $this->request->post['status'] : true;
        $data['approved'] = isset($this->request->post['approved']) ? $this->request->post['approved'] : true;
        $data['safe'] = isset($this->request->post['safe']) ? $this->request->post['safe'] : 0;
        $data['password'] = isset($this->request->post['password']) ? $this->request->post['password'] : '';
        $data['confirm'] = isset($this->request->post['confirm']) ? $this->request->post['confirm'] : '';
        $data['addresses'] = isset($this->request->post['address']) ? $this->request->post['address'] : [];
        $data['address_id'] = isset($this->request->post['address_id']) ? $this->request->post['address_id'] : 0;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/new_customer_form', $data));
    }

    public function edit() {
        $this->document->addStyle('view/stylesheet/new_herbal_edit.css?v=' . time());

        $this->load->language('herbal/new_herbal');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('herbal/new_herbal');

        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addStyle('view/stylesheet/jAlert-v3.css');
        $this->document->addScript('view/javascript/jAlert-v3.js');
        $this->document->addScript('view/javascript/jAlert-functions.js');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');
        $this->document->addScript('view/javascript/herbal/jquery.form.js');

        $this->load->model('localisation/language');
        $this->load->language('herbal/new_patient_history_list');

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        unset($this->session->data['clinical_sale_products']);
        unset($this->session->data['clinical_sale_prescription']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);

        /** Can create a new validation or permission function to control it  */
        if (!$this->user->hasPermission('modify', 'herbal/new_herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
            $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
        }

        if (empty($this->request->get['herbal_id'])) {
            $this->error['warning'] = $this->language->get('error_permission');
            $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
        }
        /** Can create a new validation or permission function to control it  */

        $this->getForm();
    }

    public function delete() {
        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');
        $this->load->model('sale/order');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $herbal_id)
                $this->model_herbal_new_herbal->deleteHerbal($herbal_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        //getList
        $this->getList(TRUE);
    }

    public function getForm() {

        $herbal_id = (int)$this->request->get['herbal_id'];
        $this->session->data['clinicalsale_id'] = $herbal_id;
        $data['timenow'] = time();

        $data['herbal_form_javascript'] = 'view/javascript/herbal/new_herbal_form.js?v=' . time();

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['https_herbal_images'] = HTTPS_HERBAL_IMAGE;
        $data['model'] = '';
        $data['code'] = '';
        $data['sellingprice'] = '';
        $data['quantity'] = '';
        $data['error_code'] = '';
        $data['error_model'] = '';
        $data['error_model'] = '';
        $data['error_name'] = array();
        $data['error_model'] = array();

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_form'] = !isset($this->request->get['herbal_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $data['herbal_id'] = 0;
        }

        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['total_weight'] = '';
        $load_history = false;

        $this->load->model('user/user');

        $data['doctors'] = $this->model_user_user->getUserByPostion(2);
        $data['user_id'] = (int) $this->session->data['user_id'];

        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_new_herbal->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_new_herbal->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_new_herbal->getHerbalTotals($this->request->get['herbal_id']);
            // Get services from oc_service_form and oc_service_item
            $herbal_service = $this->model_herbal_new_herbal->getHerbalService2($this->request->get['herbal_id']);
            if (empty($herbal_service)) {
                /** Get services from oc_clinecal_service_item table 
                 * The purpose is because of if the clinical sale / herbal remedies not yet been `completed`, the services only will save into oc_clinecal_service_item as draft.
                 */
                $herbal_service = $this->model_herbal_new_herbal->getHerbalService($this->request->get['herbal_id']);
            }
            $herbal_image = $this->model_herbal_new_herbal->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_new_herbal->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_new_herbal->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
        }

        $history_type = !empty($this->request->get['history_type']) ? $this->request->get['history_type'] : 'all';
        if (isset($this->request->get['history_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            if ($history_type == 'diagnostic') {
                $herbal_pass_info = $this->model_herbal_new_herbal->getHerbal($this->request->get['history_id']);
                $herbal_prescription = [];
                $herbal_totals = [];
                $herbal_service = [];
                $herbal_image = [];
                $data['herbal_pass_images'] = [];
                $herbal_service_acupuncture = [];
                $load_history = true;
            } else {
                $herbal_pass_info = $this->model_herbal_new_herbal->getHerbal($this->request->get['history_id']);
                $herbal_prescription = $this->model_herbal_new_herbal->getHerbalPrescription($this->request->get['history_id']);
                $herbal_totals = $this->model_herbal_new_herbal->getHerbalTotals($this->request->get['history_id']);
                $herbal_service = $this->model_herbal_new_herbal->getHerbalService2($this->request->get['herbal_id']);
                if (empty($herbal_service)) {
                    /** Get services from oc_clinecal_service_item table 
                     * The purpose is because of if the clinical sale / herbal remedies not yet been `completed`, the services only will save into oc_clinecal_service_item as draft.
                     */
                    $herbal_service = $this->model_herbal_new_herbal->getHerbalService($this->request->get['herbal_id']);
                }
                $herbal_image = $this->model_herbal_new_herbal->getImage($this->request->get['history_id']);
                $data['herbal_pass_images'] = $this->model_herbal_new_herbal->getHerbalImages($herbal_pass_info['customer_id'], $this->request->get['history_id']);
                $herbal_service_acupuncture = $this->model_herbal_new_herbal->getHerbalServiceAcupuncture($this->request->get['history_id']);
                $load_history = true;
            }
        }

        $this->session->data['service_type'] = 'herbs';
        $this->session->data['date_modified'] = $this->model_herbal_new_herbal->getHerbalDateModified($this->request->get['herbal_id']);
        $this->load->model('herbal/new_herbal');
        $this->load->model('customer/customer');
        if ($herbal_id_info) {
            $user_details = $this->model_user_user->getUser((int) $herbal_id_info['doctor_id']);
            $user_price = $user_details['consultationprice'];

            $data['doctor_id'] = $herbal_id_info['doctor_id'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['customer_name'] = $herbal_id_info['customer_name'];
            $data['firstname'] = $herbal_id_info['firstname'];
            $data['lastname'] = $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['sales_date'] = $herbal_id_info['sales_date'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']) . ' ' . $this->language->get('text_age');
            $address_1 = !empty($herbal_id_info['address_1']) ? $herbal_id_info['address_1'] : '';
            $address_2 = !empty($herbal_id_info['address_2']) ? $herbal_id_info['address_2'] : '';
            $city = !empty($herbal_id_info['city']) ? $herbal_id_info['city'] : '';
            $postcode = !empty($herbal_id_info['postcode']) ? $herbal_id_info['postcode'] : '';
            $country_name = !empty($herbal_id_info['country_name']) ? $herbal_id_info['country_name'] : '';
            $zone_name = !empty($herbal_id_info['zone_name']) ? $herbal_id_info['zone_name'] : '';

            $data['payorder'] = $this->url->link('pos/pos', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $herbal_id_info['customer_id'], true);

            $customer_address = $address_1 . ' ' . $address_2 . ' ' . $city . ' ' . $postcode . ' ' . $zone_name . ', ' . $country_name;
            $data['customer_address'] = $customer_address;
            $data['occupation'] = $herbal_id_info['occupation'];
            $data['diagnostic_history'] = $herbal_id_info['diagnostic_history'];
            $data['allergic'] = $herbal_id_info['allergic'];
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['addresses'] = $this->model_herbal_new_herbal->getAddresses($herbal_id_info['customer_id']);
            $data['address_id'] = $herbal_id_info['shipping_address_id'];
            $this->session->data['shipping_address'] = $this->model_herbal_new_herbal->getAddress($herbal_id_info['shipping_address_id']);
            $data['remark'] = $herbal_id_info['remark'];
            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];
            $data['user_price'] = $herbal_id_info['clinicalsale_concultation'] ? $herbal_id_info['clinicalsale_concultation'] : $user_price;
            $data['customer_group_id'] = $herbal_id_info['customer_group_id'];
            $data['enable_doctorprice'] = isset($herbal_id_info['collect_consultation_price']) ? $herbal_id_info['collect_consultation_price'] : $user_details['enable_consultation_price'];

            if (!empty($user_details['consultationprice'])) {
                $data['doctor_consultation_price'] = $user_details['consultationprice'];
            } else {
                $data['doctor_consultation_price'] = '0.00';
            }

            if (empty($data['enable_doctorprice'])) {
                $data['user_price'] = $herbal_id_info['total'];
            } else {
                $data['user_price'] = $user_details['consultationprice'];
            }

            $customer_id = $data['customer_id'];
            $customer_filter = new StdClass();
            $customer_filter->customer_id = $customer_id;
            $customer_filter->clinical_sale_id = $herbal_id_info['clinical_sale_id'];
            $customer_filter->pagination_page = !empty($customer_filter->pagination_page) ? $customer_filter->pagination_page : 1;
            $customer_filter->pagination_entry = !empty($customer_filter->pagination_entry) ? $customer_filter->pagination_entry : $this->config->get('config_limit_admin');
            $customer_filter->pagination_offset = ($customer_filter->pagination_page - 1) * $customer_filter->pagination_entry;
            $herbal_history = $this->model_herbal_new_herbal->getPatientMedicalRecordList($customer_filter);

            $data['herbal_history_info'] = [];

            if (!empty($herbal_history)) {
                foreach ($herbal_history as $pid => $ps_list) {
                    $diagnostic_text = [];
                    $pescription_details = $this->model_herbal_new_herbal->getPrescriptionDetails($ps_list['clinical_sale_id']);

                    if (!empty($ps_list['diagnostic'])) {
                        $diagnostic_text[] = $ps_list['diagnostic'];
                    }

                    if (!empty($ps_list['doctoradvice'])) {
                        $diagnostic_text[] = $ps_list['doctoradvice'];
                    }

                    if (!empty($ps_list['pulse'])) {
                        $diagnostic_text[] = $ps_list['pulse'];
                    }

                    if (!empty($ps_list['disease'])) {
                        $diagnostic_text[] = $ps_list['disease'];
                    }

                    if (!empty($ps_list['treatment'])) {
                        $diagnostic_text[] = $ps_list['treatment'];
                    }

                    if (!empty($ps_list['acupuncture'])) {
                        $diagnostic_text[] = $ps_list['acupuncture'];
                    }

                    if (!empty($ps_list['symptom'])) {
                        $diagnostic_text[] = $ps_list['symptom'];
                    }

                    if (!empty($ps_list['remark'])) {
                        $diagnostic_text[] = $ps_list['remark'];
                    }

                    $service_items = [];
                    $service_items_info = $this->model_herbal_new_herbal->getHerbalService2($ps_list['clinical_sale_id']);
                    $service_items_info = empty($service_info) ? $this->model_herbal_new_herbal->getHerbalService($ps_list['clinical_sale_id']) : [];

                    if (!empty($service_items_info)) {
                        $total_service_count = 1;
                        foreach ($service_items_info as $key => $sii) {
                            $physician_info    = !empty($ps_list['doctor_id']) ? $this->model_herbal_new_herbal->getUserInfo($sii['staffincharge']) : [];
                            $physician_name   = !empty($physician_info['name']) ? $physician_info['name'] : '';
                            $service_items[] = [
                                'count' => $key + 1,
                                'servicename' => $sii['servicename'],
                                'serviceminutes' => $sii['serviceminutes'],
                                'doctor_name' =>  $physician_name,
                                'price' => $this->currency->format($sii['price'], $this->config->get('config_currency'))
                            ];
                            $total_service_count++;
                        }
                    }

                    $diagnostic_text = implode(', ', $diagnostic_text);

                    $doctor_info    = !empty($ps_list['doctor_id']) ? $this->model_herbal_new_herbal->getUserInfo($ps_list['doctor_id']) : [];
                    $doctor_name    = !empty($doctor_info['name']) ? $doctor_info['name'] : '';
                    $store_info     = !empty($ps_list['store_id']) ? $this->model_herbal_new_herbal->getStoreInfo($ps_list['store_id']) : [];
                    $store_name     = !empty($store_info['name']) ? $store_info['name'] : $this->config->get('config_name');

                    $payment_total = 0;
                    $medical_total = !empty($ps_list['total']) ? $ps_list['total'] : 0;
                    $service_total = $this->model_herbal_new_herbal->getServiceFormTotal($ps_list['clinical_sale_id']);
                    if (empty($service_total)) {
                        $service_total = $this->model_herbal_new_herbal->getHerbalServiceTotal($ps_list['clinical_sale_id']);
                    }
                    $payment_total = $medical_total + $service_total;

                    $medical_subtotal = 0;
                    $medicine_total = !empty($ps_list['clinicalsale_total']) ? $ps_list['clinicalsale_total'] : 0;
                    if ($ps_list['collect_consultation_price'] > 0) {
                        $consultation_price = $ps_list['clinicalsale_concultation'];
                    } else {
                        $consultation_price = 0;
                    }

                    $medical_subtotal = $consultation_price + $medicine_total;

                    $data['herbal_history_info'][] = [
                        'clinical_sale_id'   => $ps_list['clinical_sale_id'],
                        'invoice_prefix'     => $ps_list['invoice_prefix'],
                        'doctor_name'        => $doctor_name,
                        'store_name'         => $store_name,
                        'diagnostic'         => $ps_list['diagnostic'],
                        'doctoradvice'       => $ps_list['doctoradvice'],
                        'pulse'              => $ps_list['pulse'],
                        'disease'            => $ps_list['disease'],
                        'treatment'          => $ps_list['treatment'],
                        'acupuncture'        => $ps_list['acupuncture'],
                        'symptom'            => $ps_list['symptom'],
                        'clinicalsale_total' => $this->currency->format($medicine_total, $this->config->get('config_currency')),
                        'consultation_price' => $this->currency->format($consultation_price, $this->config->get('config_currency')),
                        'medical_subtotal'   => $this->currency->format($medical_subtotal, $this->config->get('config_currency')),
                        'medical_total'      => $this->currency->format($medical_total, $this->config->get('config_currency')),
                        'service_total'      => $this->currency->format($service_total, $this->config->get('config_currency')),
                        'payment_total'      => $this->currency->format($payment_total, $this->config->get('config_currency')),
                        'weight'             => $ps_list['weight'],
                        'date'               => date('D, Y-m-d', strtotime($ps_list['sales_date'])),
                        'prescription_list'  => $pescription_details,
                        'diagnostic_text'    => $diagnostic_text,
                        'service_items'      => $service_items,
                        'edit'               => $this->url->link('herbal/new_herbal/edit', 'user_token = ' . $this->session->data['user_token'] . '&herbal_id = ' . $ps_list['clinical_sale_id'], true),
                    ];
                }
            }

            if (!empty($herbal_pass_info)) {
                $data['herb_service_type'] = !empty($herbal_pass_info['herb_service_type']) ? $herbal_pass_info['herb_service_type'] : 'herbs';
            } else {
                $data['herb_service_type'] = !empty($herbal_id_info['herb_service_type']) ? $herbal_id_info['herb_service_type'] : 'herbs';
            }

            $this->cart->setHerbalServiceType($data['herb_service_type']);
            $this->session->data['service_type'] = $data['herb_service_type'];

            $this->load->model('localisation/order_status');

            $order_status_list = array(7, 5, 1, 18);

            foreach ($order_status_list as $order_status) {
                $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

                $data['order_statuses'][] = array(
                    'order_status_id' => $order_status_data['order_status_id'],
                    'name' => $order_status_data['name']
                );
            }

            $this->cart->addCustomerGroupId($herbal_id_info['customer_group_id']);
            $total_weight = 0;
            $grand_total_weight = 0;
            $total_weight_format = '0.00';
            $grand_total_weight_format = '0.00';
            $total_products_count = 0;
            if ($herbal_prescription) {
                foreach ($herbal_prescription as $prescription) {
                    $psp_times = !empty($prescription['times']) ? $prescription['times'] : 1;
                    $psp_cook = !empty($prescription['cook']) ? $prescription['cook'] : $this->getPreferredCookType();
                    $psp_taketype = !empty($prescription['taketype']) ? $prescription['taketype'] : $this->language->get('text_aftermeal');
                    $psp_day = !empty($prescription['day']) ? $prescription['day'] : 1;
                    $key = $this->cart->addPrescription(0, $prescription['name'], $prescription['prescription_id'], $psp_times, $psp_cook, $psp_taketype, $psp_day);
                    $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalProduct($prescription['clinical_sale_prescription_id']);
                    if ($herbal_peroduct) {
                        foreach ($herbal_peroduct as $product) {
                            if ($load_history) {
                                $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                                $product_price = !empty($product_info) ? $product_info['price'] : 0;
                            }

                            $quantity = $product['quantity'];
                            if ($data['herb_service_type'] == 'granule') {
                                $code_match_data = [
                                    'product_id' => $product['product_id'],
                                    'option_type' =>  'granule',
                                ];

                                $code_match_result = $this->getCodeMatch($code_match_data);

                                $drug_id = !empty($code_match_result['drug_id']) ? $code_match_result['drug_id'] : 0;
                                $granule_data = $this->getGranuleData($drug_id);

                                if (!empty($granule_data)) {
                                    $compressscale = $granule_data['compressscale'] ? $granule_data['compressscale'] : 1;
                                    $quantity = number_format(($quantity * $compressscale), 2);
                                }
                            }

                            $price = !empty($product_info['price']) ? $product_info['price'] : $product['price'];

                            $this->cart->addProduct($key, $product['product_id'], $quantity, $product['times'], $product['cook'], $product['taketype'], $product['day'], $price, $product['discount']);

                            $total_products_count++;

                            //$quantity = $product['quantity'];
                            $times = $product['times'];

                            $weight = $quantity * $times;

                            $total_weight += $quantity;
                            $grand_total_weight += $weight;

                            if ($product['weight_class_id']) {
                                $total_weight_format = $this->weight->format($total_weight, $product['weight_class_id']);
                                $grand_total_weight_format = $this->weight->format($grand_total_weight, $product['weight_class_id']);
                            }
                        }
                    } //end product
                } //loop prescription

                /* echo '<pre>';
                  print_r($herbal_peroduct);
                  echo '<pre>'; */

                $data['total_weight'] = array(
                    array(
                        'total_weight_name' => 'Total Weight',
                        'total_weight' => $total_weight_format
                    ),
                    array(
                        'total_weight_name' => 'Grand Total Weight',
                        'total_weight' => $grand_total_weight_format
                    )
                );
            } //end prescription
            $data['total_products_count'] = $total_products_count;

            $total_services_count = 0;
            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                    $total_services_count++;
                } //loop services
            } //end services
            $data['total_services_count'] = $total_services_count;

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            $this->cart->clearImage();
            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                } //loop image
            } //end image

            if (!empty($this->session->data['clinical_sale_prescription']) && !empty($this->session->data['clinical_sale_products'])) {
                $totalData = $this->getCartTotal();
            } else {
                $totalData = [];
            }

            $data['total_data'] = [];
            if (!empty($totalData)) {
                foreach ($totalData as $total) {
                    $data['total_data'][] = array(
                        'id' => 0,
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                        'value' => $total['value'],
                    );
                } //end looptotals

                $total_value = $total['value'] + $data['user_price'];
                $data['total_data'][] = array(
                    'id' => 1,
                    'code' => $total['code'],
                    'title' => $total['title'],
                    'text' => $this->currency->format($total_value, $this->config->get('config_currency')),
                    'value' => $total_value,
                );
            } else {
                foreach ($herbal_totals as $total) {
                    $data['total_data'][] = array(
                        'id' => $total['id'],
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                        'value' => $total['value'],
                    );
                } //end looptotals
            } //end totaldata
        } else {
            $this->response->setOutput($this->load->view('herbal/new_herbal_list', $data));
        }

        if (isset($this->request->get['history_id']) && $herbal_pass_info) {
            if ($history_type == 'prescription') {
                $data['diagnostic'] = ''; //$herbal_pass_info['diagnostic'];
                $data['doctoradvice'] = ''; //$herbal_pass_info['doctoradvice'];
                $data['pulse'] = ''; //$herbal_pass_info['pulse'];
                $data['disease'] = ''; //$herbal_pass_info['disease'];
                $data['treatment'] = ''; //$herbal_pass_info['treatment'];
                $data['acupuncture'] = ''; //$herbal_pass_info['acupuncture'];
                $data['symptom'] = ''; //$herbal_pass_info['symptom'];
                $data['remark'] = ''; //$herbal_pass_info['remark'];
                $data['user_price'] = ''; //$herbal_pass_info['clinicalsale_concultation'];
            } else {
                $data['diagnostic'] = $herbal_pass_info['diagnostic'];
                $data['doctoradvice'] = $herbal_pass_info['doctoradvice'];
                $data['pulse'] = $herbal_pass_info['pulse'];
                $data['disease'] = $herbal_pass_info['disease'];
                $data['treatment'] = $herbal_pass_info['treatment'];
                $data['acupuncture'] = $herbal_pass_info['acupuncture'];
                $data['symptom'] = $herbal_pass_info['symptom'];
                $data['remark'] = $herbal_pass_info['remark'];
                $data['user_price'] = $herbal_pass_info['clinicalsale_concultation'];
            }
        }

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $data['herbal_total'] = $this->getHerbalTotal($total_data);

        $data['cook_types'] = $this->model_herbal_new_herbal->getCookType();

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['customer_id'])) {
            $customer_id = $this->request->get['customer_id'];
        } else {
            $customer_id = null;
        }

        if (isset($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        } else {
            $herbal_id = null;
        }

        if (isset($this->request->get['filter_history_from'])) {
            $filter_history_from = $this->request->get['filter_history_from'];
        } else {
            $filter_history_from = null;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_history_to'])) {
            $filter_history_to = $this->request->get['filter_history_to'];
        } else {
            $filter_history_to = null;
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $filter_symptoms = $this->request->get['filter_symptoms'];
        } else {
            $filter_symptoms = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $filter_doctoradvice = $this->request->get['filter_doctoradvice'];
        } else {
            $filter_doctoradvice = null;
        }

        if (isset($this->request->get['filter_pulse'])) {
            $filter_pulse = $this->request->get['filter_pulse'];
        } else {
            $filter_pulse = null;
        }

        if (isset($this->request->get['filter_disease'])) {
            $filter_disease = $this->request->get['filter_disease'];
        } else {
            $filter_disease = null;
        }

        if (isset($this->request->get['filter_treatment'])) {
            $filter_treatment = $this->request->get['filter_treatment'];
        } else {
            $filter_treatment = null;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        } //url

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_history_from,
            'filter_date_to' => $filter_history_to,
            'filter_symptoms' => $filter_symptoms,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_doctoradvice' => $filter_doctoradvice,
            'filter_pulse' => $filter_pulse,
            'filter_disease' => $filter_disease,
            'filter_treatment' => $filter_treatment,
            'filter_acupuncture' => $filter_acupuncture,
            'customer_id' => $customer_id,
            'herbal_id' => $herbal_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ); //breadcrumbs
        //html products
        $data['images'] = array();
        $getPrescription = $this->getPrescriptionItems();
        $getService = $this->getServiceItems();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $getAcupunctureList = $this->getAcupunctureItems();
        $data['acupuncture_list'] = $getAcupunctureList['acupuncture_list'];

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        } //images
        // if status of cs is completed, cannot edit the price
        if ((isset($this->request->get['herbal_id'])) && ($data['status'] == '5')) {
            if (!empty($herbal_id_info['order_invoice_prefix'])) {
                $data['disabled'] = 1;
            } else {
                $data['disabled'] = 0;
            }
        } else {
            $data['disabled'] = 0;
        }

        // if cs status is pending, order invocie prefix is empty then can change the customer data
        if ((isset($this->request->get['herbal_id'])) && ($data['status'] == '1') && (empty($herbal_id_info['order_invoice_prefix']))) {
            $data['change_cus'] = 1;
            $data['button_change_customer'] = $this->language->get('button_change_customer');
            $data['change_customer'] = $this->url->link('herbal/new_herbal/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        } else {
            $data['change_cus'] = 0;
        }

        if ($data['status'] == '1') {
            $data['link_button_complete'] = $this->url->link('herbal/new_herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'] . '&order_status=5', true);
            $data['link_button_cancel'] = $this->url->link('herbal/new_herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'] . '&order_status=7', true);
        } else {
            $data['link_button_cancel'] = $this->url->link('herbal/new_herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'] . '&order_status=7', true);
        }

        $data['action'] = $this->url->link('herbal/new_herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['add_new_product_url'] = $this->url->link('herbal/new_herbal/addNewProduct', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['cancel'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['image_link'] = $this->url->link('herbal/new_herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['herbal_id'] = $this->request->get['herbal_id'];

        $data['uploading_img'] = HTTPS_IMAGE . 'uploading.gif';

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $sql = new StdClass();
        $sql->customer_id = !empty($data['customer_id']) ? $data['customer_id'] : 0;
        $sql->date_start = date('Y-m-01');
        $sql->date_end = date('Y-m-t');

        $data['total_clinicalsale'] = $this->model_herbal_new_herbal->getTotalCS($sql);
        $data['total_hold_clinicalsale'] = $this->model_herbal_new_herbal->getTotalHoldCS($sql);
        $data['total_paid_clinicalsale'] = $this->currency->format($this->model_herbal_new_herbal->getTotalPaidCS($sql), $this->config->get('config_currency'));
        $data['total_unpaid_clinicalsale'] = $this->currency->format($this->model_herbal_new_herbal->getTotalUnPaidCS($sql), $this->config->get('config_currency'));

        // Permission
        $data['view_herbal_remedies_report_permission'] = false;
        if ($this->user->hasPermission('delete', 'herbal/new_herbal')) {
            $data['view_herbal_remedies_report_permission'] = true;
        }

        //echo '<pre>';
        //print_r($this->user->hasPermission('delete', 'herbal/new_herbal'));
        //echo '</pre>';

        $data['pay_herbal_remedies_permission'] = true;
        if (!$this->user->hasPermission('access', 'pos/pos') && !$this->user->userPermissions('access', 'pos/pos')) {
            $data['pay_herbal_remedies_permission'] = false;
        }

        $data['change_customer_permission'] = true;
        if (!$this->user->hasPermission('modify', 'customer/customer') && !$this->user->userPermissions('modify', 'customer/customer')) {
            $data['change_customer_permission'] = false;
        }

        $this->response->setOutput($this->load->view('herbal/new_herbal_form', $data));
    }

    public function getInfo() {
        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->load->language('herbal/new_herbal');
        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
        }

        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['user_id'] = (int) $this->session->data['user_id'];
        $user_view = $this->user->user_view;
        $user_position = $this->user->user_position;

        $this->load->model('user/user');

        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_new_herbal->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_new_herbal->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_new_herbal->getHerbalTotals($this->request->get['herbal_id']);
            $herbal_service = $this->model_herbal_new_herbal->getHerbalService2($this->request->get['herbal_id']);
            if (empty($herbal_service)) {
                /** Get services from oc_clinecal_service_item table 
                 * The purpose is because of if the clinical sale / herbal remedies not yet been `completed`, the services only will save into oc_clinecal_service_item as draft.
                 */
                $herbal_service = $this->model_herbal_new_herbal->getHerbalService($this->request->get['herbal_id']);
            }
            $herbal_image = $this->model_herbal_new_herbal->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_new_herbal->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_new_herbal->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
        }

        $this->load->model('customer/customer');
        if ($herbal_id_info) {
            $order_action = !empty($herbal_id_info['order_action']) ? $herbal_id_info['order_action'] : 0;
            $clinicalsale_action = !empty($herbal_id_info['clinicalsale_action']) ? $herbal_id_info['clinicalsale_action'] : 0;

            $data['clinicalsale_type'] = !empty($herbal_id_info['herb_service_type']) ? $herbal_id_info['herb_service_type'] : 'herbs';

            if ($clinicalsale_action == 1) {
                $data['herbal_status_label'] = 'label-warning';
            } else if ($clinicalsale_action == 5) {
                $data['herbal_status_label'] = 'label-success';
            } else if ($clinicalsale_action == 7) {
                $data['herbal_status_label'] = 'label-danger';
            } else {
                $data['herbal_status_label'] = 'label-info';
            }

            $data['consultation_price'] = $this->currency->format(!empty($herbal_id_info['collect_consultation_price']) ? $herbal_id_info['total_d_gst'] : 0, $this->config->get('config_currency'));

            $data['username'] = $herbal_id_info['doctor_firstname'] . ' ' . $herbal_id_info['doctor_lastname'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['customer_name'] = $herbal_id_info['firstname'] . ' ' . $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']);

            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];
            $data['remark'] = $herbal_id_info['remark'];

            $data['https_herbal_images'] = HTTPS_HERBAL_IMAGE;
            $data['uploading_img'] = HTTPS_IMAGE . 'uploading.gif';

            $this->load->model('localisation/order_status');
            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            $clinicalsale_action_data =  $this->model_localisation_order_status->getOrderStatus($clinicalsale_action);
            $data['clinicalsale_action'] = !empty($clinicalsale_action_data['name']) ? $clinicalsale_action_data['name'] : 'No Status Found!';

            $payment_total = 0;
            $medical_total = !empty($herbal_id_info['total']) ? $herbal_id_info['total'] : 0;
            $service_total = $this->model_herbal_new_herbal->getServiceFormTotal($herbal_id_info['clinical_sale_id']);
            if (empty($service_total)) {
                $service_total = $this->model_herbal_new_herbal->getHerbalServiceTotal($herbal_id_info['clinical_sale_id']);
            }
            $payment_total = $medical_total + $service_total;

            $medical_subtotal = 0;
            $medicine_total = !empty($herbal_id_info['clinicalsale_total']) ? $herbal_id_info['clinicalsale_total'] : 0;
            if ($herbal_id_info['collect_consultation_price'] > 0) {
                $consultation_price = $herbal_id_info['clinicalsale_concultation'];
            } else {
                $consultation_price = 0;
            }
            $medical_subtotal = $consultation_price + $medicine_total;

            $data['clinicalsale_total'] = $this->currency->format($medicine_total, $this->config->get('config_currency'));
            $data['medical_total'] = $this->currency->format($medical_total, $this->config->get('config_currency'));
            $data['medical_subtotal'] = $this->currency->format($medical_subtotal, $this->config->get('config_currency'));
            $data['service_total'] = $this->currency->format($service_total, $this->config->get('config_currency'));
            $data['payment_total'] = $this->currency->format($payment_total, $this->config->get('config_currency'));
            $data['consultation_price'] = $this->currency->format($consultation_price, $this->config->get('config_currency'));

            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                } //loop services
            } //end services

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                } //loop image
            } //end image

            $data['total_data'] = [];
            if ($herbal_totals) {
                foreach ($herbal_totals as $total) {
                    $data['total_data'][] = array(
                        'id' => $total['id'],
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                        'value' => $total['value'],
                    );
                } //end looptotals
            } //end totaldata

            if (($order_action == 17 && $clinicalsale_action == 1 && $user_position == 2) || ($order_action == 17 && $clinicalsale_action == 5) || ($order_action == 17 && $clinicalsale_action == 1 && $user_position == 2) || ($order_action == 17 && $clinicalsale_action == 1 && $user_view == 1) || ($order_action == 17 && $clinicalsale_action == 5 && $user_view == 1)) {
                $data['enable_edit'] = true;
            } else {
                $data['enable_edit'] = false;
            }
        } else {
            $data['error_warning'] = $this->language->get('error_curupted');
            $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        } //url


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ); //breadcrumbs
        //html products
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();
        $data['total_weight'] = array();

        $total_weight = 0;
        $grand_total_weight = 0;

        $total_product_count = 0;
        foreach ($herbal_prescription as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $total = $this->currency->format($products['rowtotal'], $this->config->get('config_currency'));
                $tax = $this->currency->format($products['t_gst'], $this->config->get('config_currency'));
                $subtotal = $this->currency->format($products['t_net_price'], $this->config->get('config_currency'));

                $quantity = $products['quantity'];
                $times = $products['times'];
                $weight = $quantity * $times;

                $total_weight += $quantity;
                $grand_total_weight += $weight;

                if ($products['weight_class_id']) {
                    $total_weight_format = $this->weight->format($total_weight, $products['weight_class_id']);

                    $grand_total_weight_format = $this->weight->format($grand_total_weight, $products['weight_class_id']);
                }

                $data['total_weight'] = array(
                    array(
                        'total_weight_name' => $this->language->get('weight_total_name'),
                        'total_weight' => $total_weight_format
                    ),
                    array(
                        'total_weight_name' => $this->language->get('grand_weight_total_name'),
                        'total_weight' => $grand_total_weight_format
                    )
                );

                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'day' => $products['day'],
                    'price' => $products['product_price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'tax_class_id' => $products['tax_class_id'],
                    'weight' => $products['weight'],
                    'weight_class_id' => $products['weight_class_id'],
                    'weight_format' => $weight
                );
                $total_product_count++;
            } //end products
        } //send prescription

        $data['total_product_count'] =  $total_product_count;

        $total_service_count = 0;
        foreach ($this->cart->getService() as $key => $service) {
            $service_total_data = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));

            //tax
            $service_subtotal = $this->currency->format($service_total_data['net_amount'], $this->config->get('config_currency'));
            $service_tax = $this->currency->format($service_total_data['tax'], $this->config->get('config_currency'));
            $service_total = $this->currency->format($service_total_data['total'], $this->config->get('config_currency'));

            $subtotal = $this->currency->format($service['total'], $this->config->get('config_currency'));


            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                'subtotal' => $service_subtotal,
                'total' => $service_total,
                'tax' => $service_tax,
                'tax_class_id' => $service['tax_class_id']
            );
            $total_service_count++;
        } //end service

        $data['total_service_count'] =  $total_service_count;
        // acupuncture list
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $acupuncture_id = $acupuncture['acupuncture_id'];

                $acupuncture_name = $this->model_herbal_new_herbal->getAcupunctureNameById($acupuncture_id);

                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture_id,
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        } //images
        // image for button and pdf
        $herbal_remedies_image = $this->model_herbal_new_herbal->getHerbalRemediesImage($data['herbal_id']);

        if (!empty($herbal_remedies_image)) {
            $data['available_image'] = '1';
        } else {
            $data['available_image'] = '0';
        }

        $data['action'] = $this->url->link('herbal/herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['cancel'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['edit_url'] = $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['url_image'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1&image=1', true);
        $data['url_image_no'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_prescription_stickers'] = $this->url->link('herbal/new_herbal/printPrescriptionStickers', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_medical_leave'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_dispensing'] = $this->url->link('herbal/print/printDispensingList', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_medical_cert'] = $this->url->link('herbal/print/printMedicalCert', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_sticker'] = $this->url->link('herbal/print/printMedicationStickers', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);
        $data['print_medical_record'] = $this->url->link('herbal/print/printHerbalRemedies', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);

        $data['image_link'] = $this->url->link('herbal/herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/new_herbal_info', $data));
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'herbal/new_herbal') && !$this->user->userPermissions('delete', 'herbal/new_herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function getLatestHerbalByCustomerId($customer_id) {
        $query = $this->db->query(" 
            SELECT 
                    date_added
                FROM `oc_clinical_sale`
                WHERE 1
                    AND customer_id = '" . (int) $customer_id . "'
                ORDER BY date_added DESC
                LIMIT 1
        ");
        return !empty($query->row['date_added']) ? $query->row['date_added'] : '';
    }

    public function getUserPosition($user_id) {
        $query = $this->db->query("
			SELECT
					position
				FROM `oc_user`
				WHERE 1
					AND user_id = '" . (int) $user_id . "'
		");
        return !empty($query->row['position']) ? $query->row['position'] : 1;
    }

    public function getCodeMatch($data) {
        $query = $this->db->query("SELECT pcm.code, pcm.drug_id, pcm.drug_code AS code FROM `" . DB_PREFIX . "product_code_match` pcm  WHERE 1 AND pcm.product_id = '" . (int)$data['product_id'] . "' AND `option_type` = '" . $this->db->escape($data['option_type']) . "' AND status = 1 AND shelf_grid = 1");
        return $query->row;
    }

    public function getGranuleData($drug_id) {
        $query = $this->db->query("SELECT np.drug_id, np.code, np.name, np.compressscale, p.price FROM `" . DB_PREFIX . "ngp_product` np LEFT JOIN `" . DB_PREFIX  . "product` p ON np.product_id = p.product_id WHERE 1 AND np.drug_id = '" . (int)$drug_id . "'");
        return $query->row;
    }

    public function addImages() {

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $this->load->model('herbal/category');

        $date = date('Y_m_d');
        $paths = array();

        $folder_name = $this->model_herbal_category->getParentCategorName($this->request->post['category_id']);

        $customer_ic = !empty($this->request->post['patient_ic']) ? $this->request->post['patient_ic'] : $this->request->post['patient_telephone'];

        if (!file_exists(DIR_HERBAL . $folder_name . '/' . $customer_ic)) {
            mkdir(DIR_HERBAL . $folder_name . '/' . $customer_ic, 0777, true);
        }

        $img_folder_name = DIR_HERBAL . $folder_name . '/' . $customer_ic;
        $databse_folder = $folder_name . '/' . $customer_ic;
        foreach ($_FILES['images']['name'] as $key => $val) {
            $img_name = md5(rand(0, 1000) . rand(0, 1000) . rand(0, 1000)) . '.jpg';
            $upload_path = $img_folder_name . '/' . $img_name;
            move_uploaded_file($_FILES['images']['tmp_name'][$key], $upload_path);
            $paths[] = $databse_folder . '/' . $img_name;
        }

        foreach ($paths as $path) {
            $key = rand();
            $this->cart->addImages($key, $this->request->post['category_id'], $this->request->post['image_category'], $this->request->post['image_remark'], $path);
        }

        echo '<ul class="reorder_ul reorder-photos-list">';
        foreach ($this->cart->getImages() as $key => $image) {
            echo '<li id="image" class="ui-sortable-handle">';
            echo '<button class="btn  btn-danger" type="button" onclick="imageRemove(' . $key . ')"><i class="fa fa-remove"></i></button>';
            //echo '<a href="'.HTTPS_HERBAL_IMAGE.$image['path'].'" class="thumbnail">';
            echo '<img src="' . HTTPS_HERBAL_IMAGE . $image['path'] . '" alt=""  width="150" height="150" >';
            //echo '</a>';
            echo '<span>' . $image['name'] . '</span>';
            echo '<span>' . $image['remark'] . '</span>';
            echo '</li>';
        }
        echo '</ul>';
    }

    public function removeImage() {

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $this->cart->removeImage($this->request->post['image_id']);

        echo '<ul class="reorder_ul reorder-photos-list">';
        foreach ($this->cart->getImages() as $key => $image) {
            echo '<li id="image" class="ui-sortable-handle">';
            echo '<button class="btn  btn-danger" type="button" onclick="imageRemove(' . $key . ')"><i class="fa fa-remove"></i></button>';
            echo '<img src="' . HTTPS_HERBAL_IMAGE . $image['path'] . '" alt=""  width="100" height="100" >';
            echo '<span>' . $image['name'] . '</span>';
            echo '<span>' . $image['remark'] . '</span>';
            echo '</li>';
        }
        echo '</ul>';
    }

    public function exportExcel() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('customer/customer');
        $this->load->language('herbal/new_herbal');
        ini_set("memory_limit", "-1");
        set_time_limit(0);

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = date('Y-m-d');
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = date('Y-m-d');
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = null;
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = null;
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = null;
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = null;
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = null;
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $filter_customer_lastname = $this->request->get['filter_customer_lastname'];
        } else {
            $filter_customer_lastname = null;
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = $this->request->get['filter_payment_status'];
        } else {
            $filter_payment_status = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = null;
        }

        if (isset($this->request->get['filter_prescription'])) {
            $filter_prescription = $this->request->get['filter_prescription'];
        } else {
            $filter_prescription = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_address'])) {
            $filter_address = $this->request->get['filter_address'];
        } else {
            $filter_address = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sales_date ,invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        $filter_data = array(
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_occupation' => $filter_occupation,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_prescription' => $filter_prescription,
            'filter_telephone' => $filter_telephone,
            'filter_address' => $filter_address,
            'filter_customer_lastname' => $filter_customer_lastname,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_status' => $filter_status,
            'filter_doctor' => $filter_doctor
        );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setTitle('Title')
            ->setSubject('Subject')
            ->setDescription('Description')
            ->setKeywords('report etcm.me')
            ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
            ->setSize(12);

        $table_collection = array();
        $results = $this->model_herbal_new_herbal->getHerbals($filter_data);
        if (!empty($results)) {
            foreach ($results as $result) {
                $gender = ($result['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');

                $diagnostic = '';
                if (!empty($result['diagnostic_text'])) {
                    $diagnostic = substr($result['diagnostic_text'], 0, -1);
                }

                $prescription_list = '';
                if (!empty($result['prescription_name']) && !empty($result['prescription_product_name'])) {
                    $prescription_list = $result['prescription_name'] . ': ' . $result['prescription_product_name'];
                }

                $table_collection[] = [
                    'clinical_sale_id' => $result['clinical_sale_id'],
                    'sales_date' => $result['sales_date'],
                    'invoice_prefix' => $result['invoice_prefix'],
                    'customer_name' => $result['firstname'] . ' ' . $result['lastname'],
                    'customer_ic' => $result['customer_ic'],
                    'telephone' => $result['telephone'],
                    'gender' => $gender,
                    'diagnostic' => $diagnostic,
                    'prescription_list' => $prescription_list
                ];
            }
        }

        $table = array();
        $table[] = array('Medical Record List : ', $this->language->get('heading_title'));
        $table[] = array();
        $table_header = array(
            $this->language->get('column_medical_id'),
            $this->language->get('column_date'),
            $this->language->get('column_medical_no'),
            $this->language->get('column_name'),
            $this->language->get('column_ic'),
            $this->language->get('column_telephone'),
            $this->language->get('column_customer_gender'),
            $this->language->get('column_d_s_d'),
            $this->language->get('column_prescription')
        );
        $table[] = $table_header;
        $total_row = 0;
        $table_data = $table_collection;
        $row;
        foreach ($table_data as $key => $data) {
            $row = array();

            foreach ($data as $key => $value) {
                $row[] = $value;
            }
            $table[] = $row;

            $total_row++;
        }

        // Styling
        $autosize_column_index = 'A';
        foreach ($table_header as $header) {
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach ($table_header as $col)
            $header_index_e_column++;
        $header_index_row = 3;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font' => array(
                'bold' => true
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $general_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat' => array(
                'code' => '00000000000'
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:A' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('B1:B' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('C1:C' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('D1:D' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('E1:E' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('F1:F' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('G1:G' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $objPHPExcel->getActiveSheet()
            ->getColumnDimension('H')
            ->setAutoSize(false);

        $objPHPExcel->getActiveSheet()
            ->getColumnDimension('H')
            ->setWidth(50);

        $objPHPExcel->getActiveSheet()
            ->getStyle('H1:H' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('H1:H' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getColumnDimension('I')
            ->setAutoSize(false);

        $objPHPExcel->getActiveSheet()
            ->getColumnDimension('I')
            ->setWidth(50);

        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

        $lastrow = $header_index_row + 1 + $total_row;
        $objPHPExcel->getActiveSheet()
            ->getStyle('I1:I' . $lastrow)
            ->getAlignment()
            ->setVertical(PHPExcel_Style_Alignment::VERTICAL_TOP);

        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:I' . $lastrow)
            ->getAlignment()
            ->setWrapText(true);

        /* $objPHPExcel->getActiveSheet()
          ->getStyle('A1:I'.$lastrow)
          ->getAlignment()
          ->setWrapText(true); */
        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = 'Medical Record List';

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }

    public function getList2() {
        $this->getList(FALSE);
    }

    public function getList($list_file_type = TRUE) {
        $this->load->language('herbal/new_herbal');
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');
        $this->load->model('sale/order');

        //Set the timezone
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $data['new_herbal_list_javascript_link'] = 'view/javascript/herbal/new_herbal_list.js?v=' . time();
        $user_token = $this->session->data['user_token'];

        // Set and Get the error value return
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        // Set and Get Request GET Variables
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = null;
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = null;
        }

        $language = $this->session->data['language'];

        if ($language == 'en-gb') {
            $data['date_types'][] = [
                'text' => 'All',
                'value' => 'all'
            ];
            $data['date_types'][] = [
                'text' => 'Today',
                'value' => 'today'
            ];
            $data['date_types'][] = [
                'text' => 'Week',
                'value' => 'week'
            ];
            $data['date_types'][] = [
                'text' => 'Month',
                'value' => 'month'
            ];
            $data['date_types'][] = [
                'text' => 'Year',
                'value' => 'year'
            ];
            $data['date_types'][] = [
                'text' => 'Set By Date',
                'value' => 'set_by_date'
            ];
        } elseif ($language == 'zh-cn') {
            $data['date_types'][] = [
                'text' => '所有',
                'value' => 'all'
            ];
            $data['date_types'][] = [
                'text' => '今天',
                'value' => 'today'
            ];
            $data['date_types'][] = [
                'text' => '星期',
                'value' => 'week'
            ];
            $data['date_types'][] = [
                'text' => '月',
                'value' => 'month'
            ];
            $data['date_types'][] = [
                'text' => '年',
                'value' => 'year'
            ];
            $data['date_types'][] = [
                'text' => '按日期设置',
                'value' => 'set_by_date'
            ];
        }

        if (!empty($this->request->get['filter_customer_search'])) {
            $filter_date_from = null;
            $filter_date_to = null;
            $filter_date_type = 'all';
            $this->request->get['filter_date_to'] = null;
            $this->request->get['filter_date_from'] = null;
            $this->request->get['filter_customer_search'] = null;
        }

        $date_now = date('Y-m-d');
        $config_date_type = 'today';
        $filter_date_type = isset($this->request->get['filter_date_type']) ? ($this->request->get['filter_date_type']) : $config_date_type;
        $data['selected_date_type'] = $filter_date_type;

        // Based on the date type to set the value for date_from and date to
        switch ($filter_date_type) {
            case 'today':
                $filter_date_from = date('Y-m-d');
                $filter_date_to = date('Y-m-d');
                break;
            case 'week':
                $filter_date_from = date('Y-m-d', strtotime('this week'));
                $filter_date_to = date('Y-m-d', strtotime('+ 6 days ', strtotime($filter_date_from)));
                break;
            case 'month':
                $filter_date_from = date('Y-m-01', strtotime($date_now));
                $filter_date_to = date('Y-m-t');
                break;
            case 'year':
                $filter_date_from = date('Y-m-d', strtotime('first day of january this year'));
                $filter_date_to = date('Y-m-d', strtotime('last day of december this year'));
                break;
            case 'all':
                $filter_date_from = null;
                $filter_date_to = null;
                break;
            case 'set_by_date':
                $filter_date_from = $filter_date_from;
                $filter_date_to = $filter_date_to;
                break;
            default:
                $filter_date_from = $filter_date_from;
                $filter_date_to = $filter_date_to;
        }

        $this->request->get['filter_date_from'] = $filter_date_from;
        $this->request->get['filter_date_to'] = $filter_date_to;

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = null;
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = null;
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = null;
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = null;
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $filter_customer_search = $this->request->get['filter_customer_search'];
        } else {
            $filter_customer_search = null;
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = null;
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $filter_customer_lastname = $this->request->get['filter_customer_lastname'];
        } else {
            $filter_customer_lastname = null;
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = $this->request->get['filter_payment_status'];
        } else {
            $filter_payment_status = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = 0;
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = null;
        }

        if (isset($this->request->get['filter_prescription'])) {
            $filter_prescription = $this->request->get['filter_prescription'];
        } else {
            $filter_prescription = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_address'])) {
            $filter_address = $this->request->get['filter_address'];
        } else {
            $filter_address = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sales_date ,invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        //Build URL based on GET Variables 
        $url = '';
        $pagination_url = '';
        /*if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }*/

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination_url .= $url;

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $user_token, true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . $url, true)
        );

        $data['add'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $user_token . $url, true);
        $data['delete'] = $this->url->link('herbal/new_herbal/delete', 'user_token=' . $user_token . $url, true);

        $data['herbals'] = [];
        $filter_data = array(
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_occupation' => $filter_occupation,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_prescription' => $filter_prescription,
            'filter_telephone' => $filter_telephone,
            'filter_address' => $filter_address,
            'filter_customer_lastname' => $filter_customer_lastname,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_status' => $filter_status,
            'filter_customer_search' => $filter_customer_search,
            'filter_doctor' => $filter_doctor,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin'),
            'user_view' => $this->user->user_view,
            'user_position' => $this->user->user_position
        );

        $data['user_view'] = $this->user->user_view;
        $data['user_position'] = $this->user->user_position;

        // var_dump($data['user_view']);
        // die();

        $herbal_total = $this->model_herbal_new_herbal->getTotalHerbal($filter_data);
        $results = $this->model_herbal_new_herbal->getHerbals($filter_data);
        foreach ($results as $result) {

            $payment_total = 0;
            $medical_total = !empty($result['total']) ? $result['total'] : 0;
            $service_total = $this->model_herbal_new_herbal->getServiceFormTotal($result['clinical_sale_id']);
            if (empty($service_total)) {
                $service_total = $this->model_herbal_new_herbal->getHerbalServiceTotal($result['clinical_sale_id']);
            }
            $payment_total = $medical_total + $service_total;

            $medical_subtotal = 0;
            $medicine_total = !empty($result['clinicalsale_total']) ? $result['clinicalsale_total'] : 0;
            if ($result['collect_consultation_price'] > 0) {
                $consultation_price = $result['clinicalsale_concultation']; //$this->model_sale_order->getHerbalTotal($result['clinical_sale_id']); //$consultation_price = $result['clinicalsale_concultation'] * 1.06;
            } else {
                $consultation_price = 0;
            }

            $medical_subtotal = $consultation_price + $medicine_total;

            switch ($result['herb_service_type']) {
                case 'herbs':
                    $result['herb_service_type'] = $this->language->get('text_herbs');
                    break;
                case 'brewing':
                    $result['herb_service_type'] = $this->language->get('text_brewing');
                    break;
                case 'granule':
                    $result['herb_service_type'] = $this->language->get('text_granule');
                    break;
                default:
            }

            $label_clinicalsale_action = '';
            switch ($result['clinicalsale_action']) {
                case 1:
                    $label_clinicalsale_action = 'warning';
                    break;
                case 5:
                    $label_clinicalsale_action = 'success';
                    break;
                case 7:
                case 17:
                    $label_clinicalsale_action = 'danger';
                    break;
                default:
                    $label_clinicalsale_action = 'warning';
            }

            $label_order_action = '';
            switch ($result['order_action']) {
                case 1:
                    $label_order_action = 'warning';
                    break;
                case 5:
                    $label_order_action = 'success';
                    break;
                case 7:
                case 17:
                    $label_order_action = 'danger';
                    break;
                default:
                    $label_order_action = 'warning';
            }

            $pescription_details = $this->model_herbal_new_herbal->getPrescriptionDetails($result['clinical_sale_id']);
            $prescription_name = !empty($pescription_details['prescription_name']) ? $pescription_details['prescription_name'] : '';
            $prescription_product_name = !empty($pescription_details['prescription_product_name']) ? $pescription_details['prescription_product_name'] : '';

            $doctor_info    = !empty($result['doctor_id']) ? $this->model_herbal_new_herbal->getUserInfo($result['doctor_id']) : [];
            $doctor_name    = !empty($doctor_info['name']) ? $doctor_info['name'] : '';
            $add_by_info    = !empty($result['add_by']) ? $this->model_herbal_new_herbal->getUserInfo($result['add_by']) : [];
            $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';
            $modify_by_info = !empty($result['modify_by']) ? $this->model_herbal_new_herbal->getUserInfo($result['modify_by']) : [];
            $modify_by      = !empty($modify_by_info['name']) ? $modify_by_info['name'] : '';
            $store_info     = !empty($result['store_id']) ? $this->model_herbal_new_herbal->getStoreInfo($result['store_id']) : [];
            $store_name     = !empty($store_info['name']) ? $store_info['name'] : $this->config->get('config_name');

            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'invoice_prefix' => $result['invoice_prefix'],
                'store_name' => $store_name,
                'doctor_name' => $doctor_name,
                'telephone' => $result['telephone'],
                'firstname' => $result['firstname'] . ' ' . $result['lastname'],
                'customer_id' => $result['customer_id'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'status' => $result['status'],
                'label_clinicalsale_action' => $label_clinicalsale_action,
                'label_order_action' => $label_order_action,
                'top' => $result['tick_top'],
                'occupation' => $result['occupation'],
                'telephone' => $result['telephone'],
                'diagnostic' => substr($result['diagnostic_text'], 0, -1),
                'prescription_list' => $prescription_product_name,
                'prescription_product_list' => $prescription_product_name,
                'order_status' => $result['order_status'],
                'order_action' => $result['order_action'],
                'clinicalsale_action' => $result['clinicalsale_action'],
                'clinicalsale_total' => $this->currency->format($medicine_total, $this->config->get('config_currency')),
                'consultation_price' => $this->currency->format($consultation_price, $this->config->get('config_currency')),
                'medical_subtotal' => $this->currency->format($medical_subtotal, $this->config->get('config_currency')),
                'medical_total' => $this->currency->format($medical_total, $this->config->get('config_currency')),
                'service_total' => $this->currency->format($service_total, $this->config->get('config_currency')),
                'payment_total' => $this->currency->format($payment_total, $this->config->get('config_currency')),
                'create_new' => $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $user_token . '&customer_id=' . $result['customer_id'] . '&doctor_id=' . $result['doctor_id'] . $url, true),
                'edit' => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $user_token . '&herbal_id=' . $result['clinical_sale_id'] . $url, true),
                'pos' => $this->url->link('pos/pos', 'user_token=' . $user_token . '&herbal_id=' . $result['clinical_sale_id'], true),
                'info' => $this->url->link('herbal/new_herbal/getInfo', 'user_token=' . $user_token . '&herbal_id=' . $result['clinical_sale_id'] . $url, true)
            );
        }

        //Build and set the button action link 
        $data['add_new'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $user_token . $url, true);
        $data['export_excel'] = $this->url->link('herbal/new_herbal/exportExcel', 'user_token=' . $user_token . $url, true);
        $data['refresh_medical_record'] = 'index.php?route=herbal/new_herbal/getList2&user_token=' . $user_token . $url;

        //Build and set the sort order link based on different variable
        $data['sort_sales_date'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=cs.sales_date' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=cs.invoice_prefix' . $url, true);
        $data['sort_firstname'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=c.firstname' . $url, true);
        $data['sort_customer_ic'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=c.customer_ic' . $url, true);
        $data['sort_customer_card'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=c.customer_card' . $url, true);
        $data['sort_telephone'] = $this->url->link('herbal/new_herbal', 'user_token=' . $user_token . '&sort=c.telephone' . $url, true);

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $pagination_url . '&page={page}', true);
        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        //Set the filter value from the request GET become a variable
        $data['filter_date_type'] = $filter_date_type;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_transaction_from'] = $filter_transaction_from;
        $data['filter_transaction_to'] = $filter_transaction_to;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_customer_firstname'] = $filter_customer_firstname;
        $data['filter_payment_status'] = $filter_payment_status;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;
        $data['filter_customer_lastname'] = $filter_customer_lastname;
        $data['filter_occupation'] = $filter_occupation;
        $data['filter_address'] = $filter_address;
        $data['filter_prescription'] = $filter_prescription;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer_search'] = $filter_customer_search;

        $this->load->model('localisation/order_status');
        $order_status_list = array(7, 5, 1, 18);
        foreach ($order_status_list as $order_status) {
            $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

            $data['cs_order_statuses'][] = array(
                'order_status_id' => $order_status_data['order_status_id'],
                'name' => $order_status_data['name']
            );
        }

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['doctors'] = $this->model_herbal_new_herbal->getDoctors();

        $data['sort'] = $sort;
        $data['order'] = $order;
        $data['ordering'] = strtolower($order);
        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if ($list_file_type) {
            $this->response->setOutput($this->load->view('herbal/new_herbal_list', $data));
        } else {
            $this->response->setOutput($this->load->view('herbal/new_herbal_list2', $data));
        }
    }

    protected function validateForm() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        if (!$this->user->hasPermission('modify', 'herbal/new_herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {

            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
                $this->error['firstname'] = $this->language->get('error_firstname');
            }

            /* if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32 ) ) {
              $this->error['lastname'] = $this->language->get('error_lastname');
              } */

            if (utf8_strlen($this->request->post['doctor_id']) < 1) {
                $this->error['doctor_id'] = $this->language->get('error_doctor');
            }

            // if ((utf8_strlen($this->request->post['doctor_id']) == 0)) {
            //     $this->error['doctor_id'] = $this->language->get('error_doctor');
            // }

            if ($this->model_herbal_new_herbal->customerExistsByTelephone($this->request->post['telephone'])) {
                $this->error['telephone'] = $this->language->get('error_telephone_exists');
            }

            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if ($this->model_herbal_new_herbal->customerExistsByIc($this->request->post['customer_ic'])) {
                $this->error['customer_ic'] = $this->language->get('error_customer_ic_exists');
            }

            if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
                $this->error['customer_ic'] = $this->language->get('error_customer_ic');
            }


            // Custom field validation
            $this->load->model('customer/custom_field');

            $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }

            /* if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
              if ($this->request->post['password'] != $this->request->post['confirm']) {
              $this->error['confirm'] = $this->language->get('error_confirm');
              }
              } */
            if (isset($this->request->post['address'])) {
                foreach ($this->request->post['address'] as $key => $value) {
                    /* if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
                      $this->error['address'][$key]['firstname'] = $this->language->get('error_firstname');
                      }

                      if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                      $this->error['address'][$key]['lastname'] = $this->language->get('error_lastname');
                      } */

                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_address_1');
                    }

                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_city');
                    }

                    if ((utf8_strlen($value['postcode']) < 2) || (utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                    }

                    $this->load->model('localisation/country');

                    $country_info = $this->model_localisation_country->getCountry($value['country_id']);

                    /* if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                      $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                      } */

                    if ($value['country_id'] == '') {
                        $this->error['address'][$key]['country'] = $this->language->get('error_country');
                    }

                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_zone');
                    }

                    foreach ($custom_fields as $custom_field) {
                        if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                            $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                        }
                    }
                }
            }
        }

        if (utf8_strlen($this->request->post['doctor_id']) < 1) {

            $this->error['doctor_id'] = $this->language->get('error_doctor');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function searchCustomer() {
        $this->load->language('customer/customer');
        $this->load->model('customer/customer');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        }

        $json['shipping'][] = array();
        $json = $this->model_customer_customer->selectCustomers($data);
        $this->cart->clearService();
        $this->cart->clearHerbal();

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Member Details";
        }
        return $this->response->setOutput(json_encode($json));
    }

    public function customerAutocomplete() {
        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/new_herbal');
        $json = [];

        if (isset($this->request->get['filter_search'])) {
            $filter_search = $this->request->get['filter_search'];
        } else {
            $filter_search = '';
        }

        $filter_data = array(
            'filter_search' => $filter_search,
            'start' => 0,
            'limit' => 15
        );

        $results = $this->model_herbal_new_herbal->getAutocompleteCustomers($filter_data);
        if (!empty($results)) {
            foreach ($results as $result) {
                if ($result['gender'] == 1) {
                    $gender_text = $this->language->get('filed_male');
                } else {
                    $gender_text = $this->language->get('filed_female');
                }

                if (!empty($result['customer_address'])) {
                    $customer_address = $result['customer_address'];
                } else {
                    $customer_address = '';
                }

                $age = $this->calculateAge($result['dob']) . ' ' . $this->language->get('text_age');
                $json[] = [
                    'customer_id' => $result['customer_id'],
                    'customer_firstname' => $result['customer_firstname'],
                    'customer_lastname' => $result['customer_lastname'],
                    'customer_name' => $result['customer_name'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_card' => $result['customer_card'],
                    'customer_group_id' => $result['customer_group_id'],
                    'gender' => $result['gender'],
                    'gender_text' => $gender_text,
                    'email' => $result['email'],
                    'telephone' => $result['telephone'],
                    'occupation' => $result['occupation'],
                    'age' => $age,
                    'customer_address' => $customer_address
                ];
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function autocompleteForm() {
        $json = [];

        if (isset($this->request->get['filter_firstname'])) {
            $filter_firstname = $this->request->get['filter_firstname'];
        } else {
            $filter_firstname = '';
        }

        if (isset($this->request->get['filter_lastname'])) {
            $filter_lastname = $this->request->get['filter_lastname'];
        } else {
            $filter_lastname = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = '';
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = '';
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = '';
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = '';
        }

        $filter_data = array(
            'filter_firstname' => $filter_firstname,
            'filter_lastname' => $filter_lastname,
            'filter_telephone' => $filter_telephone,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_customer_card' => $filter_customer_card,
            'filter_occupation' => $filter_occupation,
            'filter_email' => $filter_email,
            'start' => 0,
            'limit' => 5
        );

        $this->load->model('herbal/new_herbal');

        $results = $this->model_herbal_new_herbal->getAutocompleteFormCustomers($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $religion = !empty($result['religion']) ? $result['religion'] : 2;
                $race = !empty($result['race']) ? $result['race'] : 2;
                $marital_status = !empty($result['marital_status']) ? $result['marital_status'] : 1;

                $json[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    'newsletter' => $result['newsletter'],
                    'status' => $result['status'],
                    'approved' => $result['approved'],
                    'safe' => $result['safe'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_card' => $result['customer_card'],
                    'customer_group_id' => $result['customer_group_id'],
                    'gender' => $result['gender'],
                    'dob' => $result['dob'],
                    'email' => $result['email'],
                    'telephone' => $result['telephone'],
                    'fax' => $result['fax'],
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home'],
                    'occupation' => $result['occupation'],
                    'allergic' => $result['allergic'],
                    'nationality' => $result['nationality'],
                    'marital_status' => $marital_status,
                    'race' => $race,
                    'religion' => $religion,
                    'diagnostic_history' => $result['diagnostic_history']
                ];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addShipping() {

        $this->load->model('customer/customer');
        if (isset($this->request->post['shipping_address'])) {
            $this->session->data['shipping_addres_id'] = $this->request->post['shipping_address'];
            $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($this->request->post['shipping_address']);
        }
        return $this->session->data['shipping_addres_id'];
    }

    public function setPrescription() {
        $json = array();
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $json['old_prescription'] = $this->session->data['clinical_sale_prescription'];
        $json['old_products'] = $this->session->data['clinical_sale_products'];

        //html for cart
        $json['prescription'] = array();
        foreach ($this->cart->getPrescription() as $prescription) {
            $json['prescription'][] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );
        } //send prescription

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getPatientHistory() {

        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));


        if (isset($this->request->get['customer_id'])) {
            $customer_id = $this->request->get['customer_id'];
        } else {
            $customer_id = null;
        }

        if (isset($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        } else {
            $herbal_id = null;
        }


        if (isset($this->request->get['filter_history_from'])) {
            $filter_history_from = $this->request->get['filter_history_from'];
        } else {
            $filter_history_from = null;
        }

        if (isset($this->request->get['filter_history_to'])) {
            $filter_history_to = $this->request->get['filter_history_to'];
        } else {
            $filter_history_to = null;
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $filter_symptoms = $this->request->get['filter_symptoms'];
        } else {
            $filter_symptoms = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }


        if (isset($this->request->get['filter_doctoradvice'])) {
            $filter_doctoradvice = $this->request->get['filter_doctoradvice'];
        } else {
            $filter_doctoradvice = null;
        }

        if (isset($this->request->get['filter_pulse'])) {
            $filter_pulse = $this->request->get['filter_pulse'];
        } else {
            $filter_pulse = null;
        }

        if (isset($this->request->get['filter_disease'])) {
            $filter_disease = $this->request->get['filter_disease'];
        } else {
            $filter_disease = null;
        }

        if (isset($this->request->get['filter_treatment'])) {
            $filter_treatment = $this->request->get['filter_treatment'];
        } else {
            $filter_treatment = null;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = null;
        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_history_from,
            'filter_date_to' => $filter_history_to,
            'filter_symptoms' => $filter_symptoms,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_doctoradvice' => $filter_doctoradvice,
            'filter_pulse' => $filter_pulse,
            'filter_disease' => $filter_disease,
            'filter_treatment' => $filter_treatment,
            'filter_acupuncture' => $filter_acupuncture,
            'customer_id' => $customer_id,
            'herbal_id' => $herbal_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $herbal_total = $this->model_herbal_new_herbal->getTotalHerbal($filter_data);

        $results = $this->model_herbal_new_herbal->getHerbals($filter_data);


        foreach ($results as $result) {
            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'invoice_prefix' => $result['invoice_prefix'],
                'pos_price' => $this->currency->format($result['total_d_gst']),
                'diagnostic' => $result['diagnostic'],
                'doctoradvice' => $result['doctoradvice'],
                'pulse' => $result['pulse'],
                'disease' => $result['disease'],
                'treatment' => $result['treatment'],
                'acupuncture' => $result['acupuncture'],
                'symptom' => $result['symptom'],
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }


        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_history_from'])) {
            $url .= '&filter_history_from=' . $this->request->get['filter_history_from'];
        }

        if (isset($this->request->get['filter_history_to'])) {
            $url .= '&filter_history_to=' . $this->request->get['filter_history_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/new_herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=cs.sales_date', true);
        $data['sort_invoice_prefix'] = $this->url->link('herbal/new_herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=cs.invoice_prefix', true);

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_history_from'])) {
            $url .= '&filter_history_from=' . $this->request->get['filter_history_from'];
        }

        if (isset($this->request->get['filter_history_to'])) {
            $url .= '&filter_history_to=' . $this->request->get['filter_history_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/new_herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        $data['herbal_id'] = $herbal_id;
        $data['customer_id'] = $customer_id;
        $data['filter_history_from'] = $filter_history_from;
        $data['filter_history_to'] = $filter_history_to;
        $data['filter_symptoms'] = $filter_symptoms;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_doctoradvice'] = $filter_doctoradvice;
        $data['filter_pulse'] = $filter_pulse;
        $data['filter_disease'] = $filter_disease;
        $data['filter_treatment'] = $filter_treatment;
        $data['filter_acupuncture'] = $filter_acupuncture;
        $data['herbal_id'] = $herbal_id;
        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('herbal/new_patienthistory_list', $data));
    }

    public function addOrder() {
        $data = array();

        if (isset($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['order_status'])) {
            $order_status = $this->request->get['order_status'];
        } else {
            $order_status = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        } //url

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/new_herbal');

        $data['user_token'] = $this->session->data['user_token'];

        //$data['auto_saved'] = !empty($this->request->post['auto_saved']) ? $this->request->post['auto_saved'] : 0;

        $data['shipping_address_id'] = $this->request->post['shipping_address'];
        $data['status'] = $this->request->post['status'];
        $data['doctor_id'] = $this->request->post['doctor_id'];
        $data['customer_ic'] = !empty($this->request->post['customer_ic']) ? $this->request->post['customer_ic'] : $this->request->post['telephone'];
        $data['customer_id'] = $this->request->post['customer_id'];
        //$data['customer_ic']  = $this->request->post['customer_ic'];
        $data['diagnostic'] = $this->request->post['diagnostic'];
        $data['doctoradvice'] = $this->request->post['doctoradvice'];
        $data['pulse'] = $this->request->post['pulse'];
        $data['disease'] = $this->request->post['disease'];
        $data['treatment'] = $this->request->post['treatment'];
        $data['acupuncture'] = $this->request->post['acupuncture'];
        $data['symptom'] = $this->request->post['symptom'];
        $data['remark'] = $this->request->post['remark'];
        $data['sales_date'] = $this->request->post['sales_date'];

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->request->post['doctor_id']);
        $data['tax_class_id'] = $user_details['tax_class_id'];
        $data['tax_code'] = $this->tax->getClassCode($data['tax_class_id']);

        // Totals
        $this->load->model('pos/extension');
        $total_doctor_data = array();
        $enable_doctorprice = $this->request->post['enable_doctorprice'];
        $doctor_total = 0;
        $doctor_taxes = $this->tax->calculateTax($this->request->post['doctor_price'], $data['tax_class_id']);
        $doctor_taxes_rates = $this->cart->getDoctorTaxes($this->request->post['doctor_price'], $data['tax_class_id']);
        $data['doctor_subtotal'] = $doctor_taxes['net_amount'];

        $data['doctor_price'] = ($this->request->post['enable_doctorprice'] == '1') ? $this->request->post['doctor_price'] : 0;

        $data['enable_doctorprice'] = $this->request->post['enable_doctorprice'];
        // $data['doctor_price'] = $this->request->post['doctor_price'];
        $data['doctor_total'] = $doctor_taxes['total'];
        $data['doctor_tax'] = $doctor_taxes['tax'];
        $data['doctor_format'] = $doctor_taxes['format'];

        $this->language->load('total/sub_total');

        $total_doctor_data[] = array(
            'key' => '',
            'code' => 'sub_total',
            'title' => 'Sub total',
            'text' => $this->currency->format($doctor_taxes['net_amount'], $this->config->get('config_currency')),
            'value' => $doctor_taxes['net_amount'],
            'tax_code' => '',
            'sort_order' => $this->config->get('sub_total_sort_order')
        );

        $doctor_total += $doctor_taxes['net_amount'];


        foreach ($doctor_taxes_rates as $key => $value) {
            $total_doctor_data[] = array(
                'key' => $key,
                'code' => 'tax',
                'title' => $this->tax->getRateName($key),
                'tax_code' => $this->tax->getRateCode($key),
                'text' => $this->currency->format($value, $this->config->get('config_currency')),
                'value' => $value,
                'sort_order' => $this->config->get('tax_sort_order')
            );

            $doctor_total += $value;
        }

        $total_doctor_data[] = array(
            'key' => '',
            'code' => 'total',
            'title' => 'total',
            'text' => $this->currency->format(max(0, $doctor_total), $this->config->get('config_currency')),
            'tax_code' => '',
            'value' => max(0, $doctor_total),
            'sort_order' => $this->config->get('total_sort_order')
        );

        $data['total_doctor_data'] = $total_doctor_data;

        // Totals
        $total_data = array();
        $totals = array();
        $total = 0;
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        $sort_order = array();
        $results = $this->model_pos_extension->getExtensions('total');
        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }
        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {

            if ($this->config->get('total_' . $result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            }

            $sort_order = array();
            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        $data['order_total'] = $totals;

        if ($enable_doctorprice == '1') {
            $total_doctor_data_tax = 0;
            $total_data_tax = 0;

            foreach ($total_data['totals'] as $total) {
                if ($total['code'] == 'sub_total') {
                    $total_data_subtotal = $total['value'];
                }

                if ($total['code'] == 'tax') {
                    $total_data_tax += $total['value'];
                }

                if ($total['code'] == 'total') {
                    $total_data_total = $total['value'];
                }

                if ($total['code'] == 'rounding') {
                    $total_data_rounding = $total['value'];
                }
            }

            foreach ($total_doctor_data as $total_doctor) {
                if ($total_doctor['code'] == 'sub_total') {
                    $total_doctor_data_subtotal = $total_data_subtotal + $total_doctor['value'];
                }

                if ($total_doctor['code'] == 'tax') {
                    $total_doctor_data_tax = $total_data_tax + $total_doctor['value'] /* + $total_data_rounding */;
                }

                if ($total_doctor['code'] == 'total') {
                    $total_doctor_data_total = $total_data_total + $total_doctor['value'];
                }
            }

            $data['total_doctor_data'][0]['value'] = $total_doctor_data_subtotal;
            $data['total_doctor_data'][1]['value'] = $total_doctor_data_tax;
            $data['total_doctor_data'][1]['key'] = '88';
            $data['total_doctor_data'][1]['tax_code'] = 'SR';
            $data['total_doctor_data'][1]['title'] = 'GST (6%)';
            $data['total_doctor_data'][2]['value'] = $total_doctor_data_total;

            $data['doctor_subtotal'] = $total_doctor_data_subtotal;
            $data['doctor_tax'] = $total_doctor_data_tax;
            $data['doctor_total'] = $total_doctor_data_total;

            $data['tax_class_id'] = 11;
            $data['tax_code'] = 'SR';
        }

        //html for cart
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();
        foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
            $name = $prescription['name'];
            $name = implode(',', $name);
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription['key'],
                'name' => $name,
                'id' => $prescription['id'],
                'discount' => $prescription['discount'],
                'times' => $prescription['times'],
                'cook' => $prescription['cook'],
                'taketype' => $prescription['taketype'],
                'day' => $prescription['day'],
                'quantity' => $prescription['quantity']
            );

            foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];

                $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                $total = $sub_tax['total'];
                $tax = $sub_tax['tax'];
                $subtotal = $sub_tax['net_amount'];

                $product_weight = 0;
                $product_tax = 0;
                $product_subtotal = 0;
                if ($products['weight'] > 0) {
                    $product_weight = ($products['weight'] / $products['quantity']) / $products['times'];
                }
                if ($subtotal > 0) {
                    $product_subtotal = ($subtotal / $products['quantity']) / $products['times'];
                }
                if ($tax > 0) {
                    $product_tax = ($tax / $products['quantity']) / $products['times'];
                }

                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'stock' => $products['stock'],
                    'day' => $products['day'],
                    'price' => $products['price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'product_tax' => $product_tax,
                    'product_subtotal' => $product_subtotal,
                    'tax_class_id' => $products['tax_class_id'],
                    'tax_code' => $this->tax->has($products['tax_class_id']) ? $this->tax->getClassCode($products['tax_class_id']) : '',
                    'tax_format' => $sub_tax['format'],
                    'weight' => $products['weight'],
                    'product_weight' => $product_weight,
                    'weight_class_id' => $products['weight_class_id'],
                );
            } //end products
        } //send prescription

        foreach ($this->cart->getService() as $key => $service) {
            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $sub_tax['total'];
            $tax = $sub_tax['tax'];
            $subtotal = $sub_tax['net_amount'];

            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'net_total' => $sub_tax['net_amount'],
                'total_whit_gst' => $sub_tax['net_amount'] + $sub_tax['tax'],
                'tax' => $tax,
                'nat_tax' => $sub_tax['tax'],
                'net_price' => $sub_tax['net_amount'],
                'tax_class_id' => $service['tax_class_id'],
                'tax_format' => $sub_tax['format'],
                'tax_code' => $this->tax->getClassCode($service['tax_class_id'])
            );
        } //end service

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => $image['path']
            );
        } //images
        // service acupuncture
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        //$this->printData($data);

        $this->model_herbal_new_herbal->editOrder($herbal_id, $data);
        $this->session->data['date_modified'] = $this->model_herbal_new_herbal->getHerbalDateModified($herbal_id);
        $this->response->setOutput(json_encode('index.php?route=herbal/new_herbal&user_token=' . $this->session->data['user_token'] . $url));
    }

    public function runOrderTotal2() {
        //Model
        $this->load->model('herbal/new_herbal');
        $this->load->model('pos/pos');
        $this->load->model('customer/customer');
        $this->load->model('sale/order');
        //Language
        $this->load->language('pos/pos');
        $this->load->language('customer/customer');
        //Library
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $get_order = array();
        $all_orders = array();
        $all_orders_array = array();
        $chewc_orders_array = array();
        $non_chewc_orders_array = array();
        $all_orders_count = 0;
        $chewc_count = 0;
        $non_chewc_count = 0;
        $all_orders = $this->model_herbal_new_herbal->getAllOrderByDate();
        if (!empty($all_orders)) {
            foreach ($all_orders as $all_order) {
                $order_products = array();
                $order_products_array = array();
                $order_products_count = 0;
                $order_herbals = array();
                $order_herbals_array = array();
                $order_herbals_count = 0;
                $order_services = array();
                $order_services_array = array();
                $order_services_count = 0;
                $this->cart->clear();
                $chewc = $this->model_herbal_new_herbal->checkOrderExists($all_order['order_id']);
                if (!empty($chewc)) {
                    $this->cart->clear();
                    $get_order['orders'][$all_order['order_id']]['order_status'] = 1;
                    array_push($chewc_orders_array, $all_order['order_id']);
                    $chewc_count++;
                    //Products
                    $order_products = $this->model_sale_order->getOrderCartProducts($all_order['order_id']);
                    if (!empty($order_products)) {
                        $get_order['orders'][$all_order['order_id']]['order_products_status'] = 1;
                        foreach ($order_products as $order_product) {
                            $get_order['orders'][$all_order['order_id']]['order_products'][] = array(
                                'order_id' => $order_product['order_id'],
                                'order_product_id' => $order_product['order_product_id'],
                                'product_id' => $order_product['product_id'],
                                'name' => $order_product['name'],
                                'price' => $order_product['price'],
                                'quantity' => $order_product['quantity'],
                                'net_amount' => $order_product['net_amount'],
                                'tax' => $order_product['tax'],
                                'total' => $order_product['total'],
                            );
                            if (isset($order_product['order_option'])) {
                                $order_option = $order_product['order_option'];
                            } elseif (isset($this->request->get['order_id'])) {
                                $order_option = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
                            } else {
                                $order_option = array();
                            }
                            $this->cart->add($order_product['product_id'], $order_product['quantity'], $order_option);
                            $order_products_count++;
                            array_push($order_products_array, $order_product['product_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_products_array'] = $order_products_array;
                        //if (!empty())
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_products_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_products_array'] = array();
                    }
                    //Herbals
                    $order_herbals = $this->model_pos_pos->getOrderCartherbal($all_order['order_id']);
                    if (!empty($order_herbals)) {
                        $get_order['orders'][$all_order['order_id']]['order_herbals_status'] = 1;
                        foreach ($order_herbals as $order_herbal) {
                            $order_herbals_count++;
                            array_push($order_herbals_array, $order_herbal['clinical_sale_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_herbals_array'] = $order_herbals_array;
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_herbals_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_herbals_array'] = array();
                    }
                    //Services
                    $order_services = $this->model_pos_pos->getOrderCartServices($all_order['order_id']);
                    if (!empty($order_services)) {
                        $get_order['orders'][$all_order['order_id']]['order_services_status'] = 1;
                        foreach ($order_services as $order_service) {
                            $order_services_count++;
                            array_push($order_services_array, $order_service['service_form_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_services_array'] = $order_services_array;
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_services_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_services_array'] = array();
                    }
                } else {
                    //$get_order['orders'][$all_order['order_id']]['order_status'] = 1;
                    array_push($non_chewc_orders_array, $all_order['order_id']);
                    $non_chewc_count++;
                }
                $all_orders_count++;
                array_push($all_orders_array, $all_order['order_id']);
            }
        }
        $get_order['all_orders_count'] = $all_orders_count;
        $get_order['all_orders_array'] = $all_orders_array;
        $get_order['chewc_count'] = $chewc_count;
        $get_order['chewc_orders_array'] = $chewc_orders_array;
        $get_order['non_chewc_count'] = $non_chewc_count;
        $get_order['non_chewc_orders_array'] = $non_chewc_orders_array;
        //$get_order['all_orders']       = $all_orders;
        echo '<pre>';
        print_r($get_order);
        echo '</pre>';
    }

    public function runOrderTotal() {
        $this->load->model('herbal/new_herbal');
        $this->load->model('pos/pos');
        $this->load->model('catalog/product');
        $this->load->model('customer/customer');
        $this->load->model('sale/order');

        $this->load->language('pos/pos');
        $this->load->language('customer/customer');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);

        $invoice_prefix = $this->request->get['invoice_prefix'];

        $get_order = array();
        $order_count = 0;
        //chewc check herbal exists with consultation
        $chewc_count = 0;
        $chwec_boolean = false;
        $orders = $this->model_herbal_new_herbal->getAllOrderByDate($invoice_prefix);
        if (!empty($orders)) {
            foreach ($orders as $order) {
                //$this->cart->clear();
                $get_order['allorder'][] = $order['order_id'];
                $chewc = $this->model_herbal_new_herbal->checkOrderExists($order['order_id']);
                if (!empty($chewc)) {
                    $get_order['chewcorder'][] = $order['order_id'];
                    $get_order['orders'][$order['order_id']] = array(
                        'order_id' => $order['order_id'],
                        'invoice_prefix' => $order['invoice_prefix'],
                        'store_id' => $order['store_id'],
                        'customer_id' => $order['customer_id'],
                        'payment_method' => $order['payment_method'],
                        'payment_code' => $order['payment_code'],
                        'shipping_address_id' => $order['shipping_address_id'],
                        'shipping_method' => $order['shipping_method'],
                        'shipping_code' => $order['shipping_code'],
                        'shipping_total' => $order['shipping_total'],
                        'date_added' => $order['date_added'],
                    );

                    $customer = $this->model_pos_pos->getCustomer($order['customer_id']);
                    if (!empty($customer)) {
                        $get_order['orders'][$order['order_id']]['customer'][$order['customer_id']] = array(
                            'customer_id' => $customer['customer_id'],
                            'firstname' => $customer['firstname'],
                            'customer_ic' => $customer['customer_ic'],
                            'customer_card' => $customer['customer_card'],
                            'validdate' => $customer['customer_validdate'],
                        );
                    } else {
                        $get_order['orders'][$order['order_id']]['customer'] = array(
                            'customer_id' => 0,
                            'firstname' => $this->language->get('walk_in_customer'),
                            'customer_ic' => '',
                            'customer_card' => '',
                            'validdate' => '',
                        );
                    }

                    $shipping = $this->model_customer_customer->getAddresses($order['customer_id']);
                    if (!empty($shipping)) {
                        $get_order['orders'][$order['order_id']]['shipping'] = $shipping;
                    } else {
                        $get_order['orders'][$order['order_id']]['shipping'] = '';
                    }

                    if (!empty($order['shipping_address_id'])) {
                        $this->session->data['shipping_address_id'] = $order['shipping_address_id'];
                        $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($order['shipping_address_id']);
                        $get_order['orders'][$order['order_id']]['shipping_address'] = $this->session->data['shipping_address'];
                    } else {
                        $get_order['orders'][$order['order_id']]['shipping_address'] = '';

                        $this->session->data['shipping_address_id'] = 0;
                    }

                    $data['shipping_methods'] = array();
                    $default_country_id = $this->config->get('config_country_id');
                    $default_zone_id = $this->config->get('config_zone_id');


                    if (!empty($order['shipping_address_id'])) {
                        $method_data = array();
                        $this->load->model('extension/extension');
                        $results = $this->model_extension_extension->getExtensions('shipping');
                        $loop = 1;
                        foreach ($results as $result) {
                            if ($this->config->get($result['code'] . '_status')) {
                                $this->load->model('shipping/' . $result['code']);

                                $quote = $this->{'model_shipping_' . $result['code']}->getQuote($shipping);
                                if ($quote) {
                                    $method_data[$result['code']] = array(
                                        'title' => $quote['title'],
                                        'quote' => $quote['quote'],
                                        'sort_order' => $quote['sort_order'],
                                        'error' => $quote['error']
                                    );
                                }
                            }
                        }
                        $sort_order = array();


                        foreach ($method_data as $key => $value) {
                            $sort_order[$key] = $value['sort_order'];
                        }

                        array_multisort($sort_order, SORT_ASC, $method_data);

                        $this->session->data['shipping_methods'] = $method_data;
                        $data['shipping_methods'] = $method_data;
                        $loop = 1;
                        foreach ($data['shipping_methods'] as $shipping_method) {

                            if ($loop == 1) {
                                foreach ($shipping_method['quote'] as $quote) {
                                    $shipping_data = explode('.', $quote['code']);
                                }
                            }
                            $loop++;
                        }
                        $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
                    }

                    if (!empty($order['shipping_code']) && $order['shipping_code'] != 'pickup.pickup') {
                        $shipping_data = explode('.', $order['shipping_code']);
                        $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
                    }

                    $add_product_to_cart_count = 0;
                    $order_products = $this->model_sale_order->getOrderCartProducts($order['order_id']);
                    if (!empty($order_products)) {
                        //$get_order['orders'][$order['order_id']]['order_products'] = $order_products;
                        foreach ($order_products as $order_product) {
                            if (isset($order_product['order_option'])) {
                                $order_option = $order_product['order_option'];
                            } elseif (isset($this->request->get['order_id'])) {
                                $order_option = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
                            } else {
                                $order_option = array();
                            }
                            $this->cart->add($order_product['product_id'], $order_product['quantity'], $order_option);
                            $add_product_to_cart_count++;
                        }
                    }

                    $get_product_from_cart_count = 0;
                    if (!empty($this->cart->getProducts())) {
                        foreach ($this->cart->getProducts() as $product) {
                            $option_data = array();

                            foreach ($product['option'] as $option) {
                                if ($option['type'] != 'file') {
                                    $value = $option['value'];
                                } else {
                                    $filename = $this->encryption->decrypt($option['value']);

                                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                                }
                                $option_data[] = array(
                                    'name' => $option['name'],
                                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                                    'type' => $option['type']
                                );
                            }
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($product['price']);
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($sub_tax['total'] * $product['quantity']);
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $product['quantity']);
                            $get_order['orders'][$order['order_id']]['products'][] = array(
                                'key' => $product['key'],
                                'name' => $product['name'],
                                'code' => $product['code'],
                                'model' => $product['model'],
                                'unitprice' => $product['unitprice'],
                                'reward' => $product['reward'],
                                'points' => $product['points'],
                                'option' => $option_data,
                                'quantity' => $product['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
                            );
                            $get_product_from_cart_count++;
                        } //foreach product in cart generate html
                    }
                    //Herbal
                    //$this->cart->clearHerbal();
                    //unset($this->session->data['herbal']);
                    $add_herbal_to_cart_count = 0;
                    $order_herbals = $this->model_pos_pos->getOrderCartherbal($order['order_id']);
                    if (!empty($order_herbals)) {
                        $get_order['orders'][$order['order_id']]['order_herbals'] = $order_herbals;
                        foreach ($order_herbals as $order_herbal) {
                            $this->cart->addHerbal($order_herbal['clinical_sale_id'], 1);
                            $add_herbal_to_cart_count++;
                        }
                    }

                    $get_order['orders'][$order['order_id']]['add_herbal_to_cart_count'] = $add_herbal_to_cart_count;

                    $get_herbal_from_cart_count = 0;
                    if (!empty($this->cart->getHerbals())) {
                        foreach ($this->cart->getHerbals() as $herbale) {
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($herbale['price']);
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($herbale['price'], $herbale['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($herbale['price'] * $herbale['quantity']);
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $herbale['quantity']);
                            $get_order['orders'][$order['order_id']]['herbals'][$herbale['key']] = array(
                                'key' => $herbale['key'],
                                'name' => $herbale['name'],
                                'unitprice' => $herbale['unitprice'],
                                'invoice_prefix' => $herbale['invoice_prefix'],
                                'gst' => $herbale['gst'],
                                'customer_ic' => $herbale['customer_ic'],
                                'quantity' => $herbale['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                            );
                        } //foreach product in herbls generate html
                    }
                    //Services
                    //$this->cart->clearService();
                    $add_service_to_cart_count = 0;
                    $order_services = $this->model_pos_pos->getOrderCartServices($order['order_id']);
                    if (!empty($order_services)) {
                        $get_order['orders'][$order['order_id']]['order_services'] = $order_services;
                        foreach ($order_services as $order_service) {
                            $this->cart->addService($order_service['service_form_id'], 1);
                            $add_service_to_cart_count++;
                        }
                    }
                    $get_service_from_cart_count = 0;
                    if (!empty($this->cart->getServices())) {
                        foreach ($this->cart->getServices() as $service) {
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($service['price']);
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($service['price'], $service['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($service['price'] * $service['quantity']);
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $service['quantity']);
                            $get_order['orders'][$order['order_id']]['services'][] = array(
                                'key' => $service['key'],
                                'name' => $service['name'],
                                'unitprice' => $service['unitprice'],
                                'invoice_prefix' => $service['invoice_prefix'],
                                'gst' => $service['gst'],
                                'customer_ic' => $service['customer_ic'],
                                'quantity' => $service['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                            );
                            $get_service_from_cart_count++;
                        } //foreach product in services generate html
                    }

                    //$this->cart->clearService();
                    //$this->cart->clearHerbal();
                    //$this->cart->clear();

                    $this->load->model('pos/extension');
                    $total_data = array();

                    $totals = array();
                    $taxes = $this->cart->getTaxes();
                    $total = 0;

                    $total_data = array(
                        'totals' => &$totals,
                        'taxes' => &$taxes,
                        'total' => &$total
                    );

                    /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                    $sort_order = array();
                    $results = $this->model_pos_extension->getExtensions('total');
                    foreach ($results as $key => $value) {
                        $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
                    }
                    array_multisort($sort_order, SORT_ASC, $results);
                    foreach ($results as $result) {
                        if ($this->config->get($result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                            $this->load->model('pos/' . $result['code']);

                            $this->{'model_pos_' . $result['code']}->getTotal($total_data, $total, $taxes);
                        }
                        $sort_order = array();
                        foreach ($total_data as $key => $value) {
                            $sort_order[$key] = $value['sort_order'];
                        }
                        array_multisort($sort_order, SORT_ASC, $total_data);
                    }
                    //}
                    /* $get_order['orders'][$order['order_id']]['test_shipping_address_id'] = $this->session->data['shipping_address_id'];
                      $get_order['orders'][$order['order_id']]['test_shipping_address'] = $this->session->data['shipping_address']; */
                    $get_order['orders'][$order['order_id']]['total_data'] = $total_data;

                    $get_order['orders'][$order['order_id']]['total'] = $this->currency->format($total);
                    $chwec_boolean = true;
                    $get_order['orders'][$order['order_id']]['chewc_boolean'] = $chwec_boolean;
                    $chewc_count++;

                    $this->model_herbal_new_herbal->updatErrorOrderTotal($get_order['orders'][$order['order_id']]);
                }
                $order_count++;
                //$this->cart->clearService();
                //$this->cart->clearHerbal();
                $this->cart->clear();
                unset($this->session->data['shipping_address']);
                unset($this->session->data['shipping_address_id']);
                unset($this->session->data['shipping_method']);
            } //order loop end
        }
        $get_order['order_count'] = $order_count;
        $get_order['chewc_count'] = $chewc_count;
        echo '<pre>';
        print_r($get_order);
        echo '</pre>';
    }

    public function runHerbalTotal() {
        $this->load->model('herbal/new_herbal');
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        $this->load->model('user/user');
        $herbals = $this->model_herbal_new_herbal->getErrorHerbal();
        //$test2 = array();

        $ot1_subtotal = 0;
        $ot1_tax = 0;
        $ot1_total = 0;
        $ot2_subtotal = 0;
        $ot2_tax = 0;
        $ot2_total = 0;

        $concultation_subtotal = 0;
        $concultation_tax = 0;
        $concultation_total = 0;

        $pos_subtotal = 0;
        $pos_tax = 0;
        $pos_total = 0;

        foreach ($herbals as $hid => $herbal) {
            $user_details = $this->model_user_user->getUser($herbal['doctor_id']);
            if ($herbal['collect_consultation_price'] == 1) {
                $doctor_taxes = $this->tax->calculateTax($herbal['clinicalsale_concultation'], $user_details['tax_class_id']);
                $concultation_subtotal = $doctor_taxes['net_amount'];
                $concultation_tax = $doctor_taxes['tax'];
                $concultation_total = $doctor_taxes['total'];
            }

            $test[$herbal['clinical_sale_id']] = array(
                'clinical_sale_id' => $herbal['clinical_sale_id'],
                'invoice_prefix' => $herbal['invoice_prefix'],
                'collect_consultation_price' => $herbal['collect_consultation_price'],
                'clinicalsale_concultation' => $herbal['clinicalsale_concultation'],
                'doctor_id' => $herbal['doctor_id'],
                'tax_class_id' => $user_details['tax_class_id'],
                'sales_date' => $herbal['sales_date'],
                'concultation_subtotal' => $concultation_subtotal,
                'concultation_tax' => $concultation_tax,
                'concultation_total' => $concultation_total,
            );

            $cs_subtotal = 0;
            $cs_tax = 0;
            $cs_total = 0;
            $cs_rounding = 0;
            $herbal_totals = $this->model_herbal_new_herbal->getErrorHerbalTotal($herbal['clinical_sale_id']);
            foreach ($herbal_totals as $herbal_total) {
                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'sub_total') {
                    $cs_subtotal = $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'tax') {
                    $cs_tax += $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'total') {
                    $cs_total = $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'rounding') {
                    $cs_rounding = $herbal_total['value'];
                }

                $test[$herbal['clinical_sale_id']]['cs_subtotal'] = $cs_subtotal;
                $test[$herbal['clinical_sale_id']]['cs_tax'] = $cs_tax;
                $test[$herbal['clinical_sale_id']]['cs_total'] = $cs_total;
                $test[$herbal['clinical_sale_id']]['cs_rounding'] = $cs_rounding;

                $test[$herbal['clinical_sale_id']]['clinicalsale_total'][$herbal_total['id']][$herbal_total['clinical_sale_total_id']] = array(
                    'clinical_sale_total_id' => $herbal_total['clinical_sale_total_id'],
                    'clinical_sale_id' => $herbal_total['clinical_sale_id'],
                    'id' => $herbal_total['id'],
                    'code' => $herbal_total['code'],
                    'tax_key' => $herbal_total['tax_key'],
                    'tax_code' => $herbal_total['tax_code'],
                    'title' => $herbal_total['title'],
                    'value' => $herbal_total['value'],
                    'sort_order' => $herbal_total['sort_order'],
                );
            }

            $pos_subtotal = $concultation_subtotal + $cs_subtotal;
            $pos_tax = $concultation_tax + $cs_tax /* + $cs_rounding */;
            $pos_total = $concultation_total + $cs_total;

            $test[$herbal['clinical_sale_id']]['pos_subtotal'] = $pos_subtotal;
            $test[$herbal['clinical_sale_id']]['pos_tax'] = $pos_tax;
            $test[$herbal['clinical_sale_id']]['pos_total'] = $pos_total;
            $test[$herbal['clinical_sale_id']]['final_total'] = $cs_total + $pos_total;

            $final_total = $cs_total + $pos_total;

            $data = array(
                'clinical_sale_id' => $herbal['clinical_sale_id'],
                'd_net_amount' => $pos_subtotal,
                'd_gst' => $pos_tax,
                'total_d_gst' => $pos_total,
                'total' => $final_total,
            );

            $this->model_herbal_new_herbal->updateErrorHerbal($data);

            $herbal_totals2 = $this->model_herbal_new_herbal->getErrorHerbalTotal($herbal['clinical_sale_id']);
            if (!empty($herbal_totals2)) {
                foreach ($herbal_totals2 as $hid => $herbal_total2) {
                    if ($herbal_total2['id'] == 2) {
                        if ($herbal['clinical_sale_id'] == $herbal_total2['clinical_sale_id']) {
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['clinical_sale_total_id'] = $herbal_total2['clinical_sale_total_id'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['clinical_sale_id'] = $herbal_total2['clinical_sale_id'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['code'] = $herbal_total2['code'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['id'] = $herbal_total2['id'];
                            if ($herbal_total2['code'] == 'sub_total') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_subtotal;
                            }
                            if ($herbal_total2['code'] == 'tax') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_tax;
                            }
                            if ($herbal_total2['code'] == 'total') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_total;
                            }
                        }

                        $this->model_herbal_new_herbal->updateErrorHerbalTotal($get[$herbal['clinical_sale_id']]);
                    }
                }
            }
        }

        echo '<pre>';
        print_r($data);
        echo '</pre>';

        echo '<pre>';
        print_r($get);
        echo '</pre>';

        echo '<pre>';
        print_r($test);
        echo '</pre>';
    }

    public function DateModify() {

        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/new_herbal');

        $json = array();

        $json['error_code'] = array(
            'error' => 0,
            'msj' => 'Succes',
        );

        date_default_timezone_set("Asia/Kuala_Lumpur");
        $passed_time = $this->model_herbal_new_herbal->getHerbalDateModified($this->request->get['herbal_id']);
        $current_time = date('Y-m-d H:i:s');
        $date_added = strtotime($passed_time);
        $date_now = strtotime($current_time);
        $diff = $date_now - $date_added;

        if ($diff < 10) {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => $this->language->get('update_error'),
            );
        }

        $json['current_time'] = $current_time;
        $json['passed_time'] = $passed_time;
        $json['interval'] = '';
        $json['diff'] = $diff;

        /* if ($this->session->data['date_modified'] < $date_modified) {
          $json['error_code'] = array(
          'error' => 1,
          'msj' => $this->language->get('update_error'),
          );
          } */
        $this->response->setOutput(json_encode($json));
    }

    public function check_got_saved_medical_record() {
        $this->load->model('herbal/new_herbal');
        $json = [];
        $saved = $this->model_herbal_new_herbal->check_got_saved_medical_record();
        if (!empty($saved)) {
            $json['success'] = 1;
        }
        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function tickToTop() {
        $this->load->model('herbal/new_herbal');
        $json = [];
        if (!empty($this->request->post['herbal_id'])) {
            $top = $this->request->post['top'];
            $herbal_id = $this->request->post['herbal_id'];
            $this->model_herbal_new_herbal->tickToTop($herbal_id, $top);
            $json['success'] = 1;
        }
        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($this->config->get('total_' . $result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            }

            $sort_order = array();

            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        return $totals;
    }

    public function getPrescription() {
        $data = array();
        $data['prescription'] = array();
        $data['products'] = array();
        foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );

            if (isset($this->session->data['product'][$prescription_id])) {
                foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                    $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];
                    $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                    $total = $this->currency->format($sub_tax['total']);
                    $tax = $this->currency->format($sub_tax['tax']);
                    $subtotal = $this->currency->format($sub_tax['net_amount']);


                    $data['products'][$prescription_id][] = array(
                        'product_id' => $products['product_id'],
                        'name' => $products['name'],
                        'code' => $products['code'],
                        'quantity' => $products['quantity'],
                        'times' => $products['times'],
                        'cook' => $products['cook'],
                        'taketype' => $products['taketype'],
                        'stock' => $products['stock'],
                        'day' => $products['day'],
                        'price' => $products['price'],
                        'discount' => $products['discount'],
                        'subtotal' => $subtotal,
                        'total' => $total,
                        'tax' => $tax,
                        'tax_class_id' => $products['tax_class_id'],
                        'weight' => $products['weight'],
                        'weight_class_id' => $products['weight_class_id'],
                        'weight_format' => $products['weight']
                    );
                } //end products
            }
        }

        return $data;
    }

    public function getService() {
        $data = array();
        $data['service'] = array();

        foreach ($this->cart->getService() as $key => $service) {

            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $this->currency->format($sub_tax['total']);
            $tax = $this->currency->format($sub_tax['tax']);
            $subtotal = $this->currency->format($sub_tax['net_amount']);

            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }

        return $data;
    }

    public function getAcupunctureList() {
        $data = array();
        $data['acupuncture_list'] = array();

        foreach ($this->cart->getAcupunctureList() as $key => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {

                if ($acupuncture['acupuncture_id'] > 0) {
                    $acupuncture_name = $this->model_herbal_new_herbal->getAcupunctureNameById($acupuncture['acupuncture_id']);
                } else {
                    $acupuncture_name = '';
                }

                $data['acupuncture_list'][$key][] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        return $data;
    }

    public function getImages() {

        $this->load->model('herbal/new_herbal');

        $data['herbal_image'] = $this->model_herbal_new_herbal->getImage($this->request->post['herbal_id']);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data['herbal_image']));
    }

    public function printSticker() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/new_herbal');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $herbal_id = $this->request->get['herbal_id'];

        $basic_data = $this->model_herbal_new_herbal->getHerbalRemediesBasicData($herbal_id);

        $data['customer_name'] = $basic_data['customer_name'];
        $data['customer_ic'] = $basic_data['customer_ic'];
        $data['invoice_prefix'] = $basic_data['invoice_prefix'];
        $data['date_added'] = date($this->language->get('date_format_short'), strtotime($basic_data['date_added']));
        $data['doctor_name'] = $basic_data['doctor_name'];
        $data['telephone'] = $basic_data['telephone'];

        $data['diagnostic'] = $basic_data['diagnostic'];
        $data['doctoradvice'] = $basic_data['doctoradvice'];
        $data['pulse'] = $basic_data['pulse'];
        $data['disease'] = $basic_data['disease'];
        $data['treatment'] = $basic_data['treatment'];
        $data['acupuncture'] = $basic_data['acupuncture'];
        $data['symptom'] = $basic_data['symptom'];

        $data['times'] = $basic_data['times'];
        $data['day'] = $basic_data['day'];
        $data['cook'] = $basic_data['cook'];
        $data['taketype'] = $basic_data['taketype'];

        if ($basic_data['gender'] == '1') {
            $data['gender'] = $this->language->get('text_male');
        } else {
            $data['gender'] = $this->language->get('text_female');
        }

        $data['current_language'] = $this->session->data['language'];

        $herbal_remedies = $this->model_herbal_new_herbal->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals'] = array();

        foreach ($herbal_remedies as $prescription_id => $prescription) {
            $data['remedies'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $data['products'][$prescription_id][] = array(
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'weight' => round($products['quantity'] * $products['weight']) . 'g'
                );
            }
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        $herbal_remedies_image = $this->model_herbal_new_herbal->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            //$page_size =  $this->config->get('pdf_invoice_page_size').$page_format;
            $data['pdf'] = true;

            $page_size = array(500, 80);

            $this->response->setOutput($pdf->pdf($this->load->view('herbal/new_herbal_sticker_pdf', $data), $pdf_file_name, $page_size, $show));
        }


        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('herbal/new_herbal_sticker_pdf', $data));
        }
    }

    public function addProductToDB($data) {
        $this->db->query("
	        INSERT INTO 
	            `oc_product` 
	                SET model = '" . $this->db->escape($data['model']) . "', 
	                    code = '" . $this->db->escape($data['code']) . "', 
	                    quantity = '" . (int) $data['quantity'] . "', 
	                    minimum = '1', 
	                    subtract = '1', 
	                    stock_status_id = '1', 
	                    date_available = NOW(), 
	                    shipping = '0', 
	                    price = '" . (float) $data['sellingprice'] . "', 
	                    costprice = '" . (float) $data['sellingprice'] . "', 
	                    selling_product = '1', 
	                    product_type = '1', 
	                    points = '0', 
	                    weight = '1', 
	                    weight_class_id = '1', 
	                    status = '1', 
	                    internal_status = '1', 
	                    tax_class_id = '11', 
	                    sort_order = '1', 
	                    add_by = '" . (int) $this->session->data['user_id'] . "', 
	                    modify_by = '" . (int) $this->session->data['user_id'] . "', 
	                    date_added = NOW()");
        $product_id = $this->db->getLastId();
        if (!empty($product_id)) {
            if (!empty($data['product_description'])) {
                foreach ($data['product_description'] as $language_id => $value) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "product_description SET product_id = '" . (int) $product_id . "', language_id = '" . (int) $language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', tag = '" . $this->db->escape($value['name']) . "', meta_title = '" . $this->db->escape($value['name']) . "', meta_description = '" . $this->db->escape($value['name']) . "', meta_keyword = '" . $this->db->escape($value['name']) . "'");
                }
            }
        }
        return $product_id;
    }

    public function addNewProduct() {
        $this->load->language('catalog/product');

        $this->load->model('catalog/product');

        $this->session->data['success'] = '';
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateProductForm()) {
            $this->addProductToDB($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            if (!empty($this->request->get['herbal_id'])) {
                //$this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&herba_id=' . $this->request->get['herbal_id'], true));
            }
        }

        $this->addNewProductForm();
    }

    public function addNewProductForm() {
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
        } else {
            $data['success'] = '';
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        if (isset($this->error['description'])) {
            $data['error_description'] = $this->error['description'];
        } else {
            $data['error_description'] = array();
        }

        if (isset($this->error['model'])) {
            $data['error_model'] = $this->error['model'];
        } else {
            $data['error_model'] = '';
        }

        if (isset($this->error['code'])) {
            $data['error_code'] = $this->error['code'];
        } else {
            $data['error_code'] = '';
        }

        if (isset($this->request->post['product_description'])) {
            $data['product_description'] = $this->request->post['product_description'];
        } else {
            $data['product_description'] = array();
        }

        if (isset($this->request->post['model'])) {
            $data['model'] = $this->request->post['model'];
        } else {
            $data['model'] = null;
        }

        if (isset($this->request->post['code'])) {
            $data['code'] = $this->request->post['code'];
        } else {
            $data['code'] = null;
        }

        if (isset($this->request->post['sellingprice'])) {
            $data['sellingprice'] = $this->request->post['sellingprice'];
        } else {
            $data['sellingprice'] = 1;
        }

        if (isset($this->request->post['quantity'])) {
            $data['quantity'] = $this->request->post['quantity'];
        } else {
            $data['quantity'] = 1;
        }

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $this->response->setOutput($this->load->view('herbal/add_new_product', $data));
    }

    protected function validateProductForm() {
        if (!$this->user->hasPermission('modify', 'catalog/product') && !$this->user->userPermissions('modify', 'catalog/product')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['product_description'] as $language_id => $value) {
            if ((utf8_strlen($value['name']) < 1) || (utf8_strlen($value['name']) > 255)) {
                $this->error['name'][$language_id] = $this->language->get('error_name');
            }

            if ((utf8_strlen($value['description']) < 1) || (utf8_strlen($value['description']) > 255)) {
                $this->error['description'][$language_id] = $this->language->get('error_meta_title');
            }
        }

        if ((utf8_strlen($this->request->post['model']) < 1) || (utf8_strlen($this->request->post['model']) > 64)) {
            $this->error['model'] = $this->language->get('error_model');
        }

        if ((utf8_strlen($this->request->post['code']) < 1) || (utf8_strlen($this->request->post['code']) > 64)) {
            $this->error['code'] = $this->language->get('error_code');
        }

        $product_info = $this->model_catalog_product->getProductByCode($this->request->post['code']);
        if (!isset($this->request->get['product_id'])) {
            if ($product_info) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        } else {
            if ($product_info && ($this->request->get['product_id'] != $product_info['product_id'])) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function medicalCert() {
        $this->load->model('herbal/new_herbal');

        $this->load->language('herbal/print_prescription');

        $this->document->addStyle('view/stylesheet/invoicea5.css?v=' . time());

        $data = [];
        $data['logo_image'] = HTTPS_CATALOG . 'image/catalog/cop_image.png';
        $data['direction'] = $this->language->get('direction');
        $data['lang'] = $this->language->get('code');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        if (isset($this->request->post['selected'])) {
            $herbals = $this->request->post['selected'];
        } elseif (isset($this->request->get['herbal_id'])) {
            $herbals[] = $this->request->get['herbal_id'];
        }

        $data['herbals'] = [];
        if (!empty($herbals)) {

            foreach ($herbals as $herbal_id) {

                if (!empty($herbal_id)) {

                    $this->load->model('setting/setting');

                    $this->load->model('localisation/country');

                    $this->load->model('localisation/zone');

                    $basic_data = $this->model_herbal_new_herbal->getHerbalRemediesBasicData($herbal_id);
                    $store_info = $this->model_setting_setting->getSetting('config', $basic_data['store_id']);
                    $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                    $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                    if ($store_info) {
                        $store_name = $store_info['config_name'];
                        $store_address = $store_info['config_address'];
                        $store_telephone = $store_info['config_telephone'];
                        $store_fax = $store_info['config_fax'];
                        $store_number = $store_info['config_number'];
                        $store_gstno = $store_info['config_gstno'];
                        $store_country = $country['name'];
                        $store_zone = $zone['name'];
                        $store_email = $store_info['config_email'];
                    } else {
                        $store_name = $this->config->get('config_name');
                        $store_address = $this->config->get('config_address');
                        $store_telephone = $this->config->get('config_telephone');
                        $store_fax = $this->config->get('config_fax');
                        $store_number = '';
                        $store_gstno = '';
                        $store_country = '';
                        $zone = '';
                        $store_email = $this->config->get('config_email');
                    }

                    if ($basic_data['gender'] == '1') {
                        $data['gender_text'] = 'He';
                        $data['gender_text2'] = 'his';
                    } else {
                        $data['gender_text'] = 'She';
                        $data['gender_text2'] = 'her';
                    }

                    $data['herbals'][] = array(
                        'herbal_id' => $herbal_id,
                        'invoice_no' => $basic_data['invoice_prefix'],
                        'customer_name' => $basic_data['customer_name'],
                        'date_added' => date($this->language->get('date_format_short'), strtotime($basic_data['date_added'])),
                        'store_name' => $store_name,
                        'store_gstno' => $store_gstno,
                        'store_country' => $store_country,
                        'store_number' => $store_number,
                        'store_zone' => $store_zone,
                        'store_address' => nl2br($store_address),
                        'store_telephone' => $store_telephone,
                        'store_email' => $store_email,
                        'store_fax' => $store_fax,
                        'telephone' => $basic_data['telephone'],
                        'customer_ic' => $basic_data['customer_ic'],
                        'physician_name' => $basic_data['doctor_name'],
                    );

                    $data['pdf'] = false;
                    $pdf_file_name = date('Ymd_His') . '.pdf';
                    if (isset($this->request->get['pdf'])) {
                        $pdf = new PDF();
                        //PDF INVOICE
                        $data['pdf'] = true;
                        $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                        $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                        $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                        $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');

                        $data['is_pdf'] = true;

                        include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';
                        $mpdf = new mPDF('utf-8', 'A5-L');
                        $mpdf->writeHTML($this->load->view('herbal/new_medical_cert', $data));
                        $mpdf->Output($pdf_file_name, 'I');
                    }
                }
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('herbal/new_medical_cert', $data));
        }
    }

    public function printA5() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/new_herbal');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $herbal_id = $this->request->get['herbal_id'];

        $basic_data = $this->model_herbal_new_herbal->getHerbalRemediesBasicData($herbal_id);

        $data['customer_name']  = $basic_data['customer_name'];
        $data['customer_ic']    = $basic_data['customer_ic'];
        $data['invoice_prefix'] = $basic_data['invoice_prefix'];
        $data['date_added']     = date($this->language->get('date_format_short'), strtotime($basic_data['date_added']));
        $data['doctor_name']    = $basic_data['doctor_name'];
        $data['telephone']      = $basic_data['telephone'];

        $data['diagnostic']     = $basic_data['diagnostic'];
        $data['doctoradvice']   = $basic_data['doctoradvice'];
        $data['pulse']          = $basic_data['pulse'];
        $data['disease']        = $basic_data['disease'];
        $data['treatment']      = $basic_data['treatment'];
        $data['acupuncture']    = $basic_data['acupuncture'];
        $data['symptom']        = $basic_data['symptom'];

        $data['times']          = $basic_data['times'];
        $data['day']            = $basic_data['day'];
        $data['cook']           = $basic_data['cook'];
        $data['taketype']       = $basic_data['taketype'];
        $data['weight']         = $this->weight->format($basic_data['weight'], $basic_data['weight_class_id']);

        if ($basic_data['gender'] == '1') {
            $data['gender'] = $this->language->get('text_male');
        } else {
            $data['gender'] = $this->language->get('text_female');
        }

        $data['current_language'] = $this->session->data['language'];

        $herbal_remedies = $this->model_herbal_new_herbal->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals'] = array();

        foreach ($herbal_remedies as $prescription_id => $prescription) {
            $data['remedies'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $data['products'][$prescription_id][] = array(
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'weight' => round($products['quantity'], 2) . 'g', //* $products['weight']) 
                );
            }
        }
        $data['store_address'] = nl2br($this->config->get('config_address'));

        $data['store_address'] = nl2br($this->config->get('config_address'));
        $store_info = $this->model_setting_setting->getSetting('config', $this->session->data['store_id']);
        $country_info = $this->model_localisation_country->getCountry($store_info['config_country_id']);
        $data['country'] = $country_info['name'];
        $zone_info =  $this->model_localisation_zone->getZone($store_info['config_zone_id']);
        $data['zone'] = $zone_info['name'];
        $data['compony_telephone'] = $this->config->get('config_telephone');
        $data['store_name1'] = $this->config->get('config_name');
        $data['store_gstno'] = $store_info['config_gstno'];

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $herbal_remedies_image = $this->model_herbal_new_herbal->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view('herbal/herbal_remedies_pdf3', $data), $pdf_file_name, $page_size, $show));
        }


        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('herbal/herbal_remedies_pdf3', $data));
        }
    }

    public function printPrescriptionStickers() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/new_herbal');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['direction']               = $this->language->get('direction');
        $data['lang']                    = $this->language->get('code');

        $data['text_invoice_prefix']     = $this->language->get('text_invoice_prefix');
        $data['text_date_added']         = $this->language->get('text_date_added');
        $data['text_doctor_name']        = $this->language->get('text_doctor_name');
        $data['text_customer_name']      = $this->language->get('text_customer_name');
        $data['text_customer_ic']        = $this->language->get('text_customer_ic');
        $data['text_customer_gender']    = $this->language->get('text_customer_gender');
        $data['text_customer_telephone'] = $this->language->get('text_customer_telephone');
        $data['text_phone']              = $this->language->get('text_phone');
        $data['text_regno']              = $this->language->get('text_regno');
        $data['text_diagnostic']         = $this->language->get('text_diagnostic');
        $data['text_pulse']              = $this->language->get('text_pulse');
        $data['text_symptom']            = $this->language->get('text_symptom');
        $data['text_treatment']          = $this->language->get('text_treatment');
        $data['text_doctoradvice']       = $this->language->get('text_doctoradvice');
        $data['text_acupuncture']        = $this->language->get('text_acupuncture');
        $data['text_disease']            = $this->language->get('text_disease');
        $data['text_doctor_signature']   = $this->language->get('text_doctor_signature');
        $data['text_validate_signature'] = $this->language->get('text_validate_signature');
        $data['text_taketype']           = $this->language->get('text_taketype');
        $data['text_cook']               = $this->language->get('text_cook');
        $data['text_times']              = $this->language->get('text_times');
        $data['text_day']                = $this->language->get('text_day');
        $data['text_times_per_day']      = $this->language->get('text_times_per_day');

        $herbal_id = $this->request->get['herbal_id'];

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $basic_data = $this->model_herbal_new_herbal->getHerbalRemediesBasicData($herbal_id);

        $store_info = $this->model_setting_setting->getSetting('config', $basic_data['store_id']);
        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

        if ($store_info) {
            $store_name      = $store_info['config_name'];
            $store_address   = $store_info['config_address'];
            $store_telephone = $store_info['config_telephone'];
            $store_fax       = $store_info['config_fax'];
            $store_number    = $store_info['config_number'];
            $store_gstno     = $store_info['config_gstno'];
            $store_country   = $country['name'];
            $store_zone      = $zone['name'];
            $store_email     = $store_info['config_email'];
        } else {
            $store_name      = $this->config->get('config_name');
            $store_address   = $this->config->get('config_address');
            $store_telephone = $this->config->get('config_telephone');
            $store_fax       = $this->config->get('config_fax');
            $store_number    = '';
            $store_gstno     = '';
            $store_country   = '';
            $zone            = '';
            $store_email     = $this->config->get('config_email');
        }

        $data['store_name']      = $store_name;
        $data['store_number']    = $store_number;
        $data['store_address']   = $store_address;
        $data['store_zone']      = $store_zone;
        $data['store_country']   = $store_country;
        $data['store_telephone'] = $store_telephone;
        $data['customer_name']   = $basic_data['customer_name'];
        $data['customer_ic']     = $basic_data['customer_ic'];
        $data['invoice_prefix']  = $basic_data['invoice_prefix'];
        $data['date_added']      = date($this->language->get('date_format_short'), strtotime($basic_data['date_added']));
        $data['doctor_name']     = $basic_data['doctor_name'];
        $data['telephone']       = $basic_data['telephone'];

        $data['diagnostic']      = $basic_data['diagnostic'];
        $data['doctoradvice']    = $basic_data['doctoradvice'];
        $data['pulse']           = $basic_data['pulse'];
        $data['disease']         = $basic_data['disease'];
        $data['treatment']       = $basic_data['treatment'];
        $data['acupuncture']     = $basic_data['acupuncture'];
        $data['symptom']         = $basic_data['symptom'];

        $data['times']           = $basic_data['times'];
        $data['day']             = $basic_data['day'];
        $data['cook']            = $basic_data['cook'];
        $data['taketype']        = $basic_data['taketype'];

        if ($basic_data['gender'] == '1') {
            $data['gender'] = $this->language->get('text_male');
        } else {
            $data['gender'] = $this->language->get('text_female');
        }

        $data['current_language'] = $this->session->data['language'];

        $herbal_remedies = $this->model_herbal_new_herbal->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals']   = array();

        foreach ($herbal_remedies as $prescription_id => $prescription) {
            $data['remedies'][$prescription_id] = array(
                'key'      => $prescription_id,
                'name'     => $prescription['name'],
                'id'       => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $data['products'][$prescription_id][] = array(
                    'name'   => $products['name'],
                    'code'   => $products['code'],
                    'weight' => $this->weight->format($products['weight'], $products['weight_class_id']),
                );
            }
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        $herbal_remedies_image = $this->model_herbal_new_herbal->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            // header('Content-Type: text/html; charset=utf-8');


            $this->response->setOutput($pdf->pdf($this->load->view('herbal/herbal_remedies_sticker_pdf', $data), $pdf_file_name, $page_size, $show));
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('herbal/herbal_remedies_sticker_pdf', $data));
        }
    }

    public function changeCustomer() {
        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/new_herbal');

        $this->document->setTitle($this->language->get('text_change_customer'));

        $data['herbal_id'] = $this->request->get['herbal_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateChangeCustomer()) {
            //update customer id into cs table
            $this->model_herbal_new_herbal->updateCustomer($data['herbal_id'], $this->request->post['customer_id']);

            $this->response->redirect($this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $data['herbal_id'], true));
        }

        $herbal_data = $this->model_herbal_new_herbal->getHerbal($data['herbal_id']);

        if (($herbal_data['clinicalsale_action'] == '5') && (!empty($herbal_data['order_invoice_prefix']))) {
            $this->response->redirect($this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['heading_title'] = $this->language->get('text_change_customer');

        $data['text_form'] = $this->language->get('text_change_customer');

        $data['entry_invoice_prefix'] = $this->language->get('entry_invoiceprefix');
        $data['entry_customer_ic'] = $this->language->get('entry_customer_ic');
        $data['entry_customer_name'] = $this->language->get('column_name');
        $data['entry_customer_card'] = $this->language->get('entry_customer_card');

        $data['error_not_found'] = $this->language->get('error_not_found');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true)
        ); //breadcrumbs

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($herbal_data)) {
            $data['invoice_prefix'] = $herbal_data['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = '';
        }

        if (isset($this->request->post['customer_name'])) {
            $data['customer_name'] = $this->request->post['customer_name'];
        } else {
            $data['customer_name'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        $data['cancel'] = $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['action'] = $this->url->link('herbal/new_herbal/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/change_customer_form', $data));
    }

    public function setServiceType() {
        $data = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $data['entry_cookmethod']             = $this->language->get('entry_cookmethod');
        $data['entry_perday']                 = $this->language->get('entry_perday');
        $data['entry_unit']                   = $this->language->get('entry_unit');
        $data['entry_times']                  = $this->language->get('entry_times');
        $data['entry_discount']               = $this->language->get('entry_discount');
        $data['entry_medicationtake']         = $this->language->get('entry_medicationtake');
        $data['text_newprescription']         = $this->language->get('text_newprescription');
        $data['text_beformeal']               = $this->language->get('text_beformeal');
        $data['text_aftermeal']               = $this->language->get('text_aftermeal');
        $data['column_productname']           = $this->language->get('column_productname');
        $data['column_productcode']           = $this->language->get('column_productcode');
        $data['column_productprice']          = $this->language->get('column_productprice');
        $data['column_productdis']            = $this->language->get('column_productdis');
        $data['column_producttake']           = $this->language->get('column_producttake');
        $data['column_productcook']           = $this->language->get('column_productcook');
        $data['column_productday']            = $this->language->get('column_productday');
        $data['column_productunit']           = $this->language->get('column_productunit');
        $data['column_producttimes']          = $this->language->get('column_producttimes');
        $data['column_productweight']         = $this->language->get('column_productweight');
        $data['column_productnet']            = $this->language->get('column_productnet');
        $data['column_producttex']            = $this->language->get('column_producttex');
        $data['column_producttotal']          = $this->language->get('column_producttotal');
        $data['column_servicename']           = $this->language->get('column_servicename');
        $data['column_serviceminutes']        = $this->language->get('column_serviceminutes');
        $data['column_staffname']             = $this->language->get('column_staffname');
        $data['entry_service']                = $this->language->get('entry_service');
        $data['column_action']                = $this->language->get('column_action');
        $data['error_empty']                  = $this->language->get('error_empty');
        $data['column_acupuncture_point']     = $this->language->get('column_acupuncture_point');
        $data['column_num_of_acupuncture']    = $this->language->get('column_num_of_acupuncture');
        $data['button_acupuncture_point_add'] = $this->language->get('button_acupuncture_point_add');
        $data['button_remove_acupuncture']    = $this->language->get('button_remove_acupuncture');
        $data['entry_acupuncture_point']      = $this->language->get('entry_acupuncture_point');
        $data['entry_num_of_acupuncture']     = $this->language->get('entry_num_of_acupuncture');
        //New
        $data['error_granule_service_type']   = $this->language->get('error_granule_service_type');

        $data['cook_types']                   = $this->model_herbal_new_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];

        //star post value
        if (isset($this->request->post['service_type'])) {
            $service_type = $this->request->post['service_type'];
        } else {
            $service_type = 'herbs';
        }

        $this->session->data['service_type'] = $service_type;

        $this->cart->setHerbalServiceType($service_type);
        $data['service_type'] = $this->cart->getServiceType();

        //end pos value
        $data['product_exit'] = array();

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total);

        $data['herbal_total'] = $this->getHerbalTotal($total_data);

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription          = $this->getPrescription();
        $getService               = $this->getService();
        $data['prescription']     = $getPrescription['prescription'];
        $data['products']         = $getPrescription['products'];
        $data['service']          = $getService['service'];
        $acupuncture_list         = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput(json_encode($data));
    }

    public function customer_list() {
        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/new_herbal');

        if (isset($this->request->get['customer_name'])) {
            $customer_name = $this->request->get['customer_name'];
        } else {
            $customer_name = NULL;
        }

        if (isset($this->request->get['customer_ic'])) {
            $customer_ic = $this->request->get['customer_ic'];
        } else {
            $customer_ic = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['customer_name'])) {
            $url .= '&customer_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_ic'])) {
            $url .= '&customer_ic=' . urlencode(html_entity_decode($this->request->get['customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['customers'] = array();

        $filter_data = array(
            'customer_name' => $customer_name,
            'customer_ic' => $customer_ic,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_herbal_new_herbal->getTotalCustomers($filter_data);
        $results = $this->model_herbal_new_herbal->getCustomers($filter_data);

        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card']
            );
        }

        $data['text_list']                    = $this->language->get('text_customer_list');
        $data['text_no_results']              = $this->language->get('text_no_results');

        $data['entry_customer_name']          = $this->language->get('column_name');
        $data['entry_customer_ic']            = $this->language->get('entry_customer_ic');

        $data['column_customer_name']         = $this->language->get('column_name');
        $data['column_customer_ic']           = $this->language->get('entry_customer_ic');
        $data['column_customer_card']         = $this->language->get('entry_customer_card');
        $data['column_action']                = $this->language->get('column_action');
        $data['column_acupuncture_point']     = $this->language->get('column_acupuncture_point');
        $data['column_num_of_acupuncture']    = $this->language->get('column_num_of_acupuncture');
        $data['button_acupuncture_point_add'] = $this->language->get('button_acupuncture_point_add');
        $data['button_remove_acupuncture']    = $this->language->get('button_remove_acupuncture');
        $data['entry_acupuncture_point']      = $this->language->get('entry_acupuncture_point');
        $data['entry_num_of_acupuncture']     = $this->language->get('entry_num_of_acupuncture');

        $data['button_filter'] = $this->language->get('button_filter');

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('herbal/new_herbal/customer_list', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['customer_name'] = $customer_name;
        $data['customer_ic'] = $customer_ic;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/customer_name_list', $data));
    }

    public function findCustomer() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $json = array();

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json = $this->model_herbal_new_herbal->getCustomerByIC($data);

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Customer Details";
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function getPatientPrescription() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $json = array();

        $herbal_id = $this->request->get['herbal_id'];

        $herbal_details = $this->model_herbal_new_herbal->getPatientPrescription($herbal_id);

        $json['entry_product_name']   = $this->language->get('entry_productname');
        $json['entry_product_code']   = $this->language->get('entry_productcode');
        $json['entry_quantity']       = $this->language->get('entry_unit');
        $json['entry_times']          = $this->language->get('entry_times');
        $json['entry_day']            = $this->language->get('entry_perday');
        $json['text_no_prescription'] = $this->language->get('text_no_prescription');
        $json['prescriptions']        = $herbal_details;

        return $this->response->setOutput(json_encode($json));
    }

    protected function validateChangeCustomer() {
        if (!$this->user->hasPermission('modify', 'herbal/new_herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {
            $this->error['warning'] = $this->language->get('error_select_customer');
        }

        return !$this->error;
    }

    private function calculateAge($dob) {
        $date_of_birth = date('m/d/Y', strtotime($dob));

        $birthDate = explode("/", $date_of_birth);

        $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

        return $age;
    }

    public function print_array($array) {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }

    //kb
    public function clear_product() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->cart->clear();

        $json = array(
            'success' => true
        );

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function customfield() {
        $json = array();
        $this->load->model('customer/custom_field');
        // Customer Group
        if (isset($this->request->get['customer_group_id'])) {
            $customer_group_id = $this->request->get['customer_group_id'];
        } else {
            $customer_group_id = $this->config->get('config_customer_group_id');
        }
        $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $customer_group_id));
        foreach ($custom_fields as $custom_field) {
            $json[] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'required' => empty($custom_field['required']) || $custom_field['required'] == 0 ? false : true
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function country() {
        $json = array();
        $this->load->model('localisation/country');
        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
        if ($country_info) {
            $this->load->model('localisation/zone');
            $json = array(
                'country_id'        => $country_info['country_id'],
                'name'              => $country_info['name'],
                'iso_code_2'        => $country_info['iso_code_2'],
                'iso_code_3'        => $country_info['iso_code_3'],
                'address_format'    => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status'            => $country_info['status']
            );
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    /* New */
    /* Add Item */
    public function getPreferredCookType() {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getPreferredCookType();
        return $result;
    }

    public function deleteCartPrescription() {
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $data->testing = $this->session->data['clinical_sale_prescription'];
        $prescription_id = !empty($filter->prescription_id) ? $filter->prescription_id : 0;
        if (!empty($prescription_id)) {
            $this->cart->removePrescription($prescription_id);
        }

        $data->testing2 = $this->session->data['clinical_sale_prescription'];
        $result = (array) $data;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    public function updateCartAcupuncturePoint() {
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $service_id = !empty($filter->service_id) ? $filter->service_id : 0;
        $acupuncture_id = !empty($filter->acupuncture_id) ? $filter->acupuncture_id : 0;
        $num_of_acupuncture = !empty($filter->num_of_acupuncture) ? $filter->num_of_acupuncture : '';
        if (!empty($service_id) && $acupuncture_id) {
            $this->cart->unsetAcupunctureList($service_id, 0);
            $this->cart->setAcupunctureList($service_id, $acupuncture_id, $num_of_acupuncture);
        }
        $result = (array) $data;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    public function removeCartAcupuncturePoint() {
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $service_id = !empty($filter->service_id) ? $filter->service_id : 0;
        $acupuncture_id = !empty($filter->acupuncture_id) ? $filter->acupuncture_id : 0;
        if (!empty($service_id) && $acupuncture_id) {
            $this->cart->unsetAcupunctureList($service_id, $acupuncture_id);
        }
        $result = (array) $data;
        $this->response->setOutput(json_encode($result));
    }

    public function addCartAcupuncturePoint() {
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $service_id = !empty($filter->service_id) ? $filter->service_id : 0;
        if (!empty($service_id)) {
            $this->cart->setAcupunctureList($service_id, 0, 1);
        }
        $result = (array) $data;
        $this->response->setOutput(json_encode($result));
    }

    public function deleteCartService() {
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $service_id = !empty($filter->service_id) ? $filter->service_id : 0;
        if (!empty($service_id)) {
            $this->cart->removeService($service_id);
            $this->cart->removeAcupunctureList($service_id);
        }
        $result = (array) $data;
        $this->response->setOutput(json_encode($result));
    }

    public function deleteCartProduct() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->load->model('catalog/product');
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $prescription_id = !empty($filter->prescription_id) ? $filter->prescription_id : 1;
        $product_id = !empty($filter->product_id) ? $filter->product_id : 0;
        if (!empty($prescription_id) && !empty($product_id)) {
            $this->cart->removeProduct($prescription_id, $product_id);
            $product_info = $this->model_catalog_product->getProduct($product_id);
            $product_name = !empty($product_info['name']) ? $product_info['name'] : '';
            $data->product_name = $product_name;
            $this->cart->removePrescriptionName($prescription_id, $product_name);
        }

        $data->prescriptionItems = $this->getPrescriptionItems();
        $data->products = $data->prescriptionItems['products'];
        if (empty($data->products)) {
            $this->cart->removePrescription(1);
        }

        $result = (array) $data;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    public function updateCartProduct() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $prescription_id = !empty($filter->prescription_id) ? $filter->prescription_id : 0;
        $product_id = !empty($filter->product_id) ? $filter->product_id : 0;
        $price = !empty($filter->price) ? $filter->price : 1;
        $discount = !empty($filter->discount) ? $filter->discount : 0;
        $taketype = !empty($filter->taketype) ? $filter->taketype : $this->language->get('text_aftermeal');
        $cook = !empty($filter->cook) ? $filter->cook : $this->getPreferredCookType();
        $day = !empty($filter->day) ? $filter->day : 1;
        $quantity = !empty($filter->quantity) ? $filter->quantity : 1;
        $times = !empty($filter->times) ? $filter->times : 1;
        if (!empty($prescription_id) && !empty($product_id)) {
            $this->cart->updateProduct($prescription_id, $product_id, $price, $discount, $taketype, $cook, $day, $quantity, $times);
        }
        $result = (array) $data;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    public function updateCartPrescription() {
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $prescription_id = !empty($filter->prescription_id) ? $filter->prescription_id : 0;
        $arg = !empty($filter->arg) ? $filter->arg : '';
        $value = !empty($filter->value) ? $filter->value : 1;
        if (!empty($prescription_id) && !empty($arg) && !empty($value)) {
            $this->cart->updatePrescription($prescription_id, $arg, $value);
        }
        $result = (array) $data;
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    public function addItemServices($data) {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart');
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        $result = [];
        $service_id = !empty($data->item_id) ? $data->item_id : 0;
        if (!empty($service_id)) {
            $service_details = $this->model_herbal_new_herbal->getServiceDetails($service_id);
            //$this->printData($service_details);
            $staff_id = $this->session->data['user_id']; //!empty($service_details['staff_id']) ? $service_details['staff_id'] : $this->session->data['user_id'];
            $price = !empty($service_details['price']) ? $service_details['price'] : 0;
            $this->cart->setService($service_id, $staff_id, $price);
        }
        return $result;
    }

    public function addItemPrescriptions($data) {
        $this->load->model('herbal/new_herbal');
        $this->load->model('catalog/prescription');
        $this->load->model('catalog/product');
        $this->load->language('herbal/new_herbal');
        $this->load->library('new_herbal_cart');
        $this->cart = new new_herbal_cart($this->registry);
        $result = [];
        $under = !empty($data->under) ? $data->under : 1;
        $prescription_id = !empty($data->item_id) ? $data->item_id : 0;
        $cook = $this->getPreferredCookType();
        $taketype = $this->language->get('text_aftermeal');
        $day = 1;
        $times = 1;
        if (!empty($prescription_id)) {
            $name = $this->model_herbal_new_herbal->getPrescriptionName($prescription_id);
            $key = $this->cart->addPrescription($under, $name, $prescription_id, $times, $cook, $taketype, $day);
            $productList = $this->model_catalog_prescription->getPerscriptionItemsJson($prescription_id);
            if (!empty($productList)) {
                /** @var type $productList */
                foreach ($productList as $product) {
                    $products = $this->model_catalog_product->getProduct($product['product_id']);
                    if (isset($this->session->data['clinical_sale_products']) && isset($this->session->data['clinical_sale_products'][$key][$product['product_id']])) {
                        $result['product_exit'][] = array('name' => $products['name']);
                    } else {
                        $this->cart->addProduct($key, $product['product_id'], $product['used_qty'], $times, $cook, $taketype, $day, $product['price'], 0);
                        $result['product_added'][] = [
                            'name' => $products['name'],
                        ];
                    }
                }
            }
        }
        return $result;
    }

    public function addItemProducts($data) {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $result = [];
        $day = 1;
        $cook = $this->getPreferredCookType();
        $times = 1;
        $under = !empty($data->under) ? $data->under : 1;
        $taketype = $this->language->get('text_aftermeal');
        $quantity = 1;
        $product_id = !empty($data->item_id) ? $data->item_id : 0;

        $product_info = $this->model_herbal_new_herbal->getProduct($product_id);
        if (!empty($product_info)) {
            $result['product_exit'] = [];
            $result['product_added'] = [];
            $product_id = $product_info['product_id'];

            $key = $this->cart->addPrescription($under, $product_info['name'], $product_id, $times, $cook, $taketype, $day);
            if (isset($this->session->data['clinical_sale_products']) && isset($this->session->data['clinical_sale_products'][$key][$product_id])) {
                $result['products'] = [];
                $result['product_exit'][] = [
                    'name' => $product_info['name'],
                ];
            } else {
                $result['products'] = $this->session->data['clinical_sale_products'][$under][$product_id];
                $this->cart->addProduct($key, $product_id, $quantity, $times, $cook, $taketype, $day, $product_info['price'], 0);
                $result['product_added'][] = [
                    'name' => $product_info['name'],
                ];
            }
        }
        return $result;
    }

    public function filterAddItemByType($data) {
        $result = [];
        switch ($data->type) {
            case 'product':
                $result = $this->addItemProducts($data);
                break;
            case 'sub-prescription':
                $result = $this->addItemPrescriptions($data);
                break;
            case 'service':
                $result = $this->addItemServices($data);
                break;
            default:
        }
        return $result;
    }

    public function addCartItem() {
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->post)) {
            foreach ($this->request->post as $p => $post) {
                $filter->$p = $post;
            }
        }
        $filter->item_id = !empty($filter->product_id) ? $filter->product_id : 0;
        $filter->type = !empty($filter->type) ? $filter->type : '';
        if (!empty($filter->item_id) && !empty($filter->type)) {
            $data->result = $this->filterAddItemByType($filter);
        }
        $result = (array) $data;
        $this->response->setOutput(json_encode($result));
    }

    public function cartTotalView() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $data = new StdClass();

        // Totals
        $total = 0;

        $total_data = !empty($this->getCartTotal()) ? $this->getCartTotal() : array();
        $data->total_data = $total_data;
        $data->total = $this->currency->format($total);

        // Weights
        $total_weight = $this->getCartTotalWeight();
        $data->total_weight = !empty($total_weight['total_weight']) ? $total_weight['total_weight'] : [];
        $result = (array) $data;

        $this->response->setOutput($this->load->view('herbal/new_cart_total', $result));
    }

    public function cartItemView2() {
        echo '<pre>';
        print_r($this->session->data);
        echo '</pre>';
    }

    public function cartItemView() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $data = new StdClass();
        $data->product_exit = !empty($data->result['product_exit']) ? $data->result['product_exit'] : [];
        $data->product_added = !empty($data->result['product_added']) ? $data->result['product_added'] : [];

        $user_view = $this->user->user_view;
        if (!empty($user_view)) {
            $data->allowed_edit_product_price = true;
        } else {
            $data->allowed_edit_product_price = !empty($this->config->get('config_herbal_edit_form_edit_product_price')) ? true : false;
        }

        $data->serviceItems = $this->getServiceItems();
        $data->service = $data->serviceItems['service'];
        $data->acupunctureItems = $this->getAcupunctureItems();
        $data->acupuncture_list = $data->acupunctureItems['acupuncture_list'];
        $data->prescriptionItems = $this->getPrescriptionItems();
        $data->prescription = $data->prescriptionItems['prescription'];
        $data->products = $data->prescriptionItems['products'];
        $data->cook_types = $this->model_herbal_new_herbal->getCookType();
        $data->user_token = $this->session->data['user_token'];
        $data->total_products_count = !empty($this->cart->getProductCount()) ? $this->cart->getProductCount() : 0;
        $data->total_services_count = !empty($data->service) ? count($data->service) : 0;

        // Totals
        $total = 0;

        $total_data = !empty($this->getCartTotal()) ? $this->getCartTotal() : array();
        $data->total_data = $total_data;
        $data->total = $this->currency->format($total, $this->config->get('config_currency'));

        $data->herbal_total = $this->getHerbalTotal($total_data);

        // Weights
        $total_weight = $this->getCartTotalWeight();
        $data->total_weight = !empty($total_weight['total_weight']) ? $total_weight['total_weight'] : [];
        $result = (array) $data;

        $this->response->setOutput($this->load->view('herbal/new_cart', $result));
    }

    public function getCartTotalWeight() {
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $result = array();
        $weights = $this->cart->getWeights();
        foreach ($weights as $weight) {
            $result['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }
        return $result;
    }

    public function getCartTotal() {
        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);
        $this->load->model('pos/extension');

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($result['code'] != 'credit') {
                if ($this->config->get('total_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        return $totals;
    }

    public function getHerbalTotal($totals) {
        $herbal_total = 0;
        if (!empty($totals)) {
            foreach ($totals as $total) {
                if ($total['code'] == 'total') {
                    $herbal_total += $total['value'];
                }
            }
        }
        return $herbal_total;
    }

    public function getAcupunctureItems() {
        $result = array();
        $result['acupuncture_list'] = array();
        foreach ($this->cart->getAcupunctureList() as $key => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                if ($acupuncture['acupuncture_id'] > 0) {
                    $acupuncture_name = $this->model_herbal_new_herbal->getAcupunctureNameById($acupuncture['acupuncture_id']);
                } else {
                    $acupuncture_name = '';
                }
                $result['acupuncture_list'][$key][] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }
        return $result;
    }

    public function getServiceItems() {
        $result = array();
        $result['service'] = array();
        foreach ($this->cart->getService() as $key => $service) {
            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
            $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));
            $result['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }
        return $result;
    }

    public function getPrescriptionItems() {
        $this->load->model('herbal/new_herbal');
        $this->load->language('herbal/new_herbal');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('new_herbal_cart'); //
        $this->cart = new new_herbal_cart($this->registry);

        $result = array();
        $result['prescription'] = array();
        $result['products'] = array();
        if (!empty($this->session->data['clinical_sale_prescription'])) {
            foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
                $result['prescription_keys'][] = $prescription['key'];
                $name = $prescription['name'];
                $name = implode(',', $name);
                $result['prescription'][$prescription_id] = array(
                    'key' => $prescription['key'],
                    'name' => $name,
                    'id' => $prescription['id'],
                    'discount' => $prescription['discount'],
                    'times' => $prescription['times'],
                    'cook' => $prescription['cook'],
                    'taketype' => $prescription['taketype'],
                    'day' => $prescription['day'],
                    'quantity' => $prescription['quantity']
                );
                if (!empty($this->session->data['clinical_sale_products'][$prescription_id])) {
                    foreach ($this->cart->getProducts($prescription_id) as $key => $products) {
                        $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];
                        $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                        $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
                        $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
                        $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));
                        $subprice = $this->currency->format($products['price'] * $products['quantity'] * $products['times'], $this->config->get('config_currency'));
                        $result['products'][$prescription_id][] = array(
                            'product_id' => $products['product_id'],
                            'name' => $products['name'],
                            'code' => $products['code'],
                            'quantity' => $products['quantity'],
                            'times' => $products['times'],
                            'cook' => $products['cook'],
                            'taketype' => $products['taketype'],
                            'stock' => $products['stock'],
                            'day' => $products['day'],
                            'price' => $products['price'],
                            'subprice' => $subprice,
                            'discount' => $products['discount'],
                            'subtotal' => $subtotal,
                            'total' => $total,
                            'tax' => $tax,
                            'tax_class_id' => $products['tax_class_id'],
                            'weight' => $products['weight'],
                            'weight_class_id' => $products['weight_class_id'],
                            'weight_format' => $products['weight']
                        );
                    } //end products
                }
            }
        }
        return $result;
    }

    /* Prescription */
    public function getItemLists() {
        $this->load->language('herbal/new_herbal');
        $this->load->language('herbal/new_patient_history_list');
        $url = '';
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->get)) {
            foreach ($this->request->get as $g => $get) {
                $filter->$g = $get;
                $url .= '&' . $g . '=' . $g;
            }
        }
        $filter->type = !empty($filter->type) ? $filter->type : 'product';
        $filter->search = !empty($filter->search) ? $filter->search : '';
        $filter->pagination_page = !empty($filter->pagination_page) ? $filter->pagination_page : 1;
        $filter->pagination_entry = !empty($filter->pagination_entry) ? $filter->pagination_entry : $this->config->get('config_limit_admin');
        $filter->pagination_offset = ($filter->pagination_page - 1) * $filter->pagination_entry;
        $data->type = $filter->type;
        $data->pagination_page = $filter->pagination_page;
        $data->pagination_entry = $filter->pagination_entry;
        $data->item_lists = $this->getAllItemLists($filter);
        //text
        $data->text_no_result = $this->language->get('text_no_result');
        $data = (array) $data;
        //$this->printData($data);
        $this->response->setOutput($this->load->view('herbal/new_items_list', $data));
    }

    public function itemListView() {
        $this->load->language('herbal/new_herbal');
        $this->load->language('herbal/new_patient_history_list');
        $url = '';
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->get)) {
            foreach ($this->request->get as $g => $get) {
                $filter->$g = $get;
                $url .= '&' . $g . '=' . $g;
            }
        }
        $filter->type = !empty($filter->type) ? $filter->type : 'product';
        $filter->search = !empty($filter->search) ? $filter->search : '';
        $filter->pagination_page = !empty($filter->pagination_page) ? $filter->pagination_page : 1;
        $filter->pagination_entry = !empty($filter->pagination_entry) ? $filter->pagination_entry : $this->config->get('config_limit_admin');
        $filter->pagination_offset = ($filter->pagination_page - 1) * $filter->pagination_entry;
        $data->type = $filter->type;
        $data->item_lists = $this->getAllItemLists($filter);
        //text
        $data->text_no_result = $this->language->get('text_no_result');
        $result = (array) $data;
        //$this->printData($data);
        $this->response->setOutput($this->load->view('herbal/new_items_list', $result));
    }

    public function getAllItemLists($data) {
        $result = [];
        $lists = $this->filterItemListByType($data);
        if (!empty($lists)) {
            foreach ($lists as $l => $ls) {
                $result[] = [
                    'item_id' => $ls['item_id'],
                    'item_name' => $ls['item_name'],
                    'item_code' => $ls['item_code'],
                ];
            }
        }
        return $result;
    }

    public function filterItemListByType($data) {
        $result = [];
        switch ($data->type) {
            case 'product':
                $result = $this->getProductLists($data);
                break;
            case 'sub-prescription':
                $result = $this->getSubPrescriptionLists($data);
                break;
            case 'service':
                $result = $this->getServiceLists($data);
                break;
            default:
                $result = [];
        }
        return $result;
    }

    public function getProductLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getProductLists($data);
        return $result;
    }

    public function getSubPrescriptionLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getSubPrescriptionLists($data);
        return $result;
    }

    public function getServiceLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getServiceLists($data);
        return $result;
    }

    /* Diagnostic */
    public function diagnosticListView() {
        //$this->load->language('herbal/new_diagnostic_list');
        $this->load->language('herbal/new_patient_history_list');
        $url = '';
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->get)) {
            foreach ($this->request->get as $g => $get) {
                $filter->$g = $get;
                $url .= '&' . $g . '=' . $g;
            }
        }
        $filter->type = !empty($filter->type) ? $filter->type : 'diagnostic';
        $filter->search = !empty($filter->search) ? $this->db->escape($filter->search) : '';
        $filter->pagination_page = !empty($filter->pagination_page) ? $filter->pagination_page : 1;
        $filter->pagination_entry = !empty($filter->pagination_entry) ? $filter->pagination_entry : $this->config->get('config_limit_admin');
        $filter->pagination_offset = ($filter->pagination_page - 1) * $filter->pagination_entry;
        $data->type = $filter->type;
        $data->diagnostic_lists = $this->getAllDiagnosticLists($filter);
        //text
        $data->text_no_result = $this->language->get('text_no_result');
        $result = (array) $data;
        //$this->printData($data);
        $this->response->setOutput($this->load->view('herbal/new_diagnostic_list', $result));
    }

    public function getAllDiagnosticLists($data) {
        $result = [];
        $lists = $this->filterDiagnosticListByType($data);
        if (!empty($lists)) {
            foreach ($lists as $l => $ls) {
                $result[] = [
                    'disgnostic_id' => $ls['diagnostic_id'],
                    'diagnostic_name' => $ls['diagnostic_name'],
                    'diagnostic_code' => $ls['diagnostic_code'],
                ];
            }
        }

        return $result;
    }

    public function resetDiagnosticLists($data) {
        $result = [];
        $lists = explode('||', $data);
        if (!empty($lists)) {
            foreach ($lists as $l => $ls) {
                if (!empty($ls)) {
                    $diagnostics[$l] = explode('---', $ls);
                    if (!empty($diagnostics)) {
                        foreach ($diagnostics as $d => $da) {
                            $d_id = $da[0];
                            $d_name = $da[1];
                            $d_code = $da[2];
                            $d_pid = $da[3];
                            $result[$l] = [
                                'diagnostic_id' => $d_id,
                                'diagnostic_name' => $d_name,
                                'diagnostic_code' => $d_code,
                                'diagnostic_parent_id' => $d_pid,
                            ];
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function filterDiagnosticListByType($data) {
        $result = [];
        switch ($data->type) {
            case 'pulse':
                $result = $this->getPulseLists($data);
                break;
            case 'symptom':
                $result = $this->getSymptomLists($data);
                break;
            case 'disease':
                $result = $this->getDiseaseLists($data);
                break;
            case 'treatment':
                $result = $this->getTreatmentLists($data);
                break;
            case 'diagnostic':
                $result = $this->getDiagnosticLists($data);
                break;
            case 'acupuncture':
                $result = $this->getAcupunctureLists($data);
                break;
            case 'doctoradvice':
                $result = $this->getDoctorAdviceLists($data);
                break;
            default:
                $result = [];
        }
        return $result;
    }

    public function getPulseLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getPulseLists($data);
        return $result;
    }

    public function getSymptomLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getSymptomLists($data);
        return $result;
    }

    public function getDiseaseLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getDiseaseLists($data);
        return $result;
    }

    public function getTreatmentLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getTreatmentLists($data);
        return $result;
    }

    public function getDiagnosticLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getDiagnosticLists($data);
        return $result;
    }

    public function getAcupunctureLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getAcupunctureLists($data);
        return $result;
    }

    public function getDoctorAdviceLists($data) {
        $this->load->model('herbal/new_herbal');
        $result = $this->model_herbal_new_herbal->getDoctorAdviceLists($data);
        return $result;
    }

    /* Patient History */
    public function patientMedicalHistoriesView() {
        //$this->load->language('herbal/new_herbal');
        $this->load->language('herbal/new_patient_history_list');
        $url = '';
        $data = new StdClass();
        $filter = new StdClass();
        if (!empty($this->request->get)) {
            foreach ($this->request->get as $g => $get) {
                $filter->$g = $get;
                $url .= '&' . $g . '=' . $g;
            }
        }
        //Request
        $filter->search = !empty($filter->search) ? $filter->search : '';
        $filter->customer_id = !empty($filter->customer_id) ? $filter->customer_id : 0;
        $filter->clinical_sale_id = !empty($filter->clinical_sale_id) ? $filter->clinical_sale_id : 0;
        //Pagination
        $filter->pagination_page = !empty($filter->pagination_page) ? $filter->pagination_page : 1;
        $filter->pagination_entry = !empty($filter->pagination_entry) ? $filter->pagination_entry : $this->config->get('config_limit_admin');
        $filter->pagination_offset = ($filter->pagination_page - 1) * $filter->pagination_entry;
        $data->herbal_id = !empty($filter->clinical_sale_id) ? $filter->clinical_sale_id : 0;
        $data->medical_record_histories = $this->getPatientMedicalHistories($filter);
        //Button
        $data->button_copy = $this->language->get('button_copy');
        //data
        $data->clinical_sale_id = $filter->clinical_sale_id;
        $data->customer_id = $filter->customer_id;
        //Diagnotics
        $data->column_date = $this->language->get('column_date');
        $data->column_total = $this->language->get('column_total');
        $data->column_pulse = $this->language->get('column_pulse');
        $data->column_disease = $this->language->get('column_disease');
        $data->column_symptoms = $this->language->get('column_symptoms');
        $data->column_treatment = $this->language->get('column_treatment');
        $data->column_diagnostic = $this->language->get('column_diagnostic');
        $data->column_acupuncture = $this->language->get('column_acupuncture');
        $data->column_doctoradvice = $this->language->get('column_doctoradvice');
        $data->column_invoice_prefix = $this->language->get('column_invoice_prefix');
        $data->column_doctor = $this->language->get('entry_doctor');
        $data->column_store = $this->language->get('column_store');
        $data->column_total_medical = $this->language->get('column_total_medical');
        $data->column_total_consultation = $this->language->get('column_total_consultation');
        $data->column_total_service = $this->language->get('column_total_service');


        //Medicine List
        $data->column_day = $this->language->get('column_day');
        $data->column_cook = $this->language->get('column_cook');
        $data->column_dosage = $this->language->get('column_dosage');
        $data->column_taketype = $this->language->get('column_taketype');
        //Medical text
        $data->text_dose = $this->language->get('text_dose');
        $data->text_times = $this->language->get('text_times');
        $data->text_no_result = $this->language->get('text_no_result');
        $data->header = $this->load->controller('common/header/pop_header');
        $data = (array) $data;
        //$this->printData($data);
        $this->response->setOutput($this->load->view('herbal/new_patient_history_list', $data));
    }

    public function getPatientMedicalHistories($data) {
        $this->load->model('herbal/new_herbal');
        $result = [];
        $prescription_list = $this->model_herbal_new_herbal->getPatientMedicalRecordList($data);
        if (!empty($prescription_list)) {
            foreach ($prescription_list as $pid => $ps_list) {

                $doctor_info = $this->model_herbal_new_herbal->getUserInfo($ps_list['doctor_id']);
                $doctor_name = !empty($doctor_info['name']) ? $doctor_info['name'] : '';

                $store_info = $this->model_herbal_new_herbal->getStoreInfo($ps_list['store_id']);
                $store_name = !empty($store_info['name']) ? $store_info['name'] : $this->config->get('config_name');

                $diagnostic_text2 = '';
                $diagnostic_text = [];
                $medical_list = [];
                if (!empty($ps_list['prescription_text'])) {
                    $medical_list = $this->resetPatientMedicalHistories($ps_list['prescription_text']);
                }

                if (!empty($ps_list['diagnostic'])) {
                    $diagnostic_text[] = $ps_list['diagnostic'];
                }

                if (!empty($ps_list['doctoradvice'])) {
                    $diagnostic_text[] = $ps_list['doctoradvice'];
                }

                if (!empty($ps_list['pulse'])) {
                    $diagnostic_text[] = $ps_list['pulse'];
                }

                if (!empty($ps_list['disease'])) {
                    $diagnostic_text[] = $ps_list['disease'];
                }

                if (!empty($ps_list['treatment'])) {
                    $diagnostic_text[] = $ps_list['treatment'];
                }

                if (!empty($ps_list['acupuncture'])) {
                    $diagnostic_text[] = $ps_list['acupuncture'];
                }

                if (!empty($ps_list['symptom'])) {
                    $diagnostic_text[] = $ps_list['symptom'];
                }

                if (!empty($ps_list['remark'])) {
                    $diagnostic_text[] = $ps_list['remark'];
                }
                $diagnostic_text2 = implode(',', $diagnostic_text);

                $herbal_service_total = $this->model_herbal_new_herbal->getHerbalServiceTotal($ps_list['clinical_sale_id']);


                $result[] = [
                    'clinical_sale_id'  => $ps_list['clinical_sale_id'],
                    'invoice_prefix'    => $ps_list['invoice_prefix'],
                    'doctor_id'         => $ps_list['doctor_id'],
                    'doctor_name'       => $doctor_name,
                    'store_id'          => $ps_list['store_id'],
                    'store_name'        => $store_name,
                    'diagnostic'        => $ps_list['diagnostic'],
                    'doctoradvice'      => $ps_list['doctoradvice'],
                    'pulse'             => $ps_list['pulse'],
                    'disease'           => $ps_list['disease'],
                    'treatment'         => $ps_list['treatment'],
                    'acupuncture'       => $ps_list['acupuncture'],
                    'symptom'           => $ps_list['symptom'],
                    'total_medical'     => $ps_list['clinicalsale_total'],
                    'total_consult'     => $ps_list['clinicalsale_concultation'],
                    // 'total_service'     => $herbal_service_total,
                    'total'             =>  sprintf('%.2f', $ps_list['clinicalsale_total'] + $ps_list['clinicalsale_concultation']),
                    'weight'            => $ps_list['weight'],
                    'date'              => date('d/m/Y H:i:s', strtotime($ps_list['date'])),
                    'prescription_list' => $medical_list,
                    'diagnostic_text'   => $diagnostic_text2,
                    'edit'              => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $ps_list['clinical_sale_id'], 'SSL'),
                ];
            }
        }
        return $result;
    }

    public function resetPatientMedicalHistories($data) {
        $result = [];
        $lists = explode('&', $data);
        if (!empty($lists)) {
            foreach ($lists as $l => $ls) {
                if (!empty($ls)) {
                    $prescriptions[$l] = explode('//', $ls);
                    if (!empty($prescriptions)) {
                        foreach ($prescriptions as $p => $pst) {
                            $p_name = $pst[0];
                            $day = $pst[1];
                            $cook = $pst[2];
                            $take = $pst[3];
                            $dose = $pst[4];
                            $p_list = $pst[5];
                            $p_list = $this->resetMedicalPrescriptionList($p_list);
                            $result[$l] = [
                                'day' => $day,
                                'dose' => $dose,
                                'cook' => $cook,
                                'taketype' => $take,
                                'prescription_name' => $p_name,
                                'prescription_list' => $p_list,
                            ];
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function resetMedicalPrescriptionList($data) {
        $result = [];
        $lists = explode('||', $data);
        if (!empty($lists)) {
            foreach ($lists as $l => $ls) {
                if (!empty($ls)) {
                    $prescriptions[$l] = explode(',', $ls);
                    if (!empty($prescriptions)) {
                        foreach ($prescriptions as $p => $pst) {
                            $p_name = $pst[0];
                            $p_code = isset($pst[1]) ? $pst[1] : null;
                            $p_qty = isset($pst[2]) ? $pst[2] : null;
                            $p_price = isset($pst[3]) ? $pst[3] : null;
                            $result[$l] = [
                                'product_name' => $p_name,
                                'product_code' => $p_code,
                                'product_quantity' => $p_qty,
                                'product_price' => $p_price,
                            ];
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function debug() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser(101);
        $data['tax_class_id'] = $user_details['tax_class_id'];
        $data['tax_code'] = $this->tax->getClassCode($data['tax_class_id']);
        echo $data['tax_code'];
    }

    protected function sendSystemPopupNotification($data = array()) {
        $notification = new Notification($this->registry);
        if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
            $notification->add_notification('new_clinical_sale_notification', $data);
        }
    }

    protected function buildDoctorNotificationData($data = array()) {
        $template_title = $data['title'];
        $template_message = $data['message'];

        $find_title = ['{customer_name}'];
        $replace_title = ['customer_name' => $data['customer_name']];
        $find_message = ['{invoice_prefix}'];
        $replace_message = ['invoice_prefix' => $data['invoice_prefix']];

        $notification_title = str_replace($find_title, $replace_title, $template_title);
        $notification_message = str_replace($find_message, $replace_message, $template_message);

        $data_gcm = array(
            'title' => $notification_title,
            'message' => $notification_message,
            'user_id' => $data['doctor_id'],
            'type' => 2
        );
        return $data_gcm;
    }

    protected function sendDoctorNotification($data = array()) {
        $notification_template = $this->config->get('config_gcm_new_herbal');
        if ($notification_template['status'] == '1') {
            $notification_data = [
                'title' => $notification_template['title'],
                'message' => $notification_template['message'],
                'doctor_id' => $data['doctor_id'],
                'invoice_prefix' => $data['invoice_prefix'],
                'customer_name' => $data['customer_name'],
            ];
            $data_gcm = $this->buildDoctorNotificationData($notification_data);
            if (!empty($data['doctor_device'])) {
                $gcm = new GCM($this->registry);
                $gcm->sendTo($gcm->get_user_token($data['doctor_id']))
                    ->setData($data_gcm)
                    ->send();
            }
        }
    }

    public function addNewMedicalRecord() {
        $json = [];
        if (!empty($this->request->get['customer_id']) && !empty($this->session->data['user_id'])) {
            $customer_info = $this->model_herbal_new_herbal->getCustomerbyid($this->request->get['customer_id']);
            $data['customer_id'] = !empty($customer_info['customer_id']) ? $customer_info['customer_id'] : 0;
            $data['doctor_id'] = $this->session->data['user_id'];
            $doctor_info = $this->model_user_user->getUser($this->session->data['user_id']);
            $data['enable_consultation_price'] = !empty($doctor_info['enable_consultation_price']) ? $doctor_info['enable_consultation_price'] : 0;
            $data['consultationprice'] = !empty($doctor_info['consultationprice']) ? $doctor_info['consultationprice'] : 0;
            $herbal_id = $this->model_herbal_new_herbal->addHerbal($data);
            if (!empty($herbal_id) && !empty($data['doctor_id'])) {
                $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
                $invoice_prefix = $herbal_info['invoice_prefix'];
                $customer_name = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
                $doctor_device = $this->model_herbal_new_herbal->getDoctorDevice($data['doctor_id']);

                $notification_data = [
                    'customer_id' => $data['customer_id'],
                    'herbal_id' => $herbal_id,
                    'doctor_id' => $data['doctor_id'],
                    'invoice_prefix' => $invoice_prefix,
                    'customer_name' => $customer_name,
                    'doctor_device' => $doctor_device
                ];
                //Send app notification to doctor
                $this->sendDoctorNotification($notification_data);
                //Send PopUP notification
                $this->sendSystemPopupNotification($notification_data);

                $json['success'] = true;
            }
        } else {
            $json['error'] = true;
        }

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function sendToServicing() {
        $herbal_id = !empty($this->request->get['herbal_id']) ? $this->request->get['herbal_id'] : 0;
        $order_id = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;

        $this->load->language('herbal/herbal');
        $this->load->model('herbal/herbal');
        $json = [];
        $json['herbal'] = $this->model_herbal_herbal->getHerbal($herbal_id);
        $json['prescription'] = $this->model_herbal_herbal->getHerbalPrescription($herbal_id);
        $json['herbal_product'] = $this->model_herbal_herbal->getHerbalProducts($herbal_id);
        $times = $this->model_herbal_herbal->getHerbalDailyTimes($herbal_id);
        $take = $this->model_herbal_herbal->getHerbalDailyTake($herbal_id);
        $products = array_column($json['herbal_product'], 'product');

        if (!empty($take['taken'])) {
            $taken  = $take['taken']; //$this->formatNumericToChineseNumeral($take['taken']);
        } else {
            $taken  = 3; //$this->formatNumericToChineseNumeral(3);
        }

        $data = [];
        $data['order_id'] = $order_id;
        $data['date_added'] = (!empty($json['herbal']['date_added'])) ? date('Ymd', strtotime($json['herbal']['date_added'])) : date('Ymd');
        $data['invoice_prefix'] = (!empty($json['herbal']['invoice_prefix'])) ? $json['herbal']['invoice_prefix'] : date('Ymd');
        $data['prescription_id'] = ($json['herbal']['clinical_sale_id']) ? $json['herbal']['clinical_sale_id'] : 0;
        $data['currency_format'] = 'RM';
        $data['prescription_times'] = !empty($times['times']) ? $times['times'] : 3;
        $data['daily_take'] = !empty($taken) ? '一日' . $taken . '次' : '一日1次';
        $data['diagnostic'] = str_replace(',', ' ', $json['herbal']['diagnostic'] . ' ' . $json['herbal']['pulse'] . ' ' . $json['herbal']['disease'] . ' ' . $json['herbal']['symptom']);
        $data['doctoradvice'] = str_replace(',', ' ', $json['herbal']['doctoradvice'] . ' ' . $json['herbal']['treatment'] . ' ' . $json['herbal']['acupuncture'] . ' ' . $json['herbal']['remark']);
        $data['service_type'] = !empty($json['herbal']['herb_service_type']) ? $json['herbal']['herb_service_type'] : 'herbs';
        $data['customer'] = $json['herbal']['firstname'] . $json['herbal']['lastname'];
        $data['gender'] = ($json['herbal']['gender'] == 1) ? '男' : '女';
        $data['age'] = ($json['herbal']['age']) ? $json['herbal']['age'] : 0;
        $data['total'] = ($json['herbal']['total_d_gst']) ? $json['herbal']['total_d_gst'] : 0;
        $data['doctor'] = $json['herbal']['doctor_firstname'] . $json['herbal']['doctor_lastname'];;
        $data['profession'] = $json['herbal']['doctor_firstname'];
        $data['products'] = implode('/', $products);
        $data['status'] = 2;

        $json['products2'] = $this->model_herbal_herbal->getHerbalProducts2($herbal_id);
        $products2 = array_column($json['products2'], 'product');
        $data['products2'] = implode(', ', $products2);

        $data['format'] = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';

        $data['format2'] = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';

        $search = [
            '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
            '{gender}', '{age}', '{total}', '{status}', '{doctor}', '{profession}', '{products}'
        ];

        $search2 = [
            '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
            '{gender}', '{age}', '{total}',  '{status}', '{doctor}', '{profession}', '{products}'
        ];

        $replace = [
            $data['date_added'],
            $data['prescription_times'],
            $data['daily_take'],
            $data['diagnostic'],
            $data['doctoradvice'],
            $data['customer'],
            $data['gender'],
            $data['age'],
            $data['total'],
            $data['status'],
            $data['doctor'],
            $data['profession'],
            $data['products'],
        ];

        $replace2 = [
            $data['date_added'],
            $data['prescription_times'],
            $data['daily_take'],
            $data['diagnostic'],
            $data['doctoradvice'],
            $data['customer'],
            $data['gender'],
            $data['age'],
            $data['total'],
            $data['status'],
            $data['doctor'],
            $data['profession'],
            $data['products2'],
        ];

        $data['prescriptionFormat'] = str_ireplace($search2, $replace2, $data['format']);
        $data['InterfaceStr'] = str_ireplace($search, $replace, $data['format']);

        $data['status'] = 1;
        if (!empty($json['herbal']['herb_service_type']) && $json['herbal']['herb_service_type'] == 'granule') {
            ini_set('soap.wsdl_cache_enabled', 0);
            ini_set('soap.wsdl_cache_ttl', 0);
            ini_set('default_socket_timeout', 15);

            //options for ssl in php 5.6.5
            $opts = array(
                'ssl' => array(
                    'ciphers' => 'RC4-SHA',
                    'verify_peer' => false,
                    'verify_peer_name' => false
                )
            );

            $options = array(
                'cache_wsdl' => WSDL_CACHE_NONE,
                'connection_timeout' => 15,
                'trace' => false,
                'encoding' => 'UTF-8',
                'exceptions' => false,
                'verifypeer' => false,
                'verifyhost' => false,
                'soap_version' => SOAP_1_2,
            );


            $url = "http://eciwo.dyndns.org:8089/Prescription.asmx?WSDL";

            try {
                if (!empty($client = new SoapClient($url, $options))) {
                    $client = new SoapClient($url, $options);
                    $client->__setLocation('http://eciwo.dyndns.org:8089/Prescription.asmx');

                    $interfaceStr = !empty($data['interfaceFormat']) ? $data['interfaceFormat'] : '';

                    $result = [
                        'InterfaceStr' => $data['InterfaceStr'],
                        //'InterfaceStr' => '3, 7, 一日三次, 早�?�, 肾虚阳痿, 林凯文, 男, 24, 452.40, Mr.黄医师, 皮肤科; A001, 30/A002, 20',
                    ];

                    $response = $client->InterfaceFormat($result);
                    if (!empty($response->InterfaceFormatResult)) {
                        $data['status'] = 15;
                    }
                }
            } catch (Exception $e) {
            }
        }

        $service_id = $this->insertToProductService($data);
        return $service_id;
    }

    public function insertToProductService($data) {
        $query = $this->db->query("INSERT INTO `" . DB_PREFIX . "product_to_service` SET `prescription_id` = '" . (int)$data['prescription_id'] . "', `status` = '" . (int)$data['status'] . "', `prescription_times` = '" . $this->db->escape($data['prescription_times']) . "',  `daily_take` = '" . $this->db->escape($data['daily_take']) .  "', `diagnostic` = '" . $this->db->escape($data['diagnostic']) . "', `doctoradvice` = '" . $this->db->escape($data['doctoradvice']) . "', `customer` = '" . $this->db->escape($data['customer']) . "', `gender` = '" . $this->db->escape($data['gender']) . "', `age` = '" . $this->db->escape($data['age']) . "', `total` = '" . $this->db->escape($data['total']) . "', `doctor` = '" . $this->db->escape($data['doctor']) . "', `profession` = '" . $this->db->escape($data['profession']) . "', `products` = '" . $this->db->escape($data['products2']) . "', `interfaceFormat` = '" . $this->db->escape($data['InterfaceStr']) . "', `prescriptionFormat` = '" . $this->db->escape($data['prescriptionFormat']) . "', `order_id` = '" . $data['order_id'] . "', `date_added` = NOW(), `added_by` = '" . $this->session->data['user_id'] . "',  `service_type` = '" . $this->db->escape($data['service_type']) . "'");
        $service_id = $this->db->getLastId();
        return $service_id;
    }

    public function getAllHerbal() {
        $result = [];
        $query = $this->db->query("SELECT cs.`date_added`, cs.`clinical_sale_id`, cs.`total`, (SELECT cst.value FROM `oc_clinical_sale_total` cst WHERE 1 AND cst.code = 'sub_total'  AND cst.id = '2' AND cst.`clinical_sale_id` = cs.`clinical_sale_id`) AS total_amount  FROM `oc_clinical_sale` cs WHERE 1 AND DATE(cs.`sales_date`) ORDER BY cs.`clinical_sale_id` ASC ");
        $clinical_sales = $query->rows;
        if (!empty($clinical_sales)) {
            foreach ($clinical_sales as $cs) {
                $tally = true;
                if ((float)$cs['total'] != (float)$cs['total_amount']) {
                    $tally = false;
                }

                $result[] = [
                    'date_added'       => $cs['date_added'],
                    'clinical_sale_id' => $cs['clinical_sale_id'],
                    'total'            => $cs['total'],
                    'total_amount'     => $cs['total_amount'],
                    'tally'            => $tally,
                ];

                if (empty($tally)) {
                    $this->db->query("UPDATE `oc_clinical_sale`  SET `total` = '" . (float)ROUND($cs['total_amount'], 2) . "', `subtotal` = '" . (float)ROUND($cs['total_amount'], 2) . "' WHERE 1 AND `clinical_sale_id` = '" . (int)$cs['clinical_sale_id'] . "'");
                }
            }
        }

        //$this->response->addHeader('Content-Type: application/json');
        //$this->response->setOutput(json_encode($result));

    }

    public function sendMedicalRecordToNGPMachine() {
        $this->load->language('herbal/new_herbal');
        $this->load->model('herbal/herbal');
        $this->load->model('herbal/new_herbal');

        $results = [];

        $json = [];
        $json['error'] = '';
        $json['success'] = '';
        $json['message'] = '';
        $json['response'] = [];
        $json['prescriptions'] = [];

        $send = true;
        if (!empty($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        } else if (!empty($this->request->post['herbal_id'])) {
            $herbal_id = $this->request->post['herbal_id'];
        } else {
            $herbal_id = 0;
        }

        $order_id  = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;

        // Setup Soap Client INI settings
        ini_set('soap.wsdl_cache_enabled', 0);
        ini_set('soap.wsdl_cache_ttl', 0);
        ini_set('default_socket_timeout', 15);

        //options for ssl in php 5.6.5
        $opts = array(
            'ssl' => array(
                'ciphers' => 'RC4-SHA',
                'verify_peer' => false,
                'verify_peer_name' => false
            )
        );

        // Setup Soap Client options
        $options = array(
            'cache_wsdl' => WSDL_CACHE_NONE,
            'connection_timeout' => 5,
            'trace' => false,
            'encoding' => 'UTF-8',
            'exceptions' => false,
            'verifypeer' => false,
            'verifyhost' => false,
            'soap_version' => SOAP_1_2,
            'exceptions' => true,
        );

        try {
            // Check herbal is empty or not
            if (empty($herbal_id)) {
                $send = false;
                throw new Exception('Error! herbal id parameter are empty ! Please resend again !');
            }

            // Check herbal info is valid or invalid, throw error if invalid
            $herbal_info = $this->model_herbal_new_herbal->getHerbal($herbal_id);
            if (empty($herbal_info)) {
                $send = false;
                throw new Exception('Error! Invalid herbal id parameter ! Please resend again !');
            }

            // Check service type is granule
            if ($herbal_info['herb_service_type'] != 'granule') {
                $send = false;
                throw new Exception('Error! The prescriptions is not granule ! Cannot send to NGP Machine !');
            }

            // Check ngp webservices exists, if not exists throw an error
            if (empty($this->config->get('config_ngp_webservices_connection_url'))) {
                $send = false;
                $json['error'] = 'Error! The NGP machine connection havent setup ! Please contact ETCM technician !';
            }

            // Check ngp webservices is enable, if disable throw an error
            if (empty($this->config->get('config_ngp_webservices_status'))) {
                $send = false;
                throw new Exception('Error! The NGP machine connection is disabled and you are not allowed to connect ! Please contact ETCM technician !');
            }

            // Check ngp webservices send prescription connection setup, if havent throw an error
            if (empty($this->config->get('config_ngp_webservices_send_prescription_url')) || empty($this->config->get('config_ngp_webservices_send_prescription_location_url'))) {
                $send = false;
                throw new Exception('Error! The NGP machine send prescription connection havent setup ! Please contact ETCM technician !');
            }

            $function_url = $this->config->get('config_ngp_webservices_send_prescription_url');
            //$function_location_url = $this->config->get('config_ngp_webservices_send_prescription_location_url');

            // Check ngp webservices connection is turn on, if turn off throw an error 
            $url = $this->config->get('config_ngp_webservices_connection_url');
            if (empty($this->checkConnection($url))) {
                $send = false;
                throw new Exception('Error! The NGP machine is not turn on ! Please turn on before send prescriptions to NGP machine !');
            }

            try {
                // Check ngp webservices validation, if invalid, throw and error.
                $client = new SoapClient($function_url, $options);
            } catch (SoapFault $client) {
                $send = false;
                $json['error'] = 'Error! Invalid NGP machine connection setup ! Please contact ETCM technician !';
                //$this->printJson($json);
            }

            $prescriptions = $this->model_herbal_new_herbal->getHerbalPrescription($herbal_id);
            $products  = $this->model_herbal_herbal->getHerbalProducts($herbal_id);
            $products2 = $this->model_herbal_herbal->getHerbalProducts2($herbal_id);
            $times     = $this->model_herbal_herbal->getHerbalDailyTimes($herbal_id);
            $take      = $this->model_herbal_herbal->getHerbalDailyTake($herbal_id);

            // Format Product List
            $formatted_products  = array_column($products, 'product');
            $formatted_products2 = array_column($products2, 'product');

            // Implode Products
            $implode_products  = implode('/', $formatted_products);
            $implode_products2 = implode('/', $formatted_products2);

            // Prescription Format
            $format = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';
            $format2 = '{prescription_id}, {prescription_times}, {daily_take}, {diagnostic}, {doctoradvice}, {customer}, {gender}, {age}, {total}, {status}, {doctor}, {profession};{products}';

            $search = [
                '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
                '{gender}', '{age}', '{total}', '{status}', '{doctor}', '{profession}', '{products}'
            ];
            $search2 = [
                '{prescription_id}', '{prescription_times}', '{daily_take}', '{diagnostic}', '{doctoradvice}', '{customer}',
                '{gender}', '{age}', '{total}',  '{status}', '{doctor}', '{profession}', '{products}'
            ];

            // Get All Data
            $data = [
                'order_id'           => $order_id,
                'date_added'         => (!empty($herbal_info['date_added'])) ? date('Ymd', strtotime($herbal_info['date_added'])) : date('Ymd'),
                'invoice_prefix'     => (!empty($herbal_info['invoice_prefix'])) ? $herbal_info['invoice_prefix'] : date('Ymd'),
                'prescription_id'    => ($herbal_info['clinical_sale_id']) ? $herbal_info['clinical_sale_id'] : 0,
                'currency_format'    => 'RM',
                'prescription_times' => !empty($times['times']) ? $times['times'] : 3,
                'daily_take'  => !empty($taken) ? '一日' . $taken . '次' : '一日1次',
                'diagnostic'         => str_replace(',', ' ', $herbal_info['diagnostic'] . ' ' . $herbal_info['pulse'] . ' ' . $herbal_info['disease'] . ' ' . $herbal_info['symptom']),
                'doctoradvice'       => str_replace(',', ' ', $herbal_info['doctoradvice'] . ' ' . $herbal_info['treatment'] . ' ' . $herbal_info['acupuncture'] . ' ' . $herbal_info['remark']),
                'service_type'       => empty($herbal_info['herb_service_type']) ? $herbal_info['herb_service_type'] : 'herbs',
                'status'             => 2,
                'customer'           => $herbal_info['firstname'] . $herbal_info['lastname'],
                'gender'             => ($herbal_info['gender'] == 1) ? '男' : '女',
                'age'                => ($herbal_info['age']) ? $herbal_info['age'] : 0,
                'total'              => ($herbal_info['total_d_gst']) ? $herbal_info['total_d_gst'] : 0,
                'doctor'             => $herbal_info['doctor_firstname'] . $herbal_info['doctor_lastname'],
                'profession'         => $herbal_info['doctor_firstname'],
                'products'           => $implode_products,
                'products2'          => $implode_products2,
            ];

            $replace = [
                $data['date_added'], $data['prescription_times'], $data['daily_take'], $data['diagnostic'], $data['doctoradvice'], $data['customer'], $data['gender'], $data['age'], $data['total'], $data['status'], $data['doctor'], $data['profession'], $data['products'],
            ];

            $replace2 = [
                $data['date_added'], $data['prescription_times'], $data['daily_take'], $data['diagnostic'], $data['doctoradvice'], $data['customer'], $data['gender'], $data['age'], $data['total'], $data['status'], $data['doctor'], $data['profession'], $data['products2'],
            ];

            $data['prescriptionFormat'] = str_ireplace($search2, $replace2, $format);
            $data['InterfaceStr']       = str_ireplace($search, $replace, $format);

            // Check prescriptions list, if empty, send an error
            if (empty($prescriptions)) {
                $send = false;
                throw new Exception('Error! The prescription is empty! Cannot send to NGP Machine ! ');
            }

            // Check products list, if empty, send an error
            if (empty($products)) {
                $send = false;
                throw new Exception('Error! The products list is empty! Cannot send to NGP Machine ! ');
            }

            // If cannot send prescriptions to NGP machine, send an error.
            if (empty($send)) {
                $send = false;
                throw new Exception('Error! The system error ! Please contact ETCM technician !');
            }

            if (!empty($send)) {
                try {
                    $InterfaceStr['InterfaceStr']  = $data['InterfaceStr'];
                    $response = $client->InterfaceFormat($InterfaceStr);
                    if (!empty($response->InterfaceFormatResult)) {
                        $format_result = explode(',', $response->InterfaceFormatResult);
                        $result['response'] = (int)$format_result['2'];
                        $msg = $format_result['1'];
                        // Check if webservices response success, return success else thrown an error
                        if (!empty($result['response'])) {
                            $json['response'] = $result['response'];
                            $json['send_to_ngp'] = 1;
                            $json['success'] = 'Prescriptions successfully sent to NGP Machine ! #' . $result['response'] . ' ' . $msg;
                        } else {
                            $json['response'] = $result['response'];
                            $json['send_to_ngp'] = 0;
                            $json['error'] = 'There are some items of prescription #' . (int)$herbal_id . ' not exists in NGP machine ! ' . $this->db->escape($msg);
                        }
                    } else {
                        $json['error'] = 'Failed! Your send medical record #' . (int)$herbal_id . ' format is not correct. Please contact ETCM technician!';
                    }
                } catch (SoapFault $client) {
                    $json['error'] = 'Erorrs. Send Prescriptions webservices function name is incorrect ! Contact ETCM technician !';
                }
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
            $json['error'] = $message;
        }

        $error = !empty($json['error']) ? $json['error'] : '';
        $success = !empty($json['success']) ? $json['success'] : '';

        $results = [
            'error' => !empty($json['error']) ? true : false,
            'code'  => !empty($json['error']) ? 500 : 200,
            'message' => !empty($json['error']) ? $error : $success,
            'response' => !empty($json['response']) ? $json['response'] : [],
        ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($results));
    }

    /**
     * Check the connection to the given URL.
     *
     * @param string $url The URL to check the connection for.
     * @return bool True if the HTTP response code is 200, otherwise false.
     */
    public function checkConnection($url) {
        // Initialize a new cURL session with the given URL
        $ch = curl_init($url);

        // Set the cURL options
        curl_setopt($ch, CURLOPT_HEADER, true);         // We want headers
        curl_setopt($ch, CURLOPT_NOBODY, true);         // We don't need the body
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);     // Return the transfer as a string
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);            // Set the maximum execution time to 5 seconds

        // Execute the cURL session
        $output = curl_exec($ch);

        // Get the HTTP response code
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        // Close the cURL session
        curl_close($ch);

        // Check if the HTTP response code is 200
        if ($httpcode == 200) {
            return true;
        } else {
            return false;
        }
    }

    protected function printData($data) {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }

    protected function installUpdateNewRelease() {
        $this->load->model('herbal/new_herbal');
        $this->model_herbal_new_herbal->installUpdateNewRelease();
    }

    /**
     * Updates Notes
     * 20230308
     */
}
