<?php

class ControllerHerbalHerbal extends Controller {

    private $error = array();

    public function index() {

        $this->load->language('herbal/herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/herbal');
        $this->load->model('sale/order');

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->getList();
    }

    public function debug() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser(101);
        $data['tax_class_id'] = $user_details['tax_class_id'];
        $data['tax_code'] = $this->tax->getClassCode($data['tax_class_id']);
        echo $data['tax_code'];
    }

    public function addCustomer() {
        $this->load->language('herbal/herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer');
        $this->load->model('herbal/herbal');
        $this->load->model('user/user');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $customer_info = $this->model_sale_customer->customerExistsByIc($this->request->post['customer_ic']);

            if (empty($customer_info)) {
                $data['customer_id'] = $this->model_sale_customer->addCustomer($this->request->post);
            } else {
                $data['customer_id'] = $customer_info['customer_id'];
            }

            $data['doctor_id'] = $this->request->post['doctor_id'];
            $doctor_info = $this->model_user_user->getUser($data['doctor_id']);

            $data['enable_consultation_price'] = $doctor_info['enable_consultation_price'];
            $data['consultationprice'] = $doctor_info['consultationprice'];

            $herbal_id = $this->model_herbal_herbal->addHerbal($data);

            $customer_data = $this->model_sale_customer->getCustomer($data['customer_id']);
            $customer_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

            $herbal_info = $this->model_herbal_herbal->getHerbal($herbal_id);
            $invoice_prefix = $herbal_info['invoice_prefix'];

            if ($data['doctor_id'] != 0) {
                $notification_template = $this->config->get('config_gcm_new_herbal');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{customer_name}'
                    );

                    $replace_title = array(
                        'customer_name' => $customer_name
                    );

                    $find_message = array(
                        '{invoice_prefix}'
                    );

                    $replace_message = array(
                        'invoice_prefix' => $invoice_prefix
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $notification_data = array(
                        'body' => $notification_title,
                        'badge' => 1,
                        'sound' => 'ping.aiff'
                    );

                    $data_gcm = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $data['doctor_id'],
                        'type' => 2      // New herbal remedies type
                    );

                    $doctor_device = $this->model_herbal_herbal->getDoctorDevice($data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm->sendTo($gcm->get_user_user_token($data['doctor_id']))
                                ->setData($data_gcm)
                                ->setIosNotification($notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }
            }

            $notification = new Notification($this->registry);

            $notification_data = [
                'herbal_id' => $herbal_id,
                'invoice_prefix' => $invoice_prefix,
                'customer_name' => $customer_name
            ];

            if (($notification->new_clinical_sale_notification_status == '1') && ($notification->notification_status == '1')) {
                $notification->add_notification('new_clinical_sale_notification', $notification_data);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_transaction_from'])) {
                $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
            }

            if (isset($this->request->get['filter_transaction_to'])) {
                $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_firstname'])) {
                $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
            }


            if (isset($this->request->get['filter_payment_status'])) {
                $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($herbal_id) && $herbal_id != 0) {
                $url .= '&herbal_id=' . $herbal_id;
            }

            $this->response->redirect($this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->customer();
    }

    public function edit() {

        $this->load->language('herbal/herbal');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('herbal/herbal');
        $this->load->model('catalog/product');

        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addStyle('view/stylesheet/jAlert-v3.css');
        $this->document->addScript('view/javascript/jAlert-v3.js');
        $this->document->addScript('view/javascript/jAlert-functions.js');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');



        $this->getForm();
    }

    public function getForm() {

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        $this->document->addScript('view/javascript/herbal/jquery.form.js');

        $data['text_form'] = !isset($this->request->get['herbal_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['text_enabled'] = $this->language->get('text_enabled_doctorprice');
        $data['text_disabled'] = $this->language->get('text_disabled_doctorprice');

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $data['herbal_id'] = 0;
        }


        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['total_weight'] = '';
        $load_history = false;

        $this->load->model('user/user');

        $data['doctors'] = $this->model_user_user->getUserByPostion(2);
        $data['user_id'] = (int) $this->session->data['user_id'];

        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_herbal->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_herbal->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_herbal->getHerbalTotals($this->request->get['herbal_id']);
            $herbal_service = $this->model_herbal_herbal->getHerbalService($this->request->get['herbal_id']);
            $herbal_image = $this->model_herbal_herbal->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_herbal->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_herbal->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
        }

        if (isset($this->request->get['history_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_pass_info = $this->model_herbal_herbal->getHerbal($this->request->get['history_id']);
            $herbal_prescription = $this->model_herbal_herbal->getHerbalPrescription($this->request->get['history_id']);
            $herbal_totals = $this->model_herbal_herbal->getHerbalTotals($this->request->get['history_id']);
            $herbal_service = $this->model_herbal_herbal->getHerbalService($this->request->get['history_id']);
            //$herbal_image = $this->model_herbal_herbal->getImage($this->request->get['history_id']);
            $data['herbal_pass_images'] = $this->model_herbal_herbal->getHerbalImages($herbal_pass_info['customer_id'], $this->request->get['history_id']);
            $load_history = true;

            //$herbal_image = array();
            //$data['herbal_pass_images'] =  array();
        }

        $this->session->data['date_modified'] = $this->model_herbal_herbal->getHerbalDateModified($this->request->get['herbal_id']);
        $this->load->model('sale/customer');
        if ($herbal_id_info) {
            $user_details = $this->model_user_user->getUser((int) $herbal_id_info['doctor_id']);
            $user_price = $user_details['consultationprice'];
            $data['doctor_id'] = $herbal_id_info['doctor_id'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['firstname'] = $herbal_id_info['firstname'];
            $data['lastname'] = $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']) . ' ' . $this->language->get('text_age');
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['addresses'] = $this->model_sale_customer->getAddresses($herbal_id_info['customer_id']);
            $data['address_id'] = $herbal_id_info['shipping_address_id'];
            $this->session->data['shipping_address'] = $this->model_sale_customer->getAddress($herbal_id_info['shipping_address_id']);
            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];
            $data['user_price'] = $herbal_id_info['clinicalsale_concultation'] ? $herbal_id_info['clinicalsale_concultation'] : $user_price;
            $data['customer_group_id'] = $herbal_id_info['customer_group_id'];
            $data['enable_doctorprice'] = isset($herbal_id_info['collect_consultation_price']) ? $herbal_id_info['collect_consultation_price'] : $user_details['enable_consultation_price'];


            $this->load->model('localisation/order_status');

            $order_status_list = array(7, 5, 1, 18);

            foreach ($order_status_list as $order_status) {
                $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

                $data['order_statuses'][] = array(
                    'order_status_id' => $order_status_data['order_status_id'],
                    'name' => $order_status_data['name']
                );
            }



            $this->cart->addCustomerGroupId($herbal_id_info['customer_group_id']);

            $total_weight = 0;
            $grand_total_weight = 0;

            if ($herbal_prescription) {
                foreach ($herbal_prescription as $prescription) {
                    $key = $this->cart->addPrescription(0, $prescription['name'], $prescription['prescription_id']);
                    $herbal_peroduct = $this->model_herbal_herbal->getHerbalProduct($prescription['clinical_sale_prescription_id']);

                    if ($herbal_peroduct) {
                        foreach ($herbal_peroduct as $product) {
                            $product_price = $product['price'];

                            if ($load_history) {
                                $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                                $product_price = !empty($product_info) ? $product_info['price'] : 0;
                            }

                            $this->cart->addProduct($key, $product['product_id'], $product['quantity'], $product['times'], $product['cook'], $product['taketype'], $product['day'], $product_price, $product['discount']);

                            $quantity = $product['quantity'];
                            $times = $product['times'];

                            $weight = $quantity * $times;

                            $total_weight += $quantity;
                            $grand_total_weight += $weight;

                            if ($product['weight_class_id']) {
                                $total_weight_format = $this->weight->format($total_weight, $product['weight_class_id']);
                                $grand_total_weight_format = $this->weight->format($grand_total_weight, $product['weight_class_id']);
                            }
                        }
                    }
                }

                $data['total_weight'] = array(
                    array(
                        'total_weight_name' => 'Total Weight',
                        'total_weight' => $total_weight_format
                    ),
                    array(
                        'total_weight_name' => 'Grand Total Weight',
                        'total_weight' => $grand_total_weight_format
                    )
                );
            }//end prescription

            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                }//loop services
            }//end services

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            $this->cart->clearImage();
            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                }//loop image
            }//end image

            if ($load_history) {
                $herbal_totals = $this->totalData();
            }

            if ($herbal_totals) {
                foreach ($herbal_totals as $total) {
                    if (isset($total['id'])) {
                        $data['total_data'][] = array(
                            'id' => $total['id'],
                            'code' => $total['code'],
                            'title' => $total['title'],
                            'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                            'value' => $total['value'],
                        );
                    } else {
                        $data['total_data'][] = array(
                            'id' => 1,
                            'code' => $total['code'],
                            'title' => $total['title'],
                            'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                            'value' => $total['value'],
                        );
                    }
                }//end looptotals
            }//end totaldata
        } else {
            $data['error_warning'] = $this->language->get('error_curupted');
        }

        if (isset($this->request->get['history_id']) && $herbal_pass_info) {
            $data['diagnostic'] = $herbal_pass_info['diagnostic'];
            $data['doctoradvice'] = $herbal_pass_info['doctoradvice'];
            $data['pulse'] = $herbal_pass_info['pulse'];
            $data['disease'] = $herbal_pass_info['disease'];
            $data['treatment'] = $herbal_pass_info['treatment'];
            $data['acupuncture'] = $herbal_pass_info['acupuncture'];
            $data['symptom'] = $herbal_pass_info['symptom'];
            $data['user_price'] = $herbal_pass_info['clinicalsale_concultation'];
        }

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();


        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }//url


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ); //breadcrumbs
        //html products
        $data['images'] = array();
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $getAcupunctureList = $this->getAcupunctureList();
        $data['acupuncture_list'] = $getAcupunctureList['acupuncture_list'];

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        }//images
        // if status of cs is completed, cannot edit the price
        if ((isset($this->request->get['herbal_id'])) && ($data['status'] == '5')) {
            if (!empty($herbal_id_info['order_invoice_prefix'])) {
                $data['disabled'] = 1;
            } else {
                $data['disabled'] = 0;
            }
        } else {
            $data['disabled'] = 0;
        }

        // if cs status is pending, order invocie prefix is empty then can change the customer data
        if ((isset($this->request->get['herbal_id'])) && ($data['status'] == '1') && (empty($herbal_id_info['order_invoice_prefix']))) {
            $data['change_cus'] = 1;
            $data['button_change_customer'] = $this->language->get('button_change_customer');
            $data['change_customer'] = $this->url->link('herbal/herbal/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        } else {
            $data['change_cus'] = 0;
        }

        $data['action'] = $this->url->link('herbal/herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['cancel'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['image_link'] = $this->url->link('herbal/herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['herbal_id'] = $this->request->get['herbal_id'];

        $data['uploading_img'] = HTTPS_IMAGE . 'uploading.gif';

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/herbal_form', $data));
    }

    public function getInfo() {
        $language = $this->session->data['language'];
        
        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->load->language('herbal/herbal');
        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/herbal');

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        $data['text_form'] = $this->language->get('view_title');

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $data['herbal_id'] = 0;
        }


        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['user_id'] = (int) $this->session->data['user_id'];

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->session->data['user_id']);

        $data['user_price'] = $user_details['consultationprice'];


        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_herbal->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_herbal->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_herbal->getHerbalTotals($this->request->get['herbal_id']);
            $herbal_service = $this->model_herbal_herbal->getHerbalService($this->request->get['herbal_id']);
            $herbal_image = $this->model_herbal_herbal->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_herbal->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_herbal->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
        }

        $this->load->model('sale/customer');
        if ($herbal_id_info) {

            $data['username'] = $herbal_id_info['doctor_firstname'] . ' ' . $herbal_id_info['doctor_lastname'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['customer_name'] = $herbal_id_info['firstname'] . ' ' . $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']);

            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];


            $this->load->model('localisation/order_status');
            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                }//loop services
            }//end services

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                }//loop image
            }//end image

            if ($herbal_totals) {
                foreach ($herbal_totals as $total) {
                    $data['total_data'][] = array(
                        'id' => $total['id'],
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                        'value' => $total['value'],
                    );
                }//end looptotals
            }//end totaldata

            if ($herbal_id_info['order_action'] == '17') {
                $data['enable_edit'] = true;
            } else {
                $data['enable_edit'] = false;
            }
        } else {
            $data['error_warning'] = $this->language->get('error_curupted');
        }


        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }//url


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        ); //breadcrumbs
        //html products
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();
        $data['total_weight'] = array();

        $total_weight = 0;
        $grand_total_weight = 0;

        foreach ($herbal_prescription as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $total = $this->currency->format($products['rowtotal'], $this->config->get('config_currency'));
                $tax = $this->currency->format($products['t_gst'], $this->config->get('config_currency'));
                $subtotal = $this->currency->format($products['t_net_price'], $this->config->get('config_currency'));

                $quantity = $products['quantity'];
                $times = $products['times'];
                $weight = $quantity * $times;

                $total_weight += $quantity;
                $grand_total_weight += $weight;

                if ($products['weight_class_id']) {
                    $total_weight_format = $this->weight->format($total_weight, $products['weight_class_id']);

                    $grand_total_weight_format = $this->weight->format($grand_total_weight, $products['weight_class_id']);
                }
                
                if($language == 'en-gb'){
                    
                    $data['total_weight'] = array(
                        array(
                            'total_weight_name' => 'Total Weight',
                            'total_weight' => $total_weight_format
                        ),
                        array(
                            'total_weight_name' => 'Grand Total Weight',
                            'total_weight' => $grand_total_weight_format
                        )
                    );
                }
                
                elseif ($language == 'zh-cn'){
                     $data['total_weight'] = array(
                        array(
                            'total_weight_name' => '总重量',
                            'total_weight' => $total_weight_format
                        ),
                        array(
                            'total_weight_name' => '盛大总重量',
                            'total_weight' => $grand_total_weight_format
                        )
                    );
                }

                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'day' => $products['day'],
                    'price' => $products['product_price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'tax_class_id' => $products['tax_class_id'],
                    'weight' => $products['weight'],
                    'weight_class_id' => $products['weight_class_id'],
                    'weight_format' => $weight
                );
            }
        }

        foreach ($this->cart->getService() as $key => $service) {
            $total = $this->currency->format($this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));

            //tax
            $b = $this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $tax = $this->currency->format($b - $service['total'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($service['total'], $this->config->get('config_currency'));


            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }//end service
        // acupuncture list
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $acupuncture_id = $acupuncture['acupuncture_id'];

                $acupuncture_name = $this->model_herbal_herbal->getAcupunctureNameById($acupuncture_id);

                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture_id,
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        }//images
        // image for button and pdf
        $herbal_remedies_image = $this->model_herbal_herbal->getHerbalRemediesImage($data['herbal_id']);

        if (!empty($herbal_remedies_image)) {
            $data['available_image'] = '1';
        } else {
            $data['available_image'] = '0';
        }

        $data['action'] = $this->url->link('herbal/herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['cancel'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['edit_url'] = $this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['url_image'] = $this->url->link('herbal/herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1&image=1', true);
        $data['url_image_no'] = $this->url->link('herbal/herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', true);

        $data['image_link'] = $this->url->link('herbal/herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/herbal_info', $data));
    }

    public function doctorPrice() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->session->data['user_id']);
        $data['tax_class_id'] = $user_details['tax_class_id'];
        $data['product_exit'] = array();

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        // Totals
        $this->load->model('pos/extension');
        $total_doctor_data = array();
        $doctor_total = 0;
        $doctor_taxes = $this->cart->getDoctorTaxes($this->request->post['price'], $data['tax_class_id']);
        $sub_total = $this->request->post['price'];

        $this->language->load('total/sub_total');

        $total_doctor_data[] = array(
            'code' => 'sub_total',
            'title' => 'Sub total',
            'text' => $this->currency->format($sub_total, $this->config->get('config_currency')),
            'value' => $sub_total,
            'sort_order' => $this->config->get('sub_total_sort_order')
        );

        $doctor_total += $sub_total;

        foreach ($doctor_taxes as $key => $value) {
            if ($value > 0) {
                $total_doctor_data[] = array(
                    'code' => 'tax',
                    'title' => $this->tax->getRateName($key),
                    'text' => $this->currency->format($value, $this->config->get('config_currency')),
                    'value' => $value,
                    'sort_order' => $this->config->get('tax_sort_order')
                );

                $doctor_total += $value;
            }
        }

        $total_doctor_data[] = array(
            'code' => 'total',
            'title' => 'total',
            'text' => $this->currency->format(max(0, $doctor_total), $this->config->get('config_currency')),
            'value' => max(0, $doctor_total),
            'sort_order' => $this->config->get('total_sort_order')
        );

        $data['total_doctor_data'] = $total_doctor_data;
        //doctor total;

        $discount_price = 0;
        $discount_price = $this->cart->getSubTotal() - $sub_total;

        if ($discount_price > 0) {
            $this->cart->updateDiscount($discount_price);
        }


        $total_data = array();
        $total = 0;
        $taxes = $this->cart->getTaxes();

        // Display prices
        $sort_order = array();
        $results = $this->model_pos_extension->getExtensions('total');
        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
        }
        array_multisort($sort_order, SORT_ASC, $results);
        foreach ($results as $result) {
            if ($this->config->get($result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data, $total, $taxes);
            }
            $sort_order = array();
            foreach ($total_data as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }
            array_multisort($sort_order, SORT_ASC, $total_data);
        }
        $data['total_data'] = $total_data;



        //html for cart
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );

            foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];

                $total = $this->currency->format($this->tax->calculate($price_discount, $products['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));

                //tax
                $b = $this->tax->calculate($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                $tax = $this->currency->format($b - $price_discount, $this->config->get('config_currency'));
                $subtotal = $this->currency->format($price_discount, $this->config->get('config_currency'));


                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'stock' => $products['stock'],
                    'day' => $products['day'],
                    'price' => $products['price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'tax_class_id' => $products['tax_class_id'],
                    'weight' => $products['weight'],
                    'weight_class_id' => $products['weight_class_id'],
                );
            }//end products
        }//send prescription

        foreach ($this->cart->getService() as $key => $service) {
            $total = $this->currency->format($this->tax->calculate($service['price'], $service['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));

            //tax
            $b = $this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $tax = $this->currency->format($b - $service['total'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($service['total'], $this->config->get('config_currency'));


            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'quantity' => $service['quantity'],
                'times' => $service['times'],
                'cook' => $service['cook'],
                'taketype' => $service['taketype'],
                'day' => $service['day'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }//end service

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function addImages() {

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('herbal/category');

        $date = date('Y_m_d');
        $paths = array();

        $folder_name = $this->model_herbal_category->getParentCategorName($this->request->post['category_id']);


        if (!file_exists(DIR_HERBAL . $folder_name . '/' . $this->request->post['customer_ic'])) {
            mkdir(DIR_HERBAL . $folder_name . '/' . $this->request->post['customer_ic'], 0777, true);
        }

        $img_folder_name = DIR_HERBAL . $folder_name . '/' . $this->request->post['customer_ic'];
        $databse_folder = $folder_name . '/' . $this->request->post['customer_ic'];
        foreach ($_FILES['images']['name'] as $key => $val) {
            $img_name = md5(rand(0, 1000) . rand(0, 1000) . rand(0, 1000)) . '.jpg';
            $upload_path = $img_folder_name . '/' . $img_name;
            move_uploaded_file($_FILES['images']['tmp_name'][$key], $upload_path);
            $paths[] = $databse_folder . '/' . $img_name;
        }

        foreach ($paths as $path) {
            $key = rand();
            $this->cart->addImages($key, $this->request->post['category_id'], $this->request->post['image_category'], $this->request->post['image_remark'], $path);
        }

        echo '<ul class="reorder_ul reorder-photos-list" style="padding: 0; margin: 0; list-style: none;">';
        foreach ($this->cart->getImages() as $key => $image) {
            echo '<li id="image" class="ui-sortable-handle" style="float: left; margin: 7px; width: 150px; display: block; overflow: hidden; height: 200px;">';
            echo '<button class="btn  btn-danger" type="button" onclick="imageRemove(' . $key . ')" style="position: absolute; padding: 5px;"><i class="fa fa-remove"></i></button>';
            //echo '<a href="'.HTTPS_HERBAL_IMAGE.$image['path'].'" class="thumbnail">';
            echo '<img src="' . HTTPS_HERBAL_IMAGE . $image['path'] . '" alt=""  width="150" height="150" >';
            //echo '</a>';
            echo '<span style="font-size: 13px; display: block; line-height: 15px;">' . $image['name'] . '</span>';
            echo '<span style="font-size: 13px; display: block; line-height: 15px;">' . $image['remark'] . '</span>';
            echo '</li>';
        }
        echo '</ul>';
    }

    public function removeImage() {

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->cart->removeImage($this->request->post['image_id']);

        echo '<ul class="reorder_ul reorder-photos-list">';
        foreach ($this->cart->getImages() as $key => $image) {
            echo '<li id="image" class="ui-sortable-handle">';
            echo '<button class="btn  btn-danger" type="button" onclick="imageRemove(' . $key . ')"><i class="fa fa-remove"></i></button>';
            echo '<img src="' . HTTPS_HERBAL_IMAGE . $image['path'] . '" alt=""  width="100" height="100" >';
            echo '<span>' . $image['name'] . '</span>';
            echo '<span>' . $image['remark'] . '</span>';
            echo '</li>';
        }
        echo '</ul>';
    }

    public function getList() {

        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = null;
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = null;
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = null;
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = null;
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = null;
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = null;
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = null;
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = $this->request->get['filter_payment_status'];
        } else {
            $filter_payment_status = null;
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = null;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sales_date ,invoice_prefix';
        }


        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('herbal/herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('herbal/herbal/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_status' => $filter_status,
            'filter_doctor' => $filter_doctor,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $herbal_total = $this->model_herbal_herbal->getTotalHerbal($filter_data);

        $results = $this->model_herbal_herbal->getHerbals($filter_data);

        foreach ($results as $result) {
            if ($result['collect_consultation_price'] > 0) {
                $consultation_price = $result['clinicalsale_concultation'] * 1.06; //$this->model_sale_order->getHerbalTotal($result['clinical_sale_id']);
            } else {
                $consultation_price = $result['clinicalsale_concultation'] + $result['d_gst'];
            }

            $status_label = '';

            switch ($result['clinicalsale_action']) {
                case 1:
                    $status_label = 'warning';
                    break;
                case 5:
                    $status_label = 'success';
                    break;
                case 7:
                case 17:
                    $status_label = 'danger';
                    break;
            }

            $payment_status_label = '';

            switch ($result['order_action']) {
                case 1:
                    $payment_status_label = 'warning';
                    break;
                case 5:
                    $payment_status_label = 'success';
                    break;
                case 7:
                case 17:
                    $payment_status_label = 'danger';
                    break;
            }

            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'invoice_prefix' => $result['invoice_prefix'],
                'firstname' => $result['firstname'] . ' ' . $result['lastname'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'status' => $result['status'],
                'order_status' => $result['order_status'],
                'order_action' => $result['order_action'],
                'status_label' => $status_label,
                'clinicalsale_action' => $result['clinicalsale_action'],
                'payment_status_label' => $payment_status_label,
                'clinicalsale_total' => $result['clinicalsale_total'],
                'consultation_price' => sprintf('%.2f', $consultation_price),
                'total_d_gst' => $result['total_d_gst'],
                'edit' => $this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, true),
                'info' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.sales_date' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.invoice_prefix' . $url, true);
        $data['sort_firstname'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.firstname' . $url, true);
        $data['sort_customer_ic'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $url, true);
        $data['sort_customer_card'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_card' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));


        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_transaction_from'] = $filter_transaction_from;
        $data['filter_transaction_to'] = $filter_transaction_to;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_customer_firstname'] = $filter_customer_firstname;
        $data['filter_payment_status'] = $filter_payment_status;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;

        $this->load->model('localisation/order_status');

        $order_status_list = array(7, 5, 1, 18);

        foreach ($order_status_list as $order_status) {
            $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

            $data['cs_order_statuses'][] = array(
                'order_status_id' => $order_status_data['order_status_id'],
                'name' => $order_status_data['name']
            );
        }

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['doctors'] = $this->model_herbal_herbal->getDoctors();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/herbal_list', $data));
    }

    public function customer() {
        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['lastname'])) {
            $data['error_lastname'] = $this->error['lastname'];
        } else {
            $data['error_lastname'] = '';
        }

        if (isset($this->error['dob'])) {
            $data['error_dob'] = $this->error['dob'];
        } else {
            $data['error_dob'] = '';
        }

        if (isset($this->error['telephone'])) {
            $data['error_telephone'] = $this->error['telephone'];
        } else {
            $data['error_telephone'] = '';
        }

        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );


        $data['action'] = $this->url->link('herbal/herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['cancel'] = $this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $this->load->model('sale/customer_group');

        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['home'])) {
            $data['home'] = $this->request->post['home'];
        } else {
            $data['home'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = 0;
        }

        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } else {
            $data['dob'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['telephone2'])) {
            $data['telephone2'] = $this->request->post['telephone2'];
        } else {
            $data['telephone2'] = '';
        }

        if (isset($this->request->post['fax'])) {
            $data['fax'] = $this->request->post['fax'];
        } else {
            $data['fax'] = '';
        }

        // Custom Fields
        $this->load->model('sale/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_sale_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_sale_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        if (isset($this->request->post['custom_field'])) {
            $data['account_custom_field'] = $this->request->post['custom_field'];
        } else {
            $data['account_custom_field'] = array();
        }

        if (isset($this->request->post['newsletter'])) {
            $data['newsletter'] = $this->request->post['newsletter'];
        } else {
            $data['newsletter'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['approved'])) {
            $data['approved'] = $this->request->post['approved'];
        } else {
            $data['approved'] = true;
        }

        if (isset($this->request->post['safe'])) {
            $data['safe'] = $this->request->post['safe'];
        } else {
            $data['safe'] = 0;
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        if (isset($this->request->post['address'])) {
            $data['addresses'] = $this->request->post['address'];
        } else {
            $data['addresses'] = array();
        }

        if (isset($this->request->post['address_id'])) {
            $data['address_id'] = $this->request->post['address_id'];
        } else {
            $data['address_id'] = '';
        }

        $this->load->model('setting/setting');
        $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));

        $this->load->model('user/user');
        $data['doctors'] = $this->model_user_user->getUserByPostion(2);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/customer_form', $data));
    }

    protected function validateForm() {

        if (!$this->user->hasPermission('modify', 'herbal/herbal')) {

            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {

            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
                $this->error['firstname'] = $this->language->get('error_firstname');
            }

            if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32 )) {
                $this->error['lastname'] = $this->language->get('error_lastname');
            }

            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
                $this->error['customer_ic'] = $this->language->get('error_customer_ic');
            }

            // Custom field validation
            $this->load->model('sale/custom_field');

            $custom_fields = $this->model_sale_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }

            if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
                if ($this->request->post['password'] != $this->request->post['confirm']) {
                    $this->error['confirm'] = $this->language->get('error_confirm');
                }
            }

            if (isset($this->request->post['address'])) {
                foreach ($this->request->post['address'] as $key => $value) {
                    if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_firstname');
                    }

                    if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                        $this->error['address'][$key]['lastname'] = $this->language->get('error_lastname');
                    }

                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_address_1');
                    }

                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_city');
                    }

                    $this->load->model('localisation/country');

                    $country_info = $this->model_localisation_country->getCountry($value['country_id']);

                    if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                    }

                    if ($value['country_id'] == '') {
                        $this->error['address'][$key]['country'] = $this->language->get('error_country');
                    }

                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_zone');
                    }

                    foreach ($custom_fields as $custom_field) {
                        if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                            $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                        }
                    }
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function searchCustomer() {

        $this->load->language('sale/customer');
        $this->load->model('sale/customer');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        }
        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json['shipping'][] = array();
        $json = $this->model_sale_customer->selectCustomers($data);
        $this->cart->clearService();
        $this->cart->clearHerbal();

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Member Details";
        }
        return $this->response->setOutput(json_encode($json));
    }

    public function autocompleteForm() {
        $json = [];

        if (isset($this->request->get['filter_firstname'])) {
            $filter_firstname = $this->request->get['filter_firstname'];
        } else {
            $filter_firstname = '';
        }

        if (isset($this->request->get['filter_lastname'])) {
            $filter_lastname = $this->request->get['filter_lastname'];
        } else {
            $filter_lastname = '';
        }

        $filter_data = array(
            'filter_firstname' => $filter_firstname,
            'filter_lastname' => $filter_lastname,
            'start' => 0,
            'limit' => 5
        );

        $this->load->model('herbal/herbal');

        $results = $this->model_herbal_herbal->getAutocompleteFormCustomers($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $json[] = [
                    'customer_id' => $result['customer_id'],
                    'firstname' => $result['firstname'],
                    'lastname' => $result['lastname'],
                    'newsletter' => $result['newsletter'],
                    'status' => $result['status'],
                    'approved' => $result['approved'],
                    'safe' => $result['safe'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_card' => $result['customer_card'],
                    'customer_group_id' => $result['customer_group_id'],
                    'gender' => $result['gender'],
                    'dob' => $result['dob'],
                    'email' => $result['email'],
                    'telephone' => $result['telephone'],
                    'fax' => $result['fax'],
                    'telephone2' => $result['telephone2'],
                    'home' => $result['home']
                ];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addShipping() {

        $this->load->model('sale/customer');
        if (isset($this->request->post['shipping_address'])) {
            $this->session->data['shipping_addres_id'] = $this->request->post['shipping_address'];
            $this->session->data['shipping_address'] = $this->model_sale_customer->getAddress($this->request->post['shipping_address']);
        }
        return $this->session->data['shipping_addres_id'];
    }

    public function setPrescription() {

        $json = array();
        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        //html for cart
        $json['prescription'] = array();
        foreach ($this->cart->getPrescription() as $prescription) {
            $json['prescription'][] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );
        }//send prescription
        $this->response->setOutput(json_encode($json));
    }

    public function addProduct() {

        $data = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['product_id'])) {
            $product_id = $this->request->post['product_id'];
        } else {
            $product_id = 0;
        }

        if (isset($this->request->post['under'])) {
            $under = $this->request->post['under'];
        } else {
            $under = 0;
        }

        if (isset($this->request->post['quantity'])) {
            $quantity = $this->request->post['quantity'];
        } else {
            $quantity = 1;
        }

        if (isset($this->request->post['times'])) {
            $times = $this->request->post['times'];
        } else {
            $times = 1;
        }

        if (isset($this->request->post['day'])) {
            $day = $this->request->post['day'];
        } else {
            $day = 1;
        }

        if (isset($this->request->post['cook'])) {
            $cook = $this->request->post['cook'];
        } else {
            $cook = '';
        }

        if (isset($this->request->post['taketype'])) {
            $taketype = $this->request->post['taketype'];
        } else {
            $taketype = '';
        }
        //end pos value
        $data['product_exit'] = array();
        $product_info = $this->model_catalog_product->getProduct($product_id);

        if ($product_info) {
            $key = $this->cart->addPrescription($under, $product_info['name'], $product_id);
            if (isset($this->session->data['product']) && isset($this->session->data['product'][$key][$product_id])) {
                $products = $this->model_catalog_product->getProduct($product_id);
                $data['product_exit'][] = array('name' => $products['name']);
            } else {
                $this->cart->addProduct($key, $product_id, $quantity, $times, $cook, $taketype, $day, $product_info['price'], 0);
            }
        }//end product_info
        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function addPrescription() {

        $data = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['prescription_id'])) {
            $prescription_id = $this->request->post['prescription_id'];
        } else {
            $prescription_id = 0;
        }

        if (isset($this->request->post['under'])) {
            $under = $this->request->post['under'];
        } else {
            $under = 0;
        }

        if (isset($this->request->post['name'])) {
            $name = $this->request->post['name'];
        } else {
            $name = '';
        }


        if (isset($this->request->post['times'])) {
            $times = $this->request->post['times'];
        } else {
            $times = 1;
        }

        if (isset($this->request->post['day'])) {
            $day = $this->request->post['day'];
        } else {
            $day = 1;
        }

        if (isset($this->request->post['cook'])) {
            $cook = $this->request->post['cook'];
        } else {
            $cook = '';
        }

        if (isset($this->request->post['taketype'])) {
            $taketype = $this->request->post['taketype'];
        } else {
            $taketype = '';
        }
        //end pos value
        $data['product_exit'] = array();

        $key = $this->cart->addPrescription($under, $name, $prescription_id);

        $this->load->model('catalog/prescription');
        $productList = $this->model_catalog_prescription->getPerscriptionItemsJson($prescription_id);

        if (!empty($productList)) {
            foreach ($productList as $product) {
                if (isset($this->session->data['product']) && isset($this->session->data['product'][$key][$product['product_id']])) {
                    $products = $this->model_catalog_product->getProduct($product['product_id']);
                    $data['product_exit'][] = array('name' => $products['name']);
                } else {
                    $this->cart->addProduct($key, $product['product_id'], $product['used_qty'], $times, $cook, $taketype, $day, $product['price'], 0);
                }
            }
        }

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];


        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function removeAcupuncturePoint() {
        $data = array();
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['service_id'])) {
            $service_id = $this->request->post['service_id'];
        } else {
            $service_id = '';
        }

        if (isset($this->request->post['acupuncture_id'])) {
            $acupuncture_id = $this->request->post['acupuncture_id'];
        } else {
            $acupuncture_id = '';
        }

        $this->cart->unsetAcupunctureList($service_id, $acupuncture_id);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        // $this->print_array($data['acupuncture_list']);
        // $this->print_array($this->session->data['acupuncture_list']);

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function updateAcupuncturePoint() {
        $data = array();
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['service_id'])) {
            $service_id = $this->request->post['service_id'];
        } else {
            $service_id = '';
        }

        if (isset($this->request->post['acupuncture_id'])) {
            $acupuncture_id = $this->request->post['acupuncture_id'];
        } else {
            $acupuncture_id = '';
        }

        if (isset($this->request->post['num_of_acupuncture'])) {
            $num_of_acupuncture = $this->request->post['num_of_acupuncture'];
        } else {
            $num_of_acupuncture = '';
        }

        $this->cart->unsetAcupunctureList($service_id, 0);
        $this->cart->setAcupunctureList($service_id, $acupuncture_id, $num_of_acupuncture);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function addAcupuncturePoint() {
        $data = array();
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['service_id'])) {
            $service_id = $this->request->post['service_id'];
        } else {
            $service_id = '';
        }

        $this->cart->setAcupunctureList($service_id, 0, 1);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        // $this->print_array($data['acupuncture_list']);

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function addService() {


        $data = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        //star pos value
        if (isset($this->request->post['staff_id'])) {
            $staff_id = $this->request->post['staff_id'];
        } else {
            $staff_id = 0;
        }

        if (isset($this->request->post['service_id'])) {
            $service_id = $this->request->post['service_id'];
        } else {
            $service_id = 0;
        }

        if (isset($this->request->post['service_price'])) {
            $price = $this->request->post['service_price'];
        } else {
            $price = '';
        }

        //end pos value
        $data['product_exit'] = array();

        $this->cart->setService($service_id, $staff_id, $price);


        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function updateProduct() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        $prescription_id = $this->request->post['prescription_id'];
        $product_id = $this->request->post['product_id'];
        $price = $this->request->post['price'];
        $discount = $this->request->post['discount'];
        $taketype = $this->request->post['taketype'];
        $cook = $this->request->post['cook'];
        $day = $this->request->post['day'];
        $quantity = $this->request->post['quantity'];
        $times = $this->request->post['times'];

        $this->cart->updateProduct($prescription_id, $product_id, $price, $discount, $taketype, $cook, $day, $quantity, $times);


        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function updatePrescription() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();
        $data['product_exit'] = array();
        $data['user_token'] = $this->session->data['user_token'];

        $prescription_id = $this->request->post['prescription_id'];

        $arg = $this->request->get['arg'];
        $value = $this->request->get['value'];

        $this->cart->updatePrescription($prescription_id, $arg, $value);


        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function deleteProduct() {



        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];

        $prescription_id = $this->request->post['prescription_id'];
        $product_id = $this->request->post['product_id'];
        $data['product_exit'] = array();

        $this->cart->removeProduct($prescription_id, $product_id);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function deleteService() {



        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];

        $data['product_exit'] = array();
        $service_id = $this->request->post['service_id'];

        $this->cart->removeService($service_id);
        $this->cart->removeAcupunctureList($service_id);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }

        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function deletePrescription() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $data['cook_types'] = $this->model_herbal_herbal->getCookType();

        $data['user_token'] = $this->session->data['user_token'];
        $data['product_exit'] = array();
        $prescription_id = $this->request->post['prescription_id'];

        $grand_single_total_weight = 0;
        $grand_grand_total_weight = 0;
        $single_total_weight = 0;
        $grand_total_weight = 0;

        $herbal_product = $this->model_herbal_herbal->getHerbalProduct($prescription_id);

        $this->cart->removePrescription($prescription_id);

        // Totals
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        // Weights
        $weights = $this->cart->getWeights();

        $data['total_weight'] = array();

        foreach ($weights as $weight) {
            $data['total_weight'][] = array(
                'total_weight_name' => $weight['weight_name'],
                'total_weight' => $weight['weight']
            );
        }


        //html for cart
        $getPrescription = $this->getPrescription();
        $getService = $this->getService();
        $data['prescription'] = $getPrescription['prescription'];
        $data['products'] = $getPrescription['products'];
        $data['service'] = $getService['service'];
        $acupuncture_list = $this->getAcupunctureList();
        $data['acupuncture_list'] = $acupuncture_list['acupuncture_list'];

        $this->response->setOutput($this->load->view('herbal/cart', $data));
    }

    public function getPatientHistory() {

        $this->load->language('herbal/herbal');
        $this->load->model('herbal/herbal');

        $this->document->setTitle($this->language->get('heading_title'));


        if (isset($this->request->get['customer_id'])) {
            $customer_id = $this->request->get['customer_id'];
        } else {
            $customer_id = null;
        }

        if (isset($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        } else {
            $herbal_id = null;
        }


        if (isset($this->request->get['filter_history_from'])) {
            $filter_history_from = $this->request->get['filter_history_from'];
        } else {
            $filter_history_from = null;
        }

        if (isset($this->request->get['filter_history_to'])) {
            $filter_history_to = $this->request->get['filter_history_to'];
        } else {
            $filter_history_to = null;
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $filter_symptoms = $this->request->get['filter_symptoms'];
        } else {
            $filter_symptoms = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }


        if (isset($this->request->get['filter_doctoradvice'])) {
            $filter_doctoradvice = $this->request->get['filter_doctoradvice'];
        } else {
            $filter_doctoradvice = null;
        }

        if (isset($this->request->get['filter_pulse'])) {
            $filter_pulse = $this->request->get['filter_pulse'];
        } else {
            $filter_pulse = null;
        }

        if (isset($this->request->get['filter_disease'])) {
            $filter_disease = $this->request->get['filter_disease'];
        } else {
            $filter_disease = null;
        }

        if (isset($this->request->get['filter_treatment'])) {
            $filter_treatment = $this->request->get['filter_treatment'];
        } else {
            $filter_treatment = null;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = null;
        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_history_from,
            'filter_date_to' => $filter_history_to,
            'filter_symptoms' => $filter_symptoms,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_doctoradvice' => $filter_doctoradvice,
            'filter_pulse' => $filter_pulse,
            'filter_disease' => $filter_disease,
            'filter_treatment' => $filter_treatment,
            'filter_acupuncture' => $filter_acupuncture,
            'customer_id' => $customer_id,
            'herbal_id' => $herbal_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $herbal_total = $this->model_herbal_herbal->getTotalHerbal($filter_data);

        $results = $this->model_herbal_herbal->getHerbals($filter_data);


        foreach ($results as $result) {
            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'invoice_prefix' => $result['invoice_prefix'],
                'pos_price' => $this->currency->format($result['total_d_gst'], $this->config->get('config_currency')),
                'diagnostic' => $result['diagnostic'],
                'doctoradvice' => $result['doctoradvice'],
                'pulse' => $result['pulse'],
                'disease' => $result['disease'],
                'treatment' => $result['treatment'],
                'acupuncture' => $result['acupuncture'],
                'symptom' => $result['symptom'],
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }


        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_history_from'])) {
            $url .= '&filter_history_from=' . $this->request->get['filter_history_from'];
        }

        if (isset($this->request->get['filter_history_to'])) {
            $url .= '&filter_history_to=' . $this->request->get['filter_history_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=cs.sales_date', true);
        $data['sort_invoice_prefix'] = $this->url->link('herbal/herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&sort=cs.invoice_prefix', true);

        $url = '';

        if (isset($this->request->get['herbal_id'])) {
            $url .= '&herbal_id=' . $this->request->get['herbal_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_history_from'])) {
            $url .= '&filter_history_from=' . $this->request->get['filter_history_from'];
        }

        if (isset($this->request->get['filter_history_to'])) {
            $url .= '&filter_history_to=' . $this->request->get['filter_history_to'];
        }

        if (isset($this->request->get['filter_symptoms'])) {
            $url .= '&filter_symptoms=' . $this->request->get['filter_symptoms'];
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . $this->request->get['filter_diagnostic'];
        }

        if (isset($this->request->get['filter_doctoradvice'])) {
            $url .= '&filter_doctoradvice=' . $this->request->get['filter_doctoradvice'];
        }

        if (isset($this->request->get['filter_pulse'])) {
            $url .= '&filter_pulse=' . $this->request->get['filter_pulse'];
        }

        if (isset($this->request->get['filter_disease'])) {
            $url .= '&filter_disease=' . $this->request->get['filter_disease'];
        }

        if (isset($this->request->get['filter_treatment'])) {
            $url .= '&filter_treatment=' . $this->request->get['filter_treatment'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/herbal/getPatientHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        $data['herbal_id'] = $herbal_id;
        $data['customer_id'] = $customer_id;
        $data['filter_history_from'] = $filter_history_from;
        $data['filter_history_to'] = $filter_history_to;
        $data['filter_symptoms'] = $filter_symptoms;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_doctoradvice'] = $filter_doctoradvice;
        $data['filter_pulse'] = $filter_pulse;
        $data['filter_disease'] = $filter_disease;
        $data['filter_treatment'] = $filter_treatment;
        $data['filter_acupuncture'] = $filter_acupuncture;
        $data['herbal_id'] = $herbal_id;
        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('herbal/patienthistory_list', $data));
    }

    public function addOrder() {
        $data = array();

        if (isset($this->request->get['herbal_id'])) {
            $herbal_id = $this->request->get['herbal_id'];
        }

        $url = '';
        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }//url

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->model('catalog/product');
        $this->load->model('herbal/herbal');

        $data['user_token'] = $this->session->data['user_token'];

        $data['shipping_address_id'] = $this->request->post['shipping_address'];
        $data['status'] = $this->request->post['status'];
        $data['doctor_id'] = $this->request->post['doctor_id'];
        $data['customer_id'] = $this->request->post['customer_id'];
        $data['customer_ic'] = $this->request->post['customer_ic'];
        $data['diagnostic'] = $this->request->post['diagnostic'];
        $data['doctoradvice'] = $this->request->post['doctoradvice'];
        $data['pulse'] = $this->request->post['pulse'];
        $data['disease'] = $this->request->post['disease'];
        $data['treatment'] = $this->request->post['treatment'];
        $data['acupuncture'] = $this->request->post['acupuncture'];
        $data['symptom'] = $this->request->post['symptom'];

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->request->post['doctor_id']);
        $data['tax_class_id'] = $user_details['tax_class_id'];
        $data['tax_code'] = $this->tax->getClassCode($data['tax_class_id']);


        // Totals
        $this->load->model('pos/extension');
        $total_doctor_data = array();
        $enable_doctorprice = $this->request->post['enable_doctorprice'];
        $doctor_total = 0;
        $doctor_taxes = $this->tax->calculateTax($this->request->post['doctor_price'], $data['tax_class_id']);
        $doctor_taxes_rates = $this->cart->getDoctorTaxes($this->request->post['doctor_price'], $data['tax_class_id']);
        $data['doctor_subtotal'] = $doctor_taxes['net_amount'];
        $data['enable_doctorprice'] = $this->request->post['enable_doctorprice'];
        $data['doctor_price'] = $this->request->post['doctor_price'];
        $data['doctor_total'] = $doctor_taxes['total'];
        $data['doctor_tax'] = $doctor_taxes['tax'];
        $data['doctor_format'] = $doctor_taxes['format'];

        $this->language->load('total/sub_total');

        $total_doctor_data[] = array(
            'key' => '',
            'code' => 'sub_total',
            'title' => 'Sub total',
            'text' => $this->currency->format($doctor_taxes['net_amount'], $this->config->get('config_currency')),
            'value' => $doctor_taxes['net_amount'],
            'tax_code' => '',
            'sort_order' => $this->config->get('sub_total_sort_order')
        );

        $doctor_total += $doctor_taxes['net_amount'];


        foreach ($doctor_taxes_rates as $key => $value) {
            $total_doctor_data[] = array(
                'key' => $key,
                'code' => 'tax',
                'title' => $this->tax->getRateName($key),
                'tax_code' => $this->tax->getRateCode($key),
                'text' => $this->currency->format($value, $this->config->get('config_currency')),
                'value' => $value,
                'sort_order' => $this->config->get('tax_sort_order')
            );

            $doctor_total += $value;
        }

        $total_doctor_data[] = array(
            'key' => '',
            'code' => 'total',
            'title' => 'total',
            'text' => $this->currency->format(max(0, $doctor_total), $this->config->get('config_currency')),
            'tax_code' => '',
            'value' => max(0, $doctor_total),
            'sort_order' => $this->config->get('total_sort_order')
        );

        $data['total_doctor_data'] = $total_doctor_data;

        // Totals
        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($this->config->get('total_' . $result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            }

            $sort_order = array();

            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        $data['order_total'] = $totals;

        if ($enable_doctorprice == '1') {
            $total_doctor_data_tax = 0;
            $total_data_tax = 0;

            foreach ($totals as $total) {
                if ($total['code'] == 'sub_total') {
                    $total_data_subtotal = $total['value'];
                }

                if ($total['code'] == 'tax') {
                    $total_data_tax += $total['value'];
                }

                if ($total['code'] == 'total') {
                    $total_data_total = $total['value'];
                }

                if ($total['code'] == 'rounding') {
                    $total_data_rounding = $total['value'];
                }
            }

            foreach ($total_doctor_data as $total_doctor) {
                if ($total_doctor['code'] == 'sub_total') {
                    $total_doctor_data_subtotal = $total_data_subtotal + $total_doctor['value'];
                }

                if ($total_doctor['code'] == 'tax') {
                    $total_doctor_data_tax = $total_data_tax + $total_doctor['value'] /* + $total_data_rounding */;
                }

                if ($total_doctor['code'] == 'total') {
                    $total_doctor_data_total = $total_data_total + $total_doctor['value'];
                }
            }

            $data['total_doctor_data'][0]['value'] = $total_doctor_data_subtotal;
            $data['total_doctor_data'][1]['value'] = $total_doctor_data_tax;
            $data['total_doctor_data'][1]['key'] = '88';
            $data['total_doctor_data'][1]['tax_code'] = 'SR';
            $data['total_doctor_data'][1]['title'] = 'GST (6%)';
            $data['total_doctor_data'][2]['value'] = $total_doctor_data_total;

            $data['doctor_subtotal'] = $total_doctor_data_subtotal;
            $data['doctor_tax'] = $total_doctor_data_tax;
            $data['doctor_total'] = $total_doctor_data_total;

            $data['tax_class_id'] = 11;
            $data['tax_code'] = 'SR';
        }

        //html for cart
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();

        foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );

            foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];

                $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                $total = $sub_tax['total'];
                $tax = $sub_tax['tax'];
                $subtotal = $sub_tax['net_amount'];

                $product_weight = 0;
                $product_tax = 0;
                $product_subtotal = 0;

                if ($products['weight'] > 0) {
                    $product_weight = ($products['weight'] / $products['quantity']) / $products['times'];
                }

                if ($subtotal > 0) {
                    $product_subtotal = ($subtotal / $products['quantity']) / $products['times'];
                }

                if ($tax > 0) {
                    $product_tax = ($tax / $products['quantity']) / $products['times'];
                }

                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'stock' => $products['stock'],
                    'day' => $products['day'],
                    'price' => $products['price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'product_tax' => $product_tax,
                    'product_subtotal' => $product_subtotal,
                    'tax_class_id' => $products['tax_class_id'],
                    'tax_code' => $this->tax->has($products['tax_class_id']) ? $this->tax->getClassCode($products['tax_class_id']) : '',
                    'tax_format' => $sub_tax['format'],
                    'weight' => $products['weight'],
                    'product_weight' => $product_weight,
                    'weight_class_id' => $products['weight_class_id'],
                );
            }//end products
        }//send prescription

        foreach ($this->cart->getService() as $key => $service) {
            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $sub_tax['total'];
            $tax = $sub_tax['tax'];
            $subtotal = $sub_tax['net_amount'];

            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'net_total' => $sub_tax['net_amount'],
                'total_whit_gst' => $sub_tax['net_amount'] + $sub_tax['tax'],
                'tax' => $tax,
                'nat_tax' => $sub_tax['tax'],
                'net_price' => $sub_tax['net_amount'],
                'tax_class_id' => $service['tax_class_id'],
                'tax_format' => $sub_tax['format'],
                'tax_code' => $this->tax->getClassCode($service['tax_class_id'])
            );
        }//end service

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => $image['path']
            );
        }//images
        // service acupuncture
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        $this->model_herbal_herbal->editOrder($herbal_id, $data);

        if ($this->request->post['status'] == '18') {
            $this->response->setOutput(json_encode('index.php?route=etcm/herbal/add&user_token=' . $this->session->data['user_token'] . '&clinical_sale_id=' . $herbal_id));
        } else {
            $this->response->setOutput(json_encode('index.php?route=herbal/herbal&user_token=' . $this->session->data['user_token'] . $url));
        }
    }

    public function runOrderTotal2() {
        //Model
        $this->load->model('herbal/herbal');
        $this->load->model('pos/pos');
        $this->load->model('sale/customer');
        $this->load->model('sale/order');
        //Language
        $this->load->language('pos/pos');
        $this->load->language('sale/customer');
        //Library
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $get_order = array();
        $all_orders = array();
        $all_orders_array = array();
        $chewc_orders_array = array();
        $non_chewc_orders_array = array();
        $all_orders_count = 0;
        $chewc_count = 0;
        $non_chewc_count = 0;
        $all_orders = $this->model_herbal_herbal->getAllOrderByDate();
        if (!empty($all_orders)) {
            foreach ($all_orders as $all_order) {
                $order_products = array();
                $order_products_array = array();
                $order_products_count = 0;
                $order_herbals = array();
                $order_herbals_array = array();
                $order_herbals_count = 0;
                $order_services = array();
                $order_services_array = array();
                $order_services_count = 0;
                $this->cart->clear();
                $chewc = $this->model_herbal_herbal->checkOrderExists($all_order['order_id']);
                if (!empty($chewc)) {
                    $this->cart->clear();
                    $get_order['orders'][$all_order['order_id']]['order_status'] = 1;
                    array_push($chewc_orders_array, $all_order['order_id']);
                    $chewc_count++;
                    //Products
                    $order_products = $this->model_sale_order->getOrderCartProducts($all_order['order_id']);
                    if (!empty($order_products)) {
                        $get_order['orders'][$all_order['order_id']]['order_products_status'] = 1;
                        foreach ($order_products as $order_product) {
                            $get_order['orders'][$all_order['order_id']]['order_products'][] = array(
                                'order_id' => $order_product['order_id'],
                                'order_product_id' => $order_product['order_product_id'],
                                'product_id' => $order_product['product_id'],
                                'name' => $order_product['name'],
                                'price' => $order_product['price'],
                                'quantity' => $order_product['quantity'],
                                'net_amount' => $order_product['net_amount'],
                                'tax' => $order_product['tax'],
                                'total' => $order_product['total'],
                            );
                            if (isset($order_product['order_option'])) {
                                $order_option = $order_product['order_option'];
                            } elseif (isset($this->request->get['order_id'])) {
                                $order_option = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
                            } else {
                                $order_option = array();
                            }
                            $this->cart->add($order_product['product_id'], $order_product['quantity'], $order_option);
                            $order_products_count++;
                            array_push($order_products_array, $order_product['product_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_products_array'] = $order_products_array;
                        //if (!empty())
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_products_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_products_array'] = array();
                    }
                    //Herbals
                    $order_herbals = $this->model_pos_pos->getOrderCartherbal($all_order['order_id']);
                    if (!empty($order_herbals)) {
                        $get_order['orders'][$all_order['order_id']]['order_herbals_status'] = 1;
                        foreach ($order_herbals as $order_herbal) {
                            $order_herbals_count++;
                            array_push($order_herbals_array, $order_herbal['clinical_sale_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_herbals_array'] = $order_herbals_array;
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_herbals_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_herbals_array'] = array();
                    }
                    //Services
                    $order_services = $this->model_pos_pos->getOrderCartServices($all_order['order_id']);
                    if (!empty($order_services)) {
                        $get_order['orders'][$all_order['order_id']]['order_services_status'] = 1;
                        foreach ($order_services as $order_service) {
                            $order_services_count++;
                            array_push($order_services_array, $order_service['service_form_id']);
                        }
                        $get_order['orders'][$all_order['order_id']]['order_services_array'] = $order_services_array;
                    } else {
                        $get_order['orders'][$all_order['order_id']]['order_services_status'] = 0;
                        $get_order['orders'][$all_order['order_id']]['order_services_array'] = array();
                    }
                } else {
                    //$get_order['orders'][$all_order['order_id']]['order_status'] = 1;
                    array_push($non_chewc_orders_array, $all_order['order_id']);
                    $non_chewc_count++;
                }
                $all_orders_count++;
                array_push($all_orders_array, $all_order['order_id']);
            }
        }
        $get_order['all_orders_count'] = $all_orders_count;
        $get_order['all_orders_array'] = $all_orders_array;
        $get_order['chewc_count'] = $chewc_count;
        $get_order['chewc_orders_array'] = $chewc_orders_array;
        $get_order['non_chewc_count'] = $non_chewc_count;
        $get_order['non_chewc_orders_array'] = $non_chewc_orders_array;
    }

    public function runOrderTotal() {
        $this->load->model('herbal/herbal');
        $this->load->model('pos/pos');
        $this->load->model('catalog/product');
        $this->load->model('sale/customer');
        $this->load->model('sale/order');

        $this->load->language('pos/pos');
        $this->load->language('sale/customer');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);

        $invoice_prefix = $this->request->get['invoice_prefix'];

        $get_order = array();
        $order_count = 0;
        //chewc check herbal exists with consultation
        $chewc_count = 0;
        $chwec_boolean = false;
        $orders = $this->model_herbal_herbal->getAllOrderByDate($invoice_prefix);
        if (!empty($orders)) {
            foreach ($orders as $order) {
                //$this->cart->clear();
                $get_order['allorder'][] = $order['order_id'];
                $chewc = $this->model_herbal_herbal->checkOrderExists($order['order_id']);
                if (!empty($chewc)) {
                    $get_order['chewcorder'][] = $order['order_id'];
                    $get_order['orders'][$order['order_id']] = array(
                        'order_id' => $order['order_id'],
                        'invoice_prefix' => $order['invoice_prefix'],
                        'store_id' => $order['store_id'],
                        'customer_id' => $order['customer_id'],
                        'payment_method' => $order['payment_method'],
                        'payment_code' => $order['payment_code'],
                        'shipping_address_id' => $order['shipping_address_id'],
                        'shipping_method' => $order['shipping_method'],
                        'shipping_code' => $order['shipping_code'],
                        'shipping_total' => $order['shipping_total'],
                        'date_added' => $order['date_added'],
                    );

                    $customer = $this->model_pos_pos->getCustomer($order['customer_id']);
                    if (!empty($customer)) {
                        $get_order['orders'][$order['order_id']]['customer'][$order['customer_id']] = array(
                            'customer_id' => $customer['customer_id'],
                            'firstname' => $customer['firstname'],
                            'customer_ic' => $customer['customer_ic'],
                            'customer_card' => $customer['customer_card'],
                            'validdate' => $customer['customer_validdate'],
                        );
                    } else {
                        $get_order['orders'][$order['order_id']]['customer'] = array(
                            'customer_id' => 0,
                            'firstname' => $this->language->get('walk_in_customer'),
                            'customer_ic' => '',
                            'customer_card' => '',
                            'validdate' => '',
                        );
                    }

                    $shipping = $this->model_sale_customer->getAddresses($order['customer_id']);
                    if (!empty($shipping)) {
                        $get_order['orders'][$order['order_id']]['shipping'] = $shipping;
                    } else {
                        $get_order['orders'][$order['order_id']]['shipping'] = '';
                    }

                    if (!empty($order['shipping_address_id'])) {
                        $this->session->data['shipping_address_id'] = $order['shipping_address_id'];
                        $this->session->data['shipping_address'] = $this->model_sale_customer->getAddress($order['shipping_address_id']);
                        $get_order['orders'][$order['order_id']]['shipping_address'] = $this->session->data['shipping_address'];
                    } else {
                        $get_order['orders'][$order['order_id']]['shipping_address'] = '';

                        $this->session->data['shipping_address_id'] = 0;
                    }

                    $data['shipping_methods'] = array();
                    $default_country_id = $this->config->get('config_country_id');
                    $default_zone_id = $this->config->get('config_zone_id');


                    if (!empty($order['shipping_address_id'])) {
                        $method_data = array();
                        $this->load->model('extension/extension');
                        $results = $this->model_extension_extension->getExtensions('shipping');
                        $loop = 1;
                        foreach ($results as $result) {
                            if ($this->config->get($result['code'] . '_status')) {
                                $this->load->model('shipping/' . $result['code']);

                                $quote = $this->{'model_shipping_' . $result['code']}->getQuote($shipping);
                                if ($quote) {
                                    $method_data[$result['code']] = array(
                                        'title' => $quote['title'],
                                        'quote' => $quote['quote'],
                                        'sort_order' => $quote['sort_order'],
                                        'error' => $quote['error']
                                    );
                                }
                            }
                        }
                        $sort_order = array();


                        foreach ($method_data as $key => $value) {
                            $sort_order[$key] = $value['sort_order'];
                        }

                        array_multisort($sort_order, SORT_ASC, $method_data);

                        $this->session->data['shipping_methods'] = $method_data;
                        $data['shipping_methods'] = $method_data;
                        $loop = 1;
                        foreach ($data['shipping_methods'] as $shipping_method) {

                            if ($loop == 1) {
                                foreach ($shipping_method['quote'] as $quote) {
                                    $shipping_data = explode('.', $quote['code']);
                                }
                            }
                            $loop++;
                        }
                        $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
                    }

                    if (!empty($order['shipping_code']) && $order['shipping_code'] != 'pickup.pickup') {
                        $shipping_data = explode('.', $order['shipping_code']);
                        $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
                    }

                    $add_product_to_cart_count = 0;
                    $order_products = $this->model_sale_order->getOrderCartProducts($order['order_id']);
                    if (!empty($order_products)) {
                        //$get_order['orders'][$order['order_id']]['order_products'] = $order_products;
                        foreach ($order_products as $order_product) {
                            if (isset($order_product['order_option'])) {
                                $order_option = $order_product['order_option'];
                            } elseif (isset($this->request->get['order_id'])) {
                                $order_option = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
                            } else {
                                $order_option = array();
                            }
                            $this->cart->add($order_product['product_id'], $order_product['quantity'], $order_option);
                            $add_product_to_cart_count++;
                        }
                    }

                    $get_product_from_cart_count = 0;
                    if (!empty($this->cart->getProducts())) {
                        foreach ($this->cart->getProducts() as $product) {
                            $option_data = array();

                            foreach ($product['option'] as $option) {
                                if ($option['type'] != 'file') {
                                    $value = $option['value'];
                                } else {
                                    $filename = $this->encryption->decrypt($option['value']);

                                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                                }
                                $option_data[] = array(
                                    'name' => $option['name'],
                                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                                    'type' => $option['type']
                                );
                            }
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($product['price'], $this->config->get('config_currency'));
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($sub_tax['total'] * $product['quantity'], $this->config->get('config_currency'));
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $product['quantity'], $this->config->get('config_currency'));
                            $get_order['orders'][$order['order_id']]['products'][] = array(
                                'key' => $product['key'],
                                'name' => $product['name'],
                                'code' => $product['code'],
                                'model' => $product['model'],
                                'unitprice' => $product['unitprice'],
                                'reward' => $product['reward'],
                                'points' => $product['points'],
                                'option' => $option_data,
                                'quantity' => $product['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
                            );
                            $get_product_from_cart_count++;
                        }//foreach product in cart generate html
                    }
                    //Herbal
                    //$this->cart->clearHerbal();
                    //unset($this->session->data['herbal']);
                    $add_herbal_to_cart_count = 0;
                    $order_herbals = $this->model_pos_pos->getOrderCartherbal($order['order_id']);
                    if (!empty($order_herbals)) {
                        $get_order['orders'][$order['order_id']]['order_herbals'] = $order_herbals;
                        foreach ($order_herbals as $order_herbal) {
                            $this->cart->addHerbal($order_herbal['clinical_sale_id'], 1);
                            $add_herbal_to_cart_count++;
                        }
                    }

                    $get_order['orders'][$order['order_id']]['add_herbal_to_cart_count'] = $add_herbal_to_cart_count;

                    $get_herbal_from_cart_count = 0;
                    if (!empty($this->cart->getHerbals())) {
                        foreach ($this->cart->getHerbals() as $herbale) {
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($herbale['price'], $this->config->get('config_currency'));
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($herbale['price'], $herbale['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($herbale['price'] * $herbale['quantity'], $this->config->get('config_currency'));
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $herbale['quantity'], $this->config->get('config_currency'));
                            $get_order['orders'][$order['order_id']]['herbals'][$herbale['key']] = array(
                                'key' => $herbale['key'],
                                'name' => $herbale['name'],
                                'unitprice' => $herbale['unitprice'],
                                'invoice_prefix' => $herbale['invoice_prefix'],
                                'gst' => $herbale['gst'],
                                'customer_ic' => $herbale['customer_ic'],
                                'quantity' => $herbale['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                            );
                        }//foreach product in herbls generate html
                    }
                    //Services
                    //$this->cart->clearService();
                    $add_service_to_cart_count = 0;
                    $order_services = $this->model_pos_pos->getOrderCartServices($order['order_id']);
                    if (!empty($order_services)) {
                        $get_order['orders'][$order['order_id']]['order_services'] = $order_services;
                        foreach ($order_services as $order_service) {
                            $this->cart->addService($order_service['service_form_id'], 1);
                            $add_service_to_cart_count++;
                        }
                    }
                    $get_service_from_cart_count = 0;
                    if (!empty($this->cart->getServices())) {
                        foreach ($this->cart->getServices() as $service) {
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $price = $this->currency->format($service['price'], $this->config->get('config_currency'));
                            /* } else {
                              $price = false;
                              } */
                            $sub_tax = $this->tax->calculateTax($service['price'], $service['tax_class_id'], $this->config->get('config_tax'));
                            // Display prices
                            /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                            $total = $this->currency->format($service['price'] * $service['quantity'], $this->config->get('config_currency'));
                            /* } else {
                              $total = false;
                              } */
                            //tax
                            $tax = $this->currency->format($sub_tax['tax'] * $service['quantity'], $this->config->get('config_currency'));
                            $get_order['orders'][$order['order_id']]['services'][] = array(
                                'key' => $service['key'],
                                'name' => $service['name'],
                                'unitprice' => $service['unitprice'],
                                'invoice_prefix' => $service['invoice_prefix'],
                                'gst' => $service['gst'],
                                'customer_ic' => $service['customer_ic'],
                                'quantity' => $service['quantity'],
                                'price' => $price,
                                'tax' => $tax,
                                'total' => $total,
                            );
                            $get_service_from_cart_count++;
                        }//foreach product in services generate html
                    }

                    //$this->cart->clearService();
                    //$this->cart->clearHerbal();
                    //$this->cart->clear();

                    $this->load->model('pos/extension');
                    $total_data = array();
                    $total = 0;
                    $taxes = $this->cart->getTaxes();

                    /* if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) { */
                    $sort_order = array();
                    $results = $this->model_pos_extension->getExtensions('total');
                    foreach ($results as $key => $value) {
                        $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
                    }
                    array_multisort($sort_order, SORT_ASC, $results);
                    foreach ($results as $result) {
                        if ($this->config->get($result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                            $this->load->model('pos/' . $result['code']);

                            $this->{'model_pos_' . $result['code']}->getTotal($total_data, $total, $taxes);
                        }
                        $sort_order = array();
                        foreach ($total_data as $key => $value) {
                            $sort_order[$key] = $value['sort_order'];
                        }
                        array_multisort($sort_order, SORT_ASC, $total_data);
                    }
                    //}
                    /* $get_order['orders'][$order['order_id']]['test_shipping_address_id'] = $this->session->data['shipping_address_id'];
                      $get_order['orders'][$order['order_id']]['test_shipping_address'] = $this->session->data['shipping_address']; */
                    $get_order['orders'][$order['order_id']]['total_data'] = $total_data;

                    $get_order['orders'][$order['order_id']]['total'] = $this->currency->format($total, $this->config->get('config_currency'));
                    $chwec_boolean = true;
                    $get_order['orders'][$order['order_id']]['chewc_boolean'] = $chwec_boolean;
                    $chewc_count++;

                    $this->model_herbal_herbal->updatErrorOrderTotal($get_order['orders'][$order['order_id']]);
                }
                $order_count++;
                //$this->cart->clearService();
                //$this->cart->clearHerbal();
                $this->cart->clear();
                unset($this->session->data['shipping_address']);
                unset($this->session->data['shipping_address_id']);
                unset($this->session->data['shipping_method']);
            }//order loop end
        }
        $get_order['order_count'] = $order_count;
        $get_order['chewc_count'] = $chewc_count;
    }

    public function runHerbalTotal() {
        $this->load->model('herbal/herbal');
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        $this->load->model('user/user');
        $herbals = $this->model_herbal_herbal->getErrorHerbal();
        //$test2 = array();

        $ot1_subtotal = 0;
        $ot1_tax = 0;
        $ot1_total = 0;
        $ot2_subtotal = 0;
        $ot2_tax = 0;
        $ot2_total = 0;

        $concultation_subtotal = 0;
        $concultation_tax = 0;
        $concultation_total = 0;

        $pos_subtotal = 0;
        $pos_tax = 0;
        $pos_total = 0;

        foreach ($herbals as $hid => $herbal) {
            $user_details = $this->model_user_user->getUser($herbal['doctor_id']);
            if ($herbal['collect_consultation_price'] == 1) {
                $doctor_taxes = $this->tax->calculateTax($herbal['clinicalsale_concultation'], $user_details['tax_class_id']);
                $concultation_subtotal = $doctor_taxes['net_amount'];
                $concultation_tax = $doctor_taxes['tax'];
                $concultation_total = $doctor_taxes['total'];
            }

            $test[$herbal['clinical_sale_id']] = array(
                'clinical_sale_id' => $herbal['clinical_sale_id'],
                'invoice_prefix' => $herbal['invoice_prefix'],
                'collect_consultation_price' => $herbal['collect_consultation_price'],
                'clinicalsale_concultation' => $herbal['clinicalsale_concultation'],
                'doctor_id' => $herbal['doctor_id'],
                'tax_class_id' => $user_details['tax_class_id'],
                'sales_date' => $herbal['sales_date'],
                'concultation_subtotal' => $concultation_subtotal,
                'concultation_tax' => $concultation_tax,
                'concultation_total' => $concultation_total,
            );

            $cs_subtotal = 0;
            $cs_tax = 0;
            $cs_total = 0;
            $cs_rounding = 0;
            $herbal_totals = $this->model_herbal_herbal->getErrorHerbalTotal($herbal['clinical_sale_id']);
            foreach ($herbal_totals as $herbal_total) {
                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'sub_total') {
                    $cs_subtotal = $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'tax') {
                    $cs_tax += $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'total') {
                    $cs_total = $herbal_total['value'];
                }

                if ($herbal_total['id'] == 1 && $herbal_total['code'] == 'rounding') {
                    $cs_rounding = $herbal_total['value'];
                }

                $test[$herbal['clinical_sale_id']]['cs_subtotal'] = $cs_subtotal;
                $test[$herbal['clinical_sale_id']]['cs_tax'] = $cs_tax;
                $test[$herbal['clinical_sale_id']]['cs_total'] = $cs_total;
                $test[$herbal['clinical_sale_id']]['cs_rounding'] = $cs_rounding;

                $test[$herbal['clinical_sale_id']]['clinicalsale_total'][$herbal_total['id']][$herbal_total['clinical_sale_total_id']] = array(
                    'clinical_sale_total_id' => $herbal_total['clinical_sale_total_id'],
                    'clinical_sale_id' => $herbal_total['clinical_sale_id'],
                    'id' => $herbal_total['id'],
                    'code' => $herbal_total['code'],
                    'tax_key' => $herbal_total['tax_key'],
                    'tax_code' => $herbal_total['tax_code'],
                    'title' => $herbal_total['title'],
                    'value' => $herbal_total['value'],
                    'sort_order' => $herbal_total['sort_order'],
                );
            }

            $pos_subtotal = $concultation_subtotal + $cs_subtotal;
            $pos_tax = $concultation_tax + $cs_tax /* + $cs_rounding */;
            $pos_total = $concultation_total + $cs_total;

            $test[$herbal['clinical_sale_id']]['pos_subtotal'] = $pos_subtotal;
            $test[$herbal['clinical_sale_id']]['pos_tax'] = $pos_tax;
            $test[$herbal['clinical_sale_id']]['pos_total'] = $pos_total;
            $test[$herbal['clinical_sale_id']]['final_total'] = $cs_total + $pos_total;

            $final_total = $cs_total + $pos_total;

            $data = array(
                'clinical_sale_id' => $herbal['clinical_sale_id'],
                'd_net_amount' => $pos_subtotal,
                'd_gst' => $pos_tax,
                'total_d_gst' => $pos_total,
                'total' => $final_total,
            );

            $this->model_herbal_herbal->updateErrorHerbal($data);

            $herbal_totals2 = $this->model_herbal_herbal->getErrorHerbalTotal($herbal['clinical_sale_id']);
            if (!empty($herbal_totals2)) {
                foreach ($herbal_totals2 as $hid => $herbal_total2) {
                    if ($herbal_total2['id'] == 2) {
                        if ($herbal['clinical_sale_id'] == $herbal_total2['clinical_sale_id']) {
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['clinical_sale_total_id'] = $herbal_total2['clinical_sale_total_id'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['clinical_sale_id'] = $herbal_total2['clinical_sale_id'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['code'] = $herbal_total2['code'];
                            $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['id'] = $herbal_total2['id'];
                            if ($herbal_total2['code'] == 'sub_total') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_subtotal;
                            }
                            if ($herbal_total2['code'] == 'tax') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_tax;
                            }
                            if ($herbal_total2['code'] == 'total') {
                                $get[$herbal['clinical_sale_id']]['order_totals'][$herbal_total2['clinical_sale_total_id']]['value'] = $pos_total;
                            }
                        }

                        $this->model_herbal_herbal->updateErrorHerbalTotal($get[$herbal['clinical_sale_id']]);
                    }
                }
            }
        }
    }

    public function DateModify() {

        $this->load->language('herbal/herbal');
        $this->load->model('herbal/herbal');

        $json = array();

        $json['error_code'] = array(
            'error' => 0,
            'msj' => 'Succes',
        );

        $date_modified = $this->model_herbal_herbal->getHerbalDateModified($this->request->get['herbal_id']);

        if ($this->session->data['date_modified'] < $date_modified) {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => $this->language->get('update_error'),
            );
        }
        $this->response->setOutput(json_encode($json));
    }

    public function delete() {
        $this->load->language('herbal/herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/herbal');
        $this->load->model('sale/order');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $herbal_id)
                $this->model_herbal_herbal->deleteHerbal($herbal_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        //getList
        $this->getList();
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'herbal/herbal') && !$this->user->userpermission('delete', 'herbal/herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($result['code'] != 'credit') {
                if ($this->config->get('total_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        return $totals;
    }

    public function getPrescription() {
        $data = array();
        $data['prescription'] = array();
        $data['products'] = array();
        foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription['key'],
                'name' => $prescription['name'],
                'id' => $prescription['id'],
                'discount' => $prescription['discount']
            );

            if (isset($this->session->data['product'][$prescription_id])) {
                foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                    $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];
                    $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                    $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
                    $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
                    $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));


                    $data['products'][$prescription_id][] = array(
                        'product_id' => $products['product_id'],
                        'name' => $products['name'],
                        'code' => $products['code'],
                        'quantity' => $products['quantity'],
                        'times' => $products['times'],
                        'cook' => $products['cook'],
                        'taketype' => $products['taketype'],
                        'stock' => $products['stock'],
                        'day' => $products['day'],
                        'price' => $products['price'],
                        'discount' => $products['discount'],
                        'subtotal' => $subtotal,
                        'total' => $total,
                        'tax' => $tax,
                        'tax_class_id' => $products['tax_class_id'],
                        'weight' => $products['weight'],
                        'weight_class_id' => $products['weight_class_id'],
                        'weight_format' => $products['weight']
                    );
                }//end products
            }
        }

        return $data;
    }

    public function getService() {
        $data = array();
        $data['service'] = array();

        foreach ($this->cart->getService() as $key => $service) {

            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
            $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));

            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }

        return $data;
    }

    public function getAcupunctureList() {
        $data = array();
        $data['acupuncture_list'] = array();

        foreach ($this->cart->getAcupunctureList() as $key => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {

                if ($acupuncture['acupuncture_id'] > 0) {
                    $acupuncture_name = $this->model_herbal_herbal->getAcupunctureNameById($acupuncture['acupuncture_id']);
                } else {
                    $acupuncture_name = '';
                }

                $data['acupuncture_list'][$key][] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        return $data;
    }

    public function getImages() {

        $this->load->model('herbal/herbal');

        $data['herbal_image'] = $this->model_herbal_herbal->getImage($this->request->post['herbal_id']);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data['herbal_image']));
    }

    public function printA5() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('herbal/herbal');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['direction'] = $this->language->get('direction');
        $data['lang'] = $this->language->get('code');

        $herbal_id = $this->request->get['herbal_id'];

        $basic_data = $this->model_herbal_herbal->getHerbalRemediesBasicData($herbal_id);

        $data['customer_name'] = $basic_data['customer_name'];
        $data['customer_ic'] = $basic_data['customer_ic'];
        $data['invoice_prefix'] = $basic_data['invoice_prefix'];
        $data['date_added'] = date($this->language->get('date_format_short'), strtotime($basic_data['date_added']));
        $data['doctor_name'] = $basic_data['doctor_name'];
        $data['telephone'] = $basic_data['telephone'];

        $data['diagnostic'] = $basic_data['diagnostic'];
        $data['doctoradvice'] = $basic_data['doctoradvice'];
        $data['pulse'] = $basic_data['pulse'];
        $data['disease'] = $basic_data['disease'];
        $data['treatment'] = $basic_data['treatment'];
        $data['acupuncture'] = $basic_data['acupuncture'];
        $data['symptom'] = $basic_data['symptom'];

        $data['times'] = $basic_data['times'];
        $data['day'] = $basic_data['day'];
        $data['cook'] = $basic_data['cook'];
        $data['taketype'] = $basic_data['taketype'];

        if ($basic_data['gender'] == '1') {
            $data['gender'] = $this->language->get('text_male');
        } else {
            $data['gender'] = $this->language->get('text_female');
        }

        $data['current_language'] = $this->session->data['language'];

        $herbal_remedies = $this->model_herbal_herbal->getHerbalPrescription($herbal_id);

        $data['remedies'] = array();
        $data['products'] = array();
        $data['totals'] = array();

        foreach ($herbal_remedies as $prescription_id => $prescription) {
            $data['remedies'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $data['products'][$prescription_id][] = array(
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'weight' => round($products['quantity'] * $products['weight']) . 'g'
                );
            }
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        $herbal_remedies_image = $this->model_herbal_herbal->getHerbalRemediesImage($herbal_id);

        foreach ($herbal_remedies_image as $image) {
            $data['image_show'][] = array(
                'folder' => $image['folder'],
                'image' => HTTPS_HERBAL_IMAGE . $image['image']
            );
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;

            $this->response->setOutput($pdf->pdf($this->load->view('herbal/herbal_remedies_pdf', $data), $pdf_file_name, $page_size, $show));
        }


        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser" )) {
            $this->response->setOutput($this->load->view('herbal/herbal_remedies_pdf', $data));
        }
    }

    public function changeCustomer() {
        $this->load->language('herbal/herbal');
        $this->load->model('herbal/herbal');

        $this->document->setTitle($this->language->get('text_change_customer'));

        $data['herbal_id'] = $this->request->get['herbal_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateChangeCustomer()) {
            //update customer id into cs table
            $this->model_herbal_herbal->updateCustomer($data['herbal_id'], $this->request->post['customer_id']);

            $this->response->redirect($this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $data['herbal_id'], true));
        }

        $herbal_data = $this->model_herbal_herbal->getHerbal($data['herbal_id']);

        if (($herbal_data['clinicalsale_action'] == '5') && (!empty($herbal_data['order_invoice_prefix']))) {
            $this->response->redirect($this->url->link('herbal/herbal', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['text_form'] = $this->language->get('text_change_customer');

        $data['entry_invoice_prefix'] = $this->language->get('entry_invoiceprefix');
        $data['entry_customer_name'] = $this->language->get('column_name');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true)
        ); //breadcrumbs

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($herbal_data)) {
            $data['invoice_prefix'] = $herbal_data['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = '';
        }

        if (isset($this->request->post['customer_name'])) {
            $data['customer_name'] = $this->request->post['customer_name'];
        } else {
            $data['customer_name'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        $data['cancel'] = $this->url->link('herbal/herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);
        $data['action'] = $this->url->link('herbal/herbal/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/change_customer_form', $data));
    }

    public function customer_list() {
        $this->load->language('herbal/herbal');
        $this->load->model('herbal/herbal');

        if (isset($this->request->get['customer_name'])) {
            $customer_name = $this->request->get['customer_name'];
        } else {
            $customer_name = NULL;
        }

        if (isset($this->request->get['customer_ic'])) {
            $customer_ic = $this->request->get['customer_ic'];
        } else {
            $customer_ic = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['customer_name'])) {
            $url .= '&customer_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_ic'])) {
            $url .= '&customer_ic=' . urlencode(html_entity_decode($this->request->get['customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['customers'] = array();

        $filter_data = array(
            'customer_name' => $customer_name,
            'customer_ic' => $customer_ic,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_herbal_herbal->getTotalCustomers($filter_data);
        $results = $this->model_herbal_herbal->getCustomers($filter_data);

        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card']
            );
        }

        $data['text_list'] = $this->language->get('text_customer_list');

        $data['entry_customer_name'] = $this->language->get('column_name');
        $data['entry_customer_ic'] = $this->language->get('entry_customer_ic');

        $data['column_customer_name'] = $this->language->get('column_name');
        $data['column_customer_ic'] = $this->language->get('entry_customer_ic');
        $data['column_customer_card'] = $this->language->get('entry_customer_card');

        $data['button_filter'] = $this->language->get('button_filter');

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        ;
        $pagination->url = $this->url->link('herbal/herbal/customer_list', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['customer_name'] = $customer_name;
        $data['customer_ic'] = $customer_ic;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/customer_name_list', $data));
    }

    public function findCustomer() {
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $json = array();

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json = $this->model_herbal_herbal->getCustomerByIC($data);

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Customer Details";
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function getPatientPrescription() {
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $json = array();

        $herbal_id = $this->request->get['herbal_id'];

        $herbal_details = $this->model_herbal_herbal->getPatientPrescription($herbal_id);

        $json['entry_product_name'] = $this->language->get('entry_productname');
        $json['entry_product_code'] = $this->language->get('entry_productcode');
        $json['entry_quantity'] = $this->language->get('entry_unit');
        $json['entry_times'] = $this->language->get('entry_times');
        $json['entry_day'] = $this->language->get('entry_perday');
        $json['text_no_prescription'] = $this->language->get('text_no_prescription');
        $json['prescriptions'] = $herbal_details;

        return $this->response->setOutput(json_encode($json));
    }

    protected function validateChangeCustomer() {
        if (!$this->user->hasPermission('modify', 'herbal/herbal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {
            $this->error['warning'] = $this->language->get('error_select_customer');
        }

        return !$this->error;
    }

    private function calculateAge($dob) {
        $date_of_birth = date('m/d/Y', strtotime($dob));

        $birthDate = explode("/", $date_of_birth);

        $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

        return $age;
    }

    public function print_array($array) {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }

}

?>