<?php

class ControllerHerbalDispense extends Controller
{
    private $error = [];

    public function index()
    {
        $this->load->language('herbal/herbal');
        $this->load->language('herbal/new_herbal');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');
        $this->load->model('sale/order');

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->getList();
    }

    public function getList()
    {
        $this->load->language('herbal/new_herbal');

        $this->document->addStyle('view/stylesheet/new_herbal_list.css?v=' . time());

        date_default_timezone_set("Asia/Kuala_Lumpur");
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = null;
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = null;
        }

        $language = $this->session->data['language'];

        if ($language == 'en-gb') {
            $data['date_types'][] = [
                'text' => 'All',
                'value' => 'all'
            ];
            $data['date_types'][] = [
                'text' => 'Today',
                'value' => 'today'
            ];
            $data['date_types'][] = [
                'text' => 'Week',
                'value' => 'week'
            ];
            $data['date_types'][] = [
                'text' => 'Month',
                'value' => 'month'
            ];
            $data['date_types'][] = [
                'text' => 'Year',
                'value' => 'year'
            ];
            $data['date_types'][] = [
                'text' => 'Set By Date',
                'value' => 'set_by_date'
            ];
        } elseif ($language == 'cn') {
            $data['date_types'][] = [
                'text' => '所有',
                'value' => 'all'
            ];
            $data['date_types'][] = [
                'text' => '今天',
                'value' => 'today'
            ];
            $data['date_types'][] = [
                'text' => '星期',
                'value' => 'week'
            ];
            $data['date_types'][] = [
                'text' => '月',
                'value' => 'month'
            ];
            $data['date_types'][] = [
                'text' => '年',
                'value' => 'year'
            ];
            $data['date_types'][] = [
                'text' => '按日期设置',
                'value' => 'set_by_date'
            ];
        }

        if (!empty($this->request->get['filter_customer_search'])) {
            $filter_date_from = null;
            $filter_date_to = null;
            $filter_date_type = 'all';
            $this->request->get['filter_date_to'] = null;
            $this->request->get['filter_date_from'] = null;
            $this->request->get['filter_customer_search'] = null;
        }


        $date_now = date('Y-m-d');
        $config_date_type = 'today';
        $filter_date_type = isset($this->request->get['filter_date_type']) ? ($this->request->get['filter_date_type']) : $config_date_type;
        $data['selected_date_type'] = $filter_date_type;

        switch ($filter_date_type) {
            case 'today':
                $filter_date_from = date('Y-m-d');
                $filter_date_to = date('Y-m-d');
                break;
            case 'week':
                $filter_date_from = date('Y-m-d', strtotime('this week'));
                $filter_date_to = date('Y-m-d', strtotime('+ 6 days ', strtotime($filter_date_from)));
                break;
            case 'month':
                $filter_date_from = date('Y-m-01', strtotime($date_now));
                $filter_date_to = date('Y-m-t');
                break;
            case 'year':
                $filter_date_from = date('Y-m-d', strtotime('first day of january this year'));
                $filter_date_to = date('Y-m-d', strtotime('last day of december this year'));
                break;
            case 'all':
                $filter_date_from = null;
                $filter_date_to = null;
                break;
            case 'set_by_date':
                $filter_date_from = $filter_date_from;
                $filter_date_to = $filter_date_to;
                break;
            default:
                $filter_date_from = $filter_date_from;
                $filter_date_to = $filter_date_to;
        }

        $this->request->get['filter_date_from'] = $filter_date_from;
        $this->request->get['filter_date_to'] = $filter_date_to;

        if (isset($this->request->get['filter_transaction_from'])) {
            $filter_transaction_from = $this->request->get['filter_transaction_from'];
        } else {
            $filter_transaction_from = null;
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $filter_transaction_to = $this->request->get['filter_transaction_to'];
        } else {
            $filter_transaction_to = null;
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = null;
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = null;
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $filter_customer_search = $this->request->get['filter_customer_search'];
        } else {
            $filter_customer_search = null;
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $filter_customer_firstname = $this->request->get['filter_customer_firstname'];
        } else {
            $filter_customer_firstname = null;
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $filter_customer_lastname = $this->request->get['filter_customer_lastname'];
        } else {
            $filter_customer_lastname = null;
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = '5';
        } else {
            $filter_payment_status = '5';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = 5;
        } else {
            $filter_status = 5;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = null;
        }

        if (isset($this->request->get['filter_occupation'])) {
            $filter_occupation = $this->request->get['filter_occupation'];
        } else {
            $filter_occupation = null;
        }

        if (isset($this->request->get['filter_prescription'])) {
            $filter_prescription = $this->request->get['filter_prescription'];
        } else {
            $filter_prescription = null;
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $filter_diagnostic = $this->request->get['filter_diagnostic'];
        } else {
            $filter_diagnostic = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_address'])) {
            $filter_address = $this->request->get['filter_address'];
        } else {
            $filter_address = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'sales_date ,invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = null;
        }

        if (isset($this->request->get['filter_service_type'])) {
            $filter_service_type = $this->request->get['filter_service_type'];
        } else {
            $filter_service_type = null;
        }

        $url = '';

        if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_service_type'])) {
            $url .= '&filter_service_type=' . $this->request->get['filter_service_type'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $data['add'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['delete'] = $this->url->link('herbal/new_herbal/delete', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

        $data['herbals'] = array();

        $filter_data = array(
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_transaction_from' => $filter_transaction_from,
            'filter_transaction_to' => $filter_transaction_to,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_occupation' => $filter_occupation,
            'filter_diagnostic' => $filter_diagnostic,
            'filter_prescription' => $filter_prescription,
            'filter_telephone' => $filter_telephone,
            'filter_address' => $filter_address,
            'filter_customer_lastname' => $filter_customer_lastname,
            'filter_customer_card' => $filter_customer_card,
            'filter_customer_firstname' => $filter_customer_firstname,
            'filter_payment_status' => $filter_payment_status,
            'filter_status' => $filter_status,
            'filter_customer_search' => $filter_customer_search,
            'filter_doctor' => $filter_doctor,
            'filter_gender' => $filter_gender,
            'filter_service_type' => $filter_service_type,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $herbal_total = $this->model_herbal_new_herbal->getTotalHerbal($filter_data);

        $results = $this->model_herbal_new_herbal->getHerbals($filter_data);

        foreach ($results as $result) {
            if ($result['collect_consultation_price'] > 0) {
                $consultation_price = $result['clinicalsale_concultation'] * 1; //$this->model_sale_order->getHerbalTotal($result['clinical_sale_id']);
            } else {
                $consultation_price = $result['clinicalsale_concultation'] + $result['d_gst'];
            }

            $herbal_service_total = $this->model_herbal_new_herbal->getHerbalServiceTotal($result['clinical_sale_id']);

            $date_of_birth = date('m/d/Y', strtotime($result['dob']));
            $birthDate = explode("/", $date_of_birth);
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

            switch ($result['herb_service_type']) {
                case 'herbs':
                    $result['herb_service_type'] = $this->language->get('text_herbs');
                    break;
                case 'brewing':
                    $result['herb_service_type'] = $this->language->get('text_brewing');
                    break;
                case 'granule':
                    $result['herb_service_type'] = $this->language->get('text_granule');
                    break;
                default:
            }

            $data['herbals'][] = array(
                'clinical_sale_id' => $result['clinical_sale_id'],
                'sales_date' => $result['sales_date'],
                'sales_time' => date('h:i A', strtotime($result['date_added'])),
                'invoice_prefix' => $result['invoice_prefix'],
                'telephone' => $result['telephone'],
                'firstname' => $result['firstname'] . ' ' . $result['lastname'],
                'customer_id' => $result['customer_id'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'status' => $result['status'],
                'top' => $result['tick_top'],
                'occupation' => $result['occupation'],
                'telephone' => $result['telephone'],
                'diagnostic' => substr($result['diagnostic_text'], 0, -1),
                //'prescription_list' => $result['prescription_name'],
                //'prescription_product_list' => $result['prescription_product_name'],
                'herb_service_type' => $result['herb_service_type'],
                'order_status' => $result['order_status'],
                'order_action' => $result['order_action'],
                'order_id' => $result['order_id'],
                'clinicalsale_action' => $result['clinicalsale_action'],
                'clinicalsale_total' => $result['clinicalsale_total'],
                'consultation_price' => sprintf('%.2f', $consultation_price),
                'service_total' => number_format($herbal_service_total, 2),
                'total_d_gst' => sprintf('%.2f', $consultation_price + $herbal_service_total + $result['clinicalsale_total']),
                'cs_type' => $result['herb_service_type'],
                // 'service_total' => number_format($herbal_service_total, 2),
                // 'total_d_gst' => sprintf('%.2f', $result['total_d_gst'] + $herbal_service_total),
                'create_new' => $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, 'SSL'),
                'edit' => $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . '&condition=waiting' . $url, 'SSL'),
                'pos' => $this->url->link('pos/pos', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'], 'SSL'),
                'info' => $this->url->link('herbal/new_herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url, 'SSL'),
                'print_prescription_sticker' => $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $result['clinical_sale_id'] . $url . '&pdf=1', 'SSL'),
                'age' => $age,
                'gender' => $result['gender'],
                'date_modified' => date('Y-m-d h:i A', strtotime($result['date_modified'])),
                'date_added' => date('Y-m-d h:i A', strtotime($result['date_added']))
            );
        }

        $data['add_new'] = $this->url->link('herbal/new_herbal/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['export_excel'] = $this->url->link('herbal/new_herbal/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['refresh_medical_record'] = 'index.php?route=herbal/new_herbal/getList2&user_token=' . $this->session->data['user_token'] . $url;

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_lastname'])) {
            $url .= '&filter_customer_lastname=' . urlencode(html_entity_decode($this->request->get['filter_customer_lastname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_address'])) {
            $url .= '&filter_address=' . urlencode(html_entity_decode($this->request->get['filter_address'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_occupation'])) {
            $url .= '&filter_occupation=' . urlencode(html_entity_decode($this->request->get['filter_occupation'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.sales_date' . $url, 'SSL');
        $data['sort_invoice_prefix'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=cs.invoice_prefix' . $url, 'SSL');
        $data['sort_firstname'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.firstname' . $url, 'SSL');
        $data['sort_customer_ic'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_ic' . $url, 'SSL');
        $data['sort_customer_card'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.customer_card' . $url, 'SSL');
        $data['sort_telephone'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . '&sort=c.telephone' . $url, 'SSL');

        $url = '';

        if (isset($filter_date_type)) {
            $url .= '&filter_date_type=' . $filter_date_type;
        }

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_search'])) {
            $url .= '&filter_customer_search=' . urlencode(html_entity_decode($this->request->get['filter_customer_search'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_diagnostic'])) {
            $url .= '&filter_diagnostic=' . urlencode(html_entity_decode($this->request->get['filter_diagnostic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_prescription'])) {
            $url .= '&filter_prescription=' . urlencode(html_entity_decode($this->request->get['filter_prescription'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $herbal_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($herbal_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($herbal_total - $this->config->get('config_limit_admin'))) ? $herbal_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $herbal_total, ceil($herbal_total / $this->config->get('config_limit_admin')));

        $data['filter_date_type'] = $filter_date_type;
        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_transaction_from'] = $filter_transaction_from;
        $data['filter_transaction_to'] = $filter_transaction_to;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_customer_firstname'] = $filter_customer_firstname;
        $data['filter_payment_status'] = $filter_payment_status;
        $data['filter_status'] = $filter_status;
        $data['filter_doctor'] = $filter_doctor;
        $data['filter_customer_lastname'] = $filter_customer_lastname;
        $data['filter_occupation'] = $filter_occupation;
        $data['filter_address'] = $filter_address;
        $data['filter_prescription'] = $filter_prescription;
        $data['filter_diagnostic'] = $filter_diagnostic;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer_search'] = $filter_customer_search;
        $data['filter_gender'] = $filter_gender;
        $data['filter_service_type'] = $filter_service_type;

        $data['print_prescription'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_dispensing_list'] = $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');
        $data['print_medical_cert'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', 'SSL');

        $data['customer_id'] = null;
        $data['herbal_single'] = array();

        if (!empty($this->request->get['customer_id'])) {
            $data['customer_id'] = $this->request->get['customer_id'];
        }
        if ($data['customer_id'] != '') {
            $herbal_single_results = $this->model_herbal_new_herbal->getCustomerbyid($data['customer_id']);

            $data['herbal_single'] = $herbal_single_results;
        }

        $this->load->model('localisation/order_status');

        $order_status_list = array(7, 5, 1, 18);

        foreach ($order_status_list as $order_status) {
            $order_status_data = $this->model_localisation_order_status->getOrderStatus($order_status);

            $data['cs_order_statuses'][] = array(
                'order_status_id' => $order_status_data['order_status_id'],
                'name' => $order_status_data['name']
            );
        }

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['doctors'] = $this->model_herbal_new_herbal->getDoctors();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/dispense_list', $data));
    }

    protected function printData($data)
    {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
    }

    public function getInfo()
    {
        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['acupuncture_list']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->document->addStyle('view/stylesheet/new_herbal_info.css?v=' . time());

        $this->load->language('herbal/new_herbal');
        $this->document->addStyle('view/javascript/magnific/magnific-popup.css');
        $this->document->addScript('view/javascript/magnific/jquery.magnific-popup.min.js');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/new_herbal');

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('herbal_cart'); //
        $this->cart = new herbal_cart($this->registry);

        $this->load->library('weight');
        $this->weight = new Weight($this->registry);

        $this->load->library('currency'); //
        $this->currency = new currency($this->registry);

        $data['heading_title'] = $this->language->get('heading_title');

        $data['button_print_sticker'] = $this->language->get('button_print_sticker');

        $data['user_token'] = $this->session->data['user_token'];
        $data['error_warning'] = '';
        $data['product_exit'] = '';

        if (isset($this->request->get['herbal_id'])) {
            $data['herbal_id'] = $this->request->get['herbal_id'];
        } else {
            $data['herbal_id'] = 0;
        }

        $herbal_id_info = '';
        $herbal_prescription = '';
        $herbal_peroduct = '';
        $herbal_totals = '';
        $data['total_data'] = '';
        $data['user_id'] = (int) $this->session->data['user_id'];

        $this->load->model('user/user');
        $user_details = $this->model_user_user->getUser((int) $this->session->data['user_id']);

        $data['user_price'] = $user_details['consultationprice'];

        if (isset($this->request->get['herbal_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $herbal_id_info = $this->model_herbal_new_herbal->getHerbal($this->request->get['herbal_id']);
            $herbal_prescription = $this->model_herbal_new_herbal->getHerbalPrescription($this->request->get['herbal_id']);
            $herbal_totals = $this->model_herbal_new_herbal->getHerbalTotals($this->request->get['herbal_id']);
            $herbal_service = $this->model_herbal_new_herbal->getHerbalService($this->request->get['herbal_id']);
            $herbal_image = $this->model_herbal_new_herbal->getImage($this->request->get['herbal_id']);
            $data['herbal_pass_images'] = $this->model_herbal_new_herbal->getHerbalImages($herbal_id_info['customer_id'], $this->request->get['herbal_id']);
            $herbal_service_acupuncture = $this->model_herbal_new_herbal->getHerbalServiceAcupuncture($this->request->get['herbal_id']);
        }

        $this->load->model('sale/customer');
        if ($herbal_id_info) {

            $data['username'] = $herbal_id_info['doctor_firstname'] . ' ' . $herbal_id_info['doctor_lastname'];
            $data['invoice_prefix'] = $herbal_id_info['invoice_prefix'];
            $data['customer_card'] = $herbal_id_info['customer_card'];
            $data['customer_ic'] = $herbal_id_info['customer_ic'];
            $data['customer_id'] = $herbal_id_info['customer_id'];
            $data['customer_name'] = $herbal_id_info['firstname'] . ' ' . $herbal_id_info['lastname'];
            $data['gender'] = $herbal_id_info['gender'];
            $data['email'] = $herbal_id_info['email'];
            $data['dob'] = $herbal_id_info['dob'];
            $data['telephone'] = $herbal_id_info['telephone'];
            $data['telephone2'] = $herbal_id_info['telephone2'];
            $data['home'] = $herbal_id_info['home'];
            $data['fax'] = $herbal_id_info['fax'];
            $data['status'] = $herbal_id_info['clinicalsale_action'];
            $data['age'] = $this->calculateAge($herbal_id_info['dob']);

            $data['diagnostic'] = $herbal_id_info['diagnostic'];
            $data['doctoradvice'] = $herbal_id_info['doctoradvice'];
            $data['pulse'] = $herbal_id_info['pulse'];
            $data['disease'] = $herbal_id_info['disease'];
            $data['treatment'] = $herbal_id_info['treatment'];
            $data['acupuncture'] = $herbal_id_info['acupuncture'];
            $data['symptom'] = $herbal_id_info['symptom'];
            $data['order_action'] = !empty($herbal_id_info['order_action']) ? $herbal_id_info['order_action'] : 0;

            $this->load->model('localisation/order_status');
            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                } //loop services
            } //end services

            if ($herbal_service_acupuncture) {
                foreach ($herbal_service_acupuncture as $clinicalservice_id => $acupuncture_list) {
                    if (!empty($acupuncture_list)) {
                        foreach ($acupuncture_list as $acupuncture) {
                            $this->cart->setAcupunctureList($clinicalservice_id, $acupuncture['acupuncture_id'], $acupuncture['num_of_acupuncture']);
                        }
                    }
                }
            }

            if ($herbal_image) {
                foreach ($herbal_image as $image) {
                    $key = rand();
                    $this->cart->addImages($key, $image['category_id'], $image['folder'], $image['remark'], $image['image']);
                } //loop image
            } //end image

            if ($herbal_totals) {
                foreach ($herbal_totals as $total) {
                    $data['total_data'][] = array(
                        'id' => $total['id'],
                        'code' => $total['code'],
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value']),
                        'value' => $total['value'],
                    );
                } //end looptotals
            } //end totaldata

            if ($herbal_id_info['order_action'] == '17') {
                $data['enable_edit'] = true;
            } else {
                $data['enable_edit'] = false;
            }
        } else {
            $data['error_warning'] = $this->language->get('error_curupted');
        }


        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        } //url


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        ); //breadcrumbs
        //html products
        $data['prescription'] = array();
        $data['products'] = array();
        $data['service'] = array();
        $data['images'] = array();
        $data['total_weight'] = array();

        $total_weight = 0;
        $grand_total_weight = 0;

        foreach ($herbal_prescription as $prescription_id => $prescription) {
            $data['prescription'][$prescription_id] = array(
                'key' => $prescription_id,
                'name' => $prescription['name'],
                'id' => $prescription['prescription_id'],
                'discount' => 0
            );

            $herbal_peroduct = $this->model_herbal_new_herbal->getHerbalInfoProduct($prescription['clinical_sale_prescription_id']);

            foreach ($herbal_peroduct as $product_id => $products) {
                $total = $this->currency->format($products['rowtotal']);
                $tax = $this->currency->format($products['t_gst']);
                $subtotal = $this->currency->format($products['t_net_price']);

                $quantity = $products['quantity'];
                $times = $products['times'];
                $weight = $quantity * $times;

                $total_weight += $quantity;
                $grand_total_weight += $weight;

                if ($products['weight_class_id']) {
                    $total_weight_format = $this->weight->format($total_weight, $products['weight_class_id']);

                    $grand_total_weight_format = $this->weight->format($grand_total_weight, $products['weight_class_id']);
                }

                $data['total_weight'] = array(
                    array(
                        'total_weight_name' => 'Total Weight',
                        'total_weight' => $total_weight_format
                    ),
                    array(
                        'total_weight_name' => 'Grand Total Weight',
                        'total_weight' => $grand_total_weight_format
                    )
                );

                $data['products'][$prescription_id][] = array(
                    'product_id' => $products['product_id'],
                    'name' => $products['name'],
                    'code' => $products['code'],
                    'quantity' => $products['quantity'],
                    'times' => $products['times'],
                    'cook' => $products['cook'],
                    'taketype' => $products['taketype'],
                    'day' => $products['day'],
                    'price' => $products['product_price'],
                    'discount' => $products['discount'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'tax' => $tax,
                    'tax_class_id' => $products['tax_class_id'],
                    'weight' => $products['weight'],
                    'weight_class_id' => $products['weight_class_id'],
                    'weight_format' => $weight
                );
            } //end products
        } //send prescription

        /* echo '<pre>';
          print_r($herbal_peroduct);
          echo '</pre>'; */

        foreach ($this->cart->getService() as $key => $service) {
            $total = $this->currency->format($this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax')));

            //tax
            $b = $this->tax->calculate($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $tax = $this->currency->format($b - $service['total']);
            $subtotal = $this->currency->format($service['total']);


            $data['service'][$key] = array(
                'service_id' => $key,
                'staff_id' => $service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'],
                'price' => $service['price'],
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        } //end service
        // acupuncture list
        foreach ($this->cart->getAcupunctureList() as $clinicalservice_id => $acupuncture_list) {
            foreach ($acupuncture_list as $acupuncture) {
                $acupuncture_id = $acupuncture['acupuncture_id'];

                $acupuncture_name = $this->model_herbal_new_herbal->getAcupunctureNameById($acupuncture_id);

                $data['acupuncture_list'][$clinicalservice_id][] = array(
                    'acupuncture_id' => $acupuncture_id,
                    'acupuncture_name' => $acupuncture_name,
                    'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                );
            }
        }

        foreach ($this->cart->getImages() as $key => $image) {
            $data['images'][$key] = array(
                'category_id' => $image['category_id'],
                'name' => $image['name'],
                'remark' => $image['remark'],
                'path' => HTTPS_HERBAL_IMAGE . $image['path']
            );
        } //images
        // image for button and pdf
        $herbal_remedies_image = $this->model_herbal_new_herbal->getHerbalRemediesImage($data['herbal_id']);

        if (!empty($herbal_remedies_image)) {
            $data['available_image'] = '1';
        } else {
            $data['available_image'] = '0';
        }

        $data['action'] = $this->url->link('herbal/herbal/addOrder', 'user_token=' . $this->session->data['user_token'] . $url . '&herbal_id=' . $this->request->get['herbal_id'], 'SSL');

        $data['cancel'] = $this->url->link('herbal/new_herbal', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
        $data['edit_url'] = $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'], 'SSL');
        $data['print_prescription_sticker'] = $this->url->link('herbal/new_herbal/printPrescriptionSticker', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', 'SSL');
        $data['url_image'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1&image=1', 'SSL');
        $data['url_image_no'] = $this->url->link('herbal/new_herbal/printA5', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', 'SSL');
        $data['print_mc'] = $this->url->link('herbal/new_herbal/medicalCert', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $this->request->get['herbal_id'] . '&pdf=1', 'SSL');

        $data['image_link'] = $this->url->link('herbal/herbal/addImages', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('herbal/new_herbal_info', $data));
    }
}
