<?php
class ControllerExtensionTotalGiftTeaser extends Controller {
 	private $moduleName;
	private $moduleTotal2;
  private $modulePath;
	private $totalPath2;
	private $moduleVersion;
  private $extensionsLink;
	private $totalLink;
  private $error = array(); 
  private $data = array();

  public function __construct($registry) {
    parent::__construct($registry);
          
    // Config Loader
    $this->config->load('isenselabs/giftteaser');
    
    // Module Constants
    $this->moduleName         = $this->config->get('giftteaser_name');
    $this->moduleTotal2      	= $this->config->get('giftteaser_total2');
    $this->modulePath         = $this->config->get('giftteaser_path');
		$this->totalPath2         = $this->config->get('giftteaser_total_path2');
    $this->moduleVersion      = $this->config->get('giftteaser_version');   
		$this->moduleData_module  = $this->config->get('giftteaser_module_data');        

    $this->totalLink        = $this->url->link($this->config->get('giftteaser_link'), '&user_token=' . $this->session->data['user_token']. $this->config->get('giftteaser_total_link_params'), 'SSL');

    // Load Language
    $this->load->language($this->totalPath2);

    // Global Variables      
    $this->data['moduleName']  		   = $this->moduleName;
		$this->data['moduleNameSmall']   = $this->moduleNameSmall;
    $this->data['modulePath']   	   = $this->modulePath;
		$this->data['feedPath']   	 	   = $this->feedPath;
		$this->data['moduleData_module'] = $this->moduleData_module;
	   
    }	

  public function index() {

    $this->document->setTitle($this->language->get('heading_title'));
   
    $this->load->model('setting/setting');




    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
      $this->model_setting_setting->editSetting($this->moduleTotal2, $this->request->post);
       
      $this->session->data['success'] = $this->language->get('text_success');

      if ($this->request->post[$this->moduleName]['Enabled'] == '1'){
        $this->model_setting_setting->editSetting('total_'.strtolower($this->moduleName), array('total_'.strtolower($this->moduleName).'_status' => 1));
      } else{
        $this->model_setting_setting->editSetting('total_'.strtolower($this->moduleName), array('total_'.strtolower($this->moduleName).'_status' => 0));
      }

      $this->response->redirect($this->totalLink);
    }

  	if (isset($this->error['warning'])) { 
  		$this->data['error_warning'] = $this->error['warning'];
  	} else {
  		$this->data['error_warning'] = '';
  	}

    $this->data['breadcrumbs'] = array();

    $this->data['breadcrumbs'][] = array(
      'text'      => $this->language->get('text_home'),
      'href'      => $this->url->link('common/dashboard', '&user_token=' . $this->session->data['user_token'], 'SSL'),
      'separator' => false
    );

    $this->data['breadcrumbs'][] = array(
      'text'      => $this->language->get('text_total'), //FIXXX
      'href'      => $this->totalLink,
      'separator' => ' :: '
    );

    $this->data['breadcrumbs'][] = array(
      'text'      => $this->language->get('heading_title'),
      'href'      => $this->url->link($this->totalPath2, '&user_token=' . $this->session->data['user_token'], 'SSL'),
      'separator' => ' :: '
    );

    $this->data['action'] = $this->url->link($this->totalPath2, '&user_token=' . $this->session->data['user_token'], 'SSL');

    $this->data['cancel'] = $this->totalLink;
    $sort_order =  $this->model_setting_setting->getSetting($this->moduleTotal2);

    $this->data['gift_teaser_sort_order'] = $sort_order['gift_teaser_sort_order'] ? $sort_order['gift_teaser_sort_order'] : 0;
    $enabled = $this->model_setting_setting->getSetting('total_'.strtolower($this->moduleName));
    
    $this->data['moduleData']['Enabled'] = $enabled['total_giftteaser_status'] ? $enabled['total_giftteaser_status'] : 0;
   
	 
  	$this->data['header']                 = $this->load->controller('common/header');
  	$this->data['column_left']            = $this->load->controller('common/column_left');
  	$this->data['footer']                 = $this->load->controller('common/footer');
    
    $this->response->setOutput($this->load->view($this->totalPath2, $this->data));
  }

  protected function validate() {
    if (!$this->user->hasPermission('modify', $this->totalPath2)) {
      $this->error['warning'] = $this->language->get('error_permission');
    }

	return !$this->error;
  }
}
