<?php
//ADMIN
class ControllerExtensionModuleGiftTeaser extends Controller {
		private $moduleName;
    private $modulePath;
	private $moduleModel;
	private $moduleVersion;
    private $extensionsLink;
    private $callModel;
    private $error = array();
    private $data = array();

    public function __construct($registry) {
        parent::__construct($registry);

        // Config Loader
        $this->config->load('isenselabs/giftteaser');

        // Module Constants
        $this->moduleName           = $this->config->get('giftteaser_name');
        $this->callModel            = $this->config->get('giftteaser_model');
        $this->modulePath           = $this->config->get('giftteaser_path');
	    $this->moduleVersion        = $this->config->get('giftteaser_version');
		$this->moduleData_module    = $this->config->get('giftteaser_module_data');
        $this->extensionsLink       = $this->url->link($this->config->get('giftteaser_link'), 'user_token=' . $this->session->data['user_token'].$this->config->get('giftteaser_link_params'), 'SSL');

        // Load Language
        $lang = $this->load->language($this->modulePath, $this->moduleName);
        $this->moduleLanguage = $lang[$this->moduleName];
        $this->data = $this->moduleLanguage->all();

        // Load Model
        $this->load->model($this->modulePath);

        // Model Instance
        $this->moduleModel          = $this->{$this->callModel};

        // Global Variables
        $this->data['moduleName']  		 = $this->moduleName;
        $this->data['modulePath']   	 = $this->modulePath;
		$this->data['feedPath']   	 	 = $this->feedPath;
		$this->data['moduleData_module'] = $this->moduleData_module;
		$this->data['moduleModel'] 		 = $this->moduleModel;

        $this->data['limit']        = 15;
    }


	public function install() {
		$this->load->model('setting/setting');
		$this->moduleModel->install();
	}

	public function uninstall() {
		$this->load->model('setting/setting');
		$this->load->model('setting/store');
		$this->model_setting_setting->deleteSetting($this->moduleName, 0);
		$stores=$this->model_setting_store->getStores();
		foreach ($stores as $store) {
			$this->model_setting_setting->deleteSetting($this->moduleName, $store['store_id']);
		}
		$this->moduleModel->uninstall();
	}

	public function index() {
		$this->load->model('setting/store');
		$this->load->model('localisation/language');
		$this->load->model('design/layout');
		$this->load->model('setting/setting');

		$catalogURL = $this->getCatalogURL();
		$this->document->addScript('view/javascript/'.$this->moduleName.'/timepicker.js');
		$this->document->addScript('view/javascript/'.$this->moduleName.'/bootbox.js');
		$this->document->addScript('view/javascript/'.$this->moduleName.'/modal.js');
		$this->document->addScript('view/javascript/'.$this->moduleName.'/modal-manager.js');
		$this->document->addStyle('view/stylesheet/'.$this->moduleName.'/modal.css');
		$this->document->addStyle('view/stylesheet/'.$this->moduleName.'/timepicker.css');
		$this->document->addStyle('view/javascript/'.$this->moduleName.'/colorpicker/css/colorpicker.css');
		$this->document->addScript('view/javascript/'.$this->moduleName.'/colorpicker/js/colorpicker.js');
		$this->document->addScript('view/javascript/'.$this->moduleName.'/main.js');
		$this->document->addStyle('view/stylesheet/'.$this->moduleName.'/giftTeaser.css');
		$this->document->setTitle($this->data['heading_title']);

		if(!isset($this->request->get['store_id'])) {
			$this->request->get['store_id'] = 0;
		}

		$store = $this->getCurrentStore($this->request->get['store_id']);
		 if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
	            if (!$this->user->hasPermission('modify', $this->modulePath)) {
	                $this->response->redirect($this->extensionsLink);
	            }

	            if (!empty($_POST['OaXRyb1BhY2sgLSBDb21'])) {
	                $this->request->post[$this->moduleName]['LicensedOn'] = $_POST['OaXRyb1BhY2sgLSBDb21'];
	            }

	            if (!empty($_POST['cHRpbWl6YXRpb24ef4fe'])) {
	                $this->request->post[$this->moduleName]['License'] = json_decode(base64_decode($_POST['cHRpbWl6YXRpb24ef4fe']), true);
	            }

	       	 	$this->load->model('setting/setting');

	            $this->model_setting_setting->editSetting($this->moduleName, array($this->moduleName => $this->request->post[$this->moduleName]),$this->request->post['store_id']);


	            if ($this->request->post[$this->moduleName]['Enabled'] == 'yes'){
	                $this->moduleModel->setupEventHandlers();
	                $this->model_setting_setting->editSetting('module_'.strtolower($this->moduleName), array('module_'.strtolower($this->moduleName).'_status' => 1));
					$this->model_setting_setting->editSetting(strtolower($this->moduleName).'_status', array(strtolower($this->moduleName).'_status' => 1));
	            } else{
	               $this->model_setting_setting->editSetting('module_'.strtolower($this->moduleName), array('module_'.strtolower($this->moduleName).'_status' => 0));
				   $this->model_setting_setting->editSetting(strtolower($this->moduleName).'_status', array(strtolower($this->moduleName).'_status' => 0));
	            }

	            $this->session->data['success'] = $this->moduleLanguage->get('text_success');

	            $this->response->redirect($this->url->link($this->modulePath, 'store_id='.$this->request->post['store_id'] . '&user_token=' . $this->session->data['user_token'], 'SSL'));
	        }

		$this->data['error_code'] = '';

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		$this->data['breadcrumbs']   = array();
		$this->data['breadcrumbs'][] = array(
			'text' => $this->registry->get('language')->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL'),
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->data['text_extensions'],
			'href' => $this->extensionsLink,
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->data['heading_title'],
			'href' => $this->url->link($this->modulePath, 'user_token=' . $this->session->data['user_token'], 'SSL'),
		);

		$this->data['heading_title'] = $this->data['heading_title'].' '.$this->moduleVersion;

		$this->data['stores']        = array_merge(array(0 => array('store_id' => '0', 'name' => $this->config->get('config_name') . ' ' . $this->registry->get('language')->get('text_default'), 'url' => HTTP_SERVER, 'ssl' => HTTPS_SERVER)), $this->model_setting_store->getStores());
		$this->data['error_warning'] = '';
		$this->data['languages']     = $this->model_localisation_language->getLanguages();
		$this->data['store']         = $store;
		$this->data['user_token']         = $this->session->data['user_token'];
		$this->data['action']        = $this->url->link($this->modulePath, 'user_token=' . $this->session->data['user_token'], 'SSL');
		$this->data['cancel']        = $this->extensionsLink;
		$this->data['language']      = $this->config->get('config_language');
		$this->data['moduleSettings']   = $this->model_setting_setting->getSetting($this->moduleName, $store['store_id']);
        $this->data['moduleData']       = (isset($this->data['moduleSettings'][$this->moduleName])) ? $this->data['moduleSettings'][$this->moduleName] : array();
		;
		foreach ($this->data['languages'] as $key => $value) {
			$this->data['languages'][$key]['flag_url'] = 'language/'.$this->data['languages'][$key]['code'].'/'.$this->data['languages'][$key]['code'].'.png"';
		}

		$this->data['catalog_url'] = $catalogURL;


		if ($this->config->get('giftteaser_status')) {
			$this->data['giftteaser_status'] = $this->config->get('giftteaser_status');
		} else {
			$this->data['giftteaser_status'] = '0';
		}

		$this->data['header']      = $this->load->controller('common/header');
		$this->data['column_left'] = $this->load->controller('common/column_left');
		$this->data['footer']      = $this->load->controller('common/footer');

		if (empty($this->data['moduleData']['LicensedOn'])) {
            $hostname = (!empty($_SERVER['HTTP_HOST'])) ? $_SERVER['HTTP_HOST'] : '' ;
            $this->data['hostname'] = (strstr($hostname, 'http://') === false) ? 'http://' . $hostname : $hostname;
            $this->data['domHostname']  = base64_encode($this->data['hostname']);
            $this->data['b64'] = base64_decode('ICAgIDxkaXYgY2xhc3M9ImFsZXJ0IGFsZXJ0LWRhbmdlciBmYWRlIGluIj4NCiAgICAgICAgPGJ1dHRvbiB0eXBlPSJidXR0b24iIGNsYXNzPSJjbG9zZSIgZGF0YS1kaXNtaXNzPSJhbGVydCIgYXJpYS1oaWRkZW49InRydWUiPsOXPC9idXR0b24+DQogICAgICAgIDxoND5XYXJuaW5nISBVbmxpY2Vuc2VkIHZlcnNpb24gb2YgdGhlIG1vZHVsZSE8L2g0Pg0KICAgICAgICA8cD5Zb3UgYXJlIHJ1bm5pbmcgYW4gdW5saWNlbnNlZCB2ZXJzaW9uIG9mIHRoaXMgbW9kdWxlISBZb3UgbmVlZCB0byBlbnRlciB5b3VyIGxpY2Vuc2UgY29kZSB0byBlbnN1cmUgcHJvcGVyIGZ1bmN0aW9uaW5nLCBhY2Nlc3MgdG8gc3VwcG9ydCBhbmQgdXBkYXRlcy48L3A+PGRpdiBzdHlsZT0iaGVpZ2h0OjVweDsiPjwvZGl2Pg0KICAgICAgICA8YSBjbGFzcz0iYnRuIGJ0bi1kYW5nZXIiIGhyZWY9ImphdmFzY3JpcHQ6dm9pZCgwKSIgb25jbGljaz0iJCgnYVtocmVmPSNpc2Vuc2Vfc3VwcG9ydF0nKS50cmlnZ2VyKCdjbGljaycpIj5FbnRlciB5b3VyIGxpY2Vuc2UgY29kZTwvYT4NCiAgICA8L2Rpdj4=');
        } else {
            $this->data['cHRpbWl6YXRpb24ef4fe'] = base64_encode(json_encode($this->data['moduleData']['License']));
            $this->data['dateExpires'] = date("F j, Y", strtotime($this->data['moduleData']['License']['licenseExpireDate']));
        }

        $this->data['supportTicketURL'] = 'https://isenselabs.com/tickets/open/' . base64_encode('Support Request').'/'.base64_encode('386').'/'. base64_encode($_SERVER['SERVER_NAME']);
		$this->data['tab_widget'] = $this->load->view($this->modulePath.'/tab_widget', $this->data);
        $this->data['tab_settings'] = $this->load->view($this->modulePath.'/tab_settings', $this->data);
        $this->data['tab_gifts'] = $this->load->view($this->modulePath.'/tab_gifts', $this->data);
        $this->data['tab_support'] = $this->load->view($this->modulePath.'/tab_support', $this->data);

		$this->response->setOutput($this->load->view($this->modulePath, $this->data));
	}

	// AJAX methods
	public function autocompleteProduct() {
		if (!isset($this->request->post['filter_name']) || !isset($this->request->post['store_id']) ) {
			$this->response->setOutput('[]');
			return;
		}

		$results = $this->moduleModel->searchProducts(
			$this->request->post['filter_name'],
			isset($this->request->post['store_id']) ? $this->request->post['store_id'] : 0,
			isset($this->request->get['limit']) ? $this->request->get['limit'] : $this->data['limit']
		);

		foreach ($results as &$result) {
			$result['name'] = strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'));
		}

		$this->response->setOutput(json_encode($results));
	}

	public function autocompleteCategory() {
		if (!isset($this->request->post['filter_name']) || !isset($this->request->post['store_id'])) {
			$this->response->setOutput('[]');
			return;
		}

		$results = $this->moduleModel->searchCategories(
			$this->request->post['filter_name'],
			$this->request->post['store_id'],
			$this->data['limit']
		);

		foreach ($results as &$result) {
			$result['name'] = strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'));
		}

		$this->response->setOutput(json_encode($results));
	}

	public function removeGift() {
		if ($this->user->hasPermission('modify', $this->modulePath)) {
			$this->moduleModel->removeGift($this->request->post['gift_id']);
		}
	}

	public function giftList() {
		$this->load->model('tool/image');

		$this->data['currencyRight'] = $this->currency->getSymbolRight($this->config->get('config_currency'));
		$this->data['currencyLeft'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));


		$sort = 'start_date';
		$order = 'ASC';
		$page = 1;

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		}

		if (isset($this->request->get['page']) && $this->request->get['page'] != 0) {
			$page = $this->request->get['page'];
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data   = array(
			'sort' => $sort,
			'order' => $order,
            'start' => ($page - 1) * $this->data['limit'],//$this->config->get('config_admin_limit'),
            'limit' => $this->data['limit'],//$this->config->get('config_admin_limit'),
            'store_id' => $this->request->get['store_id']
        );

		$gifts = $this->moduleModel->getGifts($data);

		$url = '';
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		$this->data['name']           = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url;
		$this->data['quantity']       = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=p.quantity' . $url;
		$this->data['start_date']     = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=gt.start_date' . $url;
		$this->data['end_date']       = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=gt.end_date' . $url;
		$this->data['sort_order']     = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=gt.sort_order' . $url;
		$this->data['condition_type'] = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'] . '&user_token=' . $this->session->data['user_token'] . '&sort=gt.condition_type' . $url;

		$url = '';
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		foreach ($gifts as $key => $gift) {
			$gifts[$key]['image'] = $this->model_tool_image->resize($gift['image'], 100, 100);
		}

		$pagination               = new Pagination();
		$pagination->total        = $this->moduleModel->getTotalGifts($this->request->get['store_id']);
		$pagination->page         = $page;
		$pagination->limit        = $this->data['limit'];
		$pagination->text         = $this->language->get('text_pagination');
		$pagination->url          = 'index.php?route='.$this->modulePath.'/giftList&store_id='.$this->request->get['store_id'].'&user_token=' . $this->session->data['user_token'] . $url . '&page={page}';
		$this->data['pagination'] = $pagination->render();
		$this->data['sort']       = $sort;
		$this->data['order']      = $order;
		$this->data['gifts']      = $gifts;

		$this->response->setOutput($this->load->view($this->modulePath.'/giftList', $this->data));
	}

	public function giftForm() {
		$this->load->model('tool/image');
		$this->load->model('localisation/language');

		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
			if (!$this->user->hasPermission('modify', $this->modulePath)) {
				$this->response->redirect($this->extensionsLink);
			}
			$this->moduleModel->saveGift($this->request->post);
		}

		$this->data['languages'] = $this->model_localisation_language->getLanguages();

		//2.2.0.0 language flag image fix
		foreach ($this->data['languages'] as $key => $value) {
			if(version_compare(VERSION, '2.2.0.0', "<")) {
				$this->data['languages'][$key]['flag_url'] = 'view/image/flags/'.$this->data['languageVariables'][$key]['image'];
			} else {
				$this->data['languages'][$key]['flag_url'] = 'language/'.$this->data['languages'][$key]['code'].'/'.$this->data['languages'][$key]['code'].'.png"';
			}
		}

		$this->load->model('customer/customer_group');
		$this->data['customerGroups'] = $this->model_customer_customer_group->getCustomerGroups();

		if(isset($this->request->get['gift_id'])){
			$this->data['gift_id'] = $this->request->get['gift_id'];
			$this->data['item_id'] = $this->request->get['item_id'];
			$item = $this->moduleModel->getProductsInIDArray(array($this->request->get['item_id']));
			$item = $item[0];
			$this->data['item_name'] = $item['name'];
			$this->data['image'] = $this->model_tool_image->resize($item['image'], 50, 50);
			$this->data['gift'] =$this->moduleModel->getGift($this->request->get['gift_id']);

			if (isset($this->data['gift']['description'])) {
				$this->data['description'] = unserialize(base64_decode($this->data['gift']['description']));
			}

			$properties = isset($this->data['gift']['condition_properties'])?unserialize($this->data['gift']['condition_properties']):array();

			$this->data['select_total_subtotal'] = !empty($properties['select_total'])?$properties['select_total']:'';
			$this->data['total'] = !empty($properties['total'])?$properties['total']:'';
			$this->data['total_max'] = !empty($properties['total_max'])?$properties['total_max']:'';
			$this->data['some_product_quantity'] = !empty($properties['some_product_quantity'])?$properties['some_product_quantity']:'1';
			$this->data['certain_product_quantity'] = !empty($properties['certain_product_quantity'])?$properties['certain_product_quantity']:'1';
			$this->data['certain'] = !empty($properties['certain'])?$this->moduleModel->getProductsInIDArray($properties['certain']):array();
			$this->data['some'] = !empty($properties['some'])?$this->moduleModel->getProductsInIDArray($properties['some']):array();
			$this->data['categories'] = !empty($properties['categories'])?$this->moduleModel->getCategoriesByID($properties['categories']):array();
			$this->data['reward_points_min'] = !empty($properties['reward_points_min'])?$properties['reward_points_min'] : '';
			$this->data['reward_points_max'] = !empty($properties['reward_points_max'])?$properties['reward_points_max'] : '';
			$this->data['reward_points_price'] = !empty($properties['reward_points_price'])?$properties['reward_points_price'] : '';
			$this->data['customer_group'] = !empty($properties['customer_group'])?$properties['customer_group']:array();
			$this->data['manufacturers'] = !empty($properties['manufacturer'])?$this->moduleModel->getManufacturersByID($properties['manufacturer']):array();
		} else {
			$this->data['gift_id'] = '-1';
			$this->data['gift'] = array();
		}

		$this->response->setOutput($this->load->view($this->modulePath.'/giftForm', $this->data));
	}

	// Helpers
	private function getCatalogURL() {
		if (isset($_SERVER['HTTPS']) && (($_SERVER['HTTPS'] == 'on') || ($_SERVER['HTTPS'] == '1'))) {
			$storeURL = HTTPS_CATALOG;
		} else {
			$storeURL = HTTP_CATALOG;
		}
		return $storeURL;
	}

	private function getCurrentStore($store_id) {
		$this->load->model('setting/store');

		if($store_id && $store_id != 0) {
			$store = $this->model_setting_store->getStore($store_id);
		} else {
			$store['store_id'] = 0;
			$store['name'] = $this->config->get('config_name');
			$store['url'] = $this->getCatalogURL();
		}
		return $store;
	}
}

?>
