<?php

class ControllerExtensionDashboardService extends Controller {
    private $error = [];

    public function index() {
        $this->load->language('extension/dashboard/service');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('dashboard_service', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
        );
        
        $data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/dashboard/service', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/dashboard/service', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

		if (isset($this->request->post['dashboard_service_width'])) {
			$data['dashboard_service_width'] = $this->request->post['dashboard_service_width'];
		} else {
			$data['dashboard_service_width'] = $this->config->get('dashboard_service_width');
		}

        $data['columns'] = array();
		
		for ($i = 3; $i <= 12; $i++) {
			$data['columns'][] = $i;
		}
				
		if (isset($this->request->post['dashboard_service_status'])) {
			$data['dashboard_service_status'] = $this->request->post['dashboard_service_status'];
		} else {
			$data['dashboard_service_status'] = $this->config->get('dashboard_service_status');
		}

		if (isset($this->request->post['dashboard_service_sort_order'])) {
			$data['dashboard_service_sort_order'] = $this->request->post['dashboard_service_sort_order'];
		} else {
			$data['dashboard_service_sort_order'] = $this->config->get('dashboard_service_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/dashboard/service_form', $data));
    }

    protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/dashboard/service')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
    }

    public function dashboard() {
        $this->load->language('extension/dashboard/service');
        $this->load->model('service/service_form');

		$data['user_token'] = $this->session->data['user_token'];

		// Last 5 Orders
		$data['orders'] = array();		

		$filter_data = array(
		    'filter_start_date'     => date('Y-m-d'),
			'filter_end_date' 	    => date('Y-m-d',strtotime(date('Y-m-d') . "-5 days")),   
			'filter_service_name'	=> '', 
			'sort'                  => 'a.invoice_prefix',
			'order'                 => 'DESC',
			'filter_status'         => 1,
			'start'                 => 0,
			'limit'                 => 5
        );
        
        $service_total = $this->model_service_service_form->totalServiceForm($filter_data);
	
        $results = $this->model_service_service_form->getServiceFormList($filter_data);
	
		foreach ($results as $result) {
			$data['orders'][] = array(
				'invoice_prefix' => $result['invoice_prefix'],
				'customer'       => $result['name'],
				'status'         => $result['status'],
				'date_added'     => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'customer_ic'    => $result['customer_ic'],
				'edit'           => $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $result['service_form_id'], true),
			);
		}	

		return $this->load->view('extension/dashboard/service_info', $data);
    }
}
?>