<?php

class ControllerExtensionDashboardAppointment extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('extension/dashboard/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('dashboard_appointment', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/dashboard/appointment', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/dashboard/appointment', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=dashboard', true);

        if (isset($this->request->post['dashboard_appointment_width'])) {
            $data['dashboard_appointment_width'] = $this->request->post['dashboard_appointment_width'];
        } else {
            $data['dashboard_appointment_width'] = $this->config->get('dashboard_appointment_width');
        }

        $data['columns'] = array();

        for ($i = 3; $i <= 12; $i++) {
            $data['columns'][] = $i;
        }

        if (isset($this->request->post['dashboard_appointment_status'])) {
            $data['dashboard_appointment_status'] = $this->request->post['dashboard_appointment_status'];
        } else {
            $data['dashboard_appointment_status'] = $this->config->get('dashboard_appointment_status');
        }

        if (isset($this->request->post['dashboard_appointment_sort_order'])) {
            $data['dashboard_appointment_sort_order'] = $this->request->post['dashboard_appointment_sort_order'];
        } else {
            $data['dashboard_appointment_sort_order'] = $this->config->get('dashboard_appointment_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/dashboard/appointment_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/dashboard/appointment')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function dashboard() {
        $this->load->language('extension/dashboard/appointment');
        $this->load->model('appointment/appointment');

        $data['user_token'] = $this->session->data['user_token'];

        // Last 5 Orders
        $data['orders'] = array();

        $filter_data = array(
            'filter_date_from' => date('Y-m-d'),
            'filter_date_to' => date('Y-m-d', strtotime(date('Y-m-d') . "+5 days")),
            'sort' => 'a.appointment_date',
            'order' => 'ASC',
            'filter_status' => 1,
            'start' => 0,
            'limit' => 5,
            'page' => 1
        );

        $appointment_total = 0;

        $appointment_data = $this->get_appointments($filter_data);

        $results = $appointment_data['appointments'];
        $appointment_total = $appointment_data['num_of_appointments'];

        foreach ($results as $result) {
            $customer_ic = ($result['customer_id'] > 0) ? $result['customer_ic'] : '';

            $edit_link = $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'], true);
            $view_link = $this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'], true);
            $select_link = $this->url->link('appointment/appointment/assign', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $result['appointment_id'], true);

            $data['orders'][] = array(
                'date' => $result['appointment_date'],
                'time' => $result['appointment_time'],
                'customer_id' => $result['customer_id'],
                'customer' => $result['customer_name'],
                'doctor' => $result['doctor_name'],
                'status' => $result['status'],
                'from_etcm' => $result['from_etcm'],
                'customer_ic' => $customer_ic,
                'edit' => $edit_link,
                'view' => $view_link,
                'select' => $select_link
            );
        }

        return $this->load->view('extension/dashboard/appointment_info', $data);
    }

    private function get_appointments($data) {
        $appointments = [];

        // default appointments
        $default_results = $this->model_appointment_appointment->getDashboardAppointments($data);

        // etcm appointments
        $etcm_results = $this->model_appointment_appointment->getDashboardEtcmAppointments($data);

        $merged_appointments = array_merge($default_results, $etcm_results);

        $appointment_date = array_column($merged_appointments, 'appointment_date');
        $appointment_date = array_map('strtotime', $appointment_date);

        $appointment_time = array_column($merged_appointments, 'appointment_time');
        $appointment_time = array_map('strtotime', $appointment_time);

        array_multisort($merged_appointments, SORT_NUMERIC, $appointment_date, SORT_ASC, $appointment_time, SORT_ASC);

        $limit = $data['limit'];
        $show = ($data['page'] * $limit) - $limit;

        $sliced_appointments = array_slice($merged_appointments, $show, $limit);

        $appointments = array(
            'appointments' => $sliced_appointments,
            'num_of_appointments' => count($merged_appointments)
        );

        return $appointments;
    }

}

?>